#ifndef QRK_CONNECTION_H
#define QRK_CONNECTION_H

/*!
  \file
  \brief ʐMC^[tF[X

  \author Satofumi KAMIMURA

  $Id: Connection.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include <cstddef>


namespace qrk
{
    enum {
        ReceiveTimeout = -1,
        ErrorLastIndex = -2,
    };


    //! ʐMC^[tF[X
    class Connection
    {
    public:
        virtual ~Connection(void) {}


        /*!
          \brief ԂԂ

          \return Ԃ
        */
        virtual const char* what(void) const = 0;


        /*!
          \brief foCXւ̐ڑ

          \param[in] device ڑfoCX
          \param[in] baudrate ڑ{[[g

          \retval true 
          \retval false s
        */
        virtual bool connect(const char* device, long baudrate) = 0;


        /*!
          \brief ؒf
        */
        virtual void disconnect(void) = 0;


        /*!
          \brief {[[g̕ύX

          \param[in] baudrate {[[g

          \retval 0 
          \retval < 0 G[
        */
        virtual bool setBaudrate(long baudrate) = 0;


        /*!
          \brief {[[gԂ

          \retval {[[g

          \attention SerialDevice ł̂ݗL
        */
        virtual long baudrate(void) const = 0;


        /*!
          \brief ڑԂԂ

          \retval true ڑ
          \retval false ؒf
        */
        virtual bool isConnected(void) const = 0;


        /*!
          \brief M

          \param[in] data Mf[^
          \param[in] count MoCg

          \return MoCg
        */
        virtual int send(const char* data, size_t count) = 0;


        /*!
          \brief M

          \param[out] data Mpobt@
          \param[in] count Mobt@̍őTCY
          \param[in] timeout ^CAEg [msec]
        */
        virtual int receive(char* data, size_t count, int timeout) = 0;


        /*!
          \brief Mς݃f[^̃oCgԂ

          \return Mς݃f[^̃oCg
        */
        virtual size_t size(void) const = 0;


        /*!
          \brief obt@̓eIɏo͂
        */
        virtual void flush(void) = 0;


        /*!
          \brief Mf[^̃NA

          Mobt@AMς݃f[^NA
        */
        virtual void clear(void) = 0;


        /*!
          \brief P߂

          \param[in] ch ߂
        */
        virtual void ungetc(const char ch) = 0;
    };
}

#endif /* !QRK_CONNECTION_H */
