/***************************************************************************
                                   Options.h
                              -------------------
 
     Begin        : Mon May 12 2008 12:13 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the options window
 
****************************************************************************/

#ifndef INCLUDE_OPTIONS_H
#define INCLUDE_OPTIONS_H

#include "env.h"

#include <QDialog>
#include <QtGui>
#include <QSettings>
#ifdef ULTRACOPIER_MODE_WINDOWS
#include <windows.h>
#endif

#include "ui_options.h"

/** \brief The options dialog

This dialog box provide a lot of options
*/
class optionsDialog : public QDialog, public Ui::Options
{
	Q_OBJECT
public:
	optionsDialog();
signals:
	void OrderUpdateStyle();
	void OptionsUpdated();
private slots:
	//save the settings
	void apply();
	//ok action, save the settings and quit
	void ok();
	//get speed
	void abstractLayerGetSpeed();
	//update the speed type
	void abstractLayerUpdateSpeedType();
	//update the lang
	void updateLangBool();
public slots:
	//update the style
	void UpdateStyle();
private:
	//set speed
	void abstractLayerSetSpeed(int speed);
	//update the slider speed text
	void UpdateSliderSpeedText();
	int	MaxSpeedValueInt;///< For the max speed, 0 is for unlimited
	int	lastLangIndex;///< Store the previous language for show the restart message
	bool	langHaveChanged;
};

#endif
