/***************************************************************************
			      Mwindow.cpp
			  -------------------

     Begin       : Sat Oct 23 2007 10:00 alpha_one_x86
     Project     : Ultracopier
     Email       : ultracopier@first-world.info
     Note	: See README for copyright and developer
     Target      : Define the contructor and methode of the main window

****************************************************************************/

/// \todo start, stop, pause the copy
/// \todo copy error management

#include "env.h"
#include "Mwindow.h"

/** \brief For create the copy or moving window
It link action, create menu, connect signal and slot. Initialise the widget and the default settings.
\see ~Main_window()

*/
Main_window::Main_window()
{
	DEBUGCONSOLE(90,"Main_window::Main_window","start");
	
	//setup the interface
	setupUi(this);
	this->setWindowFlags(((this->windowFlags()|Qt::WindowMinMaxButtonsHint)&(0xffffffff^Qt::WindowContextHelpButtonHint)));
	setAcceptDrops(true);
	tabWidget->setCurrentIndex(0);
	CopyList->setColumnWidth(1,60);
	treeWidgetListError->setColumnWidth(1,60);
	tabWidget->hide();
	progressBar_file->hide();
	current_file->hide();
	skipButton->hide();
	currentSpeed->hide();
	progressBar_all->setTextVisible(false);
	this->setMaximumHeight(50);
	this->adjustSize();
	closeTheSearchBox();
	TimerForSearch	= new QTimer(this);
	TimerForSearch->setInterval(500);
	TimerForSearch->setSingleShot(true);
	searchShortcut	= new QShortcut(QKeySequence("Ctrl+F"),this);
	searchShortcut2 = new QShortcut(QKeySequence("F3"),this);

	qRegisterMetaType<QDir>("QDir");
	qRegisterMetaType<QFileInfo>("QFileInfo");
	
	//connect the button for do the action
	connect(moreButton,		SIGNAL(toggled(bool)),			this,	SLOT(resizeMore(bool)));
	connect(del,			SIGNAL(clicked(bool)),			this,	SLOT(Playlist_management_del()));
	connect(pauseButton,		SIGNAL(clicked(bool)),			this,	SLOT(PauseButton()));
	connect(cancelButton,		SIGNAL(clicked(bool)),			this,	SLOT(cancel_copy_window()));
	connect(skipButton,		SIGNAL(clicked()),			this,	SLOT(SkipButton()));
	connect(SetDefaultOptions,	SIGNAL(clicked()),			this,	SLOT(setDefaultOptions()));
	
	connect(putOnTop,		SIGNAL(clicked()),			this,	SLOT(Playlist_management_putSelectedFileOnTop()));
	connect(pushUp,			SIGNAL(clicked()),			this,	SLOT(Playlist_management_putSelectedFileUp()));
	connect(pushDown,		SIGNAL(clicked()),			this,	SLOT(Playlist_management_putSelectedFileDown()));
	connect(putOnBottom,		SIGNAL(clicked()),			this,	SLOT(Playlist_management_putSelectedFileOnBottom()));
	
	//connect for speed
	connect(limitSpeed,		SIGNAL(valueChanged(int)),		this,	SLOT(abstractLayerGetSpeed()));
	connect(checkBox_limitSpeed,	SIGNAL(stateChanged(int)),		this,	SLOT(abstractLayerGetSpeed()));
	connect(SliderSpeed,		SIGNAL(valueChanged(int)),		this,	SLOT(abstractLayerGetSpeed()));
	connect(spinBoxBlock,		SIGNAL(valueChanged(int)),		this,	SLOT(updateBlockSize(int)));
	connect(comboBox_TypeSpeedMax,	SIGNAL(currentIndexChanged(int)),	this,	SLOT(abstractLayerUpdateSpeedType()));
	
	//connect other
	connect(comboBox_Priority,	SIGNAL(currentIndexChanged(int)),	this,	SLOT(changePriority()));
	connect(TimerForSearch,		SIGNAL(timeout()),			this,	SLOT(hilightTheSearch()));
	connect(searchShortcut,		SIGNAL(activated()),			this,	SLOT(searchBoxShortcut()));
	connect(searchShortcut2,	SIGNAL(activated()),			this,	SLOT(on_pushButtonSearchNext_clicked()));
	connect(pushButtonCloseSearch,	SIGNAL(clicked()),			this,	SLOT(closeTheSearchBox()));
	
	actionaddFile = new QAction(tr("Open f&ile(s)"), this);
	connect(actionaddFile,		SIGNAL(triggered()),			this,	SLOT(addFile()));
	actionaddFolder = new QAction(tr("Open f&older"), this);
	connect(actionaddFolder,	SIGNAL(triggered()),			this,	SLOT(addFolder()));
	
	menu = new QMenu("menu", this);
	menu->addAction(actionaddFile);
	menu->addAction(actionaddFolder);
	add->setPopupMode(QToolButton::InstantPopup);
	add->setMenu(menu);
	
	AddingFolderThread = new AddFolderThread(this);
	connect(AddingFolderThread,	SIGNAL(putToDirList(QDir)),		this,	SLOT(addEntryToDirList(QDir)));
	connect(AddingFolderThread,	SIGNAL(addToCopyList(QFileInfo,QFileInfo)), this,	SLOT(addToList(QFileInfo,QFileInfo)));
	connect(AddingFolderThread,	SIGNAL(FolderSourceAndDestAreSame(QString)), this,	SLOT(AddFolderDetectAreSame(QString)));
	connect(AddingFolderThread,	SIGNAL(started()),			this,	SLOT(updateProgressBarAllMode()));
	connect(AddingFolderThread,	SIGNAL(finished()),			this,	SLOT(ListingIsFinish()));
	connect(AddingFolderThread,	SIGNAL(finished()),			this,	SLOT(updateProgressBarAllMode()));
	connect(AddingFolderThread,	SIGNAL(ErrorInListing(QString,QString)),this,	SLOT(ErrorInListing(QString,QString)));
	
	//setup the copy thread
	CopyThread = new copyThread(this);
	connect(AddingFolderThread, SIGNAL(putToDirDestinationEmptyList(QDir)), CopyThread, SLOT(addEntryToEmptyDestinationDirList(QDir)));
	//error management here
	connect(CopyThread,		SIGNAL(errorOnFile(int,QString,QString,quint64)), this, SLOT(copyThreadError(int,QString,QString,quint64)));
	connect(CopyThread,		SIGNAL(fileIsSame(QString)),		this,	SLOT(copyThreadFileIsSame(QString)));
	connect(CopyThread,		SIGNAL(fileIsExists(QString,QString)),	this,	SLOT(copyThreadFileIsExists(QString,QString)));
	connect(CopyThread,		SIGNAL(started()),			this,	SLOT(updateTheCopyStat()));
	connect(CopyThread,		SIGNAL(started()),			this,	SLOT(updatePlayPauseSkipButton()));
	connect(CopyThread,		SIGNAL(started()),			this,	SLOT(updateProgressBarAllMode()));
	connect(CopyThread,		SIGNAL(finished()),			this,	SLOT(updateTheCopyStat()));
	connect(CopyThread,		SIGNAL(finished()),			this,	SLOT(updatePlayPauseSkipButton()));
	connect(CopyThread,		SIGNAL(finished()),			this,	SLOT(updateProgressBarAllMode()));
	connect(CopyThread,		SIGNAL(finished()),			this,	SLOT(copyThreadIsFinish()));
	connect(CopyThread,		SIGNAL(allThreadIsFinishNow()),		this,	SLOT(copyThreadOrWriteThread()));
	connect(CopyThread,		SIGNAL(isInPauseOrNot()),		this,	SLOT(updatePlayPauseSkipButton()));

	connect(checkBoxRightCopy,	SIGNAL(stateChanged(int)),		CopyThread,	SLOT(setRightCopy(int)));
	connect(checkBoxPreallocate,	SIGNAL(stateChanged(int)),		this,		SLOT(setPreallocateFileSize(int)));
	connect(checkBoxKeepDate,	SIGNAL(stateChanged(int)),		CopyThread,	SLOT(setKeepDate(int)));
	connect(checkWriteThread,	SIGNAL(stateChanged(int)),		CopyThread,	SLOT(setThreadWrite(int)));
	connect(spinBoxBlock,		SIGNAL(valueChanged(int)),		CopyThread,	SLOT(setBlockSize()));
	connect(comboBox_statusBar,	SIGNAL(currentIndexChanged(int)),	this,		SLOT(changeShowStatusBar()));
	
	TimerForCopyUpdate = new QTimer();
	TimerForCopyUpdate->setInterval(UPDATEINTERVAL);
	connect(TimerForCopyUpdate,	SIGNAL(timeout()), this, SLOT(updateTheCopyStat()));

	TimerForCopySpeedUpdate = new QTimer();
	TimerForCopySpeedUpdate->setInterval(UPDATEINTERVAL);
	connect(TimerForCopySpeedUpdate,SIGNAL(timeout()), this, SLOT(updateTheCopySpeed()));

	TimerForTimeRemainingUpdate = new QTimer();
	TimerForTimeRemainingUpdate->setInterval(1000);
	connect(CopyThread,		SIGNAL(started()),	TimerForTimeRemainingUpdate,	SLOT(start()));
	connect(CopyThread,		SIGNAL(finished()),	TimerForTimeRemainingUpdate,	SLOT(stop()));
	connect(CopyThread,		SIGNAL(finished()),	this,				SLOT(updateTheTimeRemaining()));
	connect(TimerForTimeRemainingUpdate, SIGNAL(timeout()), this,				SLOT(updateTheTimeRemaining()));

	//systray progression icon
	sysTrayIcon = new QSystemTrayIcon(this);
	
	//initialise the variable
	sizeTot			= 0;
	sizeCur			= 0;
	fileTot			= 0;
	MaxSpeedValueInt	= 0;
	aErrorHasOccurred	= false;
	movingMode		= false;
	autoIncrementId		= 1;
	MainDestination		= "";
	MainSource		= "";
	shouldBeClosed		= false;
	numberOfFilePutAtTheEnd	= 0;

	//start time
	showingDrop.start();
	addDirDropFrame.start();

	//Set range
	progressBar_file->setRange(0,32767);
	progressBar_all->setRange(0,32767);

	//load the default options
	setDefaultOptions();
	
	//After load options set if the right should be copied
	CopyThread->setPreallocateFileSize(checkBoxPreallocate->isChecked());
	CopyThread->setRightCopy(checkBoxRightCopy->isChecked());
	CopyThread->setKeepDate(checkBoxKeepDate->isChecked());
	CopyThread->setBlockSize(spinBoxBlock->value());
	CopyThread->setThreadWrite(checkWriteThread->isChecked());

	//loading the image
	#ifdef Q_OS_WIN32
	pixmapTop		= new QPixmap(loadImagePixmap("systray/top.png"));
	pixmapBottom		= new QPixmap(loadImagePixmap("systray/bottom.png"));
	#else
	pixmapTop		= new QPixmap(loadImagePixmap("systray/top_X11.png"));
	pixmapBottom		= new QPixmap(loadImagePixmap("systray/bottom_X11.png"));
	#endif

	connect(sysTrayIcon,		SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, SLOT(CatchAction(QSystemTrayIcon::ActivationReason)));
	connect(sysTrayIcon,		SIGNAL(messageClicked()), this, SLOT(RestoreTheWindow()));
	
	//initialise the menu
	actionPause = new QAction(tr("Pause"), this);
	actionPause->setEnabled(false);
	connect(actionPause,		SIGNAL(triggered()), this, SLOT(PauseButton()));
	actionRestore = new QAction(tr("Restore"), this);
	connect(actionRestore,		SIGNAL(triggered()), this, SLOT(RestoreTheWindow()));
	actionQuit = new QAction(tr("Quit"), this);
	connect(actionQuit,		SIGNAL(triggered()), this, SLOT(cancel_copy_window()));
	
	systrayMenu = new QMenu("menu", this);
	systrayMenu->addAction(actionaddFile);
	systrayMenu->addAction(actionaddFolder);
	systrayMenu->addAction(actionPause);
	systrayMenu->addAction(actionRestore);
	systrayMenu->addAction(actionQuit);
	sysTrayIcon->setContextMenu(systrayMenu);
	
	getOldProgression=-1;

	#if (DEBUG_ULTRACOPIER>0)
	connect(&DebugTrackThread,	SIGNAL(timeout()), this, SLOT(DebugCheckThread()));
	DebugTrackThread.setInterval(1000);
	hboxLayoutDebug = new QHBoxLayout();
	Debug_label_copyThread = new QLabel(this);
	Debug_label_copyThread->setText("Init...");
	Debug_label_copyThread->hide();
	Debug_label_writeThread = new QLabel(this);
	Debug_label_writeThread->setText("Init...");
	Debug_label_writeThread->hide();
	Debug_label_waitThread = new QLabel(this);
	Debug_label_waitThread->setText("Init...");
	Debug_label_waitThread->hide();
	Debug_label_waitThread->setStyleSheet("background-color: rgb(255, 255, 0);");
	hboxLayoutDebug->addWidget(Debug_label_copyThread);
	hboxLayoutDebug->addWidget(Debug_label_writeThread);
	hboxLayoutDebug->addWidget(Debug_label_waitThread);
	vboxLayout->addLayout(hboxLayoutDebug);
	#endif

	#ifdef Q_OS_WIN32
	SpecWindowsCurWindow=GetActiveWindow();
	#endif

	DEBUGCONSOLE(30,"Main_window::Main_window","stop");	
	//update the style
	this->UpdateStyle();
}

/// \brief The destructor
Main_window::~Main_window()
{
	#if (DEBUG_ULTRACOPIER>0)
	DebugTrackThread.stop();
	#endif
	DEBUGCONSOLE(30,"Main_window::~Main_window","disconnect copyThread");
	CopyThread->disconnect();
	DEBUGCONSOLE(30,"Main_window::~Main_window","start other delete");
	delete actionaddFile;
	delete actionaddFolder;
	delete menu;
	AddingFolderThread->deleteLater();
	delete AddingFolderThread;
	delete TimerForCopyUpdate;
	CopyThread->stopTheCopy();
	DEBUGCONSOLE(30,"Main_window::~Main_window","CopyThread->deleteLater()");
	CopyThread->deleteLater();
	delete sysTrayIcon;
	delete systrayMenu;
	delete actionPause;
	delete actionRestore;
	delete actionQuit;
}

#if (DEBUG_ULTRACOPIER>0)
void Main_window::DebugCheckThread()
{
	if(CopyThread->isRunning())
	{
		if(CopyThread->getCurrentStat()==copyThread::Running)
		{
			Debug_label_copyThread->setStyleSheet("background-color: rgb(255, 170, 0);");
			Debug_label_copyThread->setText("copyThread::Running");
		}
		else if(CopyThread->getCurrentStat()==copyThread::Paused)
		{
			Debug_label_copyThread->setStyleSheet("background-color: rgb(255, 255, 0);");
			Debug_label_copyThread->setText("copyThread::Paused");
		}
		//it's bug
		else if(CopyThread->getCurrentStat()==copyThread::Stopped)
		{
			Debug_label_copyThread->setStyleSheet("background-color: rgb(255, 0, 0);");
			Debug_label_copyThread->setText("copyThread::Stopped (error)");
		}
	}
	else
	{
		if(CopyThread->getCurrentStat()==copyThread::Running)
		{
			Debug_label_copyThread->setStyleSheet("background-color: rgb(255, 0, 0);");
			Debug_label_copyThread->setText("copyThread::Running (error)");
		}
		else if(CopyThread->getCurrentStat()==copyThread::Paused)
		{
			Debug_label_copyThread->setStyleSheet("background-color: rgb(255, 0, 0);");
			Debug_label_copyThread->setText("copyThread::Paused (error)");
		}
		//it's bug
		else if(CopyThread->getCurrentStat()==copyThread::Stopped)
		{
			Debug_label_copyThread->setStyleSheet("background-color: rgb(0, 170, 0);");
			Debug_label_copyThread->setText("copyThread::Stopped (ilde)");
		}
	}
	QStringList temp=CopyThread->DebugReturnCopyThreadStat();
	Debug_label_writeThread->setText(temp.at(0));
	Debug_label_writeThread->setStyleSheet(temp.at(1));
	Debug_label_waitThread->setText(CopyThread->WaitInWhat());
}
#endif

//when the copy thread is finish
void Main_window::copyThreadIsFinish()
{
	DEBUGCONSOLE(30,"Main_window::copyThreadIsFinish","start");
	if(comboBox_copyEnd->currentIndex()==2 || (!aErrorHasOccurred && comboBox_copyEnd->currentIndex()==0))
	{
		shouldBeClosed=true;
		emit copyFinish();
		#if (DEBUG_ULTRACOPIER>0)
		if(comboBox_copyEnd->currentIndex()==2)
			DEBUGCONSOLE(30,"Main_window::copyThreadIsFinish","comboBox_copyEnd->currentIndex()==2 (always close)");
		if(aErrorHasOccurred && comboBox_copyEnd->currentIndex()==0)
			DEBUGCONSOLE(30,"Main_window::copyThreadIsFinish","comboBox_copyEnd->currentIndex()==0 (close if no error, && no error found)");
		#endif
		hide();
	}
	else
	{
		updateTheCopyStat();
		emit copyFinish();
	}
	#if (DEBUG_ULTRACOPIER>0)
	DebugCheckThread();
	#endif
}

//close the search box
void Main_window::closeTheSearchBox()
{
	currentIndexSearch = -1;
	lineEditSearch->clear();
	lineEditSearch->hide();
	pushButtonSearchPrev->hide();
	pushButtonSearchNext->hide();
	pushButtonCloseSearch->hide();
	hilightTheSearch();
}

//search box shortcut
void Main_window::searchBoxShortcut()
{
	if(lineEditSearch->isHidden())
	{
		lineEditSearch->show();
		pushButtonSearchPrev->show();
		pushButtonSearchNext->show();
		pushButtonCloseSearch->show();
		lineEditSearch->setFocus(Qt::ShortcutFocusReason);
	}
	else
		closeTheSearchBox();
}

//hilight the search
void Main_window::hilightTheSearch()
{
	QFont *fontNormal=new QFont();
	QTreeWidgetItem * item=NULL;
	//get the ids to do actions
	int i=0;
	if(lineEditSearch->text().isEmpty())
	{
		while(i<CopyList->topLevelItemCount())
		{
			item=CopyList->topLevelItem(i);
			item->setBackgroundColor(0,QColor(255,255,255,0));
			item->setBackgroundColor(1,QColor(255,255,255,0));
			item->setBackgroundColor(2,QColor(255,255,255,0));
			item->setFont(0,*fontNormal);
			item->setFont(1,*fontNormal);
			item->setFont(2,*fontNormal);
			i++;
		}
		lineEditSearch->setStyleSheet("");
	}
	else
	{
		bool itemFound=false;
		while(i<CopyList->topLevelItemCount())
		{
			item=CopyList->topLevelItem(i);
			if(item->text(0).indexOf(lineEditSearch->text(),0,Qt::CaseInsensitive)!=-1 || item->text(2).indexOf(lineEditSearch->text(),0,Qt::CaseInsensitive)!=-1)
			{
				itemFound=true;
				item->setBackgroundColor(0,QColor(255,255,0,100));
				item->setBackgroundColor(1,QColor(255,255,0,100));
				item->setBackgroundColor(2,QColor(255,255,0,100));
			}
			else
			{
				item->setBackgroundColor(0,QColor(255,255,255,0));
				item->setBackgroundColor(1,QColor(255,255,255,0));
				item->setBackgroundColor(2,QColor(255,255,255,0));
			}
			item->setFont(0,*fontNormal);
			item->setFont(1,*fontNormal);
			item->setFont(2,*fontNormal);
			i++;
		}
		if(!itemFound)
			lineEditSearch->setStyleSheet("background-color: rgb(255, 150, 150);");
		else
			lineEditSearch->setStyleSheet("");
	}
	delete fontNormal;
}

void Main_window::on_pushButtonSearchPrev_clicked()
{
	if(!lineEditSearch->text().isEmpty() && CopyList->topLevelItemCount()>0)
	{
		hilightTheSearch();
		int searchStart;
		if(currentIndexSearch<0 || currentIndexSearch>=CopyList->topLevelItemCount())
			searchStart=CopyList->topLevelItemCount()-1;
		else
			searchStart=CopyList->topLevelItemCount()-currentIndexSearch-2;
		int count=0;
		QTreeWidgetItem *curs=NULL;
		while(count<CopyList->topLevelItemCount())
		{
			if(searchStart<0)
				searchStart+=CopyList->topLevelItemCount();
			if(CopyList->topLevelItem(searchStart)->text(0).indexOf(lineEditSearch->text(),0,Qt::CaseInsensitive)!=-1 || CopyList->topLevelItem(searchStart)->text(0).indexOf(lineEditSearch->text(),0,Qt::CaseInsensitive)!=-1)
			{
				curs=CopyList->topLevelItem(searchStart);
				break;
			}
			searchStart--;
			count++;
		}
		if(curs!=NULL)
		{
			currentIndexSearch=CopyList->topLevelItemCount()-1-CopyList->indexOfTopLevelItem(curs);
			lineEditSearch->setStyleSheet("");
			QFont *bold=new QFont();
			bold->setBold(true);
			curs->setFont(0,*bold);
			curs->setFont(1,*bold);
			curs->setFont(2,*bold);
			curs->setBackgroundColor(0,QColor(255,255,0,200));
			curs->setBackgroundColor(1,QColor(255,255,0,200));
			curs->setBackgroundColor(2,QColor(255,255,0,200));
			CopyList->scrollToItem(curs);
			delete bold;
		}
		else
			lineEditSearch->setStyleSheet("background-color: rgb(255, 150, 150);");
	}
}

void Main_window::on_pushButtonSearchNext_clicked()
{
	if(lineEditSearch->text().isEmpty())
	{
		if(lineEditSearch->isHidden())
			searchBoxShortcut();
	}
	else
	{
		if(CopyList->topLevelItemCount()>0)
		{
			hilightTheSearch();
			int searchStart;
			if(currentIndexSearch<0 || currentIndexSearch>=CopyList->topLevelItemCount())
				searchStart=0;
			else
				searchStart=CopyList->topLevelItemCount()-currentIndexSearch;
			int count=0;
			QTreeWidgetItem *curs=NULL;
			while(count<CopyList->topLevelItemCount())
			{
				if(searchStart>=CopyList->topLevelItemCount())
					searchStart-=CopyList->topLevelItemCount();
				if(CopyList->topLevelItem(searchStart)->text(0).indexOf(lineEditSearch->text(),0,Qt::CaseInsensitive)!=-1 || CopyList->topLevelItem(searchStart)->text(0).indexOf(lineEditSearch->text(),0,Qt::CaseInsensitive)!=-1)
				{
					curs=CopyList->topLevelItem(searchStart);
					break;
				}
				searchStart++;
				count++;
			}
			if(curs!=NULL)
			{
				currentIndexSearch=CopyList->topLevelItemCount()-1-CopyList->indexOfTopLevelItem(curs);
				lineEditSearch->setStyleSheet("");
				QFont *bold=new QFont();
				bold->setBold(true);
				curs->setFont(0,*bold);
				curs->setFont(1,*bold);
				curs->setFont(2,*bold);
				curs->setBackgroundColor(0,QColor(255,255,0,200));
				curs->setBackgroundColor(1,QColor(255,255,0,200));
				curs->setBackgroundColor(2,QColor(255,255,0,200));
				CopyList->scrollToItem(curs);
				delete bold;
			}
			else
				lineEditSearch->setStyleSheet("background-color: rgb(255, 150, 150);");
		}
	}
}

void Main_window::on_lineEditSearch_returnPressed()
{
	hilightTheSearch();
}

void Main_window::on_lineEditSearch_textChanged(QString text)
{
	if(text=="")
	{
		TimerForSearch->stop();
		hilightTheSearch();
	}
	else
		TimerForSearch->start();
}

//update the time remaning
void Main_window::updateTheTimeRemaining()
{
	QString tempString=CopyThread->remainingTime();
	if(tempString!="")
		labelTimeRemaining->setText(tempString);
}

/** \brief function for copy thread error
\param buttonActivated The button activated
\param file The file linked with the error
\param errorString The error string
\param id Id of the item linked with the error, can by null */
void Main_window::copyThreadError(const int buttonActivated,const QString& file,const QString& errorString,quint64 id)
{
	CopyThread->errorAction(errorManagement(buttonActivated,file,errorString));
	if(id==0)
		return;
	for (int j=0; j<theCopyItemExternal.size(); ++j) {
		if(theCopyItemExternal.at(j).id==id)
		{
			if(CopyList->indexOfTopLevelItem(theCopyItemExternal.at(j).theGraphicIndex)==-1)
			{
				//DEBUGCONSOLE(10,"Main_window::copyThreadError","Crash prevent, theCopyItemExternal.at("+QString::number(j)+").theGraphicIndex not found!");
				QTreeWidgetItem *item = new QTreeWidgetItem(QStringList() << file << "0" << "" << errorString);
				//only if item is not removed after copier
				//item->setIcon(0,loadImage("error.png"));
				treeWidgetListError->addTopLevelItem(item);
			}
			else
			{
				QTreeWidgetItem *item = new QTreeWidgetItem(QStringList() << theCopyItemExternal.at(j).theGraphicIndex->text(0) << theCopyItemExternal.at(j).theGraphicIndex->text(1) << theCopyItemExternal.at(j).theGraphicIndex->text(2) << errorString);
				//only if item is not removed after copier
				//item->setIcon(0,loadImage("error.png"));
				treeWidgetListError->addTopLevelItem(item);
			}
		}
	}
}

/** \brief function for write thread error
\param buttonActivated The button activated
\param file The file linked with the error
\param errorString The error string
\param id Id of the item linked with the error, can by null */
void Main_window::writeThreadError(const int buttonActivated,const QString& file,const QString& errorString,quint64 id)
{
	WriteThread *theSenderObject=qobject_cast<WriteThread *>(QObject::sender());
	theSenderObject->errorAction(errorManagement(buttonActivated,file,errorString));
	CopyThread->resumeCopy();
	for (int j=0; j<theCopyItemExternal.size(); ++j) {
		if(theCopyItemExternal.at(j).id==id)
		{
			if(CopyList->indexOfTopLevelItem(theCopyItemExternal.at(j).theGraphicIndex)==-1)
			{
				DEBUGCONSOLE(10,"Main_window::copyThreadError","Crash prevent, theCopyItemExternal.at("+QString::number(j)+").theGraphicIndex not found!");
			}
			else
			{
				QTreeWidgetItem *item = new QTreeWidgetItem(QStringList() << theCopyItemExternal.at(j).theGraphicIndex->text(0) << theCopyItemExternal.at(j).theGraphicIndex->text(1) << theCopyItemExternal.at(j).theGraphicIndex->text(2) << errorString);
				//only if item is not removed after copier
				//item->setIcon(0,loadImage("error.png"));
				treeWidgetListError->addTopLevelItem(item);
			}
		}
	}
}

//set destination only on internal
void Main_window::setInternalDestination(QString dir)
{
	DEBUGCONSOLE(90,"Main_window::setInternalDestination","dir: "+dir);
	LastDestination=dir;
	if(MainDestination=="")
		MainDestination=dir;
	else
	{
		if(MainDestination!="*")
		if(QDir(MainDestination)!=QDir(dir))
			MainDestination="*";
	}
}

//set source only on internal
void Main_window::setInternalSource(QString dir)
{
	DEBUGCONSOLE(90,"Main_window::setInternalSource","dir: "+dir);
	if(MainSource=="")
		MainSource=dir;
	else
	{
		if(MainSource!="*")
		if(QDir(MainSource)!=QDir(dir))
			MainSource="*";
	}
}

//function for fileIsSame
void Main_window::copyThreadFileIsSame(const QString& file)
{
	CopyThread->fileExistsAction(GetActionFileExist(true,file));
}

//function for fileIsExists
void Main_window::copyThreadFileIsExists(const QString& source,const QString& destination)
{
	CopyThread->fileExistsAction(GetActionFileExist(false,QFileInfo(destination).absolutePath(),source,destination));
}

/** \brief Create progessive icon

Do QIcon with top and bottom image mixed and percent writed on it.
The icon it be search in the style path.
Do by mongaulois, remake by alpha_one_x86.
\param percent indique how many percent need be showed, sould be between 0 and 100
\param text The showed text if needed (optionnal)
\return QIcon of the final image
\note Can be used as it: dynaIcon(75,"...")
*/
QIcon Main_window::dynaIcon(int percent,QString text)
{
	#if (DEBUG_ULTRACOPIER>0)
	if(pixmapTop->isNull() || pixmapBottom->isNull())
		DEBUGCONSOLE(10,"Main_window::dynaIcon","Error loading the icons");
	#endif
	if(percent==-1)
		percent=getOldProgression;
	if(percent<0)
		percent=0;
	if(percent>100)
		percent=100;
	//pixmap avec un fond transparent
	#ifdef Q_OS_WIN32
	QPixmap resultImage(16,16);
	#else
	QPixmap resultImage(22,22);
	#endif
	resultImage.fill(Qt::transparent);
	{
		QPainter painter(&resultImage);
		
		//preprocessing the calcul
		float percent_1 = (100.-percent)/100.;
		float percent_2 =  percent/100.;
		
		//top image
		QRect target(0, 0, resultImage.width(), (int)(percent_1*resultImage.height()));
		QRect source(0, 0, pixmapTop->width(), (int)(percent_1*pixmapTop->height()));
		painter.drawPixmap(target, *pixmapTop, source);
		
		//bottom image
		QRect target2(0, (int)(percent_1*resultImage.height()), resultImage.width(), (int)(percent_2*resultImage.height()));
		QRect source2(0, (int)(percent_1*pixmapBottom->height()), pixmapBottom->width(), (int)(percent_2*pixmapBottom->height()));
		painter.drawPixmap(target2, *pixmapBottom, source2);
		
		if(text.isEmpty())
		{
			if(percent!=100)
				text=QString::number(percent);
			else
				text=" :)";
		}
		
		painter.setPen(QPen(Qt::black));
		#ifdef Q_OS_WIN32
		painter.drawText(2,14,text);
		#else
		painter.drawText(5,16,text);
		#endif
		painter.setPen(QPen(Qt::white));
		#ifdef Q_OS_WIN32
		painter.drawText(1,13,text);
		#else
		painter.drawText(4,15,text);
		#endif
	}
	return QIcon(resultImage);
}

/// \brief Change show status
void Main_window::changeShowStatusBar()
{
	DEBUGCONSOLE(30,"Main_window::changeShowStatusBar","start");
	if(comboBox_statusBar->currentIndex()==0)
		setVisibleStatus(true);
	if(comboBox_statusBar->currentIndex()==1)
		setVisibleStatus(true);
	if(comboBox_statusBar->currentIndex()==2)
		setVisibleStatus(false);
}

/** \brief Set visibility status of the copy
\param show If true the item is showed
*/
void Main_window::setVisibleStatus(bool show)
{
	#if (DEBUG_ULTRACOPIER>0)
	if(show)
		DEBUGCONSOLE(30,"Main_window::setVisibleStatus","show: true");
	else
		DEBUGCONSOLE(30,"Main_window::setVisibleStatus","show: false");
	#endif
	showTheStatus=show;
}

/** \brief Set the status of the copy

Show what it do, and if is in copy or moving mode
\see movingMode and copyMode
*/
void Main_window::setStatusOfCopy()
{
	DEBUGCONSOLE(90,"Main_window::setStatusOfCopy","start");
	QString text="";
	//for the window title
	if(showTheStatus)
	{
		if(CopyThread->getCurrentStat()!=copyThread::Stopped)
			text+=" - "+tr("Coping...");
		else
			if(CopyThread->getCurrentStat()==copyThread::Paused)
				text+=" - "+tr("Copy paused");
		if(AddingFolderThread->isRunning())
			text+=" - "+tr("Listing...");
	}
	if(!showTheStatus || text=="")
	{
		if(movingMode)
			this->setWindowTitle("Ultracopier - "+tr("Move"));
		else
			this->setWindowTitle("Ultracopier - "+tr("Copy"));
	}
	else
	{
		if(movingMode)
			this->setWindowTitle(tr("Move")+text);
		else
			this->setWindowTitle(tr("Copy")+text);
	}
	//for the systray icon
	if(sysTrayIcon!=NULL)
	{
		if(CopyThread->getCurrentStat()!=copyThread::Stopped)
			sysTrayIcon->setToolTip(QString(tr("Coping...")));
		else if(CopyThread->getCurrentStat()==copyThread::Paused)
			sysTrayIcon->setToolTip(QString(tr("[Paused]")));
		else if(AddingFolderThread->isRunning())
			sysTrayIcon->setToolTip(QString(tr("Listing...")));
		else
			sysTrayIcon->setToolTip(QString(tr("Done")));
	}
	else
	{
		DEBUGCONSOLE(10,"Main_window::changePriority","sysTrayIcon==NULL");
	}
}

/** \brief update the block size value
\param newBlockSize The new block size */
void Main_window::updateBlockSize(int newBlockSize)
{
	CopyThread->setBlockSize(newBlockSize);
}

/** \brief Set prealoc file size
\param checked true if need prealoc else false */
void Main_window::setPreallocateFileSize(int checked)
{
	if(checked)
		CopyThread->setPreallocateFileSize(true);
	else
		CopyThread->setPreallocateFileSize(false);
}

/// \brief Update the priority of the threads
void Main_window::changePriority()
{
	DEBUGCONSOLE(30,"Main_window::changePriority","start");
	priorityLevel=priorityFromInt(comboBox_Priority->currentIndex());
}

/** \brief Listing is finish

Function called when the listing is finish
*/
void Main_window::ListingIsFinish()
{
	DEBUGCONSOLE(70,"Main_window::ListingIsFinish","start");
	if(shouldBeClosed)
	{
		cancel_copy_window();
		return;
	}
	DEBUGCONSOLE(90,"Main_window::ListingIsFinish","size of the copy (or move): "+QString::number(sizeTot));
	progressBar_all->setMaximum(32767);
	CopyList->addTopLevelItems(addingBuffer);
	addingBuffer.clear();
	setStatusOfCopy();
	updateTheCopyStat();
	QString MountPoint=getMountPoint(LastDestination);
	//if mount point located check free space
	if(MountPoint!="")
	{
		qint64 freeSpace=freeSpaceDrive(MountPoint);
		DEBUGCONSOLE(70,"Main_window::ListingIsFinish","Free space on: "+MountPoint+" = "+QString::number(freeSpace));
		if(freeSpace!=-1 && freeSpace<(sizeTot-sizeCur))
		{
			spaceWindowDialog *TheSpaceWindow = new spaceWindowDialog(this);
			connect(TheSpaceWindow, SIGNAL(ActionClicked(int)), this, SLOT(GetAction(int)));
			connect(this, SIGNAL(OrderUpdateStyle()), TheSpaceWindow, SLOT(UpdateStyle()));
			TheSpaceWindow->replaceText(QStringList() << QString::number(fileTot) << copyThread::intToQtringSize(sizeTot-sizeCur) << LastDestination << copyThread::intToQtringSize(freeSpace) << copyThread::intToQtringSize((sizeTot-sizeCur)-freeSpace));
			//default action if window is close for example
			TheSpaceWindow->exec();
			disconnect(TheSpaceWindow, SIGNAL(ActionClicked(int)));
			disconnect(TheSpaceWindow, SLOT(UpdateStyle()));
			delete TheSpaceWindow;
			if(actionInDialog==SPACE_DIAL_CANCEL)
			{
				cancel_copy_window();
				return;
			}
		}
	}
	if(!CopyThread->isRunning() && !checkBoxDisableAutoStart->isChecked())
	{
		DEBUGCONSOLE(70,"Main_window::ListingIsFinish","start the copy thread");
		PauseButton();
	}
	updatePlayPauseSkipButton();
}

/** \brief Action because the folders selected are the same

If addFolderThread detect that the source folder are same as destination folder ask what to do
\see folder
*/
void Main_window::AddFolderDetectAreSame(const QString& folder)
{
	DEBUGCONSOLE(90,"Main_window::AddFolderDetectAreSame","folder: \""+folder+"\")");
	AddingFolderThread->action(GetActionFileExist(true,folder,tr("The folders are the same"),""));
}

//get the main destination, can be "" for unable to stat the mount point, "*" for multiple destination
QString Main_window::getMainDestination()
{
	return MainDestination;
}

//get the main source, can be "" for unable to stat the mount point, "*" for multiple destination
QString Main_window::getMainSource()
{
	return MainSource;
}

/// \brief Cut the long text
QString Main_window::cutText(QString in,int len)
{
	if(in.length()>len)
		return in.left(len/2-1)+"..."+in.right(len/2-1);
	return in;
}

/** \brief Add one entry to dir list
\param theDir the unique dir given
\see AddFolderThread::putToDirList()
*/
void Main_window::addEntryToDirList(QDir theDir)
{
	//for frame dropping, for better speed listing
	if(addDirDropFrame.elapsed()>40)
	{
		addDirDropFrame.restart();
		to->setText(cutText(theDir.absolutePath(),50));
	}
}

/** \brief Set if copy or moving mode
\param isMovingMode If true is in the moving mode
*/
void Main_window::setMovingMode(bool isMovingMode)
{
	DEBUGCONSOLE(90,"Main_window::setMovingMode","start");
	movingMode=isMovingMode;
	if(movingMode)
	{
		CopyThread->setMovingMode(movingMode);
                //do that's because the slot need be connected only in moving mode
		//disconnect if connected
		disconnect(AddingFolderThread, SIGNAL(putToSourceDirList(QDir)), CopyThread, SLOT(addEntryToDirList(QDir)));
		//reconnect
		connect(AddingFolderThread, SIGNAL(putToSourceDirList(QDir)), CopyThread, SLOT(addEntryToDirList(QDir)));
	}
        else
        {
		//disconnect if connected because useless in copy mode
		disconnect(AddingFolderThread, SIGNAL(putToSourceDirList(QDir)), CopyThread, SLOT(addEntryToDirList(QDir)));
        }
}

//get the moving mode
bool Main_window::getMovingMode()
{
	return movingMode;
}

/** \brief Update the copy stat and the progress bar

Update only the progress bar if copyIsRunning is at true
Update only the information of the current file if copy is runing
\see copyIsRunning
*/
void Main_window::updateTheCopyStat()
{
	//put at end
	QList<copyItemInternal> listToPutAtEnd;
	listToPutAtEnd=CopyThread->putAtEndAfterError();
	for (int i = 0; i < listToPutAtEnd.size(); ++i) {
		removeIdItem(listToPutAtEnd.at(i).id);
		copyItemExternal tempItem;
		tempItem.id=listToPutAtEnd.at(i).id;
		QStringList newItem;
		newItem << listToPutAtEnd.at(i).source.absoluteFilePath();
		newItem << copyThread::intToQtringSize(listToPutAtEnd.at(i).size);
		newItem << listToPutAtEnd.at(i).destination.absoluteFilePath();
		QTreeWidgetItem *item = new QTreeWidgetItem(newItem);
		CopyList->insertTopLevelItem((CopyList->topLevelItemCount()-1),item);
		tempItem.theGraphicIndex=item;
		DEBUGCONSOLE(90,"Main_window::updateTheCopyStat","new: "+graphicPointer(tempItem.theGraphicIndex)+" id: "+QString::number(tempItem.id));
		theCopyItemExternal.append(tempItem);
	}
	//remove the right item
	int numberOfItemToRemove=CopyThread->getNumberOfItemRemoved();
	//if it just update the progression, numberOfItemToRemove=0
	while(numberOfItemToRemove>0)
	{
		QTreeWidgetItem * item=CopyList->topLevelItem(0);
		for (int i = 0; i < theCopyItemExternal.size(); ++i) {
			if(theCopyItemExternal.at(i).theGraphicIndex==item)
			{
				DEBUGCONSOLE(90,"Main_window::updateTheCopyStat","remove: "+graphicPointer(theCopyItemExternal.at(i).theGraphicIndex)+" id: "+QString::number(theCopyItemExternal.at(i).id));
				if(CopyList->indexOfTopLevelItem(theCopyItemExternal.at(i).theGraphicIndex)==-1)
				{
					DEBUGCONSOLE(10,"Main_window::removeIdItem","unable to locate the item in copy list with the id: "+QString::number(theCopyItemExternal.at(i).id));
				}
				else
					delete theCopyItemExternal.at(i).theGraphicIndex;
				theCopyItemExternal.removeAt(i);
				break;
			}
		}
		numberOfItemToRemove--;
	}
	//if iconised
	if(this->isHidden())
	{
		//update systray icon
		int getVarProgression=CopyThread->getProgressionPercentTotal();
		if(getOldProgression!=getVarProgression)
		{
			getOldProgression=getVarProgression;
			sysTrayIcon->setIcon(dynaIcon(getVarProgression));
		}
	}
	//if windowsed
	else
	{
		//update current file
		QString text=CopyThread->getCurrentFileCopied();
		if(text!="")
			current_file->setText(text);
		//update progress bar file
		progressBar_file->setValue(CopyThread->getProgressionPercent(32767));
		//update overall text
		text=CopyThread->getTextOverall();
		if(text!="")
			overall->setText(text);
		//update to and from
		text=CopyThread->getSyntetizedStringTo();
		if(text!="")
			to->setText(text);
		text=CopyThread->getSyntetizedStringFrom();
		if(text!="")
			from->setText(text);
		//update progress bar total
		int tempValue=CopyThread->getProgressionPercentTotal(32767);
		if(tempValue<0)
		{
			DEBUGCONSOLE(90,"Main_window::updateTheCopyStat","CopyThread->getProgressionPercentTotal(32767) return "+QString::number(tempValue));
		}
		else
		{
			#ifdef Q_OS_WIN32
			//SpecWindowsCurWindow;
			/*
			  ptl->SetProgressState(hmainwnd, TBPF_NORMAL)
			  ptl->SetProgressValue(hmainwnd, tempValue, 32767);
			  ptl->SetProgressState(hmainwnd, TBPF_PAUSED);
			  ptl->SetProgressState(hmainwnd, TBPF_ERROR);
			  ptl->SetProgressState(hmainwnd, TBPF_INDETERMINATE);
			*/
			#endif
			progressBar_all->setValue(tempValue);
		}
	}
}

void Main_window::updateTheCopySpeed()
{
	//update speed
	QString text=CopyThread->getCopySpeed();
	if(text!="")
		currentSpeed->setText(text);
}

/// \brief Reset the options as default
void Main_window::setDefaultOptions()
{
	#ifdef ULTRACOPIER_MODE_WINDOWS
	checkBoxPreallocate->setChecked(true);
	#endif
	
	//load the settings
	QSettings *theSettings=getSettingsRes();
	if(theSettings->status()==QSettings::NoError)
	{
		theSettings->beginGroup("theCopy");
		if(theSettings->contains("comboBox_copyEnd"))
			comboBox_copyEnd->setCurrentIndex(theSettings->value("comboBox_copyEnd").toInt());
		if(theSettings->contains("comboBox_fileCollisions"))
			comboBox_fileCollisions->setCurrentIndex(theSettings->value("comboBox_fileCollisions").toInt());
		if(theSettings->contains("comboBox_copyErrors"))
			comboBox_copyErrors->setCurrentIndex(theSettings->value("comboBox_copyErrors").toInt());
		if(theSettings->contains("MaxSpeed"))
                {
			DEBUGCONSOLE(90,"Main_window::setDefaultOptions","theSettings->contains(\"MaxSpeed\"): "+QString::number(theSettings->value("MaxSpeed").toInt()));
			abstractLayerSetSpeed(theSettings->value("MaxSpeed").toInt());
                }
		theSettings->endGroup();
		theSettings->beginGroup("Interface");
		if(theSettings->contains("checkBoxOnTop"))
			if(theSettings->value("checkBoxOnTop").toBool())
				this->setWindowFlags(this->windowFlags()|Qt::WindowStaysOnTopHint);
		theSettings->endGroup();
		theSettings->beginGroup("CopyManagement");
		if(theSettings->contains("checkBoxDisableAutoStart"))
			checkBoxDisableAutoStart->setChecked(theSettings->value("checkBoxDisableAutoStart").toBool());
		if(theSettings->contains("checkBoxRightCopy"))
			checkBoxRightCopy->setChecked(theSettings->value("checkBoxRightCopy").toBool());
		if(theSettings->contains("checkWriteThread"))
			checkWriteThread->setChecked(theSettings->value("checkWriteThread").toBool());
		if(theSettings->contains("checkBoxSystray"))
			checkBoxSystray->setChecked(theSettings->value("checkBoxSystray").toBool());
		if(theSettings->contains("checkBoxKeepDate"))
			checkBoxKeepDate->setChecked(theSettings->value("checkBoxKeepDate").toBool());
		if(theSettings->contains("comboBox_statusBar"))
			comboBox_statusBar->setCurrentIndex(theSettings->value("comboBox_statusBar").toInt());
		if(theSettings->contains("comboBox_TypeSpeedMax"))
		{
			int index=comboBox_TypeSpeedMax->findText(theSettings->value("comboBox_TypeSpeedMax").toString());
			DEBUGCONSOLE(90,"Main_window::setDefaultOptions","theSettings->value(\"comboBox_TypeSpeedMax\"): "+theSettings->value("comboBox_TypeSpeedMax").toString());
			if(index!=-1)
				comboBox_TypeSpeedMax->setCurrentIndex(index);
		}
		theSettings->endGroup();
		theSettings->beginGroup("Advanced");
		if(theSettings->contains("comboBox_Priority"))
		{
			int index=theSettings->value("comboBox_Priority").toInt();
			if(index<0 || index>3)
				index=2;
			priorityLevel=priorityFromInt(index);
			comboBox_Priority->setCurrentIndex(index);
		}
		if(theSettings->contains("spinBoxBlock"))
		{
			int index=theSettings->value("spinBoxBlock").toInt();
			if(index<1 || index>16384)
				index=64;
			spinBoxBlock->setValue(index);
		}
		if(theSettings->contains("checkBoxPreallocate"))
			checkBoxPreallocate->setChecked(theSettings->value("checkBoxPreallocate").toBool());
		theSettings->endGroup();
	}
	abstractLayerUpdateSpeedType();
	CopyThread->setBlockSize(spinBoxBlock->value());
}

/** \brief Set action
\param action is the action at store
\see env.h
*/
void Main_window::GetAction(int action)
{
	DEBUGCONSOLE(30,"Main_window::GetAction","action: "+QString::number(action));
	actionInDialog=action;
}

/// \brief Put selected file on top
void Main_window::Playlist_management_putSelectedFileOnTop()
{
	DEBUGCONSOLE(30,"Main_window::Playlist_management_putSelectedFileOnTop","start");
	int index,dest;
	bool isRunning;
	if(CopyThread->getCurrentStat()!=copyThread::Stopped)
	{
		isRunning=true;
		dest=1;
	}
	else
	{
		isRunning=false;
		dest=0;
	}
	QList<int> ids;
	QTreeWidgetItem * item=NULL;
	//get the ids to do actions
	int i=0;
	do
	{
		item=CopyList->topLevelItem(i);
		if(item==NULL)
			break;
		if(item->isSelected())
		{
			if(i!=0 || !isRunning)
			{
				for (int j=0; j<theCopyItemExternal.size(); ++j) {
					if(theCopyItemExternal.at(j).theGraphicIndex==item)
						ids<<theCopyItemExternal.at(j).id;
				}
			}
		}
		i++;
	} while(i<CopyList->topLevelItemCount());
	//do the real list actions
	returnIdsTransaction theReturnedVar=CopyThread->putOnTop(ids);
	//remove needed items
	for (int j=0; j<theCopyItemExternal.size(); ++j) {
		if(theReturnedVar.idsRemove.indexOf(theCopyItemExternal.at(j).id)!=-1)
		{
			if(CopyList->indexOfTopLevelItem(theCopyItemExternal.at(j).theGraphicIndex)==-1)
			{
				DEBUGCONSOLE(10,"Main_window::Playlist_management_putSelectedFileOnTop","critical crash prevent: theCopyItemExternal.at(j).theGraphicIndex not found!");
			}
			else
				delete theCopyItemExternal.at(j).theGraphicIndex;
			theCopyItemExternal.removeAt(j);
		}
	}
	//do the action only on requested items
	i=0;
	do
	{
		item=CopyList->topLevelItem(i);
		if(item==NULL)
			break;
		//load the id
		int id;
		for (int j=0; j<theCopyItemExternal.size(); ++j) {
			if(theCopyItemExternal.at(j).theGraphicIndex==item)
				id=theCopyItemExternal.at(j).id;
		}
		if(item->isSelected() && theReturnedVar.idsAction.indexOf(id)!=-1)
		{
			index = CopyList->indexOfTopLevelItem(item);
			if(!isRunning || index!=0)
			{
				if(index>dest)
				{
					CopyList->takeTopLevelItem(index);
					CopyList->insertTopLevelItem(dest, item);
					item->setSelected(true);
				}
				dest++;
			}
		}
		i++;
	} while(i<CopyList->topLevelItemCount());

}

/// \brief Move up the selected file
void Main_window::Playlist_management_putSelectedFileUp()
{
	DEBUGCONSOLE(30,"Main_window::Playlist_management_putSelectedFileUp","start");
	int index,dest,i=0;
	bool isRunning;
	if(CopyThread->getCurrentStat()!=copyThread::Stopped)
	{
		isRunning=true;
		dest=1;
	}
	else
	{
		isRunning=false;
		dest=0;
	}
	QList<int> ids;
	QTreeWidgetItem * item=NULL;
	do
	{
		item=CopyList->topLevelItem(i);
		if(item==NULL)
			break;
		if(item->isSelected())
		{
			index = CopyList->indexOfTopLevelItem(item);
			if(index!=1 || CopyThread->getCurrentStat()==copyThread::Stopped)
				if(!isRunning || index!=0)
				{
					if(index>dest)
					{
						for (int j=0; j<theCopyItemExternal.size(); ++j) {
							if(theCopyItemExternal.at(j).theGraphicIndex==item)
								ids<<theCopyItemExternal.at(j).id;
						}
					}
					else
						dest++;
				}
		}
		i++;
	} while(i<CopyList->topLevelItemCount());
	//do the real list actions
	returnIdsTransaction theReturnedVar=CopyThread->moveUp(ids);
	//remove needed items
	for (int j=0; j<theCopyItemExternal.size(); ++j) {
		if(theReturnedVar.idsRemove.indexOf(theCopyItemExternal.at(j).id)!=-1)
		{
			if(CopyList->indexOfTopLevelItem(theCopyItemExternal.at(j).theGraphicIndex)==-1)
			{
				DEBUGCONSOLE(10,"Main_window::Playlist_management_putSelectedFileUp","critical crash prevent: theCopyItemExternal.at(j).theGraphicIndex not found!");
			}
			else
				delete theCopyItemExternal.at(j).theGraphicIndex;
			theCopyItemExternal.removeAt(j);
		}
	}
	//do the action only on requested items
	i=0;
	do
	{
		item=CopyList->topLevelItem(i);
		if(item==NULL)
			break;
		//load the id
		int id;
		for (int j=0; j<theCopyItemExternal.size(); ++j) {
			if(theCopyItemExternal.at(j).theGraphicIndex==item)
				id=theCopyItemExternal.at(j).id;
		}
		if(item->isSelected() && theReturnedVar.idsAction.indexOf(id)!=-1)
		{
			index = CopyList->indexOfTopLevelItem(item);
			if(index!=1 || CopyThread->getCurrentStat()==copyThread::Stopped)
				if(!isRunning || index!=0)
				{
					if(index>dest)
					{
						CopyList->takeTopLevelItem(index);
						CopyList->insertTopLevelItem(index-1, item);
						item->setSelected(true);
						for (int j=0; j<theCopyItemExternal.size(); ++j) {
							if(theCopyItemExternal.at(j).theGraphicIndex==item)
								ids<<theCopyItemExternal.at(j).id;
						}
					}
					else
						dest++;
				}
		}
		i++;
	} while(i<CopyList->topLevelItemCount());
}

/// \brief Move down the selected file
void Main_window::Playlist_management_putSelectedFileDown()
{
	DEBUGCONSOLE(30,"Main_window::Playlist_management_putSelectedFileDown","start");
	int index,dest=(CopyList->topLevelItemCount()-1),i=(CopyList->topLevelItemCount()-1);
	QList<int> ids;
	QTreeWidgetItem * item=NULL;
	do
	{
		item=CopyList->topLevelItem(i);
		if(item==NULL)
			break;
		if(item->isSelected() && (i!=0 || CopyThread->getCurrentStat()==copyThread::Stopped))
		{
			index = CopyList->indexOfTopLevelItem(item);
			if(index<dest)
			{
				for (int j=0; j<theCopyItemExternal.size(); ++j) {
					if(theCopyItemExternal.at(j).theGraphicIndex==item)
						ids<<theCopyItemExternal.at(j).id;
				}
			}
			else
				dest--;
		}
		i--;
	} while(i>=0);
	//do the real list actions
	returnIdsTransaction theReturnedVar=CopyThread->moveDown(ids);
	i=(CopyList->topLevelItemCount()-1);
	//remove needed items
	for (int j=0; j<theCopyItemExternal.size(); ++j) {
		if(theReturnedVar.idsRemove.indexOf(theCopyItemExternal.at(j).id)!=-1)
		{
			if(CopyList->indexOfTopLevelItem(theCopyItemExternal.at(j).theGraphicIndex)==-1)
			{
				DEBUGCONSOLE(10,"Main_window::Playlist_management_putSelectedFileDown","critical crash prevent: theCopyItemExternal.at(j).theGraphicIndex not found!");
			}
			else
				delete theCopyItemExternal.at(j).theGraphicIndex;
			theCopyItemExternal.removeAt(j);
		}
	}
	//do the action only on requested items
	do
	{
		item=CopyList->topLevelItem(i);
		if(item==NULL)
			break;
		//load the id
		int id;
		for (int j=0; j<theCopyItemExternal.size(); ++j) {
			if(theCopyItemExternal.at(j).theGraphicIndex==item)
				id=theCopyItemExternal.at(j).id;
		}
		if(item->isSelected() && (i!=0 || CopyThread->getCurrentStat()==copyThread::Stopped) && theReturnedVar.idsAction.indexOf(id)!=-1)
		{
			index = CopyList->indexOfTopLevelItem(item);
			if(index<dest)
			{
				CopyList->takeTopLevelItem(index);
				CopyList->insertTopLevelItem(index+1, item);
				item->setSelected(true);
			}
			else
				dest--;
		}
		i--;
	} while(i>=0);
}

/// \brief Put the selected file on bottom
void Main_window::Playlist_management_putSelectedFileOnBottom()
{
	DEBUGCONSOLE(30,"Main_window::Playlist_management_putSelectedFileOnBottom","start");
	int index,dest=(CopyList->topLevelItemCount()-1),i=(CopyList->topLevelItemCount()-1);
	QTreeWidgetItem * item=NULL;
	QList<int> ids;
	do
	{
		item=CopyList->topLevelItem(i);
		if(item==NULL)
			break;
		if(item->isSelected() && (i!=0 || CopyThread->getCurrentStat()==copyThread::Stopped))
		{
			index = CopyList->indexOfTopLevelItem(item);
			if(index<dest)
			{
				for (int j=0; j<theCopyItemExternal.size(); ++j) {
					if(theCopyItemExternal.at(j).theGraphicIndex==item)
						ids<<theCopyItemExternal.at(j).id;
				}
			}
			dest--;
		}
		i--;
	} while(i>=0);
	//do the real list actions
	returnIdsTransaction theReturnedVar=CopyThread->putOnBottom(ids);
	i=(CopyList->topLevelItemCount()-1);
	//remove needed items
	for (int j=0; j<theCopyItemExternal.size(); ++j) {
		if(theReturnedVar.idsRemove.indexOf(theCopyItemExternal.at(j).id)!=-1)
		{
			if(CopyList->indexOfTopLevelItem(theCopyItemExternal.at(j).theGraphicIndex)==-1)
			{
				DEBUGCONSOLE(10,"Main_window::Playlist_management_putSelectedFileOnBottom","critical crash prevent: theCopyItemExternal.at(j).theGraphicIndex not found!");
			}
			else
				delete theCopyItemExternal.at(j).theGraphicIndex;
			theCopyItemExternal.removeAt(j);
		}
	}
	//do the action only on requested items
	do
	{
		item=CopyList->topLevelItem(i);
		if(item==NULL)
			break;
		//load the id
		int id;
		for (int j=0; j<theCopyItemExternal.size(); ++j) {
			if(theCopyItemExternal.at(j).theGraphicIndex==item)
				id=theCopyItemExternal.at(j).id;
		}
		if(item->isSelected() && (i!=0 || CopyThread->getCurrentStat()==copyThread::Stopped) && theReturnedVar.idsAction.indexOf(id)!=-1)
		{
			index = CopyList->indexOfTopLevelItem(item);
			if(index<dest)
			{
				CopyList->takeTopLevelItem(index);
				CopyList->insertTopLevelItem(dest, item);
				item->setSelected(true);
			}
			dest--;
		}
		i--;
	} while(i>=0);
}

/// \brief Skip button clicked
void Main_window::SkipButton()
{
	CopyThread->skipCurrentFile();
	updateTheCopyStat();
	updatePlayPauseSkipButton();
}

/// \brief Pause button clicked
void Main_window::PauseButton()
{
	DEBUGCONSOLE(90,"Main_window::PauseButton","start");
	if(CopyThread->getCurrentStat()==copyThread::Stopped)
	{
		CopyThread->start(priorityLevel);
		if(!TimerForCopyUpdate->isActive())
			TimerForCopyUpdate->start();
		if(!TimerForCopySpeedUpdate->isActive())
			TimerForCopySpeedUpdate->start();
		DEBUGCONSOLE(50,"Main_window::PauseButton","copyThread::Stopped");
	}
	else if(CopyThread->getCurrentStat()==copyThread::Paused)
	{
		CopyThread->resumeCopy();
		DEBUGCONSOLE(50,"Main_window::PauseButton","copyThread::Paused");
	}
	else if(CopyThread->getCurrentStat()==copyThread::Running)
	{
		CopyThread->pauseCopy();
		DEBUGCONSOLE(50,"Main_window::PauseButton","copyThread::Running");
	}
	if(CopyThread->getCurrentStat()!=copyThread::Stopped)
		updateTheCopyStat();
	updatePlayPauseSkipButton();
}

/** \brief Cancel query

Click on the cancel button or query the cancel. Close all should be closed.
*/
void Main_window::cancel_copy_window()
{
	DEBUGCONSOLE(30,"Main_window::cancel_copy_window","Quit the main windows");
	shouldBeClosed=true;
	this->hide();
	#if (DEBUG_ULTRACOPIER>0)
	DebugTrackThread.stop();
	#endif
	TimerForCopyUpdate->stop();
	TimerForCopySpeedUpdate->stop();
	disconnect(AddingFolderThread);
	if(AddingFolderThread->isRunning())
	{
		DEBUGCONSOLE(30,"Main_window::cancel_copy_window","Close the listing thread");
		AddingFolderThread->stop();
		DEBUGCONSOLE(90,"Main_window::cancel_copy_window","stop() ... done");
		AddingFolderThread->quit();
		DEBUGCONSOLE(90,"Main_window::cancel_copy_window","terminate() ... done");
	}
	if(CopyThread->getCurrentStat()!=copyThread::Stopped)
	{
		DEBUGCONSOLE(30,"Main_window::cancel_copy_window","Close the copy thread");
		CopyThread->stopTheCopy();
		DEBUGCONSOLE(90,"Main_window::cancel_copy_window","terminate() ... done");
	}
	DEBUGCONSOLE(90,"Main_window::cancel_copy_window","emit copyFinish()");
	emit copyFinish();
	DEBUGCONSOLE(90,"Main_window::cancel_copy_window","check thread stat");
	if(CopyThread->allThreadIsFinish() && AddingFolderThread->isFinished())
	{
		DEBUGCONSOLE(90,"Main_window::cancel_copy_window","emit canDeleteTheObject()");
		emit canDeleteTheObject();
	}
	DEBUGCONSOLE(90,"Main_window::cancel_copy_window","stop");
}

/** \brief Open the File exists window

Show the file exist windows and return the choise
\see env.h
\return The action code
\param sameFile If true operate is the same file mode else it operate in file exists mode
\param text1 see the note
\param text2 see the note
\param text3 see the note
\note if sameFile == true : text1 = source and dest
\note if sameFile == fasle : text1 = path : text2 = source : text3 = dest
*/
int Main_window::GetActionFileExist(bool sameFile,const QString& text1,const QString& text2,const QString& text3)
{
	/** \brief For store the action requested
	\see env.h */
	DEBUGCONSOLE(30,"Main_window::GetActionFileExist","start");
	switch(comboBox_fileCollisions->currentIndex())
	{
		DEBUGCONSOLE(90,"Main_window::GetActionFileExist","comboBox_fileCollisions->currentIndex(): "+QString::number(comboBox_fileCollisions->currentIndex()));
		case COMBO_COLLI_ASK:
			{
				CopyFileExistsWindow FileExistWindow(this);
				connect(&FileExistWindow,	SIGNAL(ActionOnFileExists(int)),	this,		SLOT(GetAction(int)));
				connect(this,			SIGNAL(OrderUpdateStyle()),		&FileExistWindow,SLOT(UpdateStyle()));
				if(sameFile)
				{
					if(text2!="")
						FileExistWindow.SourceAndDestinationIsSame(text1,text2);
					else
						FileExistWindow.SourceAndDestinationIsSame(text1);
				}
				else
					FileExistWindow.AlreadyExists(text1,text2,text3);
				//default action if window is close for example
				actionInDialog=FILEEXIST_CANCEL;
				DEBUGCONSOLE(90,"Main_window::GetActionFileExist","actionInDialog before exec: "+QString::number(actionInDialog));
				FileExistWindow.exec();
				DEBUGCONSOLE(90,"Main_window::GetActionFileExist","actionInDialog after exec: "+QString::number(actionInDialog));
				disconnect(&FileExistWindow,	SIGNAL(ActionOnFileExists(int)),	this,		SLOT(GetAction(int)));
				disconnect(this,		SIGNAL(OrderUpdateStyle()),		&FileExistWindow,SLOT(UpdateStyle()));
			}
			DEBUGCONSOLE(90,"Main_window::GetActionFileExist","actionInDialog: "+QString::number(actionInDialog));
			switch(actionInDialog)
			{
				case FILEEXIST_CANCEL:
					cancel_copy_window();
					return FILEEXIST_ACTION_CANCEL;
				break;
				case FILEEXIST_SKIP_ALL:
					comboBox_fileCollisions->setCurrentIndex(COMBO_COLLI_SKIP);
				case FILEEXIST_SKIP:
					return FILEEXIST_ACTION_SKIP;
				break;
				case FILEEXIST_RENAME_ALL:
					comboBox_fileCollisions->setCurrentIndex(COMBO_COLLI_RENAME);
				case FILEEXIST_RENAME:
					return FILEEXIST_ACTION_RENAME;
				break;
				case FILEEXIST_OVERWRITE_ALL:
					if(sameFile)
					{
						DEBUGCONSOLE(10,"Main_window::GetActionFileExist","internal error, FILEEXIST_OVERWRITE_ALL can not be clicked!");
						return -1;
					}
					else
						comboBox_fileCollisions->setCurrentIndex(COMBO_COLLI_OVERWRITE);
				case FILEEXIST_OVERWRITE:
					if(sameFile)
					{
						DEBUGCONSOLE(10,"Main_window::GetActionFileExist","internal error, FILEEXIST_OVERWRITE can not be clicked!");
						return -1;
					}
					else
						return FILEEXIST_ACTION_OVERWRITE;
				break;
				case FILEEXIST_OVERWRITE_ALL_IFNOTSAME:
					if(sameFile)
					{
						DEBUGCONSOLE(10,"Main_window::GetActionFileExist","internal error, FILEEXIST_OVERWRITE_ALL_IFNOTSAME can not be clicked!");
						return -1;
					}
					else
						comboBox_fileCollisions->setCurrentIndex(COMBO_COLLI_OVERWRITE_IFNOTSAME);
				case FILEEXIST_OVERWRITE_IFNOTSAME:
					if(sameFile)
					{
						DEBUGCONSOLE(10,"Main_window::GetActionFileExist","internal error, FILEEXIST_OVERWRITE_IFNOTSAME can not be clicked!");
						return -1;
					}
					else
						return FILEEXIST_ACTION_OVERWRITE_IFNOTSAME;
				break;
				case FILEEXIST_OVERWRITE_ALL_IFNEWER:
					if(sameFile)
					{
						DEBUGCONSOLE(10,"Main_window::GetActionFileExist","internal error, FILEEXIST_OVERWRITE_ALL_IFNEWER can not be clicked!");
						return -1;
					}
					else
						comboBox_fileCollisions->setCurrentIndex(COMBO_COLLI_OVERWRITE_IFNEWER);
				case FILEEXIST_OVERWRITE_IFNEWER:
					if(sameFile)
					{
						DEBUGCONSOLE(10,"Main_window::GetActionFileExist","internal error, FILEEXIST_OVERWRITE_IFNEWER can not be clicked!");
						return -1;
					}
					else
						return FILEEXIST_ACTION_OVERWRITE_IFNEWER;
				break;
				default:
					DEBUGCONSOLE(10,"Main_window::GetActionFileExist","internal error, action number ("+QString::number(actionInDialog)+") unknow!");
					return -1;
				break;
			}
		break;
		case COMBO_COLLI_OVERWRITE:
			if(sameFile)
			{
				comboBox_fileCollisions->setCurrentIndex(COMBO_COLLI_ASK);
				return GetActionFileExist(sameFile,text1,text2,text3);
			}
			else
				return FILEEXIST_ACTION_OVERWRITE;
		break;
		case COMBO_COLLI_RENAME:
			return FILEEXIST_ACTION_RENAME;
		break;
		case COMBO_COLLI_SKIP:
			return FILEEXIST_ACTION_SKIP;
		break;
		case COMBO_COLLI_OVERWRITE_IFNOTSAME:
			return FILEEXIST_ACTION_OVERWRITE_IFNOTSAME;
		break;
		case COMBO_COLLI_OVERWRITE_IFNEWER:
			return FILEEXIST_ACTION_OVERWRITE_IFNEWER;
		break;
		default:
			DEBUGCONSOLE(10,"Main_window::GetActionFileExist","internal error, comboBox_fileCollisions->currentIndex() sould not be "+QString::number(comboBox_fileCollisions->currentIndex())+"!");
			return -1;
		break;
	}
	return -1;
}

//update the progressBar_all mode (busy or not)
void Main_window::updateProgressBarAllMode()
{
	if(AddingFolderThread->isRunning() && CopyThread->isFinished())
	{
		DEBUGCONSOLE(90,"Main_window::updateProgressBarAllMode","AddingFolderThread->isRunning() && !CopyThread->isRunning()");
		progressBar_all->setMaximum(0);
	}
	else
	{
		DEBUGCONSOLE(90,"Main_window::updateProgressBarAllMode","progressBar_all->setMaximum(32767)");
		progressBar_all->setMaximum(32767);
	}
}

/** \brief update the play, pause,skip button
\note if copyIsRunning is at true show pause, else show play
*/
void Main_window::updatePlayPauseSkipButton()
{
	//if copy is running
	if(CopyThread->isRunning())
	{
		DEBUGCONSOLE(70,"Main_window::updatePlayPauseSkipButton","!CopyThread->isFinished()");
		pauseButton->setEnabled(true);
		skipButton->setEnabled(true);
		actionPause->setEnabled(true);
		cancelButton->setText(tr("Cancel"));
		if(CopyThread->getCurrentStat()!=copyThread::Paused)
		{
			actionPause->setText(tr("Pause"));
			pauseButton->setText(tr("Pause"));
			pauseButton->setIcon(loadImage("player_pause.png"));
		}
		//if copy is paused
		else
		{
			DEBUGCONSOLE(90,"Main_window::updatePlayPauseSkipButton","Copy list full and ready to copy");
			actionPause->setText(tr("Play"));
			pauseButton->setText(tr("Play"));
			pauseButton->setIcon(loadImage("player_play.png"));
		}
	}
	else
	{
		actionPause->setText(tr("Play"));
		pauseButton->setText(tr("Play"));
		pauseButton->setIcon(loadImage("player_play.png"));
		//if copy is finish and stopped
		if(CopyThread->lenghtOfCopyList()==0)
		{
			DEBUGCONSOLE(90,"Main_window::updatePlayPauseSkipButton","no item in copy list");
			skipButton->setEnabled(false);
			pauseButton->setEnabled(false);
			actionPause->setEnabled(false);
			if(TimerForCopyUpdate->isActive())
				TimerForCopyUpdate->stop();
			if(TimerForCopySpeedUpdate->isActive())
				TimerForCopySpeedUpdate->stop();
			sizeCur=sizeTot;
			cancelButton->setText(tr("Quit"));
		}
		//if copy is paused
		else
		{
			DEBUGCONSOLE(90,"Main_window::updatePlayPauseSkipButton","Copy list full and ready to copy");
			pauseButton->setEnabled(true);
			skipButton->setEnabled(true);
			actionPause->setEnabled(true);
			cancelButton->setText(tr("Cancel"));
		}
	}
}

/** \brief Show the detailed mode if needed
\param moreButtonBool if at true then the detailed mode is needed
*/
void Main_window::resizeMore(bool moreButtonBool)
{
	DEBUGCONSOLE(30,"Main_window::resizeMore","start");
	if(!moreButtonBool)
	{
		moreButton->setIcon(loadImage("1downarrow.png"));
		if(comboBox_statusBar->currentIndex()==0)
			setVisibleStatus(false);
		progressBar_file->hide();
		current_file->hide();
		skipButton->hide();
		currentSpeed->hide();
		progressBar_all->setTextVisible(false);
		this->setMaximumHeight(50);
		this->adjustSize();
		#if (DEBUG_ULTRACOPIER>0)
		Debug_label_copyThread->hide();
		Debug_label_writeThread->hide();
		Debug_label_waitThread->hide();
		DebugTrackThread.stop();
		#endif
	}
	else
	{
		moreButton->setIcon(loadImage("1uparrow.png"));
		if(comboBox_statusBar->currentIndex()==0)
			setVisibleStatus(true);
		progressBar_file->show();
		current_file->show();
		skipButton->show();
		currentSpeed->show();
		progressBar_all->setTextVisible(true);
		this->setMaximumHeight(16777215);
		this->adjustSize();
		#if (DEBUG_ULTRACOPIER>0)
		Debug_label_copyThread->show();
		Debug_label_writeThread->show();
		Debug_label_waitThread->show();
		DebugTrackThread.start();
		DebugCheckThread();
		#endif
	}
}

/** \brief Open window for choise the directory
\param thedirpath The default dir path
\param title The title of the window
\return Return true if succes
*/
QString Main_window::getDirectoryPath(const QString& title)
{
	QString dialogPath = QFileDialog::getExistingDirectory(this, title,"",QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
	if(dialogPath.isEmpty() || dialogPath.isNull() || dialogPath=="")
		return "";
	DEBUGCONSOLE(90,"Main_window::getDirectoryPath","dialogPath: "+dialogPath);
	QString thedirpath(fromPercentEncodingLocal(dialogPath));
	DEBUGCONSOLE(90,"Main_window::getDirectoryPath","thedirpath: "+thedirpath);
	//thedirpath=QByteArray::fromPercentEncodingLocal(thedirpath);
	if(!thedirpath.endsWith('/') && !thedirpath.endsWith('\\'))
	{
		DEBUGCONSOLE(90,"Main_window::getDirectoryPath","dir not end with \"/\" look: "+thedirpath);
		thedirpath+='/';
	}
	else
	{
		DEBUGCONSOLE(90,"Main_window::getDirectoryPath","dir end with /: "+thedirpath);
	}
	if(thedirpath=="//")
	{
		DEBUGCONSOLE(90,"Main_window::getDirectoryPath","dir = // cleaning the name path");
		thedirpath='/';
	}
	return thedirpath;
}

/** \brief Add file to the copy list
\return Return true if succes
*/
bool Main_window::addFile()
{
	DEBUGCONSOLE(50,"Main_window::addFile","start");
	QStringList files = QFileDialog::getOpenFileNames(
		this,
		tr("Select one or more files to open"),
		"~/",
		tr("All files")+" (*)");
	QList<QUrl> url;
	DEBUGCONSOLE(90,"Main_window::addFile","number of argument: "+QString::number(files.size()));
	//quit if click on cancel
	if(files.isEmpty())
		return false;
	//load in url for parse in folder thread
	for (int i = 0; i < files.size(); ++i) {
		url << QUrl::fromLocalFile(fromPercentEncodingLocal(files.at(i)));
		DEBUGCONSOLE(30,"Main_window::addFile","argument["+QString::number(i)+"]: "+files.at(i));
		}
	//prompt the destination directory
	QString dir=getDirectoryPath(tr("Open target directory"));
	//quit if click on cancel
	if(dir=="")
		return false;
	setInternalDestination(dir);

	//set the url source to listing
	AddingFolderThread->setFileListDropped(url);
	//set the destination dir
	AddingFolderThread->setDir(dir,true);
	//start the scan the list
	AddingFolderThread->start(priorityLevel);
	return true;
}

/** \brief Ask which folder add
\return Return true if succes
*/
bool Main_window::addFolder()
{
	if(AddingFolderThread->isRunning())
	{
		QMessageBox::warning(NULL, tr("Error"),
		tr("Wait the end of the previous folder adding. Thanks"),
		QMessageBox::Cancel,
		QMessageBox::Cancel);
	}
	else
	{
		DEBUGCONSOLE(30,"Main_window::addFolder","start");
		//prompt the source directory
		QString dir=getDirectoryPath(tr("Open the source directory"));
		//quit if click on cancel
		if(dir=="")
			return false;
		QString dir2=dir;
		DEBUGCONSOLE(50,"Main_window::addFolder","source dir: "+dir);
		//set the source to listing
		AddingFolderThread->setDir(dir,false);
		//prompt the destination directory
		dir=getDirectoryPath(tr("Open the destination directory"));
		//quit if click on cancel
		if(dir=="")
			return false;
		setInternalSource(dir2);
		setInternalDestination(dir);
		DEBUGCONSOLE(50,"Main_window::addFolder","destination dir: "+dir);
		//set the destination dir
		AddingFolderThread->setDir(dir,true);
		//start the scan the list
		AddingFolderThread->start(priorityLevel);
	}
	return true;
}

/// \brief Priority conversion int to QThread::Priority
QThread::Priority Main_window::priorityFromInt(int num)
{
	//convert Gui combobox number to QThread Priority
	switch(num)
	{
		case 0:
			return QThread::IdlePriority;
		case 1:
			return QThread::LowestPriority;
		case 2:
			return QThread::NormalPriority;
		case 3:
			return QThread::HighestPriority;
		default:
			return QThread::NormalPriority;
	}
}

/** \brief Delete the selected file
\return Return true if succes
*/
bool Main_window::Playlist_management_del()
{
	DEBUGCONSOLE(30,"Main_window::Playlist_management_del","start");
	int dest,i=0;
	bool isRunning;
	if(CopyThread->getCurrentStat()!=copyThread::Stopped)
	{
		#if (DEBUG_ULTRACOPIER>=90)
		if(CopyThread->getCurrentStat()!=copyThread::Stopped)
			DEBUGCONSOLE(90,"Main_window::Playlist_management_del","CopyThread->isRunning()==true");
		if(CopyThread->getCurrentStat()!=copyThread::Paused)
			DEBUGCONSOLE(90,"Main_window::Playlist_management_del","copyMode==COPYMODE_RESUME");
		#endif
		isRunning=true;
		dest=1;
	}
	else
	{
		DEBUGCONSOLE(90,"Main_window::Playlist_management_del","no copy running");
		isRunning=false;
		dest=0;
	}
	QList<int> ids;
	QTreeWidgetItem * item;
	do
	{
		item=NULL;
		item=CopyList->topLevelItem(i);
		if(item!=NULL)
		{
			if(item->isSelected() && (i!=0 || CopyThread->getCurrentStat()==copyThread::Stopped))
			{
				DEBUGCONSOLE(90,"Main_window::Playlist_management_del","delete the item at index in copy list: "+QString::number(i));
				for (int j = 0; j < theCopyItemExternal.size(); ++j) {
					if(theCopyItemExternal.at(j).theGraphicIndex==item)
						ids<<theCopyItemExternal.at(j).id;
				}
				delete item;
				i--;
			}
		}
		i++;
	} while(i<CopyList->topLevelItemCount());
	CopyThread->removeItems(ids);
	updateTheCopyStat();
	updatePlayPauseSkipButton();
	return true;
}

//remove id from the external list
void Main_window::removeIdItem(quint64 id)
{
	for (int i = 0; i < theCopyItemExternal.size(); ++i) {
		if(theCopyItemExternal.at(i).id==id)
		{
			DEBUGCONSOLE(90,"Main_window::updateTheCopyStat","remove: "+graphicPointer(theCopyItemExternal.at(i).theGraphicIndex)+" id: "+QString::number(theCopyItemExternal.at(i).id));
			if(CopyList->indexOfTopLevelItem(theCopyItemExternal.at(i).theGraphicIndex)==-1)
			{
				DEBUGCONSOLE(10,"Main_window::removeIdItem","unable to locate the item in copy list with the id: "+QString::number(id));
			}
			else
				delete theCopyItemExternal.at(i).theGraphicIndex;
			theCopyItemExternal.removeAt(i);
			break;
		}
	}
}

/** \brief Set the argument of the source and destination
\param argumentsUltracopier the source and the destination */
void Main_window::setArguments(QStringList argumentsUltracopier)
{
	DEBUGCONSOLE(70,"Main_window::setArguments","start");
	if(AddingFolderThread->isRunning())
	{
		QMessageBox::warning(NULL, tr("Error"),
		tr("Wait the end of the previous folder adding. Thanks"),
		QMessageBox::Cancel,
		QMessageBox::Cancel);
	}
	else
	{
		#if (DEBUG_ULTRACOPIER>0)
		DEBUGCONSOLE(90,"Main_window::setArguments","number of argument: "+QString::number(argumentsUltracopier.size()));
		for (int i = 0; i < argumentsUltracopier.size(); ++i) {
			DEBUGCONSOLE(90,"Main_window::setArguments","argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
		}
		#endif
		if(argumentsUltracopier.last().endsWith("//"))
			argumentsUltracopier.last().resize(argumentsUltracopier.last().size()-1);
		DEBUGCONSOLE(70,"Main_window::setArguments","Set source file or folder...");
		QList<QUrl> url;
		for (int i = 0; i < (argumentsUltracopier.size()-1); ++i)
		{
			if(argumentsUltracopier.at(i)!="")
			{
				DEBUGCONSOLE(90,"Main_window::setArguments","argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
				url<<QUrl::fromLocalFile(argumentsUltracopier.at(i));
			}
			#if (DEBUG_ULTRACOPIER>0)
			else
				DEBUGCONSOLE(10,"Main_window::setArguments","argument["+QString::number(i)+"] is empty!");
			#endif
		}
		if(!url.isEmpty() && argumentsUltracopier.last()!="")
		{
			LastDestination=argumentsUltracopier.last();
			DEBUGCONSOLE(90,"Main_window::setArguments","setDir("+LastDestination+",true)");
			setInternalDestination(LastDestination);
			AddingFolderThread->setDir(LastDestination,true);
			AddingFolderThread->setFileListDropped(url);
			AddingFolderThread->start(priorityLevel);
		}
		else
		{
			#if (DEBUG_ULTRACOPIER>0)
			if(url.isEmpty())
				DEBUGCONSOLE(10,"Main_window::setArguments","url list is empty!");
			if(argumentsUltracopier.last()=="")
				DEBUGCONSOLE(10,"Main_window::setArguments","destination is empty!");
			#endif
			cancel_copy_window();
		}
	}
}

/// \brief Drag event
void Main_window::dragEnterEvent(QDragEnterEvent *event)
{
	if(event->mimeData()->hasFormat("text/uri-list"))
		event->acceptProposedAction();
}

//drag event processing
void Main_window::dropEvent(QDropEvent *event)
{
	listUrlEvent = event->mimeData()->urls();
	if(listUrlEvent.isEmpty())
		return;
	if(AddingFolderThread->isRunning())
	{
		QMessageBox::warning(NULL, tr("Error"),
		tr("Wait the end of the previous folder adding. Thanks"),
		QMessageBox::Cancel,
		QMessageBox::Cancel);
	}
	else
	{
		DEBUGCONSOLE(30,"Main_window::dropEvent","//adding the file dropped");
		AddingFolderThread->setFileListDropped(listUrlEvent);
		QString dir=getDirectoryPath(tr("Open target directory"));
		if(dir=="")
			return;
		setInternalDestination(dir);
		AddingFolderThread->setDir(dir,true);
		AddingFolderThread->start(priorityLevel);
	}
}

/** \brief Add item to list
\param source The source
\param destination The folder or file destination
*/
void Main_window::addToList(const QFileInfo& source,const QFileInfo& destination)
{
	DEBUGCONSOLE(90,"Main_window::addToList","start, add: "+source.filePath()+" and: "+destination.filePath());
	qint64 size=source.size();
	
	QStringList newItem;
	QString sourceFile,destFile;
	if(getMountType(source.filePath())!="protocol")
		sourceFile=source.absoluteFilePath();
	else
		sourceFile=source.filePath();
	if(getMountType(destination.filePath())!="protocol")
		destFile=destination.absoluteFilePath();
	else
		destFile=destination.filePath();
	newItem << sourceFile << copyThread::intToQtringSize(size) << destFile;
	QTreeWidgetItem *item = new QTreeWidgetItem(newItem);
	CopyList->addTopLevelItem(item);

	copyItemExternal tempItem;
	tempItem.id=++autoIncrementId;
	tempItem.theGraphicIndex=item;
	CopyThread->addToList(tempItem.id,source,size,destination);
	theCopyItemExternal.append(tempItem);

	sizeTot+=size;
	fileTot++;
	DEBUGCONSOLE(90,"Main_window::addToList","stop");
}

/** \brief Open window error management
\param ButtonActivated Choise the button activated, see env.h
\param fileOrDir What file or folder is the subject of this error
\param errorMessage The error message
\return Return the action code, see env.h
\see env.h
*/
int Main_window::errorManagement(int ButtonActivated,const QString& fileOrDir,const QString& errorMessage=tr("Unkown error"))
{
	/** \brief For store the action requested
	\see env.h */
	aErrorHasOccurred=true;
	switch(comboBox_copyErrors->currentIndex())
	{
		DEBUGCONSOLE(90,"Main_window::errorManagement","ButtonActivated="+QString::number(ButtonActivated));
		case COMBO_ERROR_ASK:
		{
			ErrorWindow *TheFileWindow;		///< on the Error Window
			TheFileWindow = new ErrorWindow(this);
			connect(TheFileWindow, SIGNAL(ActionClicked(int)), this, SLOT(GetAction(int)));
			connect(this, SIGNAL(OrderUpdateStyle()), TheFileWindow, SLOT(UpdateStyle()));
			TheFileWindow->file(fileOrDir);
			TheFileWindow->error(errorMessage);
			TheFileWindow->setButtonActivated(ButtonActivated);
			//default action if window is close for example
			actionInDialog=FILEEXIST_CANCEL;
			TheFileWindow->exec();
			disconnect(TheFileWindow, SIGNAL(ActionClicked(int)));
			disconnect(TheFileWindow, SLOT(UpdateStyle()));
			delete TheFileWindow;
			switch(actionInDialog)
			{
				case UC_ERROR_RETRY:
					DEBUGCONSOLE(50,"Main_window::errorManagement","Action returned: ERRORACTION_RETRY");
					return ERRORACTION_RETRY;
				break;
				case UC_ERROR_SKIP_ALL:
					if(ButtonActivated!=ERROR_DEF_NOSKIPNOENDOF)
						comboBox_copyErrors->setCurrentIndex(COMBO_ERROR_SKIP);
					else
					{
						DEBUGCONSOLE(10,"Main_window::errorManagement","internal error, the button ERROR_SKIP_ALL is disabled, then it can be clicked!");
					}
				case UC_ERROR_SKIP:
					if(ButtonActivated!=ERROR_DEF_NOSKIPNOENDOF)
					{
						DEBUGCONSOLE(50,"Main_window::errorManagement","Action returned: ERRORACTION_SKIP");
						return ERRORACTION_SKIP;
					}
					else
					{
						DEBUGCONSOLE(10,"Main_window::errorManagement","internal error, the button ERROR_SKIP is disabled, then it can be clicked!");
					}
				break;
				case UC_ERROR_ENDOFLIST_ALL:
					if(ButtonActivated!=ERROR_DEF_NOSKIPNOENDOF && ButtonActivated!=ERROR_DEF_NOENDOF)
					{
						comboBox_copyErrors->setCurrentIndex(COMBO_ERROR_ATEND);
					}
					else
					{
						DEBUGCONSOLE(10,"Main_window::errorManagement","internal error, the button ERROR_ENDOFLIST_ALL is disabled, then it can be clicked!");
					}
				case UC_ERROR_ENDOFLIST:
					if(ButtonActivated!=ERROR_DEF_NOSKIPNOENDOF && ButtonActivated!=ERROR_DEF_NOENDOF)
					{
						DEBUGCONSOLE(50,"Main_window::errorManagement","Action returned: ERRORACTION_ENDOF");
						return ERRORACTION_ENDOF;
					}
					else
					{
						DEBUGCONSOLE(10,"Main_window::errorManagement","internal error, the button ERROR_ENDOFLIST is disabled, then it can be clicked!");
					}
				break;
				case UC_ERROR_CANCEL:
					cancel_copy_window();
					DEBUGCONSOLE(50,"Main_window::errorManagement","Action returned: ERRORACTION_CLOSE");
					return ERRORACTION_CLOSE;
				break;
			}
		}
		break;
		case COMBO_ERROR_SKIP:
			if(ButtonActivated!=ERROR_DEF_NOSKIPNOENDOF)
			{
				DEBUGCONSOLE(50,"Main_window::errorManagement","Action returned: ERRORACTION_SKIP");
				return ERRORACTION_SKIP;
			}
			else
			{
				comboBox_copyErrors->setCurrentIndex(COMBO_ERROR_ASK);
				int tempr=errorManagement(ButtonActivated,fileOrDir,errorMessage);
				DEBUGCONSOLE(50,"Main_window::errorManagement","Action returned: "+QString::number(tempr));
				return tempr;
			}
		break;
		case COMBO_ERROR_ATEND:
			if(ButtonActivated!=ERROR_DEF_NOSKIPNOENDOF && ButtonActivated!=ERROR_DEF_NOENDOF)
			{
				numberOfFilePutAtTheEnd++;
				if(CopyList->topLevelItemCount()<(numberOfFilePutAtTheEnd)+2)
				{
					numberOfFilePutAtTheEnd=0;
					comboBox_copyErrors->setCurrentIndex(COMBO_ERROR_ASK);
					DEBUGCONSOLE(90,"Main_window::errorManagement","Action returned: ERRORACTION_RETRY");
					return ERRORACTION_RETRY;
				}
				else
				{
					DEBUGCONSOLE(50,"Main_window::errorManagement","Action returned: ERRORACTION_ENDOF");
					return ERRORACTION_ENDOF;
				}
			}
			else
			{
				comboBox_copyErrors->setCurrentIndex(COMBO_ERROR_ASK);
				int tempr=errorManagement(ButtonActivated,fileOrDir,errorMessage);
				DEBUGCONSOLE(50,"Main_window::errorManagement","Action returned: "+QString::number(tempr));
				return tempr;
			}
		break;
		default:
			DEBUGCONSOLE(10,"Main_window::errorManagement","internal error, the number sould not be "+QString::number(comboBox_copyErrors->currentIndex())+"!");
		break;
	}
	DEBUGCONSOLE(10,"Main_window::errorManagement","internal error, out of switch!");
	return ERRORACTION_SKIP;
}

/// \brief Update the style
void Main_window::UpdateStyle()
{
	//update style here
	skipButton->setIcon(loadImage("player_end.png"));
	cancelButton->setIcon(loadImage("cancel.png"));
	putOnTop->setIcon(loadImage("2uparrow.png"));
	pushUp->setIcon(loadImage("1uparrow.png"));
	pushDown->setIcon(loadImage("1downarrow.png"));
	putOnBottom->setIcon(loadImage("2downarrow.png"));
	add->setIcon(loadImage("add.png"));
	del->setIcon(loadImage("cancel.png"));
	pushButtonSearchPrev->setIcon(loadImage("arrow-left.png"));
	pushButtonSearchNext->setIcon(loadImage("arrow-right.png"));
	pushButtonCloseSearch->setIcon(loadImage("cancel.png"));
	
	actionaddFile->setIcon(loadImage("add.png"));
	actionaddFolder->setIcon(loadImage("add.png"));
	actionRestore->setIcon(loadImage("systray/bottom.png"));
	actionQuit->setIcon(loadImage("exit.png"));
	
	this->setWindowIcon(loadImage("main.png"));
	#ifdef Q_OS_WIN32
	*pixmapTop=loadImagePixmap("systray/top.png");
	*pixmapBottom=loadImagePixmap("systray/bottom.png");
	#else
	*pixmapTop=loadImagePixmap("systray/top_X11.png");
	*pixmapBottom=loadImagePixmap("systray/bottom_X11.png");
	#endif
	if(!moreButton->isDown())
		moreButton->setIcon(loadImage("1downarrow.png"));
	else
		moreButton->setIcon(loadImage("1uparrow.png"));
	if(CopyList->topLevelItemCount()==0)
	{
		actionPause->setIcon(loadImage("player_pause.png"));
		pauseButton->setIcon(loadImage("player_pause.png"));
	}
	else
	{
		if(CopyThread->getCurrentStat()!=copyThread::Stopped)
		{
			actionPause->setIcon(loadImage("player_pause.png"));
			pauseButton->setIcon(loadImage("player_pause.png"));
		}
		else
		{
			actionPause->setIcon(loadImage("player_play.png"));
			pauseButton->setIcon(loadImage("player_play.png"));
		}
	}
	tabWidget->setTabIcon(0,loadImage("player_playlist.png"));
	tabWidget->setTabIcon(1,loadImage("error.png"));
	tabWidget->setTabIcon(2,loadImage("tools.png"));
	tabWidget->setTabIcon(3,loadImage("player_playlist.png"));
	tabWidget->setTabIcon(4,loadImage("advanced.png"));
	//query update style to the child
	emit OrderUpdateStyle();
}

/** \brief Get speed

Abstract Layer for get the speed, it stored in MaxSpeedValueInt
\see MaxSpeedValueInt
*/
void Main_window::abstractLayerGetSpeed()
{
	if(comboBox_TypeSpeedMax->currentText()==tr("Direct value"))
	{
		MaxSpeedValueInt=0;
		if(checkBox_limitSpeed->isChecked())
			MaxSpeedValueInt=limitSpeed->value();
	}
	else
	{
		MaxSpeedValueInt=SliderSpeed->sliderPosition();
		if(MaxSpeedValueInt<0 || MaxSpeedValueInt>7)
			MaxSpeedValueInt=0;
		switch(MaxSpeedValueInt)
		{
			case 1:
				MaxSpeedValueInt=1024;
			break;
			case 2:
				MaxSpeedValueInt=4*1024;
			break;
			case 3:
				MaxSpeedValueInt=8*1024;
			break;
			case 4:
				MaxSpeedValueInt=16*1024;
			break;
			case 5:
				MaxSpeedValueInt=32*1024;
			break;
			case 6:
				MaxSpeedValueInt=64*1024;
			break;
			case 7:
				MaxSpeedValueInt=128*1024;
			break;
		}
		UpdateSliderSpeedText();
	}
	DEBUGCONSOLE(70,"Main_window::abstractLayerGetSpeed","MaxSpeedValueInt: "+QString::number(MaxSpeedValueInt));
	CopyThread->setMaxSpeed(MaxSpeedValueInt);
}

/** \brief Update the speed type

Methode for choise what is the user input methode for give the speed
*/
void Main_window::abstractLayerUpdateSpeedType()
{
	DEBUGCONSOLE(70,"Main_window::abstractLayerUpdateSpeedType","update the speed type");
	if(comboBox_TypeSpeedMax->currentText()==tr("Direct value"))
	{
		label_Slider_speed->setVisible(false);
		SliderSpeed->setVisible(false);
		label_SpeedMaxValue->setVisible(false);
		groupBoxSpeedLimit->setVisible(true);
	}
	else
	{
		label_Slider_speed->setVisible(true);
		SliderSpeed->setVisible(true);
		label_SpeedMaxValue->setVisible(true);
		groupBoxSpeedLimit->setVisible(false);
	}
	abstractLayerSetSpeed(MaxSpeedValueInt);
}

/** \brief Set speed

Abstract layer for set speed
*/
void Main_window::abstractLayerSetSpeed(int speed)
{
	DEBUGCONSOLE(70,"Main_window::abstractLayerSetSpeed","set speed at: "+QString::number(speed));
	if(speed<0)
	{
		DEBUGCONSOLE(10,"Main_window::abstractLayerSetSpeed","speed too low, in negative: "+QString::number(speed));
		speed=0;
	}
	if(!speed)
	{
		MaxSpeedValueInt=0;
		if(comboBox_TypeSpeedMax->currentText()==tr("Direct value"))
		{
			checkBox_limitSpeed->setChecked(false);
			limitSpeed->setEnabled(false);
		}
		else
		{
			SliderSpeed->setSliderPosition(0);
			UpdateSliderSpeedText();
		}
	}
	else
	{
		MaxSpeedValueInt=speed;
		if(comboBox_TypeSpeedMax->currentText()==tr("Direct value"))
		{
			checkBox_limitSpeed->setChecked(true);
			limitSpeed->setEnabled(true);
			limitSpeed->setValue(speed);
		}
		else
		{
			if(speed>=128*1024 || speed<=0)
			{
				SliderSpeed->setSliderPosition(0);
				MaxSpeedValueInt=0;
			}
			else if(speed<=1024)
			{
				SliderSpeed->setSliderPosition(1);
				MaxSpeedValueInt=1024;
			}
			else if(speed<=4*1024)
			{
				SliderSpeed->setSliderPosition(2);
				MaxSpeedValueInt=4*1024;
			}
			else if(speed<=8*1024)
			{
				SliderSpeed->setSliderPosition(3);
				MaxSpeedValueInt=8*1024;
			}
			else if(speed<=16*1024)
			{
				SliderSpeed->setSliderPosition(4);
				MaxSpeedValueInt=16*1024;
			}
			else if(speed<=32*1024)
			{
				SliderSpeed->setSliderPosition(5);
				MaxSpeedValueInt=32*1024;
			}
			else if(speed<=64*1024)
			{
				SliderSpeed->setSliderPosition(6);
				MaxSpeedValueInt=64*1024;
			}
			else if(speed<=128*1024)
			{
				SliderSpeed->setSliderPosition(7);
				MaxSpeedValueInt=128*1024;
			}
			else
			{
				DEBUGCONSOLE(10,"optionsDialog::abstractLayerSetSpeed","error value wrong");
				SliderSpeed->setSliderPosition(0);
				MaxSpeedValueInt=0;
			}
		}
		UpdateSliderSpeedText();
	}
}

/// \brief Update the slider speed text
void Main_window::UpdateSliderSpeedText()
{
	if(MaxSpeedValueInt==0)
		label_SpeedMaxValue->setText(tr("Unlimited"));
	else
		label_SpeedMaxValue->setText(QString::number(MaxSpeedValueInt)+"K"+tr("B")+"/s");
}

/** \brief Close query by the system
\param event System event who call the quit
*/
void Main_window::closeEvent(QCloseEvent * event)
{
	DEBUGCONSOLE(30,"Main_window::closeEvent","Close event detected");
	#if (DEBUG_ULTRACOPIER>0)
	if(event->spontaneous())
		DEBUGCONSOLE(70,"Main_window::closeEvent","event->spontaneous(): True");
	else
		DEBUGCONSOLE(70,"Main_window::closeEvent","event->spontaneous(): False");
	DEBUGCONSOLE(70,"Main_window::closeEvent","event->type(): "+QString::number(event->type()));
	#endif
	//check if it should be reduct in the systray
	if(checkBoxSystray->isChecked() && !this->isHidden() && actionInDialog!=FILEEXIST_CANCEL && actionInDialog!=UC_ERROR_CANCEL)
	{
		event->ignore();
		DEBUGCONSOLE(30,"Main_window::closeEvent","Show systray icon");
		//if is running disable windows info update and update systray icon
		sysTrayIcon->show();
		this->hide();
		updateTheCopyStat();
	}
	else
	{
		event->ignore();
		cancel_copy_window();
	}
}

/** \brief For catch an action on the systray icon
\param reason Why it activated
*/
void Main_window::CatchAction(QSystemTrayIcon::ActivationReason reason)
{
	if(reason==QSystemTrayIcon::DoubleClick)
	{
		RestoreTheWindow();
		DEBUGCONSOLE(30,"Main_window::CatchAction","Double Click detected");
	}
	#if (DEBUG_ULTRACOPIER>0)
	else
		DEBUGCONSOLE(90,"Main_window::CatchAction","reason: "+QString::number(reason));
	#endif
}

/// \brief Restore the window
void Main_window::RestoreTheWindow()
{
	sysTrayIcon->hide();
	this->show();
}

//manage error in listing
void Main_window::ErrorInListing(const QString& folder,const QString& theError)
{
	int action=errorManagement(ERROR_DEF_NOENDOF,folder,theError);
	DEBUGCONSOLE(90,"Main_window::ErrorInListing","folder: \""+folder+"\", the error: "+theError);
	if(action==ERRORACTION_CLOSE)
		cancel_copy_window();
	AddingFolderThread->actionAtError(action);
}


void Main_window::on_pushButtonSaveErrorToFile_clicked()
{
	QString fileName = QFileDialog::getSaveFileName(this, tr("Save file"),
		"ultracopier-error.log",
		tr("Log file")+" (*.log)");
	if(fileName=="")
		 return;
	QString composedStringForLog;
	for(int i=0;i<treeWidgetListError->topLevelItemCount();++i) {
		composedStringForLog+=QDateTime::currentDateTime().toString("MMM d hh:mm:ss")+" ultracopier: ";
		composedStringForLog+=tr("For the file from")+" "+treeWidgetListError->topLevelItem(i)->text(0);
		composedStringForLog+=" ("+treeWidgetListError->topLevelItem(i)->text(1)+")";
		composedStringForLog+=" "+tr("to")+" "+treeWidgetListError->topLevelItem(i)->text(2);
		composedStringForLog+=" "+tr("this error is append:")+" "+treeWidgetListError->topLevelItem(i)->text(3);
		composedStringForLog+="\n";
	}
	QFile file(fileName);
	if(file.open(QIODevice::WriteOnly|QIODevice::Truncate))
	{
		file.write(composedStringForLog.toAscii());
		file.close();
	}
	else
		QMessageBox::critical(this,"Error","Unable to save log:\n"+file.errorString());
}

//can be deleted
bool Main_window::canByDeleted()
{
	bool canByDelete=true;
	DEBUGCONSOLE(90,"Main_window::CatchAction","CopyThread->isFinished(): "+QString::number(CopyThread->isFinished()));
	DEBUGCONSOLE(90,"Main_window::CatchAction","shouldBeClosed: "+QString::number(shouldBeClosed));
	if(!CopyThread->allThreadIsFinish())
		canByDelete=false;
	if(!shouldBeClosed)
		canByDelete=false;
	return canByDelete;
}

//copy thread or write thread is finish
void Main_window::copyThreadOrWriteThread()
{
	if(CopyThread->allThreadIsFinish() && shouldBeClosed)
		emit canDeleteTheObject();
}

#if (DEBUG_ULTRACOPIER>0)
QString Main_window::graphicPointer(QTreeWidgetItem * theItem)
{
	QString x;
	x.sprintf( "0x%p",theItem);
	return x;
}
#endif

