/***************************************************************************
                                 FEwindow.cpp
                             --------------------
 
     Begin        : Sat Oct 20 2007 20:20 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the constructor and the methode of the
                    file exists windows
 
****************************************************************************/

#include "env.h"

#include <QtGui>

#include "FEwindow.h"

/** \brief Initiate the file exists window

Create the file exists window, setup too the action and menu
\param parent The parent of the window
*/
CopyFileExistsWindow::CopyFileExistsWindow(QWidget *parent)
    : QDialog(parent)
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::CopyFileExistsWindow","start");
	//setup the interface
	setupUi(this);
	layout()->setSizeConstraint(QLayout::SetFixedSize);
	
	//setup the menu
	menuOverwrite			= new QMenu("overwrite", this);
	alwaysOverwrite			= new QAction(tr("Always overwrite"), this);
	menuOverwrite->addAction(alwaysOverwrite);
	overwriteIfNotSame		= new QAction(tr("Overwrite if not same"), this);
	menuOverwrite->addAction(overwriteIfNotSame);
	overwriteIfNewer		= new QAction(tr("Overwrite if newer"), this);
	menuOverwrite->addAction(overwriteIfNewer);
	alwaysOverwriteIfNotSame	= new QAction(tr("Always overwrite if not same"), this);
	menuOverwrite->addAction(alwaysOverwriteIfNotSame);
	alwaysOverwriteIfNewer		= new QAction(tr("Always overwrite if newer"), this);
	menuOverwrite->addAction(alwaysOverwriteIfNewer);
	
	menuRename			= new QMenu("rename", this);
	alwaysRename			= new QAction(tr("Always rename"), this);
	menuRename->addAction(alwaysRename);
	
	menuSkip			= new QMenu("skip", this);
	alwaysSkip			= new QAction(tr("Always skip"), this);
	menuSkip->addAction(alwaysSkip);
	
	//connect the button
	connect(pushButton_cancel,	SIGNAL(clicked()), this, SLOT(cancelButton()));
	connect(pushButton_overwrite,	SIGNAL(released()),this, SLOT(overwriteButton()));
	connect(pushButton_rename,	SIGNAL(clicked()), this, SLOT(renameButton()));
	connect(pushButton_skip,	SIGNAL(clicked()), this, SLOT(skipButton()));
	
	connect(alwaysOverwrite,	SIGNAL(triggered()), this, SLOT(overwriteAllways()));
	connect(alwaysRename,		SIGNAL(triggered()), this, SLOT(renameAllways()));
	connect(alwaysSkip,		SIGNAL(triggered()), this, SLOT(skipAllways()));

	connect(overwriteIfNotSame,	SIGNAL(triggered()), this, SLOT(slotOverwriteIfNotSame()));
	connect(alwaysOverwriteIfNotSame,SIGNAL(triggered()),this, SLOT(slotOverwriteAllwaysIfNotSame()));
	connect(overwriteIfNewer,	SIGNAL(triggered()), this, SLOT(slotOverwriteIfNewer()));
	connect(alwaysOverwriteIfNewer, SIGNAL(triggered()), this, SLOT(slotOverwriteAllwaysIfNewer()));
	
	//add the menu
	pushButton_overwrite->setMenu(menuOverwrite);
	pushButton_rename->setMenu(menuRename);
	pushButton_skip->setMenu(menuSkip);
	
	//set the style
	this->UpdateStyle();
}

/** \brief Set text if source and destination is same, with custom text
\param dest The short name of the file
\param text The custom text
*/
void CopyFileExistsWindow::SourceAndDestinationIsSame(const QString& dest,const QString& text)
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::SourceAndDestinationIsSame","custom text");
	label_top_text->setText(text+":");
	label_detailSource->setText(dest.section('/',-2));
	label_detailDestination->setText(dest.section('/',-2));
	pushButton_overwrite->setEnabled(false);
	label_path->setText(QFileInfo(QFileInfo(dest).absolutePath()).absolutePath()+"/");
}

/** \brief Set text if source and destination is same
\param dest The short name of the file
*/
void CopyFileExistsWindow::SourceAndDestinationIsSame(const QString& dest)
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::SourceAndDestinationIsSame","start");
	pushButton_overwrite->setEnabled(false);
	QString path=QFileInfo(dest).absolutePath()+"/";
	label_top_text->setText(tr("The source and the destination are the same in the folder")+":");
	label_path->setText(path);
	QString file=dest.section('/',-1);
	label_detailSource->setText(file);
	label_detailDestination->setText(file);
}

/** \brief Set the text if the window have show if the file already exists
\param path The path of the destination file
\param dest The short name of the file
\param source The short name of the file
*/
void CopyFileExistsWindow::AlreadyExists(QString path,QString source,QString dest)
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::AllReadyExists","path=\""+path+"\", source=\""+source+"\", dest=\""+dest+"\"");
	bool shouldBeRewrite=true;
	while(shouldBeRewrite)
	{
		int firstPos=source.indexOf(QRegExp("[/\\]"));
		firstPos++;
		if(firstPos>0)
		{
			if(source.left(firstPos)==dest.left(firstPos))
			{
				path+=source.left(firstPos);
				source.remove(0,firstPos);
				dest.remove(0,firstPos);
			}
			else
				shouldBeRewrite=false;
		}
		else
			shouldBeRewrite=false;
	}
	label_path->setText(path);
	label_detailSource->setText(source);
	if(dest=="")
		label_detailDestination->setText(source);
	else
		label_detailDestination->setText(dest);
}

void CopyFileExistsWindow::cancelButton()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::cancelButton","emit ActionOnFileExists(FILEEXIST_CANCEL)");
	emit ActionOnFileExists(FILEEXIST_CANCEL);
	this->close();
}

void CopyFileExistsWindow::overwriteButton()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::overwriteButton","emit ActionOnFileExists(FILEEXIST_OVERWRITE)");
	emit ActionOnFileExists(FILEEXIST_OVERWRITE);
	this->close();
}

void CopyFileExistsWindow::overwriteAllways()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::overwriteAllways","emit ActionOnFileExists(FILEEXIST_OVERWRITE_ALL)");
	emit ActionOnFileExists(FILEEXIST_OVERWRITE_ALL);
	this->close();
}

void CopyFileExistsWindow::renameButton()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::renameButton","emit ActionOnFileExists(FILEEXIST_RENAME)");
	emit ActionOnFileExists(FILEEXIST_RENAME);
	this->close();
}

void CopyFileExistsWindow::renameAllways()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::renameAllways","emit ActionOnFileExists(FILEEXIST_RENAME_ALL)");
	emit ActionOnFileExists(FILEEXIST_RENAME_ALL);
	this->close();
}

void CopyFileExistsWindow::skipButton()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::skipButton","emit ActionOnFileExists(FILEEXIST_SKIP)");
	emit ActionOnFileExists(FILEEXIST_SKIP);
	this->close();
}

void CopyFileExistsWindow::skipAllways()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::skipAllways","emit ActionOnFileExists(FILEEXIST_SKIP_ALL)");
	emit ActionOnFileExists(FILEEXIST_SKIP_ALL);
	this->close();
}

void CopyFileExistsWindow::slotOverwriteIfNotSame()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::overwriteIfNotSame","emit ActionOnFileExists(OVERWRITE_IFNOTSAME)");
	emit ActionOnFileExists(FILEEXIST_OVERWRITE_IFNOTSAME);
	this->close();
}

void CopyFileExistsWindow::slotOverwriteAllwaysIfNotSame()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::overwriteAllwaysIfNotSame","emit ActionOnFileExists(OVERWRITE_ALL_IFNOTSAME)");
	emit ActionOnFileExists(FILEEXIST_OVERWRITE_ALL_IFNOTSAME);
	this->close();
}

void CopyFileExistsWindow::slotOverwriteIfNewer()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::overwriteIfNewer","emit ActionOnFileExists(OVERWRITE_ALL_IFNEWER)");
	emit ActionOnFileExists(FILEEXIST_OVERWRITE_IFNEWER);
	this->close();
}

void CopyFileExistsWindow::slotOverwriteAllwaysIfNewer()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::overwriteAllwaysIfNewer","emit ActionOnFileExists(OVERWRITE_ALL_IFNEWER)");
	emit ActionOnFileExists(FILEEXIST_OVERWRITE_ALL_IFNEWER);
	this->close();
}


/// \brief Update the window style
void CopyFileExistsWindow::UpdateStyle()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::UpdateStyle","start");
	//update style here
	icon->setPixmap(loadImagePixmap("big/save.png"));
	pushButton_overwrite->setIcon(loadImage("overwrite.png"));
	pushButton_rename->setIcon(loadImage("rename.png"));
	pushButton_skip->setIcon(loadImage("player_end.png"));
	pushButton_cancel->setIcon(loadImage("cancel.png"));
	this->setWindowIcon(loadImage("reload.png"));
}

/// \brief The destructor
CopyFileExistsWindow::~CopyFileExistsWindow()
{
	DEBUGCONSOLE(70,"CopyFileExistsWindow::~CopyFileExistsWindow","start");
	delete menuOverwrite;
	delete alwaysOverwrite;
	delete menuRename;
	delete alwaysRename;
	delete menuSkip;
	delete alwaysSkip;
}
