;; pinyin-big5.scm
;;
;; Copyright (C) 2004-2012 uim Project http://code.google.com/p/uim/
;;
;; Original table is come from XCIN Project http://xcin.linux.org.tw/
;; cin/big5/pinyin.cin
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;

(define pinyin-big5-rule
  '(((("a")) ("阿" "ㄚ" "啊"))
    ((("a" "i")) ("唉" "哀" "埃" "挨" "哎" "ㄞ" "捱" "呆" "癌" "皚" "矮" "藹" "靄" "欸" "毐" "愛" "礙" "艾" "曖" "璦" "隘" "噯" "嬡"))
    ((("a" "n")) ("安" "鞍" "庵" "諳" "氨" "銨" "ㄢ" "鵪" "桉" "盦" "俺" "唵" "案" "按" "暗" "岸" "黯" "闇" "犴"))
    ((("a" "n" "g")) ("骯" "ㄤ" "昂" "盎"))
    ((("a" "o")) ("凹" "坳" "ㄠ" "熬" "敖" "遨" "翱" "嗷" "螯" "鰲" "鼇" "驁" "獒" "襖" "拗" "媼" "傲" "澳" "奧" "懊"))
    ((("b")) ("ㄅ"))
    ((("b" "a")) ("八" "巴" "捌" "疤" "芭" "笆" "粑" "叭" "朳" "拔" "跋" "鈸" "把" "靶" "爸" "罷" "霸" "壩" "灞" "耙" "吧"))
    ((("b" "a" "i")) ("掰" "白" "百" "佰" "擺" "襬" "柏" "敗" "拜"))
    ((("b" "a" "n")) ("般" "搬" "班" "斑" "頒" "扳" "攽" "板" "版" "闆" "阪" "舨" "半" "辦" "伴" "扮" "拌" "絆" "瓣" "爿"))
    ((("b" "a" "n" "g")) ("幫" "邦" "梆" "榜" "綁" "膀" "棒" "磅" "謗" "蚌" "傍" "鎊" "£"))
    ((("b" "a" "o")) ("包" "胞" "苞" "褒" "煲" "薄" "雹" "保" "寶" "飽" "堡" "褓" "葆" "鴇" "報" "抱" "暴" "爆" "豹" "趵" "鮑" "刨" "菢"))
    ((("b" "e" "i")) ("悲" "杯" "卑" "碑" "俾" "揹" "盃" "背" "北" "被" "備" "貝" "輩" "倍" "臂" "狽" "憊" "悖" "孛" "焙" "蓓" "唄"))
    ((("b" "e" "n")) ("奔" "賁" "錛" "本" "苯" "畚" "笨"))
    ((("b" "e" "n" "g")) ("崩" "繃" "甭" "蹦" "迸"))
    ((("b" "i")) ("逼" "鼻" "比" "筆" "彼" "鄙" "匕" "秕" "妣" "必" "敝" "畢" "壁" "璧" "碧" "避" "閉" "幣" "弊" "斃" "蔽" "臂" "泌" "婢" "俾" "庇" "嗶" "愎" "辟" "弼" "裨" "陛" "篦" "畀" "嬖" "睥" "襞" "篳" "蹕" "髀" "痺" "毖"))
    ((("b" "i" "a" "n")) ("邊" "編" "鞭" "蝙" "砭" "扁" "貶" "匾" "便" "變" "遍" "辨" "辯" "汴" "卞" "辮" "弁"))
    ((("b" "i" "a" "o")) ("標" "彪" "鑣" "鏢" "飆" "膘" "表" "錶" "婊" "裱" "鰾"))
    ((("b" "i" "e")) ("憋" "鱉" "癟" "別" "蹩" "彆"))
    ((("b" "i" "n")) ("賓" "濱" "繽" "瀕" "檳" "斌" "彬" "儐" "豳" "殯" "鬢" "擯" "髕"))
    ((("b" "i" "n" "g")) ("冰" "兵" "餅" "丙" "稟" "柄" "秉" "炳" "昺" "並" "病" "併" "并" "摒"))
    ((("b" "o")) ("波" "玻" "撥" "剝" "菠" "缽" "ㄅ" "伯" "博" "柏" "泊" "勃" "搏" "渤" "駁" "薄" "礴" "脖" "帛" "舶" "箔" "蔔" "膊" "鈸" "餑" "鉑" "鵓" "踣" "亳" "跛" "簸" "播" "擘"))
    ((("b" "u")) ("逋" "晡" "補" "捕" "埔" "哺" "堡" "卜" "不" "部" "布" "步" "怖" "佈" "簿" "埠"))
    ((("c")) ("ㄘ"))
    ((("c" "a")) ("擦"))
    ((("c" "a" "i")) ("猜" "才" "財" "材" "裁" "採" "彩" "采" "睬" "踩" "綵" "菜" "蔡" "埰"))
    ((("c" "a" "n")) ("參" "餐" "驂" "殘" "蠶" "慚" "慘" "燦" "孱" "璨" "粲"))
    ((("c" "a" "n" "g")) ("蒼" "倉" "滄" "艙" "藏"))
    ((("c" "a" "o")) ("操" "糙" "曹" "槽" "嘈" "漕" "螬" "艚" "草" "艸"))
    ((("c" "e")) ("冊" "策" "測" "側" "廁" "惻"))
    ((("c" "e" "n")) ("參" "岑" "涔"))
    ((("c" "e" "n" "g")) ("噌" "曾" "層" "嶒" "蹭"))
    ((("c" "h" "a")) ("差" "插" "叉" "喳" "杈" "查" "察" "茶" "搽" "槎" "詫" "岔" "剎" "汊" "衩"))
    ((("c" "h" "a" "i")) ("拆" "釵" "差" "柴" "豺" "儕" "蠆"))
    ((("c" "h" "a" "n")) ("攙" "纏" "蟬" "禪" "饞" "讒" "潺" "蟾" "巉" "嬋" "澶" "廛" "孱" "鑱" "產" "鏟" "闡" "剷" "諂" "懺"))
    ((("c" "h" "a" "n" "g")) ("昌" "倡" "猖" "娼" "菖" "倀" "長" "常" "場" "嘗" "裳" "償" "腸" "嫦" "徜" "嚐" "廠" "敞" "氅" "昶" "唱" "暢" "悵" "鬯"))
    ((("c" "h" "a" "o")) ("抄" "鈔" "超" "勦" "怊" "剿" "朝" "潮" "巢" "嘲" "晁" "吵" "炒"))
    ((("c" "h" "e")) ("車" "扯" "徹" "澈" "轍" "撤" "掣" "坼"))
    ((("c" "h" "e" "n")) ("嗔" "琛" "瞋" "郴" "陳" "沉" "晨" "臣" "塵" "辰" "忱" "諶" "磣" "趁" "襯" "讖"))
    ((("c" "h" "e" "n" "g")) ("稱" "撐" "瞠" "蟶" "琤" "成" "程" "承" "乘" "誠" "呈" "城" "懲" "澄" "橙" "丞" "澂" "酲" "晟" "裎" "埕" "逞" "騁" "秤"))
    ((("c" "h")) ("ㄔ"))
    ((("c" "h" "i")) ("吃" "蚩" "癡" "痴" "嗤" "喫" "ㄔ" "魑" "笞" "鴟" "媸" "眵" "持" "池" "遲" "馳" "匙" "弛" "踟" "墀" "尺" "齒" "恥" "呎" "侈" "褫" "豉" "赤" "翅" "斥" "飭" "叱" "熾" "啻" "敕" "彳"))
    ((("c" "h" "o" "n" "g")) ("充" "衝" "沖" "涌" "舂" "忡" "憧" "翀" "重" "崇" "蟲" "虫" "寵" "銃"))
    ((("c" "h" "o" "u")) ("抽" "愁" "仇" "籌" "綢" "酬" "稠" "紬" "躊" "疇" "惆" "裯" "儔" "讎" "丑" "醜" "瞅" "臭"))
    ((("c" "h" "u")) ("出" "初" "齣" "除" "儲" "廚" "鋤" "櫥" "雛" "芻" "躇" "滁" "躕" "蜍" "鉏" "鶵" "處" "楚" "礎" "杵" "褚" "楮" "觸" "畜" "搐" "絀" "矗" "黜" "俶" "怵"))
    ((("c" "h" "u" "a" "i")) ("揣" "踹"))
    ((("c" "h" "u" "a" "n")) ("穿" "川" "傳" "船" "遄" "椽" "喘" "串" "釧"))
    ((("c" "h" "u" "a" "n" "g")) ("窗" "創" "瘡" "囪" "床" "幢" "闖" "愴"))
    ((("c" "h" "u" "i")) ("吹" "炊" "垂" "鎚" "槌" "搥" "椎" "陲" "錘" "捶" "棰"))
    ((("c" "h" "u" "n")) ("春" "椿" "純" "唇" "醇" "淳" "鶉" "脣" "蠢"))
    ((("c" "h" "u" "o")) ("戳" "綽" "輟" "齪" "啜" "惙" "醊"))
    ((("c" "i")) ("疵" "雌" "ㄘ" "差" "詞" "辭" "慈" "磁" "瓷" "祠" "茨" "餈" "此" "泚" "次" "刺" "賜" "廁" "伺"))
    ((("c" "o" "n" "g")) ("匆" "聰" "從" "囪" "叢" "淙" "琮"))
    ((("c" "o" "u")) ("湊"))
    ((("c" "u")) ("粗" "殂" "徂" "促" "醋" "簇" "蹴" "蹙" "猝" "鏃" "踧"))
    ((("c" "u" "a" "n")) ("攛" "躥" "攢" "竄" "篡" "爨" "篹"))
    ((("c" "u" "i")) ("摧" "催" "崔" "榱" "衰" "璀" "翠" "脆" "粹" "悴" "瘁" "萃" "啐" "淬" "橇"))
    ((("c" "u" "n")) ("村" "存" "忖" "寸" "吋"))
    ((("c" "u" "o")) ("搓" "撮" "磋" "蹉" "嵯" "錯" "措" "挫" "銼" "厝"))
    ((("d")) ("ㄉ"))
    ((("d" "d" "d")) ("、"))
    ((("d")) ("的"))
    ((("d" "a")) ("搭" "答" "咑" "達" "韃" "靼" "瘩" "怛" "妲" "笪" "打" "大"))
    ((("d" "a" "i")) ("呆" "獃" "歹" "逮" "代" "帶" "待" "袋" "戴" "怠" "殆" "黛" "貸" "迨" "玳" "岱"))
    ((("d" "a" "n")) ("單" "擔" "丹" "耽" "簞" "鄲" "眈" "聃" "酖" "儋" "膽" "疸" "撢" "亶" "但" "旦" "淡" "蛋" "誕" "彈" "憚" "氮" "啖" "澹"))
    ((("d" "a" "n" "g")) ("當" "噹" "鐺" "襠" "擋" "黨" "讜" "檔" "蕩" "盪" "宕"))
    ((("d" "a" "o")) ("刀" "叨" "忉" "倒" "島" "導" "禱" "搗" "到" "道" "稻" "盜" "蹈" "悼" "纛"))
    ((("d" "d")) ("，"))
    ((("d" "e")) ("ㄉ" "得" "德" "的" "地" "底"))
    ((("d" "e" "i")) ("得"))
    ((("d" "e" "n" "g")) ("登" "燈" "簦" "等" "戥" "鄧" "瞪" "蹬" "凳" "磴"))
    ((("d" "i")) ("低" "滴" "堤" "隄" "提" "氐" "羝" "的" "敵" "迪" "狄" "笛" "滌" "翟" "荻" "嘀" "鏑" "蹢" "糴" "底" "抵" "邸" "詆" "牴" "砥" "柢" "地" "第" "弟" "帝" "遞" "蒂" "締" "諦" "娣" "睇" "棣"))
    ((("d" "i" "a" "n")) ("顛" "巔" "癲" "滇" "掂" "點" "典" "碘" "電" "店" "殿" "甸" "奠" "墊" "澱" "惦" "癜" "靛" "佃" "淀" "玷" "鈿"))
    ((("d" "i" "a" "o")) ("雕" "凋" "刁" "貂" "鵰" "碉" "叼" "彫" "屌" "調" "掉" "釣" "吊" "弔" "蓧"))
    ((("d" "i" "e")) ("爹" "跌" "碟" "蝶" "諜" "疊" "迭" "牒" "喋" "瓞" "咥" "垤" "蹀"))
    ((("d" "i" "n" "g")) ("丁" "釘" "叮" "疔" "酊" "盯" "仃" "頂" "鼎" "定" "訂" "錠" "碇"))
    ((("d" "i" "u")) ("丟"))
    ((("d" "o" "n" "g")) ("東" "冬" "咚" "鼕" "懂" "董" "動" "洞" "凍" "棟" "恫" "胴"))
    ((("d" "o" "u")) ("都" "兜" "斗" "抖" "陡" "蚪" "枓" "鬥" "豆" "荳" "逗" "痘" "竇" "餖" "讀"))
    ((("d" "u")) ("都" "督" "嘟" "讀" "獨" "毒" "牘" "纛" "瀆" "犢" "黷" "賭" "睹" "篤" "堵" "肚" "度" "渡" "杜" "妒" "鍍" "蠹" "℃" "°" "℉"))
    ((("d" "u" "a" "n")) ("端" "耑" "短" "段" "斷" "緞" "鍛"))
    ((("d" "u" "i")) ("堆" "對" "隊" "兌" "懟"))
    ((("d" "u" "n")) ("敦" "蹲" "墩" "惇" "礅" "噸" "盹" "躉" "頓" "盾" "鈍" "遁" "燉" "沌" "、" "炖"))
    ((("d" "u" "o")) ("多" "哆" "咄" "剟" "掇" "裰" "奪" "度" "踱" "鐸" "躲" "朵" "埵" "垛" "惰" "墮" "舵" "跺" "剁" "馱"))
    ((("e")) ("阿" "婀" "痾" "欸" "ㄜ" "ㄝ" "屙" "額" "訛" "鵝" "娥" "哦" "蛾" "峨" "莪" "俄" "惡" "餓" "厄" "遏" "扼" "鱷" "顎" "呃" "愕" "噩" "軛" "鄂" "鍔" "鶚" "諤" "萼" "頞"))
    ((("e" "i")) ("欸" "ㄟ"))
    ((("e" "n")) ("恩" "奀" "ㄣ" "摁"))
    ((("e" "n" "g")) ("ㄥ"))
    ((("e" "r")) ("ㄦ" "而" "兒" "爾" "耳" "洱" "餌" "邇" "二" "貳" "佴"))
    ((("f")) ("ㄈ"))
    ((("f" "a")) ("發" "乏" "伐" "罰" "閥" "筏" "砝" "法" "髮" "琺"))
    ((("f" "a" "n")) ("番" "翻" "蕃" "繙" "幡" "帆" "凡" "煩" "繁" "礬" "藩" "樊" "膰" "反" "返" "範" "范" "犯" "氾" "汎" "飯" "販" "泛" "梵" "畈"))
    ((("f" "a" "n" "g")) ("方" "芳" "坊" "枋" "□" "房" "防" "妨" "肪" "訪" "彷" "仿" "紡" "倣" "舫" "昉" "髣" "放"))
    ((("f" "e" "i")) ("非" "飛" "菲" "扉" "啡" "妃" "緋" "霏" "肥" "淝" "腓" "匪" "翡" "斐" "蜚" "誹" "悱" "榧" "廢" "費" "肺" "沸" "吠" "痱" "怫" "芾" "狒" "剕"))
    ((("f" "e" "n")) ("分" "紛" "芬" "氛" "吩" "棻" "墳" "焚" "汾" "棼" "濆" "粉" "份" "忿" "奮" "憤" "糞"))
    ((("f" "e" "n" "g")) ("風" "蜂" "封" "豐" "瘋" "峰" "鋒" "丰" "烽" "楓" "酆" "葑" "灃" "逢" "縫" "馮" "諷" "奉" "鳳" "俸"))
    ((("f" "o")) ("ㄈ" "佛"))
    ((("f" "o" "u")) ("否" "缶"))
    ((("f" "u")) ("夫" "膚" "敷" "孵" "伕" "麩" "跗" "服" "福" "扶" "浮" "符" "伏" "彿" "幅" "俘" "拂" "弗" "孚" "袱" "芙" "苻" "輻" "蝠" "匐" "怫" "茯" "蜉" "氟" "府" "腐" "撫" "輔" "甫" "斧" "俯" "釜" "脯" "腑" "拊" "父" "負" "婦" "付" "附" "富" "復" "副" "傅" "覆" "複" "腹" "咐" "赴" "賦" "縛" "駙" "訃" "阜" "馥"))
    ((("g")) ("ㄍ"))
    ((("g" "a")) ("嘎" "旮" "咖" "軋" "噶" "尬"))
    ((("g" "a" "i")) ("該" "垓" "賅" "改" "概" "蓋" "丐" "鈣" "溉"))
    ((("g" "a" "n")) ("乾" "甘" "干" "竿" "肝" "尷" "柑" "泔" "疳" "杆" "敢" "感" "趕" "桿" "橄" "稈" "澉" "幹" "贛" "淦" "紺" "榦"))
    ((("g" "a" "n" "g")) ("剛" "鋼" "缸" "崗" "綱" "岡" "肛" "扛" "罡" "港" "槓"))
    ((("g" "a" "o")) ("高" "糕" "膏" "篙" "羔" "睾" "皋" "稿" "攪" "搞" "槁" "縞" "杲" "告" "誥" "郜"))
    ((("g" "e")) ("哥" "歌" "割" "鴿" "擱" "胳" "戈" "疙" "咯" "ㄍ" "格" "革" "隔" "閣" "葛" "骼" "蛤" "膈" "嗝" "□" "轕" "閤" "鎘" "舸" "各" "個" "鉻" "箇"))
    ((("g" "e" "i")) ("給"))
    ((("g" "e" "n")) ("跟" "根" "艮" "亙"))
    ((("g" "e" "n" "g")) ("更" "耕" "庚" "羹" "賡" "鶊" "梗" "耿" "哽" "綆" "鯁" "埂" "骾"))
    ((("g" "o" "n" "g")) ("工" "公" "功" "供" "攻" "宮" "恭" "躬" "弓" "蚣" "龔" "肱" "觥" "鞏" "拱" "汞" "栱" "共" "貢"))
    ((("g" "o" "u")) ("溝" "勾" "鉤" "句" "狗" "茍" "岣" "枸" "夠" "購" "垢" "構" "媾" "彀" "搆" "詬"))
    ((("g" "u")) ("姑" "孤" "辜" "咕" "沽" "估" "菇" "菰" "呱" "蛄" "箍" "鴣" "觚" "酤" "骨" "股" "古" "鼓" "谷" "穀" "賈" "蠱" "牯" "罟" "詁" "轂" "鵠" "瞽" "汨" "鈷" "故" "固" "顧" "雇" "僱" "錮" "痼" "梏"))
    ((("g" "u" "a")) ("瓜" "括" "刮" "颳" "呱" "寡" "剮" "掛" "卦" "褂" "挂"))
    ((("g" "u" "a" "i")) ("乖" "拐" "枴" "怪"))
    ((("g" "u" "a" "n")) ("官" "關" "觀" "冠" "棺" "矜" "鰥" "綸" "倌" "莞" "管" "館" "琯" "慣" "貫" "灌" "罐" "摜" "盥" "鸛"))
    ((("g" "u" "a" "n" "g")) ("光" "胱" "洸" "桄" "廣" "獷" "逛"))
    ((("g" "u" "i")) ("歸" "規" "龜" "瑰" "閨" "圭" "珪" "皈" "傀" "鮭" "鬼" "軌" "詭" "癸" "晷" "簋" "貴" "桂" "櫃" "劊" "檜" "柜" "跪" "劌" "鱖"))
    ((("g" "u" "n")) ("滾" "袞" "鯀" "棍"))
    ((("g" "u" "o")) ("郭" "鍋" "聒" "嘓" "國" "幗" "虢" "摑" "果" "裹" "槨" "蜾" "過"))
    ((("h")) ("ㄏ"))
    ((("h" "a")) ("哈" "蛤"))
    ((("h" "a" "i")) ("咳" "嗨" "還" "孩" "骸" "頦" "海" "醢" "害" "亥" "駭" "氦" "嗐"))
    ((("h" "a" "n")) ("酣" "鼾" "蚶" "憨" "頇" "寒" "含" "函" "涵" "韓" "邯" "汗" "邗" "喊" "罕" "漢" "旱" "焊" "憾" "翰" "撼" "悍" "頷" "瀚" "捍"))
    ((("h" "a" "n" "g")) ("行" "航" "杭" "吭" "巷" "沆"))
    ((("h" "a" "o")) ("蒿" "嚆" "號" "毫" "豪" "壕" "濠" "蠔" "貉" "嚎" "嗥" "好" "郝" "耗" "浩" "皓" "鎬" "昊" "灝" "顥" "鄗" "皞"))
    ((("h" "e")) ("喝" "呵" "訶" "ㄏ" "和" "合" "何" "河" "荷" "核" "盒" "禾" "褐" "劾" "闔" "閤" "曷" "龢" "涸" "盍" "覈" "貉" "閡" "紇" "翮" "鞨" "賀" "鶴" "嚇" "赫" "壑"))
    ((("h" "e" "i")) ("黑" "嘿"))
    ((("h" "e" "n")) ("痕" "很" "狠" "恨"))
    ((("h" "e" "n" "g")) ("亨" "哼" "脝" "橫" "恆" "衡" "珩" "蘅" "桁" "姮"))
    ((("h" "n" "g")) ("哼"))
    ((("h" "o" "n" "g")) ("轟" "哄" "烘" "薨" "訇" "紅" "洪" "宏" "鴻" "虹" "弘" "泓" "訌" "閎" "黌" "竑" "鬨" "蕻"))
    ((("h" "o" "u")) ("猴" "侯" "喉" "篌" "餱" "吼" "後" "候" "厚" "后" "鱟" "垕" "逅"))
    ((("h" "u")) ("忽" "呼" "乎" "惚" "胡" "湖" "壺" "蝴" "糊" "狐" "弧" "葫" "鬍" "瑚" "餬" "斛" "鵠" "囫" "縠" "觳" "猢" "虎" "琥" "滸" "唬" "護" "戶" "互" "滬" "扈" "瓠" "怙" "祜" "笏" "岵"))
    ((("h" "u" "a")) ("花" "華" "嘩" "滑" "划" "譁" "猾" "驊" "鏵" "話" "化" "畫" "劃" "樺"))
    ((("h" "u" "a" "i")) ("懷" "淮" "徊" "槐" "踝" "壞"))
    ((("h" "u" "a" "n")) ("歡" "驩" "獾" "懽" "還" "環" "桓" "繯" "鬟" "鍰" "鐶" "寰" "緩" "換" "喚" "宦" "患" "幻" "煥" "奐" "渙" "瘓" "豢" "鯇" "擐" "漶"))
    ((("h" "u" "a" "n" "g")) ("荒" "慌" "肓" "黃" "徨" "惶" "簧" "璜" "磺" "蝗" "煌" "皇" "凰" "遑" "隍" "潢" "篁" "喤" "艎" "蟥" "謊" "恍" "晃" "幌"))
    ((("h" "u" "i")) ("灰" "揮" "輝" "恢" "詼" "暉" "麾" "徽" "隳" "琿" "回" "迴" "蛔" "茴" "洄" "悔" "毀" "燬" "譭" "會" "惠" "匯" "繪" "慧" "彙" "穢" "誨" "賄" "晦" "彗" "諱" "潰" "卉" "蕙" "檜" "燴" "喙" "薈" "蟪"))
    ((("h" "u" "n")) ("婚" "昏" "葷" "閽" "惛" "魂" "渾" "餛" "混" "琿" "溷" "諢"))
    ((("h" "u" "o")) ("豁" "活" "火" "伙" "夥" "或" "穫" "獲" "和" "惑" "禍" "霍" "貨" "壑" "蠖" "鑊" "藿"))
    ((("i")) ("ㄧ" "〡"))
    ((("j")) ("ㄐ"))
    ((("j" "i")) ("機" "基" "積" "績" "蹟" "激" "跡" "姬" "雞" "饑" "肌" "稽" "飢" "緝" "畸" "箕" "譏" "磯" "羈" "畿" "嵇" "几" "嘰" "屐" "璣" "圾" "躋" "乩" "唧" "勣" "犄" "剞" "机" "ㄐ" "及" "級" "極" "即" "集" "急" "擊" "疾" "籍" "藉" "吉" "寂" "輯" "脊" "嫉" "亟" "棘" "汲" "瘠" "楫" "岌" "笈" "戢" "殛" "蹐" "伋" "蒺" "佶" "詰" "踖" "幾" "給" "己" "紀" "擠" "戟" "濟" "掎" "記" "既" "計" "際" "繼" "季" "寄" "技" "妓" "劑" "繫" "悸" "祭" "忌" "暨" "冀" "鯽" "稷" "薺" "驥" "霽" "薊" "髻" "覬" "伎" "洎" "跽"))
    ((("j" "i" "a")) ("家" "加" "嘉" "佳" "傢" "迦" "枷" "痂" "笳" "茄" "袈" "珈" "葭" "鎵" "夾" "嗧" "挾" "頰" "蛺" "戛" "鋏" "假" "甲" "賈" "鉀" "岬" "胛" "價" "架" "駕" "嫁" "稼"))
    ((("j" "i" "a" "n")) ("間" "監" "堅" "尖" "兼" "肩" "艱" "奸" "姦" "煎" "緘" "漸" "箋" "殲" "菅" "鞬" "牋" "縑" "湔" "蒹" "鶼" "犍" "櫼" "搛" "簡" "撿" "檢" "剪" "減" "揀" "繭" "儉" "鹼" "柬" "筧" "翦" "謇" "蹇" "譾" "見" "建" "健" "件" "鍵" "鑑" "箭" "劍" "艦" "鑒" "賤" "踐" "諫" "毽" "薦" "餞" "腱" "濺" "僭" "檻" "澗" "荐" "→" "↑" "↓" "←"))
    ((("j" "i" "a" "n" "g")) ("將" "江" "疆" "僵" "薑" "殭" "韁" "姜" "漿" "講" "獎" "蔣" "槳" "降" "匠" "醬" "絳" "糨"))
    ((("j" "i" "a" "o")) ("交" "教" "膠" "驕" "焦" "嬌" "郊" "跤" "澆" "蛟" "蕉" "礁" "椒" "茭" "姣" "嚼" "腳" "角" "繳" "攪" "勦" "矯" "絞" "佼" "餃" "皎" "僥" "剿" "鉸" "狡" "撟" "叫" "校" "較" "覺" "轎" "窖" "醮" "徼" "斠" "滘"))
    ((("j" "i" "e")) ("街" "接" "皆" "階" "揭" "偕" "嗟" "楬" "結" "癤" "節" "潔" "傑" "捷" "竭" "劫" "截" "杰" "頡" "詰" "桀" "睫" "訐" "拮" "羯" "桔" "孑" "絜" "偈" "婕" "碣" "解" "姐" "界" "借" "介" "戒" "藉" "屆" "疥" "芥" "誡" "唶" "玠" "蚧" "价"))
    ((("j" "i" "n")) ("今" "金" "禁" "津" "斤" "巾" "筋" "襟" "矜" "衿" "觔" "緊" "僅" "錦" "謹" "儘" "瑾" "饉" "巹" "進" "近" "盡" "晉" "浸" "勁" "覲" "燼" "噤" "妗" "靳" "縉" "搢" "殣"))
    ((("j" "i" "n" "g")) ("經" "精" "京" "驚" "睛" "莖" "晶" "菁" "兢" "涇" "鯨" "荊" "旌" "粳" "景" "警" "井" "頸" "阱" "儆" "璟" "憬" "剄" "敬" "竟" "鏡" "靜" "境" "淨" "競" "逕" "徑" "靖" "勁" "脛" "痙" "靚"))
    ((("j" "i" "o" "n" "g")) ("坰" "窘" "迥" "炯" "炅" "絅" "冏" "熲"))
    ((("j" "i" "u")) ("糾" "揪" "啾" "鳩" "轇" "九" "久" "酒" "玖" "赳" "灸" "韭" "就" "究" "救" "舊" "舅" "臼" "柩" "疚" "咎" "鷲" "廄" "僦"))
    ((("j" "j")) ("。"))
    ((("j" "u")) ("居" "拘" "駒" "疽" "狙" "車" "据" "琚" "雎" "局" "鞠" "菊" "橘" "掬" "跼" "桔" "鞫" "侷" "焗" "舉" "矩" "咀" "莒" "沮" "齟" "櫸" "筥" "踽" "據" "句" "具" "巨" "劇" "聚" "俱" "拒" "距" "鋸" "懼" "鉅" "炬" "詎" "遽" "倨" "瞿" "踞" "颶" "苣" "屨" "醵"))
    ((("j" "u" "a" "n")) ("捐" "娟" "鵑" "涓" "鐫" "圈" "蠲" "朘" "捲" "卷" "倦" "眷" "絹" "雋" "狷"))
    ((("j" "u" "e")) ("噘" "嗟" "撅" "決" "覺" "絕" "角" "爵" "掘" "嚼" "訣" "厥" "獗" "蹶" "蕨" "崛" "攫" "倔" "抉" "噱" "矍" "孓" "玨" "橛" "爝" "譎" "鐍"))
    ((("j" "u" "n")) ("軍" "君" "均" "鈞" "麇" "皸" "莙" "菌" "郡" "俊" "峻" "竣" "雋" "濬" "駿" "浚" "珺" "畯"))
    ((("k")) ("ㄎ"))
    ((("[")) ("（"))
    ((("]")) ("）"))
    ((("[")) ("【"))
    ((("]")) ("】"))
    ((("[")) ("｛"))
    ((("]")) ("｝"))
    ((("[")) ("〔"))
    ((("]")) ("〕"))
    ((("[")) ("︵"))
    ((("]")) ("︶"))
    ((("[")) ("︻"))
    ((("]")) ("︼"))
    ((("[")) ("︷"))
    ((("]")) ("︸"))
    ((("[")) ("︹"))
    ((("]")) ("︺"))
    ((("k" "a")) ("咖" "喀" "卡" "咭" "咯"))
    ((("k" "a" "i")) ("開" "揩" "凱" "楷" "慨" "愷" "剴" "鎧" "闓" "鍇" "愾" "欬"))
    ((("k" "a" "n")) ("刊" "堪" "勘" "戡" "看" "龕" "砍" "侃" "坎" "檻" "瞰" "崁" "闞" "磡" "墈"))
    ((("k" "a" "n" "g")) ("康" "慷" "糠" "扛" "抗" "亢" "炕" "伉"))
    ((("k" "a" "o")) ("考" "烤" "拷" "栲" "攷" "靠" "銬" "犒"))
    ((("k" "e")) ("科" "棵" "顆" "柯" "苛" "瞌" "磕" "蝌" "軻" "稞" "珂" "窠" "鈳" "ㄎ" "咳" "殼" "可" "渴" "坷" "客" "克" "課" "刻" "剋" "溘" "恪" "嗑" "兛"))
    ((("k" "e" "i")) ("剋"))
    ((("k" "e" "n")) ("肯" "啃" "墾" "懇" "齦" "掯"))
    ((("k" "e" "n" "g")) ("坑" "鏗" "硜" "吭"))
    ((("k" "o" "n" "g")) ("空" "崆" "箜" "恐" "孔" "倥" "控"))
    ((("k" "o" "u")) ("摳" "口" "扣" "寇" "叩" "蔻" "筘"))
    ((("k" "u")) ("哭" "枯" "窟" "骷" "刳" "苦" "庫" "褲" "酷" "嚳"))
    ((("k" "u" "a")) ("誇" "夸" "垮" "侉" "跨" "胯" "挎"))
    ((("k" "u" "a" "i")) ("蒯" "快" "塊" "會" "筷" "儈" "獪" "澮" "膾" "噲" "鄶"))
    ((("k" "u" "a" "n")) ("寬" "款"))
    ((("k" "u" "a" "n" "g")) ("匡" "框" "筐" "誆" "劻" "狂" "誑" "況" "礦" "曠" "眶" "鄺" "壙"))
    ((("k" "u" "i")) ("虧" "窺" "盔" "闚" "刲" "悝" "葵" "睽" "奎" "揆" "魁" "逵" "夔" "暌" "馗" "傀" "跬" "愧" "潰" "匱" "饋" "喟" "簣" "聵" "憒"))
    ((("k" "u" "n")) ("昆" "崑" "坤" "琨" "錕" "焜" "髡" "捆" "綑" "悃" "困" "睏"))
    ((("k" "u" "o")) ("括" "擴" "闊" "廓" "蛞" "（" "）" "【" "】"))
    ((("l")) ("ㄌ"))
    ((("l" "a")) ("拉" "垃" "邋" "擸" "剌" "旯" "喇" "臘" "蠟" "辣" "腊" "瘌" "落" "啦"))
    ((("l" "a" "i")) ("來" "萊" "徠" "賴" "癩" "瀨" "籟" "睞" "賚"))
    ((("l" "a" "n")) ("蘭" "籃" "藍" "欄" "攔" "瀾" "襤" "婪" "嵐" "闌" "讕" "斕" "覽" "懶" "攬" "欖" "纜" "壈" "灠" "爛" "濫"))
    ((("l" "a" "n" "g")) ("啷" "郎" "狼" "廊" "螂" "瑯" "琅" "榔" "朗" "浪"))
    ((("l" "a" "o")) ("撈" "勞" "牢" "癆" "醪" "老" "姥" "佬" "栳" "絡" "烙" "酪" "澇" "嘮"))
    ((("l" "e")) ("ㄌ" "肋" "樂" "勒" "泐" "埒" "了"))
    ((("l" "e" "i")) ("雷" "纍" "擂" "嫘" "鐳" "羸" "縲" "罍" "檑" "累" "壘" "儡" "耒" "磊" "蕾" "類" "淚" "酹"))
    ((("l" "e" "n" "g")) ("稜" "棱" "楞" "冷" "愣"))
    ((("l" "i")) ("哩" "離" "黎" "梨" "籬" "釐" "罹" "璃" "犁" "漓" "厘" "灕" "驪" "貍" "犛" "狸" "藜" "蜊" "蠡" "鸝" "嫠" "褵" "縭" "喱" "糎" "裏" "理" "李" "里" "禮" "浬" "鯉" "裡" "娌" "俚" "澧" "邐" "醴" "鋰" "利" "力" "例" "歷" "麗" "立" "厲" "勵" "粒" "曆" "荔" "蒞" "吏" "隸" "靂" "瀝" "慄" "戾" "俐" "礪" "莉" "栗" "礫" "痢" "儷" "笠" "唳" "蠣" "酈" "嚦" "壢" "溧" "癘" "櫪" "糲" "轢" "猁"))
    ((("l" "i" "a")) ("倆"))
    ((("l" "i" "a" "n")) ("連" "聯" "憐" "廉" "蓮" "漣" "簾" "鐮" "鰱" "奩" "帘" "鎌" "濂" "臉" "斂" "歛" "練" "鍊" "戀" "煉" "鏈" "殮" "瀲"))
    ((("l" "i" "a" "n" "g")) ("良" "梁" "量" "糧" "涼" "粱" "樑" "踉" "椋" "兩" "倆" "魎" "啢" "亮" "諒" "輛" "喨" "晾" "靚"))
    ((("l" "i" "a" "o")) ("撩" "聊" "寮" "遼" "療" "寥" "僚" "嘹" "燎" "繚" "獠" "了" "瞭" "潦" "蓼" "廖" "料" "鐐" "撂"))
    ((("l" "i" "e")) ("咧" "裂" "列" "烈" "劣" "獵" "捩" "冽" "鬣" "躐" "洌"))
    ((("l" "i" "n")) ("林" "臨" "鄰" "淋" "鱗" "麟" "霖" "磷" "琳" "遴" "嶙" "燐" "璘" "粼" "轔" "痳" "疄" "凜" "懍" "廩" "檁" "吝" "躪" "藺" "賃"))
    ((("l" "i" "n" "g")) ("拎" "靈" "零" "玲" "鈴" "齡" "陵" "伶" "凌" "淩" "○" "菱" "綾" "聆" "羚" "苓" "翎" "囹" "泠" "欞" "鯪" "領" "嶺" "令" "另"))
    ((("l" "i" "u")) ("溜" "劉" "流" "留" "硫" "琉" "榴" "瀏" "瘤" "騮" "鎏" "旒" "鏐" "柳" "六" "陸" "餾" "遛" "鎦"))
    ((("l" "o")) ("咯"))
    ((("l" "o" "n" "g")) ("龍" "隆" "籠" "嚨" "聾" "瓏" "朧" "矓" "瀧" "癃" "窿" "櫳" "礱" "曨" "蘢" "隴" "攏" "壟" "弄"))
    ((("l" "o" "u")) ("摟" "樓" "嘍" "婁" "螻" "髏" "僂" "蔞" "簍" "嶁" "漏" "陋" "鏤" "瘺"))
    ((("l" "u")) ("嚕" "盧" "蘆" "廬" "臚" "爐" "顱" "瀘" "鱸" "壚" "罏" "艫" "ㄌ" "魯" "虜" "擄" "櫓" "鹵" "滷" "艣" "路" "陸" "錄" "鹿" "露" "賂" "祿" "碌" "綠" "麓" "鷺" "戮" "轆" "逯" "漉" "輅" "僇" "潞" "籙" "璐" "簏" "淥"))
    ((("l" "u" "a" "n")) ("巒" "孿" "攣" "鑾" "鸞" "臠" "卵" "亂"))
    ((("l" "u" "e")) ("略" "掠"))
    ((("l" "u" "n")) ("掄" "倫" "論" "輪" "淪" "崙" "侖" "綸" "圇"))
    ((("l" "u" "o")) ("囉" "捋" "羅" "螺" "蘿" "鑼" "邏" "籮" "騾" "儸" "玀" "裸" "瘰" "臝" "落" "洛" "駱" "絡" "烙" "酪" "濼" "犖" "珞"))
    ((("l" "u" "u")) ("驢" "閭" "櫚" "旅" "屢" "履" "侶" "鋁" "呂" "縷" "褸" "膂" "律" "綠" "率" "慮" "濾" "氯"))
    ((("m")) ("ㄇ" "嘸"))
    ((("m" "a")) ("媽" "嬤" "孖" "抹" "麻" "痲" "嘛" "蟆" "碼" "馬" "瑪" "螞" "罵" "禡" "嗎"))
    ((("m" "a" "i")) ("埋" "霾" "買" "賣" "麥" "邁" "脈" "勱"))
    ((("m" "a" "n")) ("顢" "蠻" "饅" "瞞" "蹣" "謾" "鰻" "蔓" "滿" "慢" "漫" "曼" "幔" "嫚" "鏝" "縵" "墁" "熳"))
    ((("m" "a" "n" "g")) ("忙" "芒" "茫" "盲" "氓" "鋩" "莽" "蟒" "漭" "茻"))
    ((("m" "a" "o")) ("貓" "毛" "茅" "矛" "髦" "錨" "旄" "蟊" "蝥" "酕" "卯" "冇" "帽" "冒" "貌" "貿" "茂" "瑁" "懋" "耄" "瞀" "袤"))
    ((("m" "e")) ("麼"))
    ((("m" "e" "i")) ("沒" "煤" "眉" "枚" "梅" "媒" "莓" "霉" "玫" "黴" "楣" "湄" "嵋" "脢" "每" "美" "鎂" "妹" "媚" "寐" "昧" "魅" "袂"))
    ((("m" "e" "n")) ("悶" "們" "門" "捫" "燜" "懣"))
    ((("m" "e" "n" "g")) ("矇" "蒙" "盟" "萌" "朦" "濛" "檬" "幪" "氓" "艨" "虻" "甿" "猛" "蜢" "艋" "錳" "懵" "蠓" "瞢" "夢" "孟"))
    ((("m" "i")) ("咪" "瞇" "眯" "迷" "彌" "謎" "瀰" "靡" "糜" "麋" "縻" "獼" "蘼" "醚" "醾" "米" "弭" "敉" "糎" "密" "蜜" "秘" "祕" "覓" "泌" "汨" "謐" "宓" "冪" "糸"))
    ((("m" "i" "a" "n")) ("棉" "綿" "眠" "免" "勉" "緬" "冕" "娩" "靦" "湎" "沔" "丏" "澠" "面" "麵" "眄"))
    ((("m" "i" "a" "o")) ("喵" "苗" "描" "瞄" "秒" "渺" "藐" "邈" "緲" "杳" "眇" "淼" "杪" "妙" "廟" "繆"))
    ((("m" "i" "e")) ("咩" "乜" "滅" "蔑" "衊" "篾" "蠛"))
    ((("m" "i" "n")) ("民" "緡" "敏" "憫" "閔" "閩" "抿" "泯" "皿" "湣" "愍" "黽"))
    ((("m" "i" "n" "g")) ("明" "名" "鳴" "銘" "螟" "冥" "瞑" "暝" "茗" "酩" "命"))
    ((("m" "i" "u")) ("謬" "繆"))
    ((("m" "o")) ("摸" "ㄇ" "模" "磨" "摩" "膜" "魔" "摹" "謨" "蘑" "嫫" "抹" "末" "莫" "默" "漠" "沒" "寞" "陌" "歿" "脈" "沫" "秣" "茉" "驀" "墨" "貊" "瘼" "靺" "眽" "万"))
    ((("m" "o" "u")) ("謀" "眸" "繆" "牟" "鍪" "蛑" "某"))
    ((("m" "u")) ("模" "母" "畝" "牡" "姆" "拇" "牳" "姥" "木" "目" "幕" "牧" "慕" "墓" "募" "穆" "睦" "暮" "沐" "苜" "鶩"))
    ((("n")) ("ㄋ" "嗯" "唔"))
    ((("n" "a")) ("那" "拿" "哪" "納" "吶" "訥" "鈉" "捺" "娜" "肭" "衲"))
    ((("n" "a" "i")) ("孻" "乃" "奶" "迺" "氖" "嬭" "耐" "奈" "鼐"))
    ((("n" "a" "n")) ("難" "男" "南" "喃" "楠" "柟" "赧" "腩"))
    ((("n" "a" "n" "g")) ("囊" "曩" "攮"))
    ((("n" "a" "o")) ("撓" "鐃" "呶" "猱" "腦" "惱" "瑙" "鬧" "淖"))
    ((("n" "e")) ("ㄋ" "哪" "訥" "呢"))
    ((("n" "e" "i")) ("餒" "內"))
    ((("n" "e" "n")) ("嫩" "恁"))
    ((("n" "e" "n" "g")) ("能" "濘"))
    ((("n" "g")) ("嗯" "唔"))
    ((("n" "i")) ("妮" "泥" "尼" "倪" "霓" "怩" "麑" "你" "妳" "擬" "旎" "逆" "溺" "匿" "膩" "睨" "暱"))
    ((("n" "i" "a" "n")) ("拈" "年" "黏" "粘" "捻" "撚" "攆" "輦" "碾" "念" "唸" "廿"))
    ((("n" "i" "a" "n" "g")) ("娘" "孃" "釀"))
    ((("n" "i" "a" "o")) ("鳥" "裊" "嬲" "嬝" "嫋" "尿"))
    ((("n" "i" "e")) ("捏" "孽" "鎳" "躡" "聶" "鑷" "涅" "囁" "齧" "臬" "乜"))
    ((("n" "i" "n")) ("您"))
    ((("n" "i" "n" "g")) ("寧" "凝" "獰" "嚀" "檸" "甯" "擰" "濘" "佞"))
    ((("n" "i" "u")) ("妞" "牛" "紐" "扭" "鈕" "忸" "狃" "拗"))
    ((("n" "o" "n" "g")) ("農" "濃" "膿" "儂" "噥" "弄"))
    ((("n" "o" "u")) ("耨"))
    ((("n" "u")) ("奴" "駑" "孥" "努" "弩" "ㄋ" "怒"))
    ((("n" "u" "a" "n")) ("暖"))
    ((("n" "u" "e")) ("虐" "瘧" "謔"))
    ((("n" "u" "o")) ("挪" "娜" "諾" "懦" "糯" "搦"))
    ((("n" "u" "u")) ("女"))
    ((("o")) ("喔" "噢" "ㄛ" "哦" "嚄"))
    ((("o" "u")) ("歐" "甌" "毆" "謳" "鷗" "ㄡ" "區" "偶" "藕" "嘔" "耦" "漚"))
    ((("p")) ("ㄆ"))
    ((("p" "a")) ("趴" "葩" "啪" "爬" "扒" "琶" "耙" "杷" "怕" "帕"))
    ((("p" "a" "i")) ("拍" "排" "牌" "徘" "俳" "棑" "派" "湃"))
    ((("p" "a" "n")) ("潘" "攀" "番" "盤" "磐" "蟠" "胖" "槃" "蹣" "爿" "判" "叛" "盼" "畔" "拚" "泮"))
    ((("p" "a" "n" "g")) ("乓" "磅" "滂" "旁" "龐" "膀" "螃" "徬" "嗙" "胖"))
    ((("p" "a" "o")) ("拋" "袍" "咆" "刨" "匏" "庖" "跑" "泡" "砲" "炮" "皰"))
    ((("p" "e" "i")) ("胚" "呸" "醅" "培" "賠" "陪" "裴" "配" "佩" "沛" "珮" "帔" "轡"))
    ((("p" "e" "n")) ("噴" "盆"))
    ((("p" "e" "n" "g")) ("砰" "烹" "抨" "怦" "澎" "朋" "彭" "蓬" "膨" "硼" "棚" "鵬" "篷" "蟛" "捧" "碰"))
    ((("p" "i")) ("批" "披" "匹" "劈" "霹" "砒" "丕" "坯" "紕" "皮" "疲" "脾" "琵" "枇" "裨" "啤" "毗" "貔" "陂" "否" "疋" "痞" "仳" "譬" "闢" "僻" "媲" "屁" "辟" "癖" "甓" "擗" "澼"))
    ((("p" "i" "a" "n")) ("篇" "偏" "扁" "翩" "駢" "胼" "便" "諞" "片" "騙" "遍"))
    ((("p" "i" "a" "o")) ("飄" "漂" "慓" "剽" "嫖" "瓢" "莩" "縹" "瞟" "殍" "票" "驃"))
    ((("p" "i" "e")) ("瞥" "撇"))
    ((("p" "i" "n")) ("拼" "姘" "貧" "頻" "蘋" "顰" "嬪" "瀕" "品" "聘" "牝"))
    ((("p" "i" "n" "g")) ("乒" "娉" "俜" "平" "瓶" "憑" "評" "屏" "蘋" "萍" "坪" "枰" "洴"))
    ((("p" "o")) ("潑" "坡" "泊" "陂" "鏺" "ㄆ" "婆" "鄱" "皤" "頗" "叵" "笸" "破" "迫" "魄" "珀" "朴" "粕"))
    ((("p" "o" "u")) ("剖" "掊"))
    ((("p" "u")) ("撲" "仆" "鋪" "噗" "僕" "樸" "葡" "蒲" "菩" "脯" "濮" "璞" "匍" "普" "浦" "埔" "譜" "圃" "溥" "氆" "蹼" "暴" "瀑" "曝" "舖"))
    ((("q")) ("ㄑ"))
    ((("q" "i")) ("期" "七" "妻" "欺" "戚" "漆" "棲" "悽" "淒" "沏" "緝" "柒" "萋" "慼" "溪" "谿" "凄" "攲" "ㄑ" "其" "齊" "奇" "旗" "騎" "祈" "棋" "祺" "祁" "崎" "琦" "岐" "歧" "琪" "麒" "鰭" "畦" "臍" "耆" "淇" "跂" "綦" "騏" "蘄" "圻" "萁" "蜞" "頎" "起" "啟" "豈" "乞" "綺" "杞" "稽" "屺" "棨" "企" "氣" "汽" "器" "棄" "契" "砌" "泣" "迄" "訖" "憩" "亟" "葺" "磧"))
    ((("q" "i" "a")) ("掐" "卡" "恰" "洽"))
    ((("q" "i" "a" "n")) ("千" "鉛" "遷" "簽" "牽" "謙" "籤" "仟" "阡" "韆" "騫" "愆" "僉" "慳" "搴" "褰" "粁" "瓩" "兛" "前" "錢" "乾" "潛" "黔" "鉗" "虔" "箝" "鈐" "掮" "遣" "淺" "譴" "繾" "欠" "歉" "倩" "慊" "茜" "嵌" "塹" "縴"))
    ((("q" "i" "a" "n" "g")) ("槍" "腔" "鎗" "羌" "嗆" "搶" "鏘" "鏹" "蜣" "斨" "強" "牆" "薔" "嬙" "檣" "彊" "襁" "蹌"))
    ((("q" "i" "a" "o")) ("敲" "鍬" "橇" "蹺" "悄" "橋" "瞧" "僑" "喬" "樵" "翹" "憔" "蕎" "譙" "巧" "愀" "雀" "竅" "俏" "峭" "鞘" "誚" "撬" "殼"))
    ((("q" "i" "e")) ("切" "茄" "伽" "且" "竊" "妾" "怯" "愜" "挈" "篋" "鍥"))
    ((("q" "i" "n")) ("親" "侵" "欽" "衾" "勤" "琴" "秦" "禽" "擒" "芹" "檎" "懃" "噙" "芩" "寢" "沁" "撳" "唚"))
    ((("q" "i" "n" "g")) ("清" "青" "輕" "傾" "卿" "氫" "蜻" "頃" "鯖" "氰" "情" "晴" "擎" "請" "慶" "罄" "綮" "磬"))
    ((("q" "i" "o" "n" "g")) ("窮" "瓊" "穹" "跫" "蛩" "筇"))
    ((("q" "i" "u")) ("秋" "丘" "邱" "蚯" "鞦" "鰍" "鶖" "楸" "萩" "求" "球" "囚" "仇" "酋" "裘" "遒" "毬" "泅" "逑"))
    ((("q" "u")) ("區" "屈" "驅" "趨" "軀" "嶇" "曲" "蛆" "蛐" "祛" "渠" "劬" "麴" "衢" "瞿" "籧" "蘧" "蠷" "取" "娶" "齲" "去" "趣" "覷"))
    ((("q" "u" "a" "n")) ("圈" "悛" "棬" "全" "權" "泉" "荃" "詮" "拳" "銓" "痊" "顴" "蜷" "鬈" "筌" "牷" "犬" "綣" "畎" "勸" "券"))
    ((("q" "u" "e")) ("缺" "闕" "瘸" "卻" "確" "雀" "鵲" "闋" "榷" "搉" "愨"))
    ((("q" "u" "n")) ("逡" "群" "裙" "麇"))
    ((("r")) ("ㄖ" "兒"))
    ((("r" "a" "n")) ("然" "燃" "髯" "蚺" "染" "冉" "苒"))
    ((("r" "a" "n" "g")) ("嚷" "禳" "穰" "勷" "瓤" "蘘" "壤" "攘" "讓"))
    ((("r" "a" "o")) ("饒" "蕘" "嬈" "蟯" "擾" "繞" "遶"))
    ((("r" "e")) ("惹" "喏" "熱"))
    ((("r" "e" "n")) ("人" "任" "仁" "壬" "忍" "稔" "荏" "認" "刃" "飪" "韌" "軔" "衽" "紉" "紝" "妊" "仞" "賃" "恁"))
    ((("r" "e" "n" "g")) ("扔" "仍" "礽"))
    ((("r" "i")) ("ㄖ" "日"))
    ((("r" "o" "n" "g")) ("容" "榮" "融" "溶" "絨" "熔" "戎" "蓉" "榕" "茸" "嶸" "鎔" "羢" "毧" "冗"))
    ((("r" "o" "u")) ("柔" "揉" "蹂" "輮" "楺" "鞣" "肉"))
    ((("r" "u")) ("如" "儒" "孺" "茹" "蠕" "嚅" "濡" "襦" "乳" "汝" "辱" "入" "褥" "縟" "蓐" "溽"))
    ((("r" "u" "a" "n")) ("軟" "阮"))
    ((("r" "u" "i")) ("蕊" "瑞" "銳" "芮" "睿" "蚋" "叡" "枘"))
    ((("r" "u" "n")) ("潤" "閏"))
    ((("r" "u" "o")) ("若" "弱" "箬" "偌" "爇"))
    ((("s")) ("ㄙ"))
    ((("<")) ("《"))
    (((">")) ("》"))
    ((("<")) ("〈"))
    (((">")) ("〉"))
    ((("<")) ("︽"))
    (((">")) ("︾"))
    ((("<")) ("︿"))
    (((">")) ("﹀"))
    ((("s" "a")) ("撒" "灑" "洒" "薩" "卅" "颯" "挲"))
    ((("s" "a" "i")) ("鰓" "腮" "賽" "塞"))
    ((("s" "a" "n")) ("三" "參" "散" "傘"))
    ((("s" "a" "n" "g")) ("喪" "桑" "嗓" "顙" "搡"))
    ((("s" "a" "o")) ("騷" "搔" "臊" "繅" "掃" "嫂" "瘙"))
    ((("s" "e")) ("色" "塞" "瑟" "嗇" "澀" "穡"))
    ((("s" "e" "n")) ("森"))
    ((("s" "e" "n" "g")) ("僧"))
    ((("s" "h")) ("ㄕ"))
    ((("s" "h" "a")) ("殺" "沙" "紗" "砂" "莎" "煞" "鯊" "裟" "杉" "痧" "鎩" "傻" "廈" "霎" "嗄" "歃" "啥" "挲"))
    ((("s" "h" "a" "i")) ("篩" "骰" "色" "曬" "晒"))
    ((("s" "h" "a" "n")) ("山" "扇" "衫" "杉" "刪" "珊" "羶" "舢" "煽" "潸" "跚" "姍" "柵" "芟" "搧" "閃" "陜" "睒" "善" "汕" "擅" "膳" "繕" "鄯" "訕" "贍" "疝" "鱔" "騸"))
    ((("s" "h" "a" "n" "g")) ("商" "傷" "殤" "觴" "賞" "晌" "上" "尚" "裳"))
    ((("s" "h" "a" "o")) ("燒" "稍" "梢" "艄" "捎" "蛸" "筲" "韶" "勺" "芍" "杓" "少" "紹" "哨" "邵" "召" "劭" "潲"))
    ((("s" "h" "e")) ("奢" "賒" "猞" "蛇" "舌" "佘" "捨" "舍" "社" "設" "射" "涉" "攝" "赦" "懾" "麝"))
    ((("s" "h" "e" "i")) ("誰"))
    ((("s" "h" "e" "n")) ("身" "深" "伸" "申" "紳" "呻" "參" "娠" "莘" "燊" "蔘" "珅" "甚" "什" "神" "沈" "審" "嬸" "瀋" "諗" "讅" "矧" "哂" "慎" "腎" "滲" "蜃" "沁"))
    ((("s" "h" "e" "n" "g")) ("生" "聲" "升" "牲" "昇" "甥" "笙" "陞" "繩" "省" "眚" "勝" "盛" "聖" "剩" "乘" "賸"))
    ((("s" "h" "i")) ("失" "施" "師" "詩" "濕" "溼" "獅" "屍" "蝨" "虱" "噓" "尸" "ㄕ" "絁" "時" "實" "十" "食" "識" "拾" "石" "蝕" "什" "寔" "使" "始" "史" "駛" "矢" "屎" "豕" "是" "事" "世" "士" "勢" "室" "示" "試" "式" "釋" "視" "適" "市" "飾" "逝" "誓" "侍" "氏" "嗜" "恃" "仕" "柿" "螫" "弒" "噬" "拭" "筮" "舐" "軾" "諡" "奭" "謚" "匙"))
    ((("s" "h" "o" "u")) ("收" "熟" "手" "首" "守" "受" "售" "壽" "獸" "授" "瘦" "狩" "綬"))
    ((("s" "h" "u")) ("書" "輸" "叔" "淑" "殊" "舒" "梳" "疏" "《" "》" "〈" "〉" "蔬" "樞" "紓" "抒" "姝" "樗" "殳" "倏" "菽" "熟" "塾" "贖" "孰" "屬" "暑" "署" "薯" "鼠" "數" "蜀" "黍" "曙" "樹" "術" "述" "束" "豎" "恕" "庶" "戍" "墅" "漱" "澍"))
    ((("s" "h" "u" "a")) ("刷" "唰" "耍"))
    ((("s" "h" "u" "a" "i")) ("摔" "衰" "甩" "率" "帥" "蟀"))
    ((("s" "h" "u" "a" "n")) ("栓" "閂" "拴" "涮"))
    ((("s" "h" "u" "a" "n" "g")) ("雙" "霜" "孀" "爽"))
    ((("s" "h" "u" "i")) ("誰" "水" "睡" "稅" "說" "帨"))
    ((("s" "h" "u" "n")) ("吮" "順" "舜" "瞬"))
    ((("s" "h" "u" "o")) ("說" "朔" "碩" "爍" "鑠" "妁" "槊"))
    ((("s" "i")) ("司" "思" "私" "絲" "斯" "撕" "廝" "鷥" "嘶" "澌" "緦" "偲" "俬" "颸" "ㄙ" "死" "四" "似" "嗣" "飼" "寺" "肆" "祀" "俟" "伺" "泗" "巳" "耜" "姒" "駟" "兕" "涘" "汜"))
    ((("s" "o" "n" "g")) ("松" "鬆" "淞" "嵩" "忪" "崧" "聳" "慫" "悚" "竦" "送" "宋" "頌" "訟" "誦"))
    ((("s" "o" "u")) ("搜" "颼" "艘" "蒐" "廋" "溲" "餿" "嗖" "擻" "嗾" "叟" "藪" "瞍" "嗽"))
    ((("s" "u")) ("蘇" "甦" "酥" "穌" "囌" "俗" "訴" "速" "素" "肅" "宿" "塑" "夙" "粟" "溯" "愫" "觫" "膆" "謖" "簌" "蔌"))
    ((("s" "u" "a" "n")) ("酸" "痠" "狻" "算" "蒜"))
    ((("s" "u" "i")) ("雖" "睢" "綏" "荽" "隨" "隋" "髓" "歲" "遂" "碎" "穗" "隧" "祟" "燧" "誶" "邃"))
    ((("s" "u" "n")) ("孫" "飧" "蓀" "猻" "損" "筍" "榫" "隼"))
    ((("s" "u" "o")) ("縮" "梭" "莎" "唆" "娑" "簑" "嗦" "挲" "蓑" "所" "索" "鎖" "瑣" "嗩"))
    ((("t")) ("ㄊ"))
    ((("t" "a")) ("他" "她" "它" "牠" "塌" "踏" "祂" "塔" "獺" "榻" "蹋" "遢" "沓" "嗒" "撻" "遝" "闥"))
    ((("t" "a" "i")) ("胎" "苔" "台" "臺" "抬" "颱" "跆" "檯" "駘" "太" "態" "泰" "汰" "鈦"))
    ((("t" "a" "n")) ("貪" "灘" "攤" "癱" "坍" "怹" "談" "彈" "痰" "潭" "譚" "檀" "壇" "曇" "罈" "覃" "坦" "毯" "袒" "忐" "探" "嘆" "歎" "碳" "炭"))
    ((("t" "a" "n" "g")) ("湯" "鏜" "蹚" "堂" "糖" "唐" "塘" "膛" "螳" "棠" "醣" "搪" "樘" "倘" "躺" "儻" "淌" "帑" "惝" "趟" "燙"))
    ((("t" "a" "o")) ("掏" "濤" "滔" "饕" "韜" "弢" "絛" "燾" "叨" "逃" "桃" "陶" "萄" "淘" "啕" "討" "套"))
    ((("t" "e")) ("ㄊ" "特" "忑" "忒" "慝"))
    ((("t" "e" "n" "g")) ("熥" "疼" "騰" "藤" "籐" "謄" "滕" "螣" "縢"))
    ((("t" "i")) ("梯" "踢" "剔" "銻" "ˇ" "題" "提" "啼" "蹄" "醍" "緹" "荑" "體" "替" "惕" "涕" "屜" "悌" "剃" "嚏" "倜" "薙" "逖"))
    ((("t" "i" "a" "n")) ("天" "添" "田" "甜" "填" "恬" "闐" "畋" "湉" "菾" "舔" "忝" "殄" "腆" "靦" "掭"))
    ((("t" "i" "a" "o")) ("挑" "佻" "條" "調" "迢" "蜩" "窕" "跳" "眺" "糶" "朓"))
    ((("t" "i" "e")) ("貼" "帖" "怗" "鐵" "餮"))
    ((("t" "i" "n" "g")) ("聽" "廳" "汀" "停" "庭" "廷" "亭" "蜓" "霆" "婷" "渟" "挺" "艇" "町" "梃" "鋌" "珽"))
    ((("t" "o" "n" "g")) ("通" "同" "童" "銅" "桐" "潼" "瞳" "彤" "佟" "僮" "仝" "峒" "侗" "曈" "統" "筒" "桶" "捅" "痛" "慟"))
    ((("t" "o" "u")) ("偷" "頭" "投" "骰" "透"))
    ((("t" "u")) ("突" "禿" "凸" "圖" "途" "徒" "塗" "屠" "荼" "涂" "酴" "土" "兔" "吐" "菟"))
    ((("t" "u" "a" "n")) ("湍" "團" "摶" "糰" "彖"))
    ((("t" "u" "i")) ("推" "頹" "腿" "退" "蛻" "褪"))
    ((("t" "u" "n")) ("吞" "屯" "囤" "豚" "飩" "臀"))
    ((("t" "u" "o")) ("脫" "拖" "托" "託" "侂" "駝" "陀" "馱" "沱" "佗" "鴕" "跎" "橐" "砣" "鼉" "妥" "橢" "拓" "唾"))
    ((("u")) ("ㄨ" "ㄩ"))
    ((("w" "a")) ("蛙" "哇" "挖" "窪" "媧" "洼" "娃" "瓦" "佤" "瓩" "襪"))
    ((("w" "a" "i")) ("歪" "喎" "外"))
    ((("w" "a" "n")) ("灣" "彎" "豌" "剜" "蜿" "完" "玩" "頑" "丸" "汍" "紈" "芄" "晚" "惋" "碗" "宛" "婉" "菀" "皖" "輓" "畹" "挽" "琬" "綰" "萬" "腕" "卍" "翫" "万" "蔓"))
    ((("w" "a" "n" "g")) ("汪" "王" "亡" "芒" "往" "網" "枉" "罔" "惘" "魍" "輞" "网" "望" "忘" "妄" "旺"))
    ((("w" "e" "i")) ("威" "危" "微" "薇" "崴" "偎" "煨" "葳" "逶" "為" "圍" "唯" "維" "惟" "違" "韋" "巍" "桅" "闈" "帷" "嵬" "幃" "溦" "偉" "委" "尾" "偽" "緯" "萎" "諉" "葦" "痿" "猥" "煒" "娓" "韙" "瑋" "韡" "洧" "位" "未" "魏" "衛" "味" "謂" "胃" "慰" "喂" "餵" "尉" "渭" "畏" "蔚" "蝟" "遺"))
    ((("w" "e" "n")) ("溫" "瘟" "文" "聞" "紋" "蚊" "雯" "炆" "穩" "吻" "刎" "問" "紊" "汶" "抆" "搵" "璺"))
    ((("w" "e" "n" "g")) ("翁" "嗡" "蓊" "滃" "甕" "瓮" "罋"))
    ((("w" "o")) ("窩" "倭" "渦" "蝸" "萵" "踒" "喔" "我" "握" "臥" "沃" "渥" "斡" "齷" "幄"))
    ((("w" "u")) ("屋" "烏" "污" "嗚" "汙" "圬" "巫" "鎢" "鄔" "ㄨ" "無" "吳" "吾" "梧" "蕪" "蜈" "誣" "毋" "鼯" "五" "午" "武" "舞" "侮" "伍" "鵡" "憮" "嫵" "忤" "廡" "仵" "捂" "勿" "物" "務" "惡" "誤" "悟" "晤" "霧" "戊" "塢" "兀" "騖" "寤" "鶩" "鋈" "焐"))
    ((("x")) ("ㄒ"))
    ((("x" "i")) ("西" "希" "息" "悉" "惜" "昔" "吸" "錫" "夕" "汐" "嘻" "犧" "稀" "熄" "溪" "析" "禧" "蟋" "熙" "膝" "嬉" "兮" "犀" "晰" "羲" "曦" "矽" "蜥" "熹" "奚" "晞" "欷" "蹊" "樨" "淅" "皙" "唏" "烯" "粞" "谿" "腊" "習" "席" "媳" "襲" "蓆" "檄" "喜" "洗" "徙" "璽" "屣" "囍" "細" "戲" "係" "系" "繫" "隙" "鬩" "潟"))
    ((("x" "i" "a")) ("瞎" "蝦" "呷" "暇" "峽" "轄" "霞" "俠" "狹" "匣" "遐" "狎" "瑕" "硤" "柙" "黠" "下" "夏" "嚇" "廈" "罅" "唬"))
    ((("x" "i" "a" "n")) ("先" "仙" "掀" "鮮" "纖" "暹" "躚" "祆" "¢" "僊" "賢" "閒" "嫌" "咸" "鹹" "弦" "銜" "絃" "嫻" "涎" "啣" "舷" "閑" "癇" "險" "顯" "蜆" "癬" "蘚" "銑" "燹" "跣" "現" "線" "限" "縣" "憲" "獻" "羨" "陷" "腺" "餡" "莧" "峴"))
    ((("x" "i" "a" "n" "g")) ("香" "相" "鄉" "箱" "湘" "襄" "鑲" "廂" "詳" "祥" "降" "翔" "庠" "想" "響" "享" "餉" "饗" "向" "像" "象" "項" "巷" "橡" "嚮" "曏"))
    ((("x" "i" "a" "o")) ("消" "銷" "削" "蕭" "瀟" "宵" "逍" "囂" "簫" "硝" "霄" "哮" "驍" "梟" "蠨" "枵" "魈" "鴞" "嘵" "綃" "淆" "崤" "小" "曉" "筱" "校" "笑" "孝" "效" "肖" "酵" "嘯" "傚"))
    ((("x" "i" "e")) ("些" "歇" "楔" "蠍" "蝎" "協" "鞋" "斜" "攜" "脅" "諧" "邪" "偕" "頡" "挾" "擷" "絜" "勰" "寫" "謝" "械" "洩" "屑" "瀉" "懈" "卸" "泄" "蟹" "褻" "榭" "契" "邂" "廨" "燮" "紲" "躞" "獬"))
    ((("x" "i" "n")) ("心" "新" "辛" "薪" "欣" "鋅" "鑫" "莘" "炘" "馨" "芯" "歆" "昕" "訢" "忻" "尋" "信" "釁" "囟"))
    ((("x" "i" "n" "g")) ("興" "星" "猩" "腥" "惺" "行" "形" "型" "刑" "邢" "硎" "鉶" "滎" "省" "醒" "擤" "性" "幸" "姓" "杏" "倖" "悻" "荇"))
    ((("x" "i" "o" "n" "g")) ("兄" "兇" "胸" "凶" "匈" "洶" "雄" "熊" "敻"))
    ((("x" "i" "u")) ("修" "休" "羞" "脩" "咻" "貅" "髹" "饈" "鵂" "朽" "宿" "滫" "秀" "繡" "袖" "嗅" "臭" "溴" "銹" "岫" "琇"))
    ((("x" "u")) ("須" "需" "虛" "鬚" "噓" "墟" "戌" "胥" "吁" "歔" "徐" "許" "栩" "煦" "詡" "序" "續" "蓄" "緒" "敘" "絮" "旭" "恤" "卹" "酗" "婿" "畜" "勗"))
    ((("x" "u" "a" "n")) ("宣" "軒" "喧" "瑄" "萱" "暄" "諼" "禤" "玄" "旋" "懸" "漩" "璇" "璿" "選" "晅" "烜" "癬" "炫" "眩" "絢" "泫" "渲" "楦" "鉉" "鏇"))
    ((("x" "u" "e")) ("削" "薛" "靴" "學" "穴" "踅" "噱" "雪" "血" "謔"))
    ((("x" "u" "n")) ("勳" "薰" "燻" "熏" "醺" "峋" "曛" "獯" "勛" "尋" "巡" "詢" "循" "旬" "馴" "潯" "珣" "洵" "荀" "恂" "郇" "噚" "訊" "訓" "迅" "遜" "殉" "徇" "巽" "汛" "噀" "蕈"))
    ((("#" "'")) ("「" "」"))
    ((("#" "\"")) ("『" "』"))
    ((("#" "'")) ("‘" "′"))
    ((("#" "\"")) ("“" "”"))
    ((("#" "'")) ("﹁" "﹂"))
    ((("#" "\"")) ("﹃" "﹄"))
    ((("y" "a")) ("呀" "壓" "鴉" "鴨" "押" "丫" "椏" "枒" "牙" "芽" "涯" "衙" "蚜" "崖" "睚" "琊" "玡" "雅" "啞" "亞" "訝" "迓" "砑" "揠" "軋"))
    ((("y" "a" "i")) ("崖" "睚"))
    ((("y" "a" "n")) ("煙" "焉" "淹" "殷" "醃" "咽" "胭" "奄" "湮" "菸" "嫣" "燕" "閹" "懨" "研" "言" "顏" "嚴" "延" "沿" "炎" "鹽" "岩" "妍" "簷" "筵" "閻" "蜒" "檐" "巖" "芫" "眼" "演" "掩" "衍" "郾" "偃" "兗" "甗" "儼" "魘" "罨" "蝘" "黶" "鼴" "琰" "厴" "驗" "厭" "晏" "雁" "宴" "艷" "燄" "彥" "諺" "硯" "嚥" "唁" "饜" "讌" "堰" "讞" "贗" "灩" "焰" "鷃" "醼" "豔"))
    ((("y" "a" "n" "g")) ("央" "秧" "殃" "鴦" "鞅" "泱" "楊" "陽" "揚" "洋" "羊" "佯" "瘍" "徉" "暘" "煬" "養" "仰" "氧" "癢" "痒" "瀁" "樣" "恙" "漾" "怏" "烊"))
    ((("y" "a" "o")) ("要" "腰" "夭" "妖" "邀" "么" "吆" "祅" "約" "殀" "搖" "謠" "堯" "遙" "姚" "瑤" "淆" "餚" "徭" "爻" "繇" "傜" "僥" "颻" "嶢" "肴" "窯" "珧" "銚" "咬" "窈" "舀" "杳" "窅" "藥" "耀" "曜" "鑰" "鷂" "燿" "葯" "瘧"))
    ((("y" "e")) ("耶" "噎" "椰" "掖" "爺" "琊" "揶" "邪" "也" "野" "冶" "業" "葉" "頁" "夜" "曳" "謁" "靨" "液" "腋" "鄴" "燁" "曄"))
    ((("y" "i")) ("一" "壹" "衣" "依" "醫" "伊" "揖" "噫" "漪" "咿" "禕" "銥" "ㄧ" "〡" "宜" "怡" "移" "疑" "遺" "儀" "姨" "夷" "誼" "胰" "貽" "飴" "咦" "詒" "頤" "彝" "痍" "圯" "迻" "荑" "以" "已" "乙" "倚" "椅" "矣" "蟻" "迤" "旖" "意" "義" "亦" "易" "議" "益" "異" "藝" "憶" "譯" "役" "翼" "毅" "逸" "抑" "疫" "邑" "肄" "億" "繹" "溢" "縊" "軼" "詣" "屹" "佚" "翌" "羿" "驛" "懿" "裔" "臆" "曳" "奕" "弈" "蜴" "翳" "囈" "弋" "艾" "刈" "挹" "佾" "懌" "劓" "薏" "悒" "熠" "殪" "浥" "翊"))
    ((("y" "i" "n")) ("因" "音" "陰" "姻" "殷" "茵" "慇" "氤" "喑" "愔" "銀" "吟" "寅" "淫" "齦" "霪" "垠" "夤" "狺" "引" "飲" "隱" "尹" "癮" "蚓" "「" "」" "『" "』" "印" "蔭" "胤" "廕" "窨"))
    ((("y" "i" "n" "g")) ("應" "英" "鷹" "嬰" "鶯" "櫻" "膺" "瑛" "鸚" "攖" "纓" "嚶" "罌" "甖" "瓔" "營" "迎" "蠅" "螢" "贏" "盈" "瑩" "縈" "熒" "嬴" "瀛" "滎" "塋" "楹" "瀅" "瀠" "影" "穎" "潁" "癭" "郢" "映" "硬" "媵"))
    ((("y" "o")) ("唷" "喲"))
    ((("y" "o" "n" "g")) ("傭" "庸" "雍" "擁" "壅" "癰" "墉" "鏞" "慵" "饔" "臃" "喁" "顒" "永" "泳" "詠" "勇" "踴" "湧" "蛹" "甬" "恿" "俑" "踊" "涌" "用" "佣"))
    ((("y" "o" "u")) ("優" "憂" "幽" "悠" "攸" "呦" "由" "游" "遊" "尤" "油" "郵" "猶" "猷" "魷" "鈾" "柚" "疣" "蕕" "蝣" "有" "友" "酉" "莠" "牖" "黝" "卣" "誘" "又" "幼" "右" "佑" "釉" "祐" "宥" "侑" "囿" "鼬"))
    ((("y" "u")) ("於" "迂" "淤" "瘀" "紆" "ㄩ" "愉" "魚" "娛" "餘" "于" "漁" "予" "愚" "余" "逾" "俞" "榆" "虞" "輿" "渝" "瑜" "隅" "歟" "覦" "竽" "臾" "諛" "腴" "盂" "萸" "妤" "禺" "雩" "揄" "狳" "艅" "踰" "與" "語" "雨" "羽" "嶼" "宇" "禹" "齬" "瘐" "庾" "圄" "窳" "傴" "育" "遇" "預" "玉" "欲" "域" "喻" "愈" "譽" "獄" "慾" "浴" "裕" "煜" "寓" "禦" "鈺" "豫" "御" "鬱" "籲" "諭" "癒" "郁" "馭" "毓" "芋" "尉" "熨" "嫗" "鷸" "鬻" "峪" "彧" "聿" "燠" "瘉" "昱" "魊"))
    ((("y" "u" "a" "n")) ("冤" "淵" "鴛" "鳶" "眢" "蜎" "原" "元" "員" "園" "圓" "緣" "源" "援" "媛" "袁" "¥" "猿" "垣" "沅" "轅" "爰" "圜" "黿" "櫞" "芫" "湲" "遠" "院" "願" "怨" "苑" "瑗" "愿" "掾"))
    ((("y" "u" "e")) ("約" "曰" "月" "越" "樂" "悅" "岳" "粵" "閱" "嶽" "躍" "鉞"))
    ((("y" "u" "n")) ("暈" "氳" "雲" "云" "勻" "芸" "耘" "紜" "筠" "允" "殞" "隕" "狁" "運" "韻" "孕" "醞" "蘊" "慍" "縕" "韞"))
    ((("z")) ("ㄗ"))
    ((("z" "a")) ("扎" "紮" "匝" "咂" "雜" "咱" "砸" "臢"))
    ((("z" "a" "i")) ("災" "哉" "栽" "宰" "仔" "崽" "載" "在" "再"))
    ((("z" "a" "n")) ("簪" "糌" "咱" "攢" "拶" "贊" "讚" "暫" "鏨" "瓚"))
    ((("z" "a" "n" "g")) ("髒" "贓" "臧" "藏" "葬" "臟" "奘"))
    ((("z" "a" "o")) ("遭" "糟" "鑿" "早" "澡" "棗" "藻" "蚤" "造" "皂" "噪" "燥" "躁" "灶"))
    ((("z" "e")) ("則" "責" "擇" "澤" "嘖" "舴" "幘" "側" "仄" "昃"))
    ((("z" "e" "i")) ("賊"))
    ((("z" "e" "n")) ("怎" "譖"))
    ((("z" "e" "n" "g")) ("增" "曾" "憎" "繒" "贈" "甑"))
    ((("z" "h")) ("ㄓ"))
    ((("z" "h" "a")) ("扎" "紮" "查" "渣" "喳" "吒" "楂" "劄" "札" "炸" "閘" "軋" "眨" "詐" "鮓" "砟" "乍" "咋" "蚱" "搾" "榨" "痄"))
    ((("z" "h" "a" "i")) ("摘" "齋" "側" "擇" "宅" "翟" "窄" "債" "寨" "砦"))
    ((("z" "h" "a" "n")) ("占" "沾" "詹" "瞻" "霑" "氈" "黏" "旃" "粘" "展" "斬" "盞" "輾" "嶄" "搌" "佔" "站" "戰" "顫" "湛" "棧" "綻" "蘸"))
    ((("z" "h" "a" "n" "g")) ("張" "章" "彰" "樟" "璋" "鱆" "蟑" "漳" "長" "掌" "漲" "丈" "仗" "杖" "帳" "脹" "賬" "障" "瘴" "嶂"))
    ((("z" "h" "a" "o")) ("招" "朝" "昭" "嘲" "釗" "啁" "著" "找" "爪" "沼" "照" "趙" "召" "詔" "兆" "罩" "肇" "棹" "笊" "曌"))
    ((("z" "h" "e")) ("遮" "折" "蜇" "哲" "轍" "輒" "摺" "蟄" "謫" "磔" "者" "赭" "褶" "這" "浙" "蔗" "鷓" "柘" "著"))
    ((("z" "h" "e" "i")) ("這"))
    ((("z" "h" "e" "n")) ("真" "珍" "貞" "針" "偵" "砧" "甄" "箴" "斟" "榛" "禎" "臻" "胗" "蓁" "鍼" "枕" "診" "疹" "畛" "縝" "軫" "稹" "振" "震" "賑" "陣" "圳" "朕" "娠" "鎮" "鴆" "酖"))
    ((("z" "h" "e" "n" "g")) ("爭" "征" "怔" "崢" "睜" "猙" "掙" "蒸" "箏" "徵" "正" "烝" "錚" "癥" "整" "拯" "政" "證" "証" "症" "鄭" "幀" "諍"))
    ((("z" "h" "i")) ("之" "支" "枝" "知" "隻" "吱" "肢" "脂" "織" "擲" "汁" "氏" "芝" "胝" "蜘" "祗" "卮" "梔" "ㄓ" "直" "值" "植" "殖" "執" "職" "躑" "姪" "侄" "摭" "蹠" "縶" "只" "止" "指" "旨" "址" "咫" "趾" "芷" "祉" "紙" "黹" "酯" "祇" "至" "志" "治" "致" "制" "質" "緻" "智" "秩" "置" "稚" "製" "雉" "炙" "摯" "滯" "窒" "痔" "痣" "桎" "蛭" "輊" "峙" "誌" "幟" "躓" "豸" "帙" "陟" "疐" "贄" "觶" "騭" "櫛"))
    ((("z" "h" "o" "n" "g")) ("中" "忠" "終" "鐘" "鍾" "衷" "盅" "忪" "種" "踵" "塚" "冢" "腫" "眾" "重" "仲"))
    ((("z" "h" "o" "u")) ("周" "週" "州" "洲" "舟" "粥" "啁" "賙" "謅" "妯" "軸" "肘" "帚" "咒" "宙" "晝" "冑" "紂" "驟" "皺" "縐" "籀"))
    ((("z" "h" "u")) ("朱" "珠" "株" "諸" "豬" "誅" "銖" "蛛" "侏" "茱" "姝" "櫫" "硃" "竹" "築" "逐" "燭" "筑" "竺" "朮" "躅" "蠋" "舳" "主" "煮" "渚" "拄" "矚" "囑" "住" "注" "註" "著" "助" "柱" "祝" "駐" "鑄" "佇" "蛀" "杼" "箸" "貯" "炷"))
    ((("z" "h" "u" "a")) ("抓" "爪"))
    ((("z" "h" "u" "a" "i")) ("拽" "跩"))
    ((("z" "h" "u" "a" "n")) ("專" "磚" "耑" "顓" "轉" "傳" "賺" "撰" "篆" "囀"))
    ((("z" "h" "u" "a" "n" "g")) ("裝" "莊" "妝" "粧" "樁" "奘" "狀" "壯" "撞" "幢" "戇" "僮"))
    ((("z" "h" "u" "i")) ("追" "錐" "隹" "椎" "墜" "綴" "贅" "醊" "惴" "縋"))
    ((("z" "h" "u" "n")) ("屯" "肫" "諄" "准" "準" "埻" "隼"))
    ((("z" "h" "u" "o")) ("捉" "桌" "卓" "拙" "涿" "焯" "濁" "灼" "酌" "茁" "啄" "斫" "琢" "鐲" "著" "擢" "濯"))
    ((("z" "i")) ("諮" "姿" "咨" "茲" "滋" "資" "貲" "孜" "孳" "輜" "緇" "錙" "吱" "淄" "髭" "齜" "孖" "仔" "ㄗ" "子" "姊" "籽" "梓" "紫" "滓" "訾" "秭" "自" "字" "恣" "漬" "牸" "眥"))
    ((("z" "o" "n" "g")) ("宗" "綜" "縱" "蹤" "棕" "鬃" "總" "從" "粽"))
    ((("z" "o" "u")) ("鄒" "諏" "走" "奏" "揍"))
    ((("z" "u")) ("租" "足" "族" "卒" "鏃" "組" "祖" "阻" "詛" "俎"))
    ((("z" "u" "a" "n")) ("鑽" "躦" "纂" "纘" "賺" "攥"))
    ((("z" "u" "i")) ("堆" "嘴" "最" "罪" "醉" "蕞"))
    ((("z" "u" "n")) ("尊" "遵" "樽" "鱒" "撙"))
    ((("z" "u" "o")) ("作" "嘬" "昨" "捽" "左" "佐" "撮" "做" "坐" "座" "鑿" "祚" "怍" "胙" "酢"))

    ((("1")) ("1"))
    ((("2")) ("2"))
    ((("3")) ("3"))
    ((("4")) ("4"))
    ((("5")) ("5"))
    ((("6")) ("6"))
    ((("7")) ("7"))
    ((("8")) ("8"))
    ((("9")) ("9"))
    ((("0")) ("0"))

    (((",")) ("，"))
    (((".")) ("。"))
    ((("?")) ("？"))
    ((("!")) ("！"))
    ((("\"")) ("”"))
    ((("#")) ("＃"))
    ((("$")) ("＄"))
    ((("%")) ("％"))
    ((("&")) ("＆"))
    ((("'")) ("’"))
    ((("(")) ("（"))
    (((")")) ("）"))
    ((("=")) ("＝"))
    ((("^")) ("＾"))
    ((("\\")) ("＼"))
    ((("|")) ("｜"))
    ((("`")) ("‘"))
    ((("@")) ("＠"))
    ((("+")) ("＋"))
    (((";")) ("；"))
    ((("*")) ("＊"))
    (((":")) ("："))
    ((("}")) ("｝"))
    ((("<")) ("＜"))
    (((">")) ("＞"))
    ((("/")) ("／"))
    ((("_")) ("＿"))

;; Tones 

    ((("a" "4")) ("阿"))
    ((("a" "1")) ("啊"))
    ((("a" "i" "2")) ("捱" "呆" "癌" "皚"))
    ((("a" "i" "3")) ("矮" "藹" "靄" "欸" "毐"))
    ((("a" "i" "4")) ("愛" "礙" "艾" "曖" "璦" "隘" "噯" "嬡"))
    ((("a" "n" "3")) ("俺" "唵"))
    ((("a" "n" "4")) ("案" "按" "暗" "岸" "黯" "闇" "犴"))
    ((("a" "n" "g" "2")) ("昂"))
    ((("a" "n" "g" "4")) ("盎"))
    ((("a" "o" "2")) ("熬" "敖" "遨" "翱" "嗷" "螯" "鰲" "鼇" "驁" "獒"))
    ((("a" "o" "3")) ("襖" "拗" "媼"))
    ((("a" "o" "4")) ("傲" "澳" "奧" "懊" "坳" "拗"))
    ((("b" "a" "2")) ("拔" "跋" "鈸"))
    ((("b" "a" "3")) ("把" "靶"))
    ((("b" "a" "4")) ("爸" "罷" "霸" "壩" "灞" "耙"))
    ((("b" "a" "1")) ("吧" "罷"))
    ((("b" "a" "i" "2")) ("白"))
    ((("b" "a" "i" "3")) ("百" "佰" "擺" "襬" "柏"))
    ((("b" "a" "i" "4")) ("敗" "拜"))
    ((("b" "a" "n" "3")) ("板" "版" "闆" "阪" "舨"))
    ((("b" "a" "n" "4")) ("半" "辦" "伴" "扮" "拌" "絆" "瓣" "爿"))
    ((("b" "a" "n" "g" "3")) ("榜" "綁" "膀"))
    ((("b" "a" "n" "g" "4")) ("棒" "磅" "謗" "蚌" "傍" "鎊" "£"))
    ((("b" "a" "o" "2")) ("薄" "雹"))
    ((("b" "a" "o" "3")) ("保" "寶" "飽" "堡" "褓" "葆" "鴇"))
    ((("b" "a" "o" "4")) ("報" "抱" "暴" "爆" "豹" "趵" "鮑" "刨" "菢"))
    ((("b" "e" "i" "3")) ("北"))
    ((("b" "e" "i" "4")) ("被" "備" "背" "貝" "輩" "倍" "臂" "狽" "憊" "悖" "孛" "焙" "蓓"))
    ((("b" "e" "i" "1")) ("唄"))
    ((("b" "e" "n" "3")) ("本" "苯" "畚"))
    ((("b" "e" "n" "4")) ("笨"))
    ((("b" "e" "n" "g" "2")) ("甭"))
    ((("b" "e" "n" "g" "4")) ("蹦" "迸"))
    ((("b" "i" "2")) ("鼻"))
    ((("b" "i" "3")) ("比" "筆" "彼" "鄙" "匕" "秕" "妣"))
    ((("b" "i" "4")) ("必" "敝" "畢" "壁" "璧" "碧" "避" "閉" "幣" "弊" "斃" "蔽" "臂" "泌" "婢" "俾" "庇" "嗶" "愎" "辟" "弼" "裨" "陛" "篦" "畀" "嬖" "睥" "襞" "篳" "蹕" "髀" "痺" "毖"))
    ((("b" "i" "a" "n" "3")) ("扁" "貶" "匾"))
    ((("b" "i" "a" "n" "4")) ("便" "變" "遍" "辨" "辯" "汴" "卞" "辮" "弁"))
    ((("b" "i" "a" "o" "3")) ("表" "錶" "婊" "裱"))
    ((("b" "i" "a" "o" "4")) ("鰾"))
    ((("b" "i" "e" "2")) ("別" "蹩"))
    ((("b" "i" "e" "3")) ("癟"))
    ((("b" "i" "e" "4")) ("彆"))
    ((("b" "i" "n" "4")) ("殯" "鬢" "擯" "髕"))
    ((("b" "i" "n" "g" "3")) ("餅" "丙" "稟" "柄" "秉" "炳" "昺"))
    ((("b" "i" "n" "g" "4")) ("並" "病" "併" "并" "摒"))
    ((("b" "o" "2")) ("伯" "博" "柏" "泊" "勃" "搏" "渤" "駁" "薄" "礡" "脖" "帛" "舶" "箔" "蔔" "膊" "鈸" "餑" "鉑" "鵓" "踣" "亳"))
    ((("b" "o" "3")) ("跛" "簸"))
    ((("b" "o" "4")) ("播" "擘" "簸" "薄"))
    ((("b" "u" "3")) ("補" "捕" "埔" "哺" "堡" "卜"))
    ((("b" "u" "4")) ("不" "部" "布" "步" "怖" "佈" "簿" "埠"))
    ((("c" "a" "i" "2")) ("才" "財" "材" "裁"))
    ((("c" "a" "i" "3")) ("採" "彩" "采" "睬" "踩" "綵"))
    ((("c" "a" "i" "4")) ("菜" "蔡" "埰"))
    ((("c" "a" "n" "2")) ("殘" "蠶" "慚"))
    ((("c" "a" "n" "3")) ("慘"))
    ((("c" "a" "n" "4")) ("燦" "孱" "璨" "粲"))
    ((("c" "a" "n" "g" "2")) ("藏"))
    ((("c" "a" "o" "2")) ("曹" "槽" "嘈" "漕" "螬" "艚"))
    ((("c" "a" "o" "3")) ("草" "艸"))
    ((("c" "a" "o" "4")) ("操"))
    ((("c" "e" "4")) ("冊" "策" "測" "側" "廁" "惻"))
    ((("c" "e" "n" "2")) ("岑" "涔"))
    ((("c" "e" "n" "g" "2")) ("曾" "層" "嶒"))
    ((("c" "e" "n" "g" "4")) ("蹭"))
    ((("c" "h" "a" "2")) ("查" "察" "茶" "搽" "槎"))
    ((("c" "h" "a" "4")) ("詫" "岔" "剎" "差" "汊" "衩"))
    ((("c" "h" "a" "i" "2")) ("柴" "豺" "儕"))
    ((("c" "h" "a" "i" "4")) ("蠆"))
    ((("c" "h" "a" "n" "2")) ("纏" "蟬" "禪" "饞" "讒" "潺" "蟾" "巉" "嬋" "澶" "廛" "孱" "鑱"))
    ((("c" "h" "a" "n" "3")) ("產" "鏟" "闡" "剷" "諂"))
    ((("c" "h" "a" "n" "4")) ("懺"))
    ((("c" "h" "a" "n" "g" "2")) ("長" "常" "場" "嘗" "裳" "償" "腸" "嫦" "徜" "嚐"))
    ((("c" "h" "a" "n" "g" "3")) ("場" "廠" "敞" "氅" "昶"))
    ((("c" "h" "a" "n" "g" "4")) ("唱" "倡" "暢" "悵" "鬯"))
    ((("c" "h" "a" "o" "2")) ("朝" "潮" "巢" "嘲" "晁"))
    ((("c" "h" "a" "o" "3")) ("吵" "炒"))
    ((("c" "h" "e" "3")) ("扯"))
    ((("c" "h" "e" "4")) ("徹" "澈" "轍" "撤" "掣" "坼"))
    ((("c" "h" "e" "n" "2")) ("陳" "沉" "晨" "臣" "塵" "辰" "忱" "諶"))
    ((("c" "h" "e" "n" "3")) ("磣"))
    ((("c" "h" "e" "n" "4")) ("趁" "襯" "讖"))
    ((("c" "h" "e" "n" "g" "2")) ("成" "程" "承" "乘" "誠" "呈" "城" "懲" "澄" "橙" "丞" "澂" "酲" "晟" "裎" "埕"))
    ((("c" "h" "e" "n" "g" "3")) ("逞" "騁"))
    ((("c" "h" "e" "n" "g" "4")) ("稱" "秤"))
    ((("c" "h" "i" "2")) ("持" "池" "遲" "馳" "匙" "弛" "踟" "墀"))
    ((("c" "h" "i" "3")) ("尺" "齒" "恥" "呎" "侈" "褫" "豉"))
    ((("c" "h" "i" "4")) ("赤" "翅" "斥" "飭" "叱" "熾" "啻" "敕" "彳"))
    ((("c" "h" "o" "n" "g" "2")) ("重" "崇" "蟲" "虫"))
    ((("c" "h" "o" "n" "g" "3")) ("寵"))
    ((("c" "h" "o" "n" "g" "4")) ("銃"))
    ((("c" "h" "o" "u" "2")) ("愁" "仇" "籌" "綢" "酬" "稠" "紬" "躊" "疇" "惆" "裯" "儔" "讎"))
    ((("c" "h" "o" "u" "3")) ("丑" "醜" "瞅"))
    ((("c" "h" "o" "u" "4")) ("臭"))
    ((("c" "h" "u" "2")) ("除" "儲" "廚" "鋤" "櫥" "雛" "芻" "躇" "滁" "躕" "蜍" "鉏" "鶵"))
    ((("c" "h" "u" "3")) ("處" "楚" "儲" "礎" "杵" "褚" "楮"))
    ((("c" "h" "u" "4")) ("處" "觸" "畜" "搐" "絀" "矗" "黜" "俶" "怵"))
    ((("c" "h" "u" "a" "i" "3")) ("揣"))
    ((("c" "h" "u" "a" "i" "4")) ("踹"))
    ((("c" "h" "u" "a" "n" "2")) ("傳" "船" "遄" "椽"))
    ((("c" "h" "u" "a" "n" "3")) ("喘"))
    ((("c" "h" "u" "a" "n" "4")) ("串" "釧"))
    ((("c" "h" "u" "a" "n" "g" "2")) ("床" "幢"))
    ((("c" "h" "u" "a" "n" "g" "3")) ("闖"))
    ((("c" "h" "u" "a" "n" "g" "4")) ("創" "闖" "愴"))
    ((("c" "h" "u" "i" "2")) ("垂" "鎚" "槌" "搥" "椎" "陲" "錘" "捶" "棰"))
    ((("c" "h" "u" "n" "2")) ("純" "唇" "醇" "淳" "鶉" "脣"))
    ((("c" "h" "u" "n" "3")) ("蠢"))
    ((("c" "h" "u" "o" "4")) ("綽" "輟" "齪" "啜" "惙" "醊"))
    ((("c" "i" "2")) ("詞" "辭" "慈" "磁" "瓷" "雌" "祠" "茨" "餈"))
    ((("c" "i" "3")) ("此" "泚"))
    ((("c" "i" "4")) ("次" "刺" "賜" "廁" "伺"))
    ((("c" "o" "n" "g" "2")) ("從" "叢" "淙" "琮"))
    ((("c" "o" "u" "4")) ("湊"))
    ((("c" "u" "2")) ("殂" "徂"))
    ((("c" "u" "4")) ("促" "醋" "簇" "蹴" "蹙" "猝" "鏃" "踧"))
    ((("c" "u" "a" "n" "2")) ("攢"))
    ((("c" "u" "a" "n" "4")) ("竄" "篡" "爨" "篹"))
    ((("c" "u" "i" "3")) ("璀"))
    ((("c" "u" "i" "4")) ("翠" "脆" "粹" "悴" "瘁" "萃" "啐" "淬" "橇"))
    ((("c" "u" "n" "2")) ("存"))
    ((("c" "u" "n" "3")) ("忖"))
    ((("c" "u" "n" "4")) ("寸" "吋"))
    ((("c" "u" "o" "2")) ("嵯"))
    ((("c" "u" "o" "4")) ("錯" "措" "挫" "銼" "厝"))
    ((("d" "1")) ("的"))
    ((("d" "a" "2")) ("答" "達" "韃" "靼" "瘩" "怛" "妲" "笪"))
    ((("d" "a" "3")) ("打"))
    ((("d" "a" "4")) ("大"))
    ((("d" "a" "i" "3")) ("歹" "逮"))
    ((("d" "a" "i" "4")) ("代" "帶" "待" "袋" "戴" "怠" "殆" "黛" "貸" "迨" "玳" "岱" "逮"))
    ((("d" "a" "n" "3")) ("膽" "疸" "撢" "亶"))
    ((("d" "a" "n" "4")) ("但" "旦" "淡" "蛋" "誕" "擔" "彈" "憚" "氮" "啖" "澹"))
    ((("d" "a" "n" "g" "3")) ("擋" "黨" "讜"))
    ((("d" "a" "n" "g" "4")) ("檔" "當" "蕩" "盪" "擋" "宕"))
    ((("d" "a" "o" "3")) ("倒" "島" "導" "禱" "搗"))
    ((("d" "a" "o" "4")) ("到" "道" "倒" "稻" "盜" "蹈" "悼" "纛"))
    ((("d" "e" "2")) ("得" "德"))
    ((("d" "e" "1")) ("得" "的" "地" "底"))
    ((("d" "e" "i" "3")) ("得"))
    ((("d" "e" "n" "g" "3")) ("等" "戥"))
    ((("d" "e" "n" "g" "4")) ("鄧" "瞪" "蹬" "凳" "磴"))
    ((("d" "i" "2")) ("的" "敵" "迪" "狄" "笛" "滌" "翟" "荻" "嘀" "鏑" "蹢" "糴"))
    ((("d" "i" "3")) ("底" "抵" "邸" "詆" "牴" "砥" "氐" "柢"))
    ((("d" "i" "4")) ("地" "第" "弟" "帝" "遞" "蒂" "的" "締" "諦" "娣" "睇" "棣"))
    ((("d" "i" "a" "n" "3")) ("點" "典" "碘"))
    ((("d" "i" "a" "n" "4")) ("電" "店" "殿" "甸" "奠" "墊" "澱" "惦" "癜" "靛" "佃" "淀" "玷" "鈿"))
    ((("d" "i" "a" "o" "3")) ("屌"))
    ((("d" "i" "a" "o" "4")) ("調" "掉" "釣" "吊" "弔" "蓧"))
    ((("d" "i" "e" "2")) ("碟" "蝶" "諜" "疊" "迭" "牒" "喋" "瓞" "咥" "垤" "蹀"))
    ((("d" "i" "n" "g" "3")) ("頂" "鼎" "酊"))
    ((("d" "i" "n" "g" "4")) ("定" "訂" "釘" "錠" "碇"))
    ((("d" "o" "n" "g" "3")) ("懂" "董"))
    ((("d" "o" "n" "g" "4")) ("動" "洞" "凍" "棟" "恫" "胴"))
    ((("d" "o" "u" "3")) ("斗" "抖" "陡" "蚪" "枓"))
    ((("d" "o" "u" "4")) ("鬥" "豆" "荳" "逗" "痘" "竇" "餖" "讀"))
    ((("d" "u" "2")) ("讀" "獨" "毒" "牘" "纛" "瀆" "犢" "黷"))
    ((("d" "u" "3")) ("賭" "睹" "篤" "堵" "肚"))
    ((("d" "u" "4")) ("度" "渡" "杜" "妒" "肚" "鍍" "蠹" "℃" "°" "℉"))
    ((("d" "u" "a" "n" "3")) ("短"))
    ((("d" "u" "a" "n" "4")) ("段" "斷" "緞" "鍛"))
    ((("d" "u" "i" "4")) ("對" "隊" "兌" "懟"))
    ((("d" "u" "n" "3")) ("盹" "躉"))
    ((("d" "u" "n" "4")) ("頓" "盾" "鈍" "遁" "盹" "燉" "沌" "、" "炖"))
    ((("d" "u" "o" "2")) ("奪" "度" "踱" "鐸"))
    ((("d" "u" "o" "3")) ("躲" "朵" "埵" "垛"))
    ((("d" "u" "o" "4")) ("惰" "墮" "舵" "跺" "剁" "馱" "垛"))
    ((("e" "2")) ("額" "訛" "鵝" "娥" "哦" "蛾" "峨" "莪" "俄" "惡"))
    ((("e" "3")) ("欸"))
    ((("e" "4")) ("惡" "餓" "厄" "遏" "扼" "鱷" "顎" "呃" "愕" "噩" "軛" "鄂" "鍔" "鶚" "諤" "萼" "頞"))
    ((("e" "i" "3")) ("欸"))
    ((("e" "i" "4")) ("欸"))
    ((("e" "n" "4")) ("摁"))
    ((("e" "r" "2")) ("而" "兒"))
    ((("e" "r" "3")) ("爾" "耳" "洱" "餌" "邇"))
    ((("e" "r" "4")) ("二" "貳" "佴"))
    ((("f" "a" "2")) ("乏" "伐" "罰" "閥" "筏" "砝"))
    ((("f" "a" "3")) ("法"))
    ((("f" "a" "4")) ("髮" "法" "琺"))
    ((("f" "a" "n" "2")) ("凡" "煩" "繁" "帆" "蕃" "礬" "藩" "樊" "膰"))
    ((("f" "a" "n" "3")) ("反" "返"))
    ((("f" "a" "n" "4")) ("範" "范" "犯" "氾" "汎" "飯" "販" "泛" "梵" "畈"))
    ((("f" "a" "n" "g" "2")) ("房" "防" "妨" "肪" "坊"))
    ((("f" "a" "n" "g" "3")) ("訪" "彷" "仿" "紡" "倣" "舫" "昉" "髣"))
    ((("f" "a" "n" "g" "4")) ("放"))
    ((("f" "e" "i" "2")) ("肥" "淝" "腓"))
    ((("f" "e" "i" "3")) ("匪" "翡" "斐" "蜚" "誹" "悱" "菲" "榧"))
    ((("f" "e" "i" "4")) ("廢" "費" "肺" "沸" "吠" "痱" "怫" "芾" "狒" "剕"))
    ((("f" "e" "n" "2")) ("墳" "焚" "汾" "棼" "濆"))
    ((("f" "e" "n" "3")) ("粉"))
    ((("f" "e" "n" "4")) ("份" "忿" "奮" "憤" "分" "糞"))
    ((("f" "e" "n" "g" "2")) ("逢" "縫" "馮"))
    ((("f" "e" "n" "g" "3")) ("諷"))
    ((("f" "e" "n" "g" "4")) ("奉" "鳳" "俸" "諷" "縫"))
    ((("f" "o" "2")) ("佛"))
    ((("f" "o" "u" "3")) ("否" "缶"))
    ((("f" "u" "2")) ("服" "福" "扶" "浮" "符" "伏" "彿" "幅" "俘" "拂" "弗" "孚" "袱" "芙" "苻" "輻" "蝠" "匐" "怫" "茯" "蜉" "氟"))
    ((("f" "u" "3")) ("府" "腐" "撫" "輔" "甫" "斧" "俯" "釜" "脯" "腑" "拊"))
    ((("f" "u" "4")) ("父" "負" "婦" "付" "附" "富" "復" "副" "傅" "覆" "複" "腹" "咐" "赴" "賦" "縛" "駙" "訃" "阜" "馥"))
    ((("g" "a" "2")) ("軋" "噶"))
    ((("g" "a" "3")) ("嘎"))
    ((("g" "a" "4")) ("尬"))
    ((("g" "a" "i" "3")) ("改"))
    ((("g" "a" "i" "4")) ("概" "蓋" "丐" "鈣" "溉"))
    ((("g" "a" "n" "3")) ("敢" "感" "趕" "桿" "橄" "稈" "澉"))
    ((("g" "a" "n" "4")) ("幹" "贛" "淦" "紺" "榦"))
    ((("g" "a" "n" "g" "3")) ("港" "崗"))
    ((("g" "a" "n" "g" "4")) ("鋼" "槓"))
    ((("g" "a" "o" "3")) ("稿" "攪" "搞" "槁" "縞" "杲"))
    ((("g" "a" "o" "4")) ("告" "誥" "郜"))
    ((("g" "e" "2")) ("格" "革" "隔" "閣" "葛" "骼" "蛤" "膈" "嗝" "□" "轕" "閤" "鎘"))
    ((("g" "e" "3")) ("葛" "舸"))
    ((("g" "e" "4")) ("各" "個" "鉻" "箇"))
    ((("g" "e" "1")) ("個"))
    ((("g" "e" "i" "3")) ("給"))
    ((("g" "e" "n" "3")) ("艮"))
    ((("g" "e" "n" "4")) ("亙" "艮"))
    ((("g" "e" "n" "g" "3")) ("梗" "耿" "哽" "綆" "鯁" "埂" "骾"))
    ((("g" "e" "n" "g" "4")) ("更"))
    ((("g" "o" "n" "g" "3")) ("鞏" "拱" "汞" "栱"))
    ((("g" "o" "n" "g" "4")) ("共" "供" "貢"))
    ((("g" "o" "u" "3")) ("狗" "茍" "岣" "枸"))
    ((("g" "o" "u" "4")) ("夠" "購" "垢" "構" "媾" "彀" "搆" "詬"))
    ((("g" "u" "2")) ("骨"))
    ((("g" "u" "3")) ("股" "古" "鼓" "骨" "谷" "穀" "賈" "蠱" "牯" "罟" "詁" "轂" "鵠" "瞽" "汨" "鈷"))
    ((("g" "u" "4")) ("故" "固" "顧" "雇" "僱" "錮" "估" "痼" "梏"))
    ((("g" "u" "a" "3")) ("寡" "剮"))
    ((("g" "u" "a" "4")) ("掛" "卦" "褂" "挂"))
    ((("g" "u" "a" "i" "3")) ("拐" "枴"))
    ((("g" "u" "a" "i" "4")) ("怪"))
    ((("g" "u" "a" "n" "3")) ("管" "館" "莞" "琯"))
    ((("g" "u" "a" "n" "4")) ("觀" "慣" "貫" "冠" "灌" "罐" "摜" "盥" "鸛"))
    ((("g" "u" "a" "n" "g" "3")) ("廣" "獷"))
    ((("g" "u" "a" "n" "g" "4")) ("逛"))
    ((("g" "u" "i" "3")) ("鬼" "軌" "詭" "癸" "晷" "簋"))
    ((("g" "u" "i" "4")) ("貴" "桂" "櫃" "劊" "檜" "柜" "跪" "劌" "鱖"))
    ((("g" "u" "i" "1")) ("瑰"))
    ((("g" "u" "n" "3")) ("滾" "袞" "鯀"))
    ((("g" "u" "n" "4")) ("棍"))
    ((("g" "u" "o" "2")) ("國" "幗" "虢" "摑"))
    ((("g" "u" "o" "3")) ("果" "裹" "槨" "蜾"))
    ((("g" "u" "o" "4")) ("過"))
    ((("h" "a" "2")) ("蛤"))
    ((("h" "a" "3")) ("哈"))
    ((("h" "a" "4")) ("哈"))
    ((("h" "a" "i" "2")) ("還" "孩" "骸" "頦"))
    ((("h" "a" "i" "3")) ("海" "醢"))
    ((("h" "a" "i" "4")) ("害" "亥" "駭" "氦" "嗐"))
    ((("h" "a" "n" "2")) ("寒" "含" "函" "涵" "韓" "邯" "汗" "邗"))
    ((("h" "a" "n" "3")) ("喊" "罕"))
    ((("h" "a" "n" "4")) ("漢" "汗" "旱" "焊" "憾" "翰" "撼" "悍" "頷" "瀚" "捍"))
    ((("h" "a" "n" "g" "2")) ("行" "航" "杭" "吭"))
    ((("h" "a" "n" "g" "4")) ("巷" "沆"))
    ((("h" "a" "o" "2")) ("號" "毫" "豪" "壕" "濠" "蠔" "貉" "嚎" "嗥"))
    ((("h" "a" "o" "3")) ("好" "郝"))
    ((("h" "a" "o" "4")) ("號" "耗" "浩" "皓" "鎬" "昊" "好" "灝" "顥" "鄗" "皞"))
    ((("h" "e" "2")) ("和" "合" "何" "河" "荷" "核" "盒" "禾" "褐" "劾" "闔" "閤" "曷" "龢" "涸" "盍" "覈" "貉" "閡" "紇" "翮" "鞨"))
    ((("h" "e" "4")) ("賀" "和" "鶴" "喝" "荷" "嚇" "赫" "壑"))
    ((("h" "e" "n" "2")) ("痕"))
    ((("h" "e" "n" "3")) ("很" "狠"))
    ((("h" "e" "n" "4")) ("恨"))
    ((("h" "e" "n" "g" "2")) ("橫" "恆" "衡" "珩" "蘅" "桁" "姮"))
    ((("h" "e" "n" "g" "4")) ("橫"))
    ((("h" "o" "n" "g" "2")) ("紅" "洪" "宏" "鴻" "虹" "弘" "泓" "訌" "閎" "黌" "竑"))
    ((("h" "o" "n" "g" "3")) ("哄"))
    ((("h" "o" "n" "g" "4")) ("鬨" "蕻"))
    ((("h" "o" "u" "2")) ("猴" "侯" "喉" "篌" "餱"))
    ((("h" "o" "u" "3")) ("吼"))
    ((("h" "o" "u" "4")) ("後" "候" "厚" "后" "鱟" "垕" "逅"))
    ((("h" "u" "2")) ("胡" "湖" "壺" "蝴" "糊" "狐" "弧" "葫" "鬍" "瑚" "餬" "斛" "鵠" "囫" "縠" "觳" "猢"))
    ((("h" "u" "3")) ("虎" "琥" "滸" "唬"))
    ((("h" "u" "4")) ("護" "戶" "互" "滬" "扈" "瓠" "怙" "祜" "笏" "岵"))
    ((("h" "u" "a" "2")) ("華" "滑" "划" "譁" "猾" "嘩" "驊" "鏵"))
    ((("h" "u" "a" "4")) ("話" "化" "畫" "劃" "樺" "華"))
    ((("h" "u" "a" "i" "2")) ("懷" "淮" "徊" "槐" "踝"))
    ((("h" "u" "a" "i" "4")) ("壞"))
    ((("h" "u" "a" "n" "2")) ("還" "環" "桓" "繯" "鬟" "鍰" "鐶" "寰"))
    ((("h" "u" "a" "n" "3")) ("緩"))
    ((("h" "u" "a" "n" "4")) ("換" "喚" "宦" "患" "幻" "煥" "奐" "渙" "瘓" "豢" "鯇" "擐" "漶"))
    ((("h" "u" "a" "n" "g" "2")) ("黃" "徨" "惶" "簧" "璜" "磺" "蝗" "煌" "皇" "凰" "遑" "隍" "潢" "篁" "喤" "艎" "蟥"))
    ((("h" "u" "a" "n" "g" "3")) ("謊" "恍" "晃" "幌"))
    ((("h" "u" "a" "n" "g" "4")) ("晃"))
    ((("h" "u" "i" "2")) ("回" "迴" "蛔" "茴" "洄"))
    ((("h" "u" "i" "3")) ("悔" "毀" "燬" "譭"))
    ((("h" "u" "i" "4")) ("會" "惠" "匯" "繪" "慧" "彙" "穢" "誨" "賄" "晦" "彗" "諱" "潰" "卉" "蕙" "檜" "燴" "喙" "薈" "蟪"))
    ((("h" "u" "n" "2")) ("魂" "渾" "餛" "混" "琿"))
    ((("h" "u" "n" "4")) ("混" "渾" "溷" "諢"))
    ((("h" "u" "o" "2")) ("活"))
    ((("h" "u" "o" "3")) ("火" "伙" "夥"))
    ((("h" "u" "o" "4")) ("或" "穫" "獲" "和" "惑" "禍" "霍" "貨" "豁" "壑" "蠖" "鑊" "藿"))
    ((("j" "i" "2")) ("及" "級" "極" "即" "集" "急" "擊" "疾" "籍" "藉" "吉" "寂" "輯" "脊" "嫉" "亟" "棘" "汲" "瘠" "楫" "岌" "笈" "戢" "殛" "蹐" "伋" "蒺" "佶" "詰" "踖"))
    ((("j" "i" "3")) ("幾" "給" "己" "紀" "擠" "脊" "戟" "濟" "掎"))
    ((("j" "i" "4")) ("記" "既" "計" "紀" "際" "繼" "季" "寄" "技" "妓" "濟" "劑" "繫" "悸" "祭" "忌" "暨" "冀" "鯽" "稷" "薺" "驥" "霽" "薊" "髻" "覬" "伎" "洎" "跽"))
    ((("j" "i" "a" "2")) ("夾" "挾" "頰" "蛺" "戛" "鋏"))
    ((("j" "i" "a" "3")) ("假" "甲" "賈" "鉀" "岬" "胛"))
    ((("j" "i" "a" "4")) ("價" "假" "架" "駕" "嫁" "稼"))
    ((("j" "i" "a" "n" "3")) ("簡" "撿" "檢" "剪" "減" "揀" "繭" "儉" "鹼" "柬" "筧" "翦" "謇" "蹇" "譾"))
    ((("j" "i" "a" "n" "4")) ("見" "建" "健" "件" "間" "監" "鍵" "鑑" "箭" "劍" "艦" "鑒" "賤" "踐" "諫" "毽" "薦" "餞" "腱" "濺" "僭" "檻" "漸" "澗" "荐" "→" "↑" "↓" "←"))
    ((("j" "i" "a" "n" "g" "3")) ("講" "獎" "蔣" "槳"))
    ((("j" "i" "a" "n" "g" "4")) ("降" "匠" "醬" "將" "絳" "糨"))
    ((("j" "i" "a" "o" "2")) ("嚼"))
    ((("j" "i" "a" "o" "3")) ("腳" "角" "繳" "攪" "勦" "矯" "絞" "佼" "餃" "皎" "僥" "剿" "鉸" "狡" "撟"))
    ((("j" "i" "a" "o" "4")) ("教" "叫" "校" "較" "覺" "轎" "窖" "醮" "徼" "斠" "滘"))
    ((("j" "i" "e" "2")) ("結" "節" "潔" "傑" "捷" "竭" "劫" "截" "杰" "頡" "詰" "桀" "睫" "訐" "拮" "羯" "桔" "孑" "絜" "偈" "婕" "碣"))
    ((("j" "i" "e" "3")) ("解" "姐"))
    ((("j" "i" "e" "4")) ("界" "借" "介" "戒" "藉" "屆" "疥" "芥" "誡" "解" "唶" "玠" "蚧" "价"))
    ((("j" "i" "n" "3")) ("緊" "僅" "錦" "謹" "儘" "瑾" "饉" "巹"))
    ((("j" "i" "n" "4")) ("進" "近" "盡" "禁" "晉" "浸" "勁" "覲" "燼" "噤" "妗" "靳" "縉" "搢" "殣"))
    ((("j" "i" "n" "g" "3")) ("景" "警" "井" "頸" "阱" "儆" "璟" "憬" "剄"))
    ((("j" "i" "n" "g" "4")) ("敬" "竟" "鏡" "靜" "境" "淨" "競" "逕" "徑" "靖" "勁" "脛" "痙" "靚"))
    ((("j" "i" "o" "n" "g" "3")) ("窘" "迥" "炯" "炅" "絅" "冏" "熲"))
    ((("j" "i" "u" "3")) ("九" "久" "酒" "玖" "赳" "灸" "韭" "糾"))
    ((("j" "i" "u" "4")) ("就" "究" "救" "舊" "舅" "臼" "柩" "疚" "咎" "鷲" "廄" "僦"))
    ((("j" "u" "2")) ("局" "鞠" "菊" "橘" "掬" "跼" "桔" "鞫" "侷" "焗"))
    ((("j" "u" "3")) ("舉" "矩" "咀" "莒" "沮" "齟" "櫸" "筥" "踽"))
    ((("j" "u" "4")) ("據" "句" "具" "巨" "劇" "聚" "俱" "拒" "距" "鋸" "懼" "鉅" "炬" "詎" "遽" "倨" "瞿" "踞" "颶" "苣" "屨" "醵"))
    ((("j" "u" "a" "n" "3")) ("捲"))
    ((("j" "u" "a" "n" "4")) ("卷" "倦" "眷" "絹" "雋" "狷"))
    ((("j" "u" "e" "2")) ("決" "覺" "絕" "角" "爵" "掘" "嚼" "訣" "厥" "獗" "蹶" "蕨" "崛" "攫" "倔" "抉" "噱" "矍" "孓" "玨" "橛" "爝" "譎" "鐍"))
    ((("j" "u" "e" "3")) ("蹶"))
    ((("j" "u" "e" "4")) ("倔"))
    ((("j" "u" "n" "4")) ("菌" "郡" "俊" "峻" "竣" "雋" "濬" "駿" "浚" "珺" "畯"))
    ((("k" "a" "3")) ("卡" "咭" "咯"))
    ((("k" "a" "i" "3")) ("凱" "楷" "慨" "愷" "剴" "鎧" "闓" "鍇"))
    ((("k" "a" "i" "4")) ("愾" "欬"))
    ((("k" "a" "n" "3")) ("砍" "侃" "坎" "檻"))
    ((("k" "a" "n" "4")) ("看" "瞰" "勘" "崁" "闞" "磡" "墈"))
    ((("k" "a" "n" "g" "2")) ("扛"))
    ((("k" "a" "n" "g" "3")) ("慷"))
    ((("k" "a" "n" "g" "4")) ("抗" "亢" "炕" "伉"))
    ((("k" "a" "o" "3")) ("考" "烤" "拷" "栲" "攷"))
    ((("k" "a" "o" "4")) ("靠" "銬" "犒"))
    ((("k" "e" "2")) ("咳" "殼"))
    ((("k" "e" "3")) ("可" "渴" "坷"))
    ((("k" "e" "4")) ("客" "克" "課" "刻" "剋" "溘" "恪" "嗑" "兛"))
    ((("k" "e" "n" "3")) ("肯" "啃" "墾" "懇" "齦"))
    ((("k" "e" "n" "4")) ("掯"))
    ((("k" "o" "n" "g" "3")) ("恐" "孔" "倥"))
    ((("k" "o" "n" "g" "4")) ("控" "空"))
    ((("k" "o" "u" "3")) ("口"))
    ((("k" "o" "u" "4")) ("扣" "寇" "叩" "蔻" "筘"))
    ((("k" "u" "3")) ("苦"))
    ((("k" "u" "4")) ("庫" "褲" "酷" "嚳"))
    ((("k" "u" "a" "3")) ("垮" "侉"))
    ((("k" "u" "a" "4")) ("跨" "胯" "挎"))
    ((("k" "u" "a" "i" "3")) ("蒯"))
    ((("k" "u" "a" "i" "4")) ("快" "塊" "會" "筷" "儈" "獪" "澮" "膾" "噲" "鄶"))
    ((("k" "u" "a" "n" "3")) ("款"))
    ((("k" "u" "a" "n" "g" "2")) ("狂" "誑"))
    ((("k" "u" "a" "n" "g" "4")) ("況" "礦" "曠" "框" "眶" "鄺" "壙"))
    ((("k" "u" "i" "2")) ("葵" "睽" "奎" "揆" "魁" "逵" "夔" "暌" "馗"))
    ((("k" "u" "i" "3")) ("傀" "跬"))
    ((("k" "u" "i" "4")) ("愧" "潰" "匱" "饋" "喟" "簣" "聵" "憒"))
    ((("k" "u" "n" "3")) ("捆" "綑" "悃"))
    ((("k" "u" "n" "4")) ("困" "睏"))
    ((("k" "u" "o" "4")) ("括" "擴" "闊" "廓" "蛞" "（" "）" "【" "】"))
    ((("l" "a" "2")) ("剌" "旯"))
    ((("l" "a" "3")) ("喇"))
    ((("l" "a" "4")) ("臘" "蠟" "辣" "剌" "腊" "瘌" "落"))
    ((("l" "a" "1")) ("啦"))
    ((("l" "a" "i" "2")) ("來" "萊" "徠"))
    ((("l" "a" "i" "4")) ("賴" "癩" "瀨" "籟" "睞" "賚"))
    ((("l" "a" "n" "2")) ("蘭" "籃" "藍" "欄" "攔" "瀾" "襤" "婪" "嵐" "闌" "讕" "斕"))
    ((("l" "a" "n" "3")) ("覽" "懶" "攬" "欖" "纜" "壈" "灠"))
    ((("l" "a" "n" "4")) ("爛" "濫"))
    ((("l" "a" "n" "g" "2")) ("郎" "狼" "廊" "螂" "瑯" "琅" "榔"))
    ((("l" "a" "n" "g" "3")) ("朗"))
    ((("l" "a" "n" "g" "4")) ("浪"))
    ((("l" "a" "o" "2")) ("勞" "牢" "癆" "醪"))
    ((("l" "a" "o" "3")) ("老" "姥" "佬" "栳"))
    ((("l" "a" "o" "4")) ("絡" "烙" "酪" "澇" "嘮"))
    ((("l" "e" "4")) ("樂" "勒" "肋" "泐" "埒"))
    ((("l" "e" "1")) ("了"))
    ((("l" "e" "i" "2")) ("雷" "纍" "擂" "嫘" "鐳" "羸" "縲" "罍" "檑"))
    ((("l" "e" "i" "3")) ("累" "壘" "儡" "耒" "磊" "蕾"))
    ((("l" "e" "i" "4")) ("類" "淚" "累" "擂" "酹"))
    ((("l" "e" "n" "g" "2")) ("稜" "棱" "楞"))
    ((("l" "e" "n" "g" "3")) ("冷"))
    ((("l" "e" "n" "g" "4")) ("愣"))
    ((("l" "i" "2")) ("離" "黎" "梨" "籬" "釐" "罹" "璃" "犁" "漓" "厘" "灕" "驪" "貍" "犛" "狸" "藜" "蜊" "蠡" "鸝" "嫠" "褵" "縭" "喱" "糎"))
    ((("l" "i" "3")) ("裏" "理" "李" "里" "禮" "哩" "浬" "鯉" "裡" "娌" "俚" "澧" "邐" "醴" "蠡" "鋰"))
    ((("l" "i" "4")) ("利" "力" "例" "歷" "麗" "立" "厲" "勵" "粒" "曆" "荔" "蒞" "吏" "隸" "靂" "瀝" "慄" "戾" "俐" "礪" "莉" "栗" "礫" "痢" "儷" "笠" "唳" "蠣" "酈" "嚦" "壢" "溧" "癘" "櫪" "糲" "轢" "猁"))
    ((("l" "i" "1")) ("璃"))
    ((("l" "i" "a" "3")) ("倆"))
    ((("l" "i" "a" "n" "2")) ("連" "聯" "憐" "廉" "蓮" "漣" "簾" "鐮" "鰱" "奩" "帘" "鎌" "濂"))
    ((("l" "i" "a" "n" "3")) ("臉" "斂" "歛"))
    ((("l" "i" "a" "n" "4")) ("練" "鍊" "戀" "煉" "鏈" "殮" "瀲"))
    ((("l" "i" "a" "n" "g" "2")) ("良" "梁" "量" "糧" "涼" "粱" "樑" "踉" "椋"))
    ((("l" "i" "a" "n" "g" "3")) ("兩" "倆" "魎" "啢"))
    ((("l" "i" "a" "n" "g" "4")) ("亮" "量" "諒" "輛" "喨" "晾" "涼" "踉" "靚"))
    ((("l" "i" "a" "o" "2")) ("聊" "寮" "遼" "療" "寥" "撩" "僚" "嘹" "燎" "繚" "獠"))
    ((("l" "i" "a" "o" "3")) ("了" "瞭" "潦" "燎" "蓼"))
    ((("l" "i" "a" "o" "4")) ("廖" "料" "鐐" "撂"))
    ((("l" "i" "e" "2")) ("咧"))
    ((("l" "i" "e" "3")) ("裂"))
    ((("l" "i" "e" "4")) ("列" "烈" "劣" "裂" "獵" "捩" "冽" "鬣" "躐" "洌"))
    ((("l" "i" "e" "1")) ("咧"))
    ((("l" "i" "n" "2")) ("林" "臨" "鄰" "淋" "鱗" "麟" "霖" "磷" "琳" "遴" "嶙" "燐" "璘" "粼" "轔" "痳" "疄"))
    ((("l" "i" "n" "3")) ("凜" "懍" "廩" "檁"))
    ((("l" "i" "n" "4")) ("吝" "躪" "藺" "賃"))
    ((("l" "i" "n" "g" "2")) ("靈" "零" "玲" "鈴" "齡" "陵" "伶" "凌" "淩" "○" "菱" "綾" "聆" "羚" "苓" "翎" "囹" "泠" "欞" "鯪"))
    ((("l" "i" "n" "g" "3")) ("領" "嶺"))
    ((("l" "i" "n" "g" "4")) ("令" "另"))
    ((("l" "i" "u" "2")) ("劉" "流" "留" "硫" "琉" "榴" "瀏" "瘤" "騮" "鎏" "旒" "鏐"))
    ((("l" "i" "u" "3")) ("柳"))
    ((("l" "i" "u" "4")) ("六" "陸" "溜" "餾" "遛" "鎦"))
    ((("l" "o" "1")) ("咯"))
    ((("l" "o" "n" "g" "2")) ("龍" "隆" "籠" "嚨" "聾" "瓏" "朧" "矓" "瀧" "癃" "窿" "櫳" "礱" "曨" "蘢"))
    ((("l" "o" "n" "g" "3")) ("隴" "攏" "壟"))
    ((("l" "o" "n" "g" "4")) ("弄"))
    ((("l" "o" "u" "2")) ("樓" "嘍" "婁" "螻" "髏" "僂" "蔞"))
    ((("l" "o" "u" "3")) ("簍" "摟" "嶁"))
    ((("l" "o" "u" "4")) ("漏" "陋" "鏤" "瘺"))
    ((("l" "u" "2")) ("盧" "蘆" "廬" "臚" "爐" "顱" "瀘" "鱸" "壚" "罏" "艫" "ㄌ"))
    ((("l" "u" "3")) ("魯" "虜" "擄" "櫓" "鹵" "滷" "艣" "ㄌ"))
    ((("l" "u" "4")) ("路" "陸" "錄" "鹿" "露" "賂" "祿" "碌" "綠" "麓" "鷺" "戮" "轆" "逯" "漉" "輅" "僇" "潞" "籙" "璐" "簏" "淥" "ㄌ"))
    ((("l" "u" "a" "n" "2")) ("巒" "孿" "攣" "鑾" "鸞" "臠"))
    ((("l" "u" "a" "n" "3")) ("卵"))
    ((("l" "u" "a" "n" "4")) ("亂"))
    ((("l" "u" "e" "4")) ("略" "掠"))
    ((("l" "u" "n" "2")) ("倫" "論" "輪" "淪" "崙" "侖" "綸" "掄" "圇"))
    ((("l" "u" "n" "4")) ("論"))
    ((("l" "u" "o" "2")) ("羅" "螺" "蘿" "鑼" "邏" "籮" "騾" "囉" "儸" "玀"))
    ((("l" "u" "o" "3")) ("裸" "瘰" "臝"))
    ((("l" "u" "o" "4")) ("落" "洛" "駱" "絡" "烙" "酪" "濼" "犖" "珞"))
    ((("l" "u" "o" "1")) ("囉"))
    ((("l" "u" "u" "2")) ("驢" "閭" "櫚"))
    ((("l" "u" "u" "3")) ("旅" "屢" "履" "侶" "鋁" "呂" "縷" "褸" "膂"))
    ((("l" "u" "u" "4")) ("律" "綠" "率" "慮" "濾" "氯"))
    ((("m" "2")) ("嘸"))
    ((("m" "a" "2")) ("麻" "痲" "嘛" "蟆"))
    ((("m" "a" "3")) ("碼" "馬" "瑪" "螞"))
    ((("m" "a" "4")) ("罵" "禡" "螞"))
    ((("m" "a" "1")) ("嗎" "嘛" "蟆"))
    ((("m" "a" "i" "2")) ("埋" "霾"))
    ((("m" "a" "i" "3")) ("買"))
    ((("m" "a" "i" "4")) ("賣" "麥" "邁" "脈" "勱"))
    ((("m" "a" "n" "2")) ("蠻" "饅" "瞞" "蹣" "謾" "鰻" "蔓"))
    ((("m" "a" "n" "3")) ("滿"))
    ((("m" "a" "n" "4")) ("慢" "漫" "曼" "蔓" "幔" "嫚" "鏝" "縵" "墁" "熳"))
    ((("m" "a" "n" "g" "2")) ("忙" "芒" "茫" "盲" "氓" "鋩"))
    ((("m" "a" "n" "g" "3")) ("莽" "蟒" "漭" "茻"))
    ((("m" "a" "o" "2")) ("毛" "茅" "矛" "髦" "錨" "旄" "蟊" "蝥" "酕"))
    ((("m" "a" "o" "3")) ("卯" "冇"))
    ((("m" "a" "o" "4")) ("帽" "冒" "貌" "貿" "茂" "瑁" "懋" "耄" "瞀" "袤"))
    ((("m" "e" "1")) ("麼"))
    ((("m" "e" "i" "2")) ("沒" "煤" "眉" "枚" "梅" "媒" "莓" "霉" "玫" "黴" "楣" "湄" "嵋" "脢"))
    ((("m" "e" "i" "3")) ("每" "美" "鎂"))
    ((("m" "e" "i" "4")) ("妹" "媚" "寐" "昧" "魅" "袂"))
    ((("m" "e" "n" "2")) ("們" "門" "捫"))
    ((("m" "e" "n" "4")) ("悶" "燜" "懣"))
    ((("m" "e" "n" "1")) ("們"))
    ((("m" "e" "n" "g" "2")) ("蒙" "盟" "萌" "矇" "朦" "濛" "檬" "幪" "氓" "艨" "虻" "甿"))
    ((("m" "e" "n" "g" "3")) ("猛" "蜢" "艋" "錳" "懵" "蠓" "瞢"))
    ((("m" "e" "n" "g" "4")) ("夢" "孟"))
    ((("m" "i" "2")) ("迷" "彌" "謎" "瀰" "靡" "糜" "麋" "縻" "獼" "蘼" "醚" "醾"))
    ((("m" "i" "3")) ("米" "靡" "弭" "敉" "眯" "糎"))
    ((("m" "i" "4")) ("密" "蜜" "秘" "祕" "覓" "泌" "汨" "謐" "宓" "冪" "糸"))
    ((("m" "i" "a" "n" "2")) ("棉" "綿" "眠"))
    ((("m" "i" "a" "n" "3")) ("免" "勉" "緬" "冕" "娩" "靦" "湎" "沔" "丏" "澠"))
    ((("m" "i" "a" "n" "4")) ("面" "麵" "眄"))
    ((("m" "i" "a" "o" "2")) ("苗" "描" "瞄"))
    ((("m" "i" "a" "o" "3")) ("秒" "渺" "藐" "邈" "緲" "杳" "眇" "淼" "杪"))
    ((("m" "i" "a" "o" "4")) ("妙" "廟" "繆"))
    ((("m" "i" "e" "4")) ("滅" "蔑" "衊" "篾" "蠛"))
    ((("m" "i" "n" "2")) ("民" "緡"))
    ((("m" "i" "n" "3")) ("敏" "憫" "閔" "閩" "抿" "泯" "皿" "湣" "愍" "黽"))
    ((("m" "i" "n" "g" "2")) ("明" "名" "鳴" "銘" "螟" "冥" "瞑" "暝" "茗"))
    ((("m" "i" "n" "g" "3")) ("酩"))
    ((("m" "i" "n" "g" "4")) ("命"))
    ((("m" "i" "u" "4")) ("謬" "繆"))
    ((("m" "o" "2")) ("模" "磨" "摩" "膜" "魔" "摹" "謨" "蘑" "嫫"))
    ((("m" "o" "3")) ("抹"))
    ((("m" "o" "4")) ("末" "莫" "默" "漠" "沒" "膜" "寞" "陌" "歿" "脈" "抹" "沫" "秣" "茉" "驀" "墨" "貊" "磨" "瘼" "靺" "眽" "万"))
    ((("m" "o" "u" "2")) ("謀" "眸" "繆" "牟" "鍪" "蛑"))
    ((("m" "o" "u" "3")) ("某"))
    ((("m" "u" "2")) ("模"))
    ((("m" "u" "3")) ("母" "畝" "牡" "姆" "拇" "牳" "姥"))
    ((("m" "u" "4")) ("木" "目" "幕" "牧" "慕" "墓" "募" "穆" "睦" "暮" "沐" "苜" "鶩"))
    ((("n" "2")) ("嗯" "唔"))
    ((("n" "3")) ("嗯"))
    ((("n" "4")) ("嗯"))
    ((("n" "a" "2")) ("拿"))
    ((("n" "a" "3")) ("哪"))
    ((("n" "a" "4")) ("那" "納" "吶" "訥" "鈉" "捺" "娜" "肭" "衲"))
    ((("n" "a" "1")) ("哪"))
    ((("n" "a" "i" "2")) ("孻"))
    ((("n" "a" "i" "3")) ("乃" "奶" "迺" "氖" "嬭"))
    ((("n" "a" "i" "4")) ("耐" "奈" "鼐"))
    ((("n" "a" "n" "2")) ("難" "男" "南" "喃" "楠" "柟"))
    ((("n" "a" "n" "3")) ("赧" "腩"))
    ((("n" "a" "n" "4")) ("難"))
    ((("n" "a" "n" "g" "2")) ("囊"))
    ((("n" "a" "n" "g" "3")) ("曩" "攮"))
    ((("n" "a" "o" "2")) ("撓" "鐃" "呶" "猱"))
    ((("n" "a" "o" "3")) ("腦" "惱" "瑙"))
    ((("n" "a" "o" "4")) ("鬧" "淖"))
    ((("n" "e" "2")) ("哪"))
    ((("n" "e" "4")) ("訥"))
    ((("n" "e" "1")) ("呢"))
    ((("n" "e" "i" "3")) ("餒"))
    ((("n" "e" "i" "4")) ("內"))
    ((("n" "e" "n" "4")) ("嫩" "恁"))
    ((("n" "e" "n" "g" "2")) ("能"))
    ((("n" "e" "n" "g" "4")) ("濘"))
    ((("n" "g" "2")) ("嗯" "唔"))
    ((("n" "g" "3")) ("嗯"))
    ((("n" "g" "4")) ("嗯"))
    ((("n" "i" "2")) ("泥" "尼" "妮" "倪" "霓" "怩" "麑"))
    ((("n" "i" "3")) ("你" "妳" "擬" "旎"))
    ((("n" "i" "4")) ("逆" "溺" "匿" "膩" "泥" "睨" "暱"))
    ((("n" "i" "a" "n" "2")) ("年" "黏" "粘"))
    ((("n" "i" "a" "n" "3")) ("捻" "撚" "攆" "拈" "輦" "碾"))
    ((("n" "i" "a" "n" "4")) ("念" "唸" "廿"))
    ((("n" "i" "a" "n" "g" "2")) ("娘" "孃"))
    ((("n" "i" "a" "n" "g" "4")) ("釀"))
    ((("n" "i" "a" "o" "3")) ("鳥" "裊" "嬲" "嬝" "嫋"))
    ((("n" "i" "a" "o" "4")) ("尿"))
    ((("n" "i" "e" "4")) ("孽" "鎳" "躡" "聶" "鑷" "涅" "囁" "齧" "臬" "乜"))
    ((("n" "i" "n" "2")) ("您"))
    ((("n" "i" "n" "g" "2")) ("寧" "凝" "獰" "嚀" "檸" "甯" "擰"))
    ((("n" "i" "n" "g" "3")) ("擰"))
    ((("n" "i" "n" "g" "4")) ("濘" "佞"))
    ((("n" "i" "u" "2")) ("牛"))
    ((("n" "i" "u" "3")) ("紐" "扭" "鈕" "忸" "狃"))
    ((("n" "i" "u" "4")) ("拗"))
    ((("n" "o" "n" "g" "2")) ("農" "濃" "膿" "儂" "噥"))
    ((("n" "o" "n" "g" "4")) ("弄"))
    ((("n" "o" "u" "4")) ("耨"))
    ((("n" "u" "2")) ("奴" "駑" "孥"))
    ((("n" "u" "3")) ("努" "弩" "ㄋ"))
    ((("n" "u" "4")) ("怒" "ㄋ"))
    ((("n" "u" "a" "n" "3")) ("暖"))
    ((("n" "u" "e" "4")) ("虐" "瘧" "謔"))
    ((("n" "u" "o" "2")) ("挪" "娜"))
    ((("n" "u" "o" "4")) ("諾" "懦" "糯" "搦"))
    ((("n" "u" "u" "3")) ("女"))
    ((("o" "2")) ("哦"))
    ((("o" "3")) ("嚄"))
    ((("o" "4")) ("哦"))
    ((("o" "u" "3")) ("偶" "藕" "嘔" "耦"))
    ((("o" "u" "4")) ("漚"))
    ((("p" "a" "2")) ("爬" "扒" "琶" "耙" "杷"))
    ((("p" "a" "4")) ("怕" "帕"))
    ((("p" "a" "1")) ("琶" "杷"))
    ((("p" "a" "i" "2")) ("排" "牌" "徘" "俳" "棑"))
    ((("p" "a" "i" "4")) ("派" "湃"))
    ((("p" "a" "n" "2")) ("盤" "磐" "蟠" "胖" "槃" "蹣" "爿"))
    ((("p" "a" "n" "4")) ("判" "叛" "盼" "畔" "拚" "泮"))
    ((("p" "a" "n" "g" "2")) ("旁" "龐" "膀" "螃" "徬"))
    ((("p" "a" "n" "g" "3")) ("嗙"))
    ((("p" "a" "n" "g" "4")) ("胖"))
    ((("p" "a" "o" "2")) ("袍" "咆" "刨" "匏" "庖"))
    ((("p" "a" "o" "3")) ("跑"))
    ((("p" "a" "o" "4")) ("泡" "砲" "炮" "皰"))
    ((("p" "e" "i" "2")) ("培" "賠" "陪" "裴"))
    ((("p" "e" "i" "4")) ("配" "佩" "沛" "珮" "帔" "轡"))
    ((("p" "e" "n" "2")) ("盆"))
    ((("p" "e" "n" "4")) ("噴"))
    ((("p" "e" "n" "g" "2")) ("朋" "彭" "澎" "蓬" "膨" "硼" "棚" "鵬" "篷" "蟛"))
    ((("p" "e" "n" "g" "3")) ("捧"))
    ((("p" "e" "n" "g" "4")) ("碰"))
    ((("p" "i" "2")) ("皮" "疲" "脾" "琵" "枇" "裨" "啤" "毗" "貔" "陂"))
    ((("p" "i" "3")) ("否" "匹" "疋" "痞" "仳"))
    ((("p" "i" "4")) ("譬" "闢" "僻" "媲" "屁" "辟" "癖" "甓" "擗" "澼"))
    ((("p" "i" "a" "n" "2")) ("駢" "胼" "便"))
    ((("p" "i" "a" "n" "3")) ("諞"))
    ((("p" "i" "a" "n" "4")) ("片" "騙" "遍"))
    ((("p" "i" "a" "o" "2")) ("嫖" "瓢"))
    ((("p" "i" "a" "o" "3")) ("漂" "莩" "縹" "瞟" "殍"))
    ((("p" "i" "a" "o" "4")) ("票" "漂" "驃"))
    ((("p" "i" "e" "3")) ("撇"))
    ((("p" "i" "n" "2")) ("貧" "頻" "蘋" "顰" "嬪" "瀕"))
    ((("p" "i" "n" "3")) ("品"))
    ((("p" "i" "n" "4")) ("聘" "牝"))
    ((("p" "i" "n" "g" "2")) ("平" "瓶" "憑" "評" "屏" "蘋" "萍" "坪" "枰" "洴"))
    ((("p" "o" "2")) ("婆" "鄱" "皤"))
    ((("p" "o" "3")) ("頗" "叵" "笸"))
    ((("p" "o" "4")) ("破" "迫" "魄" "珀" "朴" "粕"))
    ((("p" "o" "u" "3")) ("剖" "掊"))
    ((("p" "u" "2")) ("僕" "樸" "葡" "蒲" "菩" "脯" "濮" "璞" "匍"))
    ((("p" "u" "3")) ("普" "樸" "浦" "埔" "譜" "圃" "溥" "氆" "蹼"))
    ((("p" "u" "4")) ("暴" "鋪" "瀑" "曝" "舖"))
    ((("q" "i" "2")) ("其" "期" "齊" "奇" "旗" "騎" "祈" "棋" "祺" "祁" "崎" "琦" "岐" "歧" "琪" "麒" "鰭" "畦" "臍" "耆" "淇" "跂" "綦" "騏" "蘄" "圻" "萁" "蜞" "頎"))
    ((("q" "i" "3")) ("起" "啟" "豈" "乞" "綺" "杞" "稽" "屺" "棨" "企"))
    ((("q" "i" "4")) ("氣" "汽" "器" "棄" "契" "砌" "泣" "迄" "訖" "憩" "亟" "葺" "磧"))
    ((("q" "i" "a" "3")) ("卡"))
    ((("q" "i" "a" "4")) ("恰" "洽"))
    ((("q" "i" "a" "n" "2")) ("前" "錢" "乾" "潛" "黔" "鉗" "虔" "箝" "鈐" "掮"))
    ((("q" "i" "a" "n" "3")) ("遣" "淺" "譴" "繾"))
    ((("q" "i" "a" "n" "4")) ("欠" "歉" "倩" "慊" "茜" "嵌" "塹" "縴"))
    ((("q" "i" "a" "n" "g" "2")) ("強" "牆" "薔" "嬙" "檣" "彊"))
    ((("q" "i" "a" "n" "g" "3")) ("搶" "襁" "強" "鏹"))
    ((("q" "i" "a" "n" "g" "4")) ("蹌" "嗆"))
    ((("q" "i" "a" "o" "2")) ("橋" "瞧" "僑" "喬" "樵" "翹" "憔" "蕎" "譙"))
    ((("q" "i" "a" "o" "3")) ("巧" "悄" "愀" "雀"))
    ((("q" "i" "a" "o" "4")) ("翹" "竅" "俏" "峭" "鞘" "誚" "撬" "殼"))
    ((("q" "i" "e" "2")) ("茄" "伽"))
    ((("q" "i" "e" "3")) ("且"))
    ((("q" "i" "e" "4")) ("切" "竊" "妾" "怯" "愜" "挈" "篋" "鍥"))
    ((("q" "i" "n" "2")) ("勤" "琴" "秦" "禽" "擒" "芹" "檎" "懃" "噙" "芩"))
    ((("q" "i" "n" "3")) ("寢"))
    ((("q" "i" "n" "4")) ("沁" "撳" "唚"))
    ((("q" "i" "n" "g" "2")) ("情" "晴" "擎"))
    ((("q" "i" "n" "g" "3")) ("請"))
    ((("q" "i" "n" "g" "4")) ("慶" "罄" "綮" "磬"))
    ((("q" "i" "o" "n" "g" "2")) ("窮" "瓊" "穹" "跫" "蛩" "筇"))
    ((("q" "i" "u" "2")) ("求" "球" "囚" "仇" "酋" "裘" "遒" "毬" "泅" "逑"))
    ((("q" "u" "2")) ("渠" "劬" "麴" "衢" "瞿" "籧" "蘧" "蠷"))
    ((("q" "u" "3")) ("取" "曲" "娶" "齲"))
    ((("q" "u" "4")) ("去" "趣" "覷"))
    ((("q" "u" "a" "n" "2")) ("全" "權" "泉" "荃" "詮" "拳" "銓" "痊" "顴" "蜷" "鬈" "筌" "牷"))
    ((("q" "u" "a" "n" "3")) ("犬" "綣" "畎"))
    ((("q" "u" "a" "n" "4")) ("勸" "券"))
    ((("q" "u" "e" "2")) ("瘸"))
    ((("q" "u" "e" "4")) ("卻" "確" "雀" "鵲" "闕" "闋" "榷" "搉" "愨"))
    ((("q" "u" "n" "2")) ("群" "裙" "麇"))
    ((("r" "1")) ("兒"))
    ((("r" "a" "n" "2")) ("然" "燃" "髯" "蚺"))
    ((("r" "a" "n" "3")) ("染" "冉" "苒"))
    ((("r" "a" "n" "g" "2")) ("禳" "穰" "勷" "瓤" "蘘"))
    ((("r" "a" "n" "g" "3")) ("嚷" "壤" "攘"))
    ((("r" "a" "n" "g" "4")) ("讓"))
    ((("r" "a" "o" "2")) ("饒" "蕘" "嬈" "蟯"))
    ((("r" "a" "o" "3")) ("擾" "繞"))
    ((("r" "a" "o" "4")) ("繞" "遶"))
    ((("r" "e" "3")) ("惹" "喏"))
    ((("r" "e" "4")) ("熱"))
    ((("r" "e" "n" "2")) ("人" "任" "仁" "壬"))
    ((("r" "e" "n" "3")) ("忍" "稔" "荏"))
    ((("r" "e" "n" "4")) ("任" "認" "刃" "飪" "韌" "軔" "衽" "紉" "紝" "妊" "仞" "賃" "恁"))
    ((("r" "e" "n" "g" "2")) ("仍" "礽"))
    ((("r" "i" "4")) ("日"))
    ((("r" "o" "n" "g" "2")) ("容" "榮" "融" "溶" "絨" "熔" "戎" "蓉" "榕" "茸" "嶸" "鎔" "羢" "毧"))
    ((("r" "o" "n" "g" "3")) ("冗"))
    ((("r" "o" "u" "2")) ("柔" "揉" "蹂" "輮" "楺" "鞣"))
    ((("r" "o" "u" "4")) ("肉"))
    ((("r" "u" "2")) ("如" "儒" "孺" "茹" "蠕" "嚅" "濡" "襦"))
    ((("r" "u" "3")) ("乳" "汝" "辱"))
    ((("r" "u" "4")) ("入" "褥" "縟" "蓐" "溽" "辱"))
    ((("r" "u" "a" "n" "3")) ("軟" "阮"))
    ((("r" "u" "i" "3")) ("蕊"))
    ((("r" "u" "i" "4")) ("瑞" "銳" "芮" "睿" "蚋" "叡" "枘"))
    ((("r" "u" "n" "4")) ("潤" "閏"))
    ((("r" "u" "o" "4")) ("若" "弱" "箬" "偌" "爇"))
    ((("s" "a" "3")) ("灑" "撒" "洒"))
    ((("s" "a" "4")) ("薩" "卅" "颯"))
    ((("s" "a" "1")) ("挲"))
    ((("s" "a" "i" "4")) ("賽" "塞"))
    ((("s" "a" "n" "3")) ("散" "傘"))
    ((("s" "a" "n" "4")) ("散"))
    ((("s" "a" "n" "g" "3")) ("嗓" "顙" "搡"))
    ((("s" "a" "n" "g" "4")) ("喪"))
    ((("s" "a" "o" "3")) ("掃" "嫂"))
    ((("s" "a" "o" "4")) ("掃" "瘙"))
    ((("s" "e" "4")) ("色" "塞" "瑟" "嗇" "澀" "穡"))
    ((("s" "h" "a" "3")) ("傻"))
    ((("s" "h" "a" "4")) ("廈" "煞" "霎" "嗄" "歃" "啥"))
    ((("s" "h" "a" "1")) ("挲"))
    ((("s" "h" "a" "i" "3")) ("骰" "色"))
    ((("s" "h" "a" "i" "4")) ("曬" "晒"))
    ((("s" "h" "a" "n" "3")) ("閃" "陜" "睒"))
    ((("s" "h" "a" "n" "4")) ("善" "扇" "汕" "擅" "膳" "繕" "鄯" "煽" "訕" "贍" "疝" "鱔" "騸"))
    ((("s" "h" "a" "n" "g" "3")) ("賞" "晌" "上"))
    ((("s" "h" "a" "n" "g" "4")) ("上" "尚"))
    ((("s" "h" "a" "n" "g" "1")) ("裳"))
    ((("s" "h" "a" "o" "2")) ("韶" "勺" "芍" "杓"))
    ((("s" "h" "a" "o" "3")) ("少"))
    ((("s" "h" "a" "o" "4")) ("少" "紹" "哨" "邵" "召" "劭" "潲"))
    ((("s" "h" "e" "2")) ("蛇" "舌" "佘"))
    ((("s" "h" "e" "3")) ("捨" "舍"))
    ((("s" "h" "e" "4")) ("社" "設" "射" "涉" "舍" "攝" "赦" "懾" "麝"))
    ((("s" "h" "e" "i" "2")) ("誰"))
    ((("s" "h" "e" "n" "2")) ("甚" "什" "神"))
    ((("s" "h" "e" "n" "3")) ("沈" "審" "嬸" "瀋" "諗" "讅" "矧" "哂"))
    ((("s" "h" "e" "n" "4")) ("慎" "腎" "滲" "甚" "蜃" "沁"))
    ((("s" "h" "e" "n" "g" "2")) ("繩"))
    ((("s" "h" "e" "n" "g" "3")) ("省" "眚"))
    ((("s" "h" "e" "n" "g" "4")) ("勝" "盛" "聖" "剩" "乘" "賸"))
    ((("s" "h" "i" "2")) ("時" "實" "十" "食" "識" "拾" "石" "蝕" "什" "寔"))
    ((("s" "h" "i" "3")) ("使" "始" "史" "駛" "矢" "屎" "豕"))
    ((("s" "h" "i" "4")) ("是" "事" "世" "士" "勢" "室" "示" "試" "式" "釋" "視" "適" "市" "飾" "逝" "誓" "侍" "氏" "嗜" "恃" "仕" "柿" "使" "螫" "弒" "噬" "拭" "筮" "舐" "軾" "諡" "奭" "謚"))
    ((("s" "h" "i" "1")) ("匙"))
    ((("s" "h" "o" "u" "2")) ("熟"))
    ((("s" "h" "o" "u" "3")) ("手" "首" "守"))
    ((("s" "h" "o" "u" "4")) ("受" "售" "壽" "獸" "授" "瘦" "狩" "綬"))
    ((("s" "h" "u" "2")) ("熟" "淑" "叔" "塾" "贖" "孰" "菽"))
    ((("s" "h" "u" "3")) ("屬" "暑" "署" "薯" "鼠" "數" "蜀" "黍" "曙"))
    ((("s" "h" "u" "4")) ("數" "樹" "術" "述" "束" "豎" "恕" "庶" "戍" "墅" "署" "漱" "澍"))
    ((("s" "h" "u" "a" "3")) ("耍"))
    ((("s" "h" "u" "a" "4")) ("刷"))
    ((("s" "h" "u" "a" "i" "3")) ("甩"))
    ((("s" "h" "u" "a" "i" "4")) ("率" "帥" "蟀"))
    ((("s" "h" "u" "a" "n" "4")) ("涮"))
    ((("s" "h" "u" "a" "n" "g" "3")) ("爽"))
    ((("s" "h" "u" "i" "2")) ("誰"))
    ((("s" "h" "u" "i" "3")) ("水"))
    ((("s" "h" "u" "i" "4")) ("睡" "稅" "說" "帨"))
    ((("s" "h" "u" "n" "3")) ("吮"))
    ((("s" "h" "u" "n" "4")) ("順" "舜" "瞬"))
    ((("s" "h" "u" "o" "4")) ("朔" "碩" "爍" "鑠" "妁" "槊"))
    ((("s" "i" "3")) ("死"))
    ((("s" "i" "4")) ("四" "似" "嗣" "飼" "寺" "肆" "祀" "俟" "伺" "泗" "巳" "耜" "姒" "駟" "兕" "涘" "汜"))
    ((("s" "o" "n" "g" "3")) ("聳" "慫" "悚" "竦"))
    ((("s" "o" "n" "g" "4")) ("送" "宋" "頌" "訟" "誦"))
    ((("s" "o" "u" "3")) ("擻" "嗾" "叟" "藪" "瞍"))
    ((("s" "o" "u" "4")) ("嗽"))
    ((("s" "u" "2")) ("俗"))
    ((("s" "u" "4")) ("訴" "速" "素" "肅" "宿" "塑" "夙" "粟" "溯" "愫" "觫" "膆" "謖" "簌" "蔌"))
    ((("s" "u" "a" "n" "4")) ("算" "蒜"))
    ((("s" "u" "i" "2")) ("隨" "隋" "綏"))
    ((("s" "u" "i" "3")) ("髓"))
    ((("s" "u" "i" "4")) ("歲" "遂" "碎" "穗" "隧" "祟" "燧" "誶" "邃"))
    ((("s" "u" "n" "3")) ("損" "筍" "榫" "隼"))
    ((("s" "u" "o" "3")) ("所" "索" "鎖" "瑣" "嗩"))
    ((("s" "u" "o" "1")) ("嗦"))
    ((("t" "a" "3")) ("塔" "獺"))
    ((("t" "a" "4")) ("踏" "榻" "蹋" "遢" "沓" "嗒" "撻" "遝" "闥"))
    ((("t" "a" "i" "2")) ("台" "臺" "抬" "颱" "苔" "跆" "檯" "駘"))
    ((("t" "a" "i" "4")) ("太" "態" "泰" "汰" "鈦"))
    ((("t" "a" "n" "2")) ("談" "彈" "痰" "潭" "譚" "檀" "壇" "曇" "罈" "覃"))
    ((("t" "a" "n" "3")) ("坦" "毯" "袒" "忐"))
    ((("t" "a" "n" "4")) ("探" "嘆" "歎" "碳" "炭"))
    ((("t" "a" "n" "g" "2")) ("堂" "糖" "唐" "塘" "膛" "螳" "棠" "醣" "搪" "樘"))
    ((("t" "a" "n" "g" "3")) ("倘" "躺" "儻" "淌" "帑" "惝"))
    ((("t" "a" "n" "g" "4")) ("趟" "燙"))
    ((("t" "a" "o" "2")) ("逃" "桃" "陶" "萄" "淘" "啕" "濤"))
    ((("t" "a" "o" "3")) ("討"))
    ((("t" "a" "o" "4")) ("套"))
    ((("t" "e" "4")) ("特" "忑" "忒" "慝"))
    ((("t" "e" "n" "g" "2")) ("疼" "騰" "藤" "籐" "謄" "滕" "螣" "縢"))
    ((("t" "i" "2")) ("題" "提" "啼" "蹄" "醍" "緹" "荑"))
    ((("t" "i" "3")) ("體"))
    ((("t" "i" "4")) ("替" "惕" "涕" "屜" "悌" "剃" "嚏" "倜" "薙" "逖"))
    ((("t" "i" "a" "n" "2")) ("田" "甜" "填" "恬" "闐" "畋" "湉" "菾"))
    ((("t" "i" "a" "n" "3")) ("舔" "忝" "殄" "腆" "靦"))
    ((("t" "i" "a" "n" "4")) ("掭"))
    ((("t" "i" "a" "o" "2")) ("條" "調" "迢" "蜩"))
    ((("t" "i" "a" "o" "3")) ("挑" "窕"))
    ((("t" "i" "a" "o" "4")) ("跳" "眺" "糶" "朓"))
    ((("t" "i" "e" "3")) ("鐵"))
    ((("t" "i" "e" "4")) ("帖" "餮"))
    ((("t" "i" "n" "g" "2")) ("停" "庭" "廷" "亭" "蜓" "霆" "婷" "渟"))
    ((("t" "i" "n" "g" "3")) ("挺" "艇" "町" "梃" "鋌" "珽"))
    ((("t" "i" "n" "g" "4")) ("聽"))
    ((("t" "o" "n" "g" "2")) ("同" "童" "銅" "桐" "潼" "瞳" "彤" "佟" "僮" "仝" "峒" "侗" "曈"))
    ((("t" "o" "n" "g" "3")) ("統" "筒" "桶" "捅"))
    ((("t" "o" "n" "g" "4")) ("痛" "慟"))
    ((("t" "o" "u" "2")) ("頭" "投" "骰"))
    ((("t" "o" "u" "4")) ("透"))
    ((("t" "u" "2")) ("圖" "途" "突" "徒" "塗" "屠" "凸" "荼" "涂" "酴"))
    ((("t" "u" "3")) ("土"))
    ((("t" "u" "4")) ("兔" "吐" "菟"))
    ((("t" "u" "a" "n" "2")) ("團" "摶" "糰"))
    ((("t" "u" "a" "n" "4")) ("彖"))
    ((("t" "u" "i" "2")) ("頹"))
    ((("t" "u" "i" "3")) ("腿"))
    ((("t" "u" "i" "4")) ("退" "蛻" "褪"))
    ((("t" "u" "n" "2")) ("屯" "囤" "豚" "飩" "臀"))
    ((("t" "u" "o" "2")) ("駝" "陀" "馱" "沱" "佗" "鴕" "跎" "橐" "砣" "鼉"))
    ((("t" "u" "o" "3")) ("妥" "橢"))
    ((("t" "u" "o" "4")) ("拓" "唾"))
    ((("w" "a" "2")) ("娃"))
    ((("w" "a" "3")) ("瓦" "佤" "瓩"))
    ((("w" "a" "4")) ("襪"))
    ((("w" "a" "1")) ("哇"))
    ((("w" "a" "i" "4")) ("外"))
    ((("w" "a" "n" "2")) ("完" "玩" "頑" "丸" "汍" "紈" "芄"))
    ((("w" "a" "n" "3")) ("晚" "惋" "碗" "宛" "婉" "菀" "皖" "輓" "畹" "挽" "琬" "綰"))
    ((("w" "a" "n" "4")) ("萬" "玩" "腕" "卍" "翫" "万" "蔓"))
    ((("w" "a" "n" "g" "2")) ("王" "亡" "芒"))
    ((("w" "a" "n" "g" "3")) ("往" "網" "枉" "罔" "惘" "魍" "輞" "网"))
    ((("w" "a" "n" "g" "4")) ("望" "忘" "妄" "旺" "王"))
    ((("w" "e" "i" "2")) ("為" "圍" "微" "危" "唯" "維" "惟" "違" "韋" "薇" "巍" "桅" "闈" "帷" "嵬" "幃" "溦"))
    ((("w" "e" "i" "3")) ("偉" "委" "尾" "偽" "緯" "萎" "諉" "葦" "痿" "猥" "煒" "娓" "韙" "瑋" "韡" "洧"))
    ((("w" "e" "i" "4")) ("為" "位" "未" "魏" "衛" "味" "偽" "謂" "胃" "慰" "喂" "餵" "尉" "渭" "畏" "蔚" "蝟" "遺"))
    ((("w" "e" "n" "2")) ("文" "聞" "紋" "蚊" "雯" "炆"))
    ((("w" "e" "n" "3")) ("穩" "吻" "刎"))
    ((("w" "e" "n" "4")) ("問" "紊" "汶" "抆" "搵" "璺"))
    ((("w" "e" "n" "g" "3")) ("蓊" "滃"))
    ((("w" "e" "n" "g" "4")) ("甕" "瓮" "罋"))
    ((("w" "o" "3")) ("我"))
    ((("w" "o" "4")) ("握" "臥" "沃" "渥" "斡" "齷" "幄"))
    ((("w" "u" "2")) ("無" "吳" "吾" "梧" "巫" "蕪" "蜈" "誣" "毋" "鼯"))
    ((("w" "u" "3")) ("五" "午" "武" "舞" "侮" "伍" "鵡" "憮" "嫵" "忤" "廡" "仵" "捂"))
    ((("w" "u" "4")) ("勿" "物" "務" "惡" "誤" "悟" "晤" "霧" "戊" "塢" "兀" "騖" "寤" "鶩" "鋈" "焐"))
    ((("x" "i" "2")) ("習" "席" "媳" "襲" "蓆" "檄"))
    ((("x" "i" "3")) ("喜" "洗" "徙" "璽" "屣" "囍"))
    ((("x" "i" "4")) ("細" "戲" "係" "系" "繫" "隙" "鬩" "潟"))
    ((("x" "i" "a" "2")) ("暇" "峽" "轄" "霞" "俠" "狹" "匣" "呷" "遐" "狎" "瑕" "硤" "柙" "黠"))
    ((("x" "i" "a" "4")) ("下" "夏" "嚇" "廈" "罅" "唬"))
    ((("x" "i" "a" "n" "2")) ("賢" "閒" "嫌" "咸" "鹹" "弦" "銜" "絃" "嫻" "涎" "啣" "舷" "閑" "癇"))
    ((("x" "i" "a" "n" "3")) ("險" "顯" "蜆" "癬" "蘚" "銑" "燹" "跣"))
    ((("x" "i" "a" "n" "4")) ("現" "線" "限" "縣" "憲" "獻" "羨" "陷" "腺" "餡" "莧" "峴"))
    ((("x" "i" "a" "n" "g" "2")) ("詳" "祥" "降" "翔" "庠"))
    ((("x" "i" "a" "n" "g" "3")) ("想" "響" "享" "餉" "饗"))
    ((("x" "i" "a" "n" "g" "4")) ("向" "像" "象" "項" "巷" "相" "橡" "嚮" "曏"))
    ((("x" "i" "a" "o" "2")) ("淆" "崤"))
    ((("x" "i" "a" "o" "3")) ("小" "曉" "筱"))
    ((("x" "i" "a" "o" "4")) ("校" "笑" "孝" "效" "肖" "酵" "嘯" "傚"))
    ((("x" "i" "e" "2")) ("協" "鞋" "斜" "攜" "脅" "諧" "邪" "偕" "頡" "挾" "擷" "絜" "勰"))
    ((("x" "i" "e" "3")) ("寫"))
    ((("x" "i" "e" "4")) ("謝" "械" "洩" "屑" "瀉" "懈" "卸" "泄" "蟹" "褻" "榭" "契" "邂" "廨" "燮" "紲" "躞" "獬"))
    ((("x" "i" "n" "2")) ("尋"))
    ((("x" "i" "n" "4")) ("信" "釁" "芯" "囟"))
    ((("x" "i" "n" "g" "2")) ("行" "形" "型" "刑" "邢" "硎" "鉶" "滎"))
    ((("x" "i" "n" "g" "3")) ("省" "醒" "擤"))
    ((("x" "i" "n" "g" "4")) ("性" "幸" "姓" "杏" "行" "興" "倖" "悻" "荇"))
    ((("x" "i" "o" "n" "g" "2")) ("雄" "熊"))
    ((("x" "i" "o" "n" "g" "4")) ("敻"))
    ((("x" "i" "u" "3")) ("朽" "宿" "滫"))
    ((("x" "i" "u" "4")) ("秀" "繡" "袖" "嗅" "臭" "溴" "銹" "宿" "岫" "琇"))
    ((("x" "u" "2")) ("徐"))
    ((("x" "u" "3")) ("許" "栩" "煦" "詡"))
    ((("x" "u" "4")) ("序" "續" "蓄" "緒" "敘" "絮" "旭" "恤" "卹" "酗" "婿" "畜" "勗"))
    ((("x" "u" "a" "n" "2")) ("玄" "旋" "懸" "漩" "璇" "璿"))
    ((("x" "u" "a" "n" "3")) ("選" "晅" "烜" "癬"))
    ((("x" "u" "a" "n" "4")) ("炫" "眩" "絢" "泫" "渲" "楦" "鉉" "鏇"))
    ((("x" "u" "e" "2")) ("學" "穴" "踅" "噱"))
    ((("x" "u" "e" "3")) ("雪"))
    ((("x" "u" "e" "4")) ("血" "削" "謔"))
    ((("x" "u" "n" "2")) ("尋" "巡" "詢" "循" "旬" "馴" "潯" "珣" "洵" "荀" "峋" "恂" "郇" "噚"))
    ((("x" "u" "n" "4")) ("訊" "訓" "迅" "遜" "殉" "徇" "巽" "汛" "噀" "蕈"))
    ((("y" "a" "2")) ("牙" "芽" "涯" "衙" "蚜" "崖" "睚" "琊" "玡"))
    ((("y" "a" "3")) ("雅" "啞"))
    ((("y" "a" "4")) ("亞" "訝" "迓" "砑" "揠" "軋"))
    ((("y" "a" "1")) ("呀"))
    ((("y" "a" "i" "2")) ("崖" "睚"))
    ((("y" "a" "n" "2")) ("研" "言" "顏" "嚴" "延" "沿" "炎" "鹽" "岩" "妍" "簷" "筵" "閻" "蜒" "檐" "巖" "芫"))
    ((("y" "a" "n" "3")) ("眼" "演" "掩" "衍" "郾" "偃" "兗" "甗" "儼" "魘" "罨" "蝘" "黶" "鼴" "琰" "厴"))
    ((("y" "a" "n" "4")) ("驗" "燕" "厭" "晏" "雁" "宴" "艷" "燄" "彥" "諺" "硯" "咽" "嚥" "唁" "饜" "淹" "讌" "堰" "讞" "贗" "灩" "焰" "鷃" "醼" "豔"))
    ((("y" "a" "n" "g" "2")) ("楊" "陽" "揚" "洋" "羊" "佯" "瘍" "徉" "暘" "煬"))
    ((("y" "a" "n" "g" "3")) ("養" "仰" "氧" "癢" "痒" "瀁"))
    ((("y" "a" "n" "g" "4")) ("樣" "恙" "漾" "怏" "鞅" "烊"))
    ((("y" "a" "o" "2")) ("搖" "謠" "堯" "遙" "姚" "瑤" "淆" "餚" "徭" "爻" "繇" "傜" "僥" "颻" "嶢" "肴" "窯" "珧" "銚"))
    ((("y" "a" "o" "3")) ("咬" "窈" "舀" "杳" "窅"))
    ((("y" "a" "o" "4")) ("要" "藥" "耀" "曜" "鑰" "鷂" "燿" "葯" "瘧"))
    ((("y" "e" "2")) ("爺" "耶" "椰" "琊" "揶" "邪"))
    ((("y" "e" "3")) ("也" "野" "冶"))
    ((("y" "e" "4")) ("業" "葉" "頁" "夜" "曳" "謁" "靨" "液" "掖" "腋" "鄴" "燁" "曄"))
    ((("y" "i" "2")) ("宜" "怡" "移" "疑" "遺" "儀" "姨" "夷" "誼" "胰" "貽" "飴" "咦" "詒" "頤" "彝" "痍" "圯" "迻" "荑"))
    ((("y" "i" "3")) ("以" "已" "乙" "倚" "椅" "矣" "蟻" "迤" "旖"))
    ((("y" "i" "4")) ("意" "義" "亦" "易" "議" "益" "異" "藝" "憶" "譯" "役" "翼" "毅" "逸" "抑" "疫" "邑" "肄" "億" "繹" "溢" "縊" "軼" "詣" "屹" "佚" "翌" "羿" "驛" "懿" "裔" "臆" "曳" "奕" "弈" "蜴" "翳" "囈" "弋" "艾" "刈" "挹" "佾" "懌" "劓" "薏" "悒" "熠" "殪" "浥" "翊"))
    ((("y" "i" "n" "2")) ("銀" "吟" "寅" "淫" "齦" "霪" "垠" "夤" "狺"))
    ((("y" "i" "n" "3")) ("引" "飲" "隱" "尹" "癮" "蚓" "「" "」" "『" "』"))
    ((("y" "i" "n" "4")) ("印" "蔭" "胤" "廕" "窨" "飲"))
    ((("y" "i" "n" "g" "2")) ("營" "迎" "蠅" "螢" "贏" "盈" "瑩" "縈" "熒" "嬴" "瀛" "滎" "塋" "楹" "瀅" "瀠"))
    ((("y" "i" "n" "g" "3")) ("影" "穎" "潁" "癭" "郢"))
    ((("y" "i" "n" "g" "4")) ("映" "硬" "應" "媵"))
    ((("y" "o" "1")) ("喲"))
    ((("y" "o" "n" "g" "2")) ("喁" "顒" "傭"))
    ((("y" "o" "n" "g" "3")) ("永" "泳" "詠" "勇" "擁" "踴" "湧" "蛹" "甬" "恿" "俑" "踊" "涌"))
    ((("y" "o" "n" "g" "4")) ("用" "佣" "傭"))
    ((("y" "o" "u" "2")) ("由" "游" "遊" "尤" "油" "郵" "猶" "猷" "魷" "鈾" "柚" "疣" "蕕" "蝣"))
    ((("y" "o" "u" "3")) ("有" "友" "酉" "莠" "牖" "黝" "卣" "誘"))
    ((("y" "o" "u" "4")) ("又" "幼" "右" "誘" "佑" "柚" "釉" "祐" "宥" "侑" "囿" "鼬"))
    ((("y" "u" "2")) ("於" "愉" "魚" "娛" "餘" "于" "漁" "予" "愚" "余" "逾" "俞" "榆" "虞" "輿" "渝" "瑜" "隅" "歟" "覦" "竽" "臾" "諛" "腴" "盂" "萸" "妤" "禺" "雩" "揄" "狳" "艅" "踰"))
    ((("y" "u" "3")) ("與" "語" "雨" "予" "羽" "嶼" "宇" "禹" "齬" "瘐" "庾" "圄" "窳" "傴"))
    ((("y" "u" "4")) ("育" "遇" "預" "玉" "欲" "域" "喻" "愈" "譽" "獄" "慾" "浴" "裕" "煜" "寓" "禦" "鈺" "豫" "御" "鬱" "籲" "諭" "癒" "郁" "馭" "毓" "芋" "尉" "熨" "嫗" "鷸" "鬻" "峪" "彧" "聿" "燠" "瘉" "昱" "魊"))
    ((("y" "u" "a" "n" "2")) ("原" "元" "員" "園" "圓" "緣" "源" "援" "媛" "袁" "¥" "猿" "垣" "沅" "轅" "爰" "圜" "黿" "櫞" "芫" "湲"))
    ((("y" "u" "a" "n" "3")) ("遠"))
    ((("y" "u" "a" "n" "4")) ("院" "願" "怨" "苑" "遠" "媛" "瑗" "愿" "掾"))
    ((("y" "u" "e" "4")) ("月" "越" "樂" "悅" "岳" "粵" "閱" "嶽" "躍" "鉞"))
    ((("y" "u" "n" "2")) ("雲" "云" "勻" "芸" "耘" "紜" "筠"))
    ((("y" "u" "n" "3")) ("允" "殞" "隕" "狁"))
    ((("y" "u" "n" "4")) ("運" "韻" "孕" "醞" "蘊" "慍" "縕" "韞" "暈"))
    ((("z" "a" "2")) ("雜" "咱" "砸"))
    ((("z" "a" "1")) ("臢"))
    ((("z" "a" "i" "3")) ("宰" "仔" "崽" "載"))
    ((("z" "a" "i" "4")) ("在" "再" "載"))
    ((("z" "a" "n" "2")) ("咱"))
    ((("z" "a" "n" "3")) ("攢" "拶"))
    ((("z" "a" "n" "4")) ("贊" "讚" "暫" "鏨" "瓚"))
    ((("z" "a" "n" "g" "4")) ("藏" "葬" "臟" "奘"))
    ((("z" "a" "o" "2")) ("鑿"))
    ((("z" "a" "o" "3")) ("早" "澡" "棗" "藻" "蚤"))
    ((("z" "a" "o" "4")) ("造" "皂" "噪" "燥" "躁" "灶"))
    ((("z" "e" "2")) ("則" "責" "擇" "澤" "嘖" "舴" "幘"))
    ((("z" "e" "4")) ("側" "仄" "昃"))
    ((("z" "e" "i" "2")) ("賊"))
    ((("z" "e" "n" "3")) ("怎"))
    ((("z" "e" "n" "4")) ("譖"))
    ((("z" "e" "n" "g" "4")) ("贈" "甑"))
    ((("z" "h" "a" "2")) ("扎" "札" "炸" "紮" "閘" "劄" "軋"))
    ((("z" "h" "a" "3")) ("眨" "詐" "鮓" "砟"))
    ((("z" "h" "a" "4")) ("乍" "炸" "詐" "咋" "蚱" "吒" "搾" "榨" "痄"))
    ((("z" "h" "a" "i" "2")) ("擇" "宅" "翟"))
    ((("z" "h" "a" "i" "3")) ("窄"))
    ((("z" "h" "a" "i" "4")) ("債" "寨" "砦"))
    ((("z" "h" "a" "n" "3")) ("展" "斬" "盞" "輾" "嶄" "搌"))
    ((("z" "h" "a" "n" "4")) ("占" "佔" "站" "戰" "顫" "湛" "棧" "綻" "蘸"))
    ((("z" "h" "a" "n" "g" "3")) ("長" "掌" "漲"))
    ((("z" "h" "a" "n" "g" "4")) ("丈" "仗" "杖" "帳" "脹" "賬" "障" "漲" "瘴" "嶂"))
    ((("z" "h" "a" "o" "2")) ("著"))
    ((("z" "h" "a" "o" "3")) ("找" "爪" "沼"))
    ((("z" "h" "a" "o" "4")) ("照" "趙" "召" "詔" "兆" "罩" "肇" "棹" "笊" "曌"))
    ((("z" "h" "e" "2")) ("折" "哲" "蜇" "轍" "輒" "摺" "蟄" "謫" "磔"))
    ((("z" "h" "e" "3")) ("者" "赭" "褶"))
    ((("z" "h" "e" "4")) ("這" "浙" "蔗" "鷓" "柘"))
    ((("z" "h" "e" "1")) ("著"))
    ((("z" "h" "e" "i" "4")) ("這"))
    ((("z" "h" "e" "n" "3")) ("枕" "診" "疹" "畛" "縝" "軫" "稹"))
    ((("z" "h" "e" "n" "4")) ("振" "震" "賑" "陣" "圳" "朕" "娠" "鎮" "鴆" "酖"))
    ((("z" "h" "e" "n" "g" "3")) ("整" "拯"))
    ((("z" "h" "e" "n" "g" "4")) ("正" "政" "證" "証" "症" "鄭" "幀" "諍" "掙"))
    ((("z" "h" "i" "2")) ("直" "值" "植" "殖" "執" "職" "躑" "姪" "侄" "摭" "蹠" "擲" "縶"))
    ((("z" "h" "i" "3")) ("只" "止" "指" "旨" "址" "咫" "趾" "芷" "祉" "紙" "黹" "酯" "祇"))
    ((("z" "h" "i" "4")) ("至" "志" "治" "致" "制" "質" "緻" "智" "秩" "置" "稚" "製" "雉" "炙" "摯" "滯" "窒" "痔" "痣" "桎" "蛭" "輊" "峙" "誌" "幟" "擲" "躓" "豸" "帙" "陟" "疐" "贄" "觶" "騭" "櫛"))
    ((("z" "h" "o" "n" "g" "3")) ("種" "踵" "塚" "冢" "腫"))
    ((("z" "h" "o" "n" "g" "4")) ("眾" "重" "種" "中" "仲"))
    ((("z" "h" "o" "u" "2")) ("妯" "軸"))
    ((("z" "h" "o" "u" "3")) ("肘" "帚"))
    ((("z" "h" "o" "u" "4")) ("咒" "宙" "晝" "冑" "紂" "驟" "皺" "縐" "籀" "軸"))
    ((("z" "h" "u" "2")) ("竹" "築" "逐" "燭" "筑" "竺" "朮" "躅" "蠋" "舳"))
    ((("z" "h" "u" "3")) ("主" "煮" "渚" "拄" "矚" "囑"))
    ((("z" "h" "u" "4")) ("住" "注" "註" "著" "助" "柱" "祝" "駐" "鑄" "築" "佇" "蛀" "杼" "箸" "貯" "炷"))
    ((("z" "h" "u" "a" "3")) ("爪"))
    ((("z" "h" "u" "a" "i" "3")) ("跩"))
    ((("z" "h" "u" "a" "i" "4")) ("拽"))
    ((("z" "h" "u" "a" "n" "3")) ("轉"))
    ((("z" "h" "u" "a" "n" "4")) ("傳" "轉" "賺" "撰" "篆" "囀"))
    ((("z" "h" "u" "a" "n" "g" "3")) ("奘"))
    ((("z" "h" "u" "a" "n" "g" "4")) ("狀" "壯" "撞" "幢" "戇" "僮"))
    ((("z" "h" "u" "i" "4")) ("墜" "綴" "贅" "醊" "惴" "縋"))
    ((("z" "h" "u" "n" "3")) ("准" "準" "埻" "隼"))
    ((("z" "h" "u" "o" "2")) ("濁" "灼" "酌" "茁" "啄" "斫" "琢" "鐲" "著" "擢" "濯"))
    ((("z" "i" "3")) ("子" "姊" "籽" "梓" "仔" "紫" "滓" "訾" "秭"))
    ((("z" "i" "4")) ("自" "字" "恣" "漬" "牸" "眥"))
    ((("z" "i" "1")) ("子"))
    ((("z" "o" "n" "g" "3")) ("總"))
    ((("z" "o" "n" "g" "4")) ("從" "縱" "綜" "粽"))
    ((("z" "o" "u" "3")) ("走"))
    ((("z" "o" "u" "4")) ("奏" "揍"))
    ((("z" "u" "2")) ("足" "族" "卒" "鏃"))
    ((("z" "u" "3")) ("組" "祖" "阻" "詛" "俎"))
    ((("z" "u" "a" "n" "3")) ("纂" "纘"))
    ((("z" "u" "a" "n" "4")) ("賺" "鑽" "攥"))
    ((("z" "u" "i" "3")) ("嘴"))
    ((("z" "u" "i" "4")) ("最" "罪" "醉" "蕞"))
    ((("z" "u" "n" "3")) ("撙"))
    ((("z" "u" "o" "2")) ("作" "昨" "捽"))
    ((("z" "u" "o" "3")) ("左" "佐" "撮"))
    ((("z" "u" "o" "4")) ("做" "作" "坐" "座" "鑿" "祚" "怍" "胙" "酢"))

))
