//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 2002
// 
// EHM7.cc -- 
// 
// Author           : Roy Krischer
// Created On       : Sun Nov 24 12:42:34 2002
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Aug  6 17:49:05 2005
// Update Count     : 24
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;

_ThrowEvent fred {
  public:
    int k;
    fred ( int k ) : k(k) {}
};

_Task mary {
  public:
    void main();
};

_Task john {
  public:
    void main();
};

mary m;
john j;

void mary :: main() {
    _Throw fred( 42 ) _At j;
    try {
		_Enable {
			for ( int i = 0; i < 200; i+= 1 ) yield();
		} // _Enable
    } catch ( j.fred f ) {
		uAssert( &j == f.getOriginalThrower() );
		uAssert( &j == &f.source() );
		uAssert( f.k == 84 ); 
		osacquire( cout ) << "mary catches exception from john: " << f.k << endl;
	    for ( int i = 0; i < 200; i+= 1 )
			yield();
    } // try
}
    
void john :: main() {
    _Throw fred( 84 ) _At m;
    try {
		_Enable {
			for ( int i = 0; i < 200; i+= 1 ) yield();
		} // _Enable
    } catch ( m.fred f ) {
		uAssert( &m == f.getOriginalThrower() );
		uAssert( &m == &f.source() );
		uAssert( f.k == 42 ); 
		osacquire( cout ) << "john catches exception from mary: " << f.k << endl
			  << "mary m's address: " << (void *)&m << " exception binding: " << f.getOriginalThrower()
			  << " exception Src: " << (void *)&f.source() << endl;
	 
	    for ( int i = 0; i < 200; i+= 1 ) yield();
    } // try
}

void uMain::main() {
	for ( int i = 0; i < 200; i+= 1 ) yield();
}

// Local Variables: //
// tab-width: 4 //
// End: //
