
#include "catWids.h"

#include <X11/Xaw/Dialog.h>

#define SPACING 4

#define FREQLEFTOFS 120
#define INFOOFS 40
#define CATHEIGHT 320
#define CATWIDTH 380

char *BANDLABEL[10]={"160","80","40","30","20","17","15","12","10","6"};

/* CAT mode selection + configure button */
void Cat::buildModeWidget(Widget shell, AppRes *appRes)
{
    /* left hand side "CAT-RX Mode selection" form */
    catModeForm = XtVaCreateWidget("catmodeform", xmFormWidgetClass, shell,
				   XmNwidth, 100,
				   XmNheight, 250,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_NONE,
				   XmNverticalSpacing, SPACING,
				   XmNhorizontalSpacing, SPACING,
				   NULL);

    /* CAT-RX-mode form: caption label */
    catmodeRX = XtVaCreateManagedWidget ("RX Mode:", xmLabelWidgetClass, 
					 catModeForm,
					 XmNtopAttachment, XmATTACH_FORM,
					 XmNleftAttachment, XmATTACH_FORM,
					 NULL);
    char buf[128];
    for(int i=0; i<2; i++) {
	sprintf(buf,"Mode %d",i+1);
	rxMode[i] = XtVaCreateManagedWidget(buf, xmPushButtonWidgetClass,
					    catModeForm,
					    XmNtopAttachment, XmATTACH_WIDGET,
					    XmNleftAttachment, XmATTACH_FORM,
					    XmNtopWidget,i?rxMode[i-1]:
					    catmodeRX,
					    NULL);
    }

    catmodeTX = XtVaCreateManagedWidget ("TX Mode:", xmLabelWidgetClass, 
					 catModeForm,
					 XmNtopAttachment, XmATTACH_WIDGET,
					 XmNtopWidget, rxMode[1],
					 XmNleftAttachment, XmATTACH_FORM,
					 NULL);
    for(int i=0; i<2; i++) {
	sprintf(buf,"Mode %d",i+1);
	txMode[i] = XtVaCreateManagedWidget(buf, xmPushButtonWidgetClass,
					    catModeForm,
					    XmNtopAttachment, XmATTACH_WIDGET,
					    XmNleftAttachment, XmATTACH_FORM,
					    XmNtopWidget,i?txMode[i-1]:
					    catmodeTX,
					    NULL);
    }

    catmodeSetup = XtVaCreateManagedWidget("Configure...", 
					   xmPushButtonWidgetClass,
					   catModeForm,
					   XmNbottomAttachment, XmATTACH_FORM,
					   XmNleftAttachment, XmATTACH_FORM,
					   NULL);

    
}

/* Title frame (CAT module plugin info) */
void Cat::buildTitleWidget(Widget shell, AppRes *appRes)
{
    /* very upper right-hand side "comm' plugin" info form */
    pluginForm = XtVaCreateWidget("pluginform", xmFormWidgetClass,
				  shell,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_FORM,
				  XmNrightAttachment, XmATTACH_FORM,
				  XmNverticalSpacing, SPACING,
				  XmNhorizontalSpacing, SPACING,
				  NULL);

    pText1= XtVaCreateManagedWidget("Communication plugin module information:",
				    xmLabelWidgetClass, pluginForm,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNtopAttachment, XmATTACH_FORM,
				    NULL);
    pText2= XtVaCreateManagedWidget("",
				    xmLabelWidgetClass, pluginForm,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNtopWidget, pText1,
				    XmNbottomAttachment, XmATTACH_FORM,
				    NULL);
    setPluginInfoText("FT747GX");
}

/* frequence info + change and status info frame */
void Cat::buildFreqWidget(Widget shell, AppRes *appRes)
{

    /* upper right-hand side "Frequency selection/Status info" form */
    frequencyForm = XtVaCreateWidget("frequencyform", xmFormWidgetClass, 
				     shell,
				     XmNtopAttachment, XmATTACH_FORM,
				     XmNbottomAttachment, XmATTACH_NONE,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNrightAttachment, XmATTACH_FORM,
				     XmNverticalSpacing, SPACING,
				     XmNhorizontalSpacing, SPACING,
				     NULL);

    /* frequence form: caption content: text lines */
    fText1 = XtVaCreateManagedWidget("TRX display:",
				     xmLabelWidgetClass, frequencyForm, 
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNtopAttachment, XmATTACH_FORM,
				     NULL);
    fText1b = XtVaCreateManagedWidget("XX.XXX.XXX,X Hz",
				      xmTextWidgetClass, frequencyForm,
				      XmNeditable, False,
				      XmNcolumns, 15,
				      XmNshadowThickness, 0,
				      XmNvalue, "XX.XXX.XXX,X Hz",
				      XmNcursorPositionVisible, False,
				      XmNleftOffset, FREQLEFTOFS,
				      XmNtopAttachment, XmATTACH_FORM,
				      XmNleftAttachment, XmATTACH_FORM,
				      NULL);

    fText2 = XtVaCreateManagedWidget("PSK31 carrier:",
				     xmLabelWidgetClass, frequencyForm, 
				     XmNtopWidget, fText1b,
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNleftAttachment, XmATTACH_FORM,
				     NULL);

    fText2b = XtVaCreateManagedWidget("XX.XXX.XXX,X Hz  ",
				      xmTextWidgetClass, frequencyForm,
				      XmNcolumns, 15,
				      XmNeditable, False,
				      XmNshadowThickness, 0,
				      XmNvalue, "XX.XXX.XXX,X Hz",
				      XmNcursorPositionVisible, False,
				      XmNtopWidget, fText1b,
				      XmNtopAttachment, XmATTACH_WIDGET,
				      XmNleftOffset, FREQLEFTOFS,
				      XmNleftAttachment, XmATTACH_FORM,
				      NULL);

    fText3 = XtVaCreateManagedWidget("Frequency:",
				     xmLabelWidgetClass, frequencyForm, 
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, fText2b,
				     XmNleftAttachment, XmATTACH_FORM,
				     NULL);
    freqScroll = XtVaCreateManagedWidget("fscroll", xmScrollBarWidgetClass,
					 frequencyForm,
					 XmNtopAttachment, XmATTACH_WIDGET,
					 XmNtopWidget, fText2b,
					 XmNleftOffset, FREQLEFTOFS,
					 XmNleftAttachment, XmATTACH_FORM,
					 XmNrightAttachment, XmATTACH_FORM,
					 XmNorientation, XmHORIZONTAL,
					 XmNbottomAttachment, XmATTACH_NONE,
					 NULL);

    fText4 = XtVaCreateManagedWidget("Band:",
				     xmLabelWidgetClass, frequencyForm,
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, fText3,
				     XmNleftAttachment, XmATTACH_FORM,
				     NULL);

    bandRB = XmCreateRadioBox(frequencyForm, "bandRB", NULL, 0);
    XtVaSetValues(bandRB,      
		  XmNentryAlignment, XmALIGNMENT_CENTER,
		  XmNorientation, XmHORIZONTAL,
		  XmNtopAttachment, XmATTACH_WIDGET,
		  XmNtopWidget, fText3,
		  XmNnumColumns, 2,
		  XmNpacking, XmPACK_COLUMN,
		  XmNleftAttachment, XmATTACH_FORM,
		  XmNleftOffset, FREQLEFTOFS,
		  XmNrightAttachment, XmATTACH_NONE,
		  XmNbottomAttachment, XmATTACH_NONE,
		  NULL);

    XtVaSetValues(freqScroll,
		  XmNrightWidget, bandRB,
		  XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET, NULL);

    for(int i=0; i<BANDS; i++) {
	bandwids[i] = XtVaCreateManagedWidget(BANDLABEL[i], 
					      xmToggleButtonWidgetClass,
					      bandRB,
					      XmNshadowThickness, 1,
					      XmNindicatorOn, False,
					      NULL); 
    }
    XtManageChild(bandRB);


    fText5 = XtVaCreateManagedWidget("Status:",
				     xmLabelWidgetClass, frequencyForm, 
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, bandRB,
				     XmNleftAttachment, XmATTACH_FORM,
				     NULL);
    fText5a= XtVaCreateManagedWidget("",
				     xmLabelWidgetClass, frequencyForm, 
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, bandRB,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNleftOffset, FREQLEFTOFS,
				     NULL);
    fText5b= XtVaCreateManagedWidget("",
				     xmLabelWidgetClass, frequencyForm, 
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, fText5a,
				     XmNleftOffset, FREQLEFTOFS,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNbottomAttachment, XmATTACH_FORM,
				     NULL);
    setStatusInfoText("AAA","BBB");
}

void Cat::buildInfoWidget(Widget shell, AppRes *appRes)
{
    /* lower right-hand side "Mode information" form */
    modeinfoForm = XtVaCreateWidget("infoform", xmFormWidgetClass, shell,
				    XmNtopWidget, sep2,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNbottomAttachment, XmATTACH_FORM,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNrightAttachment, XmATTACH_FORM,
				    XmNverticalSpacing, 0,
				    XmNhorizontalSpacing, SPACING,
				    NULL);
				    
    /* modeinfo form: content text */
    iText1 = XtVaCreateManagedWidget("RX:",
				     xmLabelWidgetClass, modeinfoForm, 
				     XmNtopOffset, SPACING, 
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNtopAttachment, XmATTACH_FORM,
				     NULL);
    iText1a= XtVaCreateManagedWidget("", xmLabelWidgetClass, modeinfoForm,
				     XmNtopOffset, SPACING, 
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNleftOffset, INFOOFS,
				     XmNtopAttachment, XmATTACH_FORM,
				     NULL);
    iText1b= XtVaCreateManagedWidget("", xmLabelWidgetClass, modeinfoForm,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNleftOffset, INFOOFS,
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, iText1a,
				     NULL);

    iText2 = XtVaCreateManagedWidget("TX:",
				     xmLabelWidgetClass, modeinfoForm,
				     XmNtopOffset, SPACING, 
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, iText1b,
				     XmNleftAttachment, XmATTACH_FORM,
				     NULL);
    iText2a= XtVaCreateManagedWidget("", xmLabelWidgetClass, modeinfoForm,
				     XmNtopOffset, SPACING, 
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, iText1b,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNleftOffset, INFOOFS,
				     NULL);
    iText2b= XtVaCreateManagedWidget("", xmLabelWidgetClass, modeinfoForm,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNleftOffset, INFOOFS,
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, iText2a,
				     NULL);
    setRXModeInfoText("AAA","BBB");
    setTXModeInfoText("dasdas","Hallo");
}

void Cat::buildWidgets(Widget shell, AppRes *appRes)
{
    dialogform = XtVaCreatePopupShell("CAT transceiver remote control", 
				      xmDialogShellWidgetClass, shell,
				      XmNallowShellResize, 0,
				      XmNwidth, CATWIDTH,
				      XmNheight, CATHEIGHT,
				      XmNminHeight, CATHEIGHT,
				      XmNmaxHeight, CATHEIGHT,
				      XmNminWidth, CATWIDTH,
				      XmNmaxWidth, CATWIDTH,
				      NULL);

    /* dialog box mainform */
    masterform = XtVaCreateWidget("dlgmasterform", xmFormWidgetClass, 
				  dialogform,
				  XmNverticalSpacing, 0,
				  XmNhorizontalSpacing, 0,
				  XmNwidth, CATWIDTH,
				  XmNheight, CATHEIGHT,
				  NULL);

    /* creates pluginForm */
    buildTitleWidget(masterform, appRes);

    /* vert. separator */
    sep1 = XtVaCreateManagedWidget ("sep1", xmSeparatorWidgetClass, 
				    masterform, 
				    XmNorientation, XmHORIZONTAL,
				    XmNtopWidget, pluginForm,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNbottomAttachment, XmATTACH_NONE,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNrightAttachment, XmATTACH_FORM,
				    NULL);
    /* dialog box mainform */
    mainform = XtVaCreateWidget("dlgmainform", xmFormWidgetClass, 
				masterform,
				XmNverticalSpacing, 0,
				XmNhorizontalSpacing, 0,
				//XmNwidth, CATWIDTH,
				//XmNheight, CATHEIGHT,
				XmNtopWidget, sep1,
				XmNtopAttachment, XmATTACH_WIDGET,
				XmNbottomAttachment, XmATTACH_FORM,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
				NULL);


    /* creates catModeForm */
    buildModeWidget(mainform, appRes);

    /* vertical separator */
    sep = XtVaCreateManagedWidget ("sep", xmSeparatorWidgetClass,  mainform, 
				   XmNorientation, XmVERTICAL,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_WIDGET,
				   XmNleftWidget, catModeForm,
				   XmNrightAttachment, XmATTACH_NONE,
				   NULL);

    /* right-hand side form */
    rightform = XtVaCreateWidget("rightform", xmFormWidgetClass, 
				 mainform, 
				 XmNverticalSpacing, SPACING,
				 XmNhorizontalSpacing, SPACING,
				 XmNtopAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNleftWidget, sep,
				 XmNleftAttachment, XmATTACH_WIDGET,
				 XmNbottomAttachment, XmATTACH_FORM,
				 XmNverticalSpacing, 0,
				 XmNhorizontalSpacing, 0,
				 NULL);

    buildFreqWidget( rightform, appRes );

    /* hor. separator */
    sep2 = XtVaCreateManagedWidget ("sep2", xmSeparatorWidgetClass, rightform, 
				   XmNorientation, XmHORIZONTAL,
				   XmNtopWidget, frequencyForm,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNbottomAttachment, XmATTACH_NONE,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   NULL);

    buildInfoWidget( rightform, appRes);


    XtManageChild(catModeForm);
    XtManageChild(mainform);
    XtManageChild(masterform);
    XtManageChild(rightform);
    XtManageChild(bandRB);
    XtManageChild(pluginForm);
    XtManageChild(frequencyForm);
    XtManageChild(modeinfoForm);

    XtPopup(dialogform, XtGrabNone);

    XtRealizeWidget(shell);
}
