//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/StringProperty.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/StringAlgorithm.h"
#include "tulip/AbstractProperty.h"

using namespace std;
using namespace tlp;

StringProperty::StringProperty (Graph *sg):AbstractProperty<StringType,StringType, StringAlgorithm>(sg) {
  //  propertyProxy=this;
}
  
//=================================================================================
PropertyInterface* StringProperty::clonePrototype(Graph * g, std::string n)
{
	if( !g )
		return 0;
	StringProperty * p = g->getLocalProperty<StringProperty>( n );
	p->setAllNodeValue( getNodeDefaultValue() );
	p->setAllEdgeValue( getEdgeDefaultValue() );
	return p;
}
//=============================================================
void StringProperty::copy( const node n0, const node n1, PropertyInterface * p )
{
	if( !p )
		return;
	StringProperty * tp = dynamic_cast<StringProperty*>(p);
	assert( tp );
	setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void StringProperty::copy( const edge e0, const edge e1, PropertyInterface * p )
{
	if( !p )
	  return;
	StringProperty * tp = dynamic_cast<StringProperty*>(p);
	assert( tp );
	setEdgeValue( e0, tp->getEdgeValue(e1) );
}


