/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.CopyEmitter;
import com.nwalsh.saxon.FormatCallout;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class CalloutEmitter
extends CopyEmitter {
    protected Stack elementStack = new Stack();
    protected Stack tempStack = null;
    protected boolean firstElement = true;
    protected static String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static String xhURI = "http://www.w3.org/1999/xhtml";
    protected int defaultColumn = 60;
    protected boolean foStylesheet = false;
    private static int lineNumber = 0;
    private static int colNumber = 0;
    private static Callout[] callout = null;
    private static int calloutCount = 0;
    private static int calloutPos = 0;
    private static FormatCallout fCallout = null;

    public CalloutEmitter(Controller controller, NamePool namePool, int n, boolean bl, FormatCallout formatCallout) {
        super(controller, namePool);
        this.defaultColumn = n;
        this.foStylesheet = bl;
        fCallout = formatCallout;
    }

    public void setupCallouts(NodeList nodeList) {
        callout = new Callout[10];
        calloutCount = 0;
        calloutPos = 0;
        lineNumber = 1;
        colNumber = 1;
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        Node node = nodeList.item(0);
        NodeList nodeList2 = node.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equalsIgnoreCase("areaset")) {
                ++n;
                NodeList nodeList3 = node2.getChildNodes();
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    Node node3 = nodeList3.item(j);
                    if (node3.getNodeType() != 1) continue;
                    if (node3.getNodeName().equalsIgnoreCase("area")) {
                        this.addCallout(n, node3, this.defaultColumn);
                        continue;
                    }
                    System.out.println("Unexpected element in areaset: " + node3.getNodeName());
                }
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("area")) {
                this.addCallout(++n, node2, this.defaultColumn);
                continue;
            }
            System.out.println("Unexpected element in areaspec: " + node2.getNodeName());
        }
        Arrays.sort(callout, 0, calloutCount);
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        this.firstElement = false;
        if (lineNumber == 0) {
            ++lineNumber;
            colNumber = 1;
        }
        char[] cArray2 = new char[n2];
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            if (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                if (n3 > 0) {
                    this.rtfEmitter.characters(cArray2, 0, n3);
                    n3 = 0;
                }
                this.closeOpenElements(this.rtfEmitter);
                while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                    fCallout.formatCallout(this.rtfEmitter, callout[calloutPos]);
                    ++calloutPos;
                }
                this.openClosedElements(this.rtfEmitter);
            }
            if (cArray[i] == '\n') {
                if (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() > colNumber) {
                    if (n3 > 0) {
                        this.rtfEmitter.characters(cArray2, 0, n3);
                        n3 = 0;
                    }
                    this.closeOpenElements(this.rtfEmitter);
                    while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() > colNumber) {
                        this.formatPad(callout[calloutPos].getColumn() - colNumber);
                        colNumber = callout[calloutPos].getColumn();
                        while (calloutPos < calloutCount && callout[calloutPos].getLine() == lineNumber && callout[calloutPos].getColumn() == colNumber) {
                            fCallout.formatCallout(this.rtfEmitter, callout[calloutPos]);
                            ++calloutPos;
                        }
                    }
                    this.openClosedElements(this.rtfEmitter);
                }
                ++lineNumber;
                colNumber = 1;
            } else {
                ++colNumber;
            }
            cArray2[n3++] = cArray[i];
        }
        if (n3 > 0) {
            this.rtfEmitter.characters(cArray2, 0, n3);
        }
    }

    protected void formatPad(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        try {
            this.rtfEmitter.characters(cArray, 0, n);
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in formatPad");
        }
    }

    protected void addCallout(int n, Node node, int n2) {
        int n3;
        Callout[] calloutArray;
        Element element = (Element)node;
        String string = null;
        String string2 = null;
        if (element.hasAttribute("units")) {
            string = element.getAttribute("units");
        }
        if (element.hasAttribute("coords")) {
            string2 = element.getAttribute("coords");
        }
        if (string != null && !string.equalsIgnoreCase("linecolumn") && !string.equalsIgnoreCase("linerange")) {
            System.out.println("Only linecolumn and linerange units are supported");
            return;
        }
        if (string2 == null) {
            System.out.println("Coords must be specified");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (++n4 > 2) {
                System.out.println("Unparseable coordinates");
                return;
            }
            try {
                calloutArray = stringTokenizer.nextToken();
                n6 = n3 = Integer.parseInt((String)calloutArray);
                if (n4 != 1) continue;
                n5 = n3;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Unparseable coordinate");
                return;
            }
        }
        if (calloutCount == callout.length) {
            calloutArray = new Callout[calloutCount + 10];
            for (n3 = 0; n3 < callout.length; ++n3) {
                calloutArray[n3] = callout[n3];
            }
            callout = calloutArray;
        }
        if (n4 == 2) {
            if (string != null && string.equalsIgnoreCase("linerange")) {
                for (int i = n5; i <= n6; ++i) {
                    CalloutEmitter.callout[CalloutEmitter.calloutCount++] = new Callout(n, element, i, n2);
                }
            } else {
                CalloutEmitter.callout[CalloutEmitter.calloutCount++] = new Callout(n, element, n5, n6);
            }
        } else {
            CalloutEmitter.callout[CalloutEmitter.calloutCount++] = new Callout(n, element, n5, n2);
        }
    }

    public void endElement(int n) throws TransformerException {
        if (!this.elementStack.empty()) {
            this.elementStack.pop();
        }
        this.rtfEmitter.endElement(n);
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        if (!this.skipThisElement(n)) {
            StartElementInfo startElementInfo = new StartElementInfo(n, attributes, nArray, n2);
            this.elementStack.push(startElementInfo);
        }
        this.firstElement = false;
        this.rtfEmitter.startElement(n, attributes, nArray, n2);
    }

    protected boolean skipThisElement(int n) {
        if (this.firstElement) {
            int n2 = this.namePool.getFingerprint(n);
            int n3 = this.namePool.getFingerprint(foURI, "block");
            int n4 = this.namePool.getFingerprint("", "pre");
            int n5 = this.namePool.getFingerprint("", "div");
            int n6 = this.namePool.getFingerprint(xhURI, "pre");
            int n7 = this.namePool.getFingerprint(xhURI, "div");
            if (this.foStylesheet && n2 == n3 || !this.foStylesheet && (n2 == n4 || n2 == n5 || n2 == n6 || n2 == n7)) {
                return true;
            }
        }
        return false;
    }

    private void closeOpenElements(Emitter emitter) throws TransformerException {
        this.tempStack = new Stack();
        while (!this.elementStack.empty()) {
            StartElementInfo startElementInfo = (StartElementInfo)this.elementStack.pop();
            emitter.endElement(startElementInfo.getNameCode());
            this.tempStack.push(startElementInfo);
        }
    }

    private void openClosedElements(Emitter emitter) throws TransformerException {
        while (!this.tempStack.empty()) {
            StartElementInfo startElementInfo = (StartElementInfo)this.tempStack.pop();
            AttributeCollection attributeCollection = (AttributeCollection)startElementInfo.getAttributes();
            AttributeCollection attributeCollection2 = new AttributeCollection(this.namePool);
            for (int i = 0; i < attributeCollection.getLength(); ++i) {
                String string = attributeCollection.getLocalName(i);
                int n = attributeCollection.getNameCode(i);
                String string2 = attributeCollection.getType(i);
                String string3 = attributeCollection.getValue(i);
                String string4 = attributeCollection.getURI(i);
                String string5 = "";
                if (string.indexOf(58) > 0) {
                    string5 = string.substring(0, string.indexOf(58));
                    string = string.substring(string.indexOf(58) + 1);
                }
                if (string4.equals("") && (this.foStylesheet && string.equals("id") || !this.foStylesheet && (string.equals("id") || string.equals("name")))) continue;
                attributeCollection2.addAttribute(string5, string4, string, string2, string3);
            }
            emitter.startElement(startElementInfo.getNameCode(), (Attributes)attributeCollection2, startElementInfo.getNamespaces(), startElementInfo.getNSCount());
            this.elementStack.push(startElementInfo);
        }
    }

    private class StartElementInfo {
        private int _nameCode;
        Attributes _attributes;
        int[] _namespaces;
        int _nscount;

        public StartElementInfo(int n, Attributes attributes, int[] nArray, int n2) {
            this._nameCode = n;
            this._attributes = attributes;
            this._namespaces = nArray;
            this._nscount = n2;
        }

        public int getNameCode() {
            return this._nameCode;
        }

        public Attributes getAttributes() {
            return this._attributes;
        }

        public int[] getNamespaces() {
            return this._namespaces;
        }

        public int getNSCount() {
            return this._nscount;
        }
    }
}

