/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include <header.h>


/*********************** DUPLICATE CALLSIGN *********************************/

void duplicate_callsign_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_buttons_width(term, dlg->items +0, 1, &max);
    min_buttons_width(term, dlg->items +0, 1, &min);
    max_buttons_width(term, dlg->items +1, 1, &max);
    min_buttons_width(term, dlg->items +1, 1, &min);
    max_buttons_width(term, dlg->items +2, 1, &max);
    min_buttons_width(term, dlg->items +2, 1, &min);
    max_buttons_width(term, dlg->items +3, 1, &max);
    min_buttons_width(term, dlg->items +3, 1, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
    if (w < 1) w = 1;
    
    rw = 0;
    y++;
    dlg_format_buttons(NULL, term, dlg->items +0, 1, 0, &y, w, &rw, AL_CENTER);
    dlg_format_buttons(NULL, term, dlg->items +1, 1, 0, &y, w, &rw, AL_CENTER);
    dlg_format_buttons(NULL, term, dlg->items +2, 1, 0, &y, w, &rw, AL_CENTER);
    dlg_format_buttons(NULL, term, dlg->items +3, 1, 0, &y, w, &rw, AL_CENTER);
    y++;
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_buttons(term, term, dlg->items +0, 1, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
    dlg_format_buttons(term, term, dlg->items +1, 1, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
    dlg_format_buttons(term, term, dlg->items +2, 1, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
    dlg_format_buttons(term, term, dlg->items +3, 1, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
    y++;
    
    
    /*  dlg_format_text(term, term, contest_options1_msg[3], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);*/
 /*   dlg_format_field(term, term, &dlg->items[3], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);*/
 /*   y++;*/
/*  dlg_format_text(term, term, contest_options1_msg[4], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
    dlg_format_field(term, term, &dlg->items[4], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    dlg_format_text(term, term, contest_options1_msg[4], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
    dlg_format_field(term, term, &dlg->items[4], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    y++;*/
}

int dlg_clear_tmpqsos(struct dialog_data *dlg, struct dialog_item_data *di){

    clear_tmpqsos(aband);
    return cancel_dialog(dlg,di);
}

/* todo prototyp */
int dlg_edit_qso(struct dialog_data *dlg, struct dialog_item_data *di){
    edit_qso((struct qso *)dlg->dlg->refresh_data);

    clear_tmpqsos(aband);
    return cancel_dialog(dlg,di);
}

int dlg_mark_as_error(struct dialog_data *dlg, struct dialog_item_data *di){
    struct qso *qso;             
    
    qso = (struct qso*) dlg->dlg->refresh_data;
    qso_mark_as_error(aband, atoi(qso->qsonrs)-1);
    recalc_stats(aband);
    
    aband->dupe_in_tmpqso = 0;
    ADD_TMPQSO_STRING(aband, callsign, qso->callsign, 1, ucallsign);
    wkd_tmpqso(aband, WT_CALLSIGN, qso->callsign);

    return cancel_dialog(dlg,di);
}

int dlg_store_as_dupe(struct dialog_data *dlg, struct dialog_item_data *di){
    struct qso *qso;             
   
    aband->dupe_in_tmpqso = 0;
    
    qso = (struct qso*) dlg->dlg->refresh_data;

    aband->tmpqsos[0].dupe = 1; 
    /*ADD_TMPQSO_STRING(aband, callsign, qso->callsign, 1, ucallsign);*/
    TMPQ.ucallsign=1;
    if (!TMPQ.ulocator) add_tmpqso_locator(aband, qso->locator, 0, 0); 
     
    wkd_tmpqso(aband, WT_CALLSIGN, qso->callsign);
    wkd_tmpqso(aband, WT_LOCATOR, qso->locator);
    
    return cancel_dialog(dlg,di);
}


void duplicate_callsign(struct qso *qso)
{
    struct dialog *d;
    int i;


    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = VTEXT(T_DUPE_QSO);
    d->fn = duplicate_callsign_fn;
    d->refresh = (void (*)(void *))dlg_clear_tmpqsos;
    d->refresh_data = (void *)qso;
    
    d->items[i=0].type = D_BUTTON;
    d->items[i].gid  = B_ENTER;
    d->items[i].fn   = dlg_clear_tmpqsos; 
    d->items[i].text = VTEXT(T_CLEAR_THIS_QSO);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid  = B_ENTER;
    d->items[i].fn   = dlg_edit_qso; 
    d->items[i].text = VTEXT(T_EDIT_OLD_QSO);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid  = B_ENTER;
    d->items[i].fn   = dlg_mark_as_error; 
    d->items[i].text = VTEXT(T_MARK_OLD_QSO);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid  = B_ENTER;
    d->items[i].fn   = dlg_store_as_dupe; 
    d->items[i].text = VTEXT(T_STORE_AS_DUPE);
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}
                               


/**************************** EDIT ***********************************/

void menu_add_error(union cba_t cba){
    add_error(aband, "");
} 

/*********************** CHOP - Change operator *************************/

static char op[EQSO_LEN];
static int global_operator;

char *chop_msg[] = {
    CTEXT(T_CALLSIGN), /* 0 */
    CTEXT(T_GLOBAL_OPERATOR),
    "", /* OK */  /* 9 */
    "", /* Cancel */
};

void chop(struct band *band, char *op){
    gchar *c;
    
    g_free(band->operator);
    band->operator = fixsemi(g_strdup(op));
    c = g_strconcat("O ", op, NULL);
    add_swap(band, c);
    g_free(c);  
    wkd_tmpqso(band, WT_OPERATOR, op);
}

void refresh_chop(void *xxx){
    int i;

    uc(op);
    if (!regcmp(op,"^([0-9][A-Z]|[A-Z]{1,2}[0-9]?)[0-9]{1,4}[A-Z]{1,4}$")==0){
        errbox(VTEXT(T_BAD_CALL), 0);
        return;
    }
    cfg->global_operator = global_operator;
    
    if (global_operator){
        for (i=0; i<ctest->bands->len; i++){
            struct band *b;

            b=(struct band *)g_ptr_array_index(ctest->bands, i);
            chop(b, op);
        }
    }else{
        chop(aband, op);
    }
    
    redraw_later();
    
}

void chop_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, chop_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, chop_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, chop_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, chop_msg + 1, dlg->items + 1, 1, &min);
    max_buttons_width(term, dlg->items + 2, 2, &max);
    min_buttons_width(term, dlg->items + 2, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, chop_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    y++;
    dlg_format_group(NULL, term, chop_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 2, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, chop_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group(term, term, chop_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 2, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}


void menu_chop(union cba_t cba){
    struct dialog *d;
    int i;
    
    if (!ctest || !aband) return;
    
    fixsemi(aband->operator);
    safe_strncpy0(op, aband->operator, EQSO_LEN);
    global_operator=cfg->global_operator;

/*    input_field(NULL, VTEXT(T_CHOP), VTEXT(T_N_CALLSIGN), 
               VTEXT(T_OK), VTEXT(T_CANCEL), NULL, 
               NULL, 20, op, 0, 0, NULL,
               (void (*)(void *, char *)) chop, NULL);*/
    
    if (!(d = mem_alloc(sizeof(struct dialog) + 10 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 10 * sizeof(struct dialog_item));
    d->title = VTEXT(T_CHOP);
    d->fn = chop_fn;
    d->refresh = (void (*)(void *))refresh_chop;
    
    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = EQSO_LEN;
    d->items[i].data = op;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&global_operator;
    

    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));


}
/*********************** SKEDQRG - Change QRG for sked *************************/

void skedqrg(struct session *ses, char *qrg){
    gchar *c;

    if (!qrg) return;

    g_free(aband->skedqrg);
    aband->skedqrg = fixsemi(g_strdup(qrg));
    c = g_strconcat("G ", qrg, NULL);
    add_swap(aband, c);
    g_free(c);  
    c = g_strdup_printf("RG %s;%s\n",aband->pband,qrg);
    rel_write_all(c);
    g_free(c);  
    redraw_later();
}

void menu_skedqrg(union cba_t cba){
    static char qrg[20];
    
    if (!ctest || !aband) return;
    
    fixsemi(aband->skedqrg);
    safe_strncpy0(qrg, aband->skedqrg, 20);

    input_field(NULL, VTEXT(T_SKED_QRG), VTEXT(T_N_SKED_QRG), 
               VTEXT(T_OK), VTEXT(T_CANCEL), NULL, 
               NULL, 20, qrg, 0, 0, NULL,
               (void (*)(void *, char *)) skedqrg, NULL);

}

/******************** FILL OPERATORS **************************/

void menu_fillop(union cba_t cba){
    struct band *b;
    struct qso *q;
    int i,j,k;
    gchar *c;
    GString *gs,*gs1,*gs2;
    GPtrArray *calls;

    if (!ctest) return;
    for (i=0; i<ctest->bands->len; i++){
        b = (struct band *)g_ptr_array_index(ctest->bands,i);
        
        calls=g_ptr_array_new();
        for (j=0;j<b->qsos->len;j++){
            q=(struct qso *)g_ptr_array_index(b->qsos,j);

            for (k=0;k<calls->len;k++){
                if (strcmp(q->operator,g_ptr_array_index(calls,k))==0) break;
            }
            if (k==calls->len)
                g_ptr_array_add(calls, q->operator);
            
        }

        g_ptr_array_qsort(calls, compare_gstring);
        gs1=g_string_sized_new(100);
        gs2=g_string_sized_new(100);
        gs=gs1;
        for (k=0; k<calls->len;k++){
            c=g_ptr_array_index(calls, k);
            if (gs->len+2+strlen(c) >= 50) gs=gs2;
            g_string_append(gs, ";");
            g_string_append(gs, c);
        }
        g_ptr_array_free(calls,TRUE); /* don't free items! */
        
        if (gs1->len) g_string_erase(gs1,0,1);
        if (gs2->len) g_string_erase(gs2,0,1);
        
        g_free(b->mope1);
        b->mope1=g_strdup(gs1->str);
        g_string_free(gs1,TRUE);
        
        g_free(b->mope2);
        b->mope2=g_strdup(gs2->str);
        g_string_free(gs2,TRUE);
    }
    save_all_bands_txt(0);
}

/******************** RECALC ALL QRB and QTF  **************************/

void menu_recalc_qrb(union cba_t cba){
	if (ctest) recalc_all_qrbqtf(ctest);
}

/******************** UPDATE C_W ******************************/

void menu_cw_update_contest(union cba_t cba){
    gchar *s;
    int ret;
    
    update_cw_from_ctest(cw, ctest);
    s = g_strconcat(getenv("HOME"), "/tucnak/tucnakcw", NULL);
    ret=save_cw_into_file(cw, s);        
    if (ret){
        errbox(VTEXT(T_CANT_WRITE), ret);
    }else{
        log_addf(VTEXT(T_SAVED_S), s);
    }
    g_free(s);
}

void menu_cw_update_band(union cba_t cba){
    gchar *s;
    int ret;
    
    update_cw_from_band(cw, aband);
    s = g_strconcat(getenv("HOME"), "/tucnak/tucnakcw", NULL);
    ret=save_cw_into_file(cw, s);        
    if (ret){
        errbox(VTEXT(T_CANT_WRITE), ret);
    }else{
        log_addf(VTEXT(T_SAVED_S), s);
    }
    g_free(s);
}

void menu_import_ebw(union cba_t cba){
    gchar *s;
    int ret;
    
    ret=read_ebw_files(cw, namedb);
    
    s = g_strconcat(getenv("HOME"), "/tucnak/tucnakcw", NULL);
    ret=save_cw_into_file(cw, s);        
    if (ret){
        errbox(VTEXT(T_CANT_WRITE), ret);
    }else{
        log_addf(VTEXT(T_SAVED_S), s);
    }

    s = g_strconcat(getenv("HOME"), "/tucnak/tucnaknames", NULL);
    ret=save_namedb_into_file(namedb, s);        
    if (ret){
        errbox(VTEXT(T_CANT_WRITE), ret);
    }else{
        log_addf(VTEXT(T_SAVED_S), s);
    }


    
    g_free(s);
}

/******************** AUTOSAVE *******************************/

#define AS_LEN 5

/*char as_disk_aq_str[AS_LEN], as_disk_am_str[AS_LEN];
gint as_disk_fsync;*/
char as_floppy_aq_str[AS_LEN], as_floppy_am_str[AS_LEN];
gint as_floppy_fsync;
gint as_mount;
char as_floppy_path[MAX_STR_LEN];
char as_mount_cmd[MAX_STR_LEN];

                                                   
void refresh_autosave(void *xxx)
{
/*    STORE_SINT(cfg,as_disk_aq);
    STORE_SINT(cfg,as_disk_am);
    STORE_INT (cfg,as_disk_fsync); */
    STORE_SINT(cfg,as_floppy_aq);
    STORE_SINT(cfg,as_floppy_am);
    STORE_INT (cfg,as_floppy_fsync);
    STORE_INT (cfg,as_mount);
    STORE_STR(cfg,as_floppy_path);
    STORE_STR(cfg,as_mount_cmd);

    dbg("refresh_autosave\n");
}

char *autosave_msg[] = {
#if 0
    CTEXT(T_SAVE_AQ), /* 0 */
    CTEXT(T_SAVE_AM),
    CTEXT(T_FSYNC),
#endif    
    CTEXT(T_SAVE_AQF), /* 0 */
    CTEXT(T_SAVE_AMF),
    CTEXT(T_FSYNC),                 
    
    CTEXT(T_DO_MOUNT),
    CTEXT(T_FLOPPY_PATH),     /* 5 */
    CTEXT(T_MOUNT_CMD), 
    "", /* OK */  /* 9 */
    "", /* Cancel */
};

void autosave_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, autosave_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, autosave_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, autosave_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, autosave_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, autosave_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, autosave_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, autosave_msg + 3, dlg->items + 3, 1, &max);
    min_group_width(term, autosave_msg + 3, dlg->items + 3, 1, &min);
    max_group_width(term, autosave_msg + 4, dlg->items + 4, 1, &max);
    min_group_width(term, autosave_msg + 4, dlg->items + 4, 1, &min);
    max_group_width(term, autosave_msg + 5, dlg->items + 5, 1, &max);
    min_group_width(term, autosave_msg + 5, dlg->items + 5, 1, &min);
 /*   max_group_width(term, autosave_msg + 6, dlg->items + 6, 1, &max);
    min_group_width(term, autosave_msg + 6, dlg->items + 6, 1, &min);
    max_group_width(term, autosave_msg + 7, dlg->items + 7, 1, &max);
    min_group_width(term, autosave_msg + 7, dlg->items + 7, 1, &min);
    max_group_width(term, autosave_msg + 8, dlg->items + 8, 1, &max);
    min_group_width(term, autosave_msg + 8, dlg->items + 8, 1, &min);
 */   
    max_buttons_width(term, dlg->items + 6, 2, &max);
    min_buttons_width(term, dlg->items + 6, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, autosave_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, autosave_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, autosave_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    y++;
    dlg_format_group(NULL, term, autosave_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, autosave_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, autosave_msg + 5, dlg->items + 5, 1, 0, &y, w, &rw);
/*    y++;
    dlg_format_group(NULL, term, autosave_msg + 6, dlg->items + 6, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, autosave_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, autosave_msg + 8, dlg->items + 8, 1, 0, &y, w, &rw);
    */
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 6, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, autosave_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, autosave_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, autosave_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group(term, term, autosave_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, autosave_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, autosave_msg + 5, dlg->items + 5, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
/*    y++;
    dlg_format_group(term, term, autosave_msg + 6, dlg->items + 6, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, autosave_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, autosave_msg + 8, dlg->items + 8, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    */
    y++;
    dlg_format_buttons(term, term, dlg->items + 6, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void menu_autosave(union cba_t cba)
{
    struct dialog *d;
    int i;

    dbg("menu_autosave\n");
 /*   snprint(as_disk_aq_str,AS_LEN, cfg->as_disk_aq);
    snprint(as_disk_am_str, AS_LEN, cfg->as_disk_am);
    as_disk_fsync = cfg->as_disk_fsync;*/
    snprint(as_floppy_aq_str, AS_LEN, cfg->as_floppy_aq);
    snprint(as_floppy_am_str, AS_LEN, cfg->as_floppy_am);
    as_floppy_fsync = cfg->as_floppy_fsync;
    as_mount = cfg->as_mount;
    safe_strncpy0(as_floppy_path, cfg->as_floppy_path, MAX_STR_LEN); 
    safe_strncpy0(as_mount_cmd, cfg->as_mount_cmd, MAX_STR_LEN); 
    

    if (!(d = mem_alloc(sizeof(struct dialog) + 55 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 55 * sizeof(struct dialog_item));
    d->title = VTEXT(T_AUTOSAVE_OPTS);
    d->fn = autosave_fn;
    d->refresh = (void (*)(void *))refresh_autosave;

    
/*    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = AS_LEN;
    d->items[i].data = as_disk_aq_str;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = AS_LEN;
    d->items[i].data = as_disk_am_str;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&as_disk_fsync;
    
  */  
    d->items[i=0].type = D_FIELD;
    d->items[i].dlen = AS_LEN;
    d->items[i].data = as_floppy_aq_str;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = AS_LEN;
    d->items[i].data = as_floppy_am_str;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&as_floppy_fsync;
    

    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 0;
    d->items[i].gnum = 1;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&as_mount;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = as_floppy_path;
    d->items[i].maxl = 20;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = as_mount_cmd;
    d->items[i].maxl = 20;
    
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}


/******************** ADD SUBWIN *******************************/

int asw_type;
char asw_cmd[MAX_STR_LEN];
char asw_respawn_str[MAX_STR_LEN];

                                                   
void refresh_add_sw(struct session *ses){
    struct subwin *sw;

    dbg("refresh_add_sw\n");
    

    switch(asw_type){
        case SWT_PIPE: /* shell */
            sw = new_subwin(SWT_PIPE, VTEXT(T_SW_SHELL), sw_pipe_enter);
            break;
        case SWT_QSOS: 
            sw = new_subwin(SWT_QSOS, VTEXT(T_SW_QSOS), NULL);
            break;
        case SWT_LOG: 
            sw = new_subwin(SWT_LOG, VTEXT(T_SW_LOG), NULL);
            break;
        case SWT_TALK: 
            sw = new_subwin(SWT_TALK, VTEXT(T_SW_TALK), NULL);
            break;
        case SWT_SKED: 
            sw = new_subwin(SWT_SKED, VTEXT(T_SW_SKED), NULL);
            break;
        case SWT_UNFI: 
            sw = new_subwin(SWT_UNFI, VTEXT(T_SW_UNFI), NULL);
            break;
        case SWT_DXC: 
/*            sw = new_subwin(SWT_DXC, VTEXT(T_SW_DXC), NULL);*/
            break;
        case SWT_STAT: 
            sw = new_subwin(SWT_STAT, VTEXT(T_SW_STAT), NULL);
            break;
        case SWT_SWAP: 
/*            sw = new_subwin(SWT_SWAP, VTEXT(T_SW_STAT), NULL);*/
            break;
        case SWT_MAP:
            sw = new_subwin(SWT_MAP, VTEXT(T_SW_MAP), NULL);
            break;
            
    }
    
}

char *add_sw_msg[] = {
    CTEXT(T_SHELL), /* 0 */
    CTEXT(T_QSOS),
    CTEXT(T_LOG),
    CTEXT(T_TALK),
    CTEXT(T_SKEDS),
    CTEXT(T_UNFI),          /* 5 */
    CTEXT(T_DXC),
    CTEXT(T_STAT),
    CTEXT(T_SWAP),
    CTEXT(T_MAP),               
    CTEXT(T_CMD),  /* 10 */
    CTEXT(T_RESPAWN),
    "", /* OK */  /* 12 */
    "", /* Cancel */
};

void add_sw_fn(struct dialog_data *dlg)
{
    struct terminal *term = dlg->win->term;
    int max = 0, min = 0;
    int w, rw;
    int y = -1;

    max_group_width(term, add_sw_msg + 0, dlg->items + 0, 1, &max);
    min_group_width(term, add_sw_msg + 0, dlg->items + 0, 1, &min);
    max_group_width(term, add_sw_msg + 1, dlg->items + 1, 1, &max);
    min_group_width(term, add_sw_msg + 1, dlg->items + 1, 1, &min);
    max_group_width(term, add_sw_msg + 2, dlg->items + 2, 1, &max);
    min_group_width(term, add_sw_msg + 2, dlg->items + 2, 1, &min);
    max_group_width(term, add_sw_msg + 3, dlg->items + 3, 1, &max);
    min_group_width(term, add_sw_msg + 3, dlg->items + 3, 1, &min);
    max_group_width(term, add_sw_msg + 4, dlg->items + 4, 1, &max);
    min_group_width(term, add_sw_msg + 4, dlg->items + 4, 1, &min);
    max_group_width(term, add_sw_msg + 5, dlg->items + 5, 1, &max);
    min_group_width(term, add_sw_msg + 5, dlg->items + 5, 1, &min);
    max_group_width(term, add_sw_msg + 6, dlg->items + 6, 1, &max);
    min_group_width(term, add_sw_msg + 6, dlg->items + 6, 1, &min);
    max_group_width(term, add_sw_msg + 7, dlg->items + 7, 1, &max);
    min_group_width(term, add_sw_msg + 7, dlg->items + 7, 1, &min);
    max_group_width(term, add_sw_msg + 8, dlg->items + 8, 1, &max);
    min_group_width(term, add_sw_msg + 8, dlg->items + 8, 1, &min);
    max_group_width(term, add_sw_msg + 9, dlg->items + 9, 1, &max);
    min_group_width(term, add_sw_msg + 9, dlg->items + 9, 1, &min);
    max_group_width(term, add_sw_msg +10, dlg->items +10, 1, &max);
    max_group_width(term, add_sw_msg +10, dlg->items +10, 1, &max);
    min_group_width(term, add_sw_msg +11, dlg->items +11, 1, &min);
    min_group_width(term, add_sw_msg +11, dlg->items +11, 1, &min);
    
    max_buttons_width(term, dlg->items + 12, 2, &max);
    min_buttons_width(term, dlg->items + 12, 2, &min);
    
    w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
    if (w > max) w = max;
    if (w < min) w = min;
    if (w > dlg->win->term->x - 2 * DIALOG_LB - 8 ) w = dlg->win->term->x - 2 * DIALOG_LB - 8;
    if (w < 1) w = 1;
    
    rw = 0;
    y ++;
    dlg_format_group(NULL, term, add_sw_msg + 0, dlg->items + 0, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 1, dlg->items + 1, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 2, dlg->items + 2, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 3, dlg->items + 3, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 4, dlg->items + 4, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 5, dlg->items + 5, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 6, dlg->items + 6, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 7, dlg->items + 7, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 8, dlg->items + 8, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg + 9, dlg->items + 9, 1, 0, &y, w, &rw);
    y++;
    dlg_format_group(NULL, term, add_sw_msg +10, dlg->items +10, 1, 0, &y, w, &rw);
    dlg_format_group(NULL, term, add_sw_msg +11, dlg->items +11, 1, 0, &y, w, &rw);
    y++;
    dlg_format_buttons(NULL, term, dlg->items + 12, 2, 0, &y, w, &rw, AL_LEFT);
    
    
    w = rw;
    dlg->xw = w + 2 * DIALOG_LB;
    dlg->yw = y + 2 * DIALOG_TB;

    
    center_dlg(dlg);
    draw_dlg(dlg);
    y = dlg->y + DIALOG_TB;
    y++;
    dlg_format_group(term, term, add_sw_msg + 0, dlg->items + 0, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 1, dlg->items + 1, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 2, dlg->items + 2, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 3, dlg->items + 3, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 4, dlg->items + 4, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 5, dlg->items + 5, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 6, dlg->items + 6, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 7, dlg->items + 7, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 8, dlg->items + 8, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg + 9, dlg->items + 9, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_group(term, term, add_sw_msg +10, dlg->items +10, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    dlg_format_group(term, term, add_sw_msg +11, dlg->items +11, 1, dlg->x + DIALOG_LB, &y, w, AL_LEFT);
    y++;
    dlg_format_buttons(term, term, dlg->items + 12, 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
    
}

void menu_add_subwin(union cba_t cba){

    struct dialog *d;
    int i;

    dbg("menu_add_sw\n");
    asw_type=SWT_PIPE;
    safe_strncpy0(asw_cmd, "/bin/sh", MAX_STR_LEN);
    snprint(asw_respawn_str, MAX_STR_LEN, 10);
    
    if (!(d = mem_alloc(sizeof(struct dialog) + 15 * sizeof(struct dialog_item)))) return;
    memset(d, 0, sizeof(struct dialog) + 15 * sizeof(struct dialog_item));
    d->title = VTEXT(T_ADD_SUBWIN);
    d->fn = add_sw_fn;
    d->refresh = (void (*)(void *))refresh_add_sw;
    d->refresh_data = (void *)gses; /*todo */

    
    d->items[i=0].type = D_CHECKBOX;  /* 0 */
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_PIPE;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_QSOS;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_LOG;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_TALK;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_SKED;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX; /* 5 */
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_UNFI;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_DXC;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_STAT;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_SWAP;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_CHECKBOX;
    d->items[i].gid = 1;
    d->items[i].gnum = SWT_MAP;
    d->items[i].dlen = sizeof(int);
    d->items[i].data = (void *)&asw_type;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = asw_cmd;
    
    d->items[++i].type = D_FIELD;
    d->items[i].dlen = MAX_STR_LEN;
    d->items[i].data = asw_respawn_str;
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ENTER;
    d->items[i].fn = ok_dialog;
    d->items[i].text = VTEXT(T_OK);
    
    d->items[++i].type = D_BUTTON;
    d->items[i].gid = B_ESC;
    d->items[i].fn = cancel_dialog;
    d->items[i].text = VTEXT(T_CANCEL);
    
    d->items[++i].type = D_END;
    do_dialog(d, getml(d, NULL));
}


/********************* CLOSE SUBWIN ***********************/

void menu_close_subwin(union cba_t cba){
    struct subwin *sw;
    

    sw = find_sw_ontop();
    if (!sw) return;

    free_subwin(sw);
    sw_totop_next( 0);
    redraw_later();
    
}


/******************* UNFINISHED REMARK *************/

void do_unfinished(struct session *ses, char *remark){
    GString *gs;

    if (!ctest || !aband) return;

    gs = g_string_sized_new(80);
    
    if (TMPQ.callsign && TMPQ.ucallsign){
        if (strlen(remark)>10){
            gchar *c;
            remark[17]='\0';
            c = g_strdup_printf("%s %s", remark, TMPQ.callsign);
            g_string_sprintfa(gs, "%-24s", c);
            g_free(c);
        }else{
            g_string_sprintfa(gs, "%-10s %-13s", remark, TMPQ.callsign); 
        }
    }else{
        remark[24]='\0';
        g_string_sprintfa(gs, "%-24s",remark);
    }

            
    g_string_sprintfa(gs, "%5s%4s %5s%4s",
        TMPQ.rsts?TMPQ.rsts:"---", 
        TMPQ.qsonrs, 
        TMPQ.rstr?TMPQ.rstr:"---", 
        TMPQ.qsonrr?TMPQ.qsonrr:"---");

    if (TMPQ.locator && TMPQ.ulocator){
        g_string_sprintfa(gs, "    %-8s %7d %3d", TMPQ.locator, (int)TMPQ.qrb, TMPQ.qtf);
    }

    fifo_addf(aband->unfi, gs->str);
    g_string_free(gs, 1);

    add_error(aband, remark);/* before clear_tmpqsos! */
    
    clear_tmpqsos(aband);
    clear_inputline(aband->il);
    get_cw_qs(aband->il->cdata); /* clears */
    get_band_qs(aband, aband->il->cdata);
    redraw_later();
    

}

    
void menu_unfinished(union cba_t cba){
    static char remark[40];
    int max;

    if (TMPQ.callsign && TMPQ.ucallsign)
        max=1+17;
    else
        max=1+24;
    
    if (!ctest || !aband) return;
    
    strcpy(remark, "");

    input_field(NULL, VTEXT(T_UNFI_QSO), VTEXT(T_N_REMARK), 
               VTEXT(T_OK), VTEXT(T_CANCEL), NULL, 
               NULL, max, remark, 0, 0, NULL,
               (void (*)(void *, char *)) do_unfinished, NULL);
    
}


