/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

void g_ptr_array_free_all(GPtrArray *array){
    int i;
    gpointer item;
         
    for (i=array->len-1; i>=0; i--){                   
        item=g_ptr_array_index(array, i);
        g_free(item);
    }
    g_ptr_array_free(array, TRUE);
}


void g_ptr_array_free_items(GPtrArray *array){
    int i;
    gpointer item;
            
    for (i=array->len-1; i>=0; i--){                   
        item=g_ptr_array_index(array, i);
        g_free(item);
        g_ptr_array_remove_index(array, i);
    }
}

void g_ptr_array_qsort (GPtrArray *array, 
        int (*compar)(const void *, const void *)){
    
    qsort( (void *)array->pdata, array->len, sizeof(gpointer), compar);
}
