/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "header.h"


/* returns zero if matching */
int regcmp(char *string, char *regex){
    regex_t preg;
    int ret;
    
    ret = regcomp(&preg, regex, REG_EXTENDED | REG_NOSUB);
    if (ret) raise(SIGSEGV);
    
    ret = regexec(&preg, string, 0, 0, 0);
    regfree(&preg);
    
    return ret;
}

int regcmpi(char *string, char *regex){
    regex_t preg;
    int ret;
    
    ret = regcomp(&preg, regex, REG_EXTENDED | REG_NOSUB | REG_ICASE);
    if (ret) raise(SIGSEGV);
    
    ret = regexec(&preg, string, 0, 0, 0);
    regfree(&preg);
    
    return ret;
}

/* returns zero if matching */
int regmatch(char *string, char *regex, ...){
    regex_t preg;
    regmatch_t match[MAX_MATCHES];
    va_list ap;
    int ret,i;
    char **ppc;
    
    ret = regcomp(&preg, regex, REG_EXTENDED);
    if (ret) raise(SIGSEGV);
    
    ret = regexec(&preg, string, MAX_MATCHES, match, 0);
    regfree(&preg);
    if (ret) return ret;

/*    dbg("regmatch '%s'~=/%s/; \n",string,regex);*/

    va_start(ap,regex);
    for (i=0; i<MAX_MATCHES; i++){
        ppc=va_arg(ap, char **);
       /* dbg("i=%i  ppc=%p \n",i,ppc);*/
        if (ppc==NULL) break;
            
        if (match[i].rm_eo!=-1 && 
            match[i].rm_eo!=0) { 
       
            *ppc=mem_alloc(match[i].rm_eo - match[i].rm_so + 1);
            memcpy(*ppc, string+match[i].rm_so, match[i].rm_eo - match[i].rm_so );
            (*ppc)[match[i].rm_eo - match[i].rm_so ] = '\0';
 /*           dbg("allocated %p '%s'\n",*ppc,*ppc);*/
        }else{
            *ppc=NULL;
        }
        
    }
    va_end(ap);
    
            
    
    
    return ret;
}

