# arch-tag: tla buildpackage: calls to tla package
# Copyright (C) 2003 John Goerzen
#               2008 Hubert Chathi
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

import re
import extcmd

def gettreeversion():
    return extcmd.run("tla tree-version")[0].strip()

def getarchive(version = None):
    if version == None:
        version = gettreeversion()
    return re.search('^([^/]+)/[^/]+$', version).group(1)

def isvalidversion(ver):
    try:
        return len(extcmd.run("tla revisions %s" % ver))
    except:
        return 0

def archive_setup(ver):
    extcmd.qrun('tla archive-setup "%s"' % ver)

def condsetup(version):
    """Will create version in archive if it's not there.

    Returns true if it created it, false otherwise."""
    if not isvalidversion(version):
        print "Setting up version %s" % version
        archive_setup(version)
        return 1
    else:
        return 0

def munge_category_name(name):
    """Convert the name into a valid category name.

    A category name can only contain letters, numbers and dashes, must begin
    with a letter, cannot have two dashes in a row, and connot end with a dash.

    This function takes a name and returns a name that is a valid category
    name."""

    # convert all non-letters, numbers, and dashes into a dash
    name = re.sub(r'[^a-zA-Z0-9-]',r'-',name)

    # convert multiple dashes in a row to a single dash
    name = re.sub(r'-+',r'-',name)

    # remove dashes from the beginning or end
    name = name.strip('-')

    # if it doesn't begin with a letter (i.e. with a number), start it with an
    # 'a'
    if not name[0].isalpha():
        name = 'a' + name

    return name
