proc Frame {} {
	global font USERNAME PASSWORD C_HOST C_GROUP Version keeppw DOWNLOAD
	wm title . "Tk Samba $Version"
#	wm geometry . "640x500"
	wm sizefrom . program

	frame .status		    -relief sunken -bd 2
	label .status.lbl -text ""  -relief sunken -bd 1 -font $font -anchor w
	label .status.foo -width 8  -relief sunken -bd 1 -font $font

	pack .status -side bottom -fill x -pady 2 -expand 0
	pack .status.foo -side right -padx 2
	pack .status.lbl -side right -padx 2 -fill both -expand 1 
#	place .status.foo -height 50 -width 50 -relx 1 -x -50
#	place .status.lbl -relheight 1 -relwidth 1 -width -50 -x 0





	frame .t     -relief sunken -bd 2
	frame .tl    -relief sunken -bd 2
	frame .tr    -relief sunken -bd 2	; # hosts
	frame .trt   -relief sunken -bd 2
	frame .trm   -relief sunken -bd 2
	frame .trb   -relief sunken -bd 2
	frame .trml  -relief sunken -bd 2	; # share
	frame .trmr  -relief sunken -bd 2	; # groups
	frame .trbl  				; # remote
	frame .trbr  				; # local
	frame .trblt

	#labels
	label     .tlt   -text "Hosts" -font $font
	label     .trmlt -text "Shares" -font $font
	label     .trmrt -text "Groups" -font $font
	label     .trbltl -text "Remote: " -font $font -anchor w
	label	  .trbltr -text "" -font $font -anchor e
	label     .trbrt -text "Local" -font $font
	
	frame     .trta
	frame     .trtb
	frame     .trtc
	frame     .trtd
	label	  .trt7 -text "Download to:" -font $font
	entry     .trt8 -textvariable DOWNLOAD -font $font

	label     .trt9 -text User:            -font $font
	entry     .trtA -textvariable USERNAME -font $font
       	bind .trtA <Return> { viewhost $UC_HOST $UC_GROUP 1 }
	label     .trt1 -text Password:        -font $font
	entry     .trt2 -textvariable PASSWORD -font $font -show "*"
       	bind .trt2 <Return> { viewhost $UC_HOST $UC_GROUP 1 }
	checkbutton .trt2a -variable keeppw -offvalue "no" -onvalue "yes" -text "Keep"  -font $font -anchor w
	label     .trt3 -text HOST:            -font $font
	global C_HOST C_GROUP UC_HOST UC_GROUP
	set UC_HOST  $C_HOST
	set UC_GROUP $C_GROUP
	entry     .trt4 -textvariable UC_HOST          -font $font -relief sunken -width 9 
       	bind .trt4 <Return> { viewhost $UC_HOST $UC_GROUP 1 }
	label     .trt5 -text GROUP:           -font $font
	entry     .trt6 -textvariable UC_GROUP         -font $font -relief sunken -width 9 
       	bind .trt6 <Return> { viewhost $UC_HOST $UC_GROUP 1 }

	frame     .tlb   -relief sunken -bd 2
	frame     .trmlb -relief sunken -bd 2
	frame     .trmrb -relief sunken -bd 2
	frame     .trblb -relief sunken -bd 2
	frame     .trbrb -relief sunken -bd 2

	#scrollbars
	scrollbar .tls   -orient vertical -command {.hosts   yview} -highlightthickness 0 -takefocus 1
	scrollbar .trmls -orient vertical -command {.shares  yview} -highlightthickness 0 -takefocus 1
	scrollbar .trmrs -orient vertical -command {.groups  yview} -highlightthickness 0 -takefocus 1
	scrollbar .trbls -orient vertical -command {.remote  yview} -highlightthickness 0 -takefocus 1
	scrollbar .trbrs -orient vertical -command {.local   yview} -highlightthickness 0 -takefocus 1

	text .hosts  -relief sunken -bd 2 -font $font -width 20 -height 30 -cursor arrow -wrap none \
			-yscrollcommand {.tls set} -foreground blue
	text .groups -relief sunken -bd 2 -font $font -width 10 -height 10 -cursor arrow -wrap none \
			-yscrollcommand {.trmrs set}
	text .shares -relief sunken -bd 2 -font $font -width 10 -height 10 -cursor arrow -wrap none \
			-yscrollcommand {.trmls set}
	text .remote -relief sunken -bd 2 -font $font -width 10 -height 10 -cursor arrow -wrap none \
			-yscrollcommand {.trbls set}
	text .local  -relief sunken -bd 2 -font $font -width 10 -height 10 -cursor arrow -wrap none \
			-yscrollcommand {.trbrs set}

	pack .tls   -in .tlb   -side right -fill y
	pack .trmls -in .trmlb -side right -fill y
	pack .trmrs -in .trmrb -side right -fill y
	pack .trbls -in .trblb -side right -fill y
	pack .trbrs -in .trbrb -side right -fill y

	pack .hosts  -in .tlb   -side left -expand 1 -fill both
	pack .shares -in .trmlb -side left -expand 1 -fill both
	pack .groups -in .trmrb -side left -expand 1 -fill both
	pack .remote -in .trblb -side left -expand 1 -fill both
	pack .local  -in .trbrb -side left -expand 1 -fill both

	pack .trt3 -in .trta -side left -anchor s -expand 0
	pack .trt4 -in .trta -side left -anchor w -expand 1 -fill x
	pack .trt5 -in .trta -side left -anchor s -expand 0
	pack .trt6 -in .trta -side left -anchor w -expand 1 -fill x
	pack .trt9 -in .trtd -side left -anchor e -expand 0
	pack .trtA -in .trtd -side left -anchor w -expand 0
	pack .trt1 -in .trtb -side left -anchor e -expand 0
	pack .trt2 -in .trtb -side left -anchor w -expand 0
	pack .trt2a -in .trtb -side left -anchor w -expand 0
	pack .trt7 -in .trtc -side left -anchor e -expand 0
	pack .trt8 -in .trtc -side left -anchor w -expand 1 -fill x

	pack .trta .trtd .trtb .trtc -side top -in .trt -fill x -expand 1


	pack .tlt   -in .tl   -fill x
	pack .trmlt -in .trml -fill x
	pack .trmrt -in .trmr -fill x
	pack .trbltl -in .trblt -side left
	pack .trbltr -in .trblt -fill none -expand 0
	pack .trblt -in .trbl -fill x
	pack .trbrt -in .trbr -fill x

	pack .tlb   -in .tl   -side bottom -expand 1 -fill both
	pack .trmlb -in .trml -side left   -expand 1 -fill both
	pack .trmrb -in .trmr -side left   -expand 1 -fill both
	pack .trblb -in .trbl -side left   -expand 1 -fill both
	pack .trbrb -in .trbr -side left   -expand 1 -fill both

	pack .trml -in .trm     -side left -fill both -expand 1
	pack .trmr -in .trm     -side left -fill both -expand 1
	pack .trbl -in .trb     -side left -fill both -expand 1
	#pack .trbr -in .trb     -side left -fill both -expand 1
	pack .trt  -in .tr      -side top -fill both
	pack .trm  -in .tr      -side top -fill both
	pack .trb  -in .tr      -side top -fill both -expand 1
	pack .tl   -in .t       -side left    -fill y
	pack .tr   -in .t       -side left    -fill both -expand 1
	pack .t                 -fill both -expand 1

	.hosts insert end " "
	.groups insert end " "
	.shares insert end " "
	.remote insert end " "
	.hosts configure -state disabled
	.groups configure -state disabled
	.shares configure -state disabled
	.remote configure -state disabled
	sleep .01
#	set g [wm geometry .]
#	regexp (\[^+\]*) $g tmp g
#	puts $g
#	wm geometry . $g
	}

	
set Busy_Counter 0
set Dl_Counter 0
proc SetStatus { new } {
	global Busy_Counter Dl_Counter
	if { $new == "+BUSY" } { set Busy_Counter [expr {$Busy_Counter + 1}]}
	if { $new == "-BUSY" } { set Busy_Counter [expr {$Busy_Counter - 1}]}
	if { $new == "+DL" } { set Dl_Counter [expr {$Dl_Counter + 1}]}
	if { $new == "-DL" } { set Dl_Counter [expr {$Dl_Counter - 1}]}
	
	if { $Busy_Counter != 0 } {
		if { $Dl_Counter != 0 } {
			.status.foo configure -text "${Dl_Counter}DL/BUSY"
      			} {
	 		.status.foo configure -text "BUSY"
      			}
		} {
		if { $Dl_Counter != 0 } {
			.status.foo configure -text "${Dl_Counter}DL"
			} {
			.status.foo configure -text ""
			}
	}
   
}

   
