/****************************************************************************
    Copyright (C) 1987-2007 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#ifndef __module_h
#define __module_h

struct editstate;

void modint_reset(EditState *es,GCElement *g);
GModuleDef *env_findModule(const char *n);
GModuleDef *env_findAdd(const char *name,int isMain);
void  env_addenv(const char *n,GModuleDef *e);
void env_rename(const char *old,const char *new);
GModuleDef *env_defineModule(const char *name,int);
int env_delete(struct editstate*,const char*);
GModuleDef *env_removeModule(const char *);
void env_insertModule(GModuleDef *);
void env_copy(EditState *es,const char *src,const char *dst);

void env_purge(struct editstate *es);

GCElement *env_blockdescript(GCElement *g);
void env_clear(GModuleDef *e);

GModuleDef *new_GModuleDef(const char *name,int Prot);

void env_checkname(GCElement *g);
void env_markenv(GModuleDef *env);

int block_getPortDir(GCElement *g,GWire *w);
int block_getPad(GCElement *g,GWire *w);
void block_scalewirelist(GWire *w,GCElement *g,int y);
void block_movewirelist(GWire *w,int x,int y);
void block_name(GCElement *g,struct editstate *es);
void block_namefunction(GCElement *g,struct editstate *es);
int block_in(int x,int y,GCElement *g);
int block_setPortName(GCElement *g,GWire *w,struct editstate *es);
void block_getwirexy(GWire *w,int d,int *x,int *y,int *p);
void block_free(GCElement *g);
void block_explode(GCElement *g);
int block_connect(struct celemnt *g,struct wirenode *n,int Dir);
GWire *block_addwire(GWire *w,GWire *wl);
void block_changefunction(struct editstate *es,GCElement *g);
void block_changename(struct editstate *es,GCElement *g);
void block_deletewire(GWire *w);
void block_newout(struct editstate *es);
void block_newin(struct editstate *es);
void block_newtri(struct editstate *es);
void block_changedir(GWireNode *n,struct editstate *es);
int block_attach(GModuleDef *env,GCElement *g,GWire *w1,GWire *w2,
	     int x,int y,const char *name,int Dir);
int block_edgehit(GCElement *g,int x,int y);
GCElement *block_replicate(GCElement *g,GModuleDef *M,int x,int y);
void block_canonicalizewire(GCElement *g,GWire *w);
int block_insidep(const char *n,struct editstate *es);
char *block_reportname(GCElement *g);

void modint_setInterface(GModuleDef *M,GCElement *g);
void modint_arrange(struct editstate *es);
void modint_update(struct editstate *es);
void modint_edit(struct editstate **es,GModuleDef *M);
GCElement *modint_find(const char*);
void modint_deleteInterface(GModuleDef *);
void modint_renameInterface(GModuleDef *);

GModuleDef *new_GModuleDef(const char *name,int isTop);
void delete_GModuleDef(GModuleDef *M);

GNet *GModuleDef_findNet(GModuleDef *M,const char *name);
GCElement *GModuleDef_findGate(GModuleDef *M,const char *name);
void GModuleDef_getBBX(GModuleDef *M,int *minX,int *maxX,int *minY,int *maxY);
void GModuleDef_copyInto(GModuleDef *D,GModuleDef *S,int dx,int dy,int selOnly,int selDst);



#endif
