/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KURS_H
#define KURS_H

#include "lektion.h"
#include "LKrit.H"
#include "LEntry.H"
#include "LessonController.H"
#include <vector>
#include <wx/wx.h>

/* class Kurs
 * Diese Klasse reprsentiert einen Maschinenschreibkurs
 */
class Kurs : public LessonController {
public:
  Kurs (wxWindow* parent);
  ~Kurs ();

  //errors in constructor, e.g. abort a dialog or wizard
  class DialogAborted {};

private:
  wxWindow* parent;
  wxString name;
  int kn;
  wxString key;

  std::vector<LKrit> kriterien;
  std::vector<LEntry>* results;

  unsigned int akt_krit;

  bool ladeKursKriterien ();

  bool KursBeginnen ();
  bool KursLaden ();
  bool KursEinleitung ();
  bool KursEnde ();
  bool LektionSpeichern (const LEntry& ldata);

  void NaechsteLektion (const LEntry& ldata);
  wxString GetLimits ();

  void onLessonStart(wxCommandEvent& WXUNUSED(e));
  void onLessonAbort(wxCommandEvent& WXUNUSED(e));
  void onLessonFinish(wxCommandEvent& WXUNUSED(e));

  DECLARE_EVENT_TABLE()
};

#endif
