/*
 *	TICKR - GTK-based Feed Reader - Copyright (C) Emmanuel Thomas-Maurin 2009-2011
 *	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "news.h"

#ifdef G_OS_WIN32
extern FILE	*stdout_fp, *stderr_fp;
#endif

#if USE_GUI
# ifndef G_OS_WIN32
void online_help()
{
	char		tmp1[FILE_NAME_MAXLEN + 1];
	char		*help_url = APP_SUPPORT_WEBSITE;
	char		*argv[3];
	GPid		pid;
	GError		*error = NULL;


	if (get_params()->open_link_cmd[0] == '\0') {
		/* TODO: should look for default browser */
		warning("Can't launch Browser: no command is defined.\n"
			"Please set the 'Open in Browser' option in the Preferences window.",
			"", "", "", FALSE);
		return;
	}
	fprintf(STD_OUT, "Spawning: %s %s\n", get_params()->open_link_cmd, help_url);
	str_n_cpy(tmp1, get_params()->open_link_cmd, FILE_NAME_MAXLEN);
	argv[0] = tmp1;
	argv[1] = help_url;
	argv[2] = NULL;
	if (!g_spawn_async(NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &pid, &error)) {
		warning(APP_NAME": Can't create process ", argv[0], " - ", error->message, FALSE);
		info_win("Warning", "Please check the 'Open in Browser' option in the Preferences window.",
			INFO_WARNING, FALSE);
	} else
		g_spawn_close_pid(pid);
}
# else
void online_help()
{
	char		*browser_cmd_p, browser_cmd[512], tmp[1024];
	unsigned int	i, count, start = 0, end = 0;
	char		link[] = APP_SUPPORT_WEBSITE;
	char		*argv[3];
	GPid		pid;
	GError		*error = NULL;

	if ((browser_cmd_p = (char *)get_default_browser_from_win32registry()) != NULL) {
		/* find 1st str in browser_cmd */
		str_n_cpy(tmp, browser_cmd_p, 511);
		for (i = 0, count = 0; i < strlen(tmp); i++) {
			if (tmp[i] == '"') {
				count++;
				if (count == 1)
					start = i + 1;
				else if (count == 2)
					end = i - 1;
			}
		}
		str_n_cpy(browser_cmd, tmp + start, MIN((end - start + 1), 511));
		/* launch browser */
		fprintf(STD_OUT, "Spawning: %s %s\n", browser_cmd, link);
		argv[0] = browser_cmd;
		argv[1] = link;
		argv[2] = NULL;
		if (!g_spawn_async(NULL, argv, NULL, G_SPAWN_SEARCH_PATH,
				NULL, NULL, &pid, &error))
			warning(APP_NAME": Can't create process ", argv[0],
				" - ", error->message, FALSE);
		else
			g_spawn_close_pid(pid);
	}
}
# endif
#endif

/* message max len = 511 */
static const char *message_str(const char *str1, const char *str2, const char *str3, const char *str4)
{
	static char	m_str[127 + (128 * 3) + 1];

	m_str[0] = '\0';
	if (str1[0] != '\0')
		str_n_cat(m_str, str1, 127);
	if (str2[0] != '\0') {
		str_n_cat(m_str, " ", 1);
		str_n_cat(m_str, str2, 127);
	}
	if (str3[0] != '\0') {
		str_n_cat(m_str, " ", 1);
		str_n_cat(m_str, str3, 127);
	}
	if (str4[0] != '\0') {
		str_n_cat(m_str, " ", 1);
		str_n_cat(m_str, str4, 127);
	}
	return (const char *)m_str;
}

/*
 * this func's prototype is in libetm / error.h
 * this func is not defined in libetm but in app and it handles errors
 * from libetm and app
 */
int big_error(int error_code, const char *str1, const char *str2, const char *str3, const char *str4)
{
	char	error_str[32 + 512 + 128 + 32 + 1];

	get_ticker_env()->suspend_rq = TRUE;

	str_n_cpy(error_str, "CRITICAL ERROR: ", 16);
	if (error_code >= LIBETM_OK && error_code <= LIBETM_LASTERRORCODE)
		str_n_cat(error_str, "Libetm: ", 16);
	else
		str_n_cat(error_str, APP_NAME": ", 16);
	str_n_cat(error_str, message_str(str1, str2, str3, str4), 512);
	if (error_code >= LIBETM_OK && error_code <= LIBETM_LASTERRORCODE) {
		str_n_cat(error_str, ": ", 2);
		str_n_cat(error_str, get_lib_error_str(error_code), 126);
	}
	str_n_cat(error_str, " - Will quit now", 32);

	if (STD_ERR != NULL) {
		fprintf(STD_ERR, "%s\n", error_str);
		fflush(NULL);
	}
#if USE_GUI
	info_win(APP_NAME" - Error", error_str, INFO_ERROR, FALSE);
#endif
	if (get_resource()->fp != NULL)
		fclose(get_resource()->fp);
	free2(get_ticker_env());
	free2(get_resource());
	free2(get_params());
	exit(error_code);
}

/* wait for INFO_WIN_WAIT_TIMEOUT ms if true */
void warning(const char *str1, const char *str2, const char *str3, const char *str4, gboolean wait)
{
	char	warning_str[512];

	warning_str[0] = '\0';
	str_n_cat(warning_str, message_str(str1, str2, str3, str4), 511);
	fprintf(STD_ERR, "%s\n", warning_str);
#if USE_GUI
	if (!wait)
		info_win(APP_NAME" - Warning", warning_str, INFO_WARNING, FALSE);
	else
		info_win_wait(warning_str, INFO_WIN_WAIT_TIMEOUT);
#endif
}

void dump_font_list()
{
#define NFAMMAX		1024
#define NFACEMAX	16

	PangoFontFamily		**font_fam;
	PangoFontFamily		*font_fam2[NFAMMAX];
	PangoFontFace		**font_face;
	PangoFontFace		*font_face2[NFACEMAX];
	PangoFontDescription	*font_desc;
	char			*font[NFAMMAX * NFACEMAX + 1], *tmp;
	int			n_fam, n_face, i, j, k, overflow, min;

	fprintf(STD_OUT, "List of available fonts on this system:\n");
	font_fam = font_fam2;
	font_face = font_face2;
	overflow = FALSE;
	k = 0;
	pango_font_map_list_families(pango_cairo_font_map_get_default(), &font_fam, &n_fam);
	if (n_fam >= NFAMMAX)
		overflow = TRUE;
	for (i = 0; i < n_fam && i < NFAMMAX; i++) {
		pango_font_family_list_faces(font_fam[i], &font_face, &n_face);
		if (n_face >= NFACEMAX)
			overflow = TRUE;
		for (j = 0; j < n_face && j < NFACEMAX; j++) {
			font_desc = pango_font_face_describe(font_face[j]);
			font[k++] = pango_font_description_to_string(font_desc);
			pango_font_description_free(font_desc);
		}
	}
	font[k] = NULL;
/*
 * not sure if we must g_free() sth?
 */
	/*
	 * sort array (selection sort)
	 */
	for (i = 0; i < k; i++) {
		min = i;
		for (j = i  + 1; j < k; j++) {
			if (strcmp(font[min], font[j]) > 0)
				min = j;
		}
		tmp = font[i];
		font[i] = font[min];
		font[min] = tmp;
	}
	for (i = 0; i < k; i++) {
		if (font[i] != NULL)
			fprintf(STD_OUT, "%s\n", font[i]);
		else
			break;
	}
	if (overflow)
		fprintf(STD_ERR,
			"In function dump_font_list(): need to allocate more space for array\n"
			"Can't dump full list (more than %d available fonts)\n", k);
	else
		fprintf(STD_OUT, "(%d available fonts)\n", k);
}
