% MuLTeX (Multi-Lingual TeX) change file by SAKURAI Takafumi
% The diff from tex.ch covered by the copyright:
%   Copyright (C) 1993-1998 Takafumi Sakurai
%
% 0    (93 Sep) the beginning
% 0.3  (94 Feb) the first public release
% 0.4  (94 Jul) to version 3.1415 (web2c 6.1)
% 0.5  (96 May) to version 3.14159 (web2c 6.1 / kp 2.6)
% 0.6  (97 Mar) to version 3.14159 (web2c 7.0)
% 0.7  (98 May) to version 3.14159 (web2c 7.2)
% 0.8  (99 Aug) to version 3.14159 (web2c 7.3.1)
% 0.9  (03 Jan) to version 3.14159 (web2c 7.4.3)

% JTeX change file by Takafumi Sakurai
% The diff from tex.ch covered by the copyright:
%   Copyright (C) 1988-1998 Takafumi Sakurai
%
% 1.0  (88 Dec) japanese subfont autoload by Takafumi Sakurai
% 1.04 (89 Dec) by Takafumi Sakurai
% 1.05 (90 Feb) by Takafumi Sakurai
% 1.11 (90 May) delayed font by Takafumi Sakurai
% 1.2  (91 Feb) To version 3.0, some new features added
%	by Takafumi Sakurai
% 1.21 (91 Sep) bug fixes by Takafumi Sakurai
% 1.3  (92 Aug) To version 3.14 by Takafumi Sakurai
% 1.33 (93 Jun) more than 256 fonts by Takafumi Sakurai
% 1.4  (93 Jun) distiction of kanji and 8-bit char by Takafumi Sakurai
%
% JTeX was originaly written by Yaski Saito
% ported to UNIX by Takafumi Sakurai (inijtex.ch)
% inijtex.ch and ctex.ch are merged to cjtex.ch by Shigeyuki Takagi
% 0.96 (88 May) EUC/shift-jis code support and some new features added
%	by Takafumi Sakurai and Shouichi Matsui

% tex.ch for C compilation with web2c, derived from various other change files.
% By Tim Morgan, UC Irvine ICS Department, and many others.
%
% Be very careful when making changes to this file, as it is used to
% generate TeX, e-TeX, and pdf[ex]TeX, and most changes require similar
% changes to be made to the Omega sources.
%
% (05/28/86) ETM Started with TeX 2.0
% (06/03/87) ETM Brought up to TeX 2.2
% (09/26/87) ETM Brought up to TeX 2.3
% (10/01/87) ETM Brought up to TeX 2.5
% (12/21/87) ETM Brought up to TeX 2.7
% (01/14/88) ETM Brought up to TeX 2.9
% (02/20/88) PAM Revised format and module numbers
% (03/01/88) ETM Eliminated some unused variables and unnecesary tests
% (05/09/88) ETM Added yet another casting bug fix
% (06/21/88) ETM Brought up to TeX version 2.93
% (12/11/88) ETM Brought up to TeX version 2.94
% (01/12/89) PAM Brought up to TeX version 2.95
% (02/14/89) ETM Brought up to TeX version 2.96
% (03/10/89) ETM Brought up to TeX version 2.98
% (07/06/89) ETM Brought up to TeX version 2.991
% (11/30/89) KB  To version 2.992 (8-bit).
% (01/10/90) SR  To version 2.993.
% (03/27/90) KY  To version 3.0.
% (more recent changes in ChangeLog)
%
% The TeX program is copyright (C) 1982 by D. E. Knuth.
% TeX is a trademark of the American Mathematical Society.
%
% Includes MLTEX.CH (Version 2.2) in text format, as of Dec 17, 1995.
% MLTeX is copyright (C) 1990-92 by Michael J. Ferguson; all rights reserved.
% MLTeX Version 2.2 is copyright (C) 1995 by B. Raichle; all rights reserved.
%
% The MLTeX changes are copyrighted so that we have some chance to
% forbid unauthorized copies; we explicitly authorize copying of
% correct MLTeX implementations, and not of incorrect ones!
%
% (This means that you can use the MLTeX changes as free as you can
% use TeX and its algorithm.)
%
% Copying of this file is authorized only if either
% (1) you make absolutely no changes to your copy, including name, or
% (2) if you do make changes, you name it to something other than
%     "mltex.ch", "char_sub.ch", or "charsub.ch".
%
% The module numbers in this change file refer to TEX.WEB 3.14159 as
% of March, 1995 (published as Donald E. Knuth, TeX: The Program,
% Volume B of Computers & Typesetting).

@x [0.0] l.83 - WEAVE: print changes only.
  \def\?##1]{\hbox to 1in{\hfil##1.\ }}
  }
@y 83
  \def\?##1]{\hbox{Changes to \hbox to 1em{\hfil##1}.\ }}
  }
\let\maybe=\iffalse
@z

@x [1.2] l.185 - MLTeX: add comment about banner line change
November 1984].
@y
November 1984].

ML\TeX{} will add new primitives changing the behaviour of \TeX.  The
|banner| string has to be changed.  We do not change the |banner|
string, but will output an additional line to make clear that this is
a modified \TeX{} version.

@z

@x [1.2] l.187 - MuLTeX: banner line
@d banner=='This is TeX, Version 3.141592' {printed when \TeX\ starts}
@y
@d TeX_banner_k=='This is MuLTeX, Version 1.0, based on TeXk Version 3.141592'
						{printed when \TeX\ starts}
@d TeX_banner=='This is MuLTeX, Version 1.0, based on TeX Version 3.141592'
						{printed when \TeX\ starts}
@#
@d banner==TeX_banner
@d banner_k==TeX_banner_k
@z

@x [1.4] l.233 - program header
Actually the heading shown here is not quite normal: The |program| line
does not mention any |output| file, because \ph\ would ask the \TeX\ user
to specify a file name if |output| were specified here.
@^system dependencies@>
@y
@z

@x [1.4] l.243 - labels in outer block not needed
program TEX; {all file names are defined dynamically}
label @<Labels in the outer block@>@/
@y
program TEX; {all file names are defined dynamically}
@z

@x MuLTeX: [1.4]
@t\4@>@<Basic printing procedures@>@/
@t\4@>@<Error handling procedures@>@/
@y
@t\4@>@<Basic printing procedures@>@/
@t\4@>@<Error handling procedures@>@/
@t\4@>@<Utility functions and procedures for Japanese@>@/
@z

@x [1.6] l.267 - labels in outer block not needed
@ Three labels must be declared in the main program, so we give them
symbolic names.

@d start_of_TEX=1 {go here when \TeX's variables are initialized}
@d end_of_TEX=9998 {go here to close files and terminate gracefully}
@d final_end=9999 {this label marks the ending of the program}

@<Labels in the out...@>=
start_of_TEX@t\hskip-2pt@>, end_of_TEX@t\hskip-2pt@>,@,final_end;
  {key control points}
@y
@ For Web2c, labels are not declared in the main program, but
we still have to declare the symbolic names.

@d start_of_TEX=1 {go here when \TeX's variables are initialized}
@d final_end=9999 {this label marks the ending of the program}
@z

% Here we change these WEB symbols, which are used much as #ifdef's
% are in C, into something which will get translated into actual #ifdef's.
@x [1.7] l.292 - debug..gubed, stat..tats
@d debug==@{ {change this to `$\\{debug}\equiv\null$' when debugging}
@d gubed==@t@>@} {change this to `$\\{gubed}\equiv\null$' when debugging}
@y
@d debug==ifdef('TEXMF_DEBUG')
@d gubed==endif('TEXMF_DEBUG')
@z
@x [1.7] l.297 - debug..gubed, stat..tats
@d stat==@{ {change this to `$\\{stat}\equiv\null$' when gathering
  usage statistics}
@d tats==@t@>@} {change this to `$\\{tats}\equiv\null$' when gathering
  usage statistics}
@y
@d stat==ifdef('STAT')
@d tats==endif('STAT')
@z

@x [1.8] Somewhat different for `init...tini'..  310 m.8
the codewords `$|init|\ldots|tini|$'.

@d init== {change this to `$\\{init}\equiv\.{@@\{}$' in the production version}
@d tini== {change this to `$\\{tini}\equiv\.{@@\}}$' in the production version}
@y 314
the codewords `$|init|\ldots|tini|$' for declarations and by the codewords
`$|Init|\ldots|Tini|$' for executable code.  This distinction is helpful for
implementations where a run-time switch differentiates between the two
versions of the program.

@d init==ifdef('INITEX')
@d tini==endif('INITEX')
@d Init==init if ini_version then begin
@d Tini==end;@+tini
@f Init==begin
@f Tini==end
@z

@x [1.8] l.319 - init...tini is dynamic
@!init @<Initialize table entries (done by \.{INITEX} only)@>@;@+tini
@y  318
@!Init @<Initialize table entries (done by \.{INITEX} only)@>@;@+Tini
@z

@x [1.11] l.375 - Compile-time constants: most removed for dynamic allocation.
@<Constants...@>=
@!mem_max=30000; {greatest index in \TeX's internal |mem| array;
  must be strictly less than |max_halfword|;
  must be equal to |mem_top| in \.{INITEX}, otherwise |>=mem_top|}
@!mem_min=0; {smallest index in \TeX's internal |mem| array;
  must be |min_halfword| or more;
  must be equal to |mem_bot| in \.{INITEX}, otherwise |<=mem_bot|}
@!buf_size=500; {maximum number of characters simultaneously present in
  current lines of open files and in control sequences between
  \.{\\csname} and \.{\\endcsname}; must not exceed |max_halfword|}
@!error_line=72; {width of context lines on terminal error messages}
@!half_error_line=42; {width of first lines of contexts in terminal
  error messages; should be between 30 and |error_line-15|}
@!max_print_line=79; {width of longest text lines output; should be at least 60}
@!stack_size=200; {maximum number of simultaneous input sources}
@!max_in_open=6; {maximum number of input files and error insertions that
  can be going on simultaneously}
@!font_max=75; {maximum internal font number; must not exceed |max_quarterword|
  and must be at most |font_base+256|}
@!font_mem_size=20000; {number of words of |font_info| for all fonts}
@!param_size=60; {maximum number of simultaneous macro parameters}
@!nest_size=40; {maximum number of semantic levels simultaneously active}
@!max_strings=3000; {maximum number of strings; must not exceed |max_halfword|}
@!string_vacancies=8000; {the minimum number of characters that should be
  available for the user's control sequences and font names,
  after \TeX's own error messages are stored}
@!pool_size=32000; {maximum number of characters in strings, including all
  error messages and help texts, and the names of all fonts and
  control sequences; must exceed |string_vacancies| by the total
  length of \TeX's own strings, which is currently about 23000}
@!save_size=600; {space for saving values outside of current group; must be
  at most |max_halfword|}
@!trie_size=8000; {space for hyphenation patterns; should be larger for
  \.{INITEX} than it is in production versions of \TeX}
@!trie_op_size=500; {space for ``opcodes'' in the hyphenation patterns}
@!dvi_buf_size=800; {size of the output buffer; must be a multiple of 8}
@!file_name_size=40; {file names shouldn't be longer than this}
@!pool_name='TeXformats:TEX.POOL                     ';
  {string of length |file_name_size|; tells where the string pool appears}
@y
@d file_name_size == maxint
@d ssup_error_line = 255
@d ssup_max_strings == 262143
{Larger values than 65536 cause the arrays consume much more memory.}
@d ssup_trie_opcode == 65535
@d ssup_trie_size == 262143

@d ssup_hyph_size == 65535 {Changing this requires changing (un)dumping!}
@d iinf_hyphen_size == 610 {Must be not less than |hyph_prime|!}

@d max_font_max=2000 {maximum number of internal fonts; this can be
                      increased, but |hash_size+max_font_max|
                      should not exceed 29000.}
@d font_base=0 {smallest internal font number; must be
                |>= min_quarterword|; do not change this without
                modifying the dynamic definition of the font arrays.}


@<Constants...@>=
@!hash_offset=514; {smallest index in hash array, i.e., |hash_base| }
  {Use |hash_offset=0| for compilers which cannot decrement pointers.}
@!trie_op_size=35111; {space for ``opcodes'' in the hyphenation patterns;
  best if relatively prime to 313, 361, and 1009.}
@!neg_trie_op_size=-35111; {for lower |trie_op_hash| array bound;
  must be equal to |-trie_op_size|.}
@!min_trie_op=0; {first possible trie op code for any language}
@!max_trie_op=ssup_trie_opcode; {largest possible trie opcode for any language}
@!pool_name=TEXMF_POOL_NAME; {this is configurable, for the sake of ML-\TeX}
  {string of length |file_name_size|; tells where the string pool appears}
@!engine_name=TEXMF_ENGINE_NAME; {the name of this engine}
@#
@!inf_mem_bot = 0;
@!sup_mem_bot = 1;

@!inf_main_memory = 2999;
@!sup_main_memory = 32000000;

@!inf_trie_size = 8000;
@!sup_trie_size = ssup_trie_size;

@!inf_max_strings = 3000;
@!sup_max_strings = ssup_max_strings;
@!inf_strings_free = 100;
@!sup_strings_free = sup_max_strings;

@!inf_buf_size = 500;
@!sup_buf_size = 300000;

@!inf_str_buf_size = 1000;  {MuLTeX}
@!sup_str_buf_size = 60000; {MuLTeX}

@!inf_nest_size = 40;
@!sup_nest_size = 4000;

@!inf_max_in_open = 6;
@!sup_max_in_open = 127;

@!inf_param_size = 60;
@!sup_param_size = 6000;

@!inf_save_size = 600;
@!sup_save_size = 40000;

@!inf_stack_size = 200;
@!sup_stack_size = 30000;

@!inf_dvi_buf_size = 800;
@!sup_dvi_buf_size = 65536;

@!inf_font_mem_size = 20000;
@!sup_font_mem_size = 2000000;

@!sup_font_max = max_font_max;
@!inf_font_max = 50; {could be smaller, but why?}

@!inf_pool_size = 32000;
@!sup_pool_size = 40000000;
@!inf_pool_free = 1000;
@!sup_pool_free = sup_pool_size;
@!inf_string_vacancies = 8000;
@!sup_string_vacancies = sup_pool_size - 23000;

@!sup_hash_extra = sup_max_strings;
@!inf_hash_extra = 0;

@!sup_hyph_size = ssup_hyph_size;
@!inf_hyph_size = iinf_hyphen_size; {Must be not less than |hyph_prime|!}
@z

@x [1.12] l.427 - Constants that are WEB numeric macros.
@d mem_bot=0 {smallest index in the |mem| array dumped by \.{INITEX};
  must not be less than |mem_min|}
@d mem_top==30000 {largest index in the |mem| array dumped by \.{INITEX};
  must be substantially larger than |mem_bot|
  and not greater than |mem_max|}
@d font_base=0 {smallest internal font number; must not be less
  than |min_quarterword|}
@d hash_size=2100 {maximum number of control sequences; it should be at most
  about |(mem_max-mem_min)/10|}
@d hash_prime=1777 {a prime number equal to about 85\pct! of |hash_size|}
@d hyph_size=307 {another prime; the number of \.{\\hyphenation} exceptions}
@y
@d hash_size=10000 {maximum number of control sequences; it should be at most
  about |(mem_max-mem_min)/10|}
@d hash_prime=8501 {a prime number equal to about 85\pct! of |hash_size|}
@d hyph_prime=607 {another prime for hashing \.{\\hyphenation} exceptions;
                if you change this, you should also change |iinf_hyphen_size|.}
@z

@x [1.16] l.498 - Use C macros for `incr' and `decr'.
@d incr(#) == #:=#+1 {increase a variable by unity}
@d decr(#) == #:=#-1 {decrease a variable by unity}
@y
@z

@x [1.18] MuLTeX: Internal representation of multi-lingual char
@ Characters of text that have been converted to \TeX's internal form
are said to be of type |ASCII_code|, which is a subrange of the integers.

@<Types...@>=
@!ASCII_code=0..255; {eight-bit numbers}
@y
@ Characters of text that have been converted to \TeX's internal form
are said to be of type |ASCII_code|, which is a subrange of the integers.

Multi-lingual character set.

@d mc_min=@"0
@d mc_ascii=@"0
@d mc_jpold=@"10
@d mc_jp=@"12
@d mc_max=@"5F

@d mletter_rep_flag==@"10000 {amount multiplied to mc}
@d non_mlchar==mletter_rep_flag
@d is_mlrep(#)==((#)>=mletter_rep_flag)
@d is_mlrep_ascii(#)==((#)<=255)
@d make_mlrep1(#)==(#)*mletter_rep_flag+make_mlr1_end
@d make_mlr1_end(#)==(mbc_out(#))
@d make_mlrep(#)==(#)*mletter_rep_flag+make_mlr_med
@d make_mlr_med(#)==(mbc_out(#))*@"100+make_mlr_end
@d make_mlr_end(#)==(mbc_out(#))
@d make_cn_mlrep(#)==(#)*mletter_rep_flag+make_cmlr_end
@d make_cmlr_end(#)==(#)
@d mlrep_mc(#)==((#) div mletter_rep_flag)
@d mlrep_char(#)==((#) mod mletter_rep_flag)
@d mlrep1_char(#)==((#) mod 256)
@d char_fst(#)==((#) div 256)
@d char_snd(#)==((#) mod 256)
@d mlrep_char_fst(#)==char_fst(mlrep_char(#))
@d mlrep_char_snd(#)==char_snd(#)

@d backward_onechar(#) == decr(#)

@<Types...@>=
@!ASCII_code=0..255; {eight-bit numbers}
@!ML_code=0..16777215; {2^8*2^16-1}
@z

% The text_char type is used as an array index into xord.  The
% default type `char' produces signed integers, which are bad array
% indices in C.
@x [2.19] l.565 - data type text_char is 8-bit ASCII_code
@d text_char == char {the data type of characters in text files}
@y
@d text_char == ASCII_code {the data type of characters in text files}
@z

% setup_char_set will do all the work.
@x [2.23] l.723 - Translate characters if desired, otherwise allow them all.
for i:=0 to @'37 do xchr[i]:=' ';
for i:=@'177 to @'377 do xchr[i]:=' ';
@y
@z

@x [2.24] l.733 - Don't reinitialize xord.
for i:=@'200 to @'377 do xord[xchr[i]]:=i;
for i:=0 to @'176 do xord[xchr[i]]:=i;
@y
{The idea for this dynamic translation comes from the patch by
 Libor Skarvada \.{<libor@@informatics.muni.cz>}
 and Petr Sojka \.{<sojka@@informatics.muni.cz>}. I didn't use any of the
 actual code, though, preferring a more general approach.}

{This sets the |xchr|, |xord|, and |is_printable| arrays.  We overwrite the
 |xchr| assignments from module 21, just in case someone wants to do strange
 character translations. See the function definition in \.{texmfmp.c} for
 more comments.}
setup_char_set;
@z

% [3.26] name_of_file is no longer an array.  And change the destination
% type to text_char, which fixes:
%
% Date: 19 Sep 1994 10:38:24 +0200
% From: thorinn@diku.dk (Lars Mathiesen)
%       When echoed to the screen and in the log, character codes
%       above '177 in file names are shown wrongly (typically as ^@).
%
@x [3.26] l.789 - name_of_file is no longer an array
@!name_of_file:packed array[1..file_name_size] of char;@;@/
  {on some systems this may be a \&{record} variable}
@y
@!name_of_file:^text_char;
@z

@x [3.27] l.794 - Do file opening in C.
@ The \ph\ compiler with which the present version of \TeX\ was prepared has
extended the rules of \PASCAL\ in a very convenient way. To open file~|f|,
we can write
$$\vbox{\halign{#\hfil\qquad&#\hfil\cr
|reset(f,@t\\{name}@>,'/O')|&for input;\cr
|rewrite(f,@t\\{name}@>,'/O')|&for output.\cr}}$$
The `\\{name}' parameter, which is of type `{\bf packed array
$[\langle\\{any}\rangle]$ of \\{char}}', stands for the name of
the external file that is being opened for input or output.
Blank spaces that might appear in \\{name} are ignored.

The `\.{/O}' parameter tells the operating system not to issue its own
error messages if something goes wrong. If a file of the specified name
cannot be found, or if such a file cannot be opened for some other reason
(e.g., someone may already be trying to write the same file), we will have
|@!erstat(f)<>0| after an unsuccessful |reset| or |rewrite|.  This allows
\TeX\ to undertake appropriate corrective action.
@:PASCAL H}{\ph@>
@^system dependencies@>

\TeX's file-opening procedures return |false| if no file identified by
|name_of_file| could be opened.

@d reset_OK(#)==erstat(#)=0
@d rewrite_OK(#)==erstat(#)=0

@p function a_open_in(var f:alpha_file):boolean;
  {open a text file for input}
begin reset(f,name_of_file,'/O'); a_open_in:=reset_OK(f);
end;
@#
function a_open_out(var f:alpha_file):boolean;
  {open a text file for output}
begin rewrite(f,name_of_file,'/O'); a_open_out:=rewrite_OK(f);
end;
@#
function b_open_in(var f:byte_file):boolean;
  {open a binary file for input}
begin reset(f,name_of_file,'/O'); b_open_in:=reset_OK(f);
end;
@#
function b_open_out(var f:byte_file):boolean;
  {open a binary file for output}
begin rewrite(f,name_of_file,'/O'); b_open_out:=rewrite_OK(f);
end;
@#
function w_open_in(var f:word_file):boolean;
  {open a word file for input}
begin reset(f,name_of_file,'/O'); w_open_in:=reset_OK(f);
end;
@#
function w_open_out(var f:word_file):boolean;
  {open a word file for output}
begin rewrite(f,name_of_file,'/O'); w_open_out:=rewrite_OK(f);
end;
@y
@ All of the file opening functions are defined in C.
@z

@x [3.28] l.850 - Do file closing in C.
@ Files can be closed with the \ph\ routine `|close(f)|', which
@^system dependencies@>
should be used when all input or output with respect to |f| has been completed.
This makes |f| available to be opened again, if desired; and if |f| was used for
output, the |close| operation makes the corresponding external file appear
on the user's area, ready to be read.

These procedures should not generate error messages if a file is
being closed before it has been successfully opened.

@p procedure a_close(var f:alpha_file); {close a text file}
begin close(f);
end;
@#
procedure b_close(var f:byte_file); {close a binary file}
begin close(f);
end;
@#
procedure w_close(var f:word_file); {close a word file}
begin close(f);
end;
@y
@ And all the file closing routines as well.
@z

@x [3.30] l.888 - Array size of input buffer is determined at runtime. MuLTeX
@!buffer:array[0..buf_size] of ASCII_code; {lines of characters being read}
@y
@!buffer:^ML_code; {lines of characters being read}
@!str_buffer:^ASCII_code;
@z

@x [3.31] l.933 - Do `input_ln' in C.
@p function input_ln(var f:alpha_file;@!bypass_eoln:boolean):boolean;
  {inputs the next line or returns |false|}
var last_nonblank:0..buf_size; {|last| with trailing blanks removed}
begin if bypass_eoln then if not eof(f) then get(f);
  {input the first character of the line into |f^|}
last:=first; {cf.\ Matthew 19\thinspace:\thinspace30}
if eof(f) then input_ln:=false
else  begin last_nonblank:=first;
  while not eoln(f) do
    begin if last>=max_buf_stack then
      begin max_buf_stack:=last+1;
      if max_buf_stack=buf_size then
        @<Report overflow of the input buffer, and abort@>;
      end;
    buffer[last]:=xord[f^]; get(f); incr(last);
    if buffer[last-1]<>" " then last_nonblank:=last;
    end;
  last:=last_nonblank; input_ln:=true;
  end;
end;
@y
We define |input_ln| in C, for efficiency. Nevertheless we quote the module
`Report overflow of the input buffer, and abort' here in order to make
\.{WEAVE} happy, since part of that module is needed by e-TeX.

@p @{ @<Report overflow of the input buffer, and abort@> @}
@z

% [3.32] `term_in' and `term_out' are standard input and output.
% Declare the variables that used to be constants.
@x [3.32] l.961 - `term_in' and `term_out' are standard input and output.
@<Glob...@>=
@!term_in:alpha_file; {the terminal as an input file}
@!term_out:alpha_file; {the terminal as an output file}
@y
@d term_in==stdin {the terminal as an input file}
@d term_out==stdout {the terminal as an output file}

@<Glob...@>=
@!init
@!ini_version:boolean; {are we \.{INITEX}?}
@!dump_option:boolean; {was the dump name option used?}
@!dump_line:boolean; {was a \.{\%\AM format} line seen?}
tini@/
@#
@!bound_default:integer; {temporary for setup}
@!bound_name:^char; {temporary for setup}
@#
@!mem_bot:integer;{smallest index in the |mem| array dumped by \.{INITEX};
  must not be less than |mem_min|}
@!main_memory:integer; {total memory words allocated in initex}
@!extra_mem_bot:integer; {|mem_min:=mem_bot-extra_mem_bot| except in \.{INITEX}}
@!mem_min:integer; {smallest index in \TeX's internal |mem| array;
  must be |min_halfword| or more;
  must be equal to |mem_bot| in \.{INITEX}, otherwise |<=mem_bot|}
@!mem_top:integer; {largest index in the |mem| array dumped by \.{INITEX};
  must be substantially larger than |mem_bot|,
  equal to |mem_max| in \.{INITEX}, else not greater than |mem_max|}
@!extra_mem_top:integer; {|mem_max:=mem_top+extra_mem_top| except in \.{INITEX}}
@!mem_max:integer; {greatest index in \TeX's internal |mem| array;
  must be strictly less than |max_halfword|;
  must be equal to |mem_top| in \.{INITEX}, otherwise |>=mem_top|}
@!error_line:integer; {width of context lines on terminal error messages}
@!half_error_line:integer; {width of first lines of contexts in terminal
  error messages; should be between 30 and |error_line-15|}
@!max_print_line:integer;
  {width of longest text lines output; should be at least 60}
@!trick_line:integer; {JTeX: for trick}
@!max_strings:integer; {maximum number of strings; must not exceed |max_halfword|}
@!strings_free:integer; {strings available after format loaded}
@!string_vacancies:integer; {the minimum number of characters that should be
  available for the user's control sequences and font names,
  after \TeX's own error messages are stored}
@!pool_size:integer; {maximum number of characters in strings, including all
  error messages and help texts, and the names of all fonts and
  control sequences; must exceed |string_vacancies| by the total
  length of \TeX's own strings, which is currently about 23000}
@!pool_free:integer;{pool space free after format loaded}
@!font_mem_size:integer; {number of words of |font_info| for all fonts}
@!font_max:integer; {maximum internal font number; ok to exceed |max_quarterword|
  and must be at most |font_base|+|max_font_max|}
@!font_k:integer; {loop variable for initialization}
@!hyph_size:integer; {maximun number of hyphen exceptions}
@!trie_size:integer; {space for hyphenation patterns; should be larger for
  \.{INITEX} than it is in production versions of \TeX.  50000 is
  needed for English, German, and Portuguese.}
@!buf_size:integer; {maximum number of characters simultaneously present in
  current lines of open files and in control sequences between
  \.{\\csname} and \.{\\endcsname}; must not exceed |max_halfword|}
@!str_buf_size:integer; {MuLTeX}
@!stack_size:integer; {maximum number of simultaneous input sources}
@!max_in_open:integer; {maximum number of input files and error insertions that
  can be going on simultaneously}
@!param_size:integer; {maximum number of simultaneous macro parameters}
@!nest_size:integer; {maximum number of semantic levels simultaneously active}
@!save_size:integer; {space for saving values outside of current group; must be
  at most |max_halfword|}
@!dvi_buf_size:integer; {size of the output buffer; must be a multiple of 8}
@!parse_first_line_p:c_int_type; {parse the first line for options}
@!file_line_error_style_p:c_int_type; {format messages as file:line:error}
@!eight_bit_p:c_int_type; {make all characters printable by default}
@!halt_on_error_p:c_int_type; {stop at first error}
@!quoted_filename:boolean; {current filename is quoted}
{Variables for source specials}
@!src_specials_p : boolean;{Whether |src_specials| are enabled at all}
@!insert_src_special_auto : boolean;
@!insert_src_special_every_par : boolean;
@!insert_src_special_every_parend : boolean;
@!insert_src_special_every_cr : boolean;
@!insert_src_special_every_math : boolean;
@!insert_src_special_every_hbox : boolean;
@!insert_src_special_every_vbox : boolean;
@!insert_src_special_every_display : boolean;
@z

@x [3.33] l.964 - We don't need to open terminal files.
@ Here is how to open the terminal files
in \ph. The `\.{/I}' switch suppresses the first |get|.
@^system dependencies@>

@d t_open_in==reset(term_in,'TTY:','/O/I') {open the terminal for text input}
@d t_open_out==rewrite(term_out,'TTY:','/O') {open the terminal for text output}
@y
@ Here is how to open the terminal files.  |t_open_out| does nothing.
|t_open_in|, on the other hand, does the work of ``rescanning,'' or getting
any command line arguments the user has provided.  It's defined in C.

@d t_open_out == {output already open for text output}
@z

@x [3.34] l.982 - Flushing output to terminal files.
these operations can be specified in \ph:
@^system dependencies@>

@d update_terminal == break(term_out) {empty the terminal output buffer}
@d clear_terminal == break_in(term_in,true) {clear the terminal input buffer}
@y
these operations can be specified with {\mc UNIX}.  |update_terminal|
does an |fflush|. |clear_terminal| is redefined
to do nothing, since the user should control the terminal.
@^system dependencies@>

@d update_terminal == fflush (term_out)
@d clear_terminal == do_nothing
@z

@x [3.35] l.1017 - needed for e-TeX, but differently
@<Report overflow of the input buffer, and abort@>=
if format_ident=0 then
  begin write_ln(term_out,'Buffer size exceeded!'); goto final_end;
@.Buffer size exceeded@>
  end
else begin cur_input.loc_field:=first; cur_input.limit_field:=last-1;
@y
Routine is implemented in C; part of module is, however, needed for e-TeX.

@<Report overflow of the input buffer, and abort@>=
  begin cur_input.loc_field:=first; cur_input.limit_field:=last-1;
@z

@x [3.37] l.1055 - |init_terminal|, reading the command line.
@ The following program does the required initialization
without retrieving a possible command line.
It should be clear how to modify this routine to deal with command lines,
if the system permits them.
@^system dependencies@>

@p function init_terminal:boolean; {gets the terminal input started}
label exit;
begin t_open_in;
@y
@ The following program does the required initialization.
Iff anything has been specified on the command line, then |t_open_in|
will return with |last > first|.
@^system dependencies@>

@p function init_terminal:boolean; {gets the terminal input started}
label exit;
begin t_open_in;
if last > first then
  begin loc := first;
  while (loc < last) and (buffer[loc]=' ') do incr(loc);
  if loc < last then
    begin init_terminal := true; goto exit;
    end;
  end;
@z

@x [3.37] l.1068 - |init_terminal|, output missing newline.
    write(term_out,'! End of file on the terminal... why?');
@y
    write_ln(term_out,'! End of file on the terminal... why?');
@z

@x [4.38] l.1126 - Array size for string pool is determined at runtime.
@!pool_pointer = 0..pool_size; {for variables that point into |str_pool|}
@!str_number = 0..max_strings; {for variables that point into |str_start|}
@y
@!pool_pointer = integer; {for variables that point into |str_pool|}
@!str_number = 0..ssup_max_strings; {for variables that point into |str_start|}
@z

@x [4.39] l.1131 - Dynamically size pool arrays.
@!str_pool:packed array[pool_pointer] of packed_ASCII_code; {the characters}
@!str_start : array[str_number] of pool_pointer; {the starting pointers}
@y
@!str_pool: ^packed_ASCII_code; {the characters}
@!str_start : ^pool_pointer; {the starting pointers}
@z

@x [4.45] MuLTeX: buffer and str_pool
while j<str_start[s+1] do
  begin if so(str_pool[j])<>buffer[k] then
    begin result:=false; goto not_found;
    end;
  incr(j); incr(k);
  end;
@y
while j<str_start[s+1] do
  begin if so(str_pool[j])<>str_buffer[k] then
    begin result:=false; goto not_found;
    end;
  incr(j); incr(k);
  end;
@z

@x [4.47] l.1237 - string recycling
@p @!init function get_strings_started:boolean; {initializes the string pool,
@y
@p @t\4@>@<Declare additional routines for string recycling@>@/

@!init function get_strings_started:boolean; {initializes the string pool,
@z

%@x [4.48] l.1252 -- Do not create "^^xy" for strings<256 in string pool
%@ @d app_lc_hex(#)==l:=#;
%  if l<10 then append_char(l+"0")@+else append_char(l-10+"a")
%@y
%@ The first 256 strings will consist of a single character only.
%@z
%@x
%  begin if (@<Character |k| cannot be printed@>) then
%    begin append_char("^"); append_char("^");
%    if k<@'100 then append_char(k+@'100)
%    else if k<@'200 then append_char(k-@'100)
%    else begin app_lc_hex(k div 16); app_lc_hex(k mod 16);
%      end;
%    end
%  else append_char(k);
%@y
%  begin append_char(k);
%@z

@x [4.49] l.1272 -- Change documentation (probably needed in more places)
would like string @'32 to be the single character @'32 instead of the
@y
would like string @'32 to be printed as the single character @'32
instead of the
@z

@x [4.49] l.1295 -- Do not hardwire printable ASCII.
@<Character |k| cannot be printed@>=
  (k<" ")or(k>"~")
@y
@<Character |k| cannot be printed@>=
   not is_printable[k]
@z

% [4.51] Open the pool file using a path, and can't do string
% assignments directly.  (`strcpy' and `strlen' work here because
% `pool_name' is a constant string, and thus ends in a null and doesn't
% start with a space.)
@x [4.51] l.1314 - Open the pool file.
name_of_file:=pool_name; {we needn't set |name_length|}
if a_open_in(pool_file) then
@y
name_length := strlen (pool_name);
name_of_file := xmalloc_array (ASCII_code, name_length + 1);
strcpy (stringcast(name_of_file+1), pool_name); {copy the string}
if a_open_in (pool_file, kpse_texpool_format) then
@z

@x [4.51] l.1322 - Make `TEX.POOL' lowercase, and change how it's read.
else  bad_pool('! I can''t read TEX.POOL.')
@y
else  bad_pool('! I can''t read mtex.pool; bad path?')
@z
@x [4.52] l.1326 - Make `TEX.POOL' lowercase, and change how it's read.
begin if eof(pool_file) then bad_pool('! TEX.POOL has no check sum.');
@.TEX.POOL has no check sum@>
read(pool_file,m,n); {read two digits of string length}
@y
begin if eof(pool_file) then bad_pool('! mtex.pool has no check sum.');
@.TEX.POOL has no check sum@>
read(pool_file,m); read(pool_file,n); {read two digits of string length}
@z
@x [4.52] l.1332 - Make `TEX.POOL' lowercase, and change how it's read.
    bad_pool('! TEX.POOL line doesn''t begin with two digits.');
@y
    bad_pool('! mtex.pool line doesn''t begin with two digits.');
@z
@x [4.53] l.1354 - Make `TEX.POOL' lowercase, and change how it's read.
  bad_pool('! TEX.POOL check sum doesn''t have nine digits.');
@y
  bad_pool('! mtex.pool check sum doesn''t have nine digits.');
@z
@x [4.53] l.1360 - Make `TEX.POOL' lowercase, and change how it's read.
done: if a<>@$ then bad_pool('! TEX.POOL doesn''t match; TANGLE me again.');
@y
done: if a<>@$ then
  bad_pool('! mtex.pool doesn''t match; tangle me again (or fix the path).');
@z

@x [5.54] l.1422 - error_line, MuLTeX
@!trick_buf:array[0..error_line] of ASCII_code; {circular buffer for
  pseudoprinting}
@y
@!trick_buf:array[0..ssup_error_line] of ML_code; {circular buffer for
  pseudoprinting}
@!tally_disp: integer;
@!first_count_disp: integer;
@z

@x MuLTeX l.1428
@ @<Initialize the output routines@>=
selector:=term_only; tally:=0; term_offset:=0; file_offset:=0;
@y
@ @<Initialize the output routines@>=
selector:=term_only; tally:=0; term_offset:=0; file_offset:=0;
tally_disp:=0;
@z

@x MuLTeX: [5.58] l.1466 Multi-byte char may overshoot max_print_line
procedure print_char(@!s:ASCII_code); {prints a single character}
label exit;
begin if @<Character |s| is the current new-line character@> then
 if selector<pseudo then
  begin print_ln; return;
  end;
case selector of
term_and_log: begin wterm(xchr[s]); wlog(xchr[s]);
  incr(term_offset); incr(file_offset);
  if term_offset=max_print_line then
    begin wterm_cr; term_offset:=0;
    end;
  if file_offset=max_print_line then
    begin wlog_cr; file_offset:=0;
    end;
  end;
log_only: begin wlog(xchr[s]); incr(file_offset);
  if file_offset=max_print_line then print_ln;
  end;
term_only: begin wterm(xchr[s]); incr(term_offset);
  if term_offset=max_print_line then print_ln;
  end;
no_print: do_nothing;
pseudo: if tally<trick_count then trick_buf[tally mod error_line]:=s;
new_string: begin if pool_ptr<pool_size then append_char(s);
  end; {we drop characters if the string space is full}
othercases write(write_file[selector],xchr[s])
endcases;@/
incr(tally);
exit:end;
@y
@<Declare procedures used by |print_char|@>
procedure print_char(@!s:ML_code); {prints a single character}
label exit;
begin if selector<pseudo then
  if is_mlrep_ascii(s) then
    if @<Character |s| is the current new-line character@> then
      begin print_ln; return;
      end;
case selector of
term_and_log: begin print_char_term(s); print_char_log(s);
  end;
log_only: print_char_log(s);
term_only: print_char_term(s);
no_print: do_nothing;
pseudo: if tally_disp<trick_count then @<Store char in |trick_buf|@>;
new_string: @<Store char in |str_pool|@>;
othercases write(write_file[selector],xchr[s]) {TODO:xchr}
endcases;@/
incr(tally);
exit:end;
@z

@x MuLTeX: [5.59] l.1524
    while j<str_start[s+1] do
      begin print_char(so(str_pool[j])); incr(j);
      end;
@y
    @<Print chars in |str_pool| by |print_char|@>;
@z

@x MuLTeX: [5.59] l.1530
while j<str_start[s+1] do
  begin print_char(so(str_pool[j])); incr(j);
  end;
@y
@<Print chars in |str_pool| by |print_char|@>;
@z

@x MuLTeX: [5.60] l.1543
else begin j:=str_start[s];
  while j<str_start[s+1] do
    begin print(so(str_pool[j])); incr(j);
    end;
  end;
@y
else begin j:=str_start[s];
  @<Print chars in |str_pool| by |print|@>;
  end;
@z

@x l.1536 --  If the ``src-specials'' feature is active, change the banner.
wterm(banner);
@y
if src_specials_p or file_line_error_style_p or parse_first_line_p then
  wterm(banner_k)
else
  wterm(banner);
@z

@x [5.61] l.1556 - Print rest of banner, eliminate misleading `(no format preloaded)'.
if format_ident=0 then wterm_ln(' (no format preloaded)')
else  begin slow_print(format_ident); print_ln;
  end;
@y
wterm(version_string);
if format_ident>0 then slow_print(format_ident);
print_ln;
if shell_enabled_p then begin
  wterm_ln(' \write18 enabled.')
end;
if src_specials_p then begin
  wterm_ln(' Source specials enabled.')
end;
if file_line_error_style_p then begin
  wterm_ln(' file:line:error style messages enabled.')
end;
if parse_first_line_p then begin
  wterm_ln(' %&-line parsing enabled.')
end;
if translate_filename then begin
  wterm(' (');
  fputs(translate_filename, stdout);
  wterm_ln(')');
end;
@z

@x [6.73] l.1732 - Add unspecified_mode.
@d error_stop_mode=3 {stops at every opportunity to interact}
@y
@d error_stop_mode=3 {stops at every opportunity to interact}
@d unspecified_mode=4 {extra value for command-line switch}
@z

@x [6.73] l.1734 - file:line:error style error messages.
  print_nl("! "); print(#);
@y
  if (file_line_error_style_p and not terminal_input) then
  begin 
    print_nl ("");
    print (full_source_filename_stack[in_open]);
    print (":"); print_int (line); print (": ");
    print (#); 
  end  
  else begin print_nl("! "); print(#) end;
@z


@x [6.73] l.1738 - Add interaction_option.
@!interaction:batch_mode..error_stop_mode; {current level of interaction}
@y
@!interaction:batch_mode..error_stop_mode; {current level of interaction}
@!interaction_option:batch_mode..unspecified_mode; {set from command line}
@z

@x [6.74] l.1740 - Allow override by command line switch.
@ @<Set init...@>=interaction:=error_stop_mode;
@y
@ @<Set init...@>=if interaction_option=unspecified_mode then
  interaction:=error_stop_mode
else
  interaction:=interaction_option;
@z

% [6.81] Eliminate nonlocal goto, since C doesn't have them.
% Plus, it's nicer just to do an exit with the appropriate status code
% under Unix.  We call it `uexit' because there's a WEB symbol called
% `exit' already.  We use a C macro to change `uexit' back to `exit'.
@x [6.81] l.1852 - Eliminate nonlocal goto, since C doesn't have them.
@<Error hand...@>=
procedure jump_out;
begin goto end_of_TEX;
end;
@y
@d do_final_end==begin
   update_terminal;
   ready_already:=0;
   if (history <> spotless) and (history <> warning_issued) then
       uexit(1)
   else
       uexit(0);
   end

@<Error hand...@>=
procedure jump_out;
begin
close_files_and_terminate;
do_final_end;
end;
@z

@x [6.82] l.1866 - file:line:error style messages force scroll_mode.
print_char("."); show_context;
@y
if file_line_error_style_p then interaction:=scroll_mode
else begin print_char("."); show_context end;
@z

@x [6.84] l.1888 - Implement the switch-to-editor option.
line ready to be edited. But such an extension requires some system
wizardry, so the present implementation simply types out the name of the
file that should be
edited and the relevant line number.
@^system dependencies@>

There is a secret `\.D' option available when the debugging routines haven't
been commented~out.
@^debugging@>
@y
line ready to be edited.
We do this by calling the external procedure |call_edit| with a pointer to
the filename, its length, and the line number.
However, here we just set up the variables that will be used as arguments,
since we don't want to do the switch-to-editor until after TeX has closed
its files.
@^system dependencies@>

There is a secret `\.D' option available when the debugging routines haven't
been commented~out.
@^debugging@>
@d edit_file==input_stack[base_ptr]
@z

@x [6.84] l.1903 - Implement the switch-to-editor option.
"E": if base_ptr>0 then
  begin print_nl("You want to edit file ");
@.You want to edit file x@>
  slow_print(input_stack[base_ptr].name_field);
  print(" at line "); print_int(line);
  interaction:=scroll_mode; jump_out;
@y
"E": if base_ptr>0 then
    begin edit_name_start:=str_start[edit_file.name_field];
    edit_name_length:=str_start[edit_file.name_field+1] -
                      str_start[edit_file.name_field];
    edit_line:=line;
    jump_out;
@z

% [7.104] `remainder' is a library routine on some systems, so change
% its name to avoid conflicts.
@x [7.104] l.2227 - avoid name conflicts with lib routine remainder()
|remainder|, holds the remainder after a division.

@<Glob...@>=
@y
|remainder|, holds the remainder after a division.

@d remainder==tex_remainder

@<Glob...@>=
@z

@x [7.109] l.2352 - Define glue_ratio in C.
@!glue_ratio=real; {one-word representation of a glue expansion factor}
@y
@z

% [8.110] Make it easy to change constants.  Do not increase
% max_quarterword without changing the memoryword structure in `texmfmem.h'.
% If you set min_quarterword or min_halfword to a non-zero value, you have
% to remove the definitions of qi/qo, hi/ho in this change file!
@x [8.110] l.2405 - increase |max_halfword|
@d min_quarterword=0 {smallest allowable value in a |quarterword|}
@d max_quarterword=255 {largest allowable value in a |quarterword|}
@d min_halfword==0 {smallest allowable value in a |halfword|}
@d max_halfword==65535 {largest allowable value in a |halfword|}
@y 2407
@d min_quarterword=0 {smallest allowable value in a |quarterword|}
@d max_quarterword==65535 {largest allowable value in a |quarterword|}
@d min_halfword==-@"1FFFFFFF {smallest allowable value in a |halfword|}
@d max_halfword==@"1FFFFFFF {largest allowable value in a |halfword|}
  {2^5*2^8*2^16-1 catcode*ML_code}
@d max_ml_catcode_idx=619 {prime number}
@d max_ml_kinsoku_idx=619 {prime number}
@z

@x [8.111] l.2422 - max_font_max
if (font_base<min_quarterword)or(font_max>max_quarterword) then bad:=15;
if font_max>font_base+256 then bad:=16;
@y
if (max_font_max<min_halfword)or(max_font_max>max_halfword) then bad:=15;
if font_max>font_base+max_font_max then bad:=16;
@z

@x [8.112] l.2435 - Efficiency.
macros are simplified in the obvious way when |min_quarterword=0|.
@^inner loop@>@^system dependencies@>

@d qi(#)==#+min_quarterword
  {to put an |eight_bits| item into a quarterword}
@d qo(#)==#-min_quarterword
  {to take an |eight_bits| item out of a quarterword}
@d hi(#)==#+min_halfword
  {to put a sixteen-bit item into a halfword}
@d ho(#)==#-min_halfword
  {to take a sixteen-bit item from a halfword}
@y
macros are simplified in the obvious way when |min_quarterword=0|.
So they have been simplified here in the obvious way.
@^inner loop@>@^system dependencies@>

@d qi(#)==# {to put an |eight_bits| item into a quarterword}
@d qo(#)==# {to take an |eight_bits| item from a quarterword}
@d hi(#)==# {to put a sixteen-bit item into a halfword}
@d ho(#)==# {to take a sixteen-bit item from a halfword}
@z

% [8.113] We've put the memory structure into the include file
% `texmf.h', since it's too hard to translate automatically.
@x [8.113] l.2453 - data structures for main memory
@!quarterword = min_quarterword..max_quarterword; {1/4 of a word}
@!halfword=min_halfword..max_halfword; {1/2 of a word}
@!two_choices = 1..2; {used when there are two variants in a record}
@!four_choices = 1..4; {used when there are four variants in a record}
@!two_halves = packed record@;@/
  @!rh:halfword;
  case two_choices of
  1: (@!lh:halfword);
  2: (@!b0:quarterword; @!b1:quarterword);
  end;
@!four_quarters = packed record@;@/
  @!b0:quarterword;
  @!b1:quarterword;
  @!b2:quarterword;
  @!b3:quarterword;
  end;
@!memory_word = record@;@/
  case four_choices of
  1: (@!int:integer);
  2: (@!gr:glue_ratio);
  3: (@!hh:two_halves);
  4: (@!qqqq:four_quarters);
  end;
@y
@!quarterword = min_quarterword..max_quarterword;
@!halfword = min_halfword..max_halfword;
@!two_choices = 1..2; {used when there are two variants in a record}
@!four_choices = 1..4; {used when there are four variants in a record}
@=#include "texmfmem.h";@>
@z

% [9.116] Change `mem' to `zmem', so we can define mem to be a register
% pointer to the memory array for speed.
@x [9.116] l.2545 - definition of main memory array
@!mem : array[mem_min..mem_max] of memory_word; {the big dynamic storage area}
@y
@!yzmem : ^memory_word; {the big dynamic storage area}
@!zmem : ^memory_word; {the big dynamic storage area}
@z

% [9.127] Fix casting problem in C.
% There are several of these.  They come from the rules C uses for
% comparing signed and unsigned quantities.  Just doing the comparison
% can result in incorrect evaluation wrt the way Pascal would do it.
@x [9.127] l.2739 - Fix casting problem in C.
if r>p+1 then @<Allocate from the top of node |p| and |goto found|@>;
@y 2738
if r>intcast(p+1) then @<Allocate from the top of node |p| and |goto found|@>;
@z

@x [10.144] l.3006 - font numbers can be >255 now.
@p function new_ligature(@!f,@!c:quarterword; @!q:pointer):pointer;
@y
@p function new_ligature(@!f:internal_font_number; @!c:quarterword;
                         @!q:pointer):pointer;
@z

%@x [10.152] MuLTeX
%@p function new_param_glue(@!n:small_number):pointer;
%@y
%@p function new_param_glue(@!n:integer):pointer;
%@z

@x [10.160] delayed
@ In fact, there are still more types coming. When we get to math formula
processing we will see that a |style_node| has |type=14|; and a number
of larger type codes will also be defined, for use in math mode only.
@y
@ In fact, there are still more types coming. When we get to math formula
processing we will see that a |style_node| has |type=14|; and a number
of larger type codes will also be defined, for use in math mode only.
So this is a good point for inserting definitios of new kinds of ref-type
box.

@p @<Define additional ref-type box@>
@z

% [11.165] Fix the word `free' so that it doesn't conflict with the
% standard C library routine of the same name.
@x [11.165] l.3364 - avoid conflict with lib function free()
are debugging.)
@y
are debugging.)

@d free==free_arr
@z

@x [11.165] l.3367 - dummy |free| and |was_free| arrays
@!debug @!free: packed array [mem_min..mem_max] of boolean; {free cells}
@t\hskip10pt@>@!was_free: packed array [mem_min..mem_max] of boolean;
@y
 {The debug memory arrays have not been mallocated yet.}
@!debug @!free: packed array [0..9] of boolean; {free cells}
@t\hskip10pt@>@!was_free: packed array [0..9] of boolean;
@z

%@x [12.174] l.3526 - Eliminate unsigned comparisons to zero.
%        begin if (font(p)<font_base)or(font(p)>font_max) then
%@y
%        begin if (font(p)>font_max) then
%@z
%
%@x [12.176] l.3563 - Eliminate unsigned comparisons to zero.
%@p procedure print_font_and_char(@!p:integer); {prints |char_node| data}
%begin if p>mem_end then print_esc("CLOBBERED.")
%else  begin if (font(p)<font_base)or(font(p)>font_max) then print_char("*")
%@y
%@p procedure print_font_and_char(@!p:integer); {prints |char_node| data}
%begin if p>mem_end then print_esc("CLOBBERED.")
%else  begin if (font(p)>font_max) then print_char("*")
%@z

@x MulTeX: [12.174] show japanese |char_node| properly on kanji tty
var n:integer; {for replacement counts}
begin while p>mem_min do
  begin if is_char_node(p) then
    begin if p<=mem_end then
      begin if font(p)<>font_in_short_display then
        begin if (font(p)<font_base)or(font(p)>font_max) then
          print_char("*")
@.*\relax@>
        else @<Print the font identifier for |font(p)|@>;
        print_char(" "); font_in_short_display:=font(p);
        end;
      print_ASCII(qo(character(p)));
      end;
    end
  else @<Print a short indication of the contents of node |p|@>;
  p:=link(p);
  end;
end;
@y
var n:integer; {for replacement counts}
mcset:mc_range;
begin while p>mem_min do
  begin if is_char_node(p) then
    begin if p<=mem_end then
     begin
      mcset:=ml_font_mc(font(p));
      if (mcset<>mc_ascii) then
        print_char(make_cn_mlrep(mcset)(qo(character(p))))
      else
      begin
      if font(p)<>font_in_short_display then
        begin if (font(p)>font_max) then
          print_char("*")
@.*\relax@>
        else @<Print the font identifier for |font(p)|@>;
        print_char(" "); font_in_short_display:=font(p);
        end;
      print_ASCII(qo(character(p)));
      end;
     end
    end
  else begin
    @<Print a short indication of the contents of node |p|@>;
    end;
  p:=link(p);
  end;
end;
@z

@x MuLTeX: [12.176] Printing of Japanese character in |show_node_list|
begin if p>mem_end then print_esc("CLOBBERED.")
else  begin if (font(p)<font_base)or(font(p)>font_max) then print_char("*")
@.*\relax@>
  else @<Print the font identifier for |font(p)|@>;
  print_char(" "); print_ASCII(qo(character(p)));
  end;
end;
@y
var mcset:mc_range;
begin if p>mem_end then print_esc("CLOBBERED.")
else  begin if (font(p)>font_max) then print_char("*")
@.*\relax@>
  else @<Print the font identifier for |font(p)|@>;
  print_char(" ");
  mcset:=ml_font_mc(font(p));
  if (mcset<>mc_ascii) then
    print_char(make_cn_mlrep(mcset)(qo(character(p))))
  else print_ASCII(qo(character(p)));
  end;
end;
@z

@x [12.186] l.3747 - Don't worry about strange floating point values.
  if abs(mem[p+glue_offset].int)<@'4000000 then print("?.?")
  else if abs(g)>float_constant(20000) then
@y 3747
  { The Unix |pc| folks removed this restriction with a remark that
    invalid bit patterns were vanishingly improbable, so we follow
    their example without really understanding it.
  |if abs(mem[p+glue_offset].int)<@'4000000 then print('?.?')|
  |else| }
  if fabs(g)>float_constant(20000) then
@z

@x [13.201] delayed:
@p procedure delete_glue_ref(@!p:pointer); {|p| points to a glue specification}
fast_delete_glue_ref(p);
@y
@p procedure delete_glue_ref(@!p:pointer); {|p| points to a glue specification}
fast_delete_glue_ref(p);
@<Destroy additional ref-type box@>
@z

@x [14.203] delayed: Add reference count of additional ref-type box
@d add_token_ref(#)==incr(token_ref_count(#)) {new reference to a token list}
@d add_glue_ref(#)==incr(glue_ref_count(#)) {new reference to a glue spec}
@y
@d add_token_ref(#)==incr(token_ref_count(#)) {new reference to a token list}
@d add_glue_ref(#)==incr(glue_ref_count(#)) {new reference to a glue spec}
@d add_df_ref(#)==incr(df_ref_count(#)) {new reference to a df spec}
@z

@x MuLTeX: [15.207] define new char code for multi-lingual char
@d max_char_code=15 {largest catcode for individual characters}
@y
@d jletter=16 {characters regarded as japanese letters}
@d max_char_code=16 {largest catcode for individual characters}
@z

@x MuLTeX: [15.208] you must shift command code
@d char_num=16 {character specified numerically ( \.{\\char} )}
@d math_char_num=17 {explicit math code ( \.{\\mathchar} )}
@d mark=18 {mark definition ( \.{\\mark} )}
@d xray=19 {peek inside of \TeX\ ( \.{\\show}, \.{\\showbox}, etc.~)}
@d make_box=20 {make a box ( \.{\\box}, \.{\\copy}, \.{\\hbox}, etc.~)}
@d hmove=21 {horizontal motion ( \.{\\moveleft}, \.{\\moveright} )}
@d vmove=22 {vertical motion ( \.{\\raise}, \.{\\lower} )}
@d un_hbox=23 {unglue a box ( \.{\\unhbox}, \.{\\unhcopy} )}
@d un_vbox=24 {unglue a box ( \.{\\unvbox}, \.{\\unvcopy} )}
@d remove_item=25 {nullify last item ( \.{\\unpenalty},
  \.{\\unkern}, \.{\\unskip} )}
@d hskip=26 {horizontal glue ( \.{\\hskip}, \.{\\hfil}, etc.~)}
@d vskip=27 {vertical glue ( \.{\\vskip}, \.{\\vfil}, etc.~)}
@d mskip=28 {math glue ( \.{\\mskip} )}
@d kern=29 {fixed space ( \.{\\kern})}
@d mkern=30 {math kern ( \.{\\mkern} )}
@d leader_ship=31 {use a box ( \.{\\shipout}, \.{\\leaders}, etc.~)}
@d halign=32 {horizontal table alignment ( \.{\\halign} )}
@d valign=33 {vertical table alignment ( \.{\\valign} )}
@d no_align=34 {temporary escape from alignment ( \.{\\noalign} )}
@d vrule=35 {vertical rule ( \.{\\vrule} )}
@d hrule=36 {horizontal rule ( \.{\\hrule} )}
@d insert=37 {vlist inserted in box ( \.{\\insert} )}
@d vadjust=38 {vlist inserted in enclosing paragraph ( \.{\\vadjust} )}
@d ignore_spaces=39 {gobble |spacer| tokens ( \.{\\ignorespaces} )}
@d after_assignment=40 {save till assignment is done ( \.{\\afterassignment} )}
@d after_group=41 {save till group is done ( \.{\\aftergroup} )}
@d break_penalty=42 {additional badness ( \.{\\penalty} )}
@d start_par=43 {begin paragraph ( \.{\\indent}, \.{\\noindent} )}
@d ital_corr=44 {italic correction ( \.{\\/} )}
@d accent=45 {attach accent in text ( \.{\\accent} )}
@d math_accent=46 {attach accent in math ( \.{\\mathaccent} )}
@d discretionary=47 {discretionary texts ( \.{\\-}, \.{\\discretionary} )}
@d eq_no=48 {equation number ( \.{\\eqno}, \.{\\leqno} )}
@d left_right=49 {variable delimiter ( \.{\\left}, \.{\\right} )}
@d math_comp=50 {component of formula ( \.{\\mathbin}, etc.~)}
@d limit_switch=51 {diddle limit conventions ( \.{\\displaylimits}, etc.~)}
@d above=52 {generalized fraction ( \.{\\above}, \.{\\atop}, etc.~)}
@d math_style=53 {style specification ( \.{\\displaystyle}, etc.~)}
@d math_choice=54 {choice specification ( \.{\\mathchoice} )}
@d non_script=55 {conditional math glue ( \.{\\nonscript} )}
@d vcenter=56 {vertically center a vbox ( \.{\\vcenter} )}
@d case_shift=57 {force specific case ( \.{\\lowercase}, \.{\\uppercase}~)}
@d message=58 {send to user ( \.{\\message}, \.{\\errmessage} )}
@d extension=59 {extensions to \TeX\ ( \.{\\write}, \.{\\special}, etc.~)}
@d in_stream=60 {files for reading ( \.{\\openin}, \.{\\closein} )}
@d begin_group=61 {begin local grouping ( \.{\\begingroup} )}
@d end_group=62 {end local grouping ( \.{\\endgroup} )}
@d omit=63 {omit alignment template ( \.{\\omit} )}
@d ex_space=64 {explicit space ( \.{\\\ } )}
@d no_boundary=65 {suppress boundary ligatures ( \.{\\noboundary} )}
@d radical=66 {square root and similar signs ( \.{\\radical} )}
@d end_cs_name=67 {end control sequence ( \.{\\endcsname} )}
@d min_internal=68 {the smallest code that can follow \.{\\the}}
@d char_given=68 {character code defined by \.{\\chardef}}
@d math_given=69 {math code defined by \.{\\mathchardef}}
@d last_item=70 {most recent item ( \.{\\lastpenalty},
  \.{\\lastkern}, \.{\\lastskip} )}
@d max_non_prefixed_command=70 {largest command code that can't be \.{\\global}}
@y
@d char_num=17 {character specified numerically ( \.{\\char} )}
@d math_char_num=18 {explicit math code ( \.{\\mathchar} )}
@d mark=19 {mark definition ( \.{\\mark} )}
@d xray=20 {peek inside of \TeX\ ( \.{\\show}, \.{\\showbox}, etc.~)}
@d make_box=21 {make a box ( \.{\\box}, \.{\\copy}, \.{\\hbox}, etc.~)}
@d hmove=22 {horizontal motion ( \.{\\moveleft}, \.{\\moveright} )}
@d vmove=23 {vertical motion ( \.{\\raise}, \.{\\lower} )}
@d un_hbox=24 {unglue a box ( \.{\\unhbox}, \.{\\unhcopy} )}
@d un_vbox=25 {unglue a box ( \.{\\unvbox}, \.{\\unvcopy} )}
@d remove_item=26 {nullify last item ( \.{\\unpenalty},
  \.{\\unkern}, \.{\\unskip} )}
@d hskip=27 {horizontal glue ( \.{\\hskip}, \.{\\hfil}, etc.~)}
@d vskip=28 {vertical glue ( \.{\\vskip}, \.{\\vfil}, etc.~)}
@d mskip=29 {math glue ( \.{\\mskip} )}
@d kern=30 {fixed space ( \.{\\kern})}
@d mkern=31 {math kern ( \.{\\mkern} )}
@d leader_ship=32 {use a box ( \.{\\shipout}, \.{\\leaders}, etc.~)}
@d halign=33 {horizontal table alignment ( \.{\\halign} )}
@d valign=34 {vertical table alignment ( \.{\\valign} )}
@d no_align=35 {temporary escape from alignment ( \.{\\noalign} )}
@d vrule=36 {vertical rule ( \.{\\vrule} )}
@d hrule=37 {horizontal rule ( \.{\\hrule} )}
@d insert=38 {vlist inserted in box ( \.{\\insert} )}
@d vadjust=39 {vlist inserted in enclosing paragraph ( \.{\\vadjust} )}
@d ignore_spaces=40 {gobble |spacer| tokens ( \.{\\ignorespaces} )}
@d after_assignment=41 {save till assignment is done ( \.{\\afterassignment} )}
@d after_group=42 {save till group is done ( \.{\\aftergroup} )}
@d break_penalty=43 {additional badness ( \.{\\penalty} )}
@d start_par=44 {begin paragraph ( \.{\\indent}, \.{\\noindent} )}
@d ital_corr=45 {italic correction ( \.{\\/} )}
@d accent=46 {attach accent in text ( \.{\\accent} )}
@d math_accent=47 {attach accent in math ( \.{\\mathaccent} )}
@d discretionary=48 {discretionary texts ( \.{\\-}, \.{\\discretionary} )}
@d eq_no=49 {equation number ( \.{\\eqno}, \.{\\leqno} )}
@d left_right=50 {variable delimiter ( \.{\\left}, \.{\\right} )}
@d math_comp=51 {component of formula ( \.{\\mathbin}, etc.~)}
@d limit_switch=52 {diddle limit conventions ( \.{\\displaylimits}, etc.~)}
@d above=53 {generalized fraction ( \.{\\above}, \.{\\atop}, etc.~)}
@d math_style=54 {style specification ( \.{\\displaystyle}, etc.~)}
@d math_choice=55 {choice specification ( \.{\\mathchoice} )}
@d non_script=56 {conditional math glue ( \.{\\nonscript} )}
@d vcenter=57 {vertically center a vbox ( \.{\\vcenter} )}
@d case_shift=58 {force specific case ( \.{\\lowercase}, \.{\\uppercase}~)}
@d message=59 {send to user ( \.{\\message}, \.{\\errmessage} )}
@d extension=60 {extensions to \TeX\ ( \.{\\write}, \.{\\special}, etc.~)}
@d in_stream=61 {files for reading ( \.{\\openin}, \.{\\closein} )}
@d begin_group=62 {begin local grouping ( \.{\\begingroup} )}
@d end_group=63 {end local grouping ( \.{\\endgroup} )}
@d omit=64 {omit alignment template ( \.{\\omit} )}
@d ex_space=65 {explicit space ( \.{\\\ } )}
@d no_boundary=66 {suppress boundary ligatures ( \.{\\noboundary} )}
@d radical=67 {square root and similar signs ( \.{\\radical} )}
@d end_cs_name=68 {end control sequence ( \.{\\endcsname} )}
@d min_internal=68 {the smallest code that can follow \.{\\the}}
@d char_given=69 {character code defined by \.{\\chardef}}
@d math_given=70 {math code defined by \.{\\mathchardef}}
@d last_item=71 {most recent item ( \.{\\lastpenalty},
  \.{\\lastkern}, \.{\\lastskip} )}
@d max_non_prefixed_command=71 {largest command code that can't be \.{\\global}}
@z

@x MuLTeX: [15.209] 
@d toks_register=71 {token list register ( \.{\\toks} )}
@d assign_toks=72 {special token list ( \.{\\output}, \.{\\everypar}, etc.~)}
@d assign_int=73 {user-defined integer ( \.{\\tolerance}, \.{\\day}, etc.~)}
@d assign_dimen=74 {user-defined length ( \.{\\hsize}, etc.~)}
@d assign_glue=75 {user-defined glue ( \.{\\baselineskip}, etc.~)}
@d assign_mu_glue=76 {user-defined muglue ( \.{\\thinmuskip}, etc.~)}
@d assign_font_dimen=77 {user-defined font dimension ( \.{\\fontdimen} )}
@d assign_font_int=78 {user-defined font integer ( \.{\\hyphenchar},
  \.{\\skewchar} )}
@d set_aux=79 {specify state info ( \.{\\spacefactor}, \.{\\prevdepth} )}
@d set_prev_graf=80 {specify state info ( \.{\\prevgraf} )}
@d set_page_dimen=81 {specify state info ( \.{\\pagegoal}, etc.~)}
@d set_page_int=82 {specify state info ( \.{\\deadcycles},
  \.{\\insertpenalties} )}
@d set_box_dimen=83 {change dimension of box ( \.{\\wd}, \.{\\ht}, \.{\\dp} )}
@d set_shape=84 {specify fancy paragraph shape ( \.{\\parshape} )}
@d def_code=85 {define a character code ( \.{\\catcode}, etc.~)}
@d def_family=86 {declare math fonts ( \.{\\textfont}, etc.~)}
@d set_font=87 {set current font ( font identifiers )}
@d def_font=88 {define a font file ( \.{\\font} )}
@d register=89 {internal register ( \.{\\count}, \.{\\dimen}, etc.~)}
@d max_internal=89 {the largest code that can follow \.{\\the}}
@d advance=90 {advance a register or parameter ( \.{\\advance} )}
@d multiply=91 {multiply a register or parameter ( \.{\\multiply} )}
@d divide=92 {divide a register or parameter ( \.{\\divide} )}
@d prefix=93 {qualify a definition ( \.{\\global}, \.{\\long}, \.{\\outer} )}
@d let=94 {assign a command code ( \.{\\let}, \.{\\futurelet} )}
@d shorthand_def=95 {code definition ( \.{\\chardef}, \.{\\countdef}, etc.~)}
@d read_to_cs=96 {read into a control sequence ( \.{\\read} )}
@d def=97 {macro definition ( \.{\\def}, \.{\\gdef}, \.{\\xdef}, \.{\\edef} )}
@d set_box=98 {set a box ( \.{\\setbox} )}
@d hyph_data=99 {hyphenation data ( \.{\\hyphenation}, \.{\\patterns} )}
@d set_interaction=100 {define level of interaction ( \.{\\batchmode}, etc.~)}
@d max_command=100 {the largest command code seen at |big_switch|}
@y
@d toks_register=72 {token list register ( \.{\\toks} )}
@d assign_toks=73 {special token list ( \.{\\output}, \.{\\everypar}, etc.~)}
@d assign_int=74 {user-defined integer ( \.{\\tolerance}, \.{\\day}, etc.~)}
@d assign_dimen=75 {user-defined length ( \.{\\hsize}, etc.~)}
@d assign_glue=76 {user-defined glue ( \.{\\baselineskip}, etc.~)}
@d assign_mu_glue=77 {user-defined muglue ( \.{\\thinmuskip}, etc.~)}
@d assign_font_dimen=78 {user-defined font dimension ( \.{\\fontdimen} )}
@d assign_font_int=79 {user-defined font integer ( \.{\\hyphenchar},  \.{\\skewchar} )}
@d assign_font_mcs=80 {font mcs ( \.{\\fontmcs} )}
@d set_aux=81 {specify state info ( \.{\\spacefactor}, \.{\\prevdepth} )}
@d set_prev_graf=82 {specify state info ( \.{\\prevgraf} )}
@d set_page_dimen=83 {specify state info ( \.{\\pagegoal}, etc.~)}
@d set_page_int=84 {specify state info ( \.{\\deadcycles},  \.{\\insertpenalties} )}
@d set_box_dimen=85 {change dimension of box ( \.{\\wd}, \.{\\ht}, \.{\\dp} )}
@d set_shape=86 {specify fancy paragraph shape ( \.{\\parshape} )}
@d def_code=87 {define a character code ( \.{\\catcode}, etc.~)}
@d def_family=88 {declare math fonts ( \.{\\textfont}, etc.~)}
@d set_font=89 {set current font ( font identifiers )}
@d def_font=90 {define a font file ( \.{\\font} )}
@d def_dfont=91 {define a on-demmand-load font file ( \.{\\delayedfont} )}
@d register=92 {internal register ( \.{\\count}, \.{\\dimen}, etc.~)}
@d min_refbox=93 {the smallest code that have the refbox type value}
@d demmand_font=93 {load demmanded font and set current font to it ( font identifiers )}
@d max_internal=93 {the largest code that can follow \.{\\the}}
@d max_refbox=93 {the largest code that have the refbox type value}
@d advance=94 {advance a register or parameter ( \.{\\advance} )}
@d multiply=95 {multiply a register or parameter ( \.{\\multiply} )}
@d divide=96 {divide a register or parameter ( \.{\\divide} )}
@d prefix=97 {qualify a definition ( \.{\\global}, \.{\\long}, \.{\\outer} )}
@d let=98 {assign a command code ( \.{\\let}, \.{\\futurelet} )}
@d shorthand_def=99 {code definition ( \.{\\chardef}, \.{\\countdef}, etc.~)}
@d read_to_cs=100 {read into a control sequence ( \.{\\read} )}
@d def=101 {macro definition ( \.{\\def}, \.{\\gdef}, \.{\\xdef}, \.{\\edef} )}
@d set_box=102 {set a box ( \.{\\setbox} )}
@d hyph_data=103 {hyphenation data ( \.{\\hyphenation}, \.{\\patterns} )}
@d set_interaction=104 {define level of interaction ( \.{\\batchmode}, etc.~)}
@d set_mcs_attr=105 {set attributes of mcs}
@d def_ml_input_codetype=106
@d set_ml_input_codetype=107
@d set_ml_read_codetype=108
@d set_ml_allread_codetype=109
@d def_ml_term_codetype=110
@d def_ml_log_codetype=111
@d set_ml_write_codetype=112
@d set_ml_allwrite_codetype=113
@d def_ml_spec_codetype=114
@d def_ml_input_mcs=115
@d def_ml_output_fin=116
@d set_burasage=117 {set burasage table data}
@d set_jkern=118 {set jkern table data}
@d faker=119
@d max_command=119 {the largest command code seen at |big_switch|}
@z COMMAND END

%@x [15.209] l.4165 - MLTeX: \charsubdef primitive
%@d shorthand_def=95 {code definition ( \.{\\chardef}, \.{\\countdef}, etc.~)}
%@y
%@d shorthand_def=95 {code definition ( \.{\\chardef}, \.{\\countdef}, etc.~)}
%  {or \.{\\charsubdef}}
%@z


@x [16.213] l.4321 - texarray
@!nest:array[0..nest_size] of list_state_record;
@y
@!nest:^list_state_record;
@z

@x [16.215] l.4344 - remove mem[] reference from initialize.
prev_graf:=0; shown_mode:=0;
@<Start a new current page@>;
@y
prev_graf:=0; shown_mode:=0;
@/{The following piece of code is a copy of module 991:}
page_contents:=empty; page_tail:=page_head; {|link(page_head):=null;|}@/
last_glue:=max_halfword; last_penalty:=0; last_kern:=0;
page_depth:=0; page_max_depth:=0;
@z

@x [16.219] l.4409 - i18n fix
    print_int(nest[p].pg_field); print(" line");
    if nest[p].pg_field<>1 then print_char("s");
@y
    print_int(nest[p].pg_field); 
    if nest[p].pg_field<>1 then print(" lines")
    else print(" line");
@z

@x [17.220] l.4448 - MLTeX: char_sub_code_base
paragraph shape.
@y
paragraph shape.
Additionally region~4 contains the table with ML\TeX's character
substitution definitions.
@z

@x [17.222] MlTeX
@d active_base=1 {beginning of region 1, for active character equivalents}
@d single_base=active_base+256 {equivalents of one-character control sequences}
@d null_cs=single_base+256 {equivalent of \.{\\csname\\endcsname}}
@y
@d active_base=1 {beginning of region 1, for active character equivalents}
@d ml_active_base=active_base+256 {equivalents of active ml character}
@d single_base=ml_active_base+max_ml_catcode_idx+1
  {equivalents of one-character control sequences}
@d null_cs=single_base+256 {equivalent of \.{\\csname\\endcsname}}
@z

@x [17.222] l.4523 - frozen_special, for source specials.
@d frozen_null_font=frozen_control_sequence+10
  {permanent `\.{\\nullfont}'}
@y
@d frozen_special=frozen_control_sequence+10
  {permanent `\.{\\special}'}
@d frozen_null_font=frozen_control_sequence+11
  {permanent `\.{\\nullfont}'}
@z

@x [17.222] l.4526 - max_font_max
@d undefined_control_sequence=frozen_null_font+257 {dummy location}
@y
@d undefined_control_sequence=frozen_null_font+max_font_max+1 {dummy location}
@z

@x [17.222] l.4533 - hash_extra
for k:=active_base to undefined_control_sequence-1 do
  eqtb[k]:=eqtb[undefined_control_sequence];
@y
for k:=active_base to eqtb_top do
  eqtb[k]:=eqtb[undefined_control_sequence];
@z

@x MuLTeX: [17.224] define new skip code for japanese interchar glue
@d glue_pars=18 {total number of glue parameters}
@y
@d ml_interchar_skip_code=18 {glue between japanese characters}
@d ml_ascii_mlc_skip_code=19 {glue between ascii string and kanji string}
@d ml_math_mlc_skip_code=20 {glue between ascii string and kanji string}
@d j_space_skip_code=21 {glue corresponding to JIS space(!!)}
@d ml_iskip_code=22
@d ml_askip_code=ml_iskip_code+mc_max+1
@d ml_mskip_code=ml_askip_code+mc_max+1
@d ml_sskip_code=ml_mskip_code+mc_max+1
@d glue_pars=ml_sskip_code+mc_max+1 {total number of glue parameters}
@d ml_iskip_base=glue_base+ml_iskip_code
@d ml_askip_base=glue_base+ml_askip_code
@d ml_mskip_base=glue_base+ml_mskip_code
@d ml_sskip_base=glue_base+ml_sskip_code
@z

@x MuLTeX: [17.224]
@d thick_mu_skip==glue_par(thick_mu_skip_code)
@y
@d thick_mu_skip==glue_par(thick_mu_skip_code)
@d ml_interchar_skip==glue_par(ml_interchar_skip_code)
@d ml_ascii_mlc_skip==glue_par(ml_ascii_mlc_skip_code)
@d ml_math_mlc_skip==glue_par(ml_math_mlc_skip_code)
@d j_space_skip==glue_par(j_space_skip_code)
@z

@x MuLTeX: [17.225] add new case for print_skip_param
thick_mu_skip_code: print_esc("thickmuskip");
othercases print("[unknown glue parameter!]")
@y
thick_mu_skip_code: print_esc("thickmuskip");
ml_interchar_skip_code: print_esc("mlintercharskip");
ml_ascii_mlc_skip_code: print_esc("mlasciimlcskip");
ml_math_mlc_skip_code: print_esc("mlmathmlcskip");
j_space_skip_code: print_esc("jisspaceskip");
othercases print("[unknown glue parameter!]")
@z

@x MuLTeX: [17.226] put new skip name into hash table
primitive("thickmuskip",assign_mu_glue,glue_base+thick_mu_skip_code);@/
@!@:thick_mu_skip_}{\.{\\thickmuskip} primitive@>
@y
primitive("thickmuskip",assign_mu_glue,glue_base+thick_mu_skip_code);@/
@!@:thick_mu_skip_}{\.{\\thickmuskip} primitive@>
primitive("mlintercharskip",assign_glue,glue_base+ml_interchar_skip_code);@/
@!@:ml_interchar_skip_}{\.{\\mlintercharskip} primitive@>
primitive("mlasciimlcskip",assign_glue,glue_base+ml_ascii_mlc_skip_code);@/
@!@:ml_ascii_mlc_skip_}{\.{\\mlasciimlcskip} primitive@>
primitive("mlmathmlcskip",assign_glue,glue_base+ml_math_mlc_skip_code);@/
@!@:ml_math_mlc_skip_}{\.{\\mlmathmlcskip} primitive@>
primitive("jisspaceskip",assign_glue,glue_base+j_space_skip_code);@/
@!@:j_space_skip_}{\.{\\jisspaceskip} primitive@>
primitive("@@@@jisspaceskip",assign_glue,ml_sskip_base+mc_jp);@/
@!@:def_j_space_skip_}{\.{\\@@@@jisspaceskip} primitive@>
@z

@x [17.229] MuLTeX: show equiv in region 3
else if n<mu_skip_base then
@y
else if n<=ml_iskip_code+mc_max then begin
  print("interchar skip for mcs "); print_int(n-ml_iskip_code);
  print(" = "); print_spec(equiv(n),"pt");
  end
else if n<=ml_askip_code+mc_max then begin
  print("skip between ascii and mcs "); print_int(n-ml_askip_code);
  print(" = "); print_spec(equiv(n),"pt");
  end
else if n<=ml_mskip_code+mc_max then begin
  print("skip between math and mcs "); print_int(n-ml_mskip_code);
  print(" = "); print_spec(equiv(n),"pt");
  end
else if n<=ml_sskip_code+mc_max then begin
  print("space skip for mcs "); print_int(n-ml_sskip_code);
  print(" = "); print_spec(equiv(n),"pt");
  end
else if n<mu_skip_base then
@z

@x [17.230] MuLTeX: ml catcode, current multi-lingual font
@d cur_font_loc=box_base+256 {internal font number outside math mode}
@d math_font_base=cur_font_loc+1 {table of 48 math font numbers}
@d cat_code_base=math_font_base+48
  {table of 256 command codes (the ``catcodes'')}
@d lc_code_base=cat_code_base+256 {table of 256 lowercase mappings}
@y
@d cur_font_loc=box_base+256 {internal font number outside math mode}
@d cur_ml_font_loc_base=cur_font_loc {cur_font = cur_ml_font(mc_ascii)}
@d math_font_base=cur_ml_font_loc_base+mc_max+1 {table of 48 math font numbers}
@d cat_code_base=math_font_base+48
  {table of 256 command codes (the ``catcodes'')}
@d ml_cat_code_base=cat_code_base+256+1
  {ml_cat_code_base-1 for the default ml-catcode}
  {ml_cat_code_base+max_ml_catcode_idx+1 for overflow}
@d kinsoku_code_base=ml_cat_code_base+max_ml_catcode_idx+1+1
@d ml_kinsoku_code_base=kinsoku_code_base+256+1
  {ml_kinsoku_code_base-1 for the default ml-kinsoku}
  {ml_kinsoku_code_base+max_ml_kinsoku_idx+1 for overflow}
@d asc_punct_base=ml_kinsoku_code_base+max_ml_kinsoku_idx+1+1
@d lc_code_base=asc_punct_base+256
  {table of 256 lowercase mappings}
@z

@x [17.230] l.4731 - MLTeX: char_sub_code_base
@d int_base=math_code_base+256 {beginning of region 5}
@y
@d char_sub_code_base=math_code_base+256 {table of character substitutions}
@d int_base=char_sub_code_base+256 {beginning of region 5}
@z

@x [17.232] MuLTeX: ml catcode, current multi-lingual font
@d cur_font==equiv(cur_font_loc)
@d fam_fnt(#)==equiv(math_font_base+#)
@d cat_code(#)==equiv(cat_code_base+#)
@y
@d cur_font==equiv(cur_font_loc)
@d cur_ml_font_loc(#)==cur_ml_font_loc_base+(#)
@d cur_ml_font(#)==equiv(cur_ml_font_loc_base+(#))
@d fam_fnt(#)==equiv(math_font_base+#)
@d cat_code(#)==equiv(cat_code_base+#)
@d ml_cat_code(#)==equiv(ml_cat_code_base+#)
@d asc_kinsoku(#)==equiv(kinsoku_code_base+#)
@d ml_kinsoku(#)==equiv(ml_kinsoku_code_base+#)
@d asc_punct(#)==equiv(asc_punct_base+#)
@z

@x [17.230] l.4752 - MLTeX: char_sub_code_base
  {Note: |math_code(c)| is the true math code plus |min_halfword|}
@y
  {Note: |math_code(c)| is the true math code plus |min_halfword|}
@d char_sub_code(#)==equiv(char_sub_code_base+#)
  {Note: |char_sub_code(c)| is the true substitution info plus |min_halfword|}
@z

@x [232]
cur_font:=null_font; eq_type(cur_font_loc):=data;
eq_level(cur_font_loc):=level_one;@/
@y
for k:=cur_ml_font_loc_base to cur_ml_font_loc_base+mc_max do begin
  equiv(k):=null_font; eq_type(k):=data; eq_level(k):=level_one;
  end;
@z

@x [234]
begin if n=cur_font_loc then print("current font")
else if n<math_font_base+16 then
@y
begin if n=cur_font_loc then print("current font")
else if n<math_font_base then begin
  print("current ml font (mcs "); print_int(n-cur_ml_font_loc_base);
  print(")");
  end
else if n<math_font_base+16 then
@z

@x [235]
  begin if n<lc_code_base then
    begin print_esc("catcode"); print_int(n-cat_code_base);
    end
@y
  begin if n<kinsoku_code_base then
    begin print_esc("catcode");
      if n<ml_cat_code_base then print_int(n-cat_code_base)
      else print_int(get_ml_catcode_code(n-ml_cat_code_base));
    end
  else if n<asc_punct_base then
    begin print_esc("kinsokucode");
      if n<kinsoku_code_base then print_int(n-kinsoku_code_base)
      else print_int(get_ml_kinsoku_code(n-ml_kinsoku_code_base));
    end
  else if n<lc_code_base then
    begin print_esc("asciipunct"); print_int(n-asc_punct_base);
    end
@z

% merged to MuLTeX changes
%@x [17.236] l.4954 - MLTeX: \charsubdefmax and \tracingcharsubdef
%@d int_pars=55 {total number of integer parameters}
%@y
%@d char_sub_def_min_code=55 {smallest value in the charsubdef list}
%@d char_sub_def_max_code=56 {largest value in the charsubdef list}
%@d tracing_char_sub_def_code=57 {traces changes to a charsubdef def}
%@d int_pars=58 {total number of integer parameters}
%@z
%
%@x [17.236] l.5016 - MLTeX: \charsubdefmax and \tracingcharsubdef
%@d error_context_lines==int_par(error_context_lines_code)
%@y
%@d error_context_lines==int_par(error_context_lines_code)
%@d char_sub_def_min==int_par(char_sub_def_min_code)
%@d char_sub_def_max==int_par(char_sub_def_max_code)
%@d tracing_char_sub_def==int_par(tracing_char_sub_def_code)
%@z
%
%@x [17.237] l.5080 - MLTeX: \charsubdefmax and \tracingcharsubdef
%error_context_lines_code:print_esc("errorcontextlines");
%@y
%error_context_lines_code:print_esc("errorcontextlines");
%char_sub_def_min_code:print_esc("charsubdefmin");
%char_sub_def_max_code:print_esc("charsubdefmax");
%tracing_char_sub_def_code:print_esc("tracingcharsubdef");
%@z
%
%@x [17.238] l.5200 - MLTeX: \charsubdefmax and \tracingcharsubdef
%@!@:error_context_lines_}{\.{\\errorcontextlines} primitive@>
%@y
%@!@:error_context_lines_}{\.{\\errorcontextlines} primitive@>
%if mltex_p then
%  begin mltex_enabled_p:=true;  {enable character substitution}
%  if false then {remove the if-clause to enable \.{\\charsubdefmin}}
%  primitive("charsubdefmin",assign_int,int_base+char_sub_def_min_code);@/
%@!@:char_sub_def_min_}{\.{\\charsubdefmin} primitive@>
%  primitive("charsubdefmax",assign_int,int_base+char_sub_def_max_code);@/
%@!@:char_sub_def_max_}{\.{\\charsubdefmax} primitive@>
%  primitive("tracingcharsubdef",assign_int,int_base+tracing_char_sub_def_code);@/
%@!@:tracing_char_sub_def_}{\.{\\tracingcharsubdef} primitive@>
%  end;
%@z

@x MuLTeX: [17.236] new integer param for file and terminal type
@d int_pars=55 {total number of integer parameters}
@y
@d char_sub_def_min_code=55 {smallest value in the charsubdef list}
@d char_sub_def_max_code=56 {largest value in the charsubdef list}
@d tracing_char_sub_def_code=57 {traces changes to a charsubdef def}
@d ml_input_codetype_code=58 {codetype code for multi-lingual input file}
@d base_ml_input_codetype_code=59 {base ...}
@d ml_term_codetype_code=60 {codetype code for multi-lingual terminal}
@d ml_log_codetype_code=61 {codetype code for multi-lingual log file}
@d ml_write_codetype_code=62 {codetype code for multi-lingual output file}
@d ml_spec_codetype_code=63 {codetype code for multi-lingual special}
@d jendline_type_code=64
@d int_pars=65 {total number of integer parameters}
@z

@x MuLTeX: [17.236] 
@d error_context_lines==int_par(error_context_lines_code)
@y
@d error_context_lines==int_par(error_context_lines_code)
@d char_sub_def_min==int_par(char_sub_def_min_code)
@d char_sub_def_max==int_par(char_sub_def_max_code)
@d tracing_char_sub_def==int_par(tracing_char_sub_def_code)
@d ml_input_codetype==int_par(ml_input_codetype_code)
@d base_ml_input_codetype==int_par(base_ml_input_codetype_code)
@d ml_term_codetype==int_par(ml_term_codetype_code)
@d ml_log_codetype==int_par(ml_log_codetype_code)
@d ml_write_codetype==int_par(ml_write_codetype_code)
@d ml_spec_codetype==int_par(ml_spec_codetype_code)
@d jendline_type==int_par(jendline_type_code)
@z

@x MuLTeX: [17.237] changes in print routine
error_context_lines_code:print_esc("errorcontextlines");
@y
error_context_lines_code:print_esc("errorcontextlines");
char_sub_def_min_code:print_esc("charsubdefmin");
char_sub_def_max_code:print_esc("charsubdefmax");
tracing_char_sub_def_code:print_esc("tracingcharsubdef");
ml_input_codetype_code:print_esc("mlinputcodetype");
base_ml_input_codetype_code:print_esc("basemlinputcodetype");
ml_term_codetype_code:print_esc("mltermcodetype");
ml_log_codetype_code:print_esc("mllogcodetype");
ml_write_codetype_code:print_esc("mlwritecodetype");
ml_spec_codetype_code:print_esc("mlspeccodetype");
jendline_type_code:print_esc("jendlinetype");
@z

@x MuLTeX: [17.238] enter them into a hash table
@!@:error_context_lines_}{\.{\\errorcontextlines} primitive@>
@y
@!@:error_context_lines_}{\.{\\errorcontextlines} primitive@>
if mltex_p then
  begin mltex_enabled_p:=true;  {enable character substitution}
  if false then {remove the if-clause to enable \.{\\charsubdefmin}}
  primitive("charsubdefmin",assign_int,int_base+char_sub_def_min_code);@/
@!@:char_sub_def_min_}{\.{\\charsubdefmin} primitive@>
  primitive("charsubdefmax",assign_int,int_base+char_sub_def_max_code);@/
@!@:char_sub_def_max_}{\.{\\charsubdefmax} primitive@>
  primitive("tracingcharsubdef",assign_int,int_base+tracing_char_sub_def_code);@/
@!@:tracing_char_sub_def_}{\.{\\tracingcharsubdef} primitive@>
  end;
primitive("mlinputcodetype",assign_int,int_base+ml_input_codetype_code);@/
@!@:ml_input_codetype_}{\.{\\mlinputcodetype} primitive@>
primitive("basemlinputcodetype",assign_int,int_base+base_ml_input_codetype_code);@/
@!@:base_ml_input_codetype_}{\.{\\basemlinputcodetype} primitive@>
primitive("mltermcodetype",assign_int,int_base+ml_term_codetype_code);@/
@!@:ml_term_codetype_}{\.{\\mltermcodetype} primitive@>
primitive("mllogcodetype",assign_int,int_base+ml_log_codetype_code);@/
@!@:ml_log_codetype_}{\.{\\mllogcodetype} primitive@>
primitive("mlwritecodetype",assign_int,int_base+ml_write_codetype_code);@/
@!@:ml_write_codetype_}{\.{\\mlwritecodetype} primitive@>
primitive("mlspeccodetype",assign_int,int_base+ml_spec_codetype_code);@/
@!@:ml_spec_codetype_}{\.{\\mlspeccodetype} primitive@>
primitive("jendlinetype",assign_int,int_base+jendline_type_code);@/
@!@:jendline_type_}{\.{\\jendlinetype} primitive@>
@z

@x [17.240] l.5213 - MLTeX: \charsubdefmax and \tracingcharsubdef
for k:=int_base to del_code_base-1 do eqtb[k].int:=0;
@y
for k:=int_base to del_code_base-1 do eqtb[k].int:=0;
char_sub_def_min:=256; char_sub_def_max:=-1;
{allow \.{\\charsubdef} for char 0}@/
{|tracing_char_sub_def:=0| is already done}@/
@z

@x [17.241] l.5219 - Do `fix_date_and_time' in C.
@ The following procedure, which is called just before \TeX\ initializes its
input and output, establishes the initial values of the date and time.
@^system dependencies@>
Since standard \PASCAL\ cannot provide such information, something special
is needed. The program here simply specifies July 4, 1776, at noon; but
users probably want a better approximation to the truth.

@p procedure fix_date_and_time;
begin time:=12*60; {minutes since midnight}
day:=4; {fourth day of the month}
month:=7; {seventh month of the year}
year:=1776; {Anno Domini}
end;
@y
@ The following procedure, which is called just before \TeX\ initializes its
input and output, establishes the initial values of the date and time.
It calls a macro-defined |date_and_time| routine.  |date_and_time|
in turn is a C macro, which calls |get_date_and_time|, passing
it the addresses of the day, month, etc., so they can be set by the
routine.  |get_date_and_time| also sets up interrupt catching if that
is conditionally compiled in the C code.
@^system dependencies@>

@d fix_date_and_time==date_and_time(time,day,month,year)
@z

@x [17.252] l.5420 - hash_extra
else if n<glue_base then @<Show equivalent |n|, in region 1 or 2@>
@y
else if (n<glue_base) or ((n>eqtb_size)and(n<=eqtb_top)) then
  @<Show equivalent |n|, in region 1 or 2@>
@z

@x [17.253] l.5435 - Change eqtb to zeqtb.
@!eqtb:array[active_base..eqtb_size] of memory_word;
@y
@!zeqtb:^memory_word;
@z

@x [18.256] l.5483 - hash_extra
@!hash: array[hash_base..undefined_control_sequence-1] of two_halves;
  {the hash table}
@!hash_used:pointer; {allocation pointer for |hash|}
@y
@!hash: ^two_halves; {the hash table}
@!yhash: ^two_halves; {auxiliary pointer for freeing hash}
@!hash_used:pointer; {allocation pointer for |hash|}
@!hash_extra:pointer; {|hash_extra=hash| above |eqtb_size|}
@!hash_top:pointer; {maximum of the hash array}
@!eqtb_top:pointer; {maximum of the |eqtb|}
@!hash_high:pointer; {pointer to next high hash location}
@z

@x [18.257] l.5491 - hash_extra
next(hash_base):=0; text(hash_base):=0;
for k:=hash_base+1 to undefined_control_sequence-1 do hash[k]:=hash[hash_base];
@y
@z

@x [18.258] l.5495 - hash_extra
hash_used:=frozen_control_sequence; {nothing is used}
@y
hash_used:=frozen_control_sequence; {nothing is used}
hash_high:=0;
@z

@x [18.259] MuLTeX: buffer and str_pool
@!k:pointer; {index in |buffer| array}
begin @<Compute the hash code |h|@>;
p:=h+hash_base; {we start searching here; note that |0<=h<hash_prime|}
loop@+begin if text(p)>0 then if length(text(p))=l then
    if str_eq_buf(text(p),j) then goto found;
@y
@!k:pointer; {index in |buffer| array}
@!n:pointer; {index in |str_buffer| array}
begin @<Convert |buffer| string to |str_pool| string@>;
@<Compute the hash code |h|@>;
p:=h+hash_base; {we start searching here; note that |0<=h<hash_prime|}
loop@+begin if text(p)>0 then if length(text(p))=l then
    if str_eq_buf(text(p),0) then goto found;
@z

@x [18.260] l.5531 - hash_extra
@ @<Insert a new control...@>=
begin if text(p)>0 then
  begin repeat if hash_is_full then overflow("hash size",hash_size);
@:TeX capacity exceeded hash size}{\quad hash size@>
  decr(hash_used);
  until text(hash_used)=0; {search for an empty location in |hash|}
  next(p):=hash_used; p:=hash_used;
  end;
@y
@ @<Insert a new control...@>=
begin if text(p)>0 then
  begin if hash_high<hash_extra then
      begin incr(hash_high);
      next(p):=hash_high+eqtb_size; p:=hash_high+eqtb_size;
      end
    else begin
      repeat if hash_is_full then overflow("hash size",hash_size+hash_extra);
@:TeX capacity exceeded hash size}{\quad hash size@>
      decr(hash_used);
      until text(hash_used)=0; {search for an empty location in |hash|}
    next(p):=hash_used; p:=hash_used;
    end;
  end;
@z

@x [18.260] MuLTeX: buffer and str_pool
for k:=j to j+l-1 do append_char(buffer[k]);
@y
for k:=0 to l-1 do append_char(str_buffer[k]);
@z

@x [18.261] MuLTeX: buffer and str_pool
@<Compute the hash code |h|@>=
h:=buffer[j];
for k:=j+1 to j+l-1 do
  begin h:=h+h+buffer[k];
@y
@<Compute the hash code |h|@>=
h:=str_buffer[0];
for k:=1 to l-1 do
  begin h:=h+h+str_buffer[k];
@z

@x [18.262] l.5583 - hash_extra
else if p>=undefined_control_sequence then print_esc("IMPOSSIBLE.")
@y
else if ((p>=undefined_control_sequence)and(p<=eqtb_size))or(p>eqtb_top) then
  print_esc("IMPOSSIBLE.")
@z

@x [18.262] l.5584 - Remove more unsigned comparisons to zero.
else if (text(p)<0)or(text(p)>=str_ptr) then print_esc("NONEXISTENT.")
@y
else if (text(p)>=str_ptr) then print_esc("NONEXISTENT.")
@z

@x [18.263] MuLTeX
begin if p<hash_base then
  if p<single_base then print(p-active_base)
  else  if p<null_cs then print_esc(p-single_base)
@y
begin if p<hash_base then
  if p<ml_active_base then print(p-active_base)
  else  if p<single_base then print_esc(p-ml_active_base)
  else  if p<null_cs then print_esc(p-single_base)
@z

@x [18.265] MuLTeX: mlfont primitive
primitive("font",def_font,0);@/
@!@:font_}{\.{\\font} primitive@>
@y
primitive("font",def_font,0);@/
@!@:font_}{\.{\\font} primitive@>
primitive("mlfont",def_font,1);@/
@!@:mlfont_}{\.{\\mlfont} primitive@>
@z
@x [18.266] MuLTeX: mlfont primitive
def_font: print_esc("font");
@y
def_font: if chr_code=0 then print_esc("font")
  else print_esc("mlfont");
@z

@x [19.271] l.5872 - texarray
@!save_stack : array[0..save_size] of memory_word;
@y
@!save_stack : ^memory_word;
@z

@x [19.275] delayed, MuLTeX:
box_ref: flush_node_list(equiv_field(w));
othercases do_nothing
@y
box_ref: flush_node_list(equiv_field(w));
@<Cases of |eq_destroy| for additional ref-type box in |equiv_field|@>
othercases do_nothing
@z

@x [19.279] delayed, MuLTeX:
Global definitions are done in almost the same way, but there is no need
to save old values, and the new value is associated with |level_one|.
@y
Global definitions are done in almost the same way, but there is no need
to save old values, and the new value is associated with |level_one|.
We also introduce destructive definition |deq_define|.
@z

@x [19.279] delayed, MuLTeX:
procedure geq_word_define(@!p:pointer;@!w:integer); {global |eq_word_define|}
begin eqtb[p].int:=w; xeq_level[p]:=level_one;
end;
@y
procedure geq_word_define(@!p:pointer;@!w:integer); {global |eq_word_define|}
begin eqtb[p].int:=w; xeq_level[p]:=level_one;
end;
@#
procedure deq_define(@!p:pointer;@!t:quarterword;@!e:halfword);
begin eq_destroy(eqtb[p]);
eq_type(p):=t; equiv(p):=e;
end;
@z

@x [19.283] l.6050 - hash_extra
if p<int_base then
@y
if (p<int_base)or(p>eqtb_size) then
@z

@x MuLTeX: [20.289] ml-letter token
The following definitions take care of these token-oriented constants
and a few others.

@y
The following definitions take care of these token-oriented constants
and a few others.

@d mletter_cat_flag==@"1000000
@d is_mltok(#)==is_mlrep(#)
@d make_mltok(#)==(#)*mletter_cat_flag+make_mlt_end
@d make_mlt_end(#)==(#)
@d mltok_cat(#)==((#) div mletter_cat_flag)
@d mltok_rep(#)==((#) mod mletter_cat_flag)
@z

@x MuLTeX: [20.290]
@ @<Check the ``constant''...@>=
if cs_token_flag+undefined_control_sequence>max_halfword then bad:=21;
@y
@ @<Check the ``constant''...@>=
if cs_token_flag+undefined_control_sequence>=mletter_rep_flag then bad:=21;
if (hash_offset<0)or(hash_offset>hash_base) then bad:=42;
@z
%????
%@x [20.290] l.6158 - hash_extra
%if cs_token_flag+undefined_control_sequence>max_halfword then bad:=21;
%@y
%if cs_token_flag+eqtb_size+hash_extra>max_halfword then bad:=21;
%if (hash_offset<0)or(hash_offset>hash_base) then bad:=42;
%@z

@x MuLTeX: [20.292]
begin match_chr:="#"; n:="0"; tally:=0;
while (p<>null) and (tally<l) do
  begin if p=q then @<Do magic computation@>;
@y
begin match_chr:="#"; n:="0"; tally:=0; tally_disp:=0;
while (p<>null) and (tally<l) do
  begin if p=q then @<Do magic computation@>;
@z

@x MuLTeX: [20.293] insert printing of japanese letter token
@ @<Display token |p|...@>=
if (p<hi_mem_min) or (p>mem_end) then
  begin print_esc("CLOBBERED."); return;
@.CLOBBERED@>
  end;
if info(p)>=cs_token_flag then print_cs(info(p)-cs_token_flag)
@y
@ @<Display token |p|...@>=
if (p<hi_mem_min) or (p>mem_end) then
  begin print_esc("CLOBBERED."); return;
@.CLOBBERED@>
  end;
if is_mltok(info(p)) then print_char(mltok_rep(info(p)))
else if info(p)>=cs_token_flag then print_cs(info(p)-cs_token_flag)
@z

@x MuLTeX: [21.298] new cases for |print_cmd_chr|
other_char: chr_cmd("the character ");
@y
other_char: chr_cmd("the character ");
jletter: begin print("the multi-lingual letter ");
  print_char(chr_code);
  end;
@z

@x [22.301] l.6432 - texarray
@!input_stack : array[0..stack_size] of in_state_record;
@y
@!input_stack : ^in_state_record;
@z

@x [22.304] l.6536 - texarray; additions for file:line:error style. MuLTeX
@!input_file : array[1..max_in_open] of alpha_file;
@!line : integer; {current line number in the current source file}
@!line_stack : array[1..max_in_open] of integer;
@y
@!input_file : ^alpha_file;
@!line : integer; {current line number in the current source file}
@!line_stack : ^integer;
@!source_filename_stack : ^str_number;
@!full_source_filename_stack : ^str_number;
@!ml_input_codetype_stack : ^memory_word;
@z

@x [22.306] l.6855 - i18n fix
  begin print_nl("Runaway ");
@.Runaway...@>
  case scanner_status of
  defining: begin print("definition"); p:=def_ref;
    end;
  matching: begin print("argument"); p:=temp_head;
    end;
  aligning: begin print("preamble"); p:=hold_head;
    end;
  absorbing: begin print("text"); p:=def_ref;
    end;
  end; {there are no other cases}
@y
  begin
@.Runaway...@>
  case scanner_status of
  defining: begin print_nl("Runaway definition"); p:=def_ref;
    end;
  matching: begin print_nl("Runaway argument"); p:=temp_head;
    end;
  aligning: begin print_nl("Runaway preamble"); p:=hold_head;
    end;
  absorbing: begin print_nl("Runaway text"); p:=def_ref;
    end;
  end; {there are no other cases}
@z

@x [22.308] l.6701 - texarray
@!param_stack:array [0..param_size] of pointer;
  {token list pointers for parameters}
@y
@!param_stack: ^pointer;
  {token list pointers for parameters}
@z

@x MuLTeX: [22.312]
  begin tally:=0; {get ready to count characters}
  old_setting:=selector;
@y
  begin tally:=0; tally_disp:=0; {get ready to count characters}
  old_setting:=selector;
@z

@x MuLTeX: [22.315]
@!p: integer; {starting or ending place in |trick_buf|}
@!q: integer; {temporary index}
@y
@!p: integer; {starting or ending place in |trick_buf|}
@!q,r: integer; {temporary index}
@z

@x MuLTeX: [22.316]
@d set_trick_count==
  begin first_count:=tally;
  trick_count:=tally+1+error_line-half_error_line;
  if trick_count<error_line then trick_count:=error_line;
  end
@y
@d set_trick_count==
  begin first_count:=tally; first_count_disp:=tally_disp;
  trick_count:=tally_disp+1+error_line-half_error_line;
  if trick_count<error_line then trick_count:=error_line;
  end
@z

@x MuLTeX: [22.317]
if tally<trick_count then m:=tally-first_count
else m:=trick_count-first_count; {context on line 2}
if l+first_count<=half_error_line then
  begin p:=0; n:=l+first_count;
  end
else  begin print("..."); p:=l+first_count-half_error_line+3;
  n:=half_error_line;
  end;
for q:=p to first_count-1 do print_char(trick_buf[q mod error_line]);
print_ln;
for q:=1 to n do print_char(" "); {print |n| spaces to begin line~2}
if m+n<=error_line then p:=first_count+m else p:=first_count+(error_line-n-3);
for q:=first_count to p-1 do print_char(trick_buf[q mod error_line]);
if m+n>error_line then print("...")
@y
if tally_disp<trick_count then m:=tally_disp-first_count_disp
else m:=trick_count-first_count_disp; {context on line 2}
{l=displayed length of chars before first_count}
if l+first_count_disp<=half_error_line then
  begin n:=l+first_count_disp; r:=n-l;
  end
else  begin print("...");
  n:=half_error_line; r:=n-3-l;
  end;
@<Print the first line of tricky pseudoprint@>;
print_ln;
for q:=1 to r do print_char(" "); {print |n| or |n-1| spaces to begin line~2}
if m+n<=error_line then r:=m else r:=error_line-n-3;
@<Print the second line of tricky pseudoprint@>;
if m+n>error_line then print("...")
@z

@x MuLTeX: [22.318] 8bit
@<Pseudoprint the line@>=
begin_pseudoprint;
if buffer[limit]=end_line_char then j:=limit
else j:=limit+1; {determine the effective end of the line}
if j>0 then for i:=start to j-1 do
  begin if i=loc then set_trick_count;
  print(buffer[i]);
  end
@y
@<Pseudoprint the line@>=
begin_pseudoprint;
@<Determin the effective end of the line@>;
if j>0 then for i:=start to j-1 do
  begin if i=loc then set_trick_count;
  if is_mlrep(buffer[i]) then print_char(buffer[i])
  else print(buffer[i]);
  end
@z

@x [23.328] MuLTeX
incr(in_open); push_input; index:=in_open;
line_stack[index]:=line; start:=first; state:=mid_line;
@y
incr(in_open); push_input; index:=in_open;
line_stack[index]:=line; start:=first; state:=mid_line;
ml_input_codetype_stack[index].int:=ml_input_codetype;
@z

@x [23.329] MuLTeX
begin first:=start; line:=line_stack[index];
@y
begin first:=start; line:=line_stack[index];
ml_input_codetype:=ml_input_codetype_stack[index].int;
@z

@x [24.338] l.7164 - i18n fix
print(" while scanning ");
@y
@z

@x [24.339] l.7185 - i18n fix
defining:begin print("definition"); info(p):=right_brace_token+"}";
  end;
matching:begin print("use"); info(p):=par_token; long_state:=outer_call;
  end;
aligning:begin print("preamble"); info(p):=right_brace_token+"}"; q:=p;
  p:=get_avail; link(p):=q; info(p):=cs_token_flag+frozen_cr;
  align_state:=-1000000;
  end;
absorbing:begin print("text"); info(p):=right_brace_token+"}";
@y
defining:begin print(" while scanning definition"); info(p):=right_brace_token+"}";
  end;
matching:begin print(" while scanning use"); info(p):=par_token; long_state:=outer_call;
  end;
aligning:begin print(" while scanning preamble"); info(p):=right_brace_token+"}"; q:=p;
  p:=get_avail; link(p):=q; info(p):=cs_token_flag+frozen_cr;
  align_state:=-1000000;
  end;
absorbing:begin print(" while scanning text"); info(p):=right_brace_token+"}";
@z

@x MuLTeX: [24.341] procedure get_next
var k:0..buf_size; {an index into |buffer|}
@!t:halfword; {a token}
@!cat:0..15; {|cat_code(cur_chr)|, usually}
@!c,@!cc:ASCII_code; {constituents of a possible expanded code}
@!d:2..3; {number of excess characters in an expanded code}
@y
var k:0..buf_size; {an index into |buffer|}
@!t:halfword; {a token}
@!cat:escape..max_char_code; {|cat_code(cur_chr)|, usually}
@!c,@!cc:ASCII_code; {constituents of a possible expanded code}
@!d:2..3; {number of excess characters in an expanded code}
@!cur_mlcat_idx:integer;
@!jletter_endline:boolean; {true when a line ends with jletter}
@z

@x MuLTeX: [24.343] process delayed cat_ret
begin switch: if loc<=limit then {current line not yet finished}
  begin cur_chr:=buffer[loc]; incr(loc);
  reswitch: cur_cmd:=cat_code(cur_chr);
@y
begin switch: if loc<=limit then {current line not yet finished}
  begin cur_chr:=buffer[loc]; incr(loc);
    @<Read a multi-lingual char and set |cur_cmd|@>;
    @<Restore delayed |cat_ret| and return, if appropriate@>;
  reswitch:
@z

@x [24.347] MuLTeX
@ @d add_delims_to(#)==#+math_shift,#+tab_mark,#+mac_param,
  #+sub_mark,#+letter,#+other_char
@y
@ @d add_delims_to(#)==#+math_shift,#+tab_mark,#+mac_param,
  #+sub_mark,#+letter,#+other_char,#+jletter
@z

@x MuLTeX: [24.347] ignore or delay |car_ret|
mid_line+car_ret:@<Finish line, emit a space@>;
@y
mid_line+car_ret:@<Check if the last character of the line is japanese,
  change state, and finish line@>;
@z

@x MuLTeX: [24.352]
    if is_hex(c) then if loc<=limit then
      begin cc:=buffer[loc]; @+if is_hex(cc) then
        begin incr(loc); hex_to_cur_chr; goto reswitch;
        end;
      end;
    if c<@'100 then cur_chr:=c+@'100 @+else cur_chr:=c-@'100;
    goto reswitch;
@y
    if is_hex(c) then if loc<=limit then
      begin cc:=buffer[loc]; @+if is_hex(cc) then
        begin incr(loc); hex_to_cur_chr;
          cur_cmd:=cat_code(cur_chr); goto reswitch;
        end;
      end;
    if c<@'100 then cur_chr:=c+@'100 @+else cur_chr:=c-@'100;
    cur_cmd:=cat_code(cur_chr); goto reswitch;
@z

@x [24.353] MuLTeX
begin cur_cs:=cur_chr+active_base;
@y
begin if is_mlrep(cur_chr) then cur_cs:=cur_mlcat_idx+ml_active_base
else cur_cs:=cur_chr+active_base;
@z

@x MuLTeX: [24.354] allow japanese letters in control sequence name
else  begin start_cs: k:=loc; cur_chr:=buffer[k]; cat:=cat_code(cur_chr);
  incr(k);
  if cat=letter then state:=skip_blanks
  else if cat=spacer then state:=skip_blanks
  else state:=mid_line;
  if (cat=letter)and(k<=limit) then
@y
else  begin start_cs: k:=loc; cur_chr:=buffer[k];
  @<Check a multi-lingual char in control sequence name@>;
  if not is_mlrep(cur_chr) then incr(k);
  if (cat=letter) or (cat=jletter) then state:=skip_blanks
  else if cat=spacer then state:=skip_blanks
  else state:=mid_line;
  if ((cat=letter) or is_mlrep(cur_chr)) and (k<=limit) then
@z

@x MuLTeX: [24.356] allow japanese letters in control sequence name
begin repeat cur_chr:=buffer[k]; cat:=cat_code(cur_chr); incr(k);
until (cat<>letter)or(k>limit);
@<If an expanded...@>;
if cat<>letter then decr(k);
  {now |k| points to first nonletter}
if k>loc+1 then {multiletter control sequence has been scanned}
@y
begin repeat cur_chr:=buffer[k];
 @<Check a multi-lingual char in control sequence name@>;
 incr(k);
until ((cat<>letter) and (cat<>jletter)) or (k>limit);
@<If an expanded...@>;
if (cat<>letter) and (cat<>jletter) then decr(k);
  {now |k| points to first nonletter}
if (k>loc+1) or is_mlrep(buffer[loc]) then {multiletter control sequence has been scanned}
@z

@x MuLTeX: [24.357] you must count for japanese letter token
  begin t:=info(loc); loc:=link(loc); {move to next}
  if t>=cs_token_flag then {a control sequence token}
@y
  begin t:=info(loc); loc:=link(loc); {move to next}
  if is_mltok(t) then begin cur_cmd:=mltok_cat(t); cur_chr:=mltok_rep(t) end
  else if t>=cs_token_flag then {a control sequence token}
@z

@x MuLTeX: [24.358]
begin cur_cs:=info(loc)-cs_token_flag; loc:=null;@/
cur_cmd:=eq_type(cur_cs); cur_chr:=equiv(cur_cs);
if cur_cmd>max_command then
  begin cur_cmd:=relax; cur_chr:=no_expand_flag;
  end;
end
@y
begin t:=info(loc); loc:=null;@/
if is_mltok(t) then begin cur_cmd:=mltok_cat(t); cur_chr:=mltok_rep(t) end
else begin cur_cs:=t-cs_token_flag;
cur_cmd:=eq_type(cur_cs); cur_chr:=equiv(cur_cs);
if cur_cmd>max_command then
  begin cur_cmd:=relax; cur_chr:=no_expand_flag;
  end;
end
end
@z

@x MuLTeX: [24.360]
else  begin if not terminal_input then {\.{\\read} line has ended}
    begin cur_cmd:=0; cur_chr:=0; return;
    end;
@y
else  begin
    if delayed_cat_ret then
      @<Emit a space, |delayed_cat_ret:=false|, and return@>;
    if not terminal_input then {\.{\\read} line has ended}
    begin cur_cmd:=0; cur_chr:=0; return;
    end;
@z

@x 8bit: [24.360]
    if end_line_char_inactive then decr(limit)
    else  buffer[limit]:=end_line_char;
@y
    @<Put the end-of-line-char if it is active@>;
@z

@x MuLTeX: [24.362]
if not force_eof then
  begin if input_ln(cur_file,true) then {not end of file}
    firm_up_the_line {this sets |limit|}
  else force_eof:=true;
  end;
@y
if not force_eof then
  begin if input_ln(cur_file,true) then {not end of file}
    firm_up_the_line {this sets |limit|}
  else if delayed_cat_ret {and (scanner_status=matching)} then begin
    decr(line); loc:=limit+1;
    @<Emit a space, |delayed_cat_ret:=false|, and return@>;
    end
  else force_eof:=true;
  end;
@z

@x 8bit: [24.362]
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the end-of-line-char if it is active@>;
@z

@x JTeX: [24.365] modify the computation of |cur_tok|
begin no_new_control_sequence:=false; get_next; no_new_control_sequence:=true;
@^inner loop@>
if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
begin no_new_control_sequence:=false; get_next; no_new_control_sequence:=true;
@^inner loop@>
if cur_cs=0 then begin
  if is_mlrep(cur_chr) then cur_tok:=make_mltok(cur_cmd)(cur_chr)
  else cur_tok:=(cur_cmd*@'400)+cur_chr;
  end
else cur_tok:=cs_token_flag+cur_cs;
@z

@x MuLTeX, 8bit: [25.374] take into account japanese letter csname
while p<>null do
  begin if j>=max_buf_stack then
    begin max_buf_stack:=j+1;
    if max_buf_stack=buf_size then
      overflow("buffer size",buf_size);
@:TeX capacity exceeded buffer size}{\quad buffer size@>
    end;
  buffer[j]:=info(p) mod @'400; incr(j); p:=link(p);
  end;
if j>first+1 then
@y
while p<>null do
  begin if j+1>=max_buf_stack then
    begin max_buf_stack:=j+2;
    if max_buf_stack=buf_size then
      overflow("buffer size",buf_size);
@:TeX capacity exceeded buffer size}{\quad buffer size@>
    end;
  if is_mltok(info(p)) then buffer[j]:=mltok_rep(info(p))
  else buffer[j]:=info(p) mod @'400;
  incr(j); p:=link(p);
  end;
if (j>first+1) or ((j>first) and is_mlrep(buffer[first])) then
@z

@x MuLTeX: [25.380] take into account japanese letter token
done: if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
done: if cur_cs=0 then begin
  if is_mlrep(cur_chr) then cur_tok:=make_mltok(cur_cmd)(cur_chr)
  else cur_tok:=(cur_cmd*@'400)+cur_chr;
  end
else cur_tok:=cs_token_flag+cur_cs;
@z

@x MuLTeX: [25.381] take into account japanese letter token
  begin expand;
  get_next;
  end;
if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
  begin expand;
  get_next;
  end;
if cur_cs=0 then begin
  if is_mlrep(cur_chr) then cur_tok:=make_mltok(cur_cmd)(cur_chr)
  else cur_tok:=(cur_cmd*@'400)+cur_chr;
  end
else cur_tok:=cs_token_flag+cur_cs;
@z

@x [26.413] delayed:
toks_register,assign_toks,def_family,set_font,def_font: @<Fetch a token list or
  font identifier, provided that |level=tok_val|@>;
@y
toks_register,assign_toks,def_family,set_font,def_font,def_dfont:
  @<Fetch a token list or font identifier, provided that |level=tok_val|@>;
demmand_font: scanned_result(cur_cs)(ident_val);
@z
@x [26.413] MuLTeX
assign_font_int: @<Fetch a font integer@>;
@y
assign_font_int: @<Fetch a font integer@>;
assign_font_mcs: @<Fetch a font mcs@>;
@z

@x [26.414] MuLTeX
@ @<Fetch a character code from some table@>=
begin scan_char_num;
@y
@ @<Fetch a character code from some table@>=
begin
if m=cat_code_base then begin scan_j_char_num;
  if is_mlrep(cur_val) then begin m:=ml_cat_code_base;
    cur_val:=get_ml_catcode_idx(cur_val);
    end;
  end
else if m=kinsoku_code_base then begin scan_j_char_num;
  if is_mlrep(cur_val) then begin m:=ml_kinsoku_code_base;
    cur_val:=get_ml_kinsoku_idx(cur_val);
    end;
  end
else scan_char_num;
@z

@x MuLTeX: [26.440]
@!OK_so_far:boolean; {has an error message been issued?}
@y
@!OK_so_far:boolean; {has an error message been issued?}
@!jletter_const:boolean;
@z

@x JTeX: [26.442] allow Japanese after `
begin get_token; {suppress macro expansion}
if cur_tok<cs_token_flag then
  begin cur_val:=cur_chr;
  if cur_cmd<=right_brace then
    if cur_cmd=right_brace then incr(align_state)
    else decr(align_state);
  end
else if cur_tok<cs_token_flag+single_base then
  cur_val:=cur_tok-cs_token_flag-active_base
else cur_val:=cur_tok-cs_token_flag-single_base;
if cur_val>255 then
  begin print_err("Improper alphabetic constant");
@.Improper alphabetic constant@>
  help2("A one-character control sequence belongs after a ` mark.")@/
    ("So I'm essentially inserting \0 here.");
  cur_val:="0"; back_error;
  end
else @<Scan an optional space@>;
end
@y
begin get_token; {suppress macro expansion}
jletter_const:=false;
if is_mlrep(cur_tok) then begin
  cur_val:= cur_chr;
  jletter_const:=true
  end
else if cur_tok<cs_token_flag then
  begin cur_val:=cur_chr;
  if cur_cmd<=right_brace then
    if cur_cmd=right_brace then incr(align_state)
    else decr(align_state);
  end
else if cur_tok<cs_token_flag+single_base then begin
  if cur_tok<cs_token_flag+ml_active_base then
    cur_val:=cur_tok-cs_token_flag-active_base
  else begin jletter_const:=true;
    cur_val:=get_ml_catcode_code(cur_tok-cs_token_flag-ml_active_base);
    end;
  end
else cur_val:=cur_tok-cs_token_flag-single_base;
if (not jletter_const) and (cur_val>255) then
  begin print_err("Improper alphabetic or multi-lingual constant");
@.Improper alphabetic or multi-lingual constant@>
  help2("A one-character control sequence belongs after a ` mark.")@/
    ("So I'm essentially inserting \0 here.");
  cur_val:="0"; back_error;
  end
else @<Scan an optional space@>;
end
@z

@x MuLTeX: [26.455] zw, zh
if scan_keyword("em") then v:=(@<The em width for |cur_font|@>)
@.em@>
else if scan_keyword("ex") then v:=(@<The x-height for |cur_font|@>)
@.ex@>
@y
if scan_keyword("em") then v:=(@<The em width for |cur_font|@>)
@.em@>
else if scan_keyword("ex") then v:=(@<The x-height for |cur_font|@>)
@.ex@>
else if scan_keyword("zw") then v:=(@<The zw width for current jfont@>)
@.zw@>
else if scan_keyword("zh") then v:=(@<The zh height for current jfont@>)
@.zh@>
@z

@x MuLTeX: [27.464] convert japanese string into a token list
  if t=" " then t:=space_token
  else t:=other_token+t;
@y
  @<get token of a char from |str_pool|@>;
@z

@x JTeX: [27.468] number returning primitives for JTeX
@d job_name_code=5 {command code for \.{\\jobname}}

@<Put each...@>=
primitive("number",convert,number_code);@/
@!@:number_}{\.{\\number} primitive@>
primitive("romannumeral",convert,roman_numeral_code);@/
@!@:roman_numeral_}{\.{\\romannumeral} primitive@>
primitive("string",convert,string_code);@/
@!@:string_}{\.{\\string} primitive@>
primitive("meaning",convert,meaning_code);@/
@!@:meaning_}{\.{\\meaning} primitive@>
primitive("fontname",convert,font_name_code);@/
@!@:font_name_}{\.{\\fontname} primitive@>
primitive("jobname",convert,job_name_code);@/
@!@:job_name_}{\.{\\jobname} primitive@>
@y
@d job_name_code=5 {command code for \.{\\jobname}}
@d mlchar_internal_code=6 {command code for \.{\\mlcharinternal}}
@d mlchar_mcs_code=7 {command code for \.{\\mlcharmcs}}
@d mlchar_code_code=8 {command code for \.{\\mlcharcode}}

@<Put each...@>=
primitive("number",convert,number_code);@/
@!@:number_}{\.{\\number} primitive@>
primitive("romannumeral",convert,roman_numeral_code);@/
@!@:roman_numeral_}{\.{\\romannumeral} primitive@>
primitive("string",convert,string_code);@/
@!@:string_}{\.{\\string} primitive@>
primitive("meaning",convert,meaning_code);@/
@!@:meaning_}{\.{\\meaning} primitive@>
primitive("fontname",convert,font_name_code);@/
@!@:font_name_}{\.{\\fontname} primitive@>
primitive("jobname",convert,job_name_code);@/
@!@:job_name_}{\.{\\jobname} primitive@>
primitive("mlcharinternal",convert,mlchar_internal_code);@/
@!@:mlchar_internal_}{\.{\\mlcharinternal} primitive@>
primitive("mlcharmcs",convert,mlchar_mcs_code);@/
@!@:mlchar_mcs_}{\.{\\mlcharmcs} primitive@>
primitive("mlcharcode",convert,mlchar_code_code);@/
@!@:mlchar_code_}{\.{\\mlcharcode} primitive@>
@z

@x MuLTeX: [27.469] print routine
  othercases print_esc("jobname")
@y
  job_name_code: print_esc("jobname");
  mlchar_internal_code: print_esc("mlcharinternal");
  mlchar_mcs_code: print_esc("mlcharmcs");
  mlchar_code_code: print_esc("mlcharcode");
  othercases print_esc("unknown")
@z

@x MuLTeX: [27.470] variable range change
@!c:number_code..job_name_code; {desired type of conversion}
@y
@!c:number_code..mlchar_code_code; {desired type of conversion}
@z

@x MuLTeX: [27.471] new addition to cases
number_code,roman_numeral_code: scan_int;
@y
number_code,roman_numeral_code,
mlchar_internal_code,mlchar_mcs_code,mlchar_code_code: scan_int;
@z

@x MuLTeX: [27.472] result of added command
job_name_code: print(job_name);
@y
job_name_code: print(job_name);
mlchar_internal_code: print_int(cur_val);
mlchar_mcs_code: print_int(mlrep_mc(cur_val));
mlchar_code_code: print_int(mlrep_char(cur_val));
@z

@x 8bit: [483]
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the end-of-line-char if it is active@>;
@z

% MuLTeX: ifcat and if
% when get_next, cur_cmd will not be active_char
@x [28.506] MuLTeX
    begin cur_cmd:=active_char;
    cur_chr:=cur_tok-cs_token_flag-active_base;
@y
    begin cur_cmd:=active_char;
    cur_chr:=cur_tok-cs_token_flag-active_base;
    if cur_chr>255 then begin
      if cur_chr<=256+max_ml_catcode_idx then
        cur_chr:=get_ml_catcode_code(cur_chr-256)
      else
        cur_chr:=256; {cf. def of primitive \.{\\par} par_end=active_char}
      end
@z
@x MuLTeX: [28.506] make \ifcat & \if work for kanji(added on 28-Jan-88)
if (cur_cmd>active_char)or(cur_chr>255) then {not a character}
  begin m:=relax; n:=256;
  end
else  begin m:=cur_cmd; n:=cur_chr;
  end;
get_x_token_or_active_char;
if (cur_cmd>active_char)or(cur_chr>255) then
  begin cur_cmd:=relax; cur_chr:=256;
  end;
@y
if (cur_cmd>active_char) and (cur_cmd<>jletter) then {not a character}
  begin m:=relax; n:=256;
  end
else  begin m:=cur_cmd; n:=cur_chr;
  end;
get_x_token_or_active_char;
if (cur_cmd>active_char) and (cur_cmd<>jletter) then
  begin cur_cmd:=relax; cur_chr:=256;
  end;
@z

@x [29.513] l.9951 - Area and extension rules for filenames.
@ The file names we shall deal with for illustrative purposes have the
following structure:  If the name contains `\.>' or `\.:', the file area
consists of all characters up to and including the final such character;
otherwise the file area is null.  If the remaining file name contains
`\..', the file extension consists of all such characters from the first
remaining `\..' to the end, otherwise the file extension is null.
@y
@ The file names we shall deal with have the
following structure:  If the name contains `\./' or `\.:'
(for Amiga only), the file area
consists of all characters up to and including the final such character;
otherwise the file area is null.  If the remaining file name contains
`\..', the file extension consists of all such characters from the last
`\..' to the end, otherwise the file extension is null.
@z

@x [29.513] l.9963 - Area and extension rules for filenames.
@!area_delimiter:pool_pointer; {the most recent `\.>' or `\.:', if any}
@!ext_delimiter:pool_pointer; {the relevant `\..', if any}
@y
@!area_delimiter:pool_pointer; {the most recent `\./', if any}
@!ext_delimiter:pool_pointer; {the most recent `\..', if any}
@z

@x [29.514] l.9973 - TeX area directories.
@d TEX_area=="TeXinputs:"
@.TeXinputs@>
@d TEX_font_area=="TeXfonts:"
@.TeXfonts@>
@y
In C, the default paths are specified separately.
@z

@x [29.516] l.9992 - filenames: more_name
begin if c=" " then more_name:=false
@y
begin if stop_at_space and (c=" ") then more_name:=false
@z

@x [29.516] l.9994 - filenames: more_name
  if (c=">")or(c=":") then
@y
  if IS_DIR_SEP(c) then
@z

@x [29.516] l.9997 - filenames: more_name
  else if (c=".")and(ext_delimiter=0) then ext_delimiter:=cur_length;
@y
  else if c="." then ext_delimiter:=cur_length;
@z

@x [29.517] l.10002 - end_name: string recycling
@ The third.
@^system dependencies@>

@p procedure end_name;
@y
@ The third.
@^system dependencies@>
If a string is already in the string pool, the function
|slow_make_string| does not create a new string but returns this string
number, thus saving string space.  Because of this new property of the
returned string number it is not possible to apply |flush_string| to
these strings.

@p procedure end_name;
var temp_str: str_number; {result of file name cache lookups}
@!j: pool_pointer; {running index}
@z

@x [29.517] l.10011 - end_name: string recycling
  str_start[str_ptr+1]:=str_start[str_ptr]+area_delimiter; incr(str_ptr);
  end;
if ext_delimiter=0 then
  begin cur_ext:=""; cur_name:=make_string;
@y
  str_start[str_ptr+1]:=str_start[str_ptr]+area_delimiter; incr(str_ptr);
  temp_str:=search_string(cur_area);
  if temp_str>0 then
    begin cur_area:=temp_str;
    decr(str_ptr);  {no |flush_string|, |pool_ptr| will be wrong!}
    for j:=str_start[str_ptr+1] to pool_ptr-1 do
      begin str_pool[j-area_delimiter]:=str_pool[j];
      end;
    pool_ptr:=pool_ptr-area_delimiter; {update |pool_ptr|}
    end;
  end;
if ext_delimiter=0 then
  begin cur_ext:=""; cur_name:=slow_make_string;
@z

@x [29.517] l.10016 - end_name: string recycling
else  begin cur_name:=str_ptr;
  str_start[str_ptr+1]:=str_start[str_ptr]+ext_delimiter-area_delimiter-1;
  incr(str_ptr); cur_ext:=make_string;
@y
else  begin cur_name:=str_ptr;
  str_start[str_ptr+1]:=str_start[str_ptr]+ext_delimiter-area_delimiter-1;
  incr(str_ptr); cur_ext:=make_string;
  decr(str_ptr); {undo extension string to look at name part}
  temp_str:=search_string(cur_name);
  if temp_str>0 then
    begin cur_name:=temp_str;
    decr(str_ptr);  {no |flush_string|, |pool_ptr| will be wrong!}
    for j:=str_start[str_ptr+1] to pool_ptr-1 do
      begin str_pool[j-ext_delimiter+area_delimiter+1]:=str_pool[j];
      end;
    pool_ptr:=pool_ptr-ext_delimiter+area_delimiter+1;  {update |pool_ptr|}
    end;
  cur_ext:=slow_make_string;  {remake extension string}
@z

% [29.519] In pack_file_name, leave room for the extra null we append at
% the end of a filename.
@x [29.519] l.10047 - pack_file_name, leave room for the extra null
for j:=str_start[a] to str_start[a+1]-1 do append_to_name(so(str_pool[j]));
@y
if name_of_file then libc_free (name_of_file);
name_of_file:= xmalloc_array (ASCII_code, length(a)+length(n)+length(e)+1);
for j:=str_start[a] to str_start[a+1]-1 do append_to_name(so(str_pool[j]));
@z

@x [29.519] l.10051 - pack_file_name, append the extra null
for k:=name_length+1 to file_name_size do name_of_file[k]:=' ';
@y
name_of_file[name_length+1]:=0;
@z

@x [29.520] l.10060 - filenames: default format.
@d format_default_length=20 {length of the |TEX_format_default| string}
@d format_area_length=11 {length of its area part}
@d format_ext_length=4 {length of its `\.{.fmt}' part}
@y
Under {\mc UNIX} we don't give the area part, instead depending
on the path searching that will happen during file opening.  Also, the
length will be set in the main program.

@d format_area_length=0 {length of its area part}
@d format_ext_length=4 {length of its `\.{.fmt}' part}
@z

@x [29.521] l.10066 - filenames: default format, where `plain.fmt' is.
@!TEX_format_default:packed array[1..format_default_length] of char;

@ @<Set init...@>=
TEX_format_default:='TeXformats:plain.fmt';
@y
@!format_default_length: integer;
@!TEX_format_default: ^char;

@ We set the name of the default format file and the length of that name
in C, instead of Pascal, since we want them to depend on the name of the
program.
@z

@x [29.523] l.10095 - Change to pack_buffered_name as with pack_file_name.
for j:=1 to n do append_to_name(xord[TEX_format_default[j]]);
@y
if name_of_file then libc_free (name_of_file);
name_of_file := xmalloc_array (ASCII_code, n+(b-a+1)+format_ext_length+1);
for j:=1 to n do append_to_name(xord[TEX_format_default[j]]);
@z

% @x [29.523] l.10097 - Set program name to match format.
% for j:=a to b do append_to_name(buffer[j]);
% @y
% for j:=a to b do append_to_name(buffer[j]);
% name_of_file[k+1]:=0;
% kpse_reset_program_name(name_of_file+1);
% @z

@x [29.523] l.10100 - Change to pack_buffered_name as with pack_file_name.
for k:=name_length+1 to file_name_size do name_of_file[k]:=' ';
@y
name_of_file[name_length+1]:=0;
@z

@x [29.524] l.10118 - Format file opening: only try once, with path searching.
  pack_buffered_name(0,loc,j-1); {try first without the system file area}
  if w_open_in(fmt_file) then goto found;
  pack_buffered_name(format_area_length,loc,j-1);
    {now try the system format file area}
  if w_open_in(fmt_file) then goto found;
@y
  pack_buffered_name(0,loc,j-1); {Kpathsea does everything}
  if w_open_in(fmt_file) then goto found;
@z

@x [29.524] l.10124 - replace `PLAIN' in error messages with `default'.
  wterm_ln('Sorry, I can''t find that format;',' will try PLAIN.');
@y
  wterm ('Sorry, I can''t find the format `');
  fputs (stringcast(name_of_file + 1), stdout);
  wterm ('''; will try `');
  fputs (TEX_format_default + 1, stdout);
  wterm_ln ('''.');
@z

@x [29.524] l.10132 - replace `PLAIN' in error messages with `default'.
  wterm_ln('I can''t find the PLAIN format file!');
@.I can't find PLAIN...@>
@y
  wterm ('I can''t find the format file `');
  fputs (TEX_format_default + 1, stdout);
  wterm_ln ('''!');
@.I can't find the format...@>
@z

@x MuLTeX: [29.526] filename and jendlinetype
@p procedure scan_file_name;
label done;
begin name_in_progress:=true; begin_name;
@y
@p procedure scan_file_name;
label done;
var save_jendline_type:integer;
begin name_in_progress:=true;
save_jendline_type:=jendline_type; jendline_type:=jend_ascii;
begin_name;
@z
@x MuLTeX: [29.526] filename and jendlinetype
done: end_name; name_in_progress:=false;
@y
done: end_name; name_in_progress:=false; jendline_type:=save_jendline_type;
@z

@x [29.530] l.10239 - prompt_file_name: No default extension is TeX input file.
if e=".tex" then show_context;
@y
if (e=".tex") or (e="") then show_context;
@z

%!%@x [29.532] l.10263 - avoid conflict, `logname' in <unistd.h> on some systems.
%!%@d ensure_dvi_open==if output_file_name=0 then
%!%@y
%!%@d log_name == texmf_log_name
%!%@d ensure_dvi_open==if output_file_name=0 then
%!%@z

@x [29.532] MuLTeX: post-process dvi
@d ensure_dvi_open==if output_file_name=0 then
  begin if job_name=0 then open_log_file;
  pack_job_name(".dvi");
  while not b_open_out(dvi_file) do
    prompt_file_name("file name for output",".dvi");
@y
@d log_name == texmf_log_name
@d ensure_dvi_open==if output_file_name=0 then
  begin if job_name=0 then open_log_file;
  pack_job_name(".dvi");
  while not dvi_open_out(dvi_file) do
    prompt_file_name("file name for output",".dvi");
@z

@x [29.534] l.10285 - Adjust for C string conventions.
@!months:packed array [1..36] of char; {abbreviations of month names}
@y
@!months:^char;
@z

@x [29.534] l.10289 - Filename change for the recorder.
@.texput@>
@y
@.texput@>
pack_job_name(".fls");
recorder_change_filename(stringcast(name_of_file+1));
@z

@x MuLTeX: [29.534] l.10291
while not a_open_out(log_file) do @<Try to get a different log file name@>;
log_name:=a_make_name_string(log_file);
@y
while not a_open_out(log_file) do @<Try to get a different log file name@>;
log_name:=a_make_name_string(log_file);
@<Set multi-lingual log type@>;
@z

@x [29.534] l.10293 - MLTeX: add MLTeX banner after loading fmt file
@<Print the banner line, including the date and time@>;
@y
@<Print the banner line, including the date and time@>;
if mltex_enabled_p then
  begin wlog_cr; wlog('MLTeX v2.2 enabled');
  end;
@z

@x 8bit: [29.534] l.10299
if buffer[l]=end_line_char then decr(l);
@y
@<Remove the end-of-line-char@>;
@z

@x
begin wlog(banner);
@y
begin
if src_specials_p or file_line_error_style_p or parse_first_line_p
then
  wlog(banner_k)
else
  wlog(banner);
@z

@x [29.536] l.10324 - Print rest of banner.
slow_print(format_ident); print("  ");
@y
wlog(version_string);
slow_print(format_ident); print("  ");
@z

@x [29.536] l.10327 - Adjust for C string conventions.
months:='JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC';
@y
months := ' JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC';
@z

% Print whether we're using src-specials.
% Print TCX name if one's given.
@x [29/536] l.10331
end
@y
if shell_enabled_p then begin
  wlog_cr;
  wlog('\write18 enabled.')
end;
if src_specials_p then begin
  wlog_cr;
  wlog(' Source specials enabled.')
end;
if file_line_error_style_p then begin
  wlog_cr;
  wlog(' file:line:error style messages enabled.')
end;
if parse_first_line_p then begin
  wlog_cr;
  wlog(' %&-line parsing enabled.');
end;
if translate_filename then begin
  wlog_cr;
  wlog(' (');
  fputs(translate_filename, log_file);
  wlog(')');
end;
end
@z

% [29.537] Use a path when calling a_open_in to do a \input; also, try
% to open the file with and without the `.tex' extension, regardless of
% whether the file already has an extension.  This allows filenames like
% `foo' and `foo.bar.tex', as well as `foo.tex' and `foo.bar'.
@x [29.537] l.10338 - start_input
begin scan_file_name; {set |cur_name| to desired file name}
if cur_ext="" then cur_ext:=".tex";
pack_cur_name;
loop@+  begin begin_file_reading; {set up |cur_file| and new level of input}
  if a_open_in(cur_file) then goto done;
  if cur_area="" then
    begin pack_file_name(cur_name,TEX_area,cur_ext);
    if a_open_in(cur_file) then goto done;
    end;
@y
var temp_str: str_number; k: integer;
begin scan_file_name; {set |cur_name| to desired file name}
pack_cur_name;
loop@+begin
  begin_file_reading; {set up |cur_file| and new level of input}
  tex_input_type := 1; {Tell |open_input| we are \.{\\input}.}
  {Kpathsea tries all the various ways to get the file.}
  if open_in_name_ok(stringcast(name_of_file+1))
     and a_open_in(cur_file, kpse_tex_format) then
    {At this point |name_of_file| contains the actual name found.
     We extract the |cur_area|, |cur_name|, and |cur_ext| from it.}
    begin k:=1;
    name_in_progress:=true;
    begin_name;
    stop_at_space:=false;
    while (k<=name_length)and(more_name(name_of_file[k])) do
      incr(k);
    stop_at_space:=true;
    end_name;
    name_in_progress:=false;
    goto done;
    end;
@z

@x [29.537] l.10348 - start_input: don't force ".tex" extension.
  prompt_file_name("input file name",".tex");
@y
  prompt_file_name("input file name","");
@z

@x [29.537] l.10350 - start_input: string recycling, MuLTeX:
done: name:=a_make_name_string(cur_file);
@y
done: name:=a_make_name_string(cur_file);
source_filename_stack[in_open]:=name;
full_source_filename_stack[in_open]:=make_full_name_string;
@<Set multi-lingual |cur_file| type@>;
if name=str_ptr-1 then {we can try to conserve string pool space now}
  begin temp_str:=search_string(name);
  if temp_str>0 then
    begin name:=temp_str; flush_string;
    end;
  end;
@z

@x [29.537] l.10352 - start_input: was job_name given on the command line?
  begin job_name:=cur_name; open_log_file;
@y
  begin job_name:=get_job_name; open_log_file;
@z

@x [29.537] l.10356 - 
if term_offset+length(name)>max_print_line-2 then print_ln
else if (term_offset>0)or(file_offset>0) then print_char(" ");
print_char("("); incr(open_parens); slow_print(name); update_terminal;
@y
if term_offset+length(full_source_filename_stack[in_open])>max_print_line-2
then print_ln
else if (term_offset>0)or(file_offset>0) then print_char(" ");
print_char("("); incr(open_parens);
slow_print(full_source_filename_stack[in_open]); update_terminal;
@z

@x [29.537] l.10360 - start_input: don't return filename to string pool.
if name=str_ptr-1 then {we can conserve string pool space now}
  begin flush_string; name:=cur_name;
  end;
@y
@z

@x 8bit: [29.538] l.10376
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the end-of-line-char if it is active@>;
@z

@x [30.539] MuLTeX: l.10421 jfm
Incidentally, when two or more 8-bit bytes are combined to form an integer of
16 or more bits, the most significant bytes appear first in the file.
This is called BigEndian order.
@!@^BigEndian order@>
@y
Incidentally, when two or more 8-bit bytes are combined to form an integer of
16 or more bits, the most significant bytes appear first in the file.
This is called BigEndian order.
@!@^BigEndian order@>

@d jfm_id=11
@d fmtype_tfm=0
@d fmtype_jfm=1
@d jglue_base==exten_base
@z

@x [30.548] l.10673 - texarray
@!internal_font_number=font_base..font_max; {|font| in a |char_node|}
@!font_index=0..font_mem_size; {index into |font_info|}
@y
@!internal_font_number=integer; {|font| in a |char_node|}
@!font_index=integer; {index into |font_info|}
@!nine_bits=min_quarterword..non_char;
@z

@x [30.549] l.10682 - texarray, MuLTeX
@!font_info:array[font_index] of memory_word;
  {the big collection of font data}
@!fmem_ptr:font_index; {first unused word of |font_info|}
@!font_ptr:internal_font_number; {largest internal font number in use}
@!font_check:array[internal_font_number] of four_quarters; {check sum}
@!font_size:array[internal_font_number] of scaled; {``at'' size}
@!font_dsize:array[internal_font_number] of scaled; {``design'' size}
@!font_params:array[internal_font_number] of font_index; {how many font
  parameters are present}
@!font_name:array[internal_font_number] of str_number; {name of the font}
@!font_area:array[internal_font_number] of str_number; {area of the font}
@!font_bc:array[internal_font_number] of eight_bits;
  {beginning (smallest) character code}
@!font_ec:array[internal_font_number] of eight_bits;
  {ending (largest) character code}
@!font_glue:array[internal_font_number] of pointer;
  {glue specification for interword space, |null| if not allocated}
@!font_used:array[internal_font_number] of boolean;
  {has a character from this font actually appeared in the output?}
@!hyphen_char:array[internal_font_number] of integer;
  {current \.{\\hyphenchar} values}
@!skew_char:array[internal_font_number] of integer;
  {current \.{\\skewchar} values}
@!bchar_label:array[internal_font_number] of font_index;
  {start of |lig_kern| program for left boundary character,
  |non_address| if there is none}
@!font_bchar:array[internal_font_number] of min_quarterword..non_char;
  {right boundary character, |non_char| if there is none}
@!font_false_bchar:array[internal_font_number] of min_quarterword..non_char;
  {|font_bchar| if it doesn't exist in the font, otherwise |non_char|}
@y
@!font_info: ^fmemory_word;
  {the big collection of font data}
@!fmem_ptr:font_index; {first unused word of |font_info|}
@!font_ptr:internal_font_number; {largest internal font number in use}
@!font_check: ^four_quarters; {check sum}
@!font_mcset: ^quarterword; {MuLTeX}
@!font_fmtype: ^small_number; {MuLTeX}
@!font_lcd: ^halfword; {MuLTeX}
@!font_size: ^scaled; {``at'' size}
@!font_dsize: ^scaled; {``design'' size}
@!font_params: ^font_index; {how many font
  parameters are present}
@!font_name: ^str_number; {name of the font}
@!font_area: ^str_number; {area of the font}
@!font_bc: ^eight_bits;
  {beginning (smallest) character code}
@!font_ec: ^eight_bits;
  {ending (largest) character code}
@!font_glue: ^pointer;
  {glue specification for interword space, |null| if not allocated}
@!font_used: ^boolean;
  {has a character from this font actually appeared in the output?}
@!hyphen_char: ^integer;
  {current \.{\\hyphenchar} values}
@!skew_char: ^integer;
  {current \.{\\skewchar} values}
@!bchar_label: ^font_index;
  {start of |lig_kern| program for left boundary character,
  |non_address| if there is none}
@!font_bchar: ^nine_bits;
  {right boundary character, |non_char| if there is none}
@!font_false_bchar: ^nine_bits;
  {|font_bchar| if it doesn't exist in the font, otherwise |non_char|}
@z

@x [30.550] l.10723 - texarray, MuLTeX
@!char_base:array[internal_font_number] of integer;
  {base addresses for |char_info|}
@!width_base:array[internal_font_number] of integer;
  {base addresses for widths}
@!height_base:array[internal_font_number] of integer;
  {base addresses for heights}
@!depth_base:array[internal_font_number] of integer;
  {base addresses for depths}
@!italic_base:array[internal_font_number] of integer;
  {base addresses for italic corrections}
@!lig_kern_base:array[internal_font_number] of integer;
  {base addresses for ligature/kerning programs}
@!kern_base:array[internal_font_number] of integer;
  {base addresses for kerns}
@!exten_base:array[internal_font_number] of integer;
  {base addresses for extensible recipes}
@!param_base:array[internal_font_number] of integer;
  {base addresses for font parameters}
@y
@!char_base: ^integer;
  {base addresses for |char_info|}
@!ctype_base: ^integer;
  {base addresses for char types}
@!width_base: ^integer;
  {base addresses for widths}
@!height_base: ^integer;
  {base addresses for heights}
@!depth_base: ^integer;
  {base addresses for depths}
@!italic_base: ^integer;
  {base addresses for italic corrections}
@!lig_kern_base: ^integer;
  {base addresses for ligature/kerning programs}
@!kern_base: ^integer;
  {base addresses for kerns}
@!exten_base: ^integer;
  {base addresses for extensible recipes}
@!param_base: ^integer;
  {base addresses for font parameters}
@z

@x [30.551] l.10743 - texarray
for k:=font_base to font_max do font_used[k]:=false;
@y
@z

@x [30.552] l.10749 - texarray, MuLTeX
font_ptr:=null_font; fmem_ptr:=7;
font_name[null_font]:="nullfont"; font_area[null_font]:="";
hyphen_char[null_font]:="-"; skew_char[null_font]:=-1;
bchar_label[null_font]:=non_address;
font_bchar[null_font]:=non_char; font_false_bchar[null_font]:=non_char;
font_bc[null_font]:=1; font_ec[null_font]:=0;
font_size[null_font]:=0; font_dsize[null_font]:=0;
char_base[null_font]:=0; width_base[null_font]:=0;
height_base[null_font]:=0; depth_base[null_font]:=0;
italic_base[null_font]:=0; lig_kern_base[null_font]:=0;
kern_base[null_font]:=0; exten_base[null_font]:=0;
font_glue[null_font]:=null; font_params[null_font]:=7;
param_base[null_font]:=-1;
for k:=0 to 6 do font_info[k].sc:=0;
@y
@z

@x [30.554] MuLTeX:
as fast as possible under the circumstances.
@^inner loop@>

@d char_info_end(#)==#].qqqq
@d char_info(#)==font_info[char_base[#]+char_info_end
@y
as fast as possible under the circumstances.
@^inner loop@>

@d char_info_end(#)== #@=)@>].qqqq
@d char_info(#)==font_info[ch_i_index@=(@>#,char_info_end
@#
@d orig_char_info_end(#)==#].qqqq
@d orig_char_info(#)==font_info[char_base[#]+orig_char_info_end
@#
@z

@x [30.560] MuLTeX:
@!lf,@!lh,@!bc,@!ec,@!nw,@!nh,@!nd,@!ni,@!nl,@!nk,@!ne,@!np:halfword;
@y
@!tt:small_number; {tfm type}
@!lf,@!lh,@!bc,@!ec,@!nw,@!nh,@!nd,@!ni,@!nl,@!nk,@!ne,@!np:halfword;
@!nt,@!ng,@!np_req,@!tmp:halfword;
@z

@x [30.563] l.10943 - Don't use TEX_font_area.
if aire="" then pack_file_name(nom,TEX_font_area,".tfm")
else pack_file_name(nom,aire,".tfm");
@y
{|kpse_find_file| will append the |".tfm"|, and avoid searching the disk
 before the font alias files as well.}
pack_file_name(nom,aire,"");
@z

% [30.564] Reading the tfm file.  As a special case, whenever we open a
% tfm file, we read its first byte into `tfm_temp' right away.  TeX
% looks at `fbyte' before calling `fget', so it ends up seeing every
% byte.  This is Pascal-like I/O.
@x [30.564] l.10956 - reading the tfm file, define fget & fbyte
@d fget==get(tfm_file)
@d fbyte==tfm_file^
@y
@d fget==tfm_temp:=getc(tfm_file)
@d fbyte==tfm_temp
@z

%!%@x [30.570] l.11064 - MLTeX: fix for bug while loading font
%!%  begin qw:=char_info(f)(d);
%!%@y
%!%  begin qw:=orig_char_info(f)(d);
%!%@z
%!%
%!%@x [30.573] l.11116 - MLTeX: fix for bug while loading font
%!%  qw:=char_info(f)(#); {N.B.: not |qi(#)|}
%!%@y
%!%  qw:=orig_char_info(f)(#); {N.B.: not |qi(#)|}
%!%@z

@x [30.565] MuLTeX: jfm
@ @<Read the {\.{TFM}} size fields@>=
begin read_sixteen(lf);
@y
@ @<Read the {\.{TFM}} size fields@>=
begin read_sixteen(lf);
if lf=jfm_id then begin tt:=fmtype_jfm; np_req:=15;
  fget; read_sixteen(nt); fget; read_sixteen(lf);
  end
else begin tt:=fmtype_tfm; np_req:=7; nt:=0 end;
@z
@x
fget; read_sixteen(np);
if lf<>6+lh+(ec-bc+1)+nw+nh+nd+ni+nl+nk+ne+np then abort;
@y
fget; read_sixteen(np);
if tt=fmtype_jfm then begin ng:=ne;
  if lf<>7+lh+nt+(ec-bc+1)+nw+nh+nd+ni+nl+nk+ng+np then abort;
  decr(lf);
  end
else if lf<>6+lh+(ec-bc+1)+nw+nh+nd+ni+nl+nk+ne+np then abort;
@z

@x [30.566] MuLTeX: jfm
@<Use size fields to allocate font information@>=
lf:=lf-6-lh; {|lf| words should be loaded into |font_info|}
if np<7 then lf:=lf+7-np; {at least seven parameters will appear}
if (font_ptr=font_max)or(fmem_ptr+lf>font_mem_size) then
  @<Apologize for not loading the font, |goto done|@>;
f:=font_ptr+1;
char_base[f]:=fmem_ptr-bc;
width_base[f]:=char_base[f]+ec+1;
@y
@<Use size fields to allocate font information@>=
lf:=lf-6-lh; {|lf| words should be loaded into |font_info|}
if np<np_req then lf:=lf+np_req-np; {at least |np_req| parameters will appear}
if (font_ptr=font_max)or(fmem_ptr+lf>font_mem_size) then
  @<Apologize for not loading the font, |goto done|@>;
f:=font_ptr+1;
font_mcset[f]:=mc_ascii; {replaced by \.{\\mcsassign} later}
font_fmtype[f]:=tt;
char_base[f]:=fmem_ptr-bc;
ctype_base[f]:=char_base[f]+ec+1;
width_base[f]:=ctype_base[f]+nt;
@z

@x [30.569] MuLTeX: jfm
@ @<Read character data@>=
for k:=fmem_ptr to width_base[f]-1 do
@y
@ @d jfm_ct_code(#)==font_info[#].dd.ld
@d jfm_ct_type(#)==font_info[#].dd.rd
@<Read character data@>=
if tt=fmtype_jfm then begin
  for k:=ctype_base[f] to ctype_base[f]+nt-1 do begin
    fget; tmp:=fbyte; fget;
    jfm_ct_code(k):=tmp*256+fbyte; {character code}
    fget; tmp:=fbyte; fget;
    jfm_ct_type(k):=tmp*256+fbyte; {character type}
    end;
  font_lcd[f]:=jfm_ct_code(ctype_base[f]+nt-1);
  end;
for k:=fmem_ptr to ctype_base[f]-1 do
@z

@x [30.573] MuLTeX: jfm
    else begin if b<>bchar then check_existence(b);
      if c<128 then check_existence(d) {check ligature}
      else if 256*(c-128)+d>=nk then abort; {check kern}
@y
    else begin if b<>bchar then check_existence(b);
      if c<128 then begin
        if tt=fmtype_tfm then check_existence(d) {check ligature}
        else if d*3>=ng then abort
        end
      else if 256*(c-128)+d>=nk then abort; {check kern}
@z

@x [30.574] MuLTeX: jfm
@ @<Read extensible character recipes@>=
for k:=exten_base[f] to param_base[f]-1 do
@y
@ @<Read extensible character recipes@>=
if tt=fmtype_jfm then
for k:=jglue_base[f] to param_base[f]-1 do
  store_scaled(font_info[k].sc)
else
for k:=exten_base[f] to param_base[f]-1 do
@z

% [32.575] We only want `eof' on the TFM file to be true if we
% previously had EOF, not if we're at EOF now.  This is like `feof', and
% unlike our implementation of `eof' elsewhere.
@x [32.575] l.11161 - Reading the tfm file, replace eof() by feof().
if eof(tfm_file) then abort;
@y
if feof(tfm_file) then abort;
@z

@x [30.575] MuLTeX: jfm
for k:=np+1 to 7 do font_info[param_base[f]+k-1].sc:=0;
@y
for k:=np+1 to np_req do font_info[param_base[f]+k-1].sc:=0;
if (tt=fmtype_jfm) and (np < np_req) then begin {TODO:symbolic name}
  font_info[param_base[f]+10-1].sc:=font_info[param_base[f]+7-1].sc;
  font_info[param_base[f]+13-1].sc:=font_info[param_base[f]+6-1].sc;
  end;
@z

@x [30.576] MuLTeX: jfm
@<Make final adjustments...@>=
if np>=7 then font_params[f]:=np@+else font_params[f]:=7;
@y
@<Make final adjustments...@>=
if np>=np_req then font_params[f]:=np@+else font_params[f]:=np_req;
@z

%!%@x [30.576] l.11180 - MLTeX: fix for bug while loading font
%!%  begin qw:=char_info(f)(bchar); {N.B.: not |qi(bchar)|}
%!%@y
%!%  begin qw:=orig_char_info(f)(bchar); {N.B.: not |qi(bchar)|}
%!%@z

@x [30.577] delayed, MuLTeX:
@<Declare procedures that scan font-related stuff@>=
procedure scan_font_ident;
var f:internal_font_number;
@!m:halfword;
begin @<Get the next non-blank non-call...@>;
if cur_cmd=def_font then f:=cur_font
else if cur_cmd=set_font then f:=cur_chr
else if cur_cmd=def_family then
  begin m:=cur_chr; scan_four_bit_int; f:=equiv(m+cur_val);
  end
@y
@<Declare procedures that scan font-related stuff@>=
procedure load_dfont_proc; forward;
procedure scan_font_ident;
var f:internal_font_number;
@!m:halfword;
@!mcs:integer;
begin @<Get the next non-blank non-call...@>;
if cur_cmd=def_font then begin
  if cur_chr=0 then f:=cur_font
  else begin scan_int; mcs:=cur_val;
    if (mc_min>mcs) or (mcs>mc_max) then mcs:=mc_min; {TODO}
    f:=cur_ml_font(mcs);
    end;
  end
else if cur_cmd=set_font then f:=cur_chr
else if cur_cmd=def_family then
  begin m:=cur_chr; scan_four_bit_int; f:=equiv(m+cur_val);
  end
else if cur_cmd=def_dfont then f:=cur_font
else if cur_cmd=demmand_font then
  begin load_dfont_proc; f:=cur_chr;
  end
@z

@x [30.581] MuLTeX
@p procedure char_warning(@!f:internal_font_number;@!c:eight_bits);
begin if tracing_lost_chars>0 then
  begin begin_diagnostic;
  print_nl("Missing character: There is no ");
@.Missing character@>
  print_ASCII(c); print(" in font ");
  slow_print(font_name[f]); print_char("!"); end_diagnostic(false);
  end;
end;
@y
@p procedure char_warning(@!f:internal_font_number;@!c:ML_code);
begin if tracing_lost_chars>0 then
  begin begin_diagnostic;
  print_nl("Missing character: There is no ");
@.Missing character@>
  if is_mlrep_ascii(c) then begin
    print_ASCII(c); print(" in font ");
    end
  else begin print_char(c);
    print(" in mlfont (mcs "); print_int(mlrep_mc(c)); print(") ");
    end;
  slow_print(font_name[f]); print_char("!"); end_diagnostic(false);
  end;
end;
@z

@x [30.582] MuLTeX
@p function new_character(@!f:internal_font_number;@!c:eight_bits):pointer;
label exit;
var p:pointer; {newly allocated node}
begin if font_bc[f]<=c then if font_ec[f]>=c then
  if char_exists(char_info(f)(qi(c))) then
    begin p:=get_avail; font(p):=f; character(p):=qi(c);
    new_character:=p; return;
    end;
char_warning(f,c);
new_character:=null;
exit:end;
@y
@p function new_character(@!f:internal_font_number;@!c:ML_code):pointer;
label exit;
var p:pointer; {newly allocated node}
cc:quarterword;
ct:eight_bits;
begin if font_fmtype[f]=fmtype_jfm then begin
  cc:=mlrep_char(c); ct:=get_jfm_ctype(f,cc);
  end
else begin cc:=c; ct:=c end;
if font_bc[f]<=ct then if font_ec[f]>=ct then
  if char_exists(orig_char_info(f)(qi(ct))) then
    begin p:=get_avail; font(p):=f; character(p):=qi(cc);
    new_character:=p; return;
    end;
char_warning(f,c);
new_character:=null;
exit:end;
@z

%!%@x [30.582] l.11276 - MLTeX: call |effective_char| in |new_character|
%!%@p function new_character(@!f:internal_font_number;@!c:eight_bits):pointer;
%!%label exit;
%!%var p:pointer; {newly allocated node}
%!%begin if font_bc[f]<=c then if font_ec[f]>=c then
%!%  if char_exists(char_info(f)(qi(c))) then
%!%@y
%!%
%!%This allows a character node to be used if there is an equivalent
%!%in the |char_sub_code| list.
%!%
%!%@p function new_character(@!f:internal_font_number;@!c:eight_bits):pointer;
%!%label exit;
%!%var p:pointer; {newly allocated node}
%!%@!ec:quarterword;  {effective character of |c|}
%!%begin ec:=effective_char(false,f,qi(c));
%!%if font_bc[f]<=qo(ec) then if font_ec[f]>=qo(ec) then
%!%  if char_exists(orig_char_info(f)(ec)) then  {N.B.: not |char_info|}
%!%@z

@x [32.592] l.11820 - font numbers can be >255 now.
@!c,@!f:quarterword; {character and font in current |char_node|}
@y
 {character and font in current |char_node|}
@!c:quarterword;
@!f:internal_font_number;
@z

@x [32.595] l.11860 - texarray
@!dvi_buf:array[dvi_index] of eight_bits; {buffer for \.{DVI} output}
@!half_buf:dvi_index; {half of |dvi_buf_size|}
@!dvi_limit:dvi_index; {end of the current half buffer}
@!dvi_ptr:dvi_index; {the next available buffer address}
@y
@!dvi_buf:^eight_bits; {buffer for \.{DVI} output}
@!half_buf:integer; {half of |dvi_buf_size|}
@!dvi_limit:integer; {end of the current half buffer}
@!dvi_ptr:integer; {the next available buffer address}
@z

@x [32.597] l.11886 - write_dvi done in C.
@p procedure write_dvi(@!a,@!b:dvi_index);
var k:dvi_index;
begin for k:=a to b do write(dvi_file,dvi_buf[k]);
end;
@y
In C, we use a macro to call |fwrite| or |write| directly, writing all
the bytes in one shot.  Much better even than writing four
bytes at a time.
@z

@x [32.602] l.11944 - Allow for outputting more than 256 fonts.
begin dvi_out(fnt_def1);
dvi_out(f-font_base-1);@/
@y
begin if f<=256+font_base then
  begin dvi_out(fnt_def1);
  dvi_out(f-font_base-1);
  end
else begin dvi_out(fnt_def1+1);
  dvi_out((f-font_base-1) div @'400);
  dvi_out((f-font_base-1) mod @'400);
  end;
@z

@x [32.617] l.12261 - Use output_comment if the user set it. Assume it's short enough.
  old_setting:=selector; selector:=new_string;
@y
if output_comment then
  begin l:=strlen(output_comment); dvi_out(l);
  for s:=0 to l-1 do dvi_out(output_comment[s]);
  end
else begin {the default code is unchanged}
  old_setting:=selector; selector:=new_string;
@z

@x [32.617] l.12268 - Use output_comment if the user set it.
  pool_ptr:=str_start[str_ptr]; {flush the current string}
@y
  pool_ptr:=str_start[str_ptr]; {flush the current string}
end;
@z

%!%@x [32.619] l.12294 - MLTeX: substitute character in |hlist_out|
%!%procedure hlist_out; {output an |hlist_node| box}
%!%label reswitch, move_past, fin_rule, next_p;
%!%@y
%!%procedure hlist_out; {output an |hlist_node| box}
%!%label reswitch, move_past, fin_rule, next_p, continue, found;
%!%@z
%!%
%!%@x [32.620] l.12326 - MLTeX: replace virtual character in |hlist_out|
%!%reaching a non-|char_node|. The program uses the fact that |set_char_0=0|.
%!%@^inner loop@>
%!%@y
%!%reaching a non-|char_node|. The program uses the fact that |set_char_0=0|.
%!%
%!%In ML\TeX{} this part looks for the existence of a substitution
%!%definition for a character |c|, if |c| does not exist in the font,
%!%and create appropriate \.{DVI} commands.  Former versions of ML\TeX{}
%!%have spliced appropriate character, kern, and box nodes into the
%!%horizontal list.
%!%%
%!%% 91/05/08 \charsubdefmax bug detected by Bernd Raichle
%!%Because the user can change character substitions or
%!%\.{\\charsubdefmax} on the fly, we have to test a again
%!%for valid substitutions.
%!%%
%!%% 93/10/29 \leaders bug detected by Eberhard Mattes
%!%(Additional it is necessary to be careful---if leaders are used
%!%the current hlist is normally traversed more than once!)
%!%@^inner loop@>
%!%@z
%!%
%!%@x [32.620] l.12334 - MLTeX: substitute character during |shipout|
%!%  if c>=qi(128) then dvi_out(set1);
%!%  dvi_out(qo(c));@/
%!%  cur_h:=cur_h+char_width(f)(char_info(f)(c));
%!%@y
%!%  if font_ec[f]>=qo(c) then if font_bc[f]<=qo(c) then
%!%    if char_exists(orig_char_info(f)(c)) then  {N.B.: not |char_info|}
%!%      begin if c>=qi(128) then dvi_out(set1);
%!%      dvi_out(qo(c));@/
%!%      cur_h:=cur_h+char_width(f)(orig_char_info(f)(c));
%!%      goto continue;
%!%      end;
%!%  if mltex_enabled_p then
%!%    @<Output a substitution, |goto continue| if not possible@>;
%!%continue:
%!%@z

@x [32.620] MuLTeX: wider chars
  if c>=qi(128) then dvi_out(set1);
  dvi_out(qo(c));@/
@y
  if c>=qi(256) then begin
    dvi_out(set1+1);
    dvi_out(qo(c div 256)); dvi_out(qo(c mod 256));
    end
  else begin
    if c>=qi(128) then dvi_out(set1);
    dvi_out(qo(c));@/
    end;
@z

@x [32.622] l.12349 - more >256 font output stuff.
else  begin dvi_out(fnt1); dvi_out(f-font_base-1);
  end;
@y
else if f<=256+font_base then
  begin dvi_out(fnt1); dvi_out(f-font_base-1);
  end
else begin dvi_out(fnt1+1);
  dvi_out((f-font_base-1) div @'400);
  dvi_out((f-font_base-1) mod @'400);
  end;
@z

%!%% We output each portion of the page as we get to it, if we are using
%!%% IPC, so that the previewer (TeXView) can display it immediately. [SPM]
%!%@x [32.640] l.12690 - IPC
%!%dvi_out(eop); incr(total_pages); cur_s:=-1;
%!%@y
%!%dvi_out(eop); incr(total_pages); cur_s:=-1;
%!%ifdef ('IPC')
%!%if ipc_on>0 then
%!%  begin if dvi_limit=half_buf then
%!%    begin write_dvi(half_buf, dvi_buf_size-1);
%!%    flush_dvi;
%!%    dvi_gone:=dvi_gone+half_buf;
%!%    end;
%!%  if dvi_ptr>0 then
%!%    begin write_dvi(0, dvi_ptr-1);
%!%    flush_dvi;
%!%    dvi_offset:=dvi_offset+dvi_ptr; dvi_gone:=dvi_gone+dvi_ptr;
%!%    end;
%!%  dvi_ptr:=0; dvi_limit:=dvi_buf_size;
%!%  ipc_page(dvi_gone);
%!%  end;
%!%endif ('IPC');
%!%@z
%!%
%!%@x [32.642] l.12742 - Use dvi_offset instead of dvi_buf_size with IPC stuff.
%!%  k:=4+((dvi_buf_size-dvi_ptr) mod 4); {the number of 223's}
%!%@y
%!%ifdef ('IPC')
%!%  k:=7-((3+dvi_offset+dvi_ptr) mod 4); {the number of 223's}
%!%endif ('IPC')
%!%ifndef ('IPC')
%!%  k:=4+((dvi_buf_size-dvi_ptr) mod 4); {the number of 223's}
%!%endifn ('IPC')
%!%@z

@x [32.642] l.12750 - i18n fix
  print(" ("); print_int(total_pages); print(" page");
  if total_pages<>1 then print_char("s");
@y
  print(" ("); print_int(total_pages); 
  if total_pages<>1 then print(" pages")
  else print(" page");
@z

@x [32.642] MuLTeX: l.12753 post-process dvi
  print(", "); print_int(dvi_offset+dvi_ptr); print(" bytes).");
  b_close(dvi_file);
@y
  print(", "); print_int(dvi_offset+dvi_ptr); print(" bytes).");
  dvi_close(dvi_file);
@z

%!%% The MLTeX changes never dealt with the problems of character
%!%% substitutions in math mode.  With the new additions in v2.2,
%!%% non-existing characters between |font_bc[f]| and |font_ec[f]|
%!%% can be substituted => we have to avoid this in math mode
%!%% (for compatibility reasons and to avoid other problems).
%!%%
%!%@x [35.708] l.13903 - MLTeX: avoid substitution in |var_delimiter|
%!%if (qo(y)>=font_bc[g])and(qo(y)<=font_ec[g]) then
%!%  begin continue: q:=char_info(g)(y);
%!%@y
%!%if (qo(y)>=font_bc[g])and(qo(y)<=font_ec[g]) then
%!%  begin continue: q:=orig_char_info(g)(y);
%!%@z
%!%
%!%@x [36.722] l.14172 - MLTeX: avoid substitution in |fetch|
%!%else  begin if (qo(cur_c)>=font_bc[cur_f])and(qo(cur_c)<=font_ec[cur_f]) then
%!%    cur_i:=char_info(cur_f)(cur_c)
%!%@y
%!%else  begin if (qo(cur_c)>=font_bc[cur_f])and(qo(cur_c)<=font_ec[cur_f]) then
%!%    cur_i:=orig_char_info(cur_f)(cur_c)
%!%@z
%!%
%!%@x [36.740] l.14486 - MLTeX: avoid substitution in |make_math_accent|
%!%  i:=char_info(f)(y);
%!%@y
%!%  i:=orig_char_info(f)(y);
%!%@z
%!%
%!%@x [36.749] l.14638 - MLTeX: avoid substitution in |make_op|
%!%    begin c:=rem_byte(cur_i); i:=char_info(cur_f)(c);
%!%@y
%!%    begin c:=rem_byte(cur_i); i:=orig_char_info(cur_f)(c);
%!%@z

% disabled in original tex-src-special.ch
 @x [37.774] l.15291 - source specials
if every_cr<>null then begin_token_list(every_cr,every_cr_text);
 @y
if (insert_src_special_every_cr and head<>tail) then insert_src_special;
if every_cr<>null then begin_token_list(every_cr,every_cr_text);
 @z

% disabled in original tex-source-special.ch
 @x [37.799] l.15682 - source specials
if every_cr<>null then begin_token_list(every_cr,every_cr_text);
 @y
if (insert_src_special_every_cr) then insert_src_special;
if every_cr<>null then begin_token_list(every_cr,every_cr_text);
 @z

@x [38.859] l.16855 - Fix a casting/expression evaluation problem.
if abs(fit_class-fitness(r))>1 then d:=d+adj_demerits;
@y
if abs(intcast(fit_class)-intcast(fitness(r)))>1 then d:=d+adj_demerits;
@z

@x [39.875] l.17170 - Another casting problem.
  begin line_diff:=line_number(r)-best_line;
@y
  begin line_diff:=intcast(line_number(r))-intcast(best_line);
@z

@x [42.920] l.18056 - bigtrie: allow larger hyphenation tries.
Comparatively few different number sequences $n_0\ldots n_k$ actually occur,
since most of the |n|'s are generally zero. Therefore the number sequences
are encoded in such a way that |trie_op|$(z_k)$ is only one byte long.
If |trie_op(@t$z_k$@>)<>min_quarterword|, when $p_1\ldots p_k$ has matched
the letters in |hc[(l-k+1)..l@,]| of language |t|,
we perform all of the required operations
for this pattern by carrying out the following little program: Set
|v:=trie_op(@t$z_k$@>)|. Then set |v:=v+op_start[t]|,
|hyf[l-hyf_distance[v]]:=@tmax@>(hyf[l-hyf_distance[v]], hyf_num[v])|,
and |v:=hyf_next[v]|; repeat, if necessary, until |v=min_quarterword|.
@y
The theory that comparatively few different number sequences $n_0\ldots n_k$
actually occur, since most of the |n|'s are generally zero, seems to fail
at least for the large German hyphenation patterns.
Therefore the number sequences cannot any longer be encoded in such a way
that |trie_op|$(z_k)$ is only one byte long.
We have introduced a new constant |max_trie_op| for the maximum allowable
hyphenation operation code value; |max_trie_op| might be different for
\TeX\ and \.{INITEX} and must not exceed |max_halfword|.
An opcode will occupy a halfword if |max_trie_op| exceeds |max_quarterword|
or a quarterword otherwise.
@^system dependencies@>
If |trie_op(@t$z_k$@>)<>min_trie_op|, when $p_1\ldots p_k$ has matched
the letters in |hc[(l-k+1)..l@,]| of language |t|,
we perform all of the required operations
for this pattern by carrying out the following little program: Set
|v:=trie_op(@t$z_k$@>)|. Then set |v:=v+op_start[t]|,
|hyf[l-hyf_distance[v]]:=@tmax@>(hyf[l-hyf_distance[v]], hyf_num[v])|,
and |v:=hyf_next[v]|; repeat, if necessary, until |v=min_trie_op|.
@z

@x [42.920] l.18068 - bigtrie: allow larger hyphenation tries.
@!trie_pointer=0..trie_size; {an index into |trie|}
@y
@!trie_pointer=0..ssup_trie_size; {an index into |trie|}
@!trie_opcode=0..ssup_trie_opcode;  {a trie opcode}
@z

@x [42.921] l.18070 - bigtrie: allow larger hyphenation tries.
@ @d trie_link(#)==trie[#].rh {``downward'' link in a trie}
@d trie_char(#)==trie[#].b1 {character matched at this trie location}
@d trie_op(#)==trie[#].b0 {program for hyphenation at this trie location}
@y
@ For more than 255 trie op codes, the three fields |trie_link|, |trie_char|,
and |trie_op| will no longer fit into one memory word; thus using web2c
we define |trie| as three array instead of an array of records.
The variant will be implented by reusing the opcode field later on with
another macro.

@d trie_link(#)==trie_trl[#] {``downward'' link in a trie}
@d trie_char(#)==trie_trc[#] {character matched at this trie location}
@d trie_op(#)==trie_tro[#] {program for hyphenation at this trie location}
@z

@x [42.921] l.18075 - bigtrie: allow larger hyphenation tries.
@!trie:array[trie_pointer] of two_halves; {|trie_link|, |trie_char|, |trie_op|}
@y
{We will dynamically allocate these arrays.}
@!trie_trl:^trie_pointer; {|trie_link|}
@!trie_tro:^trie_pointer; {|trie_op|}
@!trie_trc:^quarterword; {|trie_char|}
@z

@x [42.921] l.18078 - bigtrie: allow larger hyphenation tries.
@!hyf_next:array[1..trie_op_size] of quarterword; {continuation code}
@y
@!hyf_next:array[1..trie_op_size] of trie_opcode; {continuation code}
@z

@x [42.923] l.18099 - bigtrie: allow larger hyphenation tries.
    begin if trie_op(z)<>min_quarterword then
@y
    begin if trie_op(z)<>min_trie_op then
@z

@x [42.924] l.18112 - bigtrie: allow larger hyphenation tries.
until v=min_quarterword;
@y
until v=min_trie_op;
@z

%%%%%%%% dynamic hyph_size
@x 18126 m.925
different from $\alpha$, we can conclude that $\alpha$ is not in the table.
@y  18126
different from $\alpha$, we can conclude that $\alpha$ is not in the table.
This is a clever scheme which saves the need for a hash link array.
However, it is difficult to increase the size of the hyphen exception
arrays. To make this easier, the ordered hash has been replaced by
a simple hash, using an additional array |hyph_link|. The value
|0| in |hyph_link[k]| means that there are no more entries corresponding
to the specific hash chain. When |hyph_link[k]>0|, the next entry in
the hash chain is |hyph_link[k]-1|. This value is used because the
arrays start at |0|.
@z

%%%%%%%% dynamic hyph_size
@x 18134 m.925
@!hyph_pointer=0..hyph_size; {an index into the ordered hash table}
@y  18134
@!hyph_pointer=0..ssup_hyph_size; {index into hyphen exceptions hash table;
                     enlarging this requires changing (un)dump code}
@z

%%%%%%%% dynamic hyph_size
@x 18137 m.926
@!hyph_word:array[hyph_pointer] of str_number; {exception words}
@!hyph_list:array[hyph_pointer] of pointer; {list of hyphen positions}
@!hyph_count:hyph_pointer; {the number of words in the exception dictionary}
@y  18139
@!hyph_word: ^str_number; {exception words}
@!hyph_list: ^pointer; {list of hyphen positions}
@!hyph_link: ^hyph_pointer; {link array for hyphen exceptions hash table}
@!hyph_count:integer; {the number of words in the exception dictionary}
@!hyph_next:integer; {next free slot in hyphen exceptions hash table}
@z

%%%%%%%% dynamic hyph_size
@x 18145 m.928
for z:=0 to hyph_size do
  begin hyph_word[z]:=0; hyph_list[z]:=null;
  end;
hyph_count:=0;
@y  18148
for z:=0 to hyph_size do
  begin hyph_word[z]:=0; hyph_list[z]:=null; hyph_link[z]:=0;
  end;
hyph_count:=0;
hyph_next:=hyph_prime+1; if hyph_next>hyph_size then hyph_next:=hyph_prime;
@z

%%%%%%%% dynamic hyph_size
@x 18163 m.930
h:=hc[1]; incr(hn); hc[hn]:=cur_lang;
for j:=2 to hn do h:=(h+h+hc[j]) mod hyph_size;
loop@+  begin @<If the string |hyph_word[h]| is less than \(hc)|hc[1..hn]|,
    |goto not_found|; but if the two strings are equal,
    set |hyf| to the hyphen positions and |goto found|@>;
  if h>0 then decr(h)@+else h:=hyph_size;
  end;
not_found: decr(hn)
@y  18170
h:=hc[1]; incr(hn); hc[hn]:=cur_lang;
for j:=2 to hn do h:=(h+h+hc[j]) mod hyph_prime;
loop@+  begin @<If the string |hyph_word[h]| is less than \(hc)|hc[1..hn]|,
    |goto not_found|; but if the two strings are equal,
    set |hyf| to the hyphen positions and |goto found|@>;
  h:=hyph_link[h]; if h=0 then goto not_found;
  decr(h);
  end;
not_found: decr(hn)
@z

%%%%%%%% dynamic hyph_size
@x 18172 m.931
@ @<If the string |hyph_word[h]| is less than \(hc)...@>=
k:=hyph_word[h]; if k=0 then goto not_found;
if length(k)<hn then goto not_found;
if length(k)=hn then
  begin j:=1; u:=str_start[k];
  repeat if so(str_pool[u])<hc[j] then goto not_found;
  if so(str_pool[u])>hc[j] then goto done;
  incr(j); incr(u);
  until j>hn;
  @<Insert hyphens as specified in |hyph_list[h]|@>;
  decr(hn); goto found;
  end;
done:
@y  18184
@ @<If the string |hyph_word[h]| is less than \(hc)...@>=
{This is now a simple hash list, not an ordered one, so
the module title is no longer descriptive.}
k:=hyph_word[h]; if k=0 then goto not_found;
if length(k)=hn then
  begin j:=1; u:=str_start[k];
  repeat
  if so(str_pool[u])<>hc[j] then goto done;
  incr(j); incr(u);
  until j>hn;
  @<Insert hyphens as specified in |hyph_list[h]|@>;
  decr(hn); goto found;
  end;
done:
@z

%%%%%%%% dynamic hyph_size
@x 18274 m.939
  begin h:=(h+h+hc[j]) mod hyph_size;
@y  18274
  begin h:=(h+h+hc[j]) mod hyph_prime;
@z

%%%%%%%% dynamic hyph_size
@x 18281 m.940
@ @<Insert the \(p)pair |(s,p)|...@>=
if hyph_count=hyph_size then overflow("exception dictionary",hyph_size);
@:TeX capacity exceeded exception dictionary}{\quad exception dictionary@>
incr(hyph_count);
while hyph_word[h]<>0 do
  begin @<If the string |hyph_word[h]| is less than \(or)or equal to
  |s|, interchange |(hyph_word[h],hyph_list[h])| with |(s,p)|@>;
  if h>0 then decr(h)@+else h:=hyph_size;
  end;
hyph_word[h]:=s; hyph_list[h]:=p
@y  18290
@ @<Insert the \(p)pair |(s,p)|...@>=
  if hyph_next <= hyph_prime then
     while (hyph_next>0) and (hyph_word[hyph_next-1]>0) do decr(hyph_next);
if (hyph_count=hyph_size)or(hyph_next=0) then
   overflow("exception dictionary",hyph_size);
@:TeX capacity exceeded exception dictionary}{\quad exception dictionary@>
incr(hyph_count);
while hyph_word[h]<>0 do
  begin @<If the string |hyph_word[h]| is less than \(or)or equal to
  |s|, interchange |(hyph_word[h],hyph_list[h])| with |(s,p)|@>;
  if hyph_link[h]=0 then
  begin
    hyph_link[h]:=hyph_next;
    if hyph_next >= hyph_size then hyph_next:=hyph_prime;
    if hyph_next > hyph_prime then incr(hyph_next);
  end;
  h:=hyph_link[h]-1;
  end;

found: hyph_word[h]:=s; hyph_list[h]:=p
@z

%%%%%%%% dynamic hyph_size
@x 18292 m.941
@ @<If the string |hyph_word[h]| is less than \(or)...@>=
k:=hyph_word[h];
if length(k)<length(s) then goto found;
if length(k)>length(s) then goto not_found;
u:=str_start[k]; v:=str_start[s];
repeat if str_pool[u]<str_pool[v] then goto found;
if str_pool[u]>str_pool[v] then goto not_found;
incr(u); incr(v);
until u=str_start[k+1];
found:q:=hyph_list[h]; hyph_list[h]:=p; p:=q;@/
t:=hyph_word[h]; hyph_word[h]:=s; s:=t;
not_found:
@y  18303
@ @<If the string |hyph_word[h]| is less than \(or)...@>=
{This is now a simple hash list, not an ordered one, so
the module title is no longer descriptive.}
k:=hyph_word[h];
if length(k)<>length(s) then goto not_found;
u:=str_start[k]; v:=str_start[s];
repeat if str_pool[u]<>str_pool[v] then goto not_found;
incr(u); incr(v);
until u=str_start[k+1];
{repeat hyphenation exception; flushing old data}
flush_string; s:=hyph_word[h]; {avoid |slow_make_string|!}
decr(hyph_count);
{ We could also |flush_list(hyph_list[h]);|, but it interferes
  with \.{trip.log}. }
goto found;
not_found:
@z

@x [43.943] l.18332 - bigtrie: Larger tries, also in documentation parts.
|hyf_next[@t$v^\prime$@>]=min_quarterword|.
@y
|hyf_next[@t$v^\prime$@>]=min_trie_op|.
@z

@x [43.943] l.18336 - bigtrie: Larger tries, also in documentation parts.
$$\hbox{|@t$v^\prime$@>:=new_trie_op(0,1,min_quarterword)|,\qquad
@y
$$\hbox{|@t$v^\prime$@>:=new_trie_op(0,1,min_trie_op)|,\qquad
@z

@x [43.943] l.18346 - web2c can't parse negative lower bounds in arrays.  Sorry.
@!init@! trie_op_hash:array[-trie_op_size..trie_op_size] of 0..trie_op_size;
@y
@!init@! trie_op_hash:array[neg_trie_op_size..trie_op_size] of 0..trie_op_size;
@z

@x [43.943] l.18348 - bigtrie: Larger hyphenation tries.
@!trie_used:array[ASCII_code] of quarterword;
@y
@!trie_used:array[ASCII_code] of trie_opcode;
@z

@x [43.943] l.18352 - bigtrie: Larger hyphenation tries.
@!trie_op_val:array[1..trie_op_size] of quarterword;
@y
@!trie_op_val:array[1..trie_op_size] of trie_opcode;
@z

@x [43.943] l.18355 - Dynamic trie arrays
tini
@y
tini@;
@!max_op_used:trie_opcode; {largest opcode used for any language}
@!small_op:boolean; {flag used while dumping or undumping}
@z

@x [43.944] l.18358 - bigtrie: Larger tries, also in documentation parts.
|new_trie_op| could return |min_quarterword| (thereby simply ignoring
@y
|new_trie_op| could return |min_trie_op| (thereby simply ignoring
@z

@x [43.944] l.18365 - bigtrie: Larger hyphenation tries.
function new_trie_op(@!d,@!n:small_number;@!v:quarterword):quarterword;
label exit;
var h:-trie_op_size..trie_op_size; {trial hash location}
@!u:quarterword; {trial op code}
@y
function new_trie_op(@!d,@!n:small_number;@!v:trie_opcode):trie_opcode;
label exit;
var h:neg_trie_op_size..trie_op_size; {trial hash location}
@!u:trie_opcode; {trial op code}
@z

@x [43.944] l.18370 - Another casting problem, and use |neg_trie_op_size|.
begin h:=abs(n+313*d+361*v+1009*cur_lang) mod (trie_op_size+trie_op_size)
  - trie_op_size;
@y
begin h:=abs(intcast(n)+313*intcast(d)+361*intcast(v)+1009*intcast(cur_lang))
  mod (trie_op_size - neg_trie_op_size)
  + neg_trie_op_size;
@z

@x [43.944] l.18377 - bigtrie: And larger tries again.
    if u=max_quarterword then
      overflow("pattern memory ops per language",
        max_quarterword-min_quarterword);
    incr(trie_op_ptr); incr(u); trie_used[cur_lang]:=u;
@y
    if u=max_trie_op then
      overflow("pattern memory ops per language",
      max_trie_op-min_trie_op);
    incr(trie_op_ptr); incr(u); trie_used[cur_lang]:=u;
    if u>max_op_used then max_op_used:=u;
@z

@x [43.945] l.18399 - bigtrie: And larger tries again.
op_start[0]:=-min_quarterword;
@y
op_start[0]:=-min_trie_op;
@z

@x [43.946] l.18416 - bigtrie: And larger tries again.
for k:=0 to 255 do trie_used[k]:=min_quarterword;
@y
for k:=0 to 255 do trie_used[k]:=min_trie_op;
@z

@x [43.946] l.18417 - Dynamic trie arrays.
trie_op_ptr:=0;
@y
max_op_used:=min_trie_op;
trie_op_ptr:=0;
@z

@x [43.947] l.18438 - Dynamically allocate arrays, and a casting problem.
@!init @!trie_c:packed array[trie_pointer] of packed_ASCII_code;
  {characters to match}
@t\hskip10pt@>@!trie_o:packed array[trie_pointer] of quarterword;
  {operations to perform}
@t\hskip10pt@>@!trie_l:packed array[trie_pointer] of trie_pointer;
  {left subtrie links}
@t\hskip10pt@>@!trie_r:packed array[trie_pointer] of trie_pointer;
  {right subtrie links}
@t\hskip10pt@>@!trie_ptr:trie_pointer; {the number of nodes in the trie}
@t\hskip10pt@>@!trie_hash:packed array[trie_pointer] of trie_pointer;
  {used to identify equivalent subtries}
tini
@y
@!init @!trie_c:^packed_ASCII_code;
  {characters to match}
@t\hskip10pt@>@!trie_o:^trie_opcode;
  {operations to perform}
@t\hskip10pt@>@!trie_l:^trie_pointer;
  {left subtrie links}
@t\hskip10pt@>@!trie_r:^trie_pointer;
  {right subtrie links}
@t\hskip10pt@>@!trie_ptr:trie_pointer; {the number of nodes in the trie}
@t\hskip10pt@>@!trie_hash:^trie_pointer;
  {used to identify equivalent subtries}
tini
@z

@x [43.948] l.18471 - Another casting problem.
begin h:=abs(trie_c[p]+1009*trie_o[p]+@|
    2718*trie_l[p]+3142*trie_r[p]) mod trie_size;
@y
begin h:=abs(intcast(trie_c[p])+1009*intcast(trie_o[p])+@|
    2718*intcast(trie_l[p])+3142*intcast(trie_r[p])) mod trie_size;
@z

@x [43.950] l.18521 - Dynamically allocate & larger tries.
@d trie_back(#)==trie[#].lh {backward links in |trie| holes}
@y
@d trie_back(#)==trie_tro[#] {use the opcode field now for backward links}
@z

@x [43.590] l.18524 - Dynamically allocate & larger tries.
@!init@!trie_taken:packed array[1..trie_size] of boolean;
  {does a family start here?}
@t\hskip10pt@>@!trie_min:array[ASCII_code] of trie_pointer;
  {the first possible slot for each character}
@t\hskip10pt@>@!trie_max:trie_pointer; {largest location used in |trie|}
@t\hskip10pt@>@!trie_not_ready:boolean; {is the trie still in linked form?}
tini
@y
@!init@!trie_taken: ^boolean;
  {does a family start here?}
@t\hskip10pt@>@!trie_min:array[ASCII_code] of trie_pointer;
  {the first possible slot for each character}
@t\hskip10pt@>@!trie_max:trie_pointer; {largest location used in |trie|}
@t\hskip10pt@>@!trie_not_ready:boolean; {is the trie still in linked form?}
tini
@z

@x [43.951] l.18539 - Dynamically allocate.
trie_not_ready:=true; trie_root:=0; trie_c[0]:=si(0); trie_ptr:=0;
@y
trie_not_ready:=true;
@z

@x [43.958] l.18634 - bigtrie: Larger tries.
@<Move the data into |trie|@>=
h.rh:=0; h.b0:=min_quarterword; h.b1:=min_quarterword; {|trie_link:=0|,
  |trie_op:=min_quarterword|, |trie_char:=qi(0)|}
@y
@d clear_trie == {clear |trie[r]|}
  begin trie_link(r):=0;
  trie_op(r):=min_trie_op;
  trie_char(r):=min_quarterword; {|trie_char:=qi(0)|}
  end

@<Move the data into |trie|@>=
@z

@x [43.958] l.18638 - bigtrie: Larger tries.
  begin for r:=0 to 256 do trie[r]:=h;
@y
  begin for r:=0 to 256 do clear_trie;
@z

@x [43.958] l.18643 - bigtrie: Larger tries.
  repeat s:=trie_link(r); trie[r]:=h; r:=s;
@y
  repeat s:=trie_link(r); clear_trie; r:=s;
@z

@x [43.960] l.18677 - bigtrie: Larger tries.
@!v:quarterword; {trie op code}
@y
@!v:trie_opcode; {trie op code}
@z

@x [43.963] l.18749 - bigtrie: Larger tries.
if trie_o[q]<>min_quarterword then
@y
if trie_o[q]<>min_trie_op then
@z

@x [43.964] l.18762 - bigtrie: Larger tries.
trie_c[p]:=si(c); trie_o[p]:=min_quarterword;
@y
trie_c[p]:=si(c); trie_o[p]:=min_trie_op;
@z

@x [43.965] l.18768 - bigtrie: Larger tries.
l:=k; v:=min_quarterword;
@y
l:=k; v:=min_trie_op;
@z

@x [43.966] l.18786 - bigtrie: Larger tries.
@!h:two_halves; {template used to zero out |trie|'s holes}
@y
@z

%%
%% We can rewrite the original code after "main_loop_move+2" upto the
%% "tail_append(lig_stack)" in module 1036 as
%%
%
% main_loop_move+2:
% if font_bc[main_f]<=cur_chr then
%  if cur_chr<=font_ec[main_f] then
%    begin  main_i:=char_info(main_f)(cur_l);
%    if char_exists(main_i) goto main_loop_move+3;
%    end;
% char_warning(main_f,cur_chr); free_avail(lig_stack); goto big_switch;
% main_loop_move+3:
% tail_append(lig_stack) {|main_loop_lookahead| is next}
%
%%
%% We can use the rewritten code above to include additional MLTeX
%% specific parts in the future.  Additionally it can be used when
%% optimizing |main_control| to minimize the call of the function
%% |effective_char|.
%%
%
%@x [46.1030] l.19977 - MLTeX: substitution in |main_control|
%  main_loop_move,main_loop_move+1,main_loop_move+2,main_loop_move_lig,
%@y
%  main_loop_move,main_loop_move+1,main_loop_move+2,main_loop_move+3,
%  main_loop_move_lig,
%@z

@x MuLTeX: [46.1030]
@p @t\4@>@<Declare action procedures for use by |main_control|@>@;
@y
@p @t\4@>@<Declare subprocedures needed for delayed font@>@;@/
@t\4@>@<Declare action procedures for use by |main_control|@>@;
@z

@x MuLTeX: [46.1030] new case for jletter
var@!t:integer; {general-purpose temporary variable}
begin if every_job<>null then begin_token_list(every_job,every_job_text);
big_switch: get_x_token;@/
reswitch: @<Give diagnostic information, if requested@>;
case abs(mode)+cur_cmd of
hmode+letter,hmode+other_char,hmode+char_given: goto main_loop;
hmode+char_num: begin scan_char_num; cur_chr:=cur_val; goto main_loop;@+end;
@y
var@!t:integer; {general-purpose temporary variable}
@!temp_cmd:eight_bits; {to restore right |cur_cmd| after |scan_char_num|}
@<Local variables for |main_control|@>@/
begin if every_job<>null then begin_token_list(every_job,every_job_text);
big_switch: get_x_token;@/
reswitch: @<Give diagnostic information, if requested@>;
case abs(mode)+cur_cmd of
hmode+letter,hmode+jletter,hmode+other_char,hmode+char_given: goto main_loop;
hmode+char_num: begin temp_cmd:=cur_cmd;
 scan_j_char_num; if is_mlrep(cur_val) then cur_cmd:=jletter
 else cur_cmd:=temp_cmd; cur_chr:=cur_val; goto main_loop;@+end;
hmode+faker: goto main_loop_lookahead;
vmode+faker,mmode+faker: do_nothing;
@z

@x MuLTeX: [46.1034] space factor for japanese
  main_s:=sf_code(cur_chr);
  if main_s=1000 then space_factor:=1000
  else if main_s<1000 then
    begin if main_s>0 then space_factor:=main_s;
    end
  else if space_factor<1000 then space_factor:=1000
  else space_factor:=main_s
@y
  if cur_cmd=jletter then space_factor:=1000
  else begin
  main_s:=sf_code(cur_chr);
  if main_s=1000 then space_factor:=1000
  else if main_s<1000 then
    begin if main_s>0 then space_factor:=main_s;
    end
  else if space_factor<1000 then space_factor:=1000
  else space_factor:=main_s
  end
@z

@x [46.1034] l.20074 - source specials
@<Append character |cur_chr|...@>=
adjust_space_factor;@/
@y
@<Append character |cur_chr|...@>=
if ((head=tail) and (mode>0)) then begin
  if (insert_src_special_auto) then append_src_special;
end;
adjust_space_factor;@/
@z

% The following cases are not considered.
%	hyphen jletter (how we should treat this case?)
%	jletter lig (where lig is kinsoku char)
@x JTeX: [46.???]
main_f:=cur_font;
bchar:=font_bchar[main_f]; false_bchar:=font_false_bchar[main_f];
if mode>0 then if language<>clang then fix_language;
fast_get_avail(lig_stack); font(lig_stack):=main_f; cur_l:=qi(cur_chr);
character(lig_stack):=cur_l;@/
@y
main_mc:=mlrep_mc(cur_chr); main_c:=mlrep_char(cur_chr);
main_f:=get_ml_font(main_mc);
if cur_cmd=jletter then
  @<Kinsoku shori; insert or omit glue before jletter@>
else
  @<Kinsoku shori; insert or omit glue after jletter@>;
bchar:=font_bchar[main_f]; false_bchar:=font_false_bchar[main_f];
if mode>0 then if language<>clang then fix_language;
fast_get_avail(lig_stack); font(lig_stack):=main_f; cur_l:=qi(main_c);
character(lig_stack):=cur_l;@/
@z

% It is assumed that ligature happens only by ascii (TODO:1bml lattin etc?)
@x MuLTeX: [46.???]
@d pack_lig(#)== {the parameter is either |rt_hit| or |false|}
  begin main_p:=new_ligature(main_f,cur_l,link(cur_q));
@y
@d pack_lig(#)== {the parameter is either |rt_hit| or |false|}
  begin main_p:=new_ligature(cur_font,cur_l,link(cur_q));
@z

@x MuLTeX: [46.???]
main_loop_move+1:if not is_char_node(lig_stack) then goto main_loop_move_lig;
main_loop_move+2:if(cur_chr<font_bc[main_f])or(cur_chr>font_ec[main_f]) then
  begin char_warning(main_f,cur_chr); free_avail(lig_stack); goto big_switch;
  end;
main_i:=char_info(main_f)(cur_l);
@y
main_loop_move+1:if not is_char_node(lig_stack) then goto main_loop_move_lig;
main_loop_move+2:
  {if @<|cur_chr| is jis space@> then begin} {treat JIS space (!!) specially}
    {@<Insert |jspaceskip|@>;
    @<set |main_i| for JIS space@>;
    free_avail(lig_stack);
    goto main_loop_lookahead;
    end
  else} if font_fmtype[main_f]=fmtype_jfm then do_nothing
  else if(main_c<font_bc[main_f])or(main_c>font_ec[main_f]) then begin
    char_warning(main_f,cur_chr); free_avail(lig_stack);
    goto big_switch;
    end;
main_i:=char_info(main_f)(cur_l);
@z

@x MuLTeX: [46.???]
get_next; {set only |cur_cmd| and |cur_chr|, for speed}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
x_token; {now expand and set |cur_cmd|, |cur_chr|, |cur_tok|}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
if cur_cmd=char_num then
  begin scan_char_num; cur_chr:=cur_val; goto main_loop_lookahead+1;
  end;
if cur_cmd=no_boundary then bchar:=non_char;
cur_r:=bchar; lig_stack:=null; goto main_lig_loop;
main_loop_lookahead+1: adjust_space_factor;
fast_get_avail(lig_stack); font(lig_stack):=main_f;
cur_r:=qi(cur_chr); character(lig_stack):=cur_r;
if cur_r=false_bchar then cur_r:=non_char {this prevents spurious ligatures}
@y
prev_cmd:=cur_cmd; prev_chr:=cur_chr; prev_c:=mlrep_char(prev_chr);
get_next; {set only |cur_cmd| and |cur_chr|, for speed}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=jletter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
x_token; {now expand and set |cur_cmd|, |cur_chr|, |cur_tok|}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=jletter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
if cur_cmd=char_num then
  begin scan_j_char_num; 
    if is_mlrep(cur_val) then {japanese character specified by |char_num|}
      begin cur_cmd:=jletter; cur_chr:=cur_val;
      end
    else cur_chr:=cur_val;
    goto main_loop_lookahead+1;
  end;
if cur_cmd=no_boundary then bchar:=non_char;
if prev_cmd=jletter then begin @<Right boundary of japanese char@>;
  goto reswitch;
  end
else if prev_cmd=faker then goto reswitch;
cur_r:=bchar; lig_stack:=null; goto main_lig_loop;
main_loop_lookahead+1: adjust_space_factor;
main_mc:=mlrep_mc(cur_chr); main_c:=mlrep_char(cur_chr);
main_f:=get_ml_font(main_mc);
fast_get_avail(lig_stack); font(lig_stack):=main_f;
cur_r:=qi(main_c); character(lig_stack):=cur_r;
if cur_r=false_bchar then cur_r:=non_char; {this prevents spurious ligatures}
@<Kinsoku shori; insert or omit glue and |goto main_loop_move|,
  if |prev_cmd=jletter| or |cur_cmd=jletter|@>
@z

%!%???conflict with JTeX
%!%@x [46.1036] l.20138 - MLTeX: substitution in |main_control|
%!%main_loop_move+2:if(cur_chr<font_bc[main_f])or(cur_chr>font_ec[main_f]) then
%!%@y
%!%main_loop_move+2:
%!%if(qo(effective_char(false,main_f,qi(cur_chr)))>font_ec[main_f])or
%!%  (qo(effective_char(false,main_f,qi(cur_chr)))<font_bc[main_f]) then
%!%@z
%!%
%!%@x [46.1036] l.20141 - MLTeX: substitution in |main_control|
%!%main_i:=char_info(main_f)(cur_l);
%!%@y
%!%main_i:=effective_char_info(main_f,cur_l);
%!%@z

% disabled in original tex-src-special.ch
 @x [47.1083] l.20966 - source specials
  if every_vbox<>null then begin_token_list(every_vbox,every_vbox_text);
 @y
  if (insert_src_special_every_vbox) then insert_src_special;
  if every_vbox<>null then begin_token_list(every_vbox,every_vbox_text);
 @z

% disabled in original tex-src-special.ch
 @x [47.1083] l.20969 - source specials
  if every_hbox<>null then begin_token_list(every_hbox,every_hbox_text);
 @y
  if (insert_src_special_every_hbox) then insert_src_special;
  if every_hbox<>null then begin_token_list(every_hbox,every_hbox_text);
 @z

@x MuLTeX: [47.1090] new case for vmode+jletter
vmode+letter,vmode+other_char,vmode+char_num,vmode+char_given,
@y
vmode+letter,vmode+jletter,vmode+other_char,vmode+char_num,vmode+char_given,
@z

@x [47.1091] l.21064 - source specials
if indented then
  begin tail:=new_null_box; link(head):=tail; width(tail):=par_indent;@+
  end;
@y
if indented then
  begin tail:=new_null_box; link(head):=tail; width(tail):=par_indent;
  if (insert_src_special_every_par) then insert_src_special;@+
  end;
@z

% disabled in original tex-src-special.ch, conflicts with etex.
 @x [47.1096] l.21121 - source specials
  else line_break(widow_penalty);
 @y
  else begin
    if (insert_src_special_every_parend) then insert_src_special;
    line_break(widow_penalty);
  end;
 @z

@x MuLTeX: [47.1123] l.21443 make accent workable for japanese char too
begin scan_char_num; f:=cur_font; p:=new_character(f,cur_val);
@y
begin scan_j_char_num;
if is_mlrep(cur_val) then begin f:=get_ml_font(mlrep_mc(cur_val));
  p:=new_character(f,cur_val);
  end
else begin f:=cur_font;
  p:=new_character(f,cur_val);
  end;
@z

@x MuLTeX: [47.1124] l.21459 make accent workable for japanese character
if (cur_cmd=letter)or(cur_cmd=other_char)or(cur_cmd=char_given) then
  q:=new_character(f,cur_chr)
else if cur_cmd=char_num then
  begin scan_char_num; q:=new_character(f,cur_val);
  end
else back_input
@y
if (cur_cmd=letter)or(cur_cmd=other_char)or(cur_cmd=char_given) then
  q:=new_character(f,cur_chr)
else if cur_cmd=jletter then begin
    f:=get_ml_font(mlrep_mc(cur_chr));
    q:=new_character(f,cur_chr); end
  else if cur_cmd=char_num then
      begin scan_j_char_num;
        if is_mlrep(cur_val) then begin
          f:=get_ml_font(mlrep_mc(cur_val));
	  q:=new_character(f,cur_val); end
        else q:=new_character(f,cur_val); end
  else back_input
@z

@x [48.1139] l.21650 - source specials
if every_math<>null then begin_token_list(every_math,every_math_text);
@y
if (insert_src_special_every_math) then insert_src_special;
if every_math<>null then begin_token_list(every_math,every_math_text);
@z

% disabled in original tex-src-special.ch
 @x [48.1145] l.21705 - source specials
if every_display<>null then begin_token_list(every_display,every_display_text);
 @y
if (insert_src_special_every_display) then append_src_special;
if every_display<>null then begin_token_list(every_display,every_display_text);
 @z

@x MuLTeX: [48.???] l.21862 new case for mmode+jletter
mmode+letter,mmode+other_char,mmode+char_given:
  set_math_char(ho(math_code(cur_chr)));
@y
mmode+letter,mmode+other_char,mmode+char_given:
  set_math_char(ho(math_code(cur_chr)));
mmode+jletter:
  @<Multi-lingual char in math@>;
@z

@x [48.1167] l.22042 - source specials
  if every_vbox<>null then begin_token_list(every_vbox,every_vbox_text);
@y
  if (insert_src_special_every_vbox) then insert_src_special;
  if every_vbox<>null then begin_token_list(every_vbox,every_vbox_text);
@z

@x JTeX: [48.1196] l.22356
@<Finish math in text@>=
begin tail_append(new_math(math_surround,before));
@y
@<Finish math in text@>=
begin
@<Kinsoku shori; insert or omit glue between jletter and math@>;
tail_append(new_math(math_surround,before));
@z

@x [49.1210] delayed: hook for new prefixed commands
any_mode(def_font),
@y
any_mode(def_font),
@<New prefixed commands@>
@z

@x [49.1215] l.22719 - hash_extra
if (cur_cs=0)or(cur_cs>frozen_control_sequence) then
@y
if (cur_cs=0)or(cur_cs>eqtb_top)or
  ((cur_cs>frozen_control_sequence)and(cur_cs<=eqtb_size)) then
@z

@x [49.1217] MuLTeX:
@<Assignments@>=
set_font: define(cur_font_loc,data,cur_chr);
@y
@<Assignments@>=
set_font: if ml_font_mc(cur_chr)=mc_ascii then
  define(cur_font_loc,data,cur_chr)
else begin n:=ml_font_mc(cur_chr);
  define(cur_ml_font_loc(n),data,cur_chr);
  k:=param_base[cur_ml_font(n)]; {decr(param_base[f] in [30.576]}
  if ml_font_agl(n) and (font_params[cur_chr]>=15) then begin
    make_ml_skip(2); define(ml_iskip_base+n,glue_ref,p);
    make_ml_skip(7); define(ml_askip_base+n,glue_ref,p);
    make_ml_skip(10); define(ml_mskip_base+n,glue_ref,p);
    make_ml_skip(13); define(ml_sskip_base+n,glue_ref,p);
    end;
  end;
@z

@x [49.1221] delayed: add ref count of box in let
  if cur_cmd>=call then add_token_ref(cur_chr);
  define(p,cur_cmd,cur_chr);
@y
  if cur_cmd>=call then add_token_ref(cur_chr)
  else if cur_cmd=demmand_font then add_df_ref(cur_chr);
  define(p,cur_cmd,cur_chr);
@z

@x [49.1222] l.22794 - MLTeX: \charsubdef primitive
@d toks_def_code=6 {|shorthand_def| for \.{\\toksdef}}
@y
@d toks_def_code=6 {|shorthand_def| for \.{\\toksdef}}
@d char_sub_def_code=7 {|shorthand_def| for \.{\\charsubdef}}
@z

@x [49.1222] l.22810 - MLTeX: \charsubdef primitive
@!@:toks_def_}{\.{\\toksdef} primitive@>
@y
@!@:toks_def_}{\.{\\toksdef} primitive@>
if mltex_p then
  begin
  primitive("charsubdef",shorthand_def,char_sub_def_code);@/
@!@:char_sub_def_}{\.{\\charsubdef} primitive@>
  end;
@z

@x [49.1222] l.22820 - MLTeX: \charsubdef primitive
  othercases print_esc("toksdef")
@y
  char_sub_def_code: print_esc("charsubdef");
  othercases print_esc("toksdef")
@z

@x [49.1222] l.22833 - MLTeX: \charsubdef primitive
shorthand_def: begin n:=cur_chr; get_r_token; p:=cur_cs; define(p,relax,256);
@y
shorthand_def: if cur_chr=char_sub_def_code then
 begin scan_char_num; p:=char_sub_code_base+cur_val; scan_optional_equals;
  scan_char_num; n:=cur_val; {accent character in substitution}
  scan_char_num;
  if (tracing_char_sub_def>0) then
    begin begin_diagnostic; print_nl("New character substitution: ");
    print_ASCII(p-char_sub_code_base); print(" = ");
    print_ASCII(n); print_char(" ");
    print_ASCII(cur_val); end_diagnostic(false);
    end;
  n:=n*256+cur_val;
  define(p,data,hi(n));
  if (p-char_sub_code_base)<char_sub_def_min then
    word_define(int_base+char_sub_def_min_code,p-char_sub_code_base);
  if (p-char_sub_code_base)>char_sub_def_max then
    word_define(int_base+char_sub_def_max_code,p-char_sub_code_base);
 end
else begin n:=cur_chr; get_r_token; p:=cur_cs; define(p,relax,256);
@z

@x [49.1230] MuLTeX: ml catcode, kinsoku, ascpunct
primitive("catcode",def_code,cat_code_base);
@!@:cat_code_}{\.{\\catcode} primitive@>
@y
primitive("catcode",def_code,cat_code_base);
@!@:cat_code_}{\.{\\catcode} primitive@>
primitive("kinsokucode",def_code,kinsoku_code_base);@/
@!@:kinsokucode_}{\.{\\kinsokucode} primitive@>
primitive("asciipunct",def_code,asc_punct_base);@/
@!@:asciipunct_}{\.{\\asciipunct} primitive@>
@z

@x [49.1231] MuLTeX: ml catcode, kinsoku, ascpunct
def_code: if chr_code=cat_code_base then print_esc("catcode")
@y
def_code: if chr_code=cat_code_base then print_esc("catcode")
  else if chr_code=kinsoku_code_base then print_esc("kinsokucode")
  else if chr_code=asc_punct_base then print_esc("asciipunct")
@z

@x [49.1232] MuLTeX: ml catcode, kinsoku, ascpunct
def_code: begin @<Let |n| be the largest legal code value, based on |cur_chr|@>;
  p:=cur_chr; scan_char_num; p:=p+cur_val; scan_optional_equals;
@y
def_code: begin @<Let |n| be the largest legal code value, based on |cur_chr|@>;
  p:=cur_chr;
  if p=cat_code_base then begin scan_j_char_num;
    if is_mlrep(cur_val) then begin p:=ml_cat_code_base;
      cur_val:=set_ml_catcode_idx(cur_val);
      end;
    end
  else if p=kinsoku_code_base then begin scan_j_char_num;
    if is_mlrep(cur_val) then begin p:=ml_kinsoku_code_base;
      cur_val:=set_ml_kinsoku_idx(cur_val);
      end;
    end
  else scan_char_num;
  p:=p+cur_val; scan_optional_equals;
@z

@x [49.1252] l.23230 - INI = VIR, so have to do runtime test.
    begin @!init new_patterns; goto done;@;@+tini@/
@y  23215
    begin @!Init new_patterns; goto done;@;@+Tini@/
@z

@x MuLTeX: [49.1257] filename and jendlinetype
procedure new_font(@!a:small_number);
label common_ending;
var u:pointer; {user's font identifier}
@y
procedure new_font(@!a:small_number);
label common_ending;
var u:pointer; {user's font identifier}
@!save_jendline_type:integer;
@z
@x MuLTeX: [49.1258] filename and jendlinetype
@ @<Scan the font size specification@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
@y
@ @<Scan the font size specification@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
save_jendline_type:=jendline_type; jendline_type:=jend_ascii;
@z
@x MuLTeX: [49.1258] filename and jendlinetype
else s:=-1000;
name_in_progress:=false
@y
else s:=-1000;
name_in_progress:=false; jendline_type:=save_jendline_type
@z

% undo Knuth's change because
%   a) the string is already replaced in |scan_file_name| and therefore
%   b) the wrong string will get flushed!!!
%
@x [49.1260] l.23331 new_font: string recycling -- already done
flushable_string:=str_ptr-1;
@y
@z

% If you don't want to remove code with the following change,
% please replace the former change by
%
% @x
% flushable_string:=str_ptr-1;
% @y
% if cur_name=str_ptr-1 then
%   flushable_string:=str_ptr-1
% else
%   flushable_string:=str_ptr;  {number of a non-existing}
% @z
%
% otherwise the wrong string will get removed by |flush_string|!!
%
@x [49.1260] l.23334 new_font: string recycling -- already done
    begin if cur_name=flushable_string then
      begin flush_string; cur_name:=font_name[f];
      end;
    if s>0 then
@y
    begin if s>0 then
@z

@x [49.1265] if batchmode, mktex... scripts should be silent.
interaction:=cur_chr;
@y
interaction:=cur_chr;
if interaction = batch_mode
then kpse_make_tex_discard_errors := 1
else kpse_make_tex_discard_errors := 0;
@z

@x [49.1275] l.23434 - Index variable for next fragment of code.
@!n:0..15; {stream number}
@y
@!n:0..15; {stream number}
@!k:integer;
@z

@x [49.1275] l.23441 - Same stuff as for \input, this time for \openin. MuLTeX
  if cur_ext="" then cur_ext:=".tex";
  pack_cur_name;
  if a_open_in(read_file[n]) then read_open[n]:=just_open;
@y
  pack_cur_name;
  tex_input_type:=0; {Tell |open_input| we are \.{\\openin}.}
  if open_in_name_ok(stringcast(name_of_file+1))
     and a_open_in(read_file[n], kpse_tex_format) then
    begin k:=1;
    name_in_progress:=true;
    begin_name;
    stop_at_space:=false;
    while (k<=name_length)and(more_name(name_of_file[k])) do
      incr(k);
    stop_at_space:=true;
    end_name;
    name_in_progress:=false;
    read_open[n]:=just_open;
    @<Set multi-lingual |read_file| type@>;
    end;
@z

@x [50.1301] l.23679 - INI = VIR, so runtime test.
format_ident:=" (INITEX)";
@y
if ini_version then format_ident:=" (INITEX)";
@z

@x [50.1302] l.23690 - Eliminate now-unused variable `w' in `store_fmt_file'.
@!w: four_quarters; {four ASCII codes}
@y
@z

@x [50.1302] l.23694 - MLTeX: dump |mltex_p| to fmt file
@<Dump constants for consistency check@>;
@y
@<Dump constants for consistency check@>;
dump_int(@"4D4C5458);  {ML\TeX's magic constant: "MLTX"}
if mltex_p then dump_int(1)
else dump_int(0);
@z

@x MuLTeX: [50.1302] you need to dump
@<Dump the hyphenation tables@>;
@y
@<Dump the hyphenation tables@>;
@<Dump the multi-lingual tables@>;
@<Dump the Kinsoku tables@>;
@z

@x [50.1303] l.23722 - Ditto, for `load_fmt_file'.
@!w: four_quarters; {four ASCII codes}
@y
@z

@x [50.1303] l.23694 - MLTeX: undump |mltex_enabled_p| from fmt file
begin @<Undump constants for consistency check@>;
@y
begin @<Undump constants for consistency check@>;
undump_int(x);   {check magic constant of ML\TeX}
if x<>@"4D4C5458 then goto bad_fmt;
undump_int(x);   {undump |mltex_p| flag into |mltex_enabled_p|}
if x=1 then mltex_enabled_p:=true
else if x<>0 then goto bad_fmt;
@z

@x MuLTeX: [50.1303] corresponding undump
@<Undump the hyphenation tables@>;
@y
@<Undump the hyphenation tables@>;
@<Undump the multi-lingual tables@>;
@<Undump the Kinsoku tables@>;
@z

@x [50.1305] l.23751 - Do dumping and undumping of fmt files in C.
@d dump_wd(#)==begin fmt_file^:=#; put(fmt_file);@+end
@d dump_int(#)==begin fmt_file^.int:=#; put(fmt_file);@+end
@d dump_hh(#)==begin fmt_file^.hh:=#; put(fmt_file);@+end
@d dump_qqqq(#)==begin fmt_file^.qqqq:=#; put(fmt_file);@+end
@y
@z
@x [1306]
@d undump_wd(#)==begin get(fmt_file); #:=fmt_file^;@+end
@d undump_int(#)==begin get(fmt_file); #:=fmt_file^.int;@+end
@d undump_hh(#)==begin get(fmt_file); #:=fmt_file^.hh;@+end
@d undump_qqqq(#)==begin get(fmt_file); #:=fmt_file^.qqqq;@+end
@y
@z
@x [still 1306] debug format file
@d undump_size_end_end(#)==too_small(#)@+else undump_end_end
@y
@d format_debug_end(#)==
    write_ln (stderr, ' = ', #);
  end;
@d format_debug(#)==
  if debug_format_file then begin
    write (stderr, 'fmtdebug:', #);
    format_debug_end
@d undump_size_end_end(#)==
  too_small(#)@+else format_debug (#)(x); undump_end_end
@z

@x [50,1307] l.23779 - texarray
dump_int(@$);@/
@y
dump_int(@$);@/
dump_int(max_halfword);@/
dump_int(hash_high);
@z

%%%%%%%% dynamic hyph_size
@x 23784 m.1307
dump_int(hyph_size)
@y  23784
dump_int(hyph_prime)
@z

@x [50.1308] l.23793 - texarray
x:=fmt_file^.int;
if x<>@$ then goto bad_fmt; {check that strings are the same}
@y
@+Init
libc_free(font_info); libc_free(str_pool); libc_free(str_start);
libc_free(yhash); libc_free(zeqtb); libc_free(yzmem);
@+Tini
undump_int(x);
format_debug('string pool checksum')(x);
if x<>@$ then goto bad_fmt; {check that strings are the same}
undump_int(x);
if x<>max_halfword then goto bad_fmt; {check |max_halfword|}
undump_int(hash_high);
  if (hash_high<0)or(hash_high>sup_hash_extra) then goto bad_fmt;
  if hash_extra<hash_high then hash_extra:=hash_high;
  eqtb_top:=eqtb_size+hash_extra;
  if hash_extra=0 then hash_top:=undefined_control_sequence else
        hash_top:=eqtb_top;
  yhash:=xmalloc_array(two_halves,1+hash_top-hash_offset);
  hash:=yhash - hash_offset;
  next(hash_base):=0; text(hash_base):=0;
  for x:=hash_base+1 to hash_top do hash[x]:=hash[hash_base];
  zeqtb:=xmalloc_array (memory_word,eqtb_top+1);
  eqtb:=zeqtb;

  eq_type(undefined_control_sequence):=undefined_cs;
  equiv(undefined_control_sequence):=null;
  eq_level(undefined_control_sequence):=level_zero;
  for x:=eqtb_size+1 to eqtb_top do
    eqtb[x]:=eqtb[undefined_control_sequence];
@z

@x [50.1308] l.23795 - texarray
undump_int(x);
if x<>mem_bot then goto bad_fmt;
undump_int(x);
if x<>mem_top then goto bad_fmt;
@y
undump_int(x); format_debug ('mem_bot')(x);
if x<>mem_bot then goto bad_fmt;
undump_int(mem_top); format_debug ('mem_top')(mem_top);
if mem_bot+1100>mem_top then goto bad_fmt;


head:=contrib_head; tail:=contrib_head;
     page_tail:=page_head;  {page initialization}

mem_min := mem_bot - extra_mem_bot;
mem_max := mem_top + extra_mem_top;

yzmem:=xmalloc_array (memory_word, mem_max - mem_min);
zmem := yzmem - mem_min;   {this pointer arithmetic fails with some compilers}
mem := zmem;
@z

%%%%%%%% dynamic hyph_size
@x 23804 m.1308
if x<>hyph_size then goto bad_fmt
@y  23804
if x<>hyph_prime then goto bad_fmt
@z

% [1309] Make dumping/undumping more efficient by doing whole arrays at
% a time, via fread/fwrite in texmfmp.c.
@x [50.1309] l.23814 - Make dumping/undumping more efficient.
for k:=0 to str_ptr do dump_int(str_start[k]);
k:=0;
while k+4<pool_ptr do
  begin dump_four_ASCII; k:=k+4;
  end;
k:=pool_ptr-4; dump_four_ASCII;
@y
dump_things(str_start[0], str_ptr+1);
dump_things(str_pool[0], pool_ptr);
@z

@x [50.1310] l.23829 - Make dumping/undumping more efficient.
undump_size(0)(pool_size)('string pool size')(pool_ptr);
undump_size(0)(max_strings)('max strings')(str_ptr);
for k:=0 to str_ptr do undump(0)(pool_ptr)(str_start[k]);
k:=0;
while k+4<pool_ptr do
  begin undump_four_ASCII; k:=k+4;
  end;
k:=pool_ptr-4; undump_four_ASCII;
@y
undump_size(0)(sup_pool_size-pool_free)('string pool size')(pool_ptr);
if pool_size<pool_ptr+pool_free then
  pool_size:=pool_ptr+pool_free;
undump_size(0)(sup_max_strings-strings_free)('sup strings')(str_ptr);@/
if max_strings<str_ptr+strings_free then
  max_strings:=str_ptr+strings_free;
str_start:=xmalloc_array(pool_pointer, max_strings);
undump_checked_things(0, pool_ptr, str_start[0], str_ptr+1);@/
str_pool:=xmalloc_array(packed_ASCII_code, pool_size);
undump_things(str_pool[0], pool_ptr);
@z

@x [50.1311] l.23850 - Make dumping/undumping more efficient.
repeat for k:=p to q+1 do dump_wd(mem[k]);
@y
repeat dump_things(mem[p], q+2-p);
@z

@x [50.1311] l.23855 - Make dumping/undumping more efficient.
for k:=p to lo_mem_max do dump_wd(mem[k]);
@y
dump_things(mem[p], lo_mem_max+1-p);
@z

@x [50.1311] l.23858 - Make dumping/undumping more efficient.
for k:=hi_mem_min to mem_end do dump_wd(mem[k]);
@y
dump_things(mem[hi_mem_min], mem_end+1-hi_mem_min);
@z

@x [50.1312] l.23873 - Make dumping/undumping more efficient.
repeat for k:=p to q+1 do undump_wd(mem[k]);
@y
repeat undump_things(mem[p], q+2-p);
@z

@x [50.1312] l.23878 - Make dumping/undumping more efficient.
for k:=p to lo_mem_max do undump_wd(mem[k]);
@y
undump_things(mem[p], lo_mem_max+1-p);
@z

@x [50.1312] l.23888 - Make dumping/undumping more efficient.
for k:=hi_mem_min to mem_end do undump_wd(mem[k]);
@y
undump_things (mem[hi_mem_min], mem_end+1-hi_mem_min);
@z

@x [50.1314] l.23899 - hash_extra, source specials
undump(hash_base)(frozen_control_sequence)(par_loc);
par_token:=cs_token_flag+par_loc;@/
undump(hash_base)(frozen_control_sequence)(write_loc);@/
@y
undump(hash_base)(hash_top)(par_loc);
par_token:=cs_token_flag+par_loc;@/
undump(hash_base)(hash_top)(write_loc);@/
@z

@x [50.1315] l.23925 - Make dumping/undumping more efficient - eqtb
while k<l do
  begin dump_wd(eqtb[k]); incr(k);
  end;
@y
dump_things(eqtb[k], l-k);
@z

@x [50.1316] l.23944 - Make dumping/undumping more efficient - eqtb
while k<l do
  begin dump_wd(eqtb[k]); incr(k);
  end;
@y
dump_things(eqtb[k], l-k);
@z

@x [50.1316] l.23947 - hash_extra
k:=j+1; dump_int(k-l);
until k>eqtb_size
@y
k:=j+1; dump_int(k-l);
until k>eqtb_size;
if hash_high>0 then dump_things(eqtb[eqtb_size+1],hash_high);
  {dump |hash_extra| part}
@z

@x [50.1317] l.23958 - Make dumping/undumping more efficient - eqtb
for j:=k to k+x-1 do undump_wd(eqtb[j]);
@y
undump_things(eqtb[k], x);
@z

@x [50.1317] l.23960 - hash_extra
until k>eqtb_size
@y
until k>eqtb_size;
if hash_high>0 then undump_things(eqtb[eqtb_size+1],hash_high);
  {undump |hash_extra| part}
@z

@x [50.1318] l.23968 - hash_extra
dump_int(hash_used); cs_count:=frozen_control_sequence-1-hash_used;
@y  23968
dump_int(hash_used); cs_count:=frozen_control_sequence-1-hash_used+hash_high;
@z

@x [50.1318] l.23972 - Make dumping/undumping more efficient, hash_extra
for p:=hash_used+1 to undefined_control_sequence-1 do dump_hh(hash[p]);
@y
dump_things(hash[hash_used+1], undefined_control_sequence-1-hash_used);
if hash_high>0 then dump_things(hash[eqtb_size+1], hash_high);
@z

@x [50.1319] l.23980 - Make dumping/undumping more efficient, hash_extra
for p:=hash_used+1 to undefined_control_sequence-1 do undump_hh(hash[p]);
@y
undump_things (hash[hash_used+1], undefined_control_sequence-1-hash_used);
if debug_format_file then begin
  print_csnames (hash_base, undefined_control_sequence - 1);
end;
if hash_high > 0 then begin
  undump_things (hash[eqtb_size+1], hash_high);
  if debug_format_file then begin
    print_csnames (eqtb_size + 1, hash_high - (eqtb_size + 1));
  end;
end;
@z

@x [50.1320] l.23985 - Make dumping/undumping more efficient - tfm
for k:=0 to fmem_ptr-1 do dump_wd(font_info[k]);
dump_int(font_ptr);
for k:=null_font to font_ptr do
  @<Dump the array info for internal font number |k|@>;
@y
dump_things(font_info[0], fmem_ptr);
dump_int(font_ptr);
@<Dump the array info for internal font number |k|@>;
@z

@x [50.1320] l.23991 - i18n fix
print_int(font_ptr-font_base); print(" preloaded font");
if font_ptr<>font_base+1 then print_char("s")
@y
print_int(font_ptr-font_base);
if font_ptr<>font_base+1 then print(" preloaded fonts")
else print(" preloaded font")
@z

@x [50.1321] l.23994 - texarray
undump_size(7)(font_mem_size)('font mem size')(fmem_ptr);
for k:=0 to fmem_ptr-1 do undump_wd(font_info[k]);
undump_size(font_base)(font_max)('font max')(font_ptr);
for k:=null_font to font_ptr do
  @<Undump the array info for internal font number |k|@>
@y
undump_size(7)(sup_font_mem_size)('font mem size')(fmem_ptr);
if fmem_ptr>font_mem_size then font_mem_size:=fmem_ptr;
font_info:=xmalloc_array(fmemory_word, font_mem_size);
undump_things(font_info[0], fmem_ptr);@/
undump_size(font_base)(font_base+max_font_max)('font max')(font_ptr);
{This undumps all of the font info, despite the name.}
@<Undump the array info for internal font number |k|@>;
@z

% [50.1322] Dumping font_info.
% Knuth's code writes all the information relevant to a single font
% in the same section of the fmt file.  But it's a lot faster to
% write the arrays of information out, one whole array at a time.
% So that's the way we handle dumping and undumping font info.
@x [50.1322] l.24000 - Make dumping/undumping more efficient - tfm
@ @<Dump the array info for internal font number |k|@>=
begin dump_qqqq(font_check[k]);
dump_int(font_size[k]);
dump_int(font_dsize[k]);
dump_int(font_params[k]);@/
dump_int(hyphen_char[k]);
dump_int(skew_char[k]);@/
dump_int(font_name[k]);
dump_int(font_area[k]);@/
dump_int(font_bc[k]);
dump_int(font_ec[k]);@/
dump_int(char_base[k]);
dump_int(width_base[k]);
dump_int(height_base[k]);@/
dump_int(depth_base[k]);
dump_int(italic_base[k]);
dump_int(lig_kern_base[k]);@/
dump_int(kern_base[k]);
dump_int(exten_base[k]);
dump_int(param_base[k]);@/
dump_int(font_glue[k]);@/
dump_int(bchar_label[k]);
dump_int(font_bchar[k]);
dump_int(font_false_bchar[k]);@/
print_nl("\font"); print_esc(font_id_text(k)); print_char("=");
print_file_name(font_name[k],font_area[k],"");
if font_size[k]<>font_dsize[k] then
  begin print(" at "); print_scaled(font_size[k]); print("pt");
  end;
end
@y
@ @<Dump the array info for internal font number |k|@>=
begin
dump_things(font_check[null_font], font_ptr+1-null_font);
dump_things(font_mcset[null_font], font_ptr+1-null_font); {MuLTeX}
dump_things(font_fmtype[null_font], font_ptr+1-null_font); {MuLTeX}
dump_things(font_lcd[null_font], font_ptr+1-null_font); {MuLTeX}
dump_things(font_size[null_font], font_ptr+1-null_font);
dump_things(font_dsize[null_font], font_ptr+1-null_font);
dump_things(font_params[null_font], font_ptr+1-null_font);
dump_things(hyphen_char[null_font], font_ptr+1-null_font);
dump_things(skew_char[null_font], font_ptr+1-null_font);
dump_things(font_name[null_font], font_ptr+1-null_font);
dump_things(font_area[null_font], font_ptr+1-null_font);
dump_things(font_bc[null_font], font_ptr+1-null_font);
dump_things(font_ec[null_font], font_ptr+1-null_font);
dump_things(char_base[null_font], font_ptr+1-null_font);
dump_things(ctype_base[null_font], font_ptr+1-null_font); {MuLTeX}
dump_things(width_base[null_font], font_ptr+1-null_font);
dump_things(height_base[null_font], font_ptr+1-null_font);
dump_things(depth_base[null_font], font_ptr+1-null_font);
dump_things(italic_base[null_font], font_ptr+1-null_font);
dump_things(lig_kern_base[null_font], font_ptr+1-null_font);
dump_things(kern_base[null_font], font_ptr+1-null_font);
dump_things(exten_base[null_font], font_ptr+1-null_font);
dump_things(param_base[null_font], font_ptr+1-null_font);
dump_things(font_glue[null_font], font_ptr+1-null_font);
dump_things(bchar_label[null_font], font_ptr+1-null_font);
dump_things(font_bchar[null_font], font_ptr+1-null_font);
dump_things(font_false_bchar[null_font], font_ptr+1-null_font);
for k:=null_font to font_ptr do
  begin print_nl("\font"); print_esc(font_id_text(k)); print_char("=");
  print_file_name(font_name[k],font_area[k],"");
  if font_size[k]<>font_dsize[k] then
    begin print(" at "); print_scaled(font_size[k]); print("pt");
    end;
  end;
end
@z

@x [50.1322] l.24031 - Make dumping/undumping more efficient - tfm
@ @<Undump the array info for internal font number |k|@>=
begin undump_qqqq(font_check[k]);@/
undump_int(font_size[k]);
undump_int(font_dsize[k]);
undump(min_halfword)(max_halfword)(font_params[k]);@/
undump_int(hyphen_char[k]);
undump_int(skew_char[k]);@/
undump(0)(str_ptr)(font_name[k]);
undump(0)(str_ptr)(font_area[k]);@/
undump(0)(255)(font_bc[k]);
undump(0)(255)(font_ec[k]);@/
undump_int(char_base[k]);
undump_int(width_base[k]);
undump_int(height_base[k]);@/
undump_int(depth_base[k]);
undump_int(italic_base[k]);
undump_int(lig_kern_base[k]);@/
undump_int(kern_base[k]);
undump_int(exten_base[k]);
undump_int(param_base[k]);@/
undump(min_halfword)(lo_mem_max)(font_glue[k]);@/
undump(0)(fmem_ptr-1)(bchar_label[k]);
undump(min_quarterword)(non_char)(font_bchar[k]);
undump(min_quarterword)(non_char)(font_false_bchar[k]);
end
@y
@ This module should now be named `Undump all the font arrays'.

@<Undump the array info for internal font number |k|@>=
begin {Allocate the font arrays}
font_check:=xmalloc_array(four_quarters, font_max);
font_mcset:=xmalloc_array(quarterword, font_max); {MuLTeX}
font_fmtype:=xmalloc_array(small_number, font_max); {MuLTeX}
font_lcd:=xmalloc_array(halfword, font_max); {MuLTeX}
font_size:=xmalloc_array(scaled, font_max);
font_dsize:=xmalloc_array(scaled, font_max);
font_params:=xmalloc_array(font_index, font_max);
font_name:=xmalloc_array(str_number, font_max);
font_area:=xmalloc_array(str_number, font_max);
font_bc:=xmalloc_array(eight_bits, font_max);
font_ec:=xmalloc_array(eight_bits, font_max);
font_glue:=xmalloc_array(halfword, font_max);
hyphen_char:=xmalloc_array(integer, font_max);
skew_char:=xmalloc_array(integer, font_max);
bchar_label:=xmalloc_array(font_index, font_max);
font_bchar:=xmalloc_array(nine_bits, font_max);
font_false_bchar:=xmalloc_array(nine_bits, font_max);
char_base:=xmalloc_array(integer, font_max);
ctype_base:=xmalloc_array(integer, font_max); {MuLTeX}
width_base:=xmalloc_array(integer, font_max);
height_base:=xmalloc_array(integer, font_max);
depth_base:=xmalloc_array(integer, font_max);
italic_base:=xmalloc_array(integer, font_max);
lig_kern_base:=xmalloc_array(integer, font_max);
kern_base:=xmalloc_array(integer, font_max);
exten_base:=xmalloc_array(integer, font_max);
param_base:=xmalloc_array(integer, font_max);

undump_things(font_check[null_font], font_ptr+1-null_font);
undump_things(font_mcset[null_font], font_ptr+1-null_font); {MuLTeX}
undump_things(font_fmtype[null_font], font_ptr+1-null_font); {MuLTeX}
undump_things(font_lcd[null_font], font_ptr+1-null_font); {MuLTeX}
undump_things(font_size[null_font], font_ptr+1-null_font);
undump_things(font_dsize[null_font], font_ptr+1-null_font);
undump_checked_things(min_halfword, max_halfword,
                      font_params[null_font], font_ptr+1-null_font);
undump_things(hyphen_char[null_font], font_ptr+1-null_font);
undump_things(skew_char[null_font], font_ptr+1-null_font);
undump_upper_check_things(str_ptr, font_name[null_font], font_ptr+1-null_font);
undump_upper_check_things(str_ptr, font_area[null_font], font_ptr+1-null_font);
{There's no point in checking these values against the range $[0,255]$,
 since the data type is |unsigned char|, and all values of that type are
 in that range by definition.}
undump_things(font_bc[null_font], font_ptr+1-null_font);
undump_things(font_ec[null_font], font_ptr+1-null_font);
undump_things(char_base[null_font], font_ptr+1-null_font);
undump_things(ctype_base[null_font], font_ptr+1-null_font); {MuLTeX}
undump_things(width_base[null_font], font_ptr+1-null_font);
undump_things(height_base[null_font], font_ptr+1-null_font);
undump_things(depth_base[null_font], font_ptr+1-null_font);
undump_things(italic_base[null_font], font_ptr+1-null_font);
undump_things(lig_kern_base[null_font], font_ptr+1-null_font);
undump_things(kern_base[null_font], font_ptr+1-null_font);
undump_things(exten_base[null_font], font_ptr+1-null_font);
undump_things(param_base[null_font], font_ptr+1-null_font);
undump_checked_things(min_halfword, lo_mem_max,
                     font_glue[null_font], font_ptr+1-null_font);
undump_checked_things(0, fmem_ptr-1,
                     bchar_label[null_font], font_ptr+1-null_font);
undump_checked_things(min_quarterword, non_char,
                     font_bchar[null_font], font_ptr+1-null_font);
undump_checked_things(min_quarterword, non_char,
                     font_false_bchar[null_font], font_ptr+1-null_font);
end
@z

%%%%%%%% dynamic hyph_size
@x 24058 m.1324
dump_int(hyph_count);
for k:=0 to hyph_size do if hyph_word[k]<>0 then
  begin dump_int(k); dump_int(hyph_word[k]); dump_int(hyph_list[k]);
  end;
@y  24061
dump_int(hyph_count);
if hyph_next <= hyph_prime then hyph_next:=hyph_size;
dump_int(hyph_next);{minumum value of |hyphen_size| needed}
for k:=0 to hyph_size do if hyph_word[k]<>0 then
  begin dump_int(k+65536*hyph_link[k]);
        {assumes number of hyphen exceptions does not exceed 65535}
   dump_int(hyph_word[k]); dump_int(hyph_list[k]);
  end;
@z

@x [50.1324] l.24063 - i18n fix
print_ln; print_int(hyph_count); print(" hyphenation exception");
if hyph_count<>1 then print_char("s");
@y
print_ln; print_int(hyph_count);
if hyph_count<>1 then print(" hyphenation exceptions")
else print(" hyphenation exception");
@z

@x [50.1324] l.24066 - Make dumping/undumping more efficient - trie
for k:=0 to trie_max do dump_hh(trie[k]);
dump_int(trie_op_ptr);
for k:=1 to trie_op_ptr do
  begin dump_int(hyf_distance[k]);
  dump_int(hyf_num[k]);
  dump_int(hyf_next[k]);
  end;
@y
dump_things(trie_trl[0], trie_max+1);
dump_things(trie_tro[0], trie_max+1);
dump_things(trie_trc[0], trie_max+1);
dump_int(trie_op_ptr);
dump_things(hyf_distance[1], trie_op_ptr);
dump_things(hyf_num[1], trie_op_ptr);
dump_things(hyf_next[1], trie_op_ptr);
@z

@x [50.1324] l.24076 - i18n fix
print(" has "); print_int(trie_op_ptr); print(" op");
if trie_op_ptr<>1 then print_char("s");
@y
print(" has "); print_int(trie_op_ptr);
if trie_op_ptr<>1 then print(" ops")
else print(" op");
@z

%%%%%%%% dynamic hyph_size
@x 24087 m.1325
undump(0)(hyph_size)(hyph_count);
for k:=1 to hyph_count do
  begin undump(0)(hyph_size)(j);
  undump(0)(str_ptr)(hyph_word[j]);
  undump(min_halfword)(max_halfword)(hyph_list[j]);
  end;
@y  24092
undump_size(0)(hyph_size)('hyph_size')(hyph_count);
undump_size(hyph_prime)(hyph_size)('hyph_size')(hyph_next);
j:=0;
for k:=1 to hyph_count do
  begin undump_int(j); if j<0 then goto bad_fmt;
   if j>65535 then
   begin hyph_next:= j div 65536; j:=j - hyph_next * 65536; end
       else hyph_next:=0;
   if (j>=hyph_size)or(hyph_next>hyph_size) then goto bad_fmt;
   hyph_link[j]:=hyph_next;
  undump(0)(str_ptr)(hyph_word[j]);
  undump(min_halfword)(max_halfword)(hyph_list[j]);
  end;
  {|j| is now the largest occupied location in |hyph_word|}
  incr(j);
  if j<hyph_prime then j:=hyph_prime;
  hyph_next:=j;
  if hyph_next >= hyph_size then hyph_next:=hyph_prime else
  if hyph_next >= hyph_prime then incr(hyph_next);
@z


@x [50.1325] l.24094 - Make dumping/undumping more efficient - trie
for k:=0 to j do undump_hh(trie[k]);
undump_size(0)(trie_op_size)('trie op size')(j); @+init trie_op_ptr:=j;@+tini
for k:=1 to j do
  begin undump(0)(63)(hyf_distance[k]); {a |small_number|}
  undump(0)(63)(hyf_num[k]);
  undump(min_quarterword)(max_quarterword)(hyf_next[k]);
  end;
@y
{These first three haven't been allocated yet unless we're \.{INITEX};
 we do that precisely so we don't allocate more space than necessary.}
if not trie_trl then trie_trl:=xmalloc_array(trie_pointer,j+1);
undump_things(trie_trl[0], j+1);
if not trie_tro then trie_tro:=xmalloc_array(trie_pointer,j+1);
undump_things(trie_tro[0], j+1);
if not trie_trc then trie_trc:=xmalloc_array(quarterword, j+1);
undump_things(trie_trc[0], j+1);
undump_size(0)(trie_op_size)('trie op size')(j); @+init trie_op_ptr:=j;@+tini
{I'm not sure we have such a strict limitation (64) on these values, so
 let's leave them unchecked.}
undump_things(hyf_distance[1], j);
undump_things(hyf_num[1], j);
undump_upper_check_things(max_trie_op, hyf_next[1], j);
@z

@x [50.1327] l.24117 - Allow command line to override dumped value.
undump(batch_mode)(error_stop_mode)(interaction);
@y
undump(batch_mode)(error_stop_mode)(interaction);
if interaction_option<>unspecified_mode then interaction:=interaction_option;
@z

% [50.1327] As with TFM files, `eof' here means `have we previously
% encountered the end-of-file', not `are we at the end of the file'.
@x [50.1327] l.24120 - dumping/undumping, replace eof() by feof()
if (x<>69069)or eof(fmt_file) then goto bad_fmt
@y
if (x<>69069)or feof(fmt_file) then goto bad_fmt
@z

% Eliminate probably wrong word `preloaded' from format_idents.
@x [50.1328] l.24124 
print(" (preloaded format="); print(job_name); print_char(" ");
@y
print(" (format="); print(job_name); print_char(" ");
@z

@x [51.1332] l.24203 - make the main program a procedure, for eqtb hack.
@p begin @!{|start_here|}
@y
@d const_chk(#)==begin if # < inf@&# then # := inf@&# else
                         if # > sup@&# then # := sup@&# end

{|setup_bound_var| stuff duplicated in \.{mf.ch}.}
@d setup_bound_var(#)==bound_default:=#; setup_bound_var_end
@d setup_bound_var_end(#)==bound_name:=#; setup_bound_var_end_end
@d setup_bound_var_end_end(#)==
  setup_bound_variable(address_of(#), bound_name, bound_default);

@p procedure main_body;
begin @!{|start_here|}

{Bounds that may be set from the configuration file. We want the user to
 be able to specify the names with underscores, but \.{TANGLE} removes
 underscores, so we're stuck giving the names twice, once as a string,
 once as the identifier. How ugly.}
  setup_bound_var (250000)('main_memory')(main_memory);
    {|memory_word|s for |mem| in \.{INITEX}}
  setup_bound_var (0)('extra_mem_top')(extra_mem_top);
    {increase high mem in \.{VIRTEX}}
  setup_bound_var (0)('extra_mem_bot')(extra_mem_bot);
    {increase low mem in \.{VIRTEX}}
  setup_bound_var (100000)('pool_size')(pool_size);
  setup_bound_var (75000)('string_vacancies')(string_vacancies);
  setup_bound_var (5000)('pool_free')(pool_free); {min pool avail after fmt}
  setup_bound_var (15000)('max_strings')(max_strings);
  setup_bound_var (100)('strings_free')(strings_free);
  setup_bound_var (100000)('font_mem_size')(font_mem_size);
  setup_bound_var (500)('font_max')(font_max);
  setup_bound_var (20000)('trie_size')(trie_size);
    {if |ssup_trie_size| increases, recompile}
  setup_bound_var (659)('hyph_size')(hyph_size);
  setup_bound_var (3000)('buf_size')(buf_size);
  setup_bound_var (6000)('str_buf_size')(str_buf_size); {MuLTeX}
  setup_bound_var (50)('nest_size')(nest_size);
  setup_bound_var (15)('max_in_open')(max_in_open);
  setup_bound_var (60)('param_size')(param_size);
  setup_bound_var (4000)('save_size')(save_size);
  setup_bound_var (300)('stack_size')(stack_size);
  setup_bound_var (16384)('dvi_buf_size')(dvi_buf_size);
  setup_bound_var (79)('error_line')(error_line);
  setup_bound_var (50)('half_error_line')(half_error_line);
  setup_bound_var (79)('max_print_line')(max_print_line);
  setup_bound_var (0)('hash_extra')(hash_extra);

  const_chk (main_memory);
@+Init
  extra_mem_top := 0;
  extra_mem_bot := 0;
@+Tini
  if extra_mem_bot>sup_main_memory then extra_mem_bot:=sup_main_memory;
  if extra_mem_top>sup_main_memory then extra_mem_top:=sup_main_memory;
  mem_top := mem_bot + main_memory;
  mem_min := mem_bot;
  mem_max := mem_top;

  {Check other constants against their sup and inf.}
  const_chk (trie_size);
  const_chk (hyph_size);
  const_chk (buf_size);
  str_buf_size := buf_size*2;
  const_chk (nest_size);
  const_chk (max_in_open);
  const_chk (param_size);
  const_chk (save_size);
  const_chk (stack_size);
  const_chk (dvi_buf_size);
  const_chk (pool_size);
  const_chk (string_vacancies);
  const_chk (pool_free);
  const_chk (max_strings);
  const_chk (strings_free);
  const_chk (font_mem_size);
  const_chk (font_max);
  const_chk (hash_extra);
  if error_line > ssup_error_line then error_line := ssup_error_line;

  {array memory allocation}
  buffer:=xmalloc_array (ML_code, buf_size);
  str_buffer:=xmalloc_array (ASCII_code, str_buf_size); {MuLTeX}
  nest:=xmalloc_array (list_state_record, nest_size);
  save_stack:=xmalloc_array (memory_word, save_size);
  input_stack:=xmalloc_array (in_state_record, stack_size);
  input_file:=xmalloc_array (alpha_file, max_in_open);
  line_stack:=xmalloc_array (integer, max_in_open);
  source_filename_stack:=xmalloc_array (str_number, max_in_open);
  full_source_filename_stack:=xmalloc_array (str_number, max_in_open);
  ml_input_codetype_stack:=xmalloc_array (memory_word, max_in_open); {MuLTeX}
  param_stack:=xmalloc_array (halfword, param_size);
  dvi_buf:=xmalloc_array (eight_bits, dvi_buf_size);
  hyph_word :=xmalloc_array (str_number, hyph_size);
  hyph_list :=xmalloc_array (halfword, hyph_size);
  hyph_link :=xmalloc_array (hyph_pointer, hyph_size);
@+Init
  yzmem:=xmalloc_array (memory_word, mem_top - mem_bot);
  zmem := yzmem - mem_bot;   {Some compilers require |mem_bot=0|}
  eqtb_top := eqtb_size+hash_extra;
  if hash_extra=0 then hash_top:=undefined_control_sequence else
        hash_top:=eqtb_top;
  yhash:=xmalloc_array (two_halves,1+hash_top-hash_offset);
  hash:=yhash - hash_offset;   {Some compilers require |hash_offset=0|}
  next(hash_base):=0; text(hash_base):=0;
  for hash_used:=hash_base+1 to hash_top do hash[hash_used]:=hash[hash_base];
  zeqtb:=xmalloc_array (memory_word, eqtb_top);
  eqtb:=zeqtb;

  str_start:=xmalloc_array (pool_pointer, max_strings);
  str_pool:=xmalloc_array (packed_ASCII_code, pool_size);
  font_info:=xmalloc_array (fmemory_word, font_mem_size);
@+Tini
@z

@x [51.1332] l.24215 - INI = VIR, so pool init needs runtime test
@!init if not get_strings_started then goto final_end;
init_prim; {call |primitive| for each primitive}
init_str_ptr:=str_ptr; init_pool_ptr:=pool_ptr; fix_date_and_time;
tini@/
@y
@!Init if not get_strings_started then goto final_end;
init_prim; {call |primitive| for each primitive}
init_str_ptr:=str_ptr; init_pool_ptr:=pool_ptr; fix_date_and_time;
Tini@/
@z

@x MuLTeX: [51.1332]
start_of_TEX: @<Initialize the output routines@>;
@<Get the first line of input and prepare to start@>;
@y
{terminal kanji stat should be initialized before first output to terminal}
start_of_TEX: @<Set default multi-lingual terminal type@>;
@<Initialize the output routines@>;
@<Get the first line of input and prepare to start@>;
{terminal kanji type may be changed by format file}
@<Set multi-lingual terminal type and dvi-special type@>;
@z

@x [51.1332] l.24225 - main
end_of_TEX: close_files_and_terminate;
final_end: ready_already:=0;
end.
@y
close_files_and_terminate;
final_end: do_final_end;
end {|main_body|};
@z

@x [51.1333] l.24254 - Print new line before termination; switch to editor if necessary.
    slow_print(log_name); print_char(".");
    end;
  end;
@y
    slow_print(log_name); print_char(".");
    end;
  end;
print_ln;
if (edit_name_start<>0) and (interaction>batch_mode) then
  call_edit(str_pool,edit_name_start,edit_name_length,edit_line);
@z

@x [51.1334] l.24275 - hash_extra
  wlog_ln(' ',cs_count:1,' multiletter control sequences out of ',
    hash_size:1);@/
@y  24276
  wlog_ln(' ',cs_count:1,' multiletter control sequences out of ',
    hash_size:1, '+', hash_extra:1);@/
@z

@x [51.1335] l.24335 - Only do dump if ini.
  begin @!init for c:=top_mark_code to split_bot_mark_code do
@y
  begin @!Init for c:=top_mark_code to split_bot_mark_code do
@z

@x [51.1335] l.24337 - Only do dump if ini.
  store_fmt_file; return;@+tini@/
@y
  store_fmt_file; return;@+Tini@/
@z

@x [51.1337] l.24361 - Handle %&format in all cases.
if (format_ident=0)or(buffer[loc]="&") then
@y
if (format_ident=0)or(buffer[loc]="&")or dump_line then
@z

@x [51.1337] l.24366 - Dynamic arrays size.
  w_close(fmt_file);
@y
  w_close(fmt_file);
  eqtb:=zeqtb;
@z

@x 8bit: [1337]
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the end-of-line-char if it is active@>;
@z

%% [51] m.1337 l.24371 - MLTeX: add. MLTeX banner after loading fmt file
%%                     (MLTeX change: only "if mltex_enabled_p then ....;")
@x [51.1337] l.24371 - Allocate hyphenation tries, do char translation, MLTeX
fix_date_and_time;@/
@y
if mltex_enabled_p then
  begin wterm_ln('MLTeX v2.2 enabled');
  end;
fix_date_and_time;@/

@!init
if trie_not_ready then begin {initex without format loaded}
  trie_trl:=xmalloc_array (trie_pointer, trie_size);
  trie_tro:=xmalloc_array (trie_pointer, trie_size);
  trie_trc:=xmalloc_array (quarterword, trie_size);

  trie_c:=xmalloc_array (packed_ASCII_code, trie_size);
  trie_o:=xmalloc_array (trie_opcode, trie_size);
  trie_l:=xmalloc_array (trie_pointer, trie_size);
  trie_r:=xmalloc_array (trie_pointer, trie_size);
  trie_hash:=xmalloc_array (trie_pointer, trie_size);
  trie_taken:=xmalloc_array (boolean, trie_size);

  trie_root:=0; trie_c[0]:=si(0); trie_ptr:=0;

  {Allocate and initialize font arrays}
  font_check:=xmalloc_array(four_quarters, font_max);
  font_mcset:=xmalloc_array(quarterword, font_max); {MuLTeX}
  font_fmtype:=xmalloc_array(small_number, font_max); {MuLTeX}
  font_lcd:=xmalloc_array(halfword, font_max); {MuLTeX}
  font_size:=xmalloc_array(scaled, font_max);
  font_dsize:=xmalloc_array(scaled, font_max);
  font_params:=xmalloc_array(font_index, font_max);
  font_name:=xmalloc_array(str_number, font_max);
  font_area:=xmalloc_array(str_number, font_max);
  font_bc:=xmalloc_array(eight_bits, font_max);
  font_ec:=xmalloc_array(eight_bits, font_max);
  font_glue:=xmalloc_array(halfword, font_max);
  hyphen_char:=xmalloc_array(integer, font_max);
  skew_char:=xmalloc_array(integer, font_max);
  bchar_label:=xmalloc_array(font_index, font_max);
  font_bchar:=xmalloc_array(nine_bits, font_max);
  font_false_bchar:=xmalloc_array(nine_bits, font_max);
  char_base:=xmalloc_array(integer, font_max);
  ctype_base:=xmalloc_array(integer, font_max); {MuLTeX}
  width_base:=xmalloc_array(integer, font_max);
  height_base:=xmalloc_array(integer, font_max);
  depth_base:=xmalloc_array(integer, font_max);
  italic_base:=xmalloc_array(integer, font_max);
  lig_kern_base:=xmalloc_array(integer, font_max);
  kern_base:=xmalloc_array(integer, font_max);
  exten_base:=xmalloc_array(integer, font_max);
  param_base:=xmalloc_array(integer, font_max);

  font_ptr:=null_font; fmem_ptr:=7;
  font_name[null_font]:="nullfont"; font_area[null_font]:="";
  hyphen_char[null_font]:="-"; skew_char[null_font]:=-1;
  bchar_label[null_font]:=non_address;
  font_bchar[null_font]:=non_char; font_false_bchar[null_font]:=non_char;
  font_bc[null_font]:=1; font_ec[null_font]:=0;
  font_size[null_font]:=0; font_dsize[null_font]:=0;
  font_mcset[null_font]:=mc_ascii;
  font_fmtype[null_font]:=fmtype_tfm;
  char_base[null_font]:=0; width_base[null_font]:=0;
  height_base[null_font]:=0; depth_base[null_font]:=0;
  italic_base[null_font]:=0; lig_kern_base[null_font]:=0;
  kern_base[null_font]:=0; exten_base[null_font]:=0;
  font_glue[null_font]:=null; font_params[null_font]:=7;
  param_base[null_font]:=-1;
  for font_k:=0 to 6 do font_info[font_k].sc:=0;
  end;
  tini@/

  font_used:=xmalloc_array (boolean, font_max);
  for font_k:=font_base to font_max do font_used[font_k]:=false;
@z

@x MuLTeX: [1337]
if (loc<limit)and(cat_code(buffer[loc])<>escape) then start_input;
@y
{mlinputcode may be overriden from argument}
@<Reset |mlinputcodetype| from argument and set |basemlinputcodetype|@>;
if (loc<limit)and(cat_code(buffer[loc])<>escape) then start_input;
@z

% [52.1338] Core-dump in debugging mode on 0 input.  Under Unix, it's
% not possible to portably switch into the debugger while a program is
% running.  The best approximation is to do a core dump, then run the
% debugger on it later.
@x [52.1338] l.24411 - Core-dump in debugging mode on 0 input.
    begin goto breakpoint;@\ {go to every label at least once}
    breakpoint: m:=0; @{'BREAKPOINT'@}@\
    end
@y
    dump_core {do something to cause a core dump}
@z

@x [52.1339] l.24429 - debug - print tfm info
5: print_word(font_info[n]);
@y 24397
5: begin print_scaled(font_info[n].sc); print_char(" ");@/
  print_int(font_info[n].qqqq.b0); print_char(":");@/
  print_int(font_info[n].qqqq.b1); print_char(":");@/
  print_int(font_info[n].qqqq.b2); print_char(":");@/
  print_int(font_info[n].qqqq.b3);
  end;
@z

@x [53.1344] l.24544 - source specials
primitive("special",extension,special_node);@/
@y
primitive("special",extension,special_node);@/
text(frozen_special):="special"; eqtb[frozen_special]:=eqtb[cur_val];@/
@z

% [53.1350] (new_write_whatsit) Allow 18 as a \write stream. We never
% refer to an actual file, though, so we don't need to change the
% write_file or write_open arrays. We provide for disabling this at
% runtime, for paranoids.
@x [53.1350] l.24609 - system: Allow 18 as a \write stream.
  else if cur_val>15 then cur_val:=16;
@y
  else if (cur_val>15) and (cur_val <> 18) then cur_val:=16;
@z

@x [53.13??] MuLTeX: special_out
procedure special_out(@!p:pointer);
var old_setting:0..max_selector; {holds print |selector|}
@!k:pool_pointer; {index into |str_pool|}
@y
procedure special_out(@!p:pointer);
var old_setting:0..max_selector; {holds print |selector|}
@!k:pool_pointer; {index into |str_pool|}
@!len:integer;
@!mlch:ML_code;
@z

@x [53.13??] MuLTeX: special_out
if cur_length<256 then
  begin dvi_out(xxx1); dvi_out(cur_length);
  end
else  begin dvi_out(xxx4); dvi_four(cur_length);
  end;
for k:=str_start[str_ptr] to pool_ptr-1 do dvi_out(so(str_pool[k]));
pool_ptr:=str_start[str_ptr]; {erase the string}
end;
@y
spec_ch_start;
k:=str_start[str_ptr];
while k < pool_ptr do
  @<Convert |str_pool| char to mlchar, put it in temp area and increment |k|@>;
pool_ptr:=str_start[str_ptr]; {erase the string}
len:=spec_pool_len;
if len<256 then
  begin dvi_out(xxx1); dvi_out(len);
  end
else  begin dvi_out(xxx4); dvi_four(len);
  end;
spec_ch_start;
for k:=1 to len do dvi_out(get_spec_ch);
end;
@z

@x [53.1370] l.24770 - system: (write_out) \write18{foo} => system(foo).
begin @<Expand macros in the token list
@y
@!d:integer; {number of characters in incomplete current string}
@!clobbered:boolean; {system string is ok?}
begin @<Expand macros in the token list
@z

@x [53.1370] l.24773 - system: (write_out) \write18{foo} => system(foo).
if write_open[j] then selector:=j
@y
if shell_enabled_p and (j=18) then
  begin selector := new_string;
  end
else if write_open[j] then selector:=j
@z

% Then call system(3) on that string.
@x [53.1370] l.24779 - system: (write_out) \write18{foo} => system(foo).
flush_list(def_ref); selector:=old_setting;
@y
flush_list(def_ref);
if j=18 then
  begin if (tracing_online<=0) then
    selector:=log_only  {Show what we're doing in the log file.}
  else selector:=term_and_log;  {Show what we're doing.}
  print_nl("system(");
  for d:=0 to cur_length-1 do
    begin {|print| gives up if passed |str_ptr|, so do it by hand.}
    print(so(str_pool[str_start[str_ptr]+d])); {N.B.: not |print_char|}
    end;
  print(")...");
  if shell_enabled_p then
    begin str_room(1); append_char(0); {Append a null byte to the expansion.}
    clobbered:=false;
    for d:=0 to cur_length-1 do {Convert to external character set.}
      begin str_pool[str_start[str_ptr]+d]:=xchr[str_pool[str_start[str_ptr]+d]];
      if (str_pool[str_start[str_ptr]+d]=null_code)
         and (d<cur_length-1) then clobbered:=true;
        {minimal checking: NUL not allowed in argument string of |system|()}
      end;
    if clobbered then print("clobbered")
    else begin {We have the string; run system(3). We don't have anything
            reasonable to do with the return status, unfortunately discard it.}
      system(stringcast(address_of(str_pool[str_start[str_ptr]])));
      print("executed");
      end;
    pool_ptr:=str_start[str_ptr];  {erase the string}
    end
  else begin print("disabled");
  end;
  print_char("."); print_nl(""); print_ln;
end;
selector:=old_setting;
@z

@x [53.1373] Need new local.
procedure out_what(@!p:pointer);
var j:small_number; {write stream number}
@y
procedure out_what(@!p:pointer);
var j:small_number; {write stream number}
    @!old_setting:0..max_selector;
@z

@x [53.1374] Disallow certain \openout filenames, and log results. MuLTeX
      while not a_open_out(write_file[j]) do
        prompt_file_name("output file name",".tex");
      write_open[j]:=true;
@y
      while not open_out_name_ok(stringcast(name_of_file+1))
            or not a_open_out(write_file[j]) do
        prompt_file_name("output file name",".tex");
      write_open[j]:=true;
      @<Set multi-lingual |write_file| type@>;
      {If on first line of input, log file is not ready yet, so don't log.}
      if log_opened then begin
        old_setting:=selector;
        if (tracing_online<=0) then
          selector:=log_only  {Show what we're doing in the log file.}
        else selector:=term_and_log;  {Show what we're doing.}
        print_nl("\openout");
        print_int(j);
        print(" = `");
        print_file_name(cur_name,cur_area,cur_ext);
        print("'."); print_nl(""); print_ln;
        selector:=old_setting;
      end;
@z

% modules for MuLTeX and delayed
@x [54.1376] l.24903 - Add editor-switch variables to globals.
@* \[54] System-dependent changes.
@y
@* \[54/web2c] System-dependent changes for Web2c.
Here are extra variables for Web2c.  (This numbering of the
system-dependent section allows easy integration of Web2c and e-\TeX, etc.)
@^<system dependencies@>

@<Glob...@>=
@!edit_name_start: pool_pointer; {where the filename to switch to starts}
@!edit_name_length,@!edit_line: integer; {what line to start editing at}
@!ipc_on: c_int_type; {level of IPC action, 0 for none [default]}
@!is_printable: array[ASCII_code] of boolean; {use \.{\^\^} notation?}
@!stop_at_space: boolean; {whether |more_name| returns false for space}

@ The |edit_name_start| will be set to point into |str_pool| somewhere after
its beginning if \TeX\ is supposed to switch to an editor on exit.

@<Set init...@>=
edit_name_start:=0;
stop_at_space:=true;

@ These are used when we regenerate the representation of the first 256
strings.

@<Global...@> =
@!save_str_ptr: str_number;
@!save_pool_ptr: pool_pointer;
@!shell_enabled_p: boolean;
@!output_comment: ^char;
@!k,l: 0..255; {used by `Make the first 256 strings', etc.}

@ When debugging a macro package, it can be useful to see the exact
control sequence names in the format file.  For example, if ten new
csnames appear, it's nice to know what they are, to help pinpoint where
they came from.  (This isn't a truly ``basic'' printing procedure, but
that's a convenient module in which to put it.)

@<Basic printing procedures@> =
procedure print_csnames (hstart:integer; hfinish:integer);
var c,h,where:integer;
begin
  write_ln(stderr, 'fmtdebug:csnames from ', hstart, ' to ', hfinish, ':');
  for h := hstart to hfinish do begin
    if text(h) > 0 then begin {if have anything at this position}
      for c := str_start[text(h)] to str_start[text(h) + 1] - 1
      do begin
        put_byte(str_pool[c], stderr); {print the characters}
      end;
      write_ln(stderr, '|');
    end;
  end;
end;

@ Are we printing extra info as we read the format file?

@<Glob...@> =
@!debug_format_file: boolean;


@* \[54/web2c-string] The string recycling routines.  \TeX{} uses 2
upto 4 {\it new\/} strings when scanning a filename in an \.{\\input},
\.{\\openin}, or \.{\\openout} operation.  These strings are normally
lost because the reference to them are not saved after finishing the
operation.  |search_string| searches through the string pool for the
given string and returns either 0 or the found string number.

@<Declare additional routines for string recycling@>=
function search_string(@!search:str_number):str_number;
label found;
var result: str_number;
@!s: str_number; {running index}
@!len: integer; {length of searched string}
begin result:=0; len:=length(search);
if len=0 then  {trivial case}
  begin result:=""; goto found;
  end
else  begin s:=search-1;  {start search with newest string below |s|; |search>1|!}
  while s>255 do  {first 256 strings depend on implementation!!}
    begin if length(s)=len then
      if str_eq_str(s,search) then
        begin result:=s; goto found;
        end;
    decr(s);
    end;
  end;
found:search_string:=result;
end;

@ The following routine is a variant of |make_string|.  It searches
the whole string pool for a string equal to the string currently built
and returns a found string.  Otherwise a new string is created and
returned.  Be cautious, you can not apply |flush_string| to a replaced
string!

@<Declare additional routines for string recycling@>=
function slow_make_string : str_number;
label exit;
var s: str_number; {result of |search_string|}
@!t: str_number; {new string}
begin t:=make_string; s:=search_string(t);
if s>0 then
  begin flush_string; slow_make_string:=s; return;
  end;
slow_make_string:=t;
exit:end;


@* \[54/ML\TeX] System-dependent changes for ML\TeX.

The boolean variable |mltex_p| is set by web2c according to the given
command line option (or an entry in the configuration file) before any
\TeX{} function is called.

@<Global...@> =
@!mltex_p: boolean;

@ The boolean variable |mltex_enabled_p| is used to enable ML\TeX's
character substitution.  It is initialised to |false|.  When loading
a \.{FMT} it is set to the value of the boolean |mltex_p| saved in
the \.{FMT} file.  Additionally it is set to the value of |mltex_p|
in Ini\TeX.

@<Glob...@>=
@!mltex_enabled_p:boolean;  {enable character substitution}


@ @<Set init...@>=
mltex_enabled_p:=false;


@ The function |effective_char| computes the effective character with
respect to font information.  The effective character is either the
base character part of a character substitution definition, if the
character does not exist in the font or the character itself.

Inside |effective_char| we can not use |char_info| because the macro
|char_info| uses |effective_char| calling this function a second time
with the same arguments.

If neither the character |c| exists in font |f| nor a character
substitution for |c| was defined, you can not use the function value
as a character offset in |char_info| because it will access an
undefined or invalid |font_info| entry!  Therefore inside |char_info|
and in other places, |effective_char|'s boolean parameter |err_p| is
set to |true| to issue a warning and return the incorrect
replacement, but always existing character |font_bc[f]|.
@^inner loop@>

@<Declare additional functions for ML\TeX@>=
function effective_char(@!err_p:boolean;
                        @!f:internal_font_number;@!c:quarterword):integer;
label found;
var base_c: integer; {or |eightbits|: replacement base character}
@!result: integer; {or |quarterword|}
begin result:=c;  {return |c| unless it does not exist in the font}
if not mltex_enabled_p then goto found;
if font_ec[f]>=qo(c) then if font_bc[f]<=qo(c) then
  if char_exists(orig_char_info(f)(c)) then  {N.B.: not |char_info|(f)(c)}
    goto found;
if qo(c)>=char_sub_def_min then if qo(c)<=char_sub_def_max then
  if char_list_exists(qo(c)) then
    begin base_c:=char_list_char(qo(c));
    result:=qi(base_c);  {return |base_c|}
    if not err_p then goto found;
    if font_ec[f]>=base_c then if font_bc[f]<=base_c then
      if char_exists(orig_char_info(f)(qi(base_c))) then goto found;
    end;
if err_p then  {print error and return existing character?}
  begin begin_diagnostic;
  print_nl("Missing character: There is no "); print("substitution for ");
@.Missing character@>
  print_ASCII(qo(c)); print(" in font ");
  slow_print(font_name[f]); print_char("!"); end_diagnostic(false);
  result:=qi(font_bc[f]); {N.B.: not non-existing character |c|!}
  end;
found: effective_char:=result;
end;


@ The function |effective_char_info| is equivalent to |char_info|,
except it will return |null_character| if neither the character |c|
exists in font |f| nor is there a substitution definition for |c|.
(For these cases |char_info| using |effective_char| will access an
undefined or invalid |font_info| entry.  See the documentation of
|effective_char| for more information.)
@^inner loop@>

@<Declare additional functions for ML\TeX@>=
function effective_char_info(@!f:internal_font_number;
                             @!c:quarterword):four_quarters;
label exit;
var ci:four_quarters; {character information bytes for |c|}
@!base_c:integer; {or |eightbits|: replacement base character}
begin if not mltex_enabled_p then
  begin effective_char_info:=orig_char_info(f)(c); return;
  end;
if font_ec[f]>=qo(c) then if font_bc[f]<=qo(c) then
  begin ci:=orig_char_info(f)(c);  {N.B.: not |char_info|(f)(c)}
  if char_exists(ci) then
    begin effective_char_info:=ci; return;
    end;
  end;
if qo(c)>=char_sub_def_min then if qo(c)<=char_sub_def_max then
  if char_list_exists(qo(c)) then
    begin {|effective_char_info:=char_info(f)(qi(char_list_char(qo(c))));|}
    base_c:=char_list_char(qo(c));
    if font_ec[f]>=base_c then if font_bc[f]<=base_c then
      begin ci:=orig_char_info(f)(qi(base_c));  {N.B.: not |char_info|(f)(c)}
      if char_exists(ci) then
        begin effective_char_info:=ci; return;
        end;
      end;
    end;
effective_char_info:=null_character;
exit:end;


@ This code is called for a virtual character |c| in |hlist_out|
during |ship_out|.  It tries to built a character substitution
construct for |c| generating appropriate \.{DVI} code using the
character substitution definition for this character.  If a valid
character substitution exists \.{DVI} code is created as if
|make_accent| was used.  In all other cases the status of the
substituion for this character has been changed between the creation
of the character node in the hlist and the output of the page---the
created \.{DVI} code will be correct but the visual result will be
undefined.

Former ML\TeX\ versions have replaced the character node by a
sequence of character, box, and accent kern nodes splicing them into
the original horizontal list.  This version does not do this to avoid
a)~a memory overflow at this processing stage, b)~additional code to
add a pointer to the previous node needed for the replacement, and
c)~to avoid wrong code resulting in anomalies because of the use
within a \.{\\leaders} box.

@<Output a substitution, |goto continue| if not possible@>=
  begin
  @<Get substitution information, check it, goto |found|
  if all is ok, otherwise goto |continue|@>;
found: @<Print character substition tracing log@>;
  @<Rebuild character using substitution information@>;
  end


@ The global variables for the code to substitute a virtual character
can be declared as local.  Nonetheless we declare them as global to
avoid stack overflows because |hlist_out| can be called recursivly.

@<Glob...@>=
@!accent_c,@!base_c,@!replace_c:integer;
@!ia_c,@!ib_c:four_quarters; {accent and base character information}
@!base_slant,@!accent_slant:real; {amount of slant}
@!base_x_height:scaled; {accent is designed for characters of this height}
@!base_width,@!base_height:scaled; {height and width for base character}
@!accent_width,@!accent_height:scaled; {height and width for accent}
@!delta:scaled; {amount of right shift}


@ Get the character substitution information in |char_sub_code| for
the character |c|.  The current code checks that the substition
exists and is valid and all substitution characters exist in the
font, so we can {\it not\/} substitute a character used in a
substitution.  This simplifies the code because we have not to check
for cycles in all character substitution definitions.

@<Get substitution information, check it...@>=
  if qo(c)>=char_sub_def_min then if qo(c)<=char_sub_def_max then
    if char_list_exists(qo(c)) then
      begin  base_c:=char_list_char(qo(c));
      accent_c:=char_list_accent(qo(c));
      if (font_ec[f]>=base_c) then if (font_bc[f]<=base_c) then
        if (font_ec[f]>=accent_c) then if (font_bc[f]<=accent_c) then
          begin ia_c:=char_info(f)(qi(accent_c));
          ib_c:=char_info(f)(qi(base_c));
          if char_exists(ib_c) then
            if char_exists(ia_c) then goto found;
          end;
      begin_diagnostic;
      print_nl("Missing character: Incomplete substitution ");
@.Missing character@>
      print_ASCII(qo(c)); print(" = "); print_ASCII(accent_c);
      print(" "); print_ASCII(base_c); print(" in font ");
      slow_print(font_name[f]); print_char("!"); end_diagnostic(false);
      goto continue;
      end;
  begin_diagnostic;
  print_nl("Missing character: There is no "); print("substitution for ");
@.Missing character@>
  print_ASCII(qo(c)); print(" in font ");
  slow_print(font_name[f]); print_char("!"); end_diagnostic(false);
  goto continue


@ For |tracinglostchars>99| the substitution is shown in the log file.

@<Print character substition tracing log@>=
 if tracing_lost_chars>99 then
   begin begin_diagnostic;
   print_nl("Using character substitution: ");
   print_ASCII(qo(c)); print(" = ");
   print_ASCII(accent_c); print(" "); print_ASCII(base_c);
   print(" in font "); slow_print(font_name[f]); print_char(".");
   end_diagnostic(false);
   end


@ This outputs the accent and the base character given in the
substitution.  It uses code virtually identical to the |make_accent|
procedure, but without the node creation steps.
 
Additionally if the accent character has to be shifted vertically it
does {\it not\/} create the same code.  The original routine in
|make_accent| and former versions of ML\TeX{} creates a box node
resulting in |push| and |pop| operations, whereas this code simply
produces vertical positioning operations.  This can influence the
pixel rounding algorithm in some \.{DVI} drivers---and therefore will
probably be changed in one of the next ML\TeX{} versions.

@<Rebuild character using substitution information@>=
  base_x_height:=x_height(f);
  base_slant:=slant(f)/float_constant(65536);
@^real division@>
  accent_slant:=base_slant; {slant of accent character font}
  base_width:=char_width(f)(ib_c);
  base_height:=char_height(f)(height_depth(ib_c));
  accent_width:=char_width(f)(ia_c);
  accent_height:=char_height(f)(height_depth(ia_c));
  @/{compute necessary horizontal shift (don't forget slant)}@/
  delta:=round((base_width-accent_width)/float_constant(2)+
            base_height*base_slant-base_x_height*accent_slant);
@^real multiplication@>
@^real addition@>
  dvi_h:=cur_h;  {update |dvi_h|, similar to the last statement in module 620}
  @/{1. For centering/horizontal shifting insert a kern node.}@/
  cur_h:=cur_h+delta; synch_h;
  @/{2. Then insert the accent character possibly shifted up or down.}@/
  if ((base_height<>base_x_height) and (accent_height>0)) then
    begin {the accent must be shifted up or down}
    cur_v:=base_line+(base_x_height-base_height); synch_v;
    if accent_c>=128 then dvi_out(set1);
    dvi_out(accent_c);@/
    cur_v:=base_line;
    end
  else begin synch_v;
    if accent_c>=128 then dvi_out(set1);
    dvi_out(accent_c);@/
    end;
  cur_h:=cur_h+accent_width; dvi_h:=cur_h;
  @/{3. For centering/horizontal shifting insert another kern node.}@/
  cur_h:=cur_h+(-accent_width-delta);
  @/{4. Output the base character.}@/
  synch_h; synch_v;
  if base_c>=128 then dvi_out(set1);
  dvi_out(base_c);@/
  cur_h:=cur_h+base_width;
  dvi_h:=cur_h {update of |dvi_h| is unnecessary, will be set in module 620}


@* \[54/delayed] System-dependent changes for delayed font.

Various modules necessary for `delayed font'. The font defined as a delayed
font is not loaded when defined, but it is loaded when the font is first used.
In other words, it is an on-demmand-loaded font.

We define a new box to express the status of the delayed font. We call such
a box a df-box. It is similar to |glue_spec| but it can be an |equiv| value
of the command.
@d df_spec_size=4
@d df_ref_count(#) == link(#)
@d df_null=0
@d df_font=1
@d df_loaded=2
@d df_share=3
@d df_sharedelayed=4
@d df_fname(#) == mem[#+1].hh.rh
@d df_farea(#) == mem[#+1].hh.lh
@d df_fidtext(#) == mem[#+2].hh.rh
@d df_scaled(#) == mem[#+3].sc
@d df_fnum(#) == mem[#+3].int
@d df_dfref(#) == link(#+3)

@ @<Define additional ref-type box@>=
function new_df_spec(@!dt:small_number;@!fn,@!fa,@!t:str_number):pointer;
var q:pointer; {the new spec}
begin q:=get_node(df_spec_size);@/
type(q):=dt; df_ref_count(q):=null;
df_fname(q):=fn; df_farea(q):=fa; df_fidtext(q):=t;
new_df_spec:=q;
end;

@ @<Destroy additional ref-type box@>=
procedure delete_df_ref(@!p:pointer); {|p| points to a dfont specification}
begin if df_ref_count(p)=null then begin
  if type(p)=df_sharedelayed then delete_df_ref(df_dfref(p));
  free_node(p,df_spec_size);
  end
else decr(df_ref_count(p));
end;

@ @<Cases of |eq_destroy| for additional ref-type box in |equiv_field|@>=
demmand_font: delete_df_ref(equiv_field(w));

@ @<Put each...@>=
primitive("delayedfont",def_dfont,0);@/
@!@:delayedfont_}{\.{\\delayedfont} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
def_dfont: print_esc("delayedfont");

@ @<New prefixed commands@>=
any_mode(def_dfont),

@ The df-box is generated here. It contains the information for loading
the font when it is used.

@<Assignments@>=
def_dfont: new_dfont(a);

@ @<Declare subprocedures needed for delayed font@>=
procedure new_dfont(@!a:small_number);
label done,common_ending;
var u:pointer; {user's font identifier}
@!s:scaled; {stated ``at'' size, or negative of scaled magnification}
@!f:internal_font_number; {runs through existing fonts}
@!t:str_number; {name for the frozen font identifier}
@!old_setting:0..max_selector; {holds |selector| setting}
@!flushable_string:str_number; {string not yet referenced}
@!dftype:small_number;
@!p,@!q:pointer;
@!save_jendline_type:integer;
begin if job_name=0 then open_log_file;
  {avoid confusing \.{texput} with the font name}
@.texput@>
get_r_token; u:=cur_cs;
if u>=hash_base then t:=text(u)
else if u>=single_base then
  if u=null_cs then t:="FONT"@+else t:=u-single_base
else  begin old_setting:=selector; selector:=new_string;
  print("FONT"); print(u-active_base); selector:=old_setting;
@.FONTx@>
  str_room(1); t:=make_string;
  end;
scan_optional_equals; scan_file_name;
dftype:=df_font;
@<Scan the font size spec or the font to share and set |dftype|@>;
if dftype=df_font then begin
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  p:=new_df_spec(df_font,cur_name,cur_area,t); df_scaled(p):=s;
  define(u,demmand_font,p);
  goto done;
 common_ending: define(u,set_font,f);
  eqtb[font_id_base+f]:=eqtb[u]; font_id_text(f):=t;
 done:
  end
else if dftype=df_share then begin
  p:=new_df_spec(df_share,cur_name,cur_area,t); df_fnum(p):=cur_chr;
  define(u,demmand_font,p);
  end
else if dftype=df_sharedelayed then begin
  p:=new_df_spec(df_sharedelayed,cur_name,cur_area,t);
  if type(cur_chr)=df_sharedelayed then q:=df_dfref(cur_chr)
  else q:=cur_chr;
  add_df_ref(q); df_dfref(p):=q;
  define(u,demmand_font,p);
  end
else
  define(u,set_font,null_font);
end;

@ @<Scan the font size spec or the font to share and set |dftype|@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
save_jendline_type:=jendline_type; jendline_type:=jend_ascii;
if scan_keyword("at") then @<Put the \(p)(positive) `at' size into |s|@>
@.at@>
else if scan_keyword("scaled") then
@.scaled@>
  begin scan_int; s:=-cur_val;
  if (cur_val<=0)or(cur_val>32768) then
    begin print_err("Illegal magnification has been changed to 1000");@/
@.Illegal magnification...@>
    help1("The magnification ratio must be between 1 and 32768.");
    int_error(cur_val); s:=-1000;
    end;
  end
else if scan_keyword("share") then @<Get the font to share@>
@.share@>
else s:=-1000;
name_in_progress:=false; jendline_type:=save_jendline_type

@ @<Get the font to share@>=
begin @<Get the next non-blank non-call token@>;
if cur_cmd=set_font then dftype:=df_share
else if cur_cmd=demmand_font then dftype:=df_sharedelayed
else begin print_err("Improper `share' font");@/
  help1("Delayed font can share tfm with font or delayed font");
  error; dftype:=df_null;
  end
end

@ @<Cases of |print_cmd_chr|...@>=
demmand_font: begin print("delayed font ");
  case type(chr_code) of
  df_font: print("not loaded");
  df_loaded: print("loaded");
  df_share: print("share");
  df_sharedelayed: print("sharedelayed");
  othercases print("ERROR");
  endcases;
  end;

@ @<New prefixed commands@>=
any_mode(demmand_font),

@ Execution of the df-box (|cur_chr|) changes the state of the box and
yields the font number. It is assigned to |cur_cs|.

@<Assignments@>=
demmand_font: load_set_dfont(a,cur_cs,cur_chr);

@ @<Declare subprocedures needed for delayed font@>=
function load_dfont(@!u,@!p:pointer):internal_font_number;
{|u| is used just to get command name in error reporting.}
label done,done1,common_ending;
var s:scaled;
@!tfm_f,@!f:internal_font_number;
@!nom,@!aire:str_number;
@!flushable_string:str_number; {string not yet referenced}
@!q:pointer;
begin
case type(p) of
df_font: begin cur_name:=df_fname(p); cur_area:=df_farea(p); s:=df_scaled(p);
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  f:=read_font_info(u,cur_name,cur_area,s);
  end;
df_loaded: begin f:=df_fnum(p); goto done1; end;
df_share: begin tfm_f:=df_fnum(p);
  cur_name:=df_fname(p); cur_area:=df_farea(p); s:=font_size[tfm_f];
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  nom:=cur_name; aire:=cur_area;
  @<Copy TFM infomation from |tfm_f| to new font |f|@>;
  end;
df_sharedelayed: begin q:=df_dfref(p);
  if type(q)=df_font then begin type(p):=df_font;
    nom:=df_fname(p); aire:=df_farea(p);
    df_fname(p):=df_fname(q); df_farea(p):=df_farea(q);
    df_scaled(p):=df_scaled(q);
    f:=load_dfont(u,p);
    df_fname(p):=nom; df_farea(p):=aire;
    font_name[f]:=nom; font_area[f]:=aire;
    type(q):=df_share; df_fnum(q):=f;
    end
  else begin type(p):=df_share; df_fnum(p):=df_fnum(q);
    f:=load_dfont(u,p);
    end;
  delete_df_ref(q); goto done;
  end;
endcases;
common_ending: type(p):=df_loaded; df_fnum(p):=f;
done1: eq_type(font_id_base+f):=set_font; equiv(font_id_base+f):=f;
font_id_text(f):=df_fidtext(p);
done: load_dfont:=f;
end;

@ @<Copy TFM infomation from |tfm_f| to new font |f|@>=
if (font_ptr=font_max) then begin f:=null_font;
  @<Apologize for not loading the font, |goto done|@>;
  end;
font_ptr:=font_ptr+1; f:=font_ptr; {new font pointer}
char_base[f]:=char_base[tfm_f];
ctype_base[f]:=ctype_base[tfm_f]; {MuLTeX}
width_base[f]:=width_base[tfm_f];
height_base[f]:=height_base[tfm_f];
depth_base[f]:=depth_base[tfm_f];
italic_base[f]:=italic_base[tfm_f];
lig_kern_base[f]:=lig_kern_base[tfm_f];
kern_base[f]:=kern_base[tfm_f];
exten_base[f]:=exten_base[tfm_f];
param_base[f]:=param_base[tfm_f];
font_check[f]:=font_check[tfm_f];
font_mcset[f]:=font_mcset[tfm_f]; {MuLTeX}
font_fmtype[f]:=font_fmtype[tfm_f]; {MuLTeX}
font_lcd[f]:=font_lcd[tfm_f]; {MuLTeX}
font_size[f]:=font_size[tfm_f];
font_dsize[f]:=font_dsize[tfm_f];
font_params[f]:=font_params[tfm_f];
font_name[f]:=nom; {This and area should be distinct from TFM file}
font_area[f]:=aire;
font_bc[f]:=font_bc[tfm_f];
font_ec[f]:=font_ec[tfm_f];
font_glue[f]:=font_glue[tfm_f];
bchar_label[f]:=bchar_label[tfm_f];
font_bchar[f]:=font_bchar[tfm_f];
font_false_bchar[f]:=font_false_bchar[tfm_f];
hyphen_char[f]:=hyphen_char[tfm_f];
skew_char[f]:=skew_char[tfm_f];

@ @<Declare subprocedures needed for delayed font@>=
procedure load_set_dfont(@!a,@!u,@!p:pointer);
var f:internal_font_number;
begin
  f:=load_dfont(u,p);
  deq_define(u,set_font,f);
  define(cur_font_loc,data,f);
end;

@ @<Declare subprocedures needed for delayed font@>=
procedure load_dfont_proc;
begin
  cur_chr:=load_dfont(cur_cs,cur_chr);
end;


@* \[54/\MuLTeX] System-dependent changes for \MuLTeX.

Various modules necessary for MuLTeX.
From here to the end of the file, MuLTeX related modules are gathered.

Multi-lingual character set.

@<Types ...@>=
mc_range=mc_min..mc_max;

@
@d ml_font_blen(#)==ml_font_blen_tab[#]
@d ml_font_dlen(#)==ml_font_dlen_tab[#]
@d ml_font_agl(#)==ml_font_agl_tab[#]

@ @<Glob...@>=
@!ml_font_blen_tab: array[mc_range] of small_number;
@!ml_font_dlen_tab: array[mc_range] of small_number;
@!ml_font_agl_tab: array[mc_range] of boolean;

@ @<Initialize table entries...@>=
for k:=mc_min to mc_max do ml_font_blen(k):=1;
for k:=mc_min to mc_max do ml_font_dlen(k):=1;
for k:=mc_min to mc_max do ml_font_agl(k):=false;

@ @d ml_font_mc(#)==font_mcset[#]

{TODO:improve}
@ @<Utility ...@>=
function get_jfm_ctype(f:internal_font_number;c:halfword): eight_bits;
label exit;
var left,right,m:integer;
code:halfword;
begin {TODO:remove: if font_fmtype[f]=fmtype_tfm then begin
  get_jfm_ctype:=mlrep1_char(c); return;
  end;}
if c>font_lcd[f] then begin
  get_jfm_ctype:=0; return;
  end;
left:=ctype_base[f]; right:=width_base[f]-1;
while left<=right do begin
  m := (left+right) div 2;
  code:=jfm_ct_code(m);
  if c<code then right:=m-1
  else if c>code then left:=m+1
  else begin get_jfm_ctype:=jfm_ct_type(m); return; end;
  end;
get_jfm_ctype:=0;
exit:end;

@ @<Utility ...@>=
function ch_i_index(f:internal_font_number;c:halfword):integer;
begin if font_fmtype[f]=fmtype_jfm then
  ch_i_index:=char_base[f]+get_jfm_ctype(f,c)
else
  ch_i_index:=char_base[f]+c;
end;

@ @<Fetch a font mcs@>=
begin scan_font_ident;
scanned_result(font_mcset[cur_val])(int_val);
end

@ New primitive \.{\\fontmcs}.

@<Put each...@>=
primitive("fontmcs",assign_font_mcs,0);@/
@!@:fontmcs_}{\.{\\fontmcs} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
assign_font_mcs: print_esc("fontmcs");

@ @<New prefixed commands@>=
any_mode(assign_font_mcs),

@ Associate multi-ligual code to font.

@<Assignments@>=
assign_font_mcs: begin scan_font_ident; f:=cur_val; scan_int; n:=cur_val;
  if (mc_min<=n) and (n<=mc_max) then font_mcset[f]:=n;
  end;

@ New primitive \.{\\mcsattr}.

@<Put each...@>=
primitive("mcsattr",set_mcs_attr,0);@/
@!@:mcassign_}{\.{\\mcassign} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_mcs_attr: print_esc("mcsattr");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_mcs_attr): set_mcs_table;

@ Set attributes of multi-ligual charset.

@<Declare act...@>=
procedure set_mcs_table;
var m,@!n:integer;
begin scan_int; m:=cur_val; scan_int; n:=cur_val;
ml_font_blen(m):=n mod 16;
ml_font_dlen(m):=(n div 16) mod 16;
ml_font_agl(m):=(n div 256)=1;
end;

@ Set multi-lingual code for file and terminal.

@<Put each...@>=
primitive("defmlinputcodetype",def_ml_input_codetype,0);@/
@!@:defmlinputcodetype_}{\.{\\defmlinputcodetype} primitive@>
primitive("setmlinputcodetype",set_ml_input_codetype,0);@/
@!@:setmlinputcodetype_}{\.{\\setmlinputcodetype} primitive@>
primitive("setmlreadcodetype",set_ml_read_codetype,0);@/
@!@:setmlreadcodetype_}{\.{\\setmlreadcodetype} primitive@>
primitive("setmlallreadcodetype",set_ml_allread_codetype,0);@/
@!@:setmlallreadcodetype_}{\.{\\setmlallreadcodetype} primitive@>
primitive("defmltermcodetype",def_ml_term_codetype,0);@/
@!@:defmltermcodetype_}{\.{\\defmltermcodetype} primitive@>
primitive("defmllogcodetype",def_ml_log_codetype,0);@/
@!@:defmllogcodetype_}{\.{\\defmllogcodetype} primitive@>
primitive("setmlwritecodetype",set_ml_write_codetype,0);@/
@!@:setmlwritecodetype_}{\.{\\setmlwritecodetype} primitive@>
primitive("setmlallwritecodetype",set_ml_allwrite_codetype,0);@/
@!@:setmlallwritecodetype_}{\.{\\setmlallwritecodetype} primitive@>
primitive("defmlspeccodetype",def_ml_spec_codetype,0);@/
@!@:defmlspeccodetype_}{\.{\\defmlspeccodetype} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
def_ml_input_codetype: print_esc("defmlinputcodetype");
set_ml_input_codetype: print_esc("setmlinputcodetype");
set_ml_read_codetype: print_esc("setmlreadcodetype");
set_ml_allread_codetype: print_esc("setmlallreadcodetype");
def_ml_term_codetype: print_esc("defmltermcodetype");
def_ml_log_codetype: print_esc("defmllogcodetype");
set_ml_write_codetype: print_esc("setmlwritecodetype");
set_ml_allwrite_codetype: print_esc("setmlallwritecodetype");
def_ml_spec_codetype: print_esc("defmlspeccodetype");

@ |set_allml_codetype| called from the external C function |initallmlcodetype|.

@<Utility ...@>=
procedure set_allml_codetype(ict, oct: integer);
begin
ml_input_codetype:=ict;
base_ml_input_codetype:=ml_input_codetype;
ml_term_codetype:=oct; ml_log_codetype:=oct; ml_write_codetype:=oct;
ml_spec_codetype:=oct;
end;

@ @<Initialize table entries...@>=
initallmlcodetype;

@ @<Cases of |main_control| that don't...@>=
any_mode(def_ml_input_codetype): def_ml_input;
any_mode(set_ml_input_codetype): set_ml_input;
any_mode(set_ml_read_codetype): set_ml_read;
any_mode(set_ml_allread_codetype): set_ml_allread;
any_mode(def_ml_term_codetype): def_ml_term;
any_mode(def_ml_log_codetype): def_ml_log;
any_mode(set_ml_write_codetype): set_ml_write;
any_mode(set_ml_allwrite_codetype): set_ml_allwrite;
any_mode(def_ml_spec_codetype): def_ml_spec;

@ @<Declare act...@>=
procedure def_ml_input;
var k:integer;
begin setinmlcodetype(input_file[in_open], ml_input_codetype);
for k:=in_open downto 1 do ml_input_codetype_stack[k].int:=ml_input_codetype;
end;
@#
procedure set_ml_input;
begin setinmlcodetype(input_file[in_open], ml_input_codetype);
end;
@#
procedure set_ml_read;
var k:integer;
begin scan_four_bit_int; k:=cur_val;
if read_open[k]<>closed then
  setinmlcodetype(read_file[k], ml_input_codetype);
end;
@#
procedure set_ml_allread;
var k:integer;
begin
for k:=0 to 15 do if read_open[k]<>closed then
  setinmlcodetype(read_file[k], ml_input_codetype);
end;
@#
procedure def_ml_term;
begin setoutmlcodetype(term_out, ml_term_codetype);
end;
@#
procedure def_ml_log;
begin setoutmlcodetype(log_file, ml_log_codetype);
end;
@#
procedure set_ml_write;
var k:integer;
begin scan_four_bit_int; k:=cur_val;
if write_open[k] then
  setoutmlcodetype(write_file[k], ml_write_codetype);
end;
@#
procedure set_ml_allwrite;
var k:integer;
begin
for k:=0 to 15 do if write_open[k] then
  setoutmlcodetype(write_file[k], ml_write_codetype);
end;
@#
procedure def_ml_spec;
begin setspecmlcodetype(ml_spec_codetype);
end;

@ The following function is called from the external C function.

@<Utility ...@>=
function get_ml_input_codetype: integer;
begin get_ml_input_codetype := ml_input_codetype;
end;

@ @<Set default multi-lingual terminal type@>=
defaultiomlcodetype(term_in, term_out)

@ @<Set multi-lingual terminal type and dvi-special type@>=
begin
setoutmlcodetype(term_out, ml_term_codetype);
setinmlcodetype(term_in, ml_input_codetype);
setspecmlcodetype(ml_spec_codetype);
end

@ @<Reset |mlinputcodetype| from argument and set |basemlinputcodetype|@>=
begin
if hasargcode then ml_input_codetype:=getargcode;
base_ml_input_codetype:=ml_input_codetype;
if hasargterm then ml_term_codetype:=getargterm;
if hasarglog then ml_log_codetype:=getarglog;
if hasargspec then ml_spec_codetype:=getargspec;
end

@ @<Set multi-lingual |cur_file| type@>=
begin
setinmlcodetype(cur_file, ml_input_codetype);
end

@ @<Set multi-lingual |read_file| type@>=
begin
setinmlcodetype(read_file[n], ml_input_codetype);
end

@ @<Set multi-lingual log type@>=
begin
setoutmlcodetype(log_file, ml_log_codetype);
end

@ @<Set multi-lingual |write_file| type@>=
begin
setoutmlcodetype(write_file[j], ml_write_codetype);
end

@ Escape sequence.
@<Put each...@>=
primitive("defmlinputmcs",def_ml_input_mcs,0);@/
@!@:defmlinputmcs_}{\.{\\defmlinputmcs} primitive@>
primitive("defmloutputfin",def_ml_output_fin,0);@/
@!@:defmloutputfin_}{\.{\\defmloutputfin} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
def_ml_input_mcs: print_esc("defmlinputmcs");
def_ml_output_fin: print_esc("defmloutputfin");

@ @<Cases of |main_control| that don't...@>=
any_mode(def_ml_input_mcs): def_ml_input_mcset;
any_mode(def_ml_output_fin): def_ml_output_final;

@ @<Declare act...@>=
procedure def_ml_input_mcset;
var t,@!fin,@!mcs:integer;
begin scan_int; t:=cur_val; scan_int; fin:=cur_val; scan_int; mcs:=cur_val;
if (t<1) or (4<t) then begin
  print_err("Improper charset type");@/
  help0; error; return;
  end;
if (mcs<mc_min) or (mc_max<mcs) then begin
  print_err("Improper mcset");@/
  help0; error; return;
  end;
if (fin<"@@") or ("M"<fin) then begin
  print_err("Improper final char");@/
  help0; error; return;
  end;
setinmlmcs(t,fin,mcs);
exit:end;
@#
procedure def_ml_output_final;
label exit;
var mcs,@!fin:integer;
begin scan_int; mcs:=cur_val; scan_int; fin:=cur_val;
if (mcs<mc_min) or (mc_max<mcs) then begin
  print_err("Improper mcset");@/
  help0; error; return;
  end;
if (fin<"@@") or ("M"<fin) then begin
  print_err("Improper final char");@/
  help0; error; return;
  end;
setoutmlfin(mcs,fin);
exit:end;


@ Printing Japanese.

@ @<Declare procedures used by |print_char|@>=
procedure print_char_term(@!s:ML_code);
label exit;
var len:integer;
begin len:=ml_font_dlen(mlrep_mc(s));
if term_offset+len>max_print_line then begin
  wterm_cr; term_offset:=0;
  end;
{TODO:xchr}
wterm(xchr[s]); term_offset:=term_offset+len;
if term_offset>=max_print_line then begin
  wterm_cr; term_offset:=0;
  end;
end;
@#
procedure print_char_log(@!s:ML_code);
label exit;
var len:integer;
begin len:=ml_font_dlen(mlrep_mc(s));
if file_offset+len>max_print_line then begin
  wlog_cr; file_offset:=0;
  end;
{TODO:xchr}
wlog(xchr[s]); file_offset:=file_offset+len;
if file_offset>=max_print_line then begin
  wlog_cr; file_offset:=0;
  end;
end;


@ Multi-lingual char in |str_pool|.

@d mc_to_lc(#)==((#)+@"80)
@d lc_to_mc(#)==((#)-@"80)
@d MBCHARBIT == @"80
@d is_mbc(#) == ((#)>=MBCHARBIT) {multi-byte char}
@d is_lc(#) == ((#)<=@"9E) {leading char}
@d is_lc_asceight(#) == ((#)=MBCHARBIT) {lc ascii eightbit}
@d lc_asceight == MBCHARBIT
@d is_eightbit(#) == ((#)>=128)
@d make_eightbit(#) == (#)
@d de_eightbit(#) == (#)
@d is_lc_nonasc(#) == ((#)>MBCHARBIT) {lc non-ascii}
@d mbc_in(#) == ((#)+MBCHARBIT)
@d mbc_out(#) == ((#)-MBCHARBIT)

@ @<Convert |buffer| string to |str_pool| string@>=
begin n:=0;
for k:=j to j+l-1 do begin
  if is_mlrep(buffer[k]) then begin
    if ml_font_blen(mlrep_mc(buffer[k]))=1 then begin
      str_buffer[n]:=mc_to_lc(mlrep_mc(buffer[k]));
      str_buffer[n+1]:=mbc_in(mlrep1_char(buffer[k]));
      n:=n+2;
      end
    else begin
      str_buffer[n]:=mc_to_lc(mlrep_mc(buffer[k]));
      str_buffer[n+1]:=mbc_in(mlrep_char_fst(buffer[k]));
      str_buffer[n+2]:=mbc_in(mlrep_char_snd(buffer[k]));
      n:=n+3;
      end;
    end
  else begin
    if is_eightbit(buffer[k]) then begin
      str_buffer[n]:=lc_asceight;
      str_buffer[n+1]:=de_eightbit(buffer[k]);
      n:=n+2;
      end
    else begin
      str_buffer[n]:=buffer[k];
      incr(n);
      end;
    end;
  end;
l:=n;
end

@ @<Store char in |str_pool|@>=
begin {we drop characters if the string space is full}
if is_mlrep_ascii(s) then begin
  if is_eightbit(s) then begin
    if pool_ptr+2<=pool_size then begin
      append_char(lc_asceight);
      append_char(de_eightbit(s));
      end;
    end
  else if pool_ptr<pool_size then append_char(s);
  end
else if ml_font_blen(mlrep_mc(s))=1 then begin
  if pool_ptr+2<=pool_size then begin
      append_char(mc_to_lc(mlrep_mc(s)));
      append_char(mbc_in(mlrep1_char(s)));
    end
  end
else if pool_ptr+3<=pool_size then begin
  append_char(mc_to_lc(mlrep_mc(s)));
  append_char(mbc_in(mlrep_char_fst(s)));
  append_char(mbc_in(mlrep_char_snd(s)));
  end;
end

@ @<Print chars in |str_pool| by |print_char|@>=
while j<str_start[s+1] do
  if is_lc_nonasc(so(str_pool[j])) then begin
    if ml_font_blen(lc_to_mc(so(str_pool[j])))=1 then begin
      print_char(make_mlrep1(lc_to_mc(so(str_pool[j])))(so(str_pool[j+1])));
      j:=j+2;
      end
    else begin
      print_char(make_mlrep(lc_to_mc(so(str_pool[j])))
                           (so(str_pool[j+1]))(so(str_pool[j+2])));
      j:=j+3;
      end;
    end
  else if is_lc_asceight(so(str_pool[j])) then begin
    print_char(make_eightbit(so(str_pool[j+1])));
    j:=j+2;
    end
  else begin
    print_char(so(str_pool[j])); incr(j);
    end

@ @<Print chars in |str_pool| by |print|@>=
while j<str_start[s+1] do
  if is_lc_nonasc(so(str_pool[j])) then begin
    if ml_font_blen(lc_to_mc(so(str_pool[j])))=1 then begin
      print_char(make_mlrep1(lc_to_mc(so(str_pool[j])))(so(str_pool[j+1])));
      j:=j+2;
      end
    else begin
      print_char(make_mlrep(lc_to_mc(so(str_pool[j])))
                           (so(str_pool[j+1]))(so(str_pool[j+2])));
      j:=j+3;
      end;
    end
  else if is_lc_asceight(so(str_pool[j])) then begin
    print(make_eightbit(so(str_pool[j+1])));
    j:=j+2;
    end
  else begin
    print(so(str_pool[j])); incr(j);
    end

@ @<Convert |str_pool| char to mlchar, ...@>=
if is_lc_nonasc(so(str_pool[k])) then begin
  if ml_font_blen(lc_to_mc(so(str_pool[k])))=1 then begin
    spec_ch(make_mlrep1(lc_to_mc(so(str_pool[k])))(so(str_pool[k+1])));
    k:=k+2;
    end
  else begin
    spec_ch(make_mlrep(lc_to_mc(so(str_pool[k])))
                      (so(str_pool[k+1]))(so(str_pool[k+2])));
    k:=k+3;
    end;
  end
else if is_lc_asceight(so(str_pool[k])) then begin
  spec_ch(make_eightbit(so(str_pool[k+1])));
  k:=k+2;
  end
else begin
  spec_ch(so(str_pool[k])); incr(k);
  end

@ \.{\\string} and a japanese char (make ml-letter token [464]).

@<get token of a char from |str_pool|@>=
if is_mbc(t) then begin incr(k);
  if is_lc_nonasc(t) then begin
    if ml_font_blen(lc_to_mc(t))=2 then begin
      t:=make_mltok(jletter)
                   (make_mlrep(lc_to_mc(t))
                              (so(str_pool[k]))(so(str_pool[k+1])));
      incr(k);
      end
    else
      t:=make_mltok(jletter)(make_mlrep1(lc_to_mc(t))(so(str_pool[k])));
    end
  else
    t:=other_token+make_eightbit(so(str_pool[k]));
  end
else if t=" " then t:=space_token
else t:=other_token+t


@ Pseudo printing.

@ @<Store char in |trick_buf|@>=
begin
trick_buf[tally mod error_line] := s;
tally_disp:=tally_disp+ml_font_dlen(mlrep_mc(s));
end

@ @<Print the first line of tricky pseudoprint@>=
begin
p:=first_count;
while r>0 do begin
  decr(p);
  r := r-ml_font_dlen(mlrep_mc(trick_buf[p mod error_line]));
  end;
{let r be the length of the first line}
if r<0 then begin incr(p); r:=n+r; end
else r:=n;
for q:=p to first_count-1 do print_char(trick_buf[q mod error_line]);
end

@ @<Print the second line of tricky pseudoprint@>=
begin
q:=first_count;
while r>0 do begin
  print_char(trick_buf[q mod error_line]);
  r := r-ml_font_dlen(mlrep_mc(trick_buf[q mod error_line]));
  incr(q);
  end;
end


@ catcode of a multi-lingual char.

@<Glob...@>=
@!ml_catcode_tab: array [0..max_ml_catcode_idx] of ML_code;

@ @<Initialize table entries...@>=
for k:=-1 to max_ml_catcode_idx do ml_cat_code(k):=jletter;
for k:=0 to max_ml_catcode_idx do ml_catcode_tab[k]:=non_mlchar;

@ @<Utility ...@>=
function set_ml_catcode_idx(c:ML_code): integer;
label exit;
var i0,i:integer;
begin
i0:=c mod (max_ml_catcode_idx+1); {TODO:better hash}
i:=i0;
while (ml_catcode_tab[i]<>non_mlchar) and (ml_catcode_tab[i]<>c) do begin
  incr(i); if i>max_ml_catcode_idx then i:=0;
  if i=i0 then begin
    print_err("ml catcode table full");
    help0; error; set_ml_catcode_idx:=max_ml_kinsoku_idx+1;
    return;
    end;
  end;
ml_catcode_tab[i]:=c;
set_ml_catcode_idx:=i;
exit:end;
@#
function get_ml_catcode_idx(c:ML_code): integer;
label exit;
var i0,i:integer;
begin
i0:=c mod (max_ml_catcode_idx+1); {TODO:better hash}
i:=i0;
while (ml_catcode_tab[i]<>non_mlchar) and (ml_catcode_tab[i]<>c) do begin
  incr(i); if i>max_ml_catcode_idx then i:=0;
  if i=i0 then begin get_ml_catcode_idx:=-1;
    return;
    end;
  end;
if ml_catcode_tab[i]=non_mlchar then get_ml_catcode_idx:=-1
else get_ml_catcode_idx:=i;
exit:end;
@#
function get_ml_catcode_code(n:integer): ML_code;
var i:integer;
begin
get_ml_catcode_code:=ml_catcode_tab[n];
end;

@ Reading multi-lingual char.

@ @<Determin the effective end of the line@>=
begin
if is_mlrep(buffer[limit]) then j:=limit+1
else if buffer[limit]=end_line_char then j:=limit
else j:=limit+1
end

@ @<Put the end-of-line-char if it is active@>= {same as original}
begin
if end_line_char_inactive then decr(limit)
else buffer[limit]:=end_line_char
end

@ @<Remove the end-of-line-char@>=
begin
if is_mlrep(buffer[l]) then do_nothing
else if buffer[l]=end_line_char then decr(l)
end

@ @<Read a multi-lingual char and set |cur_cmd|@>=
if is_mlrep(cur_chr) then begin
  cur_mlcat_idx:=get_ml_catcode_idx(cur_chr);
  cur_cmd:=ml_cat_code(cur_mlcat_idx);
  end
else
  cur_cmd:=cat_code(cur_chr)

@ Whether the carriage return is regarded as space or not is controlled
by \.{\\jendlinetype}.

@d jend_ascii==0
@d jend_comment_bit==1
@d jend_ignore_bit==2
@d is_jend_comment(#)==odd(#)  {dirty}
@d is_jend_ignore(#)==((#)>=jend_ignore_bit)   {dirty}

@ @<Glob...@>=
@!delayed_cat_ret:boolean; {used to ignore CR after/before jletter}

@ @<Set init...@>=
delayed_cat_ret:=false;

@ @<Check if the last character of the line is japanese...@>=
begin
if jendline_type>jend_ascii then begin {TODO:catcode of buffer[loc-2]}
  jletter_endline:=is_mlrep(buffer[loc-2]) and
		   ml_font_agl(mlrep_mc(buffer[loc-2]));
  if is_jend_comment(jendline_type) and jletter_endline then
    @<Finish line, |goto switch|@>;
  if is_jend_ignore(jendline_type) then begin
    if is_mlrep_ascii(buffer[loc-2]) then begin
      if @<The last character is not ascii punctuation@> then begin
        delayed_cat_ret:=true;
        @<Finish line, |goto switch|@>;
        end;
      end;
    end;
  end;
@<Finish line, emit a space@>;
end

@ @<Restore delayed |cat_ret| and return, if appropriate@>=
if delayed_cat_ret then begin {|state=new_line| now}
  delayed_cat_ret:=false;
  if ({jletter_endline and} cur_cmd=spacer) or
     ((not jletter_endline) and cur_cmd<>jletter) then begin
    cur_cmd:=spacer; cur_chr:=" ";
    backward_onechar(loc); return;
    end
  end

@ @<Emit a space, |delayed_cat_ret:=false|, and return@>=
begin cur_cmd:=spacer; cur_chr:=" "; delayed_cat_ret:=false; return;
end

@ @<Check a multi-lingual char in control sequence name@>=
if is_mlrep(cur_chr) then cat:=ml_cat_code(get_ml_catcode_idx(cur_chr))
else cat:=cat_code(cur_chr)


@ This procedure is similar to |scan_chr_num| ([435]).

@<Declare procedures that scan restricted classes of integers@>=
procedure scan_j_char_num; {TODO:rangecheck}
begin scan_int;
if (cur_val<0) or ((cur_val>255) and (cur_val<mletter_rep_flag)) then begin
  print_err("Bad multi-lingual character code");
  help3("Multi-lingual character number (including ascii character) must be")@/
       ("<= FF or >= 10000 (in hexadecimal).")@/
       ("I changed this on to zero."); @/
  int_error(cur_val); cur_val:=0; end;
end;

@ width and height+depth of japanese zenkaku character.
@<The zw width for current jfont@>=
param(6)(cur_ml_font(mc_jp))

@ @<The zh height for current jfont@>=
param(5)(cur_ml_font(mc_jp))


@ Autoload delayed font. (But multi-lingual font is not delayed.)

@<Declare subprocedures needed for delayed font@>=
function get_ml_font(@!mcs:mc_range):internal_font_number;
var f:internal_font_number;
@!mlf:pointer;
begin
mlf := cur_ml_font_loc(mcs);
if eq_type(mlf) = data then get_ml_font := equiv(mlf)
else if eq_type(mlf) = demmand_font then begin
  f := load_dfont(mlf,equiv(mlf));
  {if font_mcset[f]<>mcs then print_err("Multi-ligual charset mismatch");}
  deq_define(mlf,set_font,f);
  get_ml_font := f;
  end
else begin
  print_err("Improper multi-lingual font "); print_cs(mlf);
  help2("Commands that have the same name as multi-lingual font")@/
       ("should not be defined");
  error; get_ml_font := null_font;
  end
end;

{TODO:remove}
@ @<|cur_chr| is jis space@>=
cur_chr=make_cn_mlrep(mc_jp)(@"21*256+@"21)

{TODO:remove}
@ @<set |main_i| for JIS space@>=
main_i.b2:=no_tag

@ @<Local variables for |main_control|@>=
@!p:pointer; {general-purpose temporary variable}

@ @<Multi-lingual char in math@>=
{if @<|cur_chr| is jis space@> then} {treat JIS space (!!) specially}
  {@<Insert |jspaceskip|@>
else} begin p:=new_noad;
  math_type(nucleus(p)):=sub_box;
  info(nucleus(p)):=
    char_box(get_ml_font(mlrep_mc(cur_chr)),mlrep_char(cur_chr));
  tail_append(p);
  end


@ ascii cat_ret japanese

@d ascii_norm=0
@d ascii_punct=1

@ @<Initialize table entries...@>=
for k:=0 to 255 do asc_punct(k):=ascii_norm;

@ @<The last character is not ascii punctuation@>=
  (asc_punct(buffer[loc-2])<>ascii_punct)


@ Kinsoku shori.

Insertion of nobreak (maximum penalty) is forced when a japanese character
cannot appear at the beginning of a line or at the end of a line. (This is
called ``Kinsoku shori'' in japanese.
|mlintercharskip| is inserted when both previous character and the current
character are japanese characters.

@ Some japanese characters cannot appear at the beginning of a line
(This is called "gyoutou-kinsoku") and several other characters cannot
appear at the end of a line ("gyoumatsu-kinsoku").  Special processing
of these characters is "Kinsoku shori".
This effect is realized by omitting the insertion of |mlintercharskip| or
|mlasciimlcskip| before
gyoutou-kinsoku character and after a gyoumatsu-kinsoku character.

Following constants and Kinsoku table are used in Kinsoku shori.

@d no_kinsoku==0 {You don't need to worry about Kinsoku shori}
@d pre_kinsoku==1 {This character shouldn't appear at the beginning of a line}
@d post_kinsoku==2 {This shouldn't be the last character of a line}

@<Glob...@>=
@!ml_kinsoku_tab: array [0..max_ml_kinsoku_idx] of ML_code;

@ Initialization of Kinsoku table (temporary).  You must be able to change the
data in this table from plain file or on line using new primitive.
Also you need to dump the info when the primitive is introduced and used in
jplain.tex.

@<Initialize table entries...@>=
for k:=0 to 255 do asc_kinsoku(k):=no_kinsoku;
for k:=-1 to max_ml_kinsoku_idx do ml_kinsoku(k):=no_kinsoku;
for k:=0 to max_ml_kinsoku_idx do ml_kinsoku_tab[k]:=non_mlchar;

@ @<Utility ...@>=
function set_ml_kinsoku_idx(c:ML_code): integer;
label exit;
var i0,i:integer;
begin
i0:=c mod (max_ml_kinsoku_idx+1); {TODO:better hash}
i:=i0;
while (ml_kinsoku_tab[i]<>non_mlchar) and (ml_kinsoku_tab[i]<>c) do begin
  incr(i); if i>max_ml_kinsoku_idx then i:=0;
  if i=i0 then begin
    print_err("ml kinsoku table full");
    help0; error; set_ml_kinsoku_idx:=max_ml_kinsoku_idx+1;
    return;
    end;
  end;
ml_kinsoku_tab[i]:=c;
set_ml_kinsoku_idx:=i;
exit:end;
@#
function get_ml_kinsoku_idx(c:ML_code): integer;
label exit;
var i0,i:integer;
begin
i0:=c mod (max_ml_kinsoku_idx+1); {TODO:better hash}
i:=i0;
while (ml_kinsoku_tab[i]<>non_mlchar) and (ml_kinsoku_tab[i]<>c) do begin
  incr(i); if i>max_ml_kinsoku_idx then i:=0;
  if i=i0 then begin get_ml_kinsoku_idx:=-1;
    return;
    end;
  end;
if ml_kinsoku_tab[i]=non_mlchar then get_ml_kinsoku_idx:=-1
else get_ml_kinsoku_idx:=i;
exit:end;
@#
function get_ml_kinsoku_code(n:integer): ML_code;
var i:integer;
begin
get_ml_kinsoku_code:=ml_kinsoku_tab[n];
end;

@ Fake chars.

@d no_fake==0
@d fake_jchar==1
@d fake_char==2
@d fake_math==3

@ New primitive \.{\\fakejchar}, \.{\\fakechar}.

@<Put each...@>=
primitive("fakejchar",faker,fake_jchar);@/
@!@:fakejchar_}{\.{\\fakejchar} primitive@>
primitive("fakechar",faker,fake_char);@/
@!@:fakechar_}{\.{\\fakechar} primitive@>
primitive("fakemath",faker,fake_math);@/
@!@:fakemath_}{\.{\\fakemath} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
faker: case chr_code of
  fake_jchar: print_esc("fakejchar");
  fake_char: print_esc("fakechar");
  fake_math: print_esc("fakemath");
  endcases;

@ Kinsoku shori.

@<Glob...@>=
@!main_mc,main_c:halfword;
@!prev_cmd:eight_bits; {the previous command}
@!prev_chr:halfword; {the previous character}
@!prev_mc,prev_c:halfword;
@!kinsoku_shori:boolean; {used in Kinsoku shori routine}
@!burasage_shori:boolean; {used in Burasage shori routine}
@!prev_jkern,cur_jkern:eight_bits;
@!prev_jkern_info:integer;

@ @<Kinsoku shori; insert or omit glue before jletter@>=
begin if tail<>head then
  if is_char_node(tail) then begin
    prev_mc:=ml_font_mc(font(tail));
    if ml_font_agl(prev_mc) then begin prev_c:=character(tail);
      @<Insert or omit |mlintercharskip| using Kinsoku table@>;
      end
    else begin prev_chr:=character(tail);
      @<Insert or omit |mlasciimlcskip| before jletter using Kinsoku table@>;
      end;
    end
  else if type(tail)=math_node then
    @<Insert or omit |mlmathmlcskip| before jletter using Kinsoku table@>
else {or the case tail is space}
  @<Left boundary of japanese char@>;
end

@ @<Kinsoku shori; insert or omit glue after jletter@>=
begin if tail<>head then
  if is_char_node(tail) then if ml_font_agl(ml_font_mc(font(tail))) then begin
    prev_mc:=ml_font_mc(font(tail)); prev_c:=character(tail);
    prev_chr:=make_cn_mlrep(prev_mc)(prev_c);
    @<Insert or omit |mlasciimlcskip| after jletter using Kinsoku table@>;
    end;
end

@ @<Kinsoku shori; insert or omit glue and |goto main_loop_move|,...@>=
begin
if prev_cmd=faker then begin
  if prev_c=fake_jchar then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |mlintercharskip|@>;
      end
    else begin
      kinsoku_shori:=false;
      @<Test of ascii pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |mlasciimlcskip|@>;
      end;
    goto main_loop_move;
    end
  else if prev_c=fake_char then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |mlasciimlcskip|@>;
      goto main_loop_move;
      end
    end
  else if prev_c=fake_math then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |mlmathmlcskip|@>;
      goto main_loop_move;
      end
    end
  end
else if cur_cmd=jletter then begin
  if prev_cmd=jletter then begin
    prev_mc:=mlrep_mc(prev_chr);
    @<Insert or omit |mlintercharskip| using Kinsoku table@>;
    end
  else begin wrapup(rt_hit); prev_mc:=mc_ascii;
    @<Insert or omit |mlasciimlcskip| before jletter using Kinsoku table@>;
    end;
  goto main_loop_move;
  end
else if prev_cmd=jletter then begin
  prev_mc:=mlrep_mc(prev_chr);
  @<Insert or omit |mlasciimlcskip| after jletter using Kinsoku table@>;
  goto main_loop_move;
  end;
end

@ Insertion of glue between jletter and math is done in |after_math| ([1194]).

@<Kinsoku shori; insert or omit glue between jletter and math@>=
begin if tail<>head then
  if is_char_node(tail) then if ml_font_agl(ml_font_mc(font(tail))) then begin
    prev_mc:=ml_font_mc(font(tail)); prev_c:=character(tail);
    prev_chr:=make_cn_mlrep(prev_mc)(prev_c);
    @<Insert or omit |mlmathmlcskip| after jletter using Kinsoku table@>;
    end;
end

@ Kinsoku shori (between jletter and jletter)

@<Insert or omit |mlintercharskip| using Kinsoku table@>=
begin if ml_font_agl(main_mc) then begin
  kinsoku_shori:=false; burasage_shori:=false;
  prev_jkern:=no_jkern; cur_jkern:=no_jkern;
  @<Test of jletter post-kinsoku@>;
  @<Test of burasage and jkern@>;
  @<Test of jletter pre-kinsoku@>;
  if @<interchar jkern@> then @<Do interchar jkern@>
  else if burasage_shori then @<Burasage shori@>;
  if not kinsoku_shori then @<Insert |mlintercharskip|@>;
  end;
end

@ Kinsoku shori (between jletter and ascii)

@<Insert or omit |mlasciimlcskip| after jletter using Kinsoku table@>=
begin if ml_font_agl(prev_mc) then begin
  kinsoku_shori:=false; burasage_shori:=false;
  prev_jkern:=no_jkern; cur_jkern:=no_jkern;
  @<Test of jletter post-kinsoku@>;
  @<Test of burasage and jkern@>;
  @<Test of ascii pre-kinsoku@>;
  if @<interchar jkern@> then @<Do interchar jkern@>
  else if burasage_shori then @<Burasage shori@>;
  if not kinsoku_shori then @<Insert |mlasciimlcskip|@>;
  end;
end

@ Kinsoku shori (between ascii and jletter)

@<Insert or omit |mlasciimlcskip| before jletter using Kinsoku table@>=
begin if ml_font_agl(main_mc) then begin
  kinsoku_shori:=false;
  @<Test of ascii post-kinsoku@>;
  @<Test of jletter pre-kinsoku@>;
  if not kinsoku_shori then @<Insert |mlasciimlcskip|@>;
  end;
end

@ Kinsoku shori (between jletter and math)

@<Insert or omit |mlmathmlcskip| after jletter using Kinsoku table@>=
begin if ml_font_agl(prev_mc) then begin
  kinsoku_shori:=false;
  @<Test of jletter post-kinsoku@>;
  if not kinsoku_shori then @<Insert |mlmathmlcskip|@>;
  end;
end

@ Kinsoku shori (between math and jletter)

@<Insert or omit |mlmathmlcskip| before jletter using Kinsoku table@>=
begin if ml_font_agl(main_mc) then begin
  kinsoku_shori:=false;
  @<Test of jletter pre-kinsoku@>;
  if not kinsoku_shori then @<Insert |mlmathmlcskip|@>;
  end;
end

@ @<Test of ascii pre-kinsoku@>=
begin
if asc_kinsoku(cur_chr)=pre_kinsoku then kinsoku_shori:=true;
end

@ @<Test of ascii post-kinsoku@>=
begin
if asc_kinsoku(prev_chr)=post_kinsoku then kinsoku_shori:=true;
end

@ @<Test of jletter pre-kinsoku@>=
begin
if ml_kinsoku(get_ml_kinsoku_idx(cur_chr))=pre_kinsoku then
  kinsoku_shori:=true;
end

@ @<Test of jletter post-kinsoku@>=
begin
if ml_kinsoku(get_ml_kinsoku_idx(prev_chr))=post_kinsoku then
  kinsoku_shori:=true;
end

@ @<Insert |mlintercharskip|@>=
begin
if ml_interchar_skip=zero_glue then
  tail_append(new_glue(glue_par(ml_iskip_code+main_mc)))
else
  tail_append(new_param_glue(ml_interchar_skip_code))
end

@ @<Insert |mlasciimlcskip|@>=
begin
if ml_ascii_mlc_skip=zero_glue then begin
  if main_mc=mc_ascii then
    tail_append(new_glue(glue_par(ml_askip_code+prev_mc)))
  else
    tail_append(new_glue(glue_par(ml_askip_code+main_mc)))
  end
else
  tail_append(new_param_glue(ml_ascii_mlc_skip_code))
end

@ @<Insert |mlmathmlcskip|@>=
begin
if ml_math_mlc_skip=zero_glue then begin
  if main_mc=mc_ascii then
    tail_append(new_glue(glue_par(ml_mskip_code+prev_mc)))
  else
    tail_append(new_glue(glue_par(ml_mskip_code+main_mc)))
  end
else
  tail_append(new_param_glue(ml_math_mlc_skip_code))
end

@ @<Insert |jspaceskip|@>=
begin
if j_space_skip=zero_glue then
  tail_append(new_glue(glue_par(ml_sskip_code+mc_jp)))
else
  tail_append(new_param_glue(j_space_skip_code))
end

@ @d make_ml_skip(#)==begin
  p:=new_spec(zero_glue);
  width(p):=font_info[k+#].sc;
  stretch(p):=font_info[k+#+1].sc;
  shrink(p):=font_info[k+#+2].sc;
  end


@ Burasage shori.
This is an experimental hack.

@d max_jsy_tab==127
@d max_jhira_tab==127
@d max_jkata_tab==127

@d jis_ku_sy=@"21
@d jis_ku_hira=@"24
@d jis_ku_kata=@"25
@d jis_ku(#)==((#) div 256)
@d jis_ten(#)==((#) mod 256)

@d no_burasage==0
@d burasage==1

@<Glob...@>=
@!jsy_burasage_table: array [0..max_jsy_tab] of 0..1;

@ @<Initialize table entries...@>=
for k:=0 to max_jsy_tab do jsy_burasage_table[k]:=no_burasage;

@ New primitive \.{\\burasage}.

@<Put each...@>=
primitive("burasage",set_burasage,0);@/
@!@:burasage_}{\.{\\burasage} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_burasage: print_esc("burasage");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_burasage): set_burasage_table;

@ Read a japanese or ascii char and set its burasage code.

@<Declare act...@>=
procedure set_burasage_table;
var @!mc:halfword;
@!cc:quarterword;
begin
scan_j_char_num; mc:=cur_val; cc:=mlrep_char(mc);
scan_optional_equals; scan_int;
if ((cur_val<0) or (cur_val>1)) then begin
  print_err("Invalid Burasage code ("); print_int(cur_val); print_char(")");@/
  help2("Burasage code must be 0(no burasage) or 1(burasage).")@/
       ("I'm going to use 0 instead of that illegal code value.");@/
  error; cur_val:=0; end;
if cc<=255 then {set Burasage code for an ASCII character}
  print_err("You cannot set Burasage code for ascii character.")
else begin {TODO:range check}
  if jis_ku(cc)=jis_ku_sy then jsy_burasage_table[jis_ten(cc)]:=cur_val
  else begin
   print_err("You cannot set Burasage code for this character:");
   print_char(mc);
   help2("Burasage code can be set only for japanese symbols.")@/
        ("So I will ignore this.");@/
   error;
   end
 end;
end;

@ burasage flag
@d br_kin==0
@d br_norm==1
@d br_bnd==2
@<Types...@>=
@!br_stat=br_kin..br_bnd;

@ @<Declare act...@>=
procedure burasage_char(@!p:pointer;@!br:br_stat);
var q:four_quarters;
@!hd:eight_bits; {|height_depth| byte}
@!b:pointer; {the new box and its character node}
@!f:internal_font_number;
@!c:quarterword;
begin c:=character(p); f:=font(p);
q:=char_info(f)(c);
tail_append(p);
if br=br_kin then
else begin tail_append(new_kern(-char_width(f)(q)));
  tail_append(new_penalty(1));
  b:=new_spec(zero_glue);
  width(b):=char_width(f)(q);
  tail_append(new_glue(b));
  if br=br_norm then tail_append(new_penalty(0));
  end;
end;


@ Kerning for japanese char.
This is an experimental hack.

@d no_jkern==0
@d pre_jkern==1
@d post_jkern==2
@d inter_jkern==3
@d bpre_jkern==4
@d bpost_jkern==5
@d pre_jkern_bit==1
@d post_jkern_bit==2
@d inter_jkern_bit==4
@d bpre_jkern_bit==8
@d bpost_jkern_bit==16
@d is_pre_jkern(#)==odd((#) div  pre_jkern_bit)
@d is_post_jkern(#)==odd((#) div  post_jkern_bit)
@d is_inter_jkern(#)==odd((#) div  inter_jkern_bit)
@d is_bpre_jkern(#)==odd((#) div  bpre_jkern_bit)
@d is_bpost_jkern(#)==odd((#) div  bpost_jkern_bit)
@d max_jkern_info=100

@<Glob...@>=
@!jsy_jkern_table: array [0..max_jsy_tab] of eight_bits;
@!jsy_bpre_jkern: array [0..max_jsy_tab] of pointer;
@!jkern_info: array [0..max_jkern_info] of integer;
@!jkern_inter_glue1: array [0..max_jkern_info] of pointer;
@!jkern_inter_glue2: array [0..max_jkern_info] of pointer;
@!last_jkern_info: integer;

@ @<Initialize table entries...@>=
for k:=0 to max_jsy_tab do jsy_jkern_table[k]:=no_jkern;
last_jkern_info:=0;

@ New primitive \.{\\jkern}.

@<Put each...@>=
primitive("jkern",set_jkern,0);@/
@!@:jkern_}{\.{\\jkern} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_jkern: print_esc("jkern");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_jkern): set_jkern_table;

@ Read a japanese or ascii char and set its jkern code.

@<Declare act...@>=
procedure set_jkern_table;
label exit;
var c1,c2:halfword;
cc:halfword;
p,q:pointer;
begin scan_int;
if (cur_val<no_jkern) or (bpost_jkern<cur_val) then begin
  print_err("Invalid jkern code ("); print_int(cur_val); print_char(")");@/
  error; help0; return;
  end;
case cur_val of {TODO:mc_code=jp check}
no_jkern: begin scan_j_char_num; c1:=mlrep_char(cur_val);
  if jis_ku(c1)=jis_ku_sy then
    jsy_jkern_table[jis_ten(c1)]:=no_jkern;
  end;
inter_jkern: begin scan_j_char_num; c1:=mlrep_char(cur_val);
  scan_glue(glue_val); p:=cur_val;
  scan_j_char_num; c2:=mlrep_char(cur_val);
  scan_glue(glue_val); q:=cur_val;
  if jis_ku(c1)=jis_ku_sy then begin cc:=(256*256)*c1+c2;
    c1:=jis_ten(c1);
    jsy_jkern_table[c1]:=inter_jkern_bit;
    jkern_info[last_jkern_info]:=cc;
    jkern_inter_glue1[last_jkern_info]:=p;
    jkern_inter_glue2[last_jkern_info]:=q;
    incr(last_jkern_info);
    end;
  end;
bpre_jkern: begin scan_glue(glue_val); p:=cur_val;
  scan_j_char_num; c1:=mlrep_char(cur_val);
  if jis_ku(c1)=jis_ku_sy then begin c1:=jis_ten(c1);
    jsy_jkern_table[c1]:=bpre_jkern_bit;
    jsy_bpre_jkern[c1]:=p;
    end;
  end;
othercases begin
  print_err("Sorry, this case of jkern not implemented");
  help0; error
  end
endcases;
exit: end;

@ @<Declare act...@>=
function get_jkern_info_index(cc:halfword):integer;
label exit;
var i:integer;
begin i:=last_jkern_info-1;
  while i>=0 do begin
    if jkern_info[i]=cc then begin
      get_jkern_info_index:=i; return;
      end;
    decr(i)
  end;
  get_jkern_info_index:=-1;
exit: end;

@ @<Burasage shori@>=
begin tail:=cur_q;
  {|link(cur_q)| points prev char}
  if kinsoku_shori then burasage_char(link(cur_q),br_kin)
  else burasage_char(link(cur_q),br_norm);
  if is_bpre_jkern(cur_jkern) then begin
    tail_append(new_glue(jsy_bpre_jkern[jis_ten(main_c)]));
    goto main_loop_move;
  end;
end

@ @<Test of burasage and jkern@>=
begin
if (prev_mc=mc_jp) and (jis_ku(prev_c)=jis_ku_sy) then begin
  if jsy_burasage_table[jis_ten(prev_c)]=burasage then burasage_shori:=true;
  prev_jkern:=jsy_jkern_table[jis_ten(prev_c)];
  if @<interchar jkern@> then begin
    prev_jkern_info:=
      get_jkern_info_index(prev_c*(256*256)+main_c);
    if prev_jkern_info<0 then prev_jkern:=prev_jkern-inter_jkern_bit;
    end;
  end;
if (main_mc=mc_jp) and (jis_ku(main_c)=jis_ku_sy) then
  cur_jkern:=jsy_jkern_table[jis_ten(main_c)];
end

@ @<interchar jkern@>=is_inter_jkern(prev_jkern)

@ @<Do interchar jkern@>=
begin
  tail_append(new_glue(jkern_inter_glue1[prev_jkern_info]));
  tail_append(lig_stack);
  tail_append(new_glue(jkern_inter_glue2[prev_jkern_info]));
  goto big_switch;
end

@ @<Left boundary of japanese char@>=
begin if (main_mc=mc_jp) or (main_mc=mc_jpold) then
if jis_ku(main_c)=jis_ku_sy then
  if is_bpre_jkern(jsy_jkern_table[jis_ten(main_c)]) then
    tail_append(new_glue(jsy_bpre_jkern[jis_ten(main_c)]))
end

@ @<Right boundary of japanese char@>=
begin if (prev_mc=mc_jp) or (prev_mc=mc_jpold) then
if jis_ku(prev_c)=jis_ku_sy then
if jsy_burasage_table[jis_ten(prev_c)]=burasage then begin
  tail:=cur_q;
  {|link(cur_q)| points prev char}
  if cur_cmd=par_end then burasage_char(link(cur_q),br_bnd)
  else burasage_char(link(cur_q),br_norm);
  end;
end


@ Dump.

@<Dump the multi-lingual tables@>=
dump_things(ml_font_blen_tab[mc_min], mc_max-mc_min+1);
dump_things(ml_font_dlen_tab[mc_min], mc_max-mc_min+1);
dump_things(ml_font_agl_tab[mc_min], mc_max-mc_min+1);
dump_io_tabs;
dump_things(ml_catcode_tab[0], max_ml_catcode_idx+1);
dump_things(ml_kinsoku_tab[0], max_ml_kinsoku_idx+1);

@ @<Undump the multi-lingual tables@>=
undump_things(ml_font_blen_tab[mc_min], mc_max-mc_min+1);
undump_things(ml_font_dlen_tab[mc_min], mc_max-mc_min+1);
undump_things(ml_font_agl_tab[mc_min], mc_max-mc_min+1);
undump_io_tabs;
undump_things(ml_catcode_tab[0], max_ml_catcode_idx+1);
undump_things(ml_kinsoku_tab[0], max_ml_kinsoku_idx+1);

@ @<Dump the Kinsoku tables@>=
dump_things(jsy_burasage_table[0], max_jsy_tab+1);
dump_things(jsy_jkern_table[0], max_jsy_tab+1);

@ @<Undump the Kinsoku tables@>=
undump_things(jsy_burasage_table[0], max_jsy_tab+1);
undump_things(jsy_jkern_table[0], max_jsy_tab+1);


@* \[54] System-dependent changes.
@z

@x [54.1379] l.24916 - extra routines
@* \[55] Index.
@y

@ @<Declare action procedures for use by |main_control|@>=

procedure insert_src_special;
var toklist, p, q : pointer;
begin
  if (source_filename_stack[in_open] > 0 and is_new_source (source_filename_stack[in_open]
, line)) then begin
    toklist := get_avail;
    p := toklist;
    info(p) := cs_token_flag+frozen_special;
    link(p) := get_avail; p := link(p);
    info(p) := left_brace_token+"{";
    q := str_toks (make_src_special (source_filename_stack[in_open], line));
    link(p) := link(temp_head);
    p := q;
    link(p) := get_avail; p := link(p);
    info(p) := right_brace_token+"}";
    ins_list (toklist);
    remember_source_info (source_filename_stack[in_open], line);
  end;
end;

procedure append_src_special;
var p, q : pointer;
begin
  if (source_filename_stack[in_open] > 0 and is_new_source (source_filename_stack[in_open]
, line)) then begin
    new_whatsit (special_node, write_node_size);
    write_stream(tail) := null;
    def_ref := get_avail;
    token_ref_count(def_ref) := null;
    q := str_toks (make_src_special (source_filename_stack[in_open], line));
    link(def_ref) := link(temp_head);
    write_tokens(tail) := def_ref;
    remember_source_info (source_filename_stack[in_open], line);
  end;
end;

@ This function used to be in pdftex, but is useful in tex too.

@p function get_nullstr: str_number;
begin
    get_nullstr := "";
end;

@* \[55] Index.
@z
