VERSION = 28.1.1
os2: {
DEFINES += 'VERSION_NUMBER=\'"28.0.0"\''
} else: {
  DEFINES += 'VERSION_NUMBER=\\\"$${VERSION}\\\"'
}


isEmpty(USE_ASPELL) {
         USE_ASPELL = true }

isEmpty(USE_HUNSPELL) {
         USE_HUNSPELL = true }


#contains(USE_ASPELL,true){
#   message ($$USE_ASPELL)}

SOURCES += rvln.cpp \
    main.cpp \
    todo.cpp \
    document.cpp \
    utils.cpp \
    spellchecker.cpp \
    fman.cpp \
    shortcuts.cpp \
    logmemo.cpp \
    img_viewer.cpp \
    tio.cpp \
    tzipper.cpp \
    ioapi.c \
    quazip.cpp \
    quazipfile.cpp \
    quazipnewinfo.cpp \
    unzip.c \
    zip.c

HEADERS += rvln.h \
    todo.h \
    document.h \
    utils.h \
    spellchecker.h \
    fman.h \
    shortcuts.h \
    logmemo.h \
    img_viewer.h \
    zconf.h \
    zlib.h \
    tio.h \
    tzipper.h \
    ioapi.h \
    quazip.h \
    quazipfile.h \
    quazipfileinfo.h \
    quazipnewinfo.h \
    unzip.h \
    zip.h

unix {
      SOURCES += qxtwindowsystem_x11.cpp \
                 qxtwindowsystem.cpp

      DISTFILES += qxtwindowsystem_win.cpp
      HEADERS += qxtwindowsystem.h
     }

win32 {
       SOURCES += qxtwindowsystem_win.cpp \
                  qxtwindowsystem.cpp

       DISTFILES += qxtwindowsystem_x11.cpp
       HEADERS += qxtwindowsystem.h
      }


TEMPLATE = app

CONFIG += warn_on \
    thread \
    qt \
    release \
    link_pkgconfig

QT += xml \
    script \
    svg

TARGET = bin/tea
#target.path = /usr/local/bin

isEmpty( PREFIX ) {
  PREFIX = /usr/local/bin
   }

target.path = $$PREFIX

INSTALLS += target
RESOURCES += rlvn.qrc
TRANSLATIONS = translations/tea_ru.ts \
               translations/tea_de.ts

DISTFILES += ChangeLog \
    COPYING \
    README \
    NEWS \
    NEWS-RU \
    AUTHORS \
    TODO \
    INSTALL \
    hls/* \
    icons/* \
    palettes/* \
    encsign/* \
    images/* \
    manuals/en.html \
    manuals/ru.html \
    text-data/* \
    translations/*

contains(USE_ASPELL,true){
exists("/usr/include/aspell.h") { 
    message ("ASpell enabled")
    LIBS += -laspell
    DEFINES += ASPELL_ENABLE
    DEFINES += SPELLCHECK_ENABLE
}
}

contains(USE_HUNSPELL,true){
exists("/usr/include/hunspell/hunspell.hxx") { 
    message ("hunspell enabled")
#    LIBS += -lhunspell-1.2
#    LIBS += $$system(pkg-config hunspell --libs)
    PKGCONFIG += hunspell
    DEFINES += HUNSPELL_ENABLE
    DEFINES += SPELLCHECK_ENABLE
}
}

DEFINES += NOCRYPT \
          NOUNCRYPT
