/*
 * passlog.h - DataLog class for passwords capture
 * $Id: passlog.h,v 1.2 2004/06/05 15:15:17 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_PASSLOG_H

# define __TCPREEN_PASSLOG_H
# include "buflog.h"

# ifndef __cplusplus
#  error This is a C++ only header!
# else

#  define PASSLOG_MAXUSER	128
#  define PASSLOG_MAXPASS	128

class PasswordDataLog : public LineBufDataLog
{
	private:
		char username[PASSLOG_MAXUSER], password[PASSLOG_MAXPASS],
				linebuf[1024];

		virtual int WriteServerLine (const char *data, int length,
						int oob);
		virtual int WriteClientLine (const char *data, int length,
						int oob);

	public:
		PasswordDataLog (void) : LineBufDataLog ()
		{
			*username = *password = 0;
			SetClientBuffer (linebuf, sizeof (linebuf));
		}
};


/*
 * Makers for the above classes
 */
extern DataLog *PasswordLogMaker (void);

# endif /* ifdef __cplusplus */
#endif /* ifndef __TCPREEN_PASSLOG_H */
