[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::chan::fifo n 1]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {In-memory fifo channel}]
[require Tcl 8.5]
[require TclOO]
[require tcl::chan::events [opt 1]]
[require tcl::chan::fifo [opt 1]]
[description]
[para]

The [package tcl::chan::fifo] package provides a command creating
channels which live purely in memory. Access is fifo-like, i.e. things
are read out of the channel in the order they were written to it.

This is equivalent to the fifo channels provided by the package
[package Mmechan], except that this is written in pure Tcl, not C. On
the other hand, [package Memchan] is usable with Tcl 8.4 and before,
whereas this package requires Tcl 8.5 or higher, and [package TclOO].

[para] The internal [package TclOO] class implementing the channel
handler is a sub-class of the [package tcl::chan::events] framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::chan::fifo]]

This command creates a new fifo channel and returns its handle.

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph virtchannel] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[keywords fifo]
[keywords {virtual channel} {reflected channel} {in-memory channel} {tip 219}]
[manpage_end]
