[manpage_begin nameserv n 0.3]
[copyright {2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Name service facility}]
[titledesc {Name service facility, Client}]
[require Tcl 8.4]
[require nameserv [opt 0.3]]
[require comm]
[require logger]
[keywords {name service} client]
[see_also nameserv::common(n)]
[see_also nameserv::server(n)]
[description]

This package provides a client for the name service facility
implemented by the package [package nameserv::server].

[section API]

The package exports eight commands, as specified below:

[list_begin definitions]

[call [cmd ::nameserv::bind] [arg name] [arg data]]

The caller of this command registers the given [arg name] as its name
in the configured name service, and additionally associates a piece of
[arg data] with it. The service does nothing with this information
beyond storing it and delivering it as part of search results. The
meaning is entirely up to the applications using the name service.

[para]

A generally useful choice would for example be an identifier for a
communication endpoint managed by the package [package comm]. Anybody
retrieving the name becomes immediately able to talk to this endpoint,
i.e. the registering application.

[para]

Of further importance is that a caller can register itself under more
than one name, and each name can have its own piece of [arg data].

[para]

Note that the name service, and thwerefore this command, will throw an
error if the chosen name is already registered.


[call [cmd ::nameserv::release]]

Invoking this command releases all names (and their data) registered
by all previous calls to [cmd ::nameserv::bind] of this client. Note
that the name service will run this command implicitly when it loses
the connection to this client.


[call [cmd ::nameserv::search] [opt [option -async]|[option -continuous]] [opt [arg pattern]]]

This command searches the name service for all registered names
matching the specified glob-[arg pattern]. If not specified the
pattern defaults to [const *], matching everything. The result of the
command is a dictionary mapping the matching names to the data
associated with them at [term bind]-time.

[para]

If either option [option -async] or [option -continuous] were
specified the result of this command changes and becomes the Tcl
command of an object holding the actual result.

These two options are supported if and only if the service the client
is connected to supports the protocol feature
[term Search/Continuous].

[para]

For [option -async] the result object is asynchronously filled with
the entries matching the pattern at the time of the search and then
not modified any more.

The option [option -continuous] extends this behaviour by additionally
continuously monitoring the service for the addition and removal of
entries which match the pattern, and updating the object's contents
appropriately.

[para]

[emph Note] that the caller is responsible for configuring the object
with a callback for proper notification when the current result (or
further changes) arrive.

[para]

For more information about this object see section
[sectref {ASYNCHRONOUS AND CONTINUOUS SEARCHES}].


[call [cmd ::nameserv::protocol]]

This command returns the highest version of the name service protocol
supported by the package.


[call [cmd ::nameserv::server_protocol]]

This command returns the highest version of the name service protocol
supported by the name service the client is currently connected to.


[call [cmd ::nameserv::server_features]]

This command returns a list containing the names of the features of
the name service protocol which are supported by the name service the
client is currently connected to.


[call [cmd ::nameserv::cget] [option -option]]

This command returns the currently configured value for the specified
[option -option]. The list of supported options and their meaning can
be found in section [sectref OPTIONS].

[call [cmd ::nameserv::configure]]

In this form the command returns a dictionary of all supported
options, and their current values. The list of supported options and
their meaning can be found in section [sectref OPTIONS].


[call [cmd ::nameserv::configure] [option -option]]

In this form the command is an alias for
"[cmd ::nameserv::cget] [option -option]]".

The list of supported options and their meaning can be found in
section [sectref OPTIONS].


[call [cmd ::nameserv::configure] "[option -option] [arg value]..."]

In this form the command is used to configure one or more of the
supported options. At least one option has to be specified, and each
option is followed by its new value.

The list of supported options and their meaning can be found in
section [sectref OPTIONS].

[para]

This form can be used only as long as the client has not contacted the
name service yet. After contact has been made reconfiguration is not
possible anymore. This means that this form of the command is for the
initalization of the client before it use.

The command forcing a contact with the name service are

[list_begin commands]
[cmd_def bind]
[cmd_def release]
[cmd_def search]
[cmd_def server_protocol]
[cmd_def server_features]
[list_end]
[list_end]


[section {CONNECTION HANDLING}]

The client automatically connects to the service when one of the
commands below is run for the first time, or whenever one of the
commands is run after the connection was lost, when it was lost.

[para]
[list_begin commands]
[cmd_def bind]
[cmd_def release]
[cmd_def search]
[cmd_def server_protocol]
[cmd_def server_features]
[list_end]
[para]

Since version 0.2 of the client it will generate an event when the
connection is lost, allowing higher layers to perform additional
actions. This is done via the support package [package uevent]. This
and all other name service related packages hereby reserve the
uevent-tag [term nameserv]. All their events will be posted to that
tag.

[para]

The sole event generated by this package is [term lost-connection].
The detail information coming with that event will be a Tcl
dictionary. The only contained key will be [const reason], and its
value will be a string describing why the connection was lost.


[section OPTIONS]

The options supported by the client are for the specification of which
name service to contact, i.e. of the location of the name service.

They are:

[list_begin options]
[opt_def -host [arg name]|[arg ipaddress]]

This option specifies the host name service to contact is running on,
either by [arg name], or by [arg ipaddress]. The initial default is
[const localhost], i.e. it is expected to contact a name service
running on the same host as the application using this package.


[opt_def -port [arg number]]

This option specifies the port the name service to contact is
listening on. It has to be a positive integer number (> 0) not greater
than 65536 (unsigned short). The initial default is the number
returned by the command [cmd ::nameserv::common::port], as provided by
the package [package ::nameserv::common].

[list_end]


[section {ASYNCHRONOUS AND CONTINUOUS SEARCHES}]

Asynchronous and continuous searches are invoked by using either
option [option -async] or [option -continuous] as argument to the
command [cmd ::nameserv::search].

[para]

[emph Note] that these two options are supported if and only if the
service the client is connected to supports the protocol feature
[term Search/Continuous]. The service provided by the package
[package ::nameserv::server] does this since version 0.3.

[para]

For such searches the result of the search command is the Tcl command
of an object holding the actual result. The API provided by these
objects is:

[list_begin definitions]

[lst_item Options:]
[list_begin options]
[opt_def -command [arg command_prefix]]

This option has to be set if a user of the result object wishes to get
asynchronous notifications when the search result or changes to it
arrive.

[para]

[emph Note] that while it is possible to poll for the arrival of the
initial search result via the method [method filled], and for
subsequent changes by comparing the output of method [method getall]
against a saved copy, this is not the recommended behaviour. Setting
the [option -command] callback and processing the notifications as
they arrive is much more efficient.

[para]

The [arg command_prefix] is called with two arguments, the type of
change, and the data of the change. The type is either [const add] or
[const remove], indicating new data, or deleted data, respectively.
The data of the change is always a dictionary listing the
added/removed names and their associated data.

[para]

The first change reported for a search is always the set of matching
entries at the time of the search.

[list_end]

[lst_item Methods:]
[list_begin definitions]

[call [cmd \$result] [method destroy]]

Destroys the object and cancels any continuous monitoring of the
service the object may have had active.


[call [cmd \$result] [method filled]]

The result is a boolean value indicating whether the search result has
already arrived ([const True]), or not ([const False]).

[call [cmd \$result] [method get] [arg name]]

Returns the data associated with the given [arg name] at
[term bind]-time.

[call [cmd \$result] [method names]]

Returns a list containing all names known to the object at the time of
the invokation.

[call [cmd \$result] [method size]]

Returns an integer value specifying the size of the result at the time
of the invokation.

[call [cmd \$result] [method getall] [opt [arg pattern]]]

Returns a dictionary containing the search result at the time of the
invokation, mapping the matching names to the data associated with
them at [term bind]-time.

[list_end]
[list_end]


[section HISTORY]
[list_begin definitions]
[def 0.3]
Extended the client with the ability to perform asynchronous and
continuous searches.

[def 0.2]
Extended the client with the ability to generate events when it loses
its connection to the name service. Based on package [package uevent].

[def 0.1]
Initial implementation of the client.
[list_end]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph nameserv] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[manpage_end]
