/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/input/prefix.cc
 */

#ifndef COMMON_TAR_INPUT_PREFIX_H
#define COMMON_TAR_INPUT_PREFIX_H

#include <rcstring.h>
#include <tar/input/filter.h>

/**
  * The tar_input_filter_mode_clear class is used to represent a filter
  * which adds a directory prefix to each file name in tar archive
  * file headers.
  */
class tar_input_filter_prefix:
    public tar_input_filter
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_input_filter_prefix();

    /**
      * The constructor.
      *
      * \param deeper
      *     The input stream to apply the filter to.
      * \param prefix
      *     The directory prefix to be applied to file names.
      */
    tar_input_filter_prefix(tar_input *deeper, const rcstring &prefix);

    // See base classfor documentation.
    virtual int read_header(tar_header &);

private:
    /**
      * The prefix instance variable is used to remember the directory
      * prefix to be applied to each file name in the tar archive.
      */
    rcstring prefix;

    /**
      * The default constructor.  Do not use.
      */
    tar_input_filter_prefix();

    /**
      * The copy constructor.  Do not use.
      */
    tar_input_filter_prefix(const tar_input_filter_prefix &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_input_filter_prefix &operator = (const tar_input_filter_prefix &);
};

#endif /* COMMON_TAR_INPUT_PREFIX_H */
