//
//	tardy - a tar post-processor
//	Copyright (C) 2002 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to manipulate files
//

#pragma implementation "filenamelist_file"

#include <ac/string.h>
#include <filenamelist/file.h>


filenamelist_file::~filenamelist_file()
{
	delete source;
}


filenamelist_file::filenamelist_file(file_input *arg) :
	source(arg),
	position(0),
	length(0)
{
}


int
filenamelist_file::read_one_char()
{
	if (position >= length)
	{
		position = 0;
		length = source->read(buffer, sizeof(buffer));
		if (length == 0)
			return -1;
	}
	return buffer[position++];
}


bool
filenamelist_file::read_one_line(rcstring &result)
{
	static char *temp;
	static size_t maximum;
	size_t length = 0;
	for (;;)
	{
		int c = read_one_char();
		if (c < 0)
		{
			if (length)
			{
				while (length && temp[length - 1] == '/')
					--length;
				result = rcstring(temp, length);
				return true;
			}
			return false;
		}
		if (c == '\n')
		{
			while (length && temp[length - 1] == '/')
				--length;
			result = rcstring(temp, length);
			return true;
		}
		if (length >= maximum)
		{
			maximum = maximum * 2 + 16;
			char *temp2 = new char[maximum];
			memcpy(temp2, temp, length);
			delete temp;
			temp = temp2;
		}
		temp[length++] = c;
	}
}


const char *
filenamelist_file::filename()
	const
{
	return source->filename();
}
