/* rygel-media-query-action.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-media-query-action.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaQueryActionRunData RygelMediaQueryActionRunData;
typedef struct _RygelMediaQueryActionFetchMediaObjectData RygelMediaQueryActionFetchMediaObjectData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	RygelXBoxHacks* xbox_hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelMediaQueryActionPrivate {
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_XBOX_HACKS_ERROR_NA
} RygelXBoxHacksError;
#define RYGEL_XBOX_HACKS_ERROR rygel_xbox_hacks_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaQueryActionRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* results;
	RygelMediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaObject* _tmp7_;
	guint32 _tmp8_;
	guint32 _tmp9_;
	RygelMediaObjects* _tmp10_;
	const gchar* _tmp11_;
	RygelMediaObjects* _tmp12_;
	GUPnPDIDLLiteWriter* _tmp13_;
	RygelHTTPServer* _tmp14_;
	RygelXBoxHacks* _tmp15_;
	GError* err;
	GError* _tmp16_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaQueryActionFetchMediaObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaQueryAction* self;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaContainer* _tmp3_;
	RygelMediaObject* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaContainer* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};


static gpointer rygel_media_query_action_parent_class = NULL;
static RygelStateMachineIface* rygel_media_query_action_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionPrivate))
enum  {
	RYGEL_MEDIA_QUERY_ACTION_DUMMY_PROPERTY,
	RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE
};
#define RYGEL_MEDIA_QUERY_ACTION_DEFAULT_SORT_CRITERIA "+dc:title"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
GQuark rygel_xbox_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error);
static void rygel_media_query_action_real_run_data_free (gpointer _data);
static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* _data_);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error);
static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const gchar* sort_criteria);
void rygel_media_objects_serialize (RygelMediaObjects* self, GUPnPDIDLLiteWriter* didl_writer, RygelHTTPServer* http_server, RygelXBoxHacks* xbox_hacks, GError** error);
static void rygel_media_query_action_conclude (RygelMediaQueryAction* self);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error);
GQuark rygel_content_directory_error_quark (void);
static void rygel_media_query_action_validate_sort_criteria (RygelMediaQueryAction* self, GError** error);
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, gchar** container_id);
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "dc:artist,dc:author,upnp:album," "dc:date,upnp:originalTrackNumber"
static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data);
static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_media_query_action_finalize (GObject* obj);
static void _vala_rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	return self ? g_object_ref (self) : NULL;
#line 354 "rygel-media-query-action.c"
}


RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelMediaQueryAction * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelContentDirectory* _tmp3_;
	RygelHTTPServer* _tmp4_;
	RygelHTTPServer* _tmp5_;
	RygelContentDirectory* _tmp6_;
	guint32 _tmp7_;
	RygelContentDirectory* _tmp8_;
	GCancellable* _tmp9_;
	GUPnPServiceAction* _tmp10_;
	GUPnPDIDLLiteWriter* _tmp11_;
	GError * _inner_error_ = NULL;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) g_object_new (object_type, NULL);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = content_dir;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp1_ = _tmp0_->root_container;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->root_container);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->root_container = _tmp2_;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp3_ = content_dir;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp4_ = _tmp3_->http_server;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->http_server);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->http_server = _tmp5_;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp6_ = content_dir;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp7_ = _tmp6_->system_update_id;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->system_update_id = _tmp7_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp8_ = content_dir;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp9_ = _tmp8_->cancellable;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp9_);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp10_ = action;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	action = NULL;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->action = _tmp10_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp11_ = gupnp_didl_lite_writer_new (NULL);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->didl_writer);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->didl_writer = _tmp11_;
#line 423 "rygel-media-query-action.c"
	{
		GUPnPServiceAction* _tmp12_;
		RygelXBoxHacks* _tmp13_;
		RygelXBoxHacks* _tmp14_;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp12_ = self->action;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp13_ = rygel_xbox_hacks_new_for_action (_tmp12_, &_inner_error_);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp14_ = _tmp13_;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_inner_error_ != NULL) {
#line 436 "rygel-media-query-action.c"
			goto __catch61_g_error;
		}
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_g_object_unref0 (self->xbox_hacks);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		self->xbox_hacks = _tmp14_;
#line 443 "rygel-media-query-action.c"
	}
	goto __finally61;
	__catch61_g_error:
	{
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_clear_error (&_inner_error_);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_inner_error_ = NULL;
#line 452 "rygel-media-query-action.c"
	}
	__finally61:
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_inner_error_ != NULL) {
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_clear_error (&_inner_error_);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return NULL;
#line 463 "rygel-media-query-action.c"
	}
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	return self;
#line 467 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_run_data_free (gpointer _data) {
	RygelMediaQueryActionRunData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_slice_free (RygelMediaQueryActionRunData, _data_);
#line 478 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryAction * self;
	RygelMediaQueryActionRunData* _data_;
	RygelMediaQueryAction* _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) base;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_ = g_slice_new0 (RygelMediaQueryActionRunData);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_real_run);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_real_run_data_free);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	rygel_media_query_action_real_run_co (_data_);
#line 500 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaQueryActionRunData* _data_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 508 "rygel-media-query-action.c"
}


static void rygel_media_query_action_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionRunData* _data_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_ = _user_data_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_source_object_ = source_object;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_res_ = _res_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	rygel_media_query_action_real_run_co (_data_);
#line 522 "rygel-media-query-action.c"
}


static gboolean rygel_media_query_action_real_run_co (RygelMediaQueryActionRunData* _data_) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	switch (_data_->_state_) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		case 0:
#line 531 "rygel-media-query-action.c"
		goto _state_0;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		case 1:
#line 535 "rygel-media-query-action.c"
		goto _state_1;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		case 2:
#line 539 "rygel-media-query-action.c"
		goto _state_2;
		default:
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_assert_not_reached ();
#line 544 "rygel-media-query-action.c"
	}
	_state_0:
	{
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_media_query_action_parse_args (_data_->self, &_data_->_inner_error_);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 552 "rygel-media-query-action.c"
			goto __catch62_g_error;
		}
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_state_ = 1;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_media_query_action_fetch_media_object (_data_->self, rygel_media_query_action_run_ready, _data_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return FALSE;
#line 561 "rygel-media-query-action.c"
		_state_1:
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp0_ = NULL;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp0_ = rygel_media_query_action_fetch_media_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->media_object = _data_->_tmp0_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 571 "rygel-media-query-action.c"
			goto __catch62_g_error;
		}
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp1_ = _data_->media_object;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_state_ = 2;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_media_query_action_fetch_results (_data_->self, _data_->_tmp1_, rygel_media_query_action_run_ready, _data_);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return FALSE;
#line 582 "rygel-media-query-action.c"
		_state_2:
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp2_ = NULL;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp2_ = rygel_media_query_action_fetch_results_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->results = _data_->_tmp2_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_g_object_unref0 (_data_->media_object);
#line 594 "rygel-media-query-action.c"
			goto __catch62_g_error;
		}
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp3_ = _data_->results;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->self->number_returned = (guint) _data_->_tmp5_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp6_ = _data_->media_object;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp6_)) {
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->_tmp7_ = _data_->media_object;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->_tmp8_ = RYGEL_MEDIA_CONTAINER (_data_->_tmp7_)->update_id;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->self->update_id = (guint) _data_->_tmp8_;
#line 615 "rygel-media-query-action.c"
		} else {
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->_tmp9_ = G_MAXUINT32;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->self->update_id = (guint) _data_->_tmp9_;
#line 621 "rygel-media-query-action.c"
		}
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp10_ = _data_->results;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp11_ = _data_->self->sort_criteria;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_media_objects_sort_by_criteria (_data_->_tmp10_, _data_->_tmp11_);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp12_ = _data_->results;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp13_ = _data_->self->didl_writer;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp14_ = _data_->self->http_server;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp15_ = _data_->self->xbox_hacks;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_media_objects_serialize (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_, &_data_->_inner_error_);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_g_object_unref0 (_data_->results);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_g_object_unref0 (_data_->media_object);
#line 645 "rygel-media-query-action.c"
			goto __catch62_g_error;
		}
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_media_query_action_conclude (_data_->self);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_g_object_unref0 (_data_->results);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_g_object_unref0 (_data_->media_object);
#line 654 "rygel-media-query-action.c"
	}
	goto __finally62;
	__catch62_g_error:
	{
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->err = _data_->_inner_error_;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_inner_error_ = NULL;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp16_ = _data_->err;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_media_query_action_handle_error (_data_->self, _data_->_tmp16_);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_g_error_free0 (_data_->err);
#line 669 "rygel-media-query-action.c"
	}
	__finally62:
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_data_->_inner_error_ != NULL) {
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_clear_error (&_data_->_inner_error_);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return FALSE;
#line 680 "rygel-media-query-action.c"
	}
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_data_->_state_ == 0) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 686 "rygel-media-query-action.c"
	} else {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 690 "rygel-media-query-action.c"
	}
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_object_unref (_data_->_async_result);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	return FALSE;
#line 696 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_parse_args (RygelMediaQueryAction* self, GError** error) {
	gint64 index = 0LL;
	gint64 requested_count = 0LL;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gint64 _tmp6_;
	gboolean _tmp8_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp16_;
	RygelXBoxHacks* _tmp18_;
	GError * _inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = self->action;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp1_ = self->object_id_arg;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	gupnp_service_action_get (_tmp0_, _tmp1_, G_TYPE_STRING, &self->object_id, "Filter", G_TYPE_STRING, &self->filter, "StartingIndex", G_TYPE_INT64, &index, "RequestedCount", G_TYPE_INT64, &requested_count, "SortCriteria", G_TYPE_STRING, &self->sort_criteria, NULL);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp2_ = self->object_id;
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_tmp2_ == NULL) {
#line 726 "rygel-media-query-action.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp3_ = _ ("No such object");
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _tmp3_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_inner_error_ = _tmp4_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return;
#line 739 "rygel-media-query-action.c"
	}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp6_ = index;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_tmp6_ < ((gint64) 0)) {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp5_ = TRUE;
#line 747 "rygel-media-query-action.c"
	} else {
		gint64 _tmp7_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp7_ = requested_count;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp5_ = _tmp7_ < ((gint64) 0);
#line 754 "rygel-media-query-action.c"
	}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp8_ = _tmp5_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_tmp8_) {
#line 760 "rygel-media-query-action.c"
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp9_ = _ ("Invalid range");
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp10_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp9_);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_inner_error_ = _tmp10_;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_propagate_error (error, _inner_error_);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return;
#line 773 "rygel-media-query-action.c"
	}
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp11_ = index;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->index = (guint) _tmp11_;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp12_ = requested_count;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->requested_count = (guint) _tmp12_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp14_ = self->sort_criteria;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_tmp14_ == NULL) {
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp13_ = TRUE;
#line 789 "rygel-media-query-action.c"
	} else {
		const gchar* _tmp15_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp15_ = self->sort_criteria;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp13_ = g_strcmp0 (_tmp15_, "") == 0;
#line 796 "rygel-media-query-action.c"
	}
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp16_ = _tmp13_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_tmp16_) {
#line 802 "rygel-media-query-action.c"
		gchar* _tmp17_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp17_ = g_strdup (RYGEL_MEDIA_QUERY_ACTION_DEFAULT_SORT_CRITERIA);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_g_free0 (self->sort_criteria);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		self->sort_criteria = _tmp17_;
#line 810 "rygel-media-query-action.c"
	}
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	rygel_media_query_action_validate_sort_criteria (self, &_inner_error_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_inner_error_ != NULL) {
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_propagate_error (error, _inner_error_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return;
#line 820 "rygel-media-query-action.c"
	}
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp18_ = self->xbox_hacks;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_tmp18_ != NULL) {
#line 826 "rygel-media-query-action.c"
		RygelXBoxHacks* _tmp19_;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp19_ = self->xbox_hacks;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_xbox_hacks_translate_container_id (_tmp19_, self, &self->object_id);
#line 832 "rygel-media-query-action.c"
	}
}


void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error) {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->parse_args (self, error);
#line 842 "rygel-media-query-action.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1334 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1335 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1335 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1336 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1336 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 877 "rygel-media-query-action.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1337 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1337 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1337 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 886 "rygel-media-query-action.c"
	}
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1339 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 892 "rygel-media-query-action.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1340 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1340 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1340 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 901 "rygel-media-query-action.c"
	}
#line 1342 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1342 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 907 "rygel-media-query-action.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1342 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1342 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1342 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 916 "rygel-media-query-action.c"
	} else {
#line 1342 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 920 "rygel-media-query-action.c"
	}
#line 1342 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1342 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1343 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1343 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 930 "rygel-media-query-action.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1343 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1343 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1343 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 939 "rygel-media-query-action.c"
	} else {
#line 1343 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 943 "rygel-media-query-action.c"
	}
#line 1343 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1343 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1344 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1344 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1344 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1345 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1345 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1345 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1345 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1345 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1345 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 967 "rygel-media-query-action.c"
}


static void rygel_media_query_action_validate_sort_criteria (RygelMediaQueryAction* self, GError** error) {
	GeeHashSet* _tmp0_;
	GeeHashSet* supported_props;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** requested_sort_props;
	gint requested_sort_props_length1;
	gint _requested_sort_props_size_;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	supported_props = _tmp0_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp1_ = self->sort_criteria;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	requested_sort_props = _tmp3_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	requested_sort_props_length1 = _vala_array_length (_tmp2_);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_requested_sort_props_size_ = requested_sort_props_length1;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp5_ = _tmp4_ = g_strsplit (RYGEL_MEDIA_OBJECTS_SORT_CAPS, ",", 0);
#line 1003 "rygel-media-query-action.c"
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		property_collection = _tmp5_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		property_collection_length1 = _vala_array_length (_tmp4_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		for (property_it = 0; property_it < _vala_array_length (_tmp4_); property_it = property_it + 1) {
#line 1015 "rygel-media-query-action.c"
			gchar* _tmp6_;
			gchar* property = NULL;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_tmp6_ = g_strdup (property_collection[property_it]);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			property = _tmp6_;
#line 1022 "rygel-media-query-action.c"
			{
				GeeHashSet* _tmp7_;
				const gchar* _tmp8_;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp7_ = supported_props;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp8_ = property;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_g_free0 (property);
#line 1034 "rygel-media-query-action.c"
			}
		}
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		property_collection = (_vala_array_free (property_collection, property_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1039 "rygel-media-query-action.c"
	}
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp9_ = requested_sort_props;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp9__length1 = requested_sort_props_length1;
#line 1045 "rygel-media-query-action.c"
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		property_collection = _tmp9_;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		property_collection_length1 = _tmp9__length1;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		for (property_it = 0; property_it < _tmp9__length1; property_it = property_it + 1) {
#line 1057 "rygel-media-query-action.c"
			gchar* _tmp10_;
			gchar* property = NULL;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_tmp10_ = g_strdup (property_collection[property_it]);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			property = _tmp10_;
#line 1064 "rygel-media-query-action.c"
			{
				gboolean _tmp11_ = FALSE;
				const gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp16_;
				GeeHashSet* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp12_ = property;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp13_ = g_str_has_prefix (_tmp12_, "+");
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				if (_tmp13_) {
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_tmp11_ = TRUE;
#line 1087 "rygel-media-query-action.c"
				} else {
					const gchar* _tmp14_;
					gboolean _tmp15_ = FALSE;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_tmp14_ = property;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_tmp15_ = g_str_has_prefix (_tmp14_, "-");
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_tmp11_ = _tmp15_;
#line 1097 "rygel-media-query-action.c"
				}
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp16_ = _tmp11_;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				if (!_tmp16_) {
#line 1103 "rygel-media-query-action.c"
					const gchar* _tmp17_;
					GError* _tmp18_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_tmp17_ = property;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_tmp18_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA, "%s is missing + or - modifier", _tmp17_);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_inner_error_ = _tmp18_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					g_propagate_error (error, _inner_error_);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_g_free0 (property);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_g_object_unref0 (supported_props);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					return;
#line 1122 "rygel-media-query-action.c"
				}
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp19_ = supported_props;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp20_ = property;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp21_ = property;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp22_ = strlen (_tmp21_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp23_ = _tmp22_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp24_ = string_slice (_tmp20_, (glong) 1, (glong) _tmp23_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp25_ = _tmp24_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp26_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp19_, _tmp25_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_tmp27_ = !_tmp26_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_g_free0 (_tmp25_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				if (_tmp27_) {
#line 1146 "rygel-media-query-action.c"
					const gchar* _tmp28_;
					GError* _tmp29_;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_tmp28_ = property;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_tmp29_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA, "%s is invalid or not supported", _tmp28_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_inner_error_ = _tmp29_;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					g_propagate_error (error, _inner_error_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_g_free0 (property);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					_g_object_unref0 (supported_props);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
					return;
#line 1165 "rygel-media-query-action.c"
				}
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				_g_free0 (property);
#line 1169 "rygel-media-query-action.c"
			}
		}
	}
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	requested_sort_props = (_vala_array_free (requested_sort_props, requested_sort_props_length1, (GDestroyNotify) g_free), NULL);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (supported_props);
#line 1177 "rygel-media-query-action.c"
}


void rygel_media_query_action_fetch_results (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results (self, media_object, _callback_, _user_data_);
#line 1184 "rygel-media-query-action.c"
}


RygelMediaObjects* rygel_media_query_action_fetch_results_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	return RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->fetch_results_finish (self, _res_, error);
#line 1191 "rygel-media-query-action.c"
}


static void rygel_media_query_action_fetch_media_object_data_free (gpointer _data) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_slice_free (RygelMediaQueryActionFetchMediaObjectData, _data_);
#line 1204 "rygel-media-query-action.c"
}


static void rygel_media_query_action_fetch_media_object (RygelMediaQueryAction* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
	RygelMediaQueryAction* _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_ = g_slice_new0 (RygelMediaQueryActionFetchMediaObjectData);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_query_action_fetch_media_object);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_query_action_fetch_media_object_data_free);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	rygel_media_query_action_fetch_media_object_co (_data_);
#line 1223 "rygel-media-query-action.c"
}


static RygelMediaObject* rygel_media_query_action_fetch_media_object_finish (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaQueryActionFetchMediaObjectData* _data_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return NULL;
#line 1234 "rygel-media-query-action.c"
	}
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	return result;
#line 1244 "rygel-media-query-action.c"
}


static void rygel_media_query_action_fetch_media_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaQueryActionFetchMediaObjectData* _data_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_ = _user_data_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_source_object_ = source_object;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_res_ = _res_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	rygel_media_query_action_fetch_media_object_co (_data_);
#line 1258 "rygel-media-query-action.c"
}


static gboolean rygel_media_query_action_fetch_media_object_co (RygelMediaQueryActionFetchMediaObjectData* _data_) {
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	switch (_data_->_state_) {
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		case 0:
#line 1267 "rygel-media-query-action.c"
		goto _state_0;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		case 1:
#line 1271 "rygel-media-query-action.c"
		goto _state_1;
		default:
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_assert_not_reached ();
#line 1276 "rygel-media-query-action.c"
	}
	_state_0:
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_tmp0_ = _data_->self->object_id;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_tmp1_ = _data_->self->root_container;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_data_->_tmp2_ = ((RygelMediaObject*) _data_->_tmp1_)->id;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (g_strcmp0 (_data_->_tmp0_, _data_->_tmp2_) == 0) {
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp3_ = _data_->self->root_container;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp4_ = _g_object_ref0 ((RygelMediaObject*) _data_->_tmp3_);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->result = _data_->_tmp4_;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_data_->_state_ == 0) {
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1297 "rygel-media-query-action.c"
		} else {
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1301 "rygel-media-query-action.c"
		}
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_object_unref (_data_->_async_result);
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return FALSE;
#line 1307 "rygel-media-query-action.c"
	} else {
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp5_ = _data_->self->object_id;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_debug ("rygel-media-query-action.vala:172: searching for object '%s'..", _data_->_tmp5_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp6_ = _data_->self->root_container;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp7_ = _data_->self->object_id;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_state_ = 1;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_media_container_find_object (_data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_, rygel_media_query_action_fetch_media_object_ready, _data_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return FALSE;
#line 1327 "rygel-media-query-action.c"
		_state_1:
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp10_ = NULL;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp10_ = rygel_media_container_find_object_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->media_object = _data_->_tmp10_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_data_->_inner_error_ != NULL) {
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_error_free (_data_->_inner_error_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			if (_data_->_state_ == 0) {
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1345 "rygel-media-query-action.c"
			} else {
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1349 "rygel-media-query-action.c"
			}
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_object_unref (_data_->_async_result);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			return FALSE;
#line 1355 "rygel-media-query-action.c"
		}
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp11_ = _data_->media_object;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_data_->_tmp11_ == NULL) {
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->_tmp12_ = NULL;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->_tmp12_ = _ ("No such object");
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp12_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_data_->_inner_error_ = _data_->_tmp13_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_error_free (_data_->_inner_error_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			_g_object_unref0 (_data_->media_object);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			if (_data_->_state_ == 0) {
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1379 "rygel-media-query-action.c"
			} else {
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1383 "rygel-media-query-action.c"
			}
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_object_unref (_data_->_async_result);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			return FALSE;
#line 1389 "rygel-media-query-action.c"
		}
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->_tmp14_ = _data_->self->object_id;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_debug ("rygel-media-query-action.vala:179: object '%s' found.", _data_->_tmp14_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_data_->result = _data_->media_object;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		if (_data_->_state_ == 0) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1401 "rygel-media-query-action.c"
		} else {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1405 "rygel-media-query-action.c"
		}
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_object_unref (_data_->_async_result);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		return FALSE;
#line 1411 "rygel-media-query-action.c"
	}
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_data_->_state_ == 0) {
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1417 "rygel-media-query-action.c"
	} else {
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1421 "rygel-media-query-action.c"
	}
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_object_unref (_data_->_async_result);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	return FALSE;
#line 1427 "rygel-media-query-action.c"
}


static void rygel_media_query_action_conclude (RygelMediaQueryAction* self) {
	GUPnPDIDLLiteWriter* _tmp0_;
	const gchar* _tmp1_;
	GUPnPDIDLLiteWriter* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* didl;
	guint _tmp4_;
	guint32 _tmp5_;
	GUPnPServiceAction* _tmp7_;
	const gchar* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	GUPnPServiceAction* _tmp12_;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = self->didl_writer;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp1_ = self->filter;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	gupnp_didl_lite_writer_filter (_tmp0_, _tmp1_);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp2_ = self->didl_writer;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp3_ = gupnp_didl_lite_writer_get_string (_tmp2_);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	didl = _tmp3_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp4_ = self->update_id;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp5_ = G_MAXUINT32;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_tmp4_ == ((guint) _tmp5_)) {
#line 1465 "rygel-media-query-action.c"
		guint32 _tmp6_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp6_ = self->system_update_id;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		self->update_id = (guint) _tmp6_;
#line 1471 "rygel-media-query-action.c"
	}
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp7_ = self->action;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp8_ = didl;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp9_ = self->number_returned;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp10_ = self->total_matches;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp11_ = self->update_id;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	gupnp_service_action_set (_tmp7_, "Result", G_TYPE_STRING, _tmp8_, "NumberReturned", G_TYPE_UINT, _tmp9_, "TotalMatches", G_TYPE_UINT, _tmp10_, "UpdateID", G_TYPE_UINT, _tmp11_, NULL);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp12_ = self->action;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	gupnp_service_action_return (_tmp12_);
#line 211 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_free0 (didl);
#line 1493 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_handle_error (RygelMediaQueryAction* self, GError* _error_) {
	GError* _tmp0_;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = _error_;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 1503 "rygel-media-query-action.c"
		GUPnPServiceAction* _tmp1_;
		GError* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp1_ = self->action;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp2_ = _error_;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp3_ = _tmp2_->code;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp4_ = _error_;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp5_ = _tmp4_->message;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		gupnp_service_action_return_error (_tmp1_, (guint) _tmp3_, _tmp5_);
#line 1521 "rygel-media-query-action.c"
	} else {
		GUPnPServiceAction* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp6_ = self->action;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp7_ = _error_;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		_tmp8_ = _tmp7_->message;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 701, _tmp8_);
#line 1534 "rygel-media-query-action.c"
	}
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1538 "rygel-media-query-action.c"
}


void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_) {
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_GET_CLASS (self)->handle_error (self, _error_);
#line 1547 "rygel-media-query-action.c"
}


static GCancellable* rygel_media_query_action_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) base;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = self->priv->_cancellable;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	result = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	return result;
#line 1563 "rygel-media-query-action.c"
}


static void rygel_media_query_action_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaQueryAction* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self = (RygelMediaQueryAction*) base;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp0_ = value;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->priv->_cancellable = _tmp1_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 1583 "rygel-media-query-action.c"
}


static void rygel_media_query_action_class_init (RygelMediaQueryActionClass * klass) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	rygel_media_query_action_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaQueryActionPrivate));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->parse_args = rygel_media_query_action_real_parse_args;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	RYGEL_MEDIA_QUERY_ACTION_CLASS (klass)->handle_error = rygel_media_query_action_real_handle_error;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_query_action_get_property;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_query_action_set_property;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_query_action_finalize;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE, "cancellable");
#line 1604 "rygel-media-query-action.c"
}


static void rygel_media_query_action_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	rygel_media_query_action_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_query_action_real_run;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	iface->run_finish = rygel_media_query_action_real_run_finish;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	iface->get_cancellable = rygel_media_query_action_real_get_cancellable;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	iface->set_cancellable = rygel_media_query_action_real_set_cancellable;
#line 1619 "rygel-media-query-action.c"
}


static void rygel_media_query_action_instance_init (RygelMediaQueryAction * self) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self->priv = RYGEL_MEDIA_QUERY_ACTION_GET_PRIVATE (self);
#line 1626 "rygel-media-query-action.c"
}


static void rygel_media_query_action_finalize (GObject* obj) {
	RygelMediaQueryAction * self;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	self = RYGEL_MEDIA_QUERY_ACTION (obj);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_free0 (self->object_id);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_free0 (self->browse_flag);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_free0 (self->filter);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_free0 (self->sort_criteria);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->root_container);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->http_server);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->didl_writer);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_object_unref0 (self->xbox_hacks);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	_g_free0 (self->object_id_arg);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	G_OBJECT_CLASS (rygel_media_query_action_parent_class)->finalize (obj);
#line 1656 "rygel-media-query-action.c"
}


/**
 * Base class of Browse and Search actions.
 */
GType rygel_media_query_action_get_type (void) {
	static volatile gsize rygel_media_query_action_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_query_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaQueryActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_query_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaQueryAction), 0, (GInstanceInitFunc) rygel_media_query_action_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_query_action_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_query_action_type_id;
		rygel_media_query_action_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaQueryAction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_media_query_action_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_query_action_type_id__volatile, rygel_media_query_action_type_id);
	}
	return rygel_media_query_action_type_id__volatile;
}


static void _vala_rygel_media_query_action_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = RYGEL_MEDIA_QUERY_ACTION (object);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		break;
#line 1688 "rygel-media-query-action.c"
		default:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		break;
#line 1694 "rygel-media-query-action.c"
	}
}


static void _vala_rygel_media_query_action_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaQueryAction * self;
	self = RYGEL_MEDIA_QUERY_ACTION (object);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		case RYGEL_MEDIA_QUERY_ACTION_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		break;
#line 1710 "rygel-media-query-action.c"
		default:
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-media-query-action.vala"
		break;
#line 1716 "rygel-media-query-action.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



