/* rygel-http-server.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-http-server.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelHttpServerRunData RygelHttpServerRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelHTTPServerPrivate {
	gchar* _path_root;
	GeeArrayList* requests;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelHttpServerRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPServer* self;
	GUPnPContext* _tmp0_;
	SoupServer* _tmp1_;
	SoupServer* _tmp2_;
	const gchar* _tmp3_;
	GUPnPContext* _tmp4_;
	SoupServer* _tmp5_;
	SoupServer* _tmp6_;
	GUPnPContext* _tmp7_;
	SoupServer* _tmp8_;
	SoupServer* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	GCancellable* _tmp12_;
	GCancellable* _tmp13_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_http_server_parent_class = NULL;
static RygelStateMachineIface* rygel_http_server_rygel_state_machine_parent_iface = NULL;

GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_CANCELLABLE
};
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name);
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value);
static void rygel_http_server_real_run_data_free (gpointer _data);
static void rygel_http_server_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* _data_);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_server_handler (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* server_path, GHashTable* query, SoupClientContext* soup_client);
static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_server_on_cancelled (RygelHTTPServer* self, GCancellable* cancellable);
static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static gboolean rygel_http_server_http_uri_present (RygelHTTPServer* self, RygelMediaItem* item);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
static gchar* rygel_http_server_real_create_uri_for_item (RygelTranscodeManager* base, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_server_real_get_protocol (RygelTranscodeManager* base);
static GeeArrayList* rygel_http_server_real_get_protocol_info (RygelTranscodeManager* base);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static void rygel_http_server_on_request_completed (RygelHTTPServer* self, RygelStateMachine* machine);
static void __lambda1_ (RygelHTTPServer* self, const gchar* name, const gchar* value);
static void ___lambda1__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self);
static void rygel_http_server_queue_request (RygelHTTPServer* self, RygelHTTPRequest* request);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg);
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self);
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_post_get_type (void) G_GNUC_CONST;
static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return self ? g_object_ref (self) : NULL;
#line 337 "rygel-http-server.c"
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name) {
	RygelHTTPServer * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelContentDirectory* _tmp3_;
	GUPnPContext* _tmp4_;
	GUPnPContext* _tmp5_;
	GUPnPContext* _tmp6_;
	GeeArrayList* _tmp7_;
	RygelContentDirectory* _tmp8_;
	GCancellable* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self = (RygelHTTPServer*) rygel_transcode_manager_construct (object_type);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = content_dir;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = _tmp0_->root_container;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (self->root_container);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self->root_container = _tmp2_;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = content_dir;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp4_ = gupnp_service_info_get_context ((GUPnPServiceInfo*) _tmp3_);
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp5_ = _tmp4_;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (self->context);
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self->context = _tmp6_;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp7_ = gee_array_list_new (RYGEL_TYPE_HTTP_REQUEST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (self->priv->requests);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self->priv->requests = _tmp7_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp8_ = content_dir;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp9_ = _tmp8_->cancellable;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp9_);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp10_ = name;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp11_ = g_strconcat ("/", _tmp10_, NULL);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp12_ = _tmp11_;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_set_path_root (self, _tmp12_);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp12_);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return self;
#line 408 "rygel-http-server.c"
}


RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name) {
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, content_dir, name);
#line 415 "rygel-http-server.c"
}


static void rygel_http_server_real_run_data_free (gpointer _data) {
	RygelHttpServerRunData* _data_;
	_data_ = _data;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (_data_->self);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_slice_free (RygelHttpServerRunData, _data_);
#line 426 "rygel-http-server.c"
}


static void rygel_http_server_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPServer * self;
	RygelHttpServerRunData* _data_;
	RygelHTTPServer* _tmp0_;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_ = g_slice_new0 (RygelHttpServerRunData);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_server_real_run);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_server_real_run_data_free);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->self = _tmp0_;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_real_run_co (_data_);
#line 448 "rygel-http-server.c"
}


static void rygel_http_server_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpServerRunData* _data_;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 456 "rygel-http-server.c"
}


static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_server_handler (self, server, msg, path, query, client);
#line 463 "rygel-http-server.c"
}


static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_on_request_aborted (self, _sender, msg, client);
#line 470 "rygel-http-server.c"
}


static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_on_request_started (self, _sender, msg, client);
#line 477 "rygel-http-server.c"
}


static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_on_cancelled (self, _sender);
#line 484 "rygel-http-server.c"
}


static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* _data_) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	switch (_data_->_state_) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		case 0:
#line 493 "rygel-http-server.c"
		goto _state_0;
		default:
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		g_assert_not_reached ();
#line 498 "rygel-http-server.c"
	}
	_state_0:
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp0_ = _data_->self->context;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp1_ = gupnp_context_get_server (_data_->_tmp0_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp3_ = _data_->self->priv->_path_root;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	soup_server_add_handler (_data_->_tmp2_, _data_->_tmp3_, _rygel_http_server_server_handler_soup_server_callback, g_object_ref (_data_->self), g_object_unref);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp4_ = _data_->self->context;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp5_ = gupnp_context_get_server (_data_->_tmp4_);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_signal_connect_object (_data_->_tmp6_, "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, _data_->self, 0);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp7_ = _data_->self->context;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp8_ = gupnp_context_get_server (_data_->_tmp7_);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_signal_connect_object (_data_->_tmp9_, "request-started", (GCallback) _rygel_http_server_on_request_started_soup_server_request_started, _data_->self, 0);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	if (_data_->_tmp11_ != NULL) {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_data_->_tmp12_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		g_signal_connect_object (_data_->_tmp13_, "cancelled", (GCallback) _rygel_http_server_on_cancelled_g_cancellable_cancelled, _data_->self, 0);
#line 539 "rygel-http-server.c"
	}
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	if (_data_->_state_ == 0) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 545 "rygel-http-server.c"
	} else {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 549 "rygel-http-server.c"
	}
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_unref (_data_->_async_result);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return FALSE;
#line 555 "rygel-http-server.c"
}


void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
	RygelMediaItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaItem* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* uri;
	RygelMediaItem* _tmp4_;
	GUPnPDIDLLiteItem* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GUPnPDIDLLiteResource* _tmp10_ = NULL;
	GUPnPDIDLLiteResource* _tmp11_;
	GError * _inner_error_ = NULL;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (didl_item != NULL);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (item != NULL);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = item;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = rygel_http_server_http_uri_present (self, _tmp0_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	if (_tmp1_) {
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		return;
#line 588 "rygel-http-server.c"
	}
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = item;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) self, _tmp2_, -1, -1, NULL);
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	uri = _tmp3_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp4_ = item;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp5_ = didl_item;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp6_ = uri;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp7_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp8_ = _tmp7_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp9_ = uri;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp10_ = rygel_media_item_add_resource (_tmp4_, _tmp5_, _tmp6_, _tmp8_, _tmp9_, &_inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp11_ = _tmp10_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (_tmp11_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp8_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	if (_inner_error_ != NULL) {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		g_propagate_error (error, _inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_g_free0 (uri);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		return;
#line 624 "rygel-http-server.c"
	}
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (uri);
#line 628 "rygel-http-server.c"
}


gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = uri;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = g_uri_parse_scheme (_tmp0_);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = _tmp1_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, "http") != 0;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp2_);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	result = _tmp3_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return result;
#line 656 "rygel-http-server.c"
}


static gboolean rygel_http_server_http_uri_present (RygelHTTPServer* self, RygelMediaItem* item) {
	gboolean result = FALSE;
	gboolean present;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	present = FALSE;
#line 669 "rygel-http-server.c"
	{
		RygelMediaItem* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _uri_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _uri_size;
		gint _uri_index;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp0_ = item;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp1_ = ((RygelMediaObject*) _tmp0_)->uris;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_uri_list = _tmp2_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp3_ = _uri_list;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp5_ = _tmp4_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_uri_size = _tmp5_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_uri_index = -1;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		while (TRUE) {
#line 700 "rygel-http-server.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* uri;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp6_ = _uri_index;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_uri_index = _tmp6_ + 1;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp7_ = _uri_index;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp8_ = _uri_size;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				break;
#line 722 "rygel-http-server.c"
			}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp9_ = _uri_list;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp10_ = _uri_index;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			uri = (gchar*) _tmp11_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp12_ = uri;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp13_ = rygel_http_server_need_proxy (self, _tmp12_);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			if (!_tmp13_) {
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				present = TRUE;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_g_free0 (uri);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				break;
#line 744 "rygel-http-server.c"
			}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_g_free0 (uri);
#line 748 "rygel-http-server.c"
		}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_g_object_unref0 (_uri_list);
#line 752 "rygel-http-server.c"
	}
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	result = present;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return result;
#line 758 "rygel-http-server.c"
}


static void rygel_http_server_on_cancelled (RygelHTTPServer* self, GCancellable* cancellable) {
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GUPnPContext* _tmp2_;
	SoupServer* _tmp3_;
	SoupServer* _tmp4_;
	const gchar* _tmp5_;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (cancellable != NULL);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = _tmp0_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_cancellable_cancel (_tmp1_);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = self->context;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = gupnp_context_get_server (_tmp2_);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp4_ = _tmp3_;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp5_ = self->priv->_path_root;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	soup_server_remove_handler (_tmp4_, _tmp5_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 791 "rygel-http-server.c"
}


static gchar* rygel_http_server_real_create_uri_for_item (RygelTranscodeManager* base, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPServer * self;
	gchar* result = NULL;
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	RygelHTTPItemURI* _tmp5_;
	RygelHTTPItemURI* uri;
	gchar* _tmp6_ = NULL;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = item;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = thumbnail_index;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = subtitle_index;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp4_ = transcode_target;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp5_ = rygel_http_item_uri_new (_tmp1_, self, _tmp2_, _tmp3_, _tmp4_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	uri = _tmp5_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp6_ = rygel_http_item_uri_to_string (uri);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	result = _tmp6_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (uri);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return result;
#line 832 "rygel-http-server.c"
}


static gchar* rygel_http_server_real_get_protocol (RygelTranscodeManager* base) {
	RygelHTTPServer * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = g_strdup ("http-get");
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	result = _tmp0_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return result;
#line 848 "rygel-http-server.c"
}


static GeeArrayList* rygel_http_server_real_get_protocol_info (RygelTranscodeManager* base) {
	RygelHTTPServer * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* protocol_infos;
	GUPnPProtocolInfo* _tmp1_;
	GUPnPProtocolInfo* protocol_info;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = RYGEL_TRANSCODE_MANAGER_CLASS (rygel_http_server_parent_class)->get_protocol_info (RYGEL_TRANSCODE_MANAGER (self));
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	protocol_infos = _tmp0_;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = gupnp_protocol_info_new ();
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	protocol_info = _tmp1_;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = _tmp2_;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	gupnp_protocol_info_set_protocol (protocol_info, _tmp3_);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp3_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	gupnp_protocol_info_set_mime_type (protocol_info, "*");
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) protocol_infos, protocol_info);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	result = protocol_infos;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (protocol_info);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return result;
#line 889 "rygel-http-server.c"
}


static void rygel_http_server_on_request_completed (RygelHTTPServer* self, RygelStateMachine* machine) {
	RygelStateMachine* _tmp0_;
	RygelHTTPRequest* _tmp1_;
	RygelHTTPRequest* request;
	GeeArrayList* _tmp2_;
	SoupMessage* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SoupMessage* _tmp7_;
	SoupURI* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (machine != NULL);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = machine;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = _g_object_ref0 (RYGEL_IS_HTTP_REQUEST (_tmp0_) ? ((RygelHTTPRequest*) _tmp0_) : NULL);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	request = _tmp1_;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = self->priv->requests;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp2_, request);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = request->msg;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_get (_tmp3_, "method", &_tmp4_, NULL);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp5_ = _tmp4_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp6_ = _tmp5_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp7_ = request->msg;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp8_ = soup_message_get_uri (_tmp7_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp9_ = soup_uri_to_string (_tmp8_, FALSE);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp10_ = _tmp9_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:133: HTTP %s request for URI '%s' handled.", _tmp6_, _tmp10_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp10_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp6_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (request);
#line 944 "rygel-http-server.c"
}


static void __lambda1_ (RygelHTTPServer* self, const gchar* name, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (name != NULL);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (value != NULL);
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = name;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = value;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:152: %s : %s", _tmp0_, _tmp1_);
#line 961 "rygel-http-server.c"
}


static void ___lambda1__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self) {
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	__lambda1_ (self, name, value);
#line 968 "rygel-http-server.c"
}


static void rygel_http_server_server_handler (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* server_path, GHashTable* query, SoupClientContext* soup_client) {
	SoupMessage* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	SoupMessage* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	SoupMessage* _tmp9_;
	SoupURI* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	SoupMessage* _tmp13_;
	SoupMessageHeaders* _tmp14_;
	SoupServer* _tmp15_;
	SoupMessage* _tmp16_;
	RygelHTTPGet* _tmp17_;
	RygelHTTPGet* _tmp18_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (msg != NULL);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (server_path != NULL);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (soup_client != NULL);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = msg;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_get (_tmp0_, "method", &_tmp1_, NULL);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = _tmp1_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = _tmp2_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp4_ = g_strcmp0 (_tmp3_, "POST") == 0;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp3_);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	if (_tmp4_) {
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		return;
#line 1018 "rygel-http-server.c"
	}
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp5_ = msg;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_get (_tmp5_, "method", &_tmp6_, NULL);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp7_ = _tmp6_;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp8_ = _tmp7_;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp9_ = msg;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp10_ = soup_message_get_uri (_tmp9_);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp11_ = soup_uri_to_string (_tmp10_, FALSE);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp12_ = _tmp11_;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:148: HTTP %s request for URI '%s'. Headers:", _tmp8_, _tmp12_);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp12_);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp8_);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp13_ = msg;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp14_ = _tmp13_->request_headers;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	soup_message_headers_foreach (_tmp14_, ___lambda1__soup_message_headers_foreach_func, self);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp15_ = server;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp16_ = msg;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp17_ = rygel_http_get_new (self, _tmp15_, _tmp16_);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp18_ = _tmp17_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_queue_request (self, (RygelHTTPRequest*) _tmp18_);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (_tmp18_);
#line 1060 "rygel-http-server.c"
}


static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (message != NULL);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (client != NULL);
#line 1073 "rygel-http-server.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _request_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _request_size;
		gint _request_index;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp0_ = self->priv->requests;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_request_list = _tmp1_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp2_ = _request_list;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp4_ = _tmp3_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_request_size = _tmp4_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_request_index = -1;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		while (TRUE) {
#line 1101 "rygel-http-server.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelHTTPRequest* request;
			RygelHTTPRequest* _tmp11_;
			SoupMessage* _tmp12_;
			SoupMessage* _tmp13_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp5_ = _request_index;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_request_index = _tmp5_ + 1;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp6_ = _request_index;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp7_ = _request_size;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				break;
#line 1124 "rygel-http-server.c"
			}
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp8_ = _request_list;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp9_ = _request_index;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			request = (RygelHTTPRequest*) _tmp10_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp11_ = request;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp12_ = _tmp11_->msg;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_tmp13_ = message;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			if (_tmp12_ == _tmp13_) {
#line 1142 "rygel-http-server.c"
				RygelHTTPRequest* _tmp14_;
				GCancellable* _tmp15_;
				GCancellable* _tmp16_;
				RygelHTTPRequest* _tmp17_;
				SoupMessage* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* _tmp21_;
				RygelHTTPRequest* _tmp22_;
				SoupMessage* _tmp23_;
				SoupURI* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp14_ = request;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp15_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp14_);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp16_ = _tmp15_;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				g_cancellable_cancel (_tmp16_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp17_ = request;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp18_ = _tmp17_->msg;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				g_object_get (_tmp18_, "method", &_tmp19_, NULL);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp20_ = _tmp19_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp21_ = _tmp20_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp22_ = request;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp23_ = _tmp22_->msg;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp24_ = soup_message_get_uri (_tmp23_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp25_ = soup_uri_to_string (_tmp24_, FALSE);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_tmp26_ = _tmp25_;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				g_debug ("rygel-http-server.vala:164: HTTP client aborted %s request for URI '%s" \
"'.", _tmp21_, _tmp26_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_g_free0 (_tmp26_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_g_free0 (_tmp21_);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				_g_object_unref0 (request);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
				break;
#line 1194 "rygel-http-server.c"
			}
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
			_g_object_unref0 (request);
#line 1198 "rygel-http-server.c"
		}
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_g_object_unref0 (_request_list);
#line 1202 "rygel-http-server.c"
	}
}


static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_on_got_headers (self, _sender);
#line 1210 "rygel-http-server.c"
}


static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
	SoupMessage* _tmp0_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (message != NULL);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (client != NULL);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = message;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_signal_connect_object (_tmp0_, "got-headers", (GCallback) _rygel_http_server_on_got_headers_soup_message_got_headers, self, 0);
#line 1228 "rygel-http-server.c"
}


static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg) {
	gboolean _tmp0_ = FALSE;
	SoupMessage* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp12_;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (msg != NULL);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = msg;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_get (_tmp1_, "method", &_tmp2_, NULL);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = _tmp2_;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp4_ = _tmp3_;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp5_ = g_strcmp0 (_tmp4_, "POST") == 0;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (_tmp4_);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	if (_tmp5_) {
#line 1258 "rygel-http-server.c"
		SoupMessage* _tmp6_;
		SoupURI* _tmp7_;
		SoupURI* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp6_ = msg;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp7_ = soup_message_get_uri (_tmp6_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp8_ = _tmp7_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp9_ = _tmp8_->path;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp10_ = self->priv->_path_root;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp11_ = g_str_has_prefix (_tmp9_, _tmp10_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp0_ = _tmp11_;
#line 1279 "rygel-http-server.c"
	} else {
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp0_ = FALSE;
#line 1283 "rygel-http-server.c"
	}
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp12_ = _tmp0_;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	if (_tmp12_) {
#line 1289 "rygel-http-server.c"
		SoupMessage* _tmp13_;
		SoupURI* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GUPnPContext* _tmp17_;
		SoupServer* _tmp18_;
		SoupServer* _tmp19_;
		SoupMessage* _tmp20_;
		RygelHTTPPost* _tmp21_;
		RygelHTTPPost* _tmp22_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp13_ = msg;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp14_ = soup_message_get_uri (_tmp13_);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp15_ = soup_uri_to_string (_tmp14_, FALSE);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp16_ = _tmp15_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		g_debug ("rygel-http-server.vala:182: HTTP POST request for URI '%s'", _tmp16_);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_g_free0 (_tmp16_);
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp17_ = self->context;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp18_ = gupnp_context_get_server (_tmp17_);
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp19_ = _tmp18_;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp20_ = msg;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp21_ = rygel_http_post_new (self, _tmp19_, _tmp20_);
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_tmp22_ = _tmp21_;
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		rygel_http_server_queue_request (self, (RygelHTTPRequest*) _tmp22_);
#line 185 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		_g_object_unref0 (_tmp22_);
#line 1328 "rygel-http-server.c"
	}
}


static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_on_request_completed (self, _sender);
#line 1336 "rygel-http-server.c"
}


static void rygel_http_server_queue_request (RygelHTTPServer* self, RygelHTTPRequest* request) {
	RygelHTTPRequest* _tmp0_;
	GeeArrayList* _tmp1_;
	RygelHTTPRequest* _tmp2_;
	RygelHTTPRequest* _tmp3_;
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (request != NULL);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = request;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp0_, "completed", (GCallback) _rygel_http_server_on_request_completed_rygel_state_machine_completed, self, 0);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = self->priv->requests;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp2_ = request;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp3_ = request;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp3_, NULL, NULL);
#line 1363 "rygel-http-server.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = self->priv->_path_root;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	result = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return result;
#line 1378 "rygel-http-server.c"
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = value;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (self->priv->_path_root);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self->priv->_path_root = _tmp1_;
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_notify ((GObject *) self, "path-root");
#line 1397 "rygel-http-server.c"
}


static GCancellable* rygel_http_server_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPServer* self;
	GCancellable* _tmp0_;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = self->priv->_cancellable;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	result = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	return result;
#line 1413 "rygel-http-server.c"
}


static void rygel_http_server_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPServer* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self = (RygelHTTPServer*) base;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp0_ = value;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self->priv->_cancellable = _tmp1_;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 1433 "rygel-http-server.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->create_uri_for_item = rygel_http_server_real_create_uri_for_item;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol = rygel_http_server_real_get_protocol;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol_info = rygel_http_server_real_get_protocol_info;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_server_set_property;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_CANCELLABLE, "cancellable");
#line 1458 "rygel-http-server.c"
}


static void rygel_http_server_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	rygel_http_server_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_server_real_run;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	iface->run_finish = rygel_http_server_real_run_finish;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	iface->get_cancellable = rygel_http_server_real_get_cancellable;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	iface->set_cancellable = rygel_http_server_real_set_cancellable;
#line 1473 "rygel-http-server.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
#line 1480 "rygel-http-server.c"
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	self = RYGEL_HTTP_SERVER (obj);
#line 29 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_free0 (self->priv->_path_root);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (self->root_container);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (self->context);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (self->priv->requests);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 1500 "rygel-http-server.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_server_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODE_MANAGER, "RygelHTTPServer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_server_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		case RYGEL_HTTP_SERVER_CANCELLABLE:
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		break;
#line 1535 "rygel-http-server.c"
		default:
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		break;
#line 1541 "rygel-http-server.c"
	}
}


static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		rygel_http_server_set_path_root (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		break;
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		case RYGEL_HTTP_SERVER_CANCELLABLE:
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		break;
#line 1563 "rygel-http-server.c"
		default:
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/src/rygel/rygel-http-server.vala"
		break;
#line 1569 "rygel-http-server.c"
	}
}



