/* rygel-external-container.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-external-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_EXTERNAL_TYPE_CONTAINER (rygel_external_container_get_type ())
#define RYGEL_EXTERNAL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainer))
#define RYGEL_EXTERNAL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))
#define RYGEL_EXTERNAL_IS_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_IS_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_CONTAINER))
#define RYGEL_EXTERNAL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerClass))

typedef struct _RygelExternalContainer RygelExternalContainer;
typedef struct _RygelExternalContainerClass RygelExternalContainerClass;
typedef struct _RygelExternalContainerPrivate RygelExternalContainerPrivate;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY (rygel_external_media_object_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_OBJECT_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY))
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY, RygelExternalMediaObjectProxyIface))

typedef struct _RygelExternalMediaObjectProxy RygelExternalMediaObjectProxy;
typedef struct _RygelExternalMediaObjectProxyIface RygelExternalMediaObjectProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY (rygel_external_media_object_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY (rygel_external_media_container_proxy_get_type ())
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxy))
#define RYGEL_EXTERNAL_IS_MEDIA_CONTAINER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY))
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY, RygelExternalMediaContainerProxyIface))

typedef struct _RygelExternalMediaContainerProxy RygelExternalMediaContainerProxy;
typedef struct _RygelExternalMediaContainerProxyIface RygelExternalMediaContainerProxyIface;

#define RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY (rygel_external_media_container_proxy_proxy_get_type ())

#define RYGEL_EXTERNAL_TYPE_ITEM_FACTORY (rygel_external_item_factory_get_type ())
#define RYGEL_EXTERNAL_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactory))
#define RYGEL_EXTERNAL_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY))
#define RYGEL_EXTERNAL_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ITEM_FACTORY, RygelExternalItemFactoryClass))

typedef struct _RygelExternalItemFactory RygelExternalItemFactory;
typedef struct _RygelExternalItemFactoryClass RygelExternalItemFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_external_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_item_factory_unref (var), NULL)))
typedef struct _RygelExternalContainerGetChildrenData RygelExternalContainerGetChildrenData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelExternalContainerSearchData RygelExternalContainerSearchData;

#define RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER (rygel_external_dummy_container_get_type ())
#define RYGEL_EXTERNAL_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainer))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER))
#define RYGEL_EXTERNAL_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_DUMMY_CONTAINER, RygelExternalDummyContainerClass))

typedef struct _RygelExternalDummyContainer RygelExternalDummyContainer;
typedef struct _RygelExternalDummyContainerClass RygelExternalDummyContainerClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _RygelExternalContainerFindObjectData RygelExternalContainerFindObjectData;
typedef struct _RygelExternalContainerCreateMediaObjectsData RygelExternalContainerCreateMediaObjectsData;
typedef struct _RygelExternalContainerRefreshChildContainersData RygelExternalContainerRefreshChildContainersData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelExternalContainerUpdateContainerData RygelExternalContainerUpdateContainerData;

struct _RygelExternalMediaObjectProxyIface {
	GTypeInterface parent_iface;
	char* (*get_parent) (RygelExternalMediaObjectProxy* self);
	void (*set_parent) (RygelExternalMediaObjectProxy* self, const char* value);
	gchar* (*get_display_name) (RygelExternalMediaObjectProxy* self);
	void (*set_display_name) (RygelExternalMediaObjectProxy* self, const gchar* value);
	gchar* (*get_object_type) (RygelExternalMediaObjectProxy* self);
	void (*set_object_type) (RygelExternalMediaObjectProxy* self, const gchar* value);
};

struct _RygelExternalMediaContainerProxyIface {
	GTypeInterface parent_iface;
	void (*list_children) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_children_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_containers) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_containers_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*list_items) (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*list_items_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*search_objects) (RygelExternalMediaContainerProxy* self, const gchar* query, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*search_objects_finish) (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
	guint (*get_child_count) (RygelExternalMediaContainerProxy* self);
	void (*set_child_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_item_count) (RygelExternalMediaContainerProxy* self);
	void (*set_item_count) (RygelExternalMediaContainerProxy* self, guint value);
	guint (*get_container_count) (RygelExternalMediaContainerProxy* self);
	void (*set_container_count) (RygelExternalMediaContainerProxy* self, guint value);
	gboolean (*get_searchable) (RygelExternalMediaContainerProxy* self);
	void (*set_searchable) (RygelExternalMediaContainerProxy* self, gboolean value);
	char* (*get_icon) (RygelExternalMediaContainerProxy* self);
	void (*set_icon) (RygelExternalMediaContainerProxy* self, const char* value);
};

struct _RygelExternalContainer {
	RygelMediaContainer parent_instance;
	RygelExternalContainerPrivate * priv;
	RygelExternalMediaContainerProxy* actual_container;
	gchar* service_name;
};

struct _RygelExternalContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelExternalContainerPrivate {
	RygelExternalItemFactory* item_factory;
	GeeArrayList* containers;
	GeeArrayList* _search_classes;
	gboolean searchable;
};

struct _RygelExternalContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gchar** _tmp0_;
	gchar** filter;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar** item_prop_collection;
	gint item_prop_collection_length1;
	gint _item_prop_collection_size_;
	gint item_prop_it;
	const gchar* item_prop;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	RygelExternalMediaContainerProxy* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	GHashTable** _tmp12_;
	GHashTable** children_props;
	gint children_props_length1;
	gint _children_props_size_;
	GHashTable** _tmp13_;
	gint _tmp13__length1;
	RygelMediaObjects* _tmp14_;
	RygelMediaObjects* _tmp15_;
	GError * _inner_error_;
};

struct _RygelExternalContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gboolean _tmp0_;
	RygelSearchExpression* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	RygelSearchExpression* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GCancellable* _tmp7_;
	guint _tmp8_;
	RygelMediaObjects* _tmp9_;
	RygelMediaObjects* _tmp10_;
	gchar** _tmp11_;
	gchar** filter;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar** container_prop_collection;
	gint container_prop_collection_length1;
	gint _container_prop_collection_size_;
	gint container_prop_it;
	const gchar* container_prop;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar** item_prop_collection;
	gint item_prop_collection_length1;
	gint _item_prop_collection_size_;
	gint item_prop_it;
	const gchar* item_prop;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	RygelSearchExpression* _tmp21_;
	RygelSearchExpression* _tmp22_;
	RygelSearchExpression* ext_expression;
	RygelExternalMediaContainerProxy* _tmp23_;
	RygelSearchExpression* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gint _tmp30_;
	GHashTable** _tmp31_;
	GHashTable** _tmp32_;
	gint _tmp32__length1;
	GHashTable** _result_;
	gint _result__length1;
	gint __result__size_;
	GHashTable** _tmp33_;
	gint _tmp33__length1;
	GHashTable** _tmp34_;
	gint _tmp34__length1;
	RygelMediaObjects* _tmp35_;
	RygelMediaObjects* _tmp36_;
	GError * _inner_error_;
};

struct _RygelExternalContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelExternalMediaObjectProxy* _tmp2_;
	RygelExternalMediaObjectProxy* actual_object;
	RygelExternalMediaObjectProxy* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelMediaObject* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _container_list;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _container_size;
	gint _container_index;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeArrayList* _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_;
	RygelExternalContainer* container;
	RygelExternalContainer* _tmp22_;
	const gchar* _tmp23_;
	GCancellable* _tmp24_;
	RygelMediaObject* _tmp25_;
	RygelMediaObject* _tmp26_;
	RygelMediaObject* _tmp27_;
	RygelExternalMediaObjectProxy* _tmp28_;
	char* _tmp29_;
	char* _tmp30_;
	gchar* _tmp31_;
	RygelExternalDummyContainer* _tmp32_;
	RygelExternalDummyContainer* _tmp33_;
	RygelExternalDummyContainer* parent_container;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	FreeDesktopProperties* _tmp36_;
	FreeDesktopProperties* props_iface;
	FreeDesktopProperties* _tmp37_;
	GHashTable* _tmp38_;
	GHashTable* props;
	RygelExternalItemFactory* _tmp39_;
	const gchar* _tmp40_;
	RygelExternalMediaObjectProxy* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	RygelExternalMediaObjectProxy* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GHashTable* _tmp49_;
	const gchar* _tmp50_;
	RygelExternalDummyContainer* _tmp51_;
	RygelMediaItem* _tmp52_;
	RygelMediaItem* _tmp53_;
	RygelMediaItem* _tmp54_;
	GError * _inner_error_;
};

struct _RygelExternalContainerCreateMediaObjectsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	GHashTable** all_props;
	gint all_props_length1;
	RygelMediaContainer* parent;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* media_objects;
	GHashTable** _tmp1_;
	gint _tmp1__length1;
	GHashTable** props_collection;
	gint props_collection_length1;
	gint _props_collection_size_;
	gint props_it;
	GHashTable* _tmp2_;
	GHashTable* props;
	GHashTable* _tmp3_;
	gconstpointer _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* id;
	GHashTable* _tmp7_;
	gconstpointer _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* type;
	RygelMediaContainer* parent_container;
	RygelMediaContainer* _tmp11_;
	RygelMediaContainer* _tmp12_;
	RygelMediaContainer* _tmp13_;
	GHashTable* _tmp14_;
	gconstpointer _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* parent_id;
	const gchar* _tmp18_;
	RygelExternalDummyContainer* _tmp19_;
	RygelMediaObject* media_object;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	RygelMediaContainer* _tmp22_;
	RygelMediaObject* _tmp23_;
	GHashTable* _tmp24_;
	gconstpointer _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* title;
	const gchar* _tmp28_;
	GHashTable* _tmp29_;
	gconstpointer _tmp30_;
	guint _tmp31_;
	guint child_count;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	guint _tmp34_;
	RygelMediaContainer* _tmp35_;
	RygelExternalDummyContainer* _tmp36_;
	RygelExternalItemFactory* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GHashTable* _tmp41_;
	const gchar* _tmp42_;
	RygelMediaContainer* _tmp43_;
	RygelMediaItem* _tmp44_;
	RygelMediaItem* _tmp45_;
	RygelMediaObjects* _tmp46_;
	RygelMediaObject* _tmp47_;
	GError * _inner_error_;
};

struct _RygelExternalContainerRefreshChildContainersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gchar** _tmp0_;
	gchar** filter;
	gint filter_length1;
	gint _filter_size_;
	const gchar** object_prop_collection;
	gint object_prop_collection_length1;
	gint _object_prop_collection_size_;
	gint object_prop_it;
	const gchar* object_prop;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar** container_prop_collection;
	gint container_prop_collection_length1;
	gint _container_prop_collection_size_;
	gint container_prop_it;
	const gchar* container_prop;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	RygelExternalMediaContainerProxy* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	GHashTable** _tmp10_;
	GHashTable** children_props;
	gint children_props_length1;
	gint _children_props_size_;
	GeeArrayList* _tmp11_;
	GHashTable** _tmp12_;
	gint _tmp12__length1;
	GHashTable** props_collection;
	gint props_collection_length1;
	gint _props_collection_size_;
	gint props_it;
	GHashTable* _tmp13_;
	GHashTable* props;
	GHashTable* _tmp14_;
	gconstpointer _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* path;
	GHashTable* _tmp18_;
	gconstpointer _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* title;
	GHashTable* _tmp22_;
	gconstpointer _tmp23_;
	guint _tmp24_;
	guint child_count;
	GHashTable* _tmp25_;
	gconstpointer _tmp26_;
	gboolean _tmp27_;
	gboolean searchable;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	guint _tmp30_;
	gboolean _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	RygelExternalContainer* _tmp34_;
	RygelExternalContainer* container;
	GeeArrayList* _tmp35_;
	RygelExternalContainer* _tmp36_;
	GError * _inner_error_;
};

struct _RygelExternalContainerUpdateContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalContainer* self;
	gboolean connect_signal;
	GError* err;
	RygelExternalMediaContainerProxy* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	RygelExternalMediaContainerProxy* _tmp5_;
	GError * _inner_error_;
};


static gpointer rygel_external_container_parent_class = NULL;
static RygelSearchableContainerIface* rygel_external_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_external_container_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_get_type (void) G_GNUC_CONST;
GType rygel_external_media_object_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_object_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_external_media_container_proxy_proxy_get_type (void) G_GNUC_CONST;
guint rygel_external_media_container_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_external_media_container_proxy_get_type (void) G_GNUC_CONST;
gpointer rygel_external_item_factory_ref (gpointer instance);
void rygel_external_item_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_item_factory (const GValue* value);
GType rygel_external_item_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_EXTERNAL_TYPE_CONTAINER, RygelExternalContainerPrivate))
enum  {
	RYGEL_EXTERNAL_CONTAINER_DUMMY_PROPERTY,
	RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES
};
RygelExternalContainer* rygel_external_container_new (const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error);
RygelExternalContainer* rygel_external_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error);
RygelExternalItemFactory* rygel_external_item_factory_new (void);
RygelExternalItemFactory* rygel_external_item_factory_construct (GType object_type);
static void rygel_external_container_update_container (RygelExternalContainer* self, gboolean connect_signal, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_update_container_finish (RygelExternalContainer* self, GAsyncResult* _res_);
static void rygel_external_container_real_get_children_data_free (gpointer _data);
static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* _data_);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
void rygel_external_media_container_proxy_list_children (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_children_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_create_media_objects (RygelExternalContainer* self, GHashTable** all_props, int all_props_length1, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_external_container_real_search_data_free (gpointer _data);
static void rygel_external_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* _data_);
static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self, RygelSearchExpression* upnp_expression);
void rygel_external_media_container_proxy_search_objects (RygelExternalMediaContainerProxy* self, const gchar* query, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_search_objects_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_real_find_object_data_free (gpointer _data);
static void rygel_external_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* _data_);
static void rygel_external_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_external_media_object_proxy_get_object_type (RygelExternalMediaObjectProxy* self);
static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self, const gchar* id);
char* rygel_external_media_object_proxy_get_parent (RygelExternalMediaObjectProxy* self);
RygelExternalDummyContainer* rygel_external_dummy_container_new (const gchar* id, const gchar* title, guint child_count, RygelMediaContainer* parent);
RygelExternalDummyContainer* rygel_external_dummy_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, RygelMediaContainer* parent);
GType rygel_external_dummy_container_get_type (void) G_GNUC_CONST;
#define RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE "org.gnome.UPnP.MediaItem2"
void rygel_external_item_factory_create (RygelExternalItemFactory* self, const gchar* id, const gchar* type, const gchar* title, GHashTable* props, const gchar* service_name, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaItem* rygel_external_item_factory_create_finish (RygelExternalItemFactory* self, GAsyncResult* _res_, GError** error);
gchar* rygel_external_media_object_proxy_get_display_name (RygelExternalMediaObjectProxy* self);
static void rygel_external_container_create_media_objects_data_free (gpointer _data);
static GHashTable** _vala_array_dup1 (GHashTable** self, int length);
static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* _data_);
static const gchar* _variant_get1 (GVariant* value);
static const gchar* _variant_get2 (GVariant* value);
static const gchar* _variant_get3 (GVariant* value);
static const gchar* _variant_get4 (GVariant* value);
static guint _variant_get5 (GVariant* value);
static void rygel_external_container_create_media_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_data_free (gpointer _data);
static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* _data_);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
void rygel_external_media_container_proxy_list_containers (RygelExternalMediaContainerProxy* self, guint offset, guint max_count, gchar** filter, int filter_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** rygel_external_media_container_proxy_list_containers_finish (RygelExternalMediaContainerProxy* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_external_container_refresh_child_containers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static const gchar* _variant_get6 (GVariant* value);
static const gchar* _variant_get7 (GVariant* value);
static guint _variant_get8 (GVariant* value);
static gboolean _variant_get9 (GVariant* value);
static void rygel_external_container_update_container_data_free (gpointer _data);
static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* _data_);
static void rygel_external_container_update_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainerProxy* actual_container);
static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender, gpointer self);
gchar* rygel_external_container_translate_property (RygelExternalContainer* self, const gchar* property);
static void rygel_external_container_finalize (GObject* obj);
static void _vala_rygel_external_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_external_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const gchar* RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES[4];
extern const gchar* RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES[19];
extern const gchar* RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES[2];

RygelExternalContainer* rygel_external_container_construct (GType object_type, const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error) {
	RygelExternalContainer * self = NULL;
	const gchar* _tmp0_;
	RygelExternalContainer* _tmp1_;
	const gchar* _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	RygelExternalItemFactory* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	RygelExternalMediaContainerProxy* _tmp12_ = NULL;
	RygelExternalMediaContainerProxy* _tmp13_;
	GError * _inner_error_ = NULL;
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (service_name != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = id;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = parent;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = title;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = child_count;
#line 51 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) rygel_media_container_construct (object_type, _tmp0_, (RygelMediaContainer*) _tmp1_, _tmp2_, (gint) _tmp3_);
#line 53 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = service_name;
#line 53 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 53 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (self->service_name);
#line 53 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->service_name = _tmp5_;
#line 54 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp6_ = rygel_external_item_factory_new ();
#line 54 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
#line 54 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->priv->item_factory = _tmp6_;
#line 55 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp7_ = gee_array_list_new (RYGEL_EXTERNAL_TYPE_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 55 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->priv->containers);
#line 55 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->priv->containers = _tmp7_;
#line 56 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 56 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp9_ = _tmp8_;
#line 56 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp9_);
#line 56 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_tmp9_);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp10_ = self->service_name;
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp11_ = path;
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp12_ = g_initable_new (RYGEL_EXTERNAL_TYPE_MEDIA_CONTAINER_PROXY_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _tmp10_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp11_, "g-interface-name", "org.gnome.UPnP.MediaContainer2", NULL);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp13_ = (RygelExternalMediaContainerProxy*) _tmp12_;
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_inner_error_->domain == G_IO_ERROR) {
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_propagate_error (error, _inner_error_);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (self);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return NULL;
#line 708 "rygel-external-container.c"
		} else {
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_clear_error (&_inner_error_);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return NULL;
#line 716 "rygel-external-container.c"
		}
	}
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->actual_container);
#line 59 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->actual_container = _tmp13_;
#line 65 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_update_container (self, TRUE, NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return self;
#line 727 "rygel-external-container.c"
}


RygelExternalContainer* rygel_external_container_new (const gchar* id, const gchar* title, guint child_count, gboolean searchable, const gchar* service_name, const gchar* path, RygelExternalContainer* parent, GError** error) {
#line 44 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return rygel_external_container_construct (RYGEL_EXTERNAL_TYPE_CONTAINER, id, title, child_count, searchable, service_name, path, parent, error);
#line 734 "rygel-external-container.c"
}


static void rygel_external_container_real_get_children_data_free (gpointer _data) {
	RygelExternalContainerGetChildrenData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerGetChildrenData, _data_);
#line 749 "rygel-external-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 756 "rygel-external-container.c"
}


static void rygel_external_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerGetChildrenData* _data_;
	RygelExternalContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerGetChildrenData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_get_children);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_get_children_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = offset;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->offset = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = max_count;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->max_count = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->cancellable = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_get_children_co (_data_);
#line 796 "rygel-external-container.c"
}


static RygelMediaObjects* rygel_external_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerGetChildrenData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return NULL;
#line 807 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 817 "rygel-external-container.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 828 "rygel-external-container.c"
	}
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 834 "rygel-external-container.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 845 "rygel-external-container.c"
	}
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 851 "rygel-external-container.c"
}


static void rygel_external_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerGetChildrenData* _data_;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_get_children_co (_data_);
#line 865 "rygel-external-container.c"
}


static gboolean rygel_external_container_real_get_children_co (RygelExternalContainerGetChildrenData* _data_) {
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 874 "rygel-external-container.c"
		goto _state_0;
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 878 "rygel-external-container.c"
		goto _state_1;
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 2:
#line 882 "rygel-external-container.c"
		goto _state_2;
		default:
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 887 "rygel-external-container.c"
	}
	_state_0:
#line 72 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = NULL;
#line 72 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 72 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = _data_->_tmp0_;
#line 72 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 72 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = _data_->filter_length1;
#line 900 "rygel-external-container.c"
	{
#line 74 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = 0;
#line 74 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_object_prop_collection_size_ = 0;
#line 74 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
#line 74 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
#line 74 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_it = 0;
#line 74 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->object_prop_it = 0; _data_->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); _data_->object_prop_it = _data_->object_prop_it + 1) {
#line 74 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
#line 916 "rygel-external-container.c"
			{
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1_ = _data_->filter;
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1__length1 = _data_->filter_length1;
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp2_ = _data_->object_prop;
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 75 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add1 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp3_);
#line 928 "rygel-external-container.c"
			}
		}
	}
	{
#line 78 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection_length1 = 0;
#line 78 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_item_prop_collection_size_ = 0;
#line 78 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
#line 78 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
#line 78 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_it = 0;
#line 78 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->item_prop_it = 0; _data_->item_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES); _data_->item_prop_it = _data_->item_prop_it + 1) {
#line 78 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->item_prop = _data_->item_prop_collection[_data_->item_prop_it];
#line 947 "rygel-external-container.c"
			{
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = _data_->filter;
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4__length1 = _data_->filter_length1;
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = _data_->item_prop;
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 79 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add2 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp6_);
#line 959 "rygel-external-container.c"
			}
		}
	}
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp7_ = _data_->self->actual_container;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp8_ = _data_->offset;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp9_ = _data_->max_count;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp10_ = _data_->filter;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp10__length1 = _data_->filter_length1;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp11_ = 0;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 1;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_media_container_proxy_list_children (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, _data_->_tmp10__length1, rygel_external_container_get_children_ready, _data_);
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 981 "rygel-external-container.c"
	_state_1:
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = NULL;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = rygel_external_media_container_proxy_list_children_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp11_, &_data_->_inner_error_);
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = _data_->_tmp12_;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props_length1 = _data_->_tmp11_;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_children_props_size_ = _data_->children_props_length1;
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1005 "rygel-external-container.c"
		} else {
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1009 "rygel-external-container.c"
		}
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 82 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1015 "rygel-external-container.c"
	}
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp13_ = _data_->children_props;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp13__length1 = _data_->children_props_length1;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 2;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_create_media_objects (_data_->self, _data_->_tmp13_, _data_->_tmp13__length1, (RygelMediaContainer*) _data_->self, rygel_external_container_get_children_ready, _data_);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1027 "rygel-external-container.c"
	_state_2:
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp14_ = NULL;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp14_ = rygel_external_container_create_media_objects_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1049 "rygel-external-container.c"
		} else {
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1053 "rygel-external-container.c"
		}
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1059 "rygel-external-container.c"
	}
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = _data_->_tmp15_;
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1071 "rygel-external-container.c"
	} else {
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1075 "rygel-external-container.c"
	}
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 85 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1089 "rygel-external-container.c"
	} else {
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1093 "rygel-external-container.c"
	}
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 68 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1099 "rygel-external-container.c"
}


static void rygel_external_container_real_search_data_free (gpointer _data) {
	RygelExternalContainerSearchData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerSearchData, _data_);
#line 1116 "rygel-external-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1123 "rygel-external-container.c"
}


static void rygel_external_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerSearchData* _data_;
	RygelExternalContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerSearchData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_search);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_search_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = expression;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->expression = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = offset;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->offset = _tmp3_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = max_count;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->max_count = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp5_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->cancellable = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_search_co (_data_);
#line 1171 "rygel-external-container.c"
}


static RygelMediaObjects* rygel_external_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerSearchData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return NULL;
#line 1182 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (total_matches) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*total_matches = _data_->total_matches;
#line 1190 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 1198 "rygel-external-container.c"
}


static void rygel_external_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerSearchData* _data_;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_search_co (_data_);
#line 1212 "rygel-external-container.c"
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1223 "rygel-external-container.c"
	}
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 1229 "rygel-external-container.c"
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1240 "rygel-external-container.c"
	}
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 1246 "rygel-external-container.c"
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1257 "rygel-external-container.c"
	}
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 1263 "rygel-external-container.c"
}


static gboolean rygel_external_container_real_search_co (RygelExternalContainerSearchData* _data_) {
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 1272 "rygel-external-container.c"
		goto _state_0;
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 1276 "rygel-external-container.c"
		goto _state_1;
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 2:
#line 1280 "rygel-external-container.c"
		goto _state_2;
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 3:
#line 1284 "rygel-external-container.c"
		goto _state_3;
		default:
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 1289 "rygel-external-container.c"
	}
	_state_0:
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = _data_->expression;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_tmp1_ == NULL) {
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp0_ = TRUE;
#line 1298 "rygel-external-container.c"
	} else {
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp2_ = _data_->self->priv->searchable;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp0_ = !_data_->_tmp2_;
#line 1304 "rygel-external-container.c"
	}
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp3_ = _data_->_tmp0_;
#line 94 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_tmp3_) {
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp4_ = _data_->expression;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp5_ = _data_->offset;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp6_ = _data_->max_count;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp7_ = _data_->cancellable;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp8_ = 0U;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 1;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, rygel_external_container_search_ready, _data_);
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1326 "rygel-external-container.c"
		_state_1:
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = NULL;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp8_, &_data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->total_matches = _data_->_tmp8_;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_error_free (_data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_state_ == 0) {
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1346 "rygel-external-container.c"
			} else {
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1350 "rygel-external-container.c"
			}
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_object_unref (_data_->_async_result);
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 1356 "rygel-external-container.c"
		}
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->result = _data_->_tmp10_;
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1364 "rygel-external-container.c"
		} else {
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1368 "rygel-external-container.c"
		}
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 96 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1374 "rygel-external-container.c"
	}
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp11_ = NULL;
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp11_ = g_new0 (gchar*, 0 + 1);
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = _data_->_tmp11_;
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 103 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = _data_->filter_length1;
#line 1386 "rygel-external-container.c"
	{
#line 104 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = 0;
#line 104 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_object_prop_collection_size_ = 0;
#line 104 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
#line 104 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
#line 104 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_it = 0;
#line 104 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->object_prop_it = 0; _data_->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); _data_->object_prop_it = _data_->object_prop_it + 1) {
#line 104 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
#line 1402 "rygel-external-container.c"
			{
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp12_ = _data_->filter;
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp12__length1 = _data_->filter_length1;
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp13_ = _data_->object_prop;
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = g_strdup (_data_->_tmp13_);
#line 105 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add3 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp14_);
#line 1414 "rygel-external-container.c"
			}
		}
	}
	{
#line 108 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = 0;
#line 108 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_container_prop_collection_size_ = 0;
#line 108 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
#line 108 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
#line 108 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_it = 0;
#line 108 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->container_prop_it = 0; _data_->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); _data_->container_prop_it = _data_->container_prop_it + 1) {
#line 108 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->container_prop = _data_->container_prop_collection[_data_->container_prop_it];
#line 1433 "rygel-external-container.c"
			{
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = _data_->filter;
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15__length1 = _data_->filter_length1;
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp16_ = _data_->container_prop;
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
#line 109 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add4 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp17_);
#line 1445 "rygel-external-container.c"
			}
		}
	}
	{
#line 112 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection_length1 = 0;
#line 112 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_item_prop_collection_size_ = 0;
#line 112 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection = RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES;
#line 112 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES);
#line 112 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->item_prop_it = 0;
#line 112 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->item_prop_it = 0; _data_->item_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_PROPERTIES); _data_->item_prop_it = _data_->item_prop_it + 1) {
#line 112 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->item_prop = _data_->item_prop_collection[_data_->item_prop_it];
#line 1464 "rygel-external-container.c"
			{
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp18_ = _data_->filter;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp18__length1 = _data_->filter_length1;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19_ = _data_->item_prop;
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
#line 113 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add5 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp20_);
#line 1476 "rygel-external-container.c"
			}
		}
	}
#line 116 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp21_ = _data_->expression;
#line 116 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp22_ = NULL;
#line 116 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp22_ = rygel_external_container_translate_expression (_data_->self, _data_->_tmp21_);
#line 116 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->ext_expression = _data_->_tmp22_;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp23_ = _data_->self->actual_container;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp24_ = _data_->ext_expression;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp25_ = NULL;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp25_ = rygel_search_expression_to_string (_data_->_tmp24_);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp26_ = _data_->_tmp25_;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp27_ = _data_->offset;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp28_ = _data_->max_count;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp29_ = _data_->filter;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp29__length1 = _data_->filter_length1;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp30_ = 0;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 2;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_media_container_proxy_search_objects (_data_->_tmp23_, _data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, _data_->_tmp29_, _data_->_tmp29__length1, rygel_external_container_search_ready, _data_);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1514 "rygel-external-container.c"
	_state_2:
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp31_ = NULL;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp31_ = rygel_external_media_container_proxy_search_objects_finish (_data_->_tmp23_, _data_->_res_, &_data_->_tmp30_, &_data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp32_ = _data_->_tmp31_;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp32__length1 = _data_->_tmp30_;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->_tmp26_);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result_ = _data_->_tmp32_;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result__length1 = _data_->_tmp32__length1;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->__result__size_ = _data_->_result__length1;
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (_data_->ext_expression);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1546 "rygel-external-container.c"
		} else {
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1550 "rygel-external-container.c"
		}
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 117 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1556 "rygel-external-container.c"
	}
#line 122 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp33_ = _data_->_result_;
#line 122 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp33__length1 = _data_->_result__length1;
#line 122 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->total_matches = (guint) _data_->_tmp33__length1;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp34_ = _data_->_result_;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp34__length1 = _data_->_result__length1;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 3;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_create_media_objects (_data_->self, _data_->_tmp34_, _data_->_tmp34__length1, NULL, rygel_external_container_search_ready, _data_);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1574 "rygel-external-container.c"
	_state_3:
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp35_ = NULL;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp35_ = rygel_external_container_create_media_objects_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp36_ = _data_->_tmp35_;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (_data_->ext_expression);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1598 "rygel-external-container.c"
		} else {
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1602 "rygel-external-container.c"
		}
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1608 "rygel-external-container.c"
	}
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = _data_->_tmp36_;
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_search_expression_unref0 (_data_->ext_expression);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1622 "rygel-external-container.c"
	} else {
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1626 "rygel-external-container.c"
	}
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_result_ = (_vala_array_free (_data_->_result_, _data_->_result__length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_search_expression_unref0 (_data_->ext_expression);
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1642 "rygel-external-container.c"
	} else {
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1646 "rygel-external-container.c"
	}
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 88 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1652 "rygel-external-container.c"
}


static void rygel_external_container_real_find_object_data_free (gpointer _data) {
	RygelExternalContainerFindObjectData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->id);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerFindObjectData, _data_);
#line 1669 "rygel-external-container.c"
}


static void rygel_external_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainer * self;
	RygelExternalContainerFindObjectData* _data_;
	RygelExternalContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerFindObjectData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_real_find_object);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_real_find_object_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = id;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->id = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->cancellable = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_find_object_co (_data_);
#line 1707 "rygel-external-container.c"
}


static RygelMediaObject* rygel_external_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelExternalContainerFindObjectData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return NULL;
#line 1718 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 1728 "rygel-external-container.c"
}


static void rygel_external_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerFindObjectData* _data_;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_real_find_object_co (_data_);
#line 1742 "rygel-external-container.c"
}


static gboolean rygel_external_container_real_find_object_co (RygelExternalContainerFindObjectData* _data_) {
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 1751 "rygel-external-container.c"
		goto _state_0;
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 1755 "rygel-external-container.c"
		goto _state_1;
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 2:
#line 1759 "rygel-external-container.c"
		goto _state_2;
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 3:
#line 1763 "rygel-external-container.c"
		goto _state_3;
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 4:
#line 1767 "rygel-external-container.c"
		goto _state_4;
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 5:
#line 1771 "rygel-external-container.c"
		goto _state_5;
		default:
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 1776 "rygel-external-container.c"
	}
	_state_0:
#line 130 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->media_object = NULL;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = _data_->self->service_name;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = _data_->id;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 1;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_async_initable_new_async (RYGEL_EXTERNAL_TYPE_MEDIA_OBJECT_PROXY_PROXY, 0, NULL, rygel_external_container_find_object_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp1_, "g-interface-name", "org.gnome.UPnP.MediaObject2", NULL);
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 1791 "rygel-external-container.c"
	_state_1:
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp2_ = NULL;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp2_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->actual_object = (RygelExternalMediaObjectProxy*) _data_->_tmp2_;
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->media_object);
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1811 "rygel-external-container.c"
		} else {
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1815 "rygel-external-container.c"
		}
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 133 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1821 "rygel-external-container.c"
	}
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp3_ = _data_->actual_object;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp4_ = rygel_external_media_object_proxy_get_object_type (_data_->_tmp3_);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp7_ = g_strcmp0 (_data_->_tmp6_, "container") == 0;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (_data_->_tmp6_);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_tmp7_) {
#line 138 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp8_ = _data_->id;
#line 138 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = NULL;
#line 138 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp9_ = rygel_external_container_find_container_by_id (_data_->self, _data_->_tmp8_);
#line 138 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->media_object);
#line 138 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->media_object = (RygelMediaObject*) _data_->_tmp9_;
#line 140 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp10_ = _data_->media_object;
#line 140 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_tmp10_ == NULL) {
#line 1851 "rygel-external-container.c"
			{
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp11_ = _data_->self->priv->containers;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_container_list = _data_->_tmp12_;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp13_ = _data_->_container_list;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp13_);
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_container_size = _data_->_tmp15_;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_container_index = -1;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				while (TRUE) {
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp16_ = _data_->_container_index;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_container_index = _data_->_tmp16_ + 1;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp17_ = _data_->_container_index;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp18_ = _data_->_container_size;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (!(_data_->_tmp17_ < _data_->_tmp18_)) {
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						break;
#line 1883 "rygel-external-container.c"
					}
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp19_ = _data_->_container_list;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp20_ = _data_->_container_index;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp21_ = NULL;
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp19_, _data_->_tmp20_);
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->container = (RygelExternalContainer*) _data_->_tmp21_;
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp22_ = _data_->container;
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp23_ = _data_->id;
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp24_ = _data_->cancellable;
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_state_ = 2;
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_, rygel_external_container_find_object_ready, _data_);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					return FALSE;
#line 1907 "rygel-external-container.c"
					_state_2:
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp25_ = NULL;
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp25_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp22_, _data_->_res_, &_data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp26_ = _data_->_tmp25_;
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (_data_->_inner_error_ != NULL) {
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_error_free (_data_->_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->container);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->_container_list);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->actual_object);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						if (_data_->_state_ == 0) {
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1933 "rygel-external-container.c"
						} else {
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_simple_async_result_complete (_data_->_async_result);
#line 1937 "rygel-external-container.c"
						}
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_object_unref (_data_->_async_result);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						return FALSE;
#line 1943 "rygel-external-container.c"
					}
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->media_object);
#line 143 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->media_object = _data_->_tmp26_;
#line 146 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp27_ = _data_->media_object;
#line 146 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (_data_->_tmp27_ != NULL) {
#line 147 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->container);
#line 147 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						break;
#line 1957 "rygel-external-container.c"
					}
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->container);
#line 1961 "rygel-external-container.c"
				}
#line 142 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->_container_list);
#line 1965 "rygel-external-container.c"
			}
		}
	} else {
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp28_ = _data_->actual_object;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp29_ = rygel_external_media_object_proxy_get_parent (_data_->_tmp28_);
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp30_ = _data_->_tmp29_;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp31_ = (gchar*) _data_->_tmp30_;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp32_ = rygel_external_dummy_container_new (_data_->_tmp31_, "LaLaLa", (guint) 0, NULL);
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp33_ = _data_->_tmp32_;
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (_data_->_tmp31_);
#line 152 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->parent_container = _data_->_tmp33_;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp34_ = _data_->self->service_name;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp35_ = _data_->id;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 3;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_async_initable_new_async (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_container_find_object_ready, _data_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _data_->_tmp34_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp35_, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 1995 "rygel-external-container.c"
		_state_3:
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp36_ = NULL;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp36_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_iface = (FreeDesktopProperties*) _data_->_tmp36_;
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_error_free (_data_->_inner_error_);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->parent_container);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->actual_object);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->media_object);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_state_ == 0) {
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2019 "rygel-external-container.c"
			} else {
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2023 "rygel-external-container.c"
			}
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_object_unref (_data_->_async_result);
#line 158 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2029 "rygel-external-container.c"
		}
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp37_ = _data_->props_iface;
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 4;
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		free_desktop_properties_get_all (_data_->_tmp37_, RYGEL_EXTERNAL_MEDIA_ITEM_PROXY_IFACE, rygel_external_container_find_object_ready, _data_);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 2039 "rygel-external-container.c"
		_state_4:
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp38_ = NULL;
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp38_ = free_desktop_properties_get_all_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error_);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props = _data_->_tmp38_;
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_error_free (_data_->_inner_error_);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->props_iface);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->parent_container);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->actual_object);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->media_object);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_state_ == 0) {
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2065 "rygel-external-container.c"
			} else {
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2069 "rygel-external-container.c"
			}
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_object_unref (_data_->_async_result);
#line 164 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2075 "rygel-external-container.c"
		}
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp39_ = _data_->self->priv->item_factory;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp40_ = _data_->id;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp41_ = _data_->actual_object;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp42_ = rygel_external_media_object_proxy_get_object_type (_data_->_tmp41_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp43_ = _data_->_tmp42_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp44_ = _data_->_tmp43_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp45_ = _data_->actual_object;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp46_ = rygel_external_media_object_proxy_get_display_name (_data_->_tmp45_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp47_ = _data_->_tmp46_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp48_ = _data_->_tmp47_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp49_ = _data_->props;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp50_ = _data_->self->service_name;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp51_ = _data_->parent_container;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 5;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_external_item_factory_create (_data_->_tmp39_, _data_->_tmp40_, _data_->_tmp44_, _data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_, (RygelMediaContainer*) _data_->_tmp51_, rygel_external_container_find_object_ready, _data_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 2109 "rygel-external-container.c"
		_state_5:
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp52_ = NULL;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp52_ = rygel_external_item_factory_create_finish (_data_->_tmp39_, _data_->_res_, &_data_->_inner_error_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp53_ = _data_->_tmp52_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (_data_->_tmp48_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (_data_->_tmp44_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp54_ = _data_->_tmp53_;
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_error_free (_data_->_inner_error_);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_hash_table_unref0 (_data_->props);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->props_iface);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->parent_container);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->actual_object);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (_data_->media_object);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (_data_->_state_ == 0) {
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2143 "rygel-external-container.c"
			} else {
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2147 "rygel-external-container.c"
			}
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_object_unref (_data_->_async_result);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			return FALSE;
#line 2153 "rygel-external-container.c"
		}
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->media_object);
#line 167 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->media_object = (RygelMediaObject*) _data_->_tmp54_;
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_hash_table_unref0 (_data_->props);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->props_iface);
#line 137 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_data_->parent_container);
#line 2165 "rygel-external-container.c"
	}
#line 176 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = _data_->media_object;
#line 176 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->actual_object);
#line 176 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 176 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2175 "rygel-external-container.c"
	} else {
#line 176 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2179 "rygel-external-container.c"
	}
#line 176 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 176 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->actual_object);
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->media_object);
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2193 "rygel-external-container.c"
	} else {
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2197 "rygel-external-container.c"
	}
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 127 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 2203 "rygel-external-container.c"
}


static void rygel_external_container_create_media_objects_data_free (gpointer _data) {
	RygelExternalContainerCreateMediaObjectsData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->all_props = (_vala_array_free (_data_->all_props, _data_->all_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->parent);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerCreateMediaObjectsData, _data_);
#line 2220 "rygel-external-container.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 2227 "rygel-external-container.c"
}


static GHashTable** _vala_array_dup1 (GHashTable** self, int length) {
	GHashTable** result;
	int i;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = g_new0 (GHashTable*, length + 1);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	for (i = 0; i < length; i++) {
#line 2238 "rygel-external-container.c"
		GHashTable* _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp0_ = _g_hash_table_ref0 (self[i]);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		result[i] = _tmp0_;
#line 2244 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 2248 "rygel-external-container.c"
}


static void rygel_external_container_create_media_objects (RygelExternalContainer* self, GHashTable** all_props, int all_props_length1, RygelMediaContainer* parent, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerCreateMediaObjectsData* _data_;
	RygelExternalContainer* _tmp0_;
	GHashTable** _tmp1_;
	gint _tmp1__length1;
	GHashTable** _tmp2_;
	gint _tmp2__length1;
	RygelMediaContainer* _tmp3_;
	RygelMediaContainer* _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerCreateMediaObjectsData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_create_media_objects);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_create_media_objects_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = all_props;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1__length1 = all_props_length1;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp2__length1 = _tmp1__length1;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->all_props = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->all_props_length1 = _tmp2__length1;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = parent;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->parent = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_create_media_objects_co (_data_);
#line 2291 "rygel-external-container.c"
}


static RygelMediaObjects* rygel_external_container_create_media_objects_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelExternalContainerCreateMediaObjectsData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return NULL;
#line 2302 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 2312 "rygel-external-container.c"
}


static const gchar* _variant_get1 (GVariant* value) {
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 2319 "rygel-external-container.c"
}


static const gchar* _variant_get2 (GVariant* value) {
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 2326 "rygel-external-container.c"
}


static const gchar* _variant_get3 (GVariant* value) {
#line 193 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 2333 "rygel-external-container.c"
}


static const gchar* _variant_get4 (GVariant* value) {
#line 207 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 2340 "rygel-external-container.c"
}


static guint _variant_get5 (GVariant* value) {
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_uint32 (value);
#line 2347 "rygel-external-container.c"
}


static void rygel_external_container_create_media_objects_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerCreateMediaObjectsData* _data_;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_create_media_objects_co (_data_);
#line 2361 "rygel-external-container.c"
}


static gboolean rygel_external_container_create_media_objects_co (RygelExternalContainerCreateMediaObjectsData* _data_) {
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 2370 "rygel-external-container.c"
		goto _state_0;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 2374 "rygel-external-container.c"
		goto _state_1;
		default:
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 2379 "rygel-external-container.c"
	}
	_state_0:
#line 183 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 183 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->media_objects = _data_->_tmp0_;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1_ = _data_->all_props;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp1__length1 = _data_->all_props_length1;
#line 2390 "rygel-external-container.c"
	{
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection_length1 = 0;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_props_collection_size_ = 0;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection = _data_->_tmp1_;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection_length1 = _data_->_tmp1__length1;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_it = 0;
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->props_it = 0; _data_->props_it < _data_->_tmp1__length1; _data_->props_it = _data_->props_it + 1) {
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp2_ = _g_hash_table_ref0 (_data_->props_collection[_data_->props_it]);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->props = _data_->_tmp2_;
#line 2408 "rygel-external-container.c"
			{
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = _data_->props;
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = NULL;
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = g_hash_table_lookup (_data_->_tmp3_, "Path");
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = _variant_get1 ((GVariant*) _data_->_tmp4_);
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 186 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->id = _data_->_tmp6_;
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp7_ = _data_->props;
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp8_ = NULL;
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp8_ = g_hash_table_lookup (_data_->_tmp7_, "Type");
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp9_ = _variant_get2 ((GVariant*) _data_->_tmp8_);
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 187 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->type = _data_->_tmp10_;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp11_ = _data_->parent;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_tmp11_ != NULL) {
#line 191 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp12_ = _data_->parent;
#line 191 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
#line 191 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->parent_container);
#line 191 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->parent_container = _data_->_tmp13_;
#line 2446 "rygel-external-container.c"
				} else {
#line 193 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp14_ = _data_->props;
#line 193 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp15_ = NULL;
#line 193 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp15_ = g_hash_table_lookup (_data_->_tmp14_, "Parent");
#line 193 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp16_ = _variant_get3 ((GVariant*) _data_->_tmp15_);
#line 193 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
#line 193 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->parent_id = _data_->_tmp17_;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp18_ = _data_->parent_id;
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp19_ = rygel_external_dummy_container_new (_data_->_tmp18_, "LaLaLa", (guint) 0, NULL);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->parent_container);
#line 195 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->parent_container = (RygelMediaContainer*) _data_->_tmp19_;
#line 190 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_free0 (_data_->parent_id);
#line 2470 "rygel-external-container.c"
				}
#line 201 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->media_object = NULL;
#line 202 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = _data_->type;
#line 202 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (g_strcmp0 (_data_->_tmp20_, "container") == 0) {
#line 203 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp21_ = _data_->id;
#line 203 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp22_ = NULL;
#line 203 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp22_ = rygel_external_container_find_container_by_id (_data_->self, _data_->_tmp21_);
#line 203 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_object_unref0 (_data_->media_object);
#line 203 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->media_object = (RygelMediaObject*) _data_->_tmp22_;
#line 2488 "rygel-external-container.c"
				}
#line 206 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp23_ = _data_->media_object;
#line 206 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_tmp23_ == NULL) {
#line 207 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp24_ = _data_->props;
#line 207 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp25_ = NULL;
#line 207 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp25_ = g_hash_table_lookup (_data_->_tmp24_, "DisplayName");
#line 207 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp26_ = _variant_get4 ((GVariant*) _data_->_tmp25_);
#line 207 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp27_ = g_strdup (_data_->_tmp26_);
#line 207 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->title = _data_->_tmp27_;
#line 209 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->_tmp28_ = _data_->type;
#line 209 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (g_strcmp0 (_data_->_tmp28_, "container") == 0) {
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp29_ = _data_->props;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp30_ = NULL;
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp30_ = g_hash_table_lookup (_data_->_tmp29_, "ChildCount");
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp31_ = _variant_get5 ((GVariant*) _data_->_tmp30_);
#line 210 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->child_count = _data_->_tmp31_;
#line 212 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp32_ = _data_->id;
#line 212 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp33_ = _data_->title;
#line 212 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp34_ = _data_->child_count;
#line 212 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp35_ = _data_->parent_container;
#line 212 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp36_ = rygel_external_dummy_container_new (_data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_, _data_->_tmp35_);
#line 212 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 212 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->media_object = (RygelMediaObject*) _data_->_tmp36_;
#line 2534 "rygel-external-container.c"
					} else {
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp37_ = _data_->self->priv->item_factory;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp38_ = _data_->id;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp39_ = _data_->type;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp40_ = _data_->title;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp41_ = _data_->props;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp42_ = _data_->self->service_name;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp43_ = _data_->parent_container;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_state_ = 1;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						rygel_external_item_factory_create (_data_->_tmp37_, _data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_, _data_->_tmp41_, _data_->_tmp42_, _data_->_tmp43_, rygel_external_container_create_media_objects_ready, _data_);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						return FALSE;
#line 2556 "rygel-external-container.c"
						_state_1:
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp44_ = NULL;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp44_ = rygel_external_item_factory_create_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error_);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->_tmp45_ = _data_->_tmp44_;
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						if (_data_->_inner_error_ != NULL) {
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_error_free (_data_->_inner_error_);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_free0 (_data_->title);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_object_unref0 (_data_->media_object);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_object_unref0 (_data_->parent_container);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_free0 (_data_->type);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_free0 (_data_->id);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_hash_table_unref0 (_data_->props);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							_g_object_unref0 (_data_->media_objects);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							if (_data_->_state_ == 0) {
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
								g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2588 "rygel-external-container.c"
							} else {
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
								g_simple_async_result_complete (_data_->_async_result);
#line 2592 "rygel-external-container.c"
							}
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							g_object_unref (_data_->_async_result);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
							return FALSE;
#line 2598 "rygel-external-container.c"
						}
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 218 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						_data_->media_object = (RygelMediaObject*) _data_->_tmp45_;
#line 2604 "rygel-external-container.c"
					}
#line 206 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_free0 (_data_->title);
#line 2608 "rygel-external-container.c"
				}
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp46_ = _data_->media_objects;
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp47_ = _data_->media_object;
#line 228 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp46_, _data_->_tmp47_);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->media_object);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->parent_container);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->type);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->id);
#line 185 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_hash_table_unref0 (_data_->props);
#line 2626 "rygel-external-container.c"
			}
		}
	}
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->result = _data_->media_objects;
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2636 "rygel-external-container.c"
	} else {
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2640 "rygel-external-container.c"
	}
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 231 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->media_objects);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2652 "rygel-external-container.c"
	} else {
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2656 "rygel-external-container.c"
	}
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 179 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 2662 "rygel-external-container.c"
}


static void rygel_external_container_refresh_child_containers_data_free (gpointer _data) {
	RygelExternalContainerRefreshChildContainersData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerRefreshChildContainersData, _data_);
#line 2673 "rygel-external-container.c"
}


static void rygel_external_container_refresh_child_containers (RygelExternalContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerRefreshChildContainersData* _data_;
	RygelExternalContainer* _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerRefreshChildContainersData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_refresh_child_containers);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_refresh_child_containers_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_refresh_child_containers_co (_data_);
#line 2692 "rygel-external-container.c"
}


static void rygel_external_container_refresh_child_containers_finish (RygelExternalContainer* self, GAsyncResult* _res_, GError** error) {
	RygelExternalContainerRefreshChildContainersData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return;
#line 2702 "rygel-external-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2706 "rygel-external-container.c"
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2717 "rygel-external-container.c"
	}
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 2723 "rygel-external-container.c"
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if ((*length) == (*size)) {
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2734 "rygel-external-container.c"
	}
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[(*length)++] = value;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	(*array)[*length] = NULL;
#line 2740 "rygel-external-container.c"
}


static void rygel_external_container_refresh_child_containers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerRefreshChildContainersData* _data_;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_refresh_child_containers_co (_data_);
#line 2754 "rygel-external-container.c"
}


static const gchar* _variant_get6 (GVariant* value) {
#line 250 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 2761 "rygel-external-container.c"
}


static const gchar* _variant_get7 (GVariant* value) {
#line 251 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_dup_string (value, NULL);
#line 2768 "rygel-external-container.c"
}


static guint _variant_get8 (GVariant* value) {
#line 252 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_uint32 (value);
#line 2775 "rygel-external-container.c"
}


static gboolean _variant_get9 (GVariant* value) {
#line 253 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return g_variant_get_boolean (value);
#line 2782 "rygel-external-container.c"
}


static gboolean rygel_external_container_refresh_child_containers_co (RygelExternalContainerRefreshChildContainersData* _data_) {
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 2791 "rygel-external-container.c"
		goto _state_0;
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 2795 "rygel-external-container.c"
		goto _state_1;
		default:
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 2800 "rygel-external-container.c"
	}
	_state_0:
#line 235 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = NULL;
#line 235 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 235 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = _data_->_tmp0_;
#line 235 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter_length1 = 0;
#line 235 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_filter_size_ = _data_->filter_length1;
#line 2813 "rygel-external-container.c"
	{
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = 0;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_object_prop_collection_size_ = 0;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection = RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES);
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->object_prop_it = 0;
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->object_prop_it = 0; _data_->object_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_PROPERTIES); _data_->object_prop_it = _data_->object_prop_it + 1) {
#line 237 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->object_prop = _data_->object_prop_collection[_data_->object_prop_it];
#line 2829 "rygel-external-container.c"
			{
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1_ = _data_->filter;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp1__length1 = _data_->filter_length1;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp2_ = _data_->object_prop;
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 238 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add6 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp3_);
#line 2841 "rygel-external-container.c"
			}
		}
	}
	{
#line 241 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = 0;
#line 241 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_container_prop_collection_size_ = 0;
#line 241 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection = RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES;
#line 241 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_collection_length1 = G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES);
#line 241 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->container_prop_it = 0;
#line 241 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->container_prop_it = 0; _data_->container_prop_it < G_N_ELEMENTS (RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_PROPERTIES); _data_->container_prop_it = _data_->container_prop_it + 1) {
#line 241 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->container_prop = _data_->container_prop_collection[_data_->container_prop_it];
#line 2860 "rygel-external-container.c"
			{
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4_ = _data_->filter;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp4__length1 = _data_->filter_length1;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp5_ = _data_->container_prop;
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 242 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_vala_array_add7 (&_data_->filter, &_data_->filter_length1, &_data_->_filter_size_, _data_->_tmp6_);
#line 2872 "rygel-external-container.c"
			}
		}
	}
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp7_ = _data_->self->actual_container;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp8_ = _data_->filter;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp8__length1 = _data_->filter_length1;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp9_ = 0;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_state_ = 1;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_media_container_proxy_list_containers (_data_->_tmp7_, (guint) 0, (guint) 0, _data_->_tmp8_, _data_->_tmp8__length1, rygel_external_container_refresh_child_containers_ready, _data_);
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 2890 "rygel-external-container.c"
	_state_1:
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp10_ = NULL;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp10_ = rygel_external_media_container_proxy_list_containers_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error_);
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = _data_->_tmp10_;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props_length1 = _data_->_tmp9_;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_children_props_size_ = _data_->children_props_length1;
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_error_free (_data_->_inner_error_);
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_state_ == 0) {
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2914 "rygel-external-container.c"
		} else {
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2918 "rygel-external-container.c"
		}
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_object_unref (_data_->_async_result);
#line 245 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 2924 "rygel-external-container.c"
	}
#line 247 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp11_ = _data_->self->priv->containers;
#line 247 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp11_);
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12_ = _data_->children_props;
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp12__length1 = _data_->children_props_length1;
#line 2934 "rygel-external-container.c"
	{
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection_length1 = 0;
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_props_collection_size_ = 0;
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection = _data_->_tmp12_;
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_collection_length1 = _data_->_tmp12__length1;
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->props_it = 0;
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		for (_data_->props_it = 0; _data_->props_it < _data_->_tmp12__length1; _data_->props_it = _data_->props_it + 1) {
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->_tmp13_ = _g_hash_table_ref0 (_data_->props_collection[_data_->props_it]);
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_data_->props = _data_->_tmp13_;
#line 2952 "rygel-external-container.c"
			{
#line 250 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp14_ = _data_->props;
#line 250 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = NULL;
#line 250 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp15_ = g_hash_table_lookup (_data_->_tmp14_, "Path");
#line 250 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp16_ = _variant_get6 ((GVariant*) _data_->_tmp15_);
#line 250 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
#line 250 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->path = _data_->_tmp17_;
#line 251 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp18_ = _data_->props;
#line 251 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19_ = NULL;
#line 251 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp19_ = g_hash_table_lookup (_data_->_tmp18_, "DisplayName");
#line 251 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp20_ = _variant_get7 ((GVariant*) _data_->_tmp19_);
#line 251 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
#line 251 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->title = _data_->_tmp21_;
#line 252 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp22_ = _data_->props;
#line 252 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp23_ = NULL;
#line 252 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp23_ = g_hash_table_lookup (_data_->_tmp22_, "ChildCount");
#line 252 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp24_ = _variant_get8 ((GVariant*) _data_->_tmp23_);
#line 252 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->child_count = _data_->_tmp24_;
#line 253 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp25_ = _data_->props;
#line 253 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp26_ = NULL;
#line 253 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp26_ = g_hash_table_lookup (_data_->_tmp25_, "Searchable");
#line 253 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp27_ = _variant_get9 ((GVariant*) _data_->_tmp26_);
#line 253 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->searchable = _data_->_tmp27_;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp28_ = _data_->path;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp29_ = _data_->title;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp30_ = _data_->child_count;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp31_ = _data_->searchable;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp32_ = _data_->self->service_name;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp33_ = _data_->path;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp34_ = rygel_external_container_new (_data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_, _data_->self, &_data_->_inner_error_);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->container = _data_->_tmp34_;
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				if (_data_->_inner_error_ != NULL) {
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_error_free (_data_->_inner_error_);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_free0 (_data_->title);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_free0 (_data_->path);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_g_hash_table_unref0 (_data_->props);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					if (_data_->_state_ == 0) {
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3034 "rygel-external-container.c"
					} else {
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 3038 "rygel-external-container.c"
					}
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					g_object_unref (_data_->_async_result);
#line 255 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
					return FALSE;
#line 3044 "rygel-external-container.c"
				}
#line 262 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp35_ = _data_->self->priv->containers;
#line 262 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_data_->_tmp36_ = _data_->container;
#line 262 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp35_, _data_->_tmp36_);
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (_data_->container);
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->title);
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_free0 (_data_->path);
#line 249 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_hash_table_unref0 (_data_->props);
#line 3060 "rygel-external-container.c"
			}
		}
	}
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->children_props = (_vala_array_free (_data_->children_props, _data_->children_props_length1, (GDestroyNotify) g_hash_table_unref), NULL);
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->filter = (_vala_array_free (_data_->filter, _data_->filter_length1, (GDestroyNotify) g_free), NULL);
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3072 "rygel-external-container.c"
	} else {
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3076 "rygel-external-container.c"
	}
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 234 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 3082 "rygel-external-container.c"
}


static void rygel_external_container_update_container_data_free (gpointer _data) {
	RygelExternalContainerUpdateContainerData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_slice_free (RygelExternalContainerUpdateContainerData, _data_);
#line 3093 "rygel-external-container.c"
}


static void rygel_external_container_update_container (RygelExternalContainer* self, gboolean connect_signal, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalContainerUpdateContainerData* _data_;
	RygelExternalContainer* _tmp0_;
	gboolean _tmp1_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_slice_new0 (RygelExternalContainerUpdateContainerData);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_external_container_update_container);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_container_update_container_data_free);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = connect_signal;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->connect_signal = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_update_container_co (_data_);
#line 3117 "rygel-external-container.c"
}


static void rygel_external_container_update_container_finish (RygelExternalContainer* self, GAsyncResult* _res_) {
	RygelExternalContainerUpdateContainerData* _data_;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3125 "rygel-external-container.c"
}


static void rygel_external_container_update_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalContainerUpdateContainerData* _data_;
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_ = _user_data_;
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_source_object_ = source_object;
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_res_ = _res_;
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_update_container_co (_data_);
#line 3139 "rygel-external-container.c"
}


static void _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated (RygelExternalMediaContainerProxy* _sender, gpointer self) {
#line 280 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_on_updated (self, _sender);
#line 3146 "rygel-external-container.c"
}


static gboolean rygel_external_container_update_container_co (RygelExternalContainerUpdateContainerData* _data_) {
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (_data_->_state_) {
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 0:
#line 3155 "rygel-external-container.c"
		goto _state_0;
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case 1:
#line 3159 "rygel-external-container.c"
		goto _state_1;
		default:
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_assert_not_reached ();
#line 3164 "rygel-external-container.c"
	}
	_state_0:
	{
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_state_ = 1;
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_external_container_refresh_child_containers (_data_->self, rygel_external_container_update_container_ready, _data_);
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 3174 "rygel-external-container.c"
		_state_1:
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_external_container_refresh_child_containers_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 269 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 3180 "rygel-external-container.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->err = _data_->_inner_error_;
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_inner_error_ = NULL;
#line 271 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp0_ = _data_->self->actual_container;
#line 271 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp1_ = NULL;
#line 271 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp1_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data_->_tmp0_);
#line 271 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp2_ = _data_->err;
#line 271 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp3_ = _data_->_tmp2_->message;
#line 271 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_warning ("rygel-external-container.vala:271: Failed to update information about " \
"container '%s': %s", _data_->_tmp1_, _data_->_tmp3_);
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_error_free0 (_data_->err);
#line 3205 "rygel-external-container.c"
	}
	__finally0:
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_clear_error (&_data_->_inner_error_);
#line 267 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return FALSE;
#line 3216 "rygel-external-container.c"
	}
#line 277 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self);
#line 279 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_data_->_tmp4_ = _data_->connect_signal;
#line 279 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_tmp4_) {
#line 280 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_data_->_tmp5_ = _data_->self->actual_container;
#line 280 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_signal_connect_object (_data_->_tmp5_, "updated", (GCallback) _rygel_external_container_on_updated_rygel_external_media_container_proxy_updated, _data_->self, 0);
#line 3228 "rygel-external-container.c"
	}
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_data_->_state_ == 0) {
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3234 "rygel-external-container.c"
	} else {
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3238 "rygel-external-container.c"
	}
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_unref (_data_->_async_result);
#line 266 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return FALSE;
#line 3244 "rygel-external-container.c"
}


static void rygel_external_container_on_updated (RygelExternalContainer* self, RygelExternalMediaContainerProxy* actual_container) {
#line 284 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_if_fail (self != NULL);
#line 284 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_if_fail (actual_container != NULL);
#line 285 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_update_container (self, FALSE, NULL, NULL);
#line 3255 "rygel-external-container.c"
}


static RygelMediaContainer* rygel_external_container_find_container_by_id (RygelExternalContainer* self, const gchar* id) {
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* target;
#line 288 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 288 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 289 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	target = NULL;
#line 3268 "rygel-external-container.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _container_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _container_size;
		gint _container_index;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp0_ = self->priv->containers;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_container_list = _tmp1_;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp2_ = _container_list;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp4_ = _tmp3_;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_container_size = _tmp4_;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_container_index = -1;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		while (TRUE) {
#line 3296 "rygel-external-container.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelExternalContainer* container;
			RygelExternalContainer* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp5_ = _container_index;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_container_index = _tmp5_ + 1;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp6_ = _container_index;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp7_ = _container_size;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				break;
#line 3319 "rygel-external-container.c"
			}
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp8_ = _container_list;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp9_ = _container_index;
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			container = (RygelExternalContainer*) _tmp10_;
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp11_ = container;
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp12_ = ((RygelMediaObject*) _tmp11_)->id;
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_tmp13_ = id;
#line 292 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 3337 "rygel-external-container.c"
				RygelExternalContainer* _tmp14_;
				RygelMediaContainer* _tmp15_;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp14_ = container;
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp15_ = _g_object_ref0 ((RygelMediaContainer*) _tmp14_);
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (target);
#line 293 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				target = _tmp15_;
#line 295 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_g_object_unref0 (container);
#line 295 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				break;
#line 3352 "rygel-external-container.c"
			}
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
			_g_object_unref0 (container);
#line 3356 "rygel-external-container.c"
		}
#line 291 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_object_unref0 (_container_list);
#line 3360 "rygel-external-container.c"
	}
#line 299 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = target;
#line 299 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 3366 "rygel-external-container.c"
}


static RygelSearchExpression* rygel_external_container_translate_expression (RygelExternalContainer* self, RygelSearchExpression* upnp_expression) {
	RygelSearchExpression* result = NULL;
	RygelSearchExpression* _tmp0_;
#line 302 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 302 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (upnp_expression != NULL, NULL);
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = upnp_expression;
#line 304 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (RYGEL_IS_RELATIONAL_EXPRESSION (_tmp0_)) {
#line 3381 "rygel-external-container.c"
		RygelSearchExpression* _tmp1_;
		RygelRelationalExpression* _tmp2_;
		RygelRelationalExpression* expression;
		RygelRelationalExpression* _tmp3_;
		RygelRelationalExpression* ext_expression;
		RygelRelationalExpression* _tmp4_;
		RygelRelationalExpression* _tmp5_;
		gconstpointer _tmp6_;
		RygelRelationalExpression* _tmp7_;
		RygelRelationalExpression* _tmp8_;
		gconstpointer _tmp9_;
		gchar* _tmp10_ = NULL;
		RygelRelationalExpression* _tmp11_;
		RygelRelationalExpression* _tmp12_;
		gconstpointer _tmp13_;
		gchar* _tmp14_;
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp1_ = upnp_expression;
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp2_ = _rygel_search_expression_ref0 (RYGEL_IS_RELATIONAL_EXPRESSION (_tmp1_) ? ((RygelRelationalExpression*) _tmp1_) : NULL);
#line 305 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		expression = _tmp2_;
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp3_ = rygel_relational_expression_new ();
#line 306 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		ext_expression = _tmp3_;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp4_ = ext_expression;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp5_ = expression;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp6_ = ((RygelSearchExpression*) _tmp5_)->op;
#line 307 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp4_)->op = GINT_TO_POINTER (GPOINTER_TO_INT (_tmp6_));
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp7_ = ext_expression;
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp8_ = expression;
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp9_ = ((RygelSearchExpression*) _tmp8_)->operand1;
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp10_ = rygel_external_container_translate_property (self, (const gchar*) _tmp9_);
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (((RygelSearchExpression*) _tmp7_)->operand1);
#line 308 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp7_)->operand1 = _tmp10_;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp11_ = ext_expression;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp12_ = expression;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp13_ = ((RygelSearchExpression*) _tmp12_)->operand2;
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp14_ = g_strdup ((const gchar*) _tmp13_);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_g_free0 (((RygelSearchExpression*) _tmp11_)->operand2);
#line 310 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp11_)->operand2 = _tmp14_;
#line 312 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		result = (RygelSearchExpression*) ext_expression;
#line 312 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (expression);
#line 312 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return result;
#line 3446 "rygel-external-container.c"
	} else {
		RygelSearchExpression* _tmp15_;
		RygelLogicalExpression* _tmp16_;
		RygelLogicalExpression* expression;
		RygelLogicalExpression* _tmp17_;
		RygelLogicalExpression* ext_expression;
		RygelLogicalExpression* _tmp18_;
		RygelLogicalExpression* _tmp19_;
		gconstpointer _tmp20_;
		RygelLogicalExpression* _tmp21_;
		RygelLogicalExpression* _tmp22_;
		gconstpointer _tmp23_;
		RygelSearchExpression* _tmp24_ = NULL;
		RygelLogicalExpression* _tmp25_;
		RygelLogicalExpression* _tmp26_;
		gconstpointer _tmp27_;
		RygelSearchExpression* _tmp28_ = NULL;
#line 314 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp15_ = upnp_expression;
#line 314 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp16_ = _rygel_search_expression_ref0 (RYGEL_IS_LOGICAL_EXPRESSION (_tmp15_) ? ((RygelLogicalExpression*) _tmp15_) : NULL);
#line 314 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		expression = _tmp16_;
#line 315 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp17_ = rygel_logical_expression_new ();
#line 315 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		ext_expression = _tmp17_;
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp18_ = ext_expression;
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp19_ = expression;
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp20_ = ((RygelSearchExpression*) _tmp19_)->op;
#line 317 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp18_)->op = GINT_TO_POINTER (GPOINTER_TO_INT (_tmp20_));
#line 318 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp21_ = ext_expression;
#line 318 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp22_ = expression;
#line 318 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp23_ = ((RygelSearchExpression*) _tmp22_)->operand1;
#line 318 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp24_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) _tmp23_);
#line 318 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp21_)->operand1);
#line 318 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp21_)->operand1 = _tmp24_;
#line 320 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp25_ = ext_expression;
#line 320 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp26_ = expression;
#line 320 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp27_ = ((RygelSearchExpression*) _tmp26_)->operand2;
#line 320 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_tmp28_ = rygel_external_container_translate_expression (self, (RygelSearchExpression*) _tmp27_);
#line 320 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _tmp25_)->operand2);
#line 320 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		((RygelSearchExpression*) _tmp25_)->operand2 = _tmp28_;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		result = (RygelSearchExpression*) ext_expression;
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		_rygel_search_expression_unref0 (expression);
#line 323 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		return result;
#line 3512 "rygel-external-container.c"
	}
}


gchar* rygel_external_container_translate_property (RygelExternalContainer* self, const gchar* property) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label0 = 0;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label1 = 0;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label2 = 0;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label3 = 0;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label4 = 0;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label5 = 0;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	static GQuark _tmp2_label6 = 0;
#line 327 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 327 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_return_val_if_fail (property != NULL, NULL);
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = property;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = _tmp0_;
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 3550 "rygel-external-container.c"
			default:
			{
				gchar* _tmp4_;
#line 330 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp4_ = g_strdup ("Path");
#line 330 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp4_;
#line 330 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 3560 "rygel-external-container.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@parentID")))) {
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 3566 "rygel-external-container.c"
			default:
			{
				gchar* _tmp5_;
#line 332 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp5_ = g_strdup ("Parent");
#line 332 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp5_;
#line 332 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 3576 "rygel-external-container.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("dc:title")))) {
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 3582 "rygel-external-container.c"
			default:
			{
				gchar* _tmp6_;
#line 334 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp6_ = g_strdup ("DisplayName");
#line 334 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp6_;
#line 334 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 3592 "rygel-external-container.c"
			}
		}
	} else if (((_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("dc:creator")))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("upnp:artist"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:author"))))) {
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 3598 "rygel-external-container.c"
			default:
			{
				gchar* _tmp7_;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp7_ = g_strdup ("Artist");
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp7_;
#line 338 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 3608 "rygel-external-container.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("upnp:album")))) {
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 3614 "rygel-external-container.c"
			default:
			{
				gchar* _tmp8_;
#line 340 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp8_ = g_strdup ("Album");
#line 340 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp8_;
#line 340 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 3624 "rygel-external-container.c"
			}
		}
	} else {
#line 328 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		switch (0) {
#line 3630 "rygel-external-container.c"
			default:
			{
				const gchar* _tmp9_;
				gchar* _tmp10_;
#line 342 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp9_ = property;
#line 342 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				_tmp10_ = g_strdup (_tmp9_);
#line 342 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				result = _tmp10_;
#line 342 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
				return result;
#line 3643 "rygel-external-container.c"
			}
		}
	}
}


static GeeArrayList* rygel_external_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelExternalContainer* self;
	GeeArrayList* _tmp0_;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = self->priv->_search_classes;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	return result;
#line 3662 "rygel-external-container.c"
}


static void rygel_external_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelExternalContainer* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = (RygelExternalContainer*) base;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->priv->_search_classes = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_notify ((GObject *) self, "search-classes");
#line 3682 "rygel-external-container.c"
}


static void rygel_external_container_class_init (RygelExternalContainerClass * klass) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_type_class_add_private (klass, sizeof (RygelExternalContainerPrivate));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_external_container_real_get_children;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_external_container_real_get_children_finish;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_external_container_real_find_object;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_external_container_real_find_object_finish;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_external_container_get_property;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_external_container_set_property;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_external_container_finalize;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES, "search-classes");
#line 3707 "rygel-external-container.c"
}


static void rygel_external_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	rygel_external_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer*, RygelSearchExpression*, guint, guint, guint*, GCancellable*, GError**)) rygel_external_container_real_search;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	iface->search_finish = rygel_external_container_real_search_finish;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	iface->get_search_classes = rygel_external_container_real_get_search_classes;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	iface->set_search_classes = rygel_external_container_real_set_search_classes;
#line 3722 "rygel-external-container.c"
}


static void rygel_external_container_instance_init (RygelExternalContainer * self) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self->priv = RYGEL_EXTERNAL_CONTAINER_GET_PRIVATE (self);
#line 3729 "rygel-external-container.c"
}


static void rygel_external_container_finalize (GObject* obj) {
	RygelExternalContainer * self;
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	self = RYGEL_EXTERNAL_CONTAINER (obj);
#line 34 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->actual_container);
#line 36 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_free0 (self->service_name);
#line 38 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_rygel_external_item_factory_unref0 (self->priv->item_factory);
#line 39 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->priv->containers);
#line 40 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	G_OBJECT_CLASS (rygel_external_container_parent_class)->finalize (obj);
#line 3749 "rygel-external-container.c"
}


/**
 * Represents an external container.
 */
GType rygel_external_container_get_type (void) {
	static volatile gsize rygel_external_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalContainer), 0, (GInstanceInitFunc) rygel_external_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_external_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_external_container_type_id;
		rygel_external_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelExternalContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_external_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_external_container_type_id__volatile, rygel_external_container_type_id);
	}
	return rygel_external_container_type_id__volatile;
}


static void _vala_rygel_external_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelExternalContainer * self;
	self = RYGEL_EXTERNAL_CONTAINER (object);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		break;
#line 3781 "rygel-external-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		break;
#line 3787 "rygel-external-container.c"
	}
}


static void _vala_rygel_external_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelExternalContainer * self;
	self = RYGEL_EXTERNAL_CONTAINER (object);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		case RYGEL_EXTERNAL_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		break;
#line 3803 "rygel-external-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/plugins/external/rygel-external-container.vala"
		break;
#line 3809 "rygel-external-container.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



