# Module.mk for rootx module
# Copyright (c) 2000 Rene Brun and Fons Rademakers
#
# Author: Fons Rademakers, 29/2/2000

MODDIR       := rootx
MODDIRS      := $(MODDIR)/src
MODDIRI      := $(MODDIR)/inc

ROOTXDIR     := $(MODDIR)
ROOTXDIRS    := $(ROOTXDIR)/src
ROOTXDIRI    := $(ROOTXDIR)/inc

##### rootx #####
ROOTXH       := $(wildcard $(MODDIRI)/*.h)
ROOTXS       := $(wildcard $(MODDIRS)/*.cxx)
ROOTXO       := $(ROOTXS:.cxx=.o)
ROOTXDEP     := $(ROOTXO:.o=.d)
ROOTX        := bin/root

# used in the main Makefile
ALLHDRS      += $(patsubst $(MODDIRI)/%.h,include/%.h,$(ROOTXH))
ALLEXECS     += $(ROOTX)

# include all dependency files
INCLUDEFILES += $(ROOTXDEP)

##### local rules #####
include/%.h:    $(ROOTXDIRI)/%.h
		cp $< $@

$(ROOTX):       $(ROOTXO)
		$(LD) $(LDFLAGS) -o $@ $(ROOTXO) $(XLIBS)

all-rootx:      $(ROOTX)

clean-rootx:
		@rm -f $(ROOTXO)

clean::         clean-rootx

distclean-rootx: clean-rootx
		@rm -f $(ROOTXDEP) $(ROOTX)

distclean::     distclean-rootx

##### extra rules ######
$(ROOTXO):      PCHCXXFLAGS =
