//echo.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roard/include/roard.h>

static int check_client(int client, struct roar_vio_calls * vio) {
 struct roar_buffer * buf;
 void * data;
 ssize_t len;

 ROAR_DBG("check_client(client=%i, vio=%p) = ?", client, vio);

 if ( roar_buffer_new_data(&buf, 1024, &data) == -1 )
  return -1;

 len = roar_vio_read(vio, data, 1024);

 if ( len < 1 ) {
  clients_delete(client);
  return -1;
 }

 if ( roar_buffer_set_len(buf, len) == -1 ) {
  roar_buffer_free(buf);
  clients_delete(client);
  return -1;
 }

 clients_add_output(client, buf);

 ROAR_DBG("check_client(client=%i, vio=%p) = 0", client, vio);
 return 0;
}


static struct roard_proto proto[1] = {
 {ROAR_PROTO_ECHO, NULL, check_client, NULL, NULL}
};

ROARD_DL_REG_PROTO(proto)

ROAR_DL_PLUGIN_START(roard_echo_protocol) {
 ROARD_DL_REGFN_PROTO();
} ROAR_DL_PLUGIN_END

//ll
