#ifndef _RHEOLEF_PRETTY_NAME_H
#define _RHEOLEF_PRETTY_NAME_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================

#include "rheolef/compiler.h"
#include <typeinfo>

namespace rheolef {

/*Class:man
NAME: @code{typename_macro}, @code{pretty_typename_macro} - type demangler and pretty printer
DESCRIPTION:
  These preprocessor macro-definitions are usefull when dealing with complex types
  as generated by imbricted template technics: they print in clear a complex type at run-time.
  @code{typeid_name_macro} obtains a human readable type in a @code{std::tring} form
  by calling the system @code{typeid} function and then a demangler.
  When this type is very long, @code{pretty_name_macro} prints also it in a multi-line
  form with a pretty indentation.
EXAMPLE:
 @example
  typedef map <size_t, double, less<size_t>, heap_allocator<pair<size_t,double> > >  map_type;
  cout << typeid_name_macro (map_type);
 @end example
AUTHORS:
    LJK-IMAG, 38041 Grenoble cedex 9, France
   | Pierre.Saramito@imag.fr
DATE: 15 december 2010
End:
*/
//<verbatim:
extern std::string typeid_name (const char* name, bool do_indent);

/// @brief get string from a type, with an optional pretty-printing for complex types
#define        typename_macro(T) typeid_name(typeid(T).name(), false)
#define pretty_typename_macro(T) typeid_name(typeid(T).name(), true)

/// @brief get string type from a variable or expression
template <class T> std::string        typename_of (T x) { return        typename_macro(T); }
template <class T> std::string pretty_typename_of (T x) { return pretty_typename_macro(T); }
//>verbatim:

} // namespace rheolef
#endif // _RHEOLEF_PRETTY_NAME_H
