///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// test of the solver
//
#include "rheolef/skit.h"
using namespace rheolef;
using namespace std;
int main (int argc, char **argv) { 
  environment distributed (argc, argv);
  communicator comm;
  double tol = 1e-7;

  // read the matrix
  csr<Float> a;
  dcin >> a;

  // convert csr a to csc trans(a) pastix format (with a transpose)
  solver_option_type opt;
  opt.verbose_level = 5;
  //opt.do_check      = 1; // BUG...?
  solver sa (a, opt); 

  // set x(dis_i) = dis_i
  vec<double> x_ex (a.row_ownership());
  for (size_t i = 0; i < x_ex .size(); i++) {
    x_ex [i] = i + x_ex .ownership().first_index();
  }
  // compute the rhs and solve
  vec<double> b = a*x_ex ;
  vec<double> x = sa.solve (b);

  // check the result
  double err = sqrt(dot (x-x_ex,x-x_ex));
  warning_macro ("error=|x-x_ex|="<< setprecision(15) << err);

  // build another matrix with the same sparse structure
  csr<double> a2 = a+a;
  sa.update_values (a2); 
  vec<double> b2 = a2*x_ex ;
  x = sa.solve (b2);
  double err2 = sqrt(dot (x-x_ex,x-x_ex));
  warning_macro ("error2=|x-x_ex|="<< setprecision(15) << err2);
  
  return max(err,err2) < tol ? 0 : 1;
}
