// usage: prog mesh Pk precond max_iter
#include "rheolef.h"
using namespace rheolef;
using namespace std;

const Float a = acos(Float(-1));
struct f : unary_function<point,Float> {
  Float operator() (const point& x) const {
   switch (d) {
    case 1 : return    sqr(a)*sin(a*x[0]);
    case 2 : return  2*sqr(a)*sin(a*x[0])*sin(a*x[1]); 
    default: return  3*sqr(a)*sin(a*x[0])*sin(a*x[1])*sin(a*x[2]); 
   }
  }
  f(size_t d1) : d(d1) {}
  size_t d;
};
struct u : unary_function<point,Float> {
  Float operator() (const point& x) const {
   switch (d) {
    case 1 : return  sin(a*x[0]); 
    case 2 : return  sin(a*x[0])*sin(a*x[1]); 
    default: return  sin(a*x[0])*sin(a*x[1])*sin(a*x[2]); 
   }
  }
  u(size_t d1) : d(d1) {}
  size_t d;
};
struct grad_u : unary_function<point,point> {
  point operator() (const point& x) const {
   switch (d) {
    case 1 : return  point(a*cos(a*x[0]));
    case 2 : return  point(a*cos(a*x[0])*sin(a*x[1]),
                           a*sin(a*x[0])*cos(a*x[1]));
    default: return  point(a*cos(a*x[0])*sin(a*x[1])*sin(a*x[2]),
                           a*sin(a*x[0])*cos(a*x[1])*sin(a*x[2]), 
                           a*sin(a*x[0])*sin(a*x[1])*cos(a*x[2])); 
   }
  }
  grad_u(size_t d1) : d(d1) {}
  size_t d;
};
int main(int argc, char**argv) {
    geo omega (argv[1]);
    string approx   = (argc > 2) ?      argv[2]  : "P1";
    string precond  = (argc > 3) ?      argv[3]  : "ic0";
    size_t max_iter = (argc > 4) ? atoi(argv[4]) : 10000;
    Float tol = 1e-15;
    size_t d = omega.dimension();
    space Vh (omega, argv[2]);
    Vh.block ("boundary");
    form a(Vh, Vh, "grad_grad");
    form m(Vh, Vh, "mass");
    field uh (Vh, 0);
    field fh = interpolate(Vh, f(d));
    if (precond != "ic0") {
      int status = pcg (a.uu, uh.u, (m*fh).u - a.ub*uh.b, EYE, max_iter, tol, &cout, "eye");
    } else {
      int status = pcg (a.uu, uh.u, (m*fh).u - a.ub*uh.b, ic0(a.uu), max_iter, tol, &cout, "ic0");
    }
    cerr << "n_el     = " << omega.size() << endl
         << "max_iter = " << max_iter << endl
         << "residue  = " << tol << endl
	;
    return (tol < 1e-10) ? 0 : 1;
}
