#ifndef _RHEOLEF_H
#define _RHEOLEF_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:rheolef
NAME: @code{rheolef} -- The finite element library (@PACKAGE@-@VERSION@)
DESCRIPTION:
  @noindent
  The @code{Rheolef} is a computer environment that serves as a
  convenient laboratory for computations involving
  finite element methods.
  It provides a set of unix commands and C++ algorithms and containers.
  In particular, this environment
  allows the user to express a partial derivative problem
  in terms of finite element @code{space},
  discrete @code{field}, bilinear @code{form},
  and @code{geo}, describing geometries and meshes.

  This set of data structure is completed by the most
  up-to-date algorithms:
  preconditioned solvers for incompressible elasticity,
  Stokes and Navier-Stokes flows, characteristic method
  for convection dominated heat problems,...

  The pdf file of the user's manual, with many examples,
  is located on your distribution in the documentation
  directory. This directory is given by the following unix command:
  @example
    rheolef-config --docdir
  @end example
  All examples presented along the user's manual
  are available in the @code{example/} directory of the
  @code{Rheolef} source distribution:
  the directory, where all source code of examples are available,
  is given by the following unix command:
  @example
    rheolef-config --exampledir
  @end example
SEE ALSO: "geo"(3), "space"(3)
AUTHORS:
   LMC-IMAG, 38041 Grenoble cedex 9, France
   Pierre.Saramito@imag.fr
DATE:   14 december 2010
End:
*/

// for simplicity: include alls
# include "rheolef/iorheo.h"
# include "rheolef/skit.h"
# include "rheolef/pcg.h"
# include "rheolef/eye.h"
# include "rheolef/geo.h"
# include "rheolef/geo_domain_indirect.h"
# include "rheolef/geo_domain.h"
# include "rheolef/field.h"
# include "rheolef/field_expr.h"
# include "rheolef/field_expr_ops.h"
# include "rheolef/form.h"
# include "rheolef/interpolate.h"

#endif // _RHEOLEF_H
