///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is sequential in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/geo_domain_indirect.h"

namespace rheolef {

template <class T, class M>
const distributor&
geo_domain_indirect_base_rep<T,M>::geo_element_ownership (size_type dim) const 
{
  if (dim == map_dimension()) return  _indirect.ownership();
  check_macro (dim  < map_dimension(), "unexpected dimension = " << dim << " > domain dimension = " << map_dimension());
  return _omega.geo_element_ownership(dim);
}
template <class T, class M>
typename geo_domain_indirect_base_rep<T,M>::const_reference
geo_domain_indirect_base_rep<T,M>::get_geo_element (size_type dim, size_type ige) const
{
  if (dim == map_dimension()) return  _omega.get_geo_element (dim, _indirect.oige(ige).index());
  check_macro (dim  < map_dimension(), "unexpected dimension = " << dim << " > domain dimension = " << map_dimension());
  return _omega.get_geo_element (dim, ige);
}
template <class T, class M>
typename geo_domain_indirect_base_rep<T,M>::const_iterator
geo_domain_indirect_base_rep<T,M>::begin (size_type dim) const
{
  error_macro ("domain.begin: not yet");
  return _omega.begin (dim); // (not reached) 
  // Note: here, not valid for dim=map_dimension ; requires a proxy_reference
}
template <class T, class M>
typename geo_domain_indirect_base_rep<T,M>::const_iterator
geo_domain_indirect_base_rep<T,M>::end (size_type dim) const
{
  error_macro ("domain.end: not yet");
  return _omega.end (dim); // (not reached) 
  // Note: here, not valid for dim=map_dimension ; requires a proxy_reference
}
template <class T, class M>
typename geo_domain_indirect_base_rep<T,M>::size_type
geo_domain_indirect_base_rep<T,M>::n_domain_indirect () const
{
  return 0;
}
template <class T, class M>
const domain_indirect_basic<M>&
geo_domain_indirect_base_rep<T,M>::get_domain_indirect (size_type i) const
{
  error_macro ("domain[domain] aka sub-sub-domain: not yet");
  return _indirect; // not reached
}
template <class T, class M>
const domain_indirect_basic<M>&
geo_domain_indirect_base_rep<T,M>::get_domain_indirect (const std::string& name) const
{
  error_macro ("domain[domain] aka sub-sub-domain: not yet");
  return _indirect; // not reached
}
template <class T, class M>
odiststream&
geo_domain_indirect_base_rep<T,M>::put (odiststream& ops) const
{
  error_macro ("domain.put: not yet");
  return ops;
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class geo_domain_indirect_base_rep<Float,sequential>;
#ifdef _RHEOLEF_HAVE_MPI
template class geo_domain_indirect_base_rep<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI
template class geo_domain_indirect_rep<Float,sequential>;

} // namespace rheolef
