#!/usr/bin/perl -w
# procress the output from refdbg and split it into separate logs per instance
# run sanity checks on each log

%logs=();

$logname="refdbg.log";
if(defined($ARGV[0])) { $logname=$ARGV[0]; }


# read log file
# build chunks for each object
open(LOGFILE, "$logname") or die("Could not open info log file: $logname.");
foreach $line (<LOGFILE>) {
    # do line-by-line processing.
    if ($line =~ m/^[A-Z].*\[0x([0-9a-fA-F]*)\].*/) {
        $obj=$1;
        if(!defined($logs{$obj})) {
            $logs{$obj}=[];
        }
    }
    push @{$logs{$obj}},$line;
}
close(LOGFILE);

print "Splitted $logname into ", scalar(keys(%logs)), " logs\n";

foreach $obj (keys(%logs)) {
    # run sanity checks on the events
    $ix=0;
    $ev_ref=0;
    $ev_unref=0;
    $ev_error=0;

    $ix_pre_new=-1;
    $ix_new=-1;
    $ix_pre_finalize=-1;
    $ix_finalize=-1;

    $status="okay";

    foreach $line (@{$logs{$obj}}) {
        if ($line =~ m/^([!A-Z_]*).*\[0x[0-9a-fA-F]*\].*/) {
            $event=$1;

            if ($event =~ m/^\!(.*)/) {
                $ev_error++;
                $event=$1
            }

            if ($event eq "REF") {
                $ev_ref++;
            } elsif ($event eq "UNREF") {
                $ev_unref++;
            } elsif ($event eq "PRE_NEW") {
                $ix_pre_new=$ix;
            } elsif ($event eq "NEW") {
                $ix_new=$ix;
            } elsif ($event eq "PRE_FINALIZE") {
                $ix_pre_finalize=$ix;
            } elsif ($event eq "FINALIZE") {
                $ix_finalize=$ix;
            }

            $ix++;
        }
    }

    # check ref/unref balance
    if ($ev_ref == $ev_unref) {
        $status_balance="okay";
    } else {
        $status_balance="FAIL";
        $status = "FAIL";
    }

    # check lifecycle order
    if (($ix_pre_new == 0) && ($ix_pre_new < $ix_new) &&
        ($ix_new < $ix_pre_finalize) && ($ix_pre_finalize < $ix_finalize) &&
        ($ix_finalize == ($ix-1))) {
        $status_lifecycle="okay";
    } else {
        $status_lifecycle="FAIL";
        $status = "FAIL";
    }

    # check for errors refdbg found
    if ($ev_error == 0) {
        $status_error="okay";
    } else {
        $status_error="FAIL";
        $status = "FAIL";
    }

    print "Processed $ix events in $logname.$status.$obj\n";
    print "  $status_balance: ref-balance: $ev_ref refs and $ev_unref\n";
    print "  $status_lifecycle: lifecycle: 0 == (pre-new: $ix_pre_new) < (new: $ix_new) < (pre-finalize: $ix_pre_finalize) < (finalize: $ix_finalize) == $ix-1\n";
    print "  $status_error: errors: $ev_error\n";

    open(LOGFILE, ">$logname.$status.$obj") or die("Could not open info log file: $logname.$status.$obj.");
    print LOGFILE @{$logs{$obj}};
    close(LOGFILE);
}

