/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: dlink.c,v 1.24.2.1 2004/12/07 03:05:09 pneumatus Exp $
 */

#include "struct.h"
#include "common.h"
#include "sys.h"
#include "h.h"
#include "numeric.h"
#include "setup.h"
#include "memory.h"
#include "hook.h"
#include "dlink.h"

BlockHeap *dlinknode_heap = NULL;

void dlink_init()
{
	dlinknode_heap = BlockHeapCreate(sizeof(dlink_node), DLINKNODE_HEAP_SIZE);
}

dlink_node *dlink_find(dlink_list *list, void *data)
{
	dlink_node *node;

	ASSERT(list != NULL);
	ASSERT(data != NULL);

	DLINK_FOREACH(list->head, node) {
		ASSERT(node != NULL);
		ASSERT(node->data != NULL);

		if (node->data == data) {
			return node;
		}
	}

	return NULL;
}

dlink_node *dlink_add(dlink_list *list, void *data)
{
	dlink_node *node;

	ASSERT(list != NULL);
	ASSERT(data != NULL);

	node = make_dlink_node();
	node->data = data;
	node->next = list->head;

	if (list->head != NULL) {
		list->head->prev = node;
	}
	else if (list->tail == NULL) {
		list->tail = node;
	}
	list->head = node;
	list->length++;

	return node;
}

dlink_node *dlink_add_node(dlink_list *list, dlink_node *node, void *data)
{
	ASSERT(list != NULL);
	ASSERT(node != NULL);
	ASSERT(data != NULL);

	node->data = data;
	node->next = list->head;
	node->prev = NULL;

	if (list->head != NULL) {
		list->head->prev = node;
	}
	else if (list->tail == NULL) {
		list->tail = node;
	}
	list->head = node;
	list->length++;

	return node;
}

dlink_node *dlink_add_tail(dlink_list *list, void *data)
{
	dlink_node *node = NULL;

	ASSERT(list != NULL);
	ASSERT(data != NULL);

	node = make_dlink_node();
	node->data = data;
	node->prev = list->tail;

	if (list->tail != NULL) {
		list->tail->next = node;
	}
	else if (list->head == NULL) {
		list->head = node;
	}
	list->tail = node;
	list->length++;

	return node;
}

void dlink_del(dlink_list *list, void *data, dlink_node *node_p)
{
	dlink_node *node = node_p;

	ASSERT(list != NULL);

	if (node == NULL) {
		node = dlink_find(list, data);
	}
	if (node != NULL) {
		if (node->next != NULL) {
			node->next->prev = node->prev;
		}
		else {
			list->tail = node->prev;
		}
		if (node->prev != NULL) {
			node->prev->next = node->next;
		}
		else {
			list->head = node->next;
		}
		list->length--;
		free_dlink_node(node);
	}
}

dlink_node *dlink_del_nofree(dlink_list *list, void *data, dlink_node *node_p)
{
	dlink_node *node = node_p;

	ASSERT(list != NULL);

	if (node == NULL) {
		node = dlink_find(list, data);
	}
	if (node != NULL) {
		if (node->next != NULL) {
			node->next->prev = node->prev;
		}
		else {
			list->tail = node->prev;
		}
		if (node->prev != NULL) {
			node->prev->next = node->next;
		}
		else {
			list->head = node->next;
		}
		list->length--;
		return node;
	}

	return NULL;
}
