/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_whois.c,v 1.56.2.3 2005/01/15 23:53:30 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "hook.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Hook *h_whois = NULL;

Module MOD_HEADER(m_whois) = {
	"m_whois",
	"/WHOIS command",
	6, "$Revision: 1.56.2.3 $"
};

int MOD_LOAD(m_whois)()
{
	if ((h_whois = register_hook(&MOD_HEADER(m_whois), "h_whois")) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(m_whois), &CMD_WHOIS, m_whois) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_whois)()
{
	return MOD_SUCCESS;
}

/*
 * m_whois
 *	parv[0] = sender prefix
 *	parv[1] = nickname list
 */
int m_whois(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr;
	aChannel *chptr;
	chanMember *cm;
	char *nick, *tmp, *name = NULL, *p = NULL, buf[BUFSIZE], *s;
	int found, len, mlen, showchan = 0;
	static time_t last_used = 0L;
	HookData hdata = HOOKDATA_INIT;

	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_simple && (last_used + FloodConfig.pace_wait_simple > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
	}
	if (parc < 2 || *parv[1] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "WHOIS");
		return 0;
	}
	if (parc > 2) {
		if (use_or_deliver(cptr, sptr, &CMD_WHOIS, "%s :%s", 1, parc, parv) != HUNTED_ISME) {
			return 0;
		}
		parv[1] = parv[2];
	}

	hdata.cptr = cptr;
	hdata.sptr = sptr;

	for (tmp = parv[1]; (nick = strtoken(&p, tmp, ",")); tmp = NULL) {
		found = 0;
		*buf = '\0';
		len = 0;

		if ((acptr = find_client(nick, NULL)) == NULL || !IsPerson(acptr)) {
			target_left(sptr, nick, MSG_WHOIS, NULL);
			continue;
		}
		name = *acptr->name != '\0' ? acptr->name : "?";

		send_me_numeric(sptr, RPL_WHOISUSER, name, acptr->username, MaskedHost(acptr),
			acptr->info);
		if (HasMode(sptr, UMODE_OPER) || (sptr == acptr)) {
			send_me_numeric(sptr, RPL_WHOISHOSTANDMODES, name, acptr->host,
				get_user_modes(acptr));
		}

		if (!IsULine(acptr)) {
			mlen = strlen(me.name) + strlen(sptr->name) + 6 + strlen(name);

			for (cm = acptr->user->channel; cm != NULL; cm = cm->nextchan) {
				chptr = cm->chptr;
				showchan = ShowChannel(sptr, chptr) ? 1 : 0;

				if (!showchan && !HasMode(sptr, UMODE_SADMIN)) {
					continue;
				}
				if (len + strlen(chptr->chname) > BUFSIZE - 4 - mlen) {
					send_me_numeric(sptr, RPL_WHOISCHANNELS, name, buf);
					*buf = '\0';
					len = 0;
				}

				if (len > 0) {
					*(buf + len++) = ' ';
				}

				if (!showchan) {
					*(buf + len++) = '!';
				}

				if (cm->flags & CMODE_CHANOP) {
					*(buf + len++) = '@';
				}
				else if (cm->flags & CMODE_HALFOP) {
					*(buf + len++) = '%';
				}
				else if (cm->flags & CMODE_VOICE) {
					*(buf + len++) = '+';
				}

				for (s = chptr->chname; *s != '\0'; s++) {
					*(buf + len++) = *s;
				}
				*(buf + len) = '\0';
			}
			if (len) {
				send_me_numeric(sptr, RPL_WHOISCHANNELS, name, buf);
				*buf = '\0';
				len = 0;
			}
		}

		send_me_numeric(sptr, RPL_WHOISSERVER, name, acptr->user->server,
			acptr->uplink != NULL ? acptr->uplink->info : "*NOT ON THIS NET*");
		if (HasMode(acptr, UMODE_REGNICK)) {
			send_me_numeric(sptr, RPL_WHOISREGNICK, name);
		}
		if (acptr->user->away != NULL) {
			send_me_numeric(sptr, RPL_AWAY, name, acptr->user->away);
		}
		
		if (HasMode(acptr, UMODE_NETADMIN)) {
			send_me_numeric(sptr, RPL_WHOISADMIN, name, "Network");
		}
		else if (HasMode(acptr, UMODE_ADMIN)) {
			send_me_numeric(sptr, RPL_WHOISADMIN, name, "Server");
		}
		else if (HasMode(acptr, UMODE_OPER)) {
			send_me_numeric(sptr, RPL_WHOISOPERATOR, name);
		}
		if (HasMode(acptr, UMODE_SADMIN)) {
			send_me_numeric(sptr, RPL_WHOISSADMIN, name);
		}

		if (HasMode(acptr, UMODE_SECURE)) {
			send_me_numeric(sptr, RPL_WHOISSECURE, name);
		}

		hdata.acptr = acptr;
		hook_run(h_whois, &hdata);

		if (MyConnect(acptr)) {
			send_me_numeric(sptr, RPL_WHOISIDLE, name,
				(timeofday - acptr->localUser->last), acptr->firsttime);
		}
	}

	send_me_numeric(sptr, RPL_ENDOFWHOIS, name);
	return 0;
}
