/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_wallops.c,v 1.20.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_wallops) = {
	"m_wallops",
	"/WALLOPS command",
	6, "$Revision: 1.20.2.2 $"
};

int MOD_LOAD(m_wallops)()
{
	if (register_command(&MOD_HEADER(m_wallops), &CMD_WALLOPS, m_wallops) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_wallops)()
{
	return MOD_SUCCESS;
}

/*
 * m_wallops
 *	parv[0] = sender prefix
 *	parv[1] = message
 */
int m_wallops(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (!IsServer(sptr) && MyConnect(sptr) && !OPHasFlag(sptr, OFLAG_WALLOPS)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 2 || *parv[1] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "WALLOPS");
		return 0;
	}

	send_wallops(sptr, "%s", parv[1]);
	sendto_serv_msg_butone(cptr, sptr, &CMD_WALLOPS, ":%s", parv[1]);

	return 0;
}
