/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_unsqline.c,v 1.28.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_unsqline) = {
	"m_unsqline",
	"/UNSQLINE command",
	6, "$Revision: 1.28.2.2 $"
};

int MOD_LOAD(m_unsqline)()
{
	if (register_command(&MOD_HEADER(m_unsqline), &CMD_UNSQLINE, m_unsqline) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_unsqline)()
{
	return MOD_SUCCESS;
}

/*
 * m_unsqline
 *	parv[0] = sender prefix
 *	parv[1] = nickname
 */
int m_unsqline(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	int matchit = 0;
	char *mask;

	if (!(IsServer(sptr) || IsULine(sptr))) {
		return 0;
	}
	if (parc < 2) {
		return 0;
	}

	if (parc == 3) {
		matchit = atoi(parv[1]);
		mask = parv[2];
	}
	else {
		mask = parv[1];
	}

	if (!mycmp(mask, "*") && matchit) {
		remove_simbans_match_mask(SBAN_NICK|BAN_NETWORK, mask, 1);
		remove_simbans_match_mask(SBAN_CHAN|BAN_NETWORK, mask, 1);
	}
	else if (*mask == '#') {
		remove_simbans_match_mask(SBAN_CHAN|BAN_NETWORK, mask, matchit);
	}
	else {
		remove_simbans_match_mask(SBAN_NICK|BAN_NETWORK, mask, matchit);
	}

	if (parc == 3) {
		sendto_serv_msg_butone(cptr, sptr, &CMD_UNSQLINE, "%d :%s", matchit, mask);
	}
	else {
		sendto_serv_msg_butone(cptr, sptr, &CMD_UNSQLINE, ":%s", mask);
	}

	return 0;
}
