/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_unkline.c,v 1.29.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_unkline) = {
	"m_unkline",
	"/UNKLINE command",
	6, "$Revision: 1.29.2.2 $"
};

int MOD_LOAD(m_unkline)()
{
	if (register_command(&MOD_HEADER(m_unkline), &CMD_UNKLINE, m_unkline) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_unkline)()
{
	return MOD_SUCCESS;
}

/*
 * m_unkline
 *	parv[0] = sender prefix
 *	parv[1] = mask
 */
int m_unkline(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *user, *host;
	userBan *myban, *uban;

	if (!OPHasFlag(sptr, OFLAG_UNKLINE)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 2 || BadPtr(parv[1])) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "UNKLINE");
		return 0;
	}
	if ((host = strchr(parv[1], '@')) != NULL) {
		user = parv[1];
		*host++ = '\0';
	}
	else {
		user = "*";
		host = parv[1];
	}

	if ((myban = make_userban(user, host, NULL, 0)) == NULL) {
		ircdlog(LOG_ERROR, "make_userban(%s,%s,-,0) failed in UNKLINE", user, host);
		return 0;
	}
	myban->flags |= (BAN_LOCAL|BAN_TEMPORARY);

	if ((uban = find_userban_exact(myban, 0)) == NULL) {
		send_me_notice(sptr, ":No k-lines matching %s@%s", user, host);
		userban_free(myban);
		return 0;
	}

	ircdlog(LOG_KILL, "%s removed k-line for %s@%s", sptr->name, uban->user, uban->host);
	sendto_realops("%s removed k-line for %s@%s", sptr->name, uban->user, uban->host);

	del_userban(uban);
	userban_free(uban);
	userban_free(myban);

	return 0;
}
