/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_svsnoop.c,v 1.24.2.2 2005/01/15 23:53:30 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_svsnoop) = {
	"m_svsnoop",
	"/SVSNOOP command",
	6, "$Revision: 1.24.2.2 $"
};

int MOD_LOAD(m_svsnoop)()
{
	if (register_command(&MOD_HEADER(m_svsnoop), &CMD_SVSNOOP, m_svsnoop) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_svsnoop)()
{
	return MOD_SUCCESS;
}

/*
 * m_svsnoop
 *	parv[0] = sender prefix
 *	parv[1] = server
 *	parv[2] = +/-
 */
int m_svsnoop(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	dlink_node *node, *next = NULL;
	ConfigItem_oper *oper = NULL;

	if (!IsULine(sptr) && parc < 2) {
		return 0;
	}
	if (use_or_deliver(cptr, sptr, &CMD_SVSNOOP, "%s :%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}

	if (*parv[2] != '+') {
		conf_rehash();
		return 0;
	}
	DLINK_FOREACH_SAFE_DATA(conf_oper_list.head, node, next, oper, ConfigItem_oper) {
		dlink_del(&conf_oper_list, NULL, node);
		free_oper(oper);
	}
	return 0;
}
