/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_sgline.c,v 1.23.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_sgline) = {
	"m_sgline",
	"/SGLINE command",
	6, "$Revision: 1.23.2.2 $"
};

int MOD_LOAD(m_sgline)()
{
	if (register_command(&MOD_HEADER(m_sgline), &CMD_SGLINE, m_sgline) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_sgline)()
{
	return MOD_SUCCESS;
}

int m_sgline(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	simBan *sban;
	int len;
	char *mask, *reason;

	if (!(IsServer(sptr) || IsULine(sptr))) {
		return 0;
	}
	if (parc < 3) {
		return 0;
	}

	len = atoi(parv[1]);
	mask = parv[2];
	if (strlen(mask) > len && (mask[len] == ':')) {
		mask[len] = '\0';
		reason = (mask + len) + 1;
	}
	else {
		return 0;
	}

	if ((sban = make_simban(mask, reason, 0, BAN_NETWORK|SBAN_GCOS)) == NULL) {
		ircdlog(LOG_ERROR, "make_simban(%s,%s,0,0) failed in SGLINE", mask, reason);
		return 0;
	}

	if (find_simban_exact(sban) == NULL) {
		add_simban(sban);
	}
	else {
		simban_free(sban);
	}

	sendto_serv_msg_butone(cptr, sptr, &CMD_SGLINE, "%d :%s:%s", len, mask, reason);

	return 0;
}
