/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_opermotd.c,v 1.21.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_opermotd) = {
	"m_opermotd",
	"/OPERMOTD command",
	6, "$Revision: 1.21.2.2 $"
};

int MOD_LOAD(m_opermotd)()
{
	if (register_command(&MOD_HEADER(m_opermotd), &CMD_OPERMOTD, m_opermotd) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_opermotd)()
{
	return MOD_SUCCESS;
}

/*
 * m_opermotd
 *	parv[0] = sender prefix
 *	parv[1] = server
 */
int m_opermotd(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (use_or_deliver(cptr, sptr, &CMD_OPERMOTD, ":%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}
	if (!HasMode(sptr, UMODE_OPER)) {
		if (MyClient(sptr)) {
			send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		}
		return 0;
	}

	send_message_file(sptr, opermotd);
	return 0;
}
