/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_links.c,v 1.30.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_links) = {
	"m_links",
	"/LINKS command",
	6, "$Revision: 1.30.2.2 $"
};

int MOD_LOAD(m_links)()
{
	if (register_command(&MOD_HEADER(m_links), &CMD_LINKS, m_links) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_links)()
{
	return MOD_SUCCESS;
}

/*
 * m_links
 *	parv[0] = sender prefix
 *	parv[1] = servername mask
 * OR
 *	parv[0] = sender prefix
 *	parv[1] = server to query
 *	parv[2] = servername mask
 */
int m_links(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	static time_t last_used = 0L;
	char *mask, *s, *d;
	char clean_mask[(2 * HOSTLEN) + 1];
	aClient *acptr;
	int n;

	if (IsServer(sptr) || (!HasMode(sptr, UMODE_OPER) && !MyConnect(sptr))) {
		return 0;
	}
	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_intense && (last_used + FloodConfig.pace_wait_intense > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
		if (GeneralConfig.spy_notices && IsPerson(sptr)) {
			sendto_realops_lev(SPY_LEV, "LINKS requested by %s (%s@%s)", sptr->name,
				sptr->username, MaskedHost(sptr));
		}
	}

	mask = parc < 2 ? NULL : parv[1];
	if (mask != NULL) {
		s = mask;
		d = clean_mask;
		n = (2 * HOSTLEN) - 2;

		while (*s && n > 0) {
			if ((unsigned char)*s < (unsigned char)' ') {
				*d++ = '^';
				*d++ = (char)((unsigned char)*s + 0x40);
				s++;
				n -= 2;
			}
			else if ((unsigned char)*s > (unsigned char)'~') {
				*d++ = '.';
				s++;
				n--;
			}
			else {
				*d++ = *s++;
				n--;
			}
		}
		*d = '\0';
	}

	collapse(mask);
	for (acptr = client; acptr != NULL; acptr = acptr->next) {
		if (!IsServer(acptr) && !IsMe(acptr)) {
			continue;
		}
		if (!BadPtr(mask) && match(mask, acptr->name)) {
			continue;
		}
		if (GeneralConfig.hide_super_servers && !HasMode(sptr, UMODE_OPER) && IsULine(acptr)) {
			continue;
		}
		if (GeneralConfig.flatten_links && !HasMode(sptr, UMODE_OPER) && !IsMe(acptr)) {
			send_me_numeric(sptr, RPL_LINKS, acptr->name, me.name, 1,
				(!BadPtr(acptr->info)) ? acptr->info : "(Unknown Location)");
		}
		else {
			send_me_numeric(sptr, RPL_LINKS, acptr->name, acptr->serv->up,
				acptr->hopcount, (!BadPtr(acptr->info)) ? acptr->info : "(Unknown Location)");
		}
	}
	send_me_numeric(sptr, RPL_ENDOFLINKS, BadPtr(mask) ? "*" : clean_mask);
	return 0;
}
