/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_gnotice.c,v 1.20.2.3 2005/01/15 23:53:30 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_gnotice) = {
	"m_gnotice",
	"GNOTICE protocol",
	6, "$Revision: 1.20.2.3 $"
};

int MOD_LOAD(m_gnotice)()
{
	if (register_command(&MOD_HEADER(m_gnotice), &CMD_GNOTICE, m_gnotice) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_gnotice)()
{
	return MOD_SUCCESS;
}

/*
 * m_gnotice
 *	parv[0] = sender prefix
 *	parv[1] = message
 */
int m_gnotice(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (!IsServer(sptr) && MyConnect(sptr)) {
		return 0;
	}
	if (parc < 2 || BadPtr(parv[1])) {
		if (MyClient(sptr)) {
			send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "GNOTICE");
		}
		return 0;
	}

	send_gnotice("from %s: %s", parv[0], parv[1]);
	sendto_serv_msg_butone(cptr, sptr, &CMD_GNOTICE, ":%s", parv[1]);

	return 0;
}
