/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: zlink.h,v 1.8.2.3 2005/05/06 22:57:42 amcwilliam Exp $
 */

#ifndef __zlink_h__
#define __zlink_h__

#include "setup.h"

#ifdef USE_ZLIB

#include <zlib.h>

#define ZIP_MIN_BLOCK		1024
#define ZIP_MAX_BLOCK		8192

#define ZIP_IN_SIZE		131072
#define ZIP_OUT_SIZE		(ZIP_MAX_BLOCK * 2)

typedef struct _ziplink_in ziplink_in;
typedef struct _ziplink_out ziplink_out;

struct _ziplink_in {
	z_stream stream;
};

struct _ziplink_out {
	z_stream stream;
	char buf[ZIP_MAX_BLOCK];
	int size;
};

extern void *zip_create_input_session();
extern char *zip_input(void *, char *, int *, int *, char **, int *);
extern void zip_in_get_stats(void *, unsigned long *, unsigned long *, double *);
extern void zip_destroy_input_session(void *);

extern void *zip_create_output_session();
extern char *zip_output(void *, char *, int *, int, int *);
extern void zip_out_get_stats(void *, unsigned long *, unsigned long *, double *);
extern void zip_destroy_output_session(void *);

#endif /* USE_ZLIB */

#endif /* __zlink_h__ */
