/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: isupport.h,v 1.20.2.1 2004/12/07 03:04:37 pneumatus Exp $
 */

#ifndef __isupport_include__
#define __isupport_include__

#include "conf2.h"
#include "xmode.h"

#define ISUPPORT_LINECNT	2
#define ISUPPORT_LINELEN	512

extern char isupport_buf[ISUPPORT_LINECNT][ISUPPORT_LINELEN];

/* STD is not sent because there is no RFC yet.
 * SILENCE, WATCH and ELIST are sent but not documented.
 */

#define FEATURES1	"CHANLIMIT=#&:%d" \
			" CHANMODES=%s" \
			" MAXLIST=b:%d,e:%d,I:%d" \
			" KICKLEN=%d" \
			" EXCEPTS" \
			" INVEX" \
			" MODES=%d" \
			" PREFIX=(ohv)@%%+" \
			" STATUSMSG=@%%+" \
			" SAFELIST" \
			" CASEMAPPING=ascii" \
			" NETWORK=%s" \
			" NICKLEN=%d"				/* Cur: 13, Max: 13 */

#define FEATURES2	"TOPICLEN=%d" \
			" TARGMAX=PRIVMSG:%d,NOTICE:%d" \
			" ELIST=MNUCT" \
			" WATCH=%d" \
			" SILENCE=%d"				/* Cur: 5, Max 13 */

#define VALUES1		GeneralConfig.max_chans_per_user, \
			chanmode_isupport, \
			GeneralConfig.max_bans, GeneralConfig.max_bans, GeneralConfig.max_bans, \
			TOPICLEN, \
			MAXMODEPARAMSUSER, \
			NetworkConfig.name_005, \
			NICKLEN

#define VALUES2		TOPICLEN, \
			GeneralConfig.max_targets, GeneralConfig.max_targets, \
			GeneralConfig.max_watch, \
			MAXSILES

#endif /* __isupport_include__ */
