/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: blalloc.h,v 1.14.2.2 2005/06/24 20:48:59 amcwilliam Exp $
 */

#ifndef __blalloc_include__
#define __blalloc_include__

#include "setup.h"
#include "dlink.h"
#include <stddef.h>

typedef struct _block_heap BlockHeap;
typedef struct _block Block;

struct _block_heap {
	size_t elemSize;
	int elemsPerBlock;
	int mapSize;
	int freeElems;
	dlink_node node;
	dlink_list block_list;
};

struct _block {
	void *elems;
	void *endElem;
	int freeElems;
	unsigned long *allocMap;
	dlink_node self;
};

extern void init_blockheap(int);
extern void blockheap_cleanup();

extern BlockHeap *BlockHeapCreate(size_t, int);
extern void BlockHeapDestroy(BlockHeap *);
extern void BlockHeapGarbageCollect(BlockHeap *);
extern void *BlockHeapALLOC(BlockHeap *);
extern void BlockHeapFREE(BlockHeap *, void *);
extern void BlockHeapUsage(BlockHeap *, int *, unsigned long *);

extern dlink_list heap_list;

extern BlockHeap *client_heap;
extern BlockHeap *localclient_heap;
extern BlockHeap *user_heap;
extern BlockHeap *localuser_heap;
extern BlockHeap *channel_heap;
extern BlockHeap *chanmember_heap;
extern BlockHeap *channelban_heap;
extern BlockHeap *slink_heap;
extern BlockHeap *dlinknode_heap;
#ifdef FLUD
extern BlockHeap *fludbot_heap;
#endif
#ifdef USE_THROTTLE
extern BlockHeap *throttle_heap;
extern BlockHeap *hashent_heap;
#endif
extern BlockHeap *connauth_heap;
extern BlockHeap *dnsquery_heap;
extern BlockHeap *ipentry_heap;

#endif /* __blalloc_include__ */
