%module r_util
%{
extern "C" {
#include <r_util.h>
}
#include <vector>
%}
%include <r_util.h>
%include "std_vector.i"


extern const char* r_str_rwx_i (int rwx);
extern char * r_file_slurp (const char* file, int* osz);
extern char * r_file_slurp_range (const char* file, unsigned long long off, int sz, int* osz);
extern int r_file_dump (const char* file, unsigned char* buf, int len);
extern char * r_file_basename (const char* path);
extern char * r_file_abspath (const char* path);
extern bool r_file_rm (const char* file);
extern bool r_file_exist (const char* file);
extern bool r_file_slurp_line (const char* file, int line, int ctx);
extern void r_log_msg (const char* str);
extern void r_log_error (const char* str);
extern void r_log_file (const char* str);
extern void r_log_progress (const char* str, int pc);
extern int r_hex_str2bin (const char* input, unsigned char* buf);
extern int r_hex_bin2str (unsigned char* buf, int len, char * str);
extern char * r_hex_bin2strdup (unsigned char* buf, int len);
extern int r_sys_sleep (int secs);
extern int r_sys_usleep (int usecs);
extern const char* r_sys_getenv (const char* key);
extern bool r_sys_setenv (const char* key, const char* val);
extern int r_sys_cmd (const char* command);
extern char * r_sys_cmd_str (const char* command, const char* input, int* len);
extern void r_sys_backtrace ();

%extend RStr {
  ~r_utilRStr() {
     (self);
  }
  static const char* rwx_i (int rwx) {
    return r_str_rwx_i (rwx);
  }
};
%extend RFile {
  ~r_utilRFile() {
    r_file_unref (self);
  }
  %apply int* OUTPUT { int* osz };
  static char * slurp (const char* file, int* osz) {
    return r_file_slurp (file, osz);
  }
  %clear int* osz;
  %apply int* OUTPUT { int* osz };
  static char * slurp_range (const char* file, unsigned long long off, int sz, int* osz) {
    return r_file_slurp_range (file, off, sz, osz);
  }
  %clear int* osz;
  static int dump (const char* file, unsigned char* buf, int len) {
    return r_file_dump (file, buf, len);
  }
  static char * basename (const char* path) {
    return r_file_basename (path);
  }
  static char * abspath (const char* path) {
    return r_file_abspath (path);
  }
  static bool rm (const char* file) {
    return r_file_rm (file);
  }
  static bool exist (const char* file) {
    return r_file_exist (file);
  }
  static bool slurp_line (const char* file, int line, int ctx) {
    return r_file_slurp_line (file, line, ctx);
  }
};
%extend RLog {
  ~r_utilRLog() {
    r_log_unref (self);
  }
  static void msg (const char* str) {
     r_log_msg (str);
  }
  static void error (const char* str) {
     r_log_error (str);
  }
  static void file (const char* str) {
     r_log_file (str);
  }
  static void progress (const char* str, int pc) {
     r_log_progress (str, pc);
  }
};
%extend RHex {
  ~r_utilRHex() {
    r_hex_unref (self);
  }
  static int str2bin (const char* input, unsigned char* buf) {
    return r_hex_str2bin (input, buf);
  }
  %apply char * OUTPUT { char * str };
  static int bin2str (unsigned char* buf, int len, char * str) {
    return r_hex_bin2str (buf, len, str);
  }
  %clear char * str;
  static char * bin2strdup (unsigned char* buf, int len) {
    return r_hex_bin2strdup (buf, len);
  }
};
%extend RSystem {
  ~r_utilRSystem() {
    r_sys_unref (self);
  }
  static int sleep (int secs) {
    return r_sys_sleep (secs);
  }
  static int usleep (int usecs) {
    return r_sys_usleep (usecs);
  }
  static const char* getenv (const char* key) {
    return r_sys_getenv (key);
  }
  static bool setenv (const char* key, const char* val) {
    return r_sys_setenv (key, val);
  }
  static int _cmd (const char* command) {
    return r_sys_cmd (command);
  }
  %apply int* OUTPUT { int* len };
  static char * cmd_str (const char* command, const char* input, int* len) {
    return r_sys_cmd_str (command, input, len);
  }
  %clear int* len;
  static void backtrace () {
     r_sys_backtrace ();
  }
};
%extend RNum {
  ~r_utilRNum() {
     (self);
  }
  RNum (RNumCallback cb, void* user) {
    return r_num_new (cb, user);
  }
  unsigned long long get (const char* str) {
    return r_num_get (self, str);
  }
  unsigned long long math (const char* str) {
    return r_num_math (self, str);
  }
};
%extend RBuffer {
  ~r_utilRBuffer() {
    r_buf_free (self);
  }
  RBuffer () {
    return r_buf_new ();
  }
  int read_at (unsigned long long addr, unsigned char* buf, int len) {
    return r_buf_read_at (self, addr, buf, len);
  }
  int write_at (unsigned long long addr, unsigned char* buf, int len) {
    return r_buf_write_at (self, addr, buf, len);
  }
  bool set_bytes (unsigned char* buf, int len) {
    return r_buf_set_bytes (self, buf, len);
  }
};
%extend RRange {
  ~r_utilRRange() {
    r_range_free (self);
  }
  RRange () {
    return r_range_new ();
  }
  RRange (const char* str) {
    return r_range_new_from_string (str);
  }
  struct r_range_item_t* item_get (unsigned long long addr) {
    return r_range_item_get (self, addr);
  }
  unsigned long long size () {
    return r_range_size (self);
  }
  unsigned long long add_from_string (const char* str) {
    return r_range_add_from_string (self, str);
  }
  bool contains (unsigned long long addr) {
    return r_range_contains (self, addr);
  }
  bool sort () {
    return r_range_sort (self);
  }
  bool list (bool rad) {
    return r_range_list (self, rad);
  }
  %apply unsigned long long* OUTPUT { unsigned long long* fr };
  %apply unsigned long long* OUTPUT { unsigned long long* to };
  bool get_n (int n, unsigned long long* fr, unsigned long long* to) {
    return r_range_get_n (self, n, fr, to);
  }
  %clear unsigned long long* fr;
  %clear unsigned long long* to;
  struct r_range_t* inverse (unsigned long long fr, unsigned long long to, int flags) {
    return r_range_inverse (self, fr, to, flags);
  }
};
%extend RRange {
  ~r_utilRRange() {
    r_range_free (self);
  }
  RRange () {
    return r_range_new ();
  }
  RRange (const char* str) {
    return r_range_new_from_string (str);
  }
  struct r_range_item_t* item_get (unsigned long long addr) {
    return r_range_item_get (self, addr);
  }
  unsigned long long size () {
    return r_range_size (self);
  }
  unsigned long long add_from_string (const char* str) {
    return r_range_add_from_string (self, str);
  }
  bool contains (unsigned long long addr) {
    return r_range_contains (self, addr);
  }
  bool sort () {
    return r_range_sort (self);
  }
  bool list (bool rad) {
    return r_range_list (self, rad);
  }
  %apply unsigned long long* OUTPUT { unsigned long long* fr };
  %apply unsigned long long* OUTPUT { unsigned long long* to };
  bool get_n (int n, unsigned long long* fr, unsigned long long* to) {
    return r_range_get_n (self, n, fr, to);
  }
  %clear unsigned long long* fr;
  %clear unsigned long long* to;
  struct r_range_t* inverse (unsigned long long fr, unsigned long long to, int flags) {
    return r_range_inverse (self, fr, to, flags);
  }
};

