// evaljit1.c
//
// R : A Computer Language for Statistical Data Analysis
// Copyright (C) 1995, 1996    Robert Gentleman and Ross Ihaka
// Copyright (C) 1998--2006    The R Development Core Team.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, a copy is available at
// http://www.r-project.org/Licenses/

case JIT_endop:
    goto done;

case JIT_push:
    incStack(p);
    TOS = op->operand;
    break;

case JIT_pushsym:
    pushSym(op, p);
    break;

case JIT_uminus_r:
    result = op->result; DCheckUminus(result, REALSXP);
    ar = REAL(op->result); xr = TOSR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = -xr[i];
    TOS = op->result;
    break;

case JIT_uminus_r1:
    result = op->result; DCheckUminus1(result, REALSXP);
    REAL(result)[0] = -TOSR[0]; TOS = result;
    break;

case JIT_uminus_i:
    result = op->result; DCheckUminus(result, INTSXP);
    ai = INTEGER(result); xi = TOSI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = -xi[i];
    TOS = result;
    break;

case JIT_uminus_i1:
    result = op->result; DCheckUminus1(result, INTSXP);
    INTEGER(result)[0] = -TOSI[0]; TOS = result;
    break;

case JIT_not_r:
    result = op->result; DCheckNot(result, REALSXP);
    ai = LOGICAL(result); xr = TOSR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr[i] == 0);
    TOS = result;
    break;

case JIT_not_r1:
    result = op->result; DCheckNot1(result, REALSXP);
    LOGICAL(result)[0] = (TOSR[0] == 0);
    TOS = result;
    break;

case JIT_not_i:
    result = op->result; DCheckNot(result, INTSXP);
    ai = LOGICAL(result); xi = TOSI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi[i] == 0);
    TOS = result;
    break;

case JIT_not_i1:
    result = op->result; DCheckNot1(result, INTSXP);
    LOGICAL(result)[0] = (TOSI[0] == 0); TOS = result;
    break;

case JIT_math1_r:
    result = op->result; DCheckMath1(result, REALSXP, REALSXP);
    ar = REAL(result); xr = TOSR; n = LENGTH(result); func = op->func;
    for (i = 0; i < n; i++) ar[i] = func(xr[i]);
    stack[istack] = result;
    break;

case JIT_math1_r1:
    result = op->result; DCheckMath1_1(result, REALSXP, REALSXP);
    REAL(result)[0] = (op->func)(TOSR[0]);
    stack[istack] = result;
    break;

case JIT_math1_i:
    result = op->result; DCheckMath1(result, INTSXP, REALSXP);
    ar = REAL(result); xi = TOSI; n = LENGTH(result); func = op->func;
    for (i = 0; i < n; i++) ar[i] = func((double)xi[i]);
    stack[istack] = result;
    break;

case JIT_math1_i1:
    result = op->result; DCheckMath1_1(result, INTSXP, REALSXP);
    REAL(result)[0] = (op->func)((double)TOSI[0]);
    stack[istack] = result;
    break;

case JIT_math1i_r:
    result = op->result; DCheckMath1(result, REALSXP, INTSXP);
    ai = INTEGER(result); xr = TOSR; n = LENGTH(result); ifunc = op->ifunc;
    for (i = 0; i < n; i++) ai[i] = ifunc(xr[i]);
    stack[istack] = result;
    break;

case JIT_math1i_r1:
    result = op->result; DCheckMath1_1(result, REALSXP, INTSXP);
    INTEGER(result)[0] = (op->ifunc)(TOSR[0]);
    stack[istack] = result;
    break;

case JIT_math1i_i:
    result = op->result; DCheckMath1(result, INTSXP, INTSXP);
    ai = INTEGER(result); xi = TOSI; n = LENGTH(result); ifunc = op->ifunc;
    for (i = 0; i < n; i++) ai[i] = ifunc(xi[i]);
    stack[istack] = result;
    break;

case JIT_math1i_i1:
    result = op->result; DCheckMath1_1(result, INTSXP, INTSXP);
    INTEGER(result)[0] = (op->ifunc)(TOSI[0]);
    stack[istack] = result;
    break;

case JIT_eval:
    TOS = eval(op->operand, op->env);
    if (TYPEOF(op->operand) == JITSXP)
        op->opcode = JIT_evaljit;           // self modifying
    break;

case JIT_evaljit:
    TOS = evalJit(op->operand);
    break;

case JIT_if_i:
    DCheckIf(op, INTSXP);
    op++;
    if (INTEGER(stack[istack])[0]) {
        if (TYPEOF(op->operand) == JITSXP) {
            TOS = evalJit(op->operand);
        } else
            TOS = eval(op->operand, op->env);
    } else
        TOS = RNIL;
    break;

case JIT_ifelse_i:
    DCheckIf(op, INTSXP);
    if (INTEGER(stack[istack])[0]) {
        if (TYPEOF((op+1)->operand) == JITSXP)
            TOS = evalJit((op+1)->operand);
        else
            TOS = eval((op+1)->operand, (op+1)->env);
    } else {
        if (TYPEOF((op+2)->operand) == JITSXP)
            TOS = evalJit((op+2)->operand);
        else
            TOS = eval((op+2)->operand, (op+2)->env);
    }
    op += 2;
    break;

case JIT_if_r:
    DCheckIf(op, REALSXP);
    op++;
    if (REAL(stack[istack])[0]) {
        if (TYPEOF(op->operand) == JITSXP)
            TOS = evalJit(op->operand);
        else
            TOS = eval(op->operand, op->env);
    } else
        TOS = RNIL;
    break;

case JIT_ifelse_r:
    DCheckIf(op, REALSXP);
    if (REAL(stack[istack])[0]) {
        if (TYPEOF((op+1)->operand) == JITSXP)
            TOS = evalJit((op+1)->operand);
        else
            TOS = eval((op+1)->operand, (op+1)->env);
    } else {
        if (TYPEOF((op+2)->operand) == JITSXP)
            TOS = evalJit((op+2)->operand);
        else
            TOS = eval((op+2)->operand, (op+2)->env);
    }
    op += 2;
    break;

case JIT_for_i:
    evalJitFor(op);
    op += 2;
    break;

// x[subset]: TOS1 X is x, TOS Y is subset

case JIT_subset_r_i1:
    result = op->result; DCheckSubscript_x_y1(REALSXP, INTSXP, result);
    yi0 = YI[0] - 1; CheckSubscriptRange_i(X, yi0, p);
    xr0 = XR[yi0];  X = result; *REAL(stack[--istack]) = xr0;
    break;

case JIT_subset_r_r1:
    result = op->result; DCheckSubscript_x_y1(REALSXP, REALSXP, result);
    yr0 = YR[0] - 1; CheckSubscriptRange_r(X, yr0, p);
    xr0 = XR[(int)yr0]; X = result; *REAL(stack[--istack]) = xr0;
    break;

case JIT_subset_i_i1:
    result = op->result; DCheckSubscript_x_y1(INTSXP, INTSXP, result);
    yi0 = YI[0] - 1; CheckSubscriptRange_i(X, yi0, p);
    xi0 = XI[yi0];  X = result; *INTEGER(stack[--istack]) = xi0;
    break;

case JIT_subset_i_r1:
    result = op->result; DCheckSubscript_x_y1(INTSXP, REALSXP, result);
    yr0 = YR[0] - 1; CheckSubscriptRange_r(X, yr0, p);
    xi0 = XI[(int)yr0]; X = result; *INTEGER(stack[--istack]) = xi0;
    break;

// Assign op->operand (which is a binding location) to TOS.
// RA_TODO All these assigns could be conflated, but then will lose Dchecks.

case JIT_as_r1_r1:
    evalJitAs(op, REALSXP, REALSXP, 1);
    break;

case JIT_as_i1_i1:
    evalJitAs(op, INTSXP, INTSXP, 1);
    break;

case JIT_as_r_r:
    evalJitAs(op, REALSXP, REALSXP, -1);
    break;

case JIT_as_i_i:
    evalJitAs(op, INTSXP, INTSXP, -1);
    break;

// subassign i.e.    x[index] = y
// opcode naming is: x_index_y
// but stack is:     y x index
//
// RA_TODO named handling?

case JIT_subas_r_r1_r:
    DCheckSubas(TOS1, TOS, TOS2, REALSXP, REALSXP, REALSXP, op->result, p);
    r = REAL(TOS)[0] - 1; CheckSubscriptRange_r(TOS1, r, p);
    xr = REAL(TOS1); xr[(int)r] = REAL(TOS2)[0]; // update x
    REAL(op->result)[0] = REAL(TOS2)[0];         // update return value
    drop2(p); TOS = op->result;
    break;

case JIT_subas_r_r1_i:
    DCheckSubas(TOS1, TOS, TOS2, REALSXP, REALSXP, INTSXP, op->result, p);
    r = REAL(TOS)[0] - 1; CheckSubscriptRange_r(TOS1, r, p);
    xr = REAL(TOS1); xr[(int)r] = INTEGER(TOS2)[0];
    REAL(op->result)[0] = INTEGER(TOS2)[0];
    drop2(p); TOS = op->result;
    break;

case JIT_subas_r_i1_r:
    DCheckSubas(TOS1, TOS, TOS2, REALSXP, INTSXP, REALSXP, op->result, p);
    i = INTEGER(TOS)[0] - 1; CheckSubscriptRange_i(TOS1, i, p);
    xr = REAL(TOS1); xr[i] = REAL(TOS2)[0];
    REAL(op->result)[0] = REAL(TOS2)[0];
    drop2(p); TOS = op->result;
    break;

case JIT_subas_r_i1_i:
    DCheckSubas(TOS1, TOS, TOS2, REALSXP, INTSXP,INTSXP, op->result, p);
    i = INTEGER(TOS)[0] - 1; CheckSubscriptRange_i(TOS1, i, p);
    xr = REAL(TOS1); xr[i] = INTEGER(TOS2)[0];
    REAL(op->result)[0] = INTEGER(TOS2)[0];
    drop2(p); TOS = op->result;
    break;

case JIT_subas_i_r1_r:
    DCheckSubas(TOS1, TOS, TOS2, INTSXP,REALSXP, REALSXP, op->result, p);
    r = REAL(TOS)[0] - 1; CheckSubscriptRange_r(TOS1, r, p);
    xi = INTEGER(TOS1); xi[(int)r] = REAL(TOS2)[0];
    INTEGER(op->result)[0] = (int)(REAL(TOS2)[0]);
    drop2(p); TOS = op->result;
    break;

case JIT_subas_i_r1_i:
    DCheckSubas(TOS1, TOS, TOS2, INTSXP,REALSXP, INTSXP, op->result, p);
    r = REAL(TOS)[0] - 1; CheckSubscriptRange_r(TOS1, r, p);
    xi = INTEGER(TOS1); xi[(int)r] = INTEGER(TOS2)[0];
    INTEGER(op->result)[0] = INTEGER(TOS2)[0];
    drop2(p); TOS = op->result;
    break;

case JIT_subas_i_i1_r:
    DCheckSubas(TOS1, TOS, TOS2, INTSXP,INTSXP,REALSXP, op->result, p);
    i = INTEGER(TOS)[0] - 1; CheckSubscriptRange_i(TOS1, i, p);
    xi = INTEGER(TOS1); xi[i] = REAL(TOS2)[0];
    INTEGER(op->result)[0] = (int)(REAL(TOS2)[0]);
    drop2(p); TOS = op->result;
    break;

case JIT_subas_i_i1_i:
    DCheckSubas(TOS1, TOS, TOS2, INTSXP,INTSXP,INTSXP, op->result, p);
    i = INTEGER(TOS)[0] - 1; CheckSubscriptRange_i(TOS1, i, p);
    xi = INTEGER(TOS1); xi[i] = INTEGER(TOS2)[0];
    INTEGER(op->result)[0] = INTEGER(TOS2)[0];
    drop2(p); TOS = op->result;
    break;

case JIT_add_r_r:
    result = op->result; DCheckBinop_x_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] + yr[i]; stack[--istack] = result;
    break;

case JIT_add_r_r1:
    result = op->result; DCheckBinop_x_y1(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] + yr0;   stack[--istack] = result;
    break;

case JIT_add_r1_r:
    result = op->result; DCheckBinop_x1_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr0 + yr[i];   stack[--istack] = result;
    break;

case JIT_add_r1_r1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, REALSXP, result);
    REAL(result)[0] = XR[0] + YR[0];               stack[--istack] = result;
    break;

case JIT_add_r_i:
    result = op->result; DCheckBinop_x_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] + yi[i]; stack[--istack] = result;
    break;

case JIT_add_r_i1:
    result = op->result; DCheckBinop_x_y1(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] + yi0;   stack[--istack] = result;
    break;

case JIT_add_r1_i:
    result = op->result; DCheckBinop_x1_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr0 + yi[i];   stack[--istack] = result;
    break;

case JIT_add_r1_i1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, INTSXP, result);
    REAL(result)[0] = XR[0] + YI[0];               stack[--istack] = result;
    break;

case JIT_add_i_r:
    result = op->result; DCheckBinop_x_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi[i] + yr[i]; stack[--istack] = result;
    break;

case JIT_add_i_r1:
    result = op->result; DCheckBinop_x_y1(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi[i] + yr0;   stack[--istack] = result;
    break;

case JIT_add_i1_r:
    result = op->result; DCheckBinop_x1_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi0 + yr[i];   stack[--istack] = result;
    break;

case JIT_add_i1_r1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, REALSXP, result);
    REAL(result)[0] = XI[0] + YR[0];               stack[--istack] = result;
    break;

case JIT_add_i_i:
    result = op->result; DCheckBinop_x_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi[i] + yi[i]; stack[--istack] = result;
    break;

case JIT_add_i_i1:
    result = op->result; DCheckBinop_x_y1(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi[i] + yi0;   stack[--istack] = result;
    break;

case JIT_add_i1_i:
    result = op->result; DCheckBinop_x1_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi0 + yi[i];   stack[--istack] = result;
    break;

case JIT_add_i1_i1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, INTSXP, result);
    INTEGER(result)[0] = XI[0] + YI[0];            stack[--istack] = result;
    break;

case JIT_sub_r_r:
    result = op->result; DCheckBinop_x_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] - yr[i]; stack[--istack] = result;
    break;

case JIT_sub_r_r1:
    result = op->result; DCheckBinop_x_y1(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] - yr0;   stack[--istack] = result;
    break;

case JIT_sub_r1_r:
    result = op->result; DCheckBinop_x1_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr0 - yr[i];   stack[--istack] = result;
    break;

case JIT_sub_r1_r1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, REALSXP, result);
    REAL(result)[0] = XR[0] - YR[0];               stack[--istack] = result;
    break;

case JIT_sub_r_i:
    result = op->result; DCheckBinop_x_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] - yi[i]; stack[--istack] = result;
    break;

case JIT_sub_r_i1:
    result = op->result; DCheckBinop_x_y1(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] - yi0;   stack[--istack] = result;
    break;

case JIT_sub_r1_i:
    result = op->result; DCheckBinop_x1_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr0 - yi[i];   stack[--istack] = result;
    break;

case JIT_sub_r1_i1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, INTSXP, result);
    REAL(result)[0] = XR[0] - YI[0];               stack[--istack] = result;
    break;

case JIT_sub_i_r:
    result = op->result; DCheckBinop_x_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi[i] - yr[i]; stack[--istack] = result;
    break;

case JIT_sub_i_r1:
    result = op->result; DCheckBinop_x_y1(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi[i] - yr0;   stack[--istack] = result;
    break;

case JIT_sub_i1_r:
    result = op->result; DCheckBinop_x1_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi0 - yr[i];   stack[--istack] = result;
    break;

case JIT_sub_i1_r1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, REALSXP, result);
    REAL(result)[0] = XI[0] - YR[0];               stack[--istack] = result;
    break;

case JIT_sub_i_i:
    result = op->result; DCheckBinop_x_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi[i] - yi[i]; stack[--istack] = result;
    break;

case JIT_sub_i_i1:
    result = op->result; DCheckBinop_x_y1(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi[i] - yi0;   stack[--istack] = result;
    break;

case JIT_sub_i1_i:
    result = op->result; DCheckBinop_x1_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi0 - yi[i];   stack[--istack] = result;
    break;

case JIT_sub_i1_i1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, INTSXP, result);
    INTEGER(result)[0] = XI[0] - YI[0];            stack[--istack] = result;
    break;

case JIT_mul_r_r:
    result = op->result; DCheckBinop_x_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] * yr[i]; stack[--istack] = result;
    break;

case JIT_mul_r_r1:
    result = op->result; DCheckBinop_x_y1(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] * yr0;   stack[--istack] = result;
    break;

case JIT_mul_r1_r:
    result = op->result; DCheckBinop_x1_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr0 * yr[i];   stack[--istack] = result;
    break;

case JIT_mul_r1_r1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, REALSXP, result);
    REAL(result)[0] = XR[0] * YR[0];               stack[--istack] = result;
    break;

case JIT_mul_r_i:
    result = op->result; DCheckBinop_x_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] * yi[i]; stack[--istack] = result;
    break;

case JIT_mul_r_i1:
    result = op->result; DCheckBinop_x_y1(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] * yi0;   stack[--istack] = result;
    break;

case JIT_mul_r1_i:
    result = op->result; DCheckBinop_x1_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr0 * yi[i];   stack[--istack] = result;
    break;

case JIT_mul_r1_i1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, INTSXP, result);
    REAL(result)[0] = XR[0] * YI[0];               stack[--istack] = result;
    break;

case JIT_mul_i_r:
    result = op->result; DCheckBinop_x_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi[i] * yr[i]; stack[--istack] = result;
    break;

case JIT_mul_i_r1:
    result = op->result; DCheckBinop_x_y1(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi[i] * yr0;   stack[--istack] = result;
    break;

case JIT_mul_i1_r:
    result = op->result; DCheckBinop_x1_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi0 * yr[i];   stack[--istack] = result;
    break;

case JIT_mul_i1_r1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, REALSXP, result);
    REAL(result)[0] = XI[0] * YR[0];               stack[--istack] = result;
    break;

case JIT_mul_i_i:
    result = op->result; DCheckBinop_x_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi[i] * yi[i]; stack[--istack] = result;
    break;

case JIT_mul_i_i1:
    result = op->result; DCheckBinop_x_y1(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi[i] * yi0;   stack[--istack] = result;
    break;

case JIT_mul_i1_i:
    result = op->result; DCheckBinop_x1_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = xi0 * yi[i];   stack[--istack] = result;
    break;

case JIT_mul_i1_i1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, INTSXP, result);
    INTEGER(result)[0] = XI[0] * YI[0];            stack[--istack] = result;
    break;

case JIT_div_r_r:
    result = op->result; DCheckBinop_x_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] / yr[i]; stack[--istack] = result;
    break;

case JIT_div_r_r1:
    result = op->result; DCheckBinop_x_y1(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] / yr0;   stack[--istack] = result;
    break;

case JIT_div_r1_r:
    result = op->result; DCheckBinop_x1_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr0 / yr[i];   stack[--istack] = result;
    break;

case JIT_div_r1_r1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, REALSXP, result);
    REAL(result)[0] = XR[0] / YR[0];               stack[--istack] = result;
    break;

case JIT_div_r_i:
    result = op->result; DCheckBinop_x_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] / yi[i]; stack[--istack] = result;
    break;

case JIT_div_r_i1:
    result = op->result; DCheckBinop_x_y1(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr[i] / yi0;   stack[--istack] = result;
    break;

case JIT_div_r1_i:
    result = op->result; DCheckBinop_x1_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xr0 / yi[i];   stack[--istack] = result;
    break;

case JIT_div_r1_i1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, INTSXP, result);
    REAL(result)[0] = XR[0] / YI[0];               stack[--istack] = result;
    break;

case JIT_div_i_r:
    result = op->result; DCheckBinop_x_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi[i] / yr[i]; stack[--istack] = result;
    break;

case JIT_div_i_r1:
    result = op->result; DCheckBinop_x_y1(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi[i] / yr0;   stack[--istack] = result;
    break;

case JIT_div_i1_r:
    result = op->result; DCheckBinop_x1_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = xi0 / yr[i];   stack[--istack] = result;
    break;

case JIT_div_i1_r1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, REALSXP, result);
    REAL(result)[0] = XI[0] / YR[0];               stack[--istack] = result;
    break;

// begin unsual code: return REAL even though args are INTs, same as arithmetic.c
case JIT_div_i_i:
    result = op->result; DCheckBinop_x_y(INTSXP, INTSXP, result);
    ar = REAL(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = (double)xi[i] / yi[i]; stack[--istack] = result;
    break;

case JIT_div_i_i1:
    result = op->result; DCheckBinop_x_y1(INTSXP, INTSXP, result);
    ar = REAL(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = (double)xi[i] / yi0;   stack[--istack] = result;
    break;

case JIT_div_i1_i:
    result = op->result; DCheckBinop_x1_y(INTSXP, INTSXP, result);
    ar = REAL(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = (double)xi0 / yi[i];   stack[--istack] = result;
    break;

case JIT_div_i1_i1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, INTSXP, result);
    REAL(result)[0] = (double)XI[0] / YI[0];               stack[--istack] = result;
    break;
// end unusual code

case JIT_pow_r_r:
    result = op->result; DCheckBinop_x_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xr[i], yr[i]); stack[--istack] = result;
    break;

case JIT_pow_r_r1:
    result = op->result; DCheckBinop_x_y1(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xr[i], yr0);   stack[--istack] = result;
    break;

case JIT_pow_r1_r:
    result = op->result; DCheckBinop_x1_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xr0, yr[i]);   stack[--istack] = result;
    break;

case JIT_pow_r1_r1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, REALSXP, result);
    REAL(result)[0] = pow(XR[0], YR[0]);               stack[--istack] = result;
    break;

case JIT_pow_r_i:
    result = op->result; DCheckBinop_x_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xr[i], yi[i]); stack[--istack] = result;
    break;

case JIT_pow_r_i1:
    result = op->result; DCheckBinop_x_y1(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xr[i], yi0);   stack[--istack] = result;
    break;

case JIT_pow_r1_i:
    result = op->result; DCheckBinop_x1_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xr0, yi[i]);   stack[--istack] = result;
    break;

case JIT_pow_r1_i1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, INTSXP, result);
    REAL(result)[0] = pow(XR[0], YI[0]);               stack[--istack] = result;
    break;

case JIT_pow_i_r:
    result = op->result; DCheckBinop_x_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xi[i], yr[i]); stack[--istack] = result;
    break;

case JIT_pow_i_r1:
    result = op->result; DCheckBinop_x_y1(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xi[i], yr0);   stack[--istack] = result;
    break;

case JIT_pow_i1_r:
    result = op->result; DCheckBinop_x1_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xi0, yr[i]);   stack[--istack] = result;
    break;

case JIT_pow_i1_r1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, REALSXP, result);
    REAL(result)[0] = pow(XI[0], YR[0]);               stack[--istack] = result;
    break;

// begin unsual code: return REAL even though args are INTs, same as arithmetic.c
case JIT_pow_i_i:
    result = op->result; DCheckBinop_x_y(INTSXP, INTSXP, result);
    ar = REAL(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xi[i], yi[i]); stack[--istack] = result;
    break;

case JIT_pow_i_i1:
    result = op->result; DCheckBinop_x_y1(INTSXP, INTSXP, result);
    ar = REAL(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xi[i], yi0);   stack[--istack] = result;
    break;

case JIT_pow_i1_i:
    result = op->result; DCheckBinop_x1_y(INTSXP, INTSXP, result);
    ar = REAL(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = pow(xi0, yi[i]);   stack[--istack] = result;
    break;

case JIT_pow_i1_i1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, INTSXP, result);
    REAL(result)[0] = pow(XI[0], YI[0]);               stack[--istack] = result;
    break;
// end unusual code

case JIT_mod_r_r:
    result = op->result; DCheckBinop_x_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xr[i], yr[i]);
    stack[--istack] = result;
    break;

case JIT_mod_r_r1:
    result = op->result; DCheckBinop_x_y1(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xr[i], yr0);
    stack[--istack] = result;
    break;

case JIT_mod_r1_r:
    result = op->result; DCheckBinop_x1_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xr0, yr[i]);
    stack[--istack] = result;
    break;

case JIT_mod_r1_r1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, REALSXP, result);
    REAL(result)[0] = FMOD(XR[0], YR[0]);                stack[--istack] = result;
    break;

case JIT_mod_r_i:
    result = op->result; DCheckBinop_x_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xr[i], yi[i]);
    stack[--istack] = result;
    break;

case JIT_mod_r_i1:
    result = op->result; DCheckBinop_x_y1(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xr[i], yi0);
    stack[--istack] = result;
    break;

case JIT_mod_r1_i:
    result = op->result; DCheckBinop_x1_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xr0, yi[i]);
    stack[--istack] = result;
    break;

case JIT_mod_r1_i1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, INTSXP, result);
    REAL(result)[0] = FMOD(XR[0], YI[0]);
    stack[--istack] = result;
    break;

case JIT_mod_i_r:
    result = op->result; DCheckBinop_x_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xi[i], yr[i]);
    stack[--istack] = result;
    break;

case JIT_mod_i_r1:
    result = op->result; DCheckBinop_x_y1(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xi[i], yr0);
    stack[--istack] = result;
    break;

case JIT_mod_i1_r:
    result = op->result; DCheckBinop_x1_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FMOD(xi0, yr[i]);
    stack[--istack] = result;
    break;

case JIT_mod_i1_r1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, REALSXP, result);
    REAL(result)[0] = FMOD(XI[0], YR[0]);
    stack[--istack] = result;
    break;

case JIT_mod_i_i:
    result = op->result; DCheckBinop_x_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = IMOD(xi[i], yi[i], p);
    stack[--istack] = result;
    break;

case JIT_mod_i_i1:
    result = op->result; DCheckBinop_x_y1(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = IMOD(xi[i], yi0, p);
    stack[--istack] = result;
    break;

case JIT_mod_i1_i:
    result = op->result; DCheckBinop_x1_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = IMOD(xi0, yi[i], p);
    stack[--istack] = result;
    break;

case JIT_mod_i1_i1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, INTSXP, result);
    INTEGER(result)[0] = IMOD(XI[0], YI[0], p);
    stack[--istack] = result;
    break;

case JIT_idiv_r_r:
    result = op->result; DCheckBinop_x_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xr[i], yr[i]);
    stack[--istack] = result;
    break;

case JIT_idiv_r_r1:
    result = op->result; DCheckBinop_x_y1(REALSXP, REALSXP, result);
    ar = REAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xr[i], yr0);
    stack[--istack] = result;
    break;

case JIT_idiv_r1_r:
    result = op->result; DCheckBinop_x1_y(REALSXP, REALSXP, result);
    ar = REAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xr0, yr[i]);
    stack[--istack] = result;
    break;

case JIT_idiv_r1_r1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, REALSXP, result);
    REAL(result)[0] = FIDIV(XR[0], YR[0]);
    stack[--istack] = result;
    break;

case JIT_idiv_r_i:
    result = op->result; DCheckBinop_x_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xr[i], yi[i]);
    stack[--istack] = result;
    break;

case JIT_idiv_r_i1:
    result = op->result; DCheckBinop_x_y1(REALSXP, INTSXP, result);
    ar = REAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xr[i], yi0);
    stack[--istack] = result;
    break;

case JIT_idiv_r1_i:
    result = op->result; DCheckBinop_x1_y(REALSXP, INTSXP, result);
    ar = REAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xr0, yi[i]);
    stack[--istack] = result;
    break;

case JIT_idiv_r1_i1:
    result = op->result; DCheckBinop_x1_y1(REALSXP, INTSXP, result);
    REAL(result)[0] = FIDIV(XR[0], YI[0]);
    stack[--istack] = result;
    break;

case JIT_idiv_i_r:
    result = op->result; DCheckBinop_x_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xi[i], yr[i]);
    stack[--istack] = result;
    break;

case JIT_idiv_i_r1:
    result = op->result; DCheckBinop_x_y1(INTSXP, REALSXP, result);
    ar = REAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xi[i], yr0);
    stack[--istack] = result;
    break;

case JIT_idiv_i1_r:
    result = op->result; DCheckBinop_x1_y(INTSXP, REALSXP, result);
    ar = REAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ar[i] = FIDIV(xi0, yr[i]);
    stack[--istack] = result;
    break;

case JIT_idiv_i1_r1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, REALSXP, result);
    REAL(result)[0] = FIDIV(XI[0], YR[0]);
    stack[--istack] = result;
    break;

case JIT_idiv_i_i:
    result = op->result; DCheckBinop_x_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = IDIV(xi[i], yi[i], p);
    stack[--istack] = result;
    break;

case JIT_idiv_i_i1:
    result = op->result; DCheckBinop_x_y1(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = IDIV(xi[i], yi0, p);
    stack[--istack] = result;
    break;

case JIT_idiv_i1_i:
    result = op->result; DCheckBinop_x1_y(INTSXP, INTSXP, result);
    ai = INTEGER(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = IDIV(xi0, yi[i], p);
    stack[--istack] = result;
    break;

case JIT_idiv_i1_i1:
    result = op->result; DCheckBinop_x1_y1(INTSXP, INTSXP, result);
    INTEGER(result)[0] = IDIV(XI[0], YI[0], p);
    stack[--istack] = result;
    break;

case JIT_eq_r_r:
    result = op->result; DCheckRelop_x_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr[i] == yr[i]);
    stack[--istack] = result;
    break;

case JIT_eq_r_r1:
    result = op->result; DCheckRelop_x_y1(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] == yr0);
    stack[--istack] = result;
    break;

case JIT_eq_r1_r:
    result = op->result; DCheckRelop_x1_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 == YR[i]);
    stack[--istack] = result;
    break;

case JIT_eq_r1_r1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, REALSXP, result);
    LOGICAL(result)[0] = (XR[0] == YR[0]);
    stack[--istack] = result;
    break;

case JIT_eq_r_i:
    result = op->result; DCheckRelop_x_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] == YI[i]);
    stack[--istack] = result;
    break;

case JIT_eq_r_i1:
    result = op->result; DCheckRelop_x_y1(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] == yi0);
    stack[--istack] = result;
    break;

case JIT_eq_r1_i:
    result = op->result; DCheckRelop_x1_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 == YI[i]);
    stack[--istack] = result;
    break;

case JIT_eq_r1_i1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, INTSXP, result);
    LOGICAL(result)[0] = (XR[0] == YI[0]);
    stack[--istack] = result;
    break;

case JIT_eq_i_r:
    result = op->result; DCheckRelop_x_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] == YR[i]);
    stack[--istack] = result;
    break;

case JIT_eq_i_r1:
    result = op->result; DCheckRelop_x_y1(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] == yr0);
    stack[--istack] = result;
    break;

case JIT_eq_i1_r:
    result = op->result; DCheckRelop_x1_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 == YR[i]);
    stack[--istack] = result;
    break;

case JIT_eq_i1_r1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, REALSXP, result);
    LOGICAL(result)[0] = (XI[0] == YR[0]);
    stack[--istack] = result;
    break;

case JIT_eq_i_i:
    result = op->result; DCheckRelop_x_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] == YI[i]);
    stack[--istack] = result;
    break;

case JIT_eq_i_i1:
    result = op->result; DCheckRelop_x_y1(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] == yi0);
    stack[--istack] = result;
    break;

case JIT_eq_i1_i:
    result = op->result; DCheckRelop_x1_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 == YI[i]);
    stack[--istack] = result;
    break;

case JIT_eq_i1_i1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, INTSXP, result);
    LOGICAL(result)[0] = (XI[0] == YI[0]);
    stack[--istack] = result;
    break;

case JIT_ne_r_r:
    result = op->result; DCheckRelop_x_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr[i] != yr[i]);
    stack[--istack] = result;
    break;

case JIT_ne_r_r1:
    result = op->result; DCheckRelop_x_y1(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] != yr0);
    stack[--istack] = result;
    break;

case JIT_ne_r1_r:
    result = op->result; DCheckRelop_x1_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 != YR[i]);
    stack[--istack] = result;
    break;

case JIT_ne_r1_r1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, REALSXP, result);
    LOGICAL(result)[0] = (XR[0] != YR[0]);
    stack[--istack] = result;
    break;

case JIT_ne_r_i:
    result = op->result; DCheckRelop_x_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] != YI[i]);
    stack[--istack] = result;
    break;

case JIT_ne_r_i1:
    result = op->result; DCheckRelop_x_y1(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] != yi0);
    stack[--istack] = result;
    break;

case JIT_ne_r1_i:
    result = op->result; DCheckRelop_x1_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 != YI[i]);
    stack[--istack] = result;
    break;

case JIT_ne_r1_i1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, INTSXP, result);
    LOGICAL(result)[0] = (XR[0] != YI[0]);
    stack[--istack] = result;
    break;

case JIT_ne_i_r:
    result = op->result; DCheckRelop_x_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] != YR[i]);
    stack[--istack] = result;
    break;

case JIT_ne_i_r1:
    result = op->result; DCheckRelop_x_y1(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] != yr0);
    stack[--istack] = result;
    break;

case JIT_ne_i1_r:
    result = op->result; DCheckRelop_x1_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 != YR[i]);
    stack[--istack] = result;
    break;

case JIT_ne_i1_r1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, REALSXP, result);
    LOGICAL(result)[0] = (XI[0] != YR[0]);
    stack[--istack] = result;
    break;

case JIT_ne_i_i:
    result = op->result; DCheckRelop_x_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] != YI[i]);
    stack[--istack] = result;
    break;

case JIT_ne_i_i1:
    result = op->result; DCheckRelop_x_y1(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] != yi0);
    stack[--istack] = result;
    break;

case JIT_ne_i1_i:
    result = op->result; DCheckRelop_x1_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 != YI[i]);
    stack[--istack] = result;
    break;

case JIT_ne_i1_i1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, INTSXP, result);
    LOGICAL(result)[0] = (XI[0] != YI[0]);
    stack[--istack] = result;
    break;

case JIT_lt_r_r:
    result = op->result; DCheckRelop_x_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr[i] < yr[i]);
    stack[--istack] = result;
    break;

case JIT_lt_r_r1:
    result = op->result; DCheckRelop_x_y1(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] < yr0);
    stack[--istack] = result;
    break;

case JIT_lt_r1_r:
    result = op->result; DCheckRelop_x1_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 < YR[i]);
    stack[--istack] = result;
    break;

case JIT_lt_r1_r1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, REALSXP, result);
    LOGICAL(result)[0] = (XR[0] < YR[0]);
    stack[--istack] = result;
    break;

case JIT_lt_r_i:
    result = op->result; DCheckRelop_x_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] < YI[i]);
    stack[--istack] = result;
    break;

case JIT_lt_r_i1:
    result = op->result; DCheckRelop_x_y1(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] < yi0);
    stack[--istack] = result;
    break;

case JIT_lt_r1_i:
    result = op->result; DCheckRelop_x1_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 < YI[i]);
    stack[--istack] = result;
    break;

case JIT_lt_r1_i1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, INTSXP, result);
    LOGICAL(result)[0] = (XR[0] < YI[0]);
    stack[--istack] = result;
    break;

case JIT_lt_i_r:
    result = op->result; DCheckRelop_x_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] < YR[i]);
    stack[--istack] = result;
    break;

case JIT_lt_i_r1:
    result = op->result; DCheckRelop_x_y1(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] < yr0);
    stack[--istack] = result;
    break;

case JIT_lt_i1_r:
    result = op->result; DCheckRelop_x1_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 < YR[i]);
    stack[--istack] = result;
    break;

case JIT_lt_i1_r1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, REALSXP, result);
    LOGICAL(result)[0] = (XI[0] < YR[0]);
    stack[--istack] = result;
    break;

case JIT_lt_i_i:
    result = op->result; DCheckRelop_x_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] < YI[i]);
    stack[--istack] = result;
    break;

case JIT_lt_i_i1:
    result = op->result; DCheckRelop_x_y1(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] < yi0);
    stack[--istack] = result;
    break;

case JIT_lt_i1_i:
    result = op->result; DCheckRelop_x1_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 < YI[i]);
    stack[--istack] = result;
    break;

case JIT_lt_i1_i1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, INTSXP, result);
    LOGICAL(result)[0] = (XI[0] < YI[0]);
    stack[--istack] = result;
    break;

case JIT_le_r_r:
    result = op->result; DCheckRelop_x_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr[i] <= yr[i]);
    stack[--istack] = result;
    break;

case JIT_le_r_r1:
    result = op->result; DCheckRelop_x_y1(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] <= yr0);
    stack[--istack] = result;
    break;

case JIT_le_r1_r:
    result = op->result; DCheckRelop_x1_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 <= YR[i]);
    stack[--istack] = result;
    break;

case JIT_le_r1_r1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, REALSXP, result);
    LOGICAL(result)[0] = (XR[0] <= YR[0]);
    stack[--istack] = result;
    break;

case JIT_le_r_i:
    result = op->result; DCheckRelop_x_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] <= YI[i]);
    stack[--istack] = result;
    break;

case JIT_le_r_i1:
    result = op->result; DCheckRelop_x_y1(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] <= yi0);
    stack[--istack] = result;
    break;

case JIT_le_r1_i:
    result = op->result; DCheckRelop_x1_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 <= YI[i]);
    stack[--istack] = result;
    break;

case JIT_le_r1_i1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, INTSXP, result);
    LOGICAL(result)[0] = (XR[0] <= YI[0]);
    stack[--istack] = result;
    break;

case JIT_le_i_r:
    result = op->result; DCheckRelop_x_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] <= YR[i]);
    stack[--istack] = result;
    break;

case JIT_le_i_r1:
    result = op->result; DCheckRelop_x_y1(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] <= yr0);
    stack[--istack] = result;
    break;

case JIT_le_i1_r:
    result = op->result; DCheckRelop_x1_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 <= YR[i]);
    stack[--istack] = result;
    break;

case JIT_le_i1_r1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, REALSXP, result);
    LOGICAL(result)[0] = (XI[0] <= YR[0]);
    stack[--istack] = result;
    break;

case JIT_le_i_i:
    result = op->result; DCheckRelop_x_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] <= YI[i]);
    stack[--istack] = result;
    break;

case JIT_le_i_i1:
    result = op->result; DCheckRelop_x_y1(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] <= yi0);
    stack[--istack] = result;
    break;

case JIT_le_i1_i:
    result = op->result; DCheckRelop_x1_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 <= YI[i]);
    stack[--istack] = result;
    break;

case JIT_le_i1_i1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, INTSXP, result);
    LOGICAL(result)[0] = (XI[0] <= YI[0]);
    stack[--istack] = result;
    break;

case JIT_gt_r_r:
    result = op->result; DCheckRelop_x_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr[i] > yr[i]);
    stack[--istack] = result;
    break;

case JIT_gt_r_r1:
    result = op->result; DCheckRelop_x_y1(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] > yr0);
    stack[--istack] = result;
    break;

case JIT_gt_r1_r:
    result = op->result; DCheckRelop_x1_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 > YR[i]);
    stack[--istack] = result;
    break;

case JIT_gt_r1_r1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, REALSXP, result);
    LOGICAL(result)[0] = (XR[0] > YR[0]);
    stack[--istack] = result;
    break;

case JIT_gt_r_i:
    result = op->result; DCheckRelop_x_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] > YI[i]);
    stack[--istack] = result;
    break;

case JIT_gt_r_i1:
    result = op->result; DCheckRelop_x_y1(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] > yi0);
    stack[--istack] = result;
    break;

case JIT_gt_r1_i:
    result = op->result; DCheckRelop_x1_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 > YI[i]);
    stack[--istack] = result;
    break;

case JIT_gt_r1_i1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, INTSXP, result);
    LOGICAL(result)[0] = (XR[0] > YI[0]);
    stack[--istack] = result;
    break;

case JIT_gt_i_r:
    result = op->result; DCheckRelop_x_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] > YR[i]);
    stack[--istack] = result;
    break;

case JIT_gt_i_r1:
    result = op->result; DCheckRelop_x_y1(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] > yr0);
    stack[--istack] = result;
    break;

case JIT_gt_i1_r:
    result = op->result; DCheckRelop_x1_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 > YR[i]);
    stack[--istack] = result;
    break;

case JIT_gt_i1_r1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, REALSXP, result);
    LOGICAL(result)[0] = (XI[0] > YR[0]);
    stack[--istack] = result;
    break;

case JIT_gt_i_i:
    result = op->result; DCheckRelop_x_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] > YI[i]);
    stack[--istack] = result;
    break;

case JIT_gt_i_i1:
    result = op->result; DCheckRelop_x_y1(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] > yi0);
    stack[--istack] = result;
    break;

case JIT_gt_i1_i:
    result = op->result; DCheckRelop_x1_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 > YI[i]);
    stack[--istack] = result;
    break;

case JIT_gt_i1_i1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, INTSXP, result);
    LOGICAL(result)[0] = (XI[0] > YI[0]);
    stack[--istack] = result;
    break;

case JIT_ge_r_r:
    result = op->result; DCheckRelop_x_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr[i] >= yr[i]);
    stack[--istack] = result;
    break;

case JIT_ge_r_r1:
    result = op->result; DCheckRelop_x_y1(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr = XR; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] >= yr0);
    stack[--istack] = result;
    break;

case JIT_ge_r1_r:
    result = op->result; DCheckRelop_x1_y(REALSXP, REALSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 >= YR[i]);
    stack[--istack] = result;
    break;

case JIT_ge_r1_r1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, REALSXP, result);
    LOGICAL(result)[0] = (XR[0] >= YR[0]);
    stack[--istack] = result;
    break;

case JIT_ge_r_i:
    result = op->result; DCheckRelop_x_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] >= YI[i]);
    stack[--istack] = result;
    break;

case JIT_ge_r_i1:
    result = op->result; DCheckRelop_x_y1(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr = XR; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XR[i] >= yi0);
    stack[--istack] = result;
    break;

case JIT_ge_r1_i:
    result = op->result; DCheckRelop_x1_y(REALSXP, INTSXP, result);
    ai = LOGICAL(result); xr0 = XR[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xr0 >= YI[i]);
    stack[--istack] = result;
    break;

case JIT_ge_r1_i1:
    result = op->result; DCheckRelop_x1_y1(REALSXP, INTSXP, result);
    LOGICAL(result)[0] = (XR[0] >= YI[0]);
    stack[--istack] = result;
    break;

case JIT_ge_i_r:
    result = op->result; DCheckRelop_x_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] >= YR[i]);
    stack[--istack] = result;
    break;

case JIT_ge_i_r1:
    result = op->result; DCheckRelop_x_y1(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi = XI; yr0 = YR[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] >= yr0);
    stack[--istack] = result;
    break;

case JIT_ge_i1_r:
    result = op->result; DCheckRelop_x1_y(INTSXP, REALSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yr = YR; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 >= YR[i]);
    stack[--istack] = result;
    break;

case JIT_ge_i1_r1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, REALSXP, result);
    LOGICAL(result)[0] = (XI[0] >= YR[0]);
    stack[--istack] = result;
    break;

case JIT_ge_i_i:
    result = op->result; DCheckRelop_x_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] >= YI[i]);
    stack[--istack] = result;
    break;

case JIT_ge_i_i1:
    result = op->result; DCheckRelop_x_y1(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi = XI; yi0 = YI[0]; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (XI[i] >= yi0);
    stack[--istack] = result;
    break;

case JIT_ge_i1_i:
    result = op->result; DCheckRelop_x1_y(INTSXP, INTSXP, result);
    ai = LOGICAL(result); xi0 = XI[0]; yi = YI; n = LENGTH(result);
    for (i = 0; i < n; i++) ai[i] = (xi0 >= YI[i]);
    stack[--istack] = result;
    break;

case JIT_ge_i1_i1:
    result = op->result; DCheckRelop_x1_y1(INTSXP, INTSXP, result);
    LOGICAL(result)[0] = (XI[0] >= YI[0]);
    stack[--istack] = result;
    break;

default:
    REprintf("Internal error in evalJit: bad opcode %d %s\n",
             op->opcode, opcodeName(op->opcode));
    assertFail(__FILE__, __LINE__, "see message above");
    break;
